/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.CVLFunction;
import com.certora.evmverifier.cvl.GhostDecl;
import com.certora.evmverifier.cvl.Hook;
import com.certora.evmverifier.cvl.Invariant;
import com.certora.evmverifier.cvl.MacroDefinition;
import com.certora.evmverifier.cvl.OverrideDeclaration;
import com.certora.evmverifier.cvl.Rule;
import com.certora.evmverifier.cvl.UninterpretedSortDecl;
import com.certora.evmverifier.cvl.UseDeclaration;
import java.util.ArrayList;
import java.util.List;
import kotlinizable.Kotlinizer;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLGhostDeclaration;
import spec.cvlast.CVLHook;
import spec.cvlast.CVLInvariant;
import spec.cvlast.IRule;
import spec.cvlast.OverrideDeclarations;
import spec.cvlast.SortDeclaration;
import spec.cvlast.UseDeclarations;

public class Definitions {
    private final ArrayList<Rule> rules = new ArrayList();
    private final ArrayList<CVLFunction> subs = new ArrayList();
    private final ArrayList<Invariant> invs = new ArrayList();
    private final ArrayList<UninterpretedSortDecl> sorts = new ArrayList();
    private final ArrayList<GhostDecl> ghosts = new ArrayList();
    private final ArrayList<MacroDefinition> macros = new ArrayList();
    private final ArrayList<Hook> hooks = new ArrayList();
    private final ArrayList<UseDeclaration.ImportedRule> useImportedRuleDeclarations = new ArrayList();
    private final ArrayList<UseDeclaration.ImportedInvariant> useImportedInvariantDeclarations = new ArrayList();
    private final ArrayList<UseDeclaration.BuiltInRule> useBuiltInRuleDeclarations = new ArrayList();
    private final ArrayList<OverrideDeclaration.MacroDefinition> overrideDefinitionDeclarations = new ArrayList();
    private final ArrayList<OverrideDeclaration.CVLFunction> overrideFunctionDeclarations = new ArrayList();

    public void add(Rule rule) {
        this.rules.add(rule);
    }

    public List<IRule> kotlinizeRules() {
        return Kotlinizer.kotlinizeList(this.rules);
    }

    public void add(CVLFunction sub) {
        this.subs.add(sub);
    }

    public List<spec.cvlast.CVLFunction> kotlinizeSubs() {
        return Kotlinizer.kotlinizeList(this.subs);
    }

    public void add(Invariant inv) {
        this.invs.add(inv);
    }

    public List<CVLInvariant> kotlinizeInvariants() {
        return Kotlinizer.kotlinizeList(this.invs);
    }

    public void add(UninterpretedSortDecl sort) {
        this.sorts.add(sort);
    }

    public List<SortDeclaration> kotlinizeSorts() {
        return Kotlinizer.kotlinizeList(this.sorts);
    }

    public void add(GhostDecl ghost2) {
        this.ghosts.add(ghost2);
    }

    public List<CVLGhostDeclaration> kotlinizeGhostDecls() {
        return Kotlinizer.kotlinizeList(this.ghosts);
    }

    public void add(MacroDefinition macro) {
        this.macros.add(macro);
    }

    public List<CVLDefinition> kotlinizeMacroDefinitions() {
        return Kotlinizer.kotlinizeList(this.macros);
    }

    public void add(Hook hook) {
        this.hooks.add(hook);
    }

    public List<CVLHook> kotlinizeHooks() {
        return Kotlinizer.kotlinizeList(this.hooks);
    }

    public void add(UseDeclaration useDeclaration) {
        if (useDeclaration instanceof UseDeclaration.ImportedRule) {
            this.useImportedRuleDeclarations.add((UseDeclaration.ImportedRule)useDeclaration);
        } else if (useDeclaration instanceof UseDeclaration.ImportedInvariant) {
            this.useImportedInvariantDeclarations.add((UseDeclaration.ImportedInvariant)useDeclaration);
        } else if (useDeclaration instanceof UseDeclaration.BuiltInRule) {
            this.useBuiltInRuleDeclarations.add((UseDeclaration.BuiltInRule)useDeclaration);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot handle the use declaration %s", useDeclaration));
        }
    }

    public UseDeclarations kotlinizeUseDeclarations() {
        return new UseDeclarations(Kotlinizer.kotlinizeList(this.useImportedRuleDeclarations), Kotlinizer.kotlinizeList(this.useImportedInvariantDeclarations), Kotlinizer.kotlinizeList(this.useBuiltInRuleDeclarations));
    }

    public void add(OverrideDeclaration overrideDeclaration) {
        if (overrideDeclaration instanceof OverrideDeclaration.MacroDefinition) {
            this.overrideDefinitionDeclarations.add((OverrideDeclaration.MacroDefinition)overrideDeclaration);
        } else if (overrideDeclaration instanceof OverrideDeclaration.CVLFunction) {
            this.overrideFunctionDeclarations.add((OverrideDeclaration.CVLFunction)overrideDeclaration);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot handle the override declaration %s", overrideDeclaration));
        }
    }

    public OverrideDeclarations kotlinizeOverrideDeclarations() {
        return new OverrideDeclarations(Kotlinizer.kotlinizeList(this.overrideDefinitionDeclarations), Kotlinizer.kotlinizeList(this.overrideFunctionDeclarations));
    }
}

