# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nonebot_plugin_searchbiliinfo']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.3,<4.0.0',
 'nonebot-adapter-onebot>=2.1.3,<3.0.0',
 'nonebot-plugin-htmlrender>=0.2.0.1,<0.3.0.0',
 'nonebot2>=2.0.0b5,<3.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-searchbiliinfo',
    'version': '1.4.3',
    'description': 'A plugin for nonebot2. Query Bilibili user information（一个Nonebot2的插件，b站用户信息查询插件【粉丝、舰团信息；直播收益数据；直播观看信息；关键词搜昵称、UID等】）',
    'long_description': '<div align="center">\n  <a href="https://v2.nonebot.dev/store"><img src="https://github.com/A-kirami/nonebot-plugin-template/blob/resources/nbp_logo.png" width="180" height="180" alt="NoneBotPluginLogo"></a>\n  <br>\n  <p><img src="https://github.com/A-kirami/nonebot-plugin-template/blob/resources/NoneBotPlugin.svg" width="240" alt="NoneBotPluginText"></p>\n</div>\n\n<div align="center">\n\n# nonebot_plugin_searchBiliInfo\n  \n_✨ NoneBot b站用户信息查询插件 ✨_\n  \n<a href="https://github.com/Ikaros-521/nonebot_plugin_searchBiliInfo/stargazers">\n    <img alt="GitHub stars" src="https://img.shields.io/github/stars/Ikaros-521/nonebot_plugin_searchBiliInfo?color=%09%2300BFFF&style=flat-square">\n</a>\n<a href="https://github.com/Ikaros-521/nonebot_plugin_searchBiliInfo/issues">\n    <img alt="GitHub issues" src="https://img.shields.io/github/issues/Ikaros-521/nonebot_plugin_searchBiliInfo?color=Emerald%20green&style=flat-square">\n</a>\n<a href="https://github.com/Ikaros-521/nonebot_plugin_searchBiliInfo/network">\n    <img alt="GitHub forks" src="https://img.shields.io/github/forks/Ikaros-521/nonebot_plugin_searchBiliInfo?color=%2300BFFF&style=flat-square">\n</a>\n<a href="./LICENSE">\n    <img src="https://img.shields.io/github/license/Ikaros-521/nonebot_plugin_searchBiliInfo.svg" alt="license">\n</a>\n<a href="https://pypi.python.org/pypi/nonebot_plugin_searchBiliInfo">\n    <img src="https://img.shields.io/pypi/v/nonebot_plugin_searchBiliInfo.svg" alt="pypi">\n</a>\n<a href="https://www.python.org">\n    <img src="https://img.shields.io/badge/python-3.8+-blue.svg" alt="python">\n</a>\n\n</div>\n\n适用于nonebot2 v11的b站用户信息查询插件【粉丝、舰团信息；直播收益数据；直播观看信息；关键词搜昵称、UID等；主播营收榜单】  \n（ps：微调源码可以兼容其他版本）   \n调用的相关API源自b站官方接口、danmakus.com和vtbs.fun\n\n## 🔧 开发环境\nNonebot2：2.0.0b5  \npython：3.8.13  \n操作系统：Windows10（CentOS7下正常运行，Linux兼容性问题不大）  \n编辑器：pycharm  \n\n## 💿 安装\n环境依赖`aiohttp`和`nonebot_plugin_htmlrender`库   \n部分功能需要获取自己的cookie，配置env后才能正常使用！  \n\n### 1. nb-cli安装（推荐）\n在你bot工程的文件夹下，运行cmd（运行路径要对啊），执行nb命令安装插件，插件配置会自动添加至配置文件  \n```\nnb plugin install nonebot_plugin_searchBiliInfo\n```\n\n### 2. 本地安装\n先安装下 `aiohttp` 和 `htmlrender`  \n```\npip install aiohttp\npip install nonebot_plugin_htmlrender\n```\n将项目clone到你的机器人插件下的对应插件目录内（一般为机器人文件夹下的`src/plugins`），然后把`nonebot_plugin_searchBiliInfo`文件夹里的内容拷贝至上一级目录即可。  \nclone命令参考（得先装`git`，懂的都懂）：\n```\ngit clone https://github.com/Ikaros-521/nonebot_plugin_searchBiliInfo.git\n``` \n也可以直接下载压缩包到插件目录解压，然后同样提取`nonebot_plugin_searchBiliInfo`至上一级目录。  \n目录结构： ```你的bot/src/plugins/nonebot_plugin_searchBiliInfo/__init__.py```  \n\n\n### 3. pip安装\n```\npip install nonebot_plugin_searchBiliInfo\n```  \n打开 nonebot2 项目的 ```bot.py``` 文件, 在其中写入  \n```nonebot.load_plugin(\'nonebot_plugin_searchBiliInfo\')```  \n当然，如果是默认nb-cli创建的nonebot2的话，在bot路径```pyproject.toml```的```[tool.nonebot]```的```plugins```中添加```nonebot_plugin_searchBiliInfo```即可  \npyproject.toml配置例如：  \n``` \n[tool.nonebot]\nplugin_dirs = ["src/plugins"]\nplugins = ["nonebot_plugin_searchBiliInfo"]\n``` \n\n### 更新版本\n```\nnb plugin update nonebot_plugin_searchBiliInfo\n```\n\n## 🔧 配置\n\n### cookie获取方式\n浏览器进入b站官网并登录: `https://www.bilibili.com/`  \nedge（或其他浏览器）按f12（或鼠标右键“检查” “开发者工具”等）, 然后点击右上角那个">>"符号, 进入"网络"  \n再按ctrl+r（或f5）刷新元素  \n随便点击一个请求, 在“请求标头”里面找到cookie（没有就换一个）  \ncookie冒号后面的就是cookie，复制一下, 可以把ta添加到env里  \n如果不想放太多cookie信息，只需要buvid3字段即可。  \n\n### env配置\n```\n# 在你的env文件中添加如下配置（我的是.env.prod） 仅需要buvid3字段即可\nsearchBiliInfo_cookie="buvid3=XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXXXXXXXinfoc;"\n```\n|       配置项        | 必填 | 默认值  |                      说明                      |\n|:----------------:|:----:|:----:|:----------------------------:|\n| `searchBiliInfo_cookie` | 否 | `""` | b站cookie，仅需要buvid3字段即可 |\n\n\n## 🎉 功能\n通过uid 或 设定好的短语 或 b站接口搜索查询指定b站用户的粉丝、舰团信息；直播收益数据；直播观看信息；关键词搜昵称、UID等信息；主播营收榜单。\n\n## 👉 命令\n\n### /查\n命令结构：```/查 (uid:或UID:或：或:)+用户uid或昵称关键词```  \n例如：```/查 uid:3709626``` 或 ```/查 :3709626``` 或 ```/查 bishi```  \nbot返回内容：  \n![](docs/search.png)\n\n### /查直播\n命令结构：```/查直播 (uid:或UID:或：或:)+用户uid或昵称关键词 场次数（默认不写为全部）```  \n例如：```/查直播 UID:3709626 1``` 或 ```/查直播 bishi```  \nbot返回内容（图片）：  \n![](docs/live_info.png)\n\n### /查舰团\n命令结构：```/查舰团 (uid:或UID:或：或:)+用户uid或昵称关键词```  \n例如：```/查舰团 ：3709626``` 或 ```/查舰团 bishi```  \nbot返回内容(图片)：  \n![](docs/guard.png)\n\n### /查昵称\n命令结构：```/查昵称 昵称关键词```  \n例如：```/查昵称 伊卡洛斯```\nbot返回内容(图片)：  \n![](docs/search_name.png)\n\n### /查收益\n命令结构：```/查收益 (uid:或UID:或：或:)+用户uid或昵称关键词 收益类型(默认1: 礼物，2: 上舰，3: SC) 倒叙第n场(从0开始)```  \n例如：```/查收益 :3709626 礼物 1``` 或 ```/查收益 bishi 2 0```  \nbot返回内容(图片)：  \n![](docs/income.png)\n\n### /查观看\n命令结构：```/查观看 (uid:或UID:或：或:)+用户uid或昵称关键词```  \n例如：```/查观看 UID:666666``` 或 ```/查观看 bishi```  \nbot返回内容(图片)：  \n![](docs/watch.png)\n\n### /查弹幕\n命令结构：```/查弹幕 (uid:或UID:或：或:)+用户uid或昵称关键词 查询的主播昵称关键词或(uid:或UID:或：或:)+ 页数(可不填，默认0) 条数(可不填，默认3)```  \n例如：```/查弹幕 uid:3709626 Love丶伊卡洛斯 1 1``` 或 ```/查弹幕 uid:3709626 Love丶伊卡洛斯 1```   \nbot返回内容(图片)：  \n![](docs/danmu.png)\n\n### /查弹幕2\n命令结构：```/查弹幕2 (uid:或UID:或：或:)+用户uid或昵称关键词 页数(可不填，默认0) 条数(可不填，默认3)```  \n例如：```/查弹幕2 uid:3709626 2 2``` 或 ```/查弹幕2 uid:3709626 2```   \nbot返回内容(图片)：  \n![](docs/danmu2.png)\n\n### /营收\n命令结构：```/营收 日/周/月榜 人数（不填默认100）```  \n例如：```/营收 日榜 3``` 或 ```/营收 月榜```  \nbot返回内容(图片)：  \n![](docs/revenue.png)\n\n### vtb网站  （命令前缀自行添加）\n命令结构：```/vtb网站``` 或 ```/vtb资源```  \n例如：```/vtb网站``` 或 ```/vtb资源```  \nbot返回内容(图片)：  \n![](docs/website.png)\n\n## ⚙ 拓展\n启用关键词搜索，需要在env中配置自己的cookie。\n\n命令修改：修改data.py，在文件头部追加你需要定义的用户的json串，注意json格式！！！\n\n返回内容格式修改对应的msg、out_str变量的内容  \n\n## 📝 更新日志\n\n<details>\n<summary>展开/收起</summary>\n\n### 0.0.1\n\n- 插件初次发布\n\n### 0.1.0\n\n- 更新基于vtbs.moe的主播数据，添加关键词搜索功能\n\n### 1.0.0\n\n新增以下功能（其实是LX_Bot的相关命令融进来了）\n- /查 昵称关键词\n- /查直播 昵称关键词 场次数\n- /查舰团 昵称关键词\n- /查昵称 昵称关键词\n- /查收益 收益类型(默认1: 礼物，2: 上舰，3: SC) 用户uid或昵称关键词 倒叙第n场(从0开始)\n- /查成分 观看 昵称关键词\n- /查成分 弹幕 查询的目标人 查询的主播 页数 条数\n\n### 1.0.4\n\n优化针对uid解析方式\n\n### 1.0.5\n\n修改cookie配置从env获取，方便用户配置\n\n### 1.0.6\n\n修复 /查成分 弹幕 数据解析bug；\n优化整体代码实现；\n\n### 1.1.0\n新增功能\n- /营收 日/周/月榜 人数（不填默认100）\n\n### 1.2.0\n弃用requests库，改为aiohttp  \n\n### 1.2.1\n修复查命令aiohttp适配性bug  \n\n### 1.3.0\n修改 查成分 弹幕 和 查成分 观看 命令为 查弹幕 和 查观看。  \n优化命令解析实现。  \n修复查弹幕数据解析bug。  \n\n### 1.3.1\n新增 /查弹幕2 命令。  \n修复查弹幕数据解析bug。 \n图片UI优化。  \n\n### 1.3.2\n优化 /查弹幕2 命令，增加主播名。  \n\n### 1.3.3\n修复 /查观看 因为数据源有同一用户名不同uid的情况导致的越界bug。  \n\n### 1.3.4\n优化异常报错的处理。  \n优化UI设计和部分功能。  \n\n### 1.3.5\n新增`/查收益 xx 舰长`和`uid：`的匹配。（但是舰长仍然是所有上舰数据）    \n\n### 1.3.6\n优化API挂彩时候的异常捕获处理。  \n\n### 1.3.7\n插件补充元信息。 \n\n### 1.3.8\n新增`vtb网站` 或 `vtb资源` 命令（命令前缀自行添加） \n\n## 1.3.9\n补充2个VTB资源站点  \n\n## 1.3.10\n适配vtbs.fun的营收接口变动  \n\n## 1.4.0\n修改on_keyword为on_command，从而适配自定义的命令前缀  \n\n## 1.4.1\n修改danmakus.com到新域名danmakus.com，接口也同步替换了。  \n\n## 1.4.2\n新增markdown的特殊字符过滤和文本超长换行。  \nps：vtbs.fun挂了，`营收`功能暂时无法使用。\n\n## 1.4.3\nvtbs.fun活了，加了ssl，已兼容。  \n\n</details>\n\n## 致谢\n- [nonebot-plugin-htmlrender](https://github.com/kexue-z/nonebot-plugin-htmlrender) - 图片合成的好手\n- [danmakus.com](https://danmakus.com/) - b站主播、用户弹幕直播信息等来源（开放API接口很赞！）\n- [vtbs.moe](https://vtbs.moe) - VTB本地数据信息来源（还有数据提供，TQL）  \n\n## 项目打包上传至pypi\n\n官网：https://pypi.org，注册账号，在系统用户根目录下创建`.pypirc`，配置  \n``` \n[distutils] \nindex-servers=pypi \n \n[pypi] repository = https://upload.pypi.org/legacy/ \nusername = 用户名 \npassword = 密码\n```\n\n### poetry\n\n```\n# 参考 https://www.freesion.com/article/58051228882/\n\n# 1、安装poetry\npip install poetry\n\n# 2、初始化配置文件（根据提示填写）\npoetry init\n\n# 3、微调配置文件pyproject.toml\n\n# 4、运行 poetry install, 可生成 “poetry.lock” 文件（可跳过）\npoetry install\n\n# 5、编译，生成dist\npoetry build\n\n# 6、发布\npoetry publish\n\n```\n\n### twine\n\n```\n# 参考 https://www.cnblogs.com/danhuai/p/14915042.html\n#创建setup.py文件 填写相关信息\n\n# 1、可以先升级打包工具\npip install --upgrade setuptools wheel twine\n\n# 2、打包\npython setup.py sdist bdist_wheel\n\n# 3、可以先检查一下包\ntwine check dist/*\n\n# 4、上传包到pypi（需输入用户名、密码）\ntwine upload dist/*\n```\n',
    'author': 'Ikaros',
    'author_email': '327209194@qq.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Ikaros-521/nonebot_plugin_searchBiliInfo',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
