# Knowledge Repo

[![PyPI](https://img.shields.io/pypi/status/knowledge-repo.svg)]()
[![license](https://img.shields.io/github/license/airbnb/knowledge-repo.svg)]()
[![PyPI version](https://badge.fury.io/py/knowledge-repo.svg)](https://badge.fury.io/py/knowledge-repo)
[![Python](https://img.shields.io/pypi/pyversions/knowledge-repo.svg?maxAge=2592000)](https://pypi.python.org/pypi/knowledge-repo)
[![Build Status](https://github.com/airbnb/knowledge-repo/actions/workflows/main.yml/badge.svg)](https://github.com/airbnb/knowledge-repo/actions)
[![PyPI downloads](https://static.pepy.tech/personalized-badge/knowledge-repo?period=total&units=international_system&left_color=black&right_color=brightgreen&left_text=total%20downloads)](https://pepy.tech/project/knowledge-repo)
[![PyPI monthly downloads](https://static.pepy.tech/personalized-badge/knowledge-repo?period=month&units=international_system&left_color=black&right_color=brightgreen&left_text=downloads/month)](https://pepy.tech/project/knowledge-repo)

## About the Knowledge Repo
The Knowledge Repo project aims to streamline the sharing of knowledge among data scientists and other technical roles 
by utilizing data formats and tools that are commonly used in these professions. Our platform offers various options for 
storing and managing "knowledge posts", with a focus on utilizing notebooks (such as R Markdown and Jupyter/IPython 
Notebook) to better promote reproducible research.

## Content Submission Options
### 1. Github Integration: 
Easily submit your posts in markdown format directly through Github. Our platform will automatically 
detect and publish your new content in a timely manner.

### 2. Built-in Editor: 
Utilize our user-friendly editor to compose and upload your posts in various formats including Jupyter Notebook, R 
markdown, and Google document link. We securely store your content on our internal storage for easy access and management. 
Users can make updates, delete, share, and add comments to their posts after publishing.

## Getting Started
- #### [**Installation Instruction**](http://knowledge-repo.readthedocs.io)
- #### [**Hosted Live Version**](https://www.knowledge-repo.com)
- #### [**Source**](https://github.com/airbnb/knowledge-repo)
For more information about the motivation and inspiration behind this project, we encourage you to read our 
[Medium Post](https://medium.com/airbnb-engineering/scaling-knowledge-at-airbnb-875d73eff091).

## Contact
- [**Bug reports**](https://github.com/airbnb/knowledge-repo/issues)
- **Ask us questions**
  - [**Knowlegde-repo Slack**](https://join.slack.com/t/knowledgerepogroup/shared_invite/zt-1oxlql877-R_WUl5qGWVOt3EMs9iRKZQ)
  - **Email**: airbnb.knowledge.repo@gmail.com

## Screenshots

| Name                                              | Screenshot(s)                                                                                                                 |
|---------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------|
| [Feed](https://www.knowledge-repo.com/feed)       | <img src="docs/images/feed.png" width="600" />                                                                                |
| [Example Post](https://www.knowledge-repo.com/post/example%2Fexample_md.kp)       | <img src="https://user-images.githubusercontent.com/8813413/83345203-48b06c00-a2c5-11ea-8edb-18e7f8f157ce.png" width="600" /> |
| [New Post](https://www.knowledge-repo.com/create)       | <img src="https://user-images.githubusercontent.com/8813413/83345202-4817d580-a2c5-11ea-9f75-964980c4c3c3.png" width="600" /> |
| [Post Form](https://www.knowledge-repo.com/edit?proxy=true)       | <img src="https://user-images.githubusercontent.com/8813413/83345204-49490280-a2c5-11ea-97e3-248192b01526.png" width="600" /> |
| [Stats](https://www.knowledge-repo.com/stats)       | <img src="docs/images/stats1.png" width="295" />  <img src="docs/images/stats2.png" width="295" />                            |
  