# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'BaremetalServerIp',
    'BaremetalServerOption',
    'BaremetalServerPrivateNetwork',
    'CockpitEndpoint',
    'CockpitTokenScopes',
    'DomainRecordGeoIp',
    'DomainRecordGeoIpMatch',
    'DomainRecordHttpService',
    'DomainRecordView',
    'DomainRecordWeighted',
    'IamPolicyRule',
    'InstanceImageAdditionalVolume',
    'InstanceSecurityGroupInboundRule',
    'InstanceSecurityGroupOutboundRule',
    'InstanceSecurityGroupRulesInboundRule',
    'InstanceSecurityGroupRulesOutboundRule',
    'InstanceServerPrivateNetwork',
    'InstanceServerRootVolume',
    'InstanceSnapshotImport',
    'IotDeviceCertificate',
    'IotDeviceMessageFilters',
    'IotDeviceMessageFiltersPublish',
    'IotDeviceMessageFiltersSubscribe',
    'IotRouteDatabase',
    'IotRouteRest',
    'IotRouteS3',
    'K8sClusterAutoUpgrade',
    'K8sClusterAutoscalerConfig',
    'K8sClusterKubeconfig',
    'K8sClusterOpenIdConnectConfig',
    'K8sPoolNode',
    'K8sPoolUpgradePolicy',
    'LbBackendHealthCheckHttp',
    'LbBackendHealthCheckHttps',
    'LbBackendHealthCheckTcp',
    'LbCertificateCustomCertificate',
    'LbCertificateLetsencrypt',
    'LbFrontendAcl',
    'LbFrontendAclAction',
    'LbFrontendAclMatch',
    'LbPrivateNetwork',
    'MnqCredentialNatsCredentials',
    'MnqCredentialSqsSnsCredentials',
    'MnqCredentialSqsSnsCredentialsPermissions',
    'ObjectBucketAclAccessControlPolicy',
    'ObjectBucketAclAccessControlPolicyGrant',
    'ObjectBucketAclAccessControlPolicyGrantGrantee',
    'ObjectBucketAclAccessControlPolicyOwner',
    'ObjectBucketCorsRule',
    'ObjectBucketLifecycleRule',
    'ObjectBucketLifecycleRuleExpiration',
    'ObjectBucketLifecycleRuleTransition',
    'ObjectBucketLockConfigurationRule',
    'ObjectBucketLockConfigurationRuleDefaultRetention',
    'ObjectBucketVersioning',
    'ObjectBucketWebsiteConfigurationErrorDocument',
    'ObjectBucketWebsiteConfigurationIndexDocument',
    'RdbAclAclRule',
    'RdbInstanceLoadBalancer',
    'RdbInstancePrivateNetwork',
    'RdbInstanceReadReplica',
    'RdbReadReplicaDirectAccess',
    'RdbReadReplicaPrivateNetwork',
    'RedisClusterAcl',
    'RedisClusterPrivateNetwork',
    'RedisClusterPublicNetwork',
    'GetBaremetalOfferCpusResult',
    'GetBaremetalOfferDiskResult',
    'GetBaremetalOfferMemoryResult',
    'GetBaremetalServerIpResult',
    'GetBaremetalServerOptionResult',
    'GetBaremetalServerPrivateNetworkResult',
    'GetCockpitEndpointResult',
    'GetDomainRecordGeoIpResult',
    'GetDomainRecordGeoIpMatchResult',
    'GetDomainRecordHttpServiceResult',
    'GetDomainRecordViewResult',
    'GetDomainRecordWeightedResult',
    'GetInstanceSecurityGroupInboundRuleResult',
    'GetInstanceSecurityGroupOutboundRuleResult',
    'GetInstanceServerPrivateNetworkResult',
    'GetInstanceServerRootVolumeResult',
    'GetInstanceServersServerResult',
    'GetInstanceSnapshotImportResult',
    'GetIotDeviceCertificateResult',
    'GetIotDeviceMessageFilterResult',
    'GetIotDeviceMessageFilterPublishResult',
    'GetIotDeviceMessageFilterSubscribeResult',
    'GetK8sClusterAutoUpgradeResult',
    'GetK8sClusterAutoscalerConfigResult',
    'GetK8sClusterKubeconfigResult',
    'GetK8sClusterOpenIdConnectConfigResult',
    'GetK8sPoolNodeResult',
    'GetK8sPoolUpgradePolicyResult',
    'GetLbAclsAclResult',
    'GetLbAclsAclActionResult',
    'GetLbAclsAclMatchResult',
    'GetLbBackendHealthCheckHttpResult',
    'GetLbBackendHealthCheckTcpResult',
    'GetLbBackendsBackendResult',
    'GetLbBackendsBackendHealthCheckHttpResult',
    'GetLbBackendsBackendHealthCheckTcpResult',
    'GetLbCertificateCustomCertificateResult',
    'GetLbCertificateLetsencryptResult',
    'GetLbFrontendAclResult',
    'GetLbFrontendAclActionResult',
    'GetLbFrontendAclMatchResult',
    'GetLbFrontendsFrontendResult',
    'GetLbIpsIpResult',
    'GetLbPrivateNetworkResult',
    'GetLbRoutesRouteResult',
    'GetLbsLbResult',
    'GetLbsLbInstanceResult',
    'GetLbsLbIpResult',
    'GetObjectBucketCorsRuleResult',
    'GetObjectBucketLifecycleRuleResult',
    'GetObjectBucketLifecycleRuleExpirationResult',
    'GetObjectBucketLifecycleRuleTransitionResult',
    'GetObjectBucketVersioningResult',
    'GetRdbAclAclRuleResult',
    'GetRdbInstanceLoadBalancerResult',
    'GetRdbInstancePrivateNetworkResult',
    'GetRdbInstanceReadReplicaResult',
    'GetRedisClusterAclResult',
    'GetRedisClusterPrivateNetworkResult',
    'GetRedisClusterPublicNetworkResult',
    'GetWebHostOfferProductResult',
]

@pulumi.output_type
class BaremetalServerIp(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 id: Optional[str] = None,
                 reverse: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str address: The address of the IP.
        :param str id: The id of the private network to attach.
        :param str reverse: The reverse of the IP.
        :param str version: The type of the IP.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The address of the IP.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the private network to attach.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> Optional[str]:
        """
        The reverse of the IP.
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The type of the IP.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class BaremetalServerOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BaremetalServerOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BaremetalServerOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BaremetalServerOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 expires_at: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str id: The id of the private network to attach.
        :param str expires_at: The auto expiration date for compatible options
        :param str name: The name of the server.
        """
        pulumi.set(__self__, "id", id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the private network to attach.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[str]:
        """
        The auto expiration date for compatible options
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BaremetalServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BaremetalServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BaremetalServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BaremetalServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 created_at: Optional[str] = None,
                 status: Optional[str] = None,
                 updated_at: Optional[str] = None,
                 vlan: Optional[int] = None):
        """
        :param str id: The id of the private network to attach.
        :param str created_at: The date and time of the creation of the private network.
        :param str status: The private network status.
        :param str updated_at: The date and time of the last update of the private network.
        :param int vlan: The VLAN ID associated to the private network.
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the private network to attach.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time of the creation of the private network.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The private network status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The date and time of the last update of the private network.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def vlan(self) -> Optional[int]:
        """
        The VLAN ID associated to the private network.
        """
        return pulumi.get(self, "vlan")


@pulumi.output_type
class CockpitEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertmanagerUrl":
            suggest = "alertmanager_url"
        elif key == "grafanaUrl":
            suggest = "grafana_url"
        elif key == "logsUrl":
            suggest = "logs_url"
        elif key == "metricsUrl":
            suggest = "metrics_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CockpitEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CockpitEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CockpitEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alertmanager_url: Optional[str] = None,
                 grafana_url: Optional[str] = None,
                 logs_url: Optional[str] = None,
                 metrics_url: Optional[str] = None):
        """
        :param str alertmanager_url: The alertmanager URL
        :param str grafana_url: The grafana URL
        :param str logs_url: The logs URL
        :param str metrics_url: The metrics URL
        """
        if alertmanager_url is not None:
            pulumi.set(__self__, "alertmanager_url", alertmanager_url)
        if grafana_url is not None:
            pulumi.set(__self__, "grafana_url", grafana_url)
        if logs_url is not None:
            pulumi.set(__self__, "logs_url", logs_url)
        if metrics_url is not None:
            pulumi.set(__self__, "metrics_url", metrics_url)

    @property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> Optional[str]:
        """
        The alertmanager URL
        """
        return pulumi.get(self, "alertmanager_url")

    @property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> Optional[str]:
        """
        The grafana URL
        """
        return pulumi.get(self, "grafana_url")

    @property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> Optional[str]:
        """
        The logs URL
        """
        return pulumi.get(self, "logs_url")

    @property
    @pulumi.getter(name="metricsUrl")
    def metrics_url(self) -> Optional[str]:
        """
        The metrics URL
        """
        return pulumi.get(self, "metrics_url")


@pulumi.output_type
class CockpitTokenScopes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryLogs":
            suggest = "query_logs"
        elif key == "queryMetrics":
            suggest = "query_metrics"
        elif key == "setupAlerts":
            suggest = "setup_alerts"
        elif key == "setupLogsRules":
            suggest = "setup_logs_rules"
        elif key == "setupMetricsRules":
            suggest = "setup_metrics_rules"
        elif key == "writeLogs":
            suggest = "write_logs"
        elif key == "writeMetrics":
            suggest = "write_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CockpitTokenScopes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CockpitTokenScopes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CockpitTokenScopes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_logs: Optional[bool] = None,
                 query_metrics: Optional[bool] = None,
                 setup_alerts: Optional[bool] = None,
                 setup_logs_rules: Optional[bool] = None,
                 setup_metrics_rules: Optional[bool] = None,
                 write_logs: Optional[bool] = None,
                 write_metrics: Optional[bool] = None):
        """
        :param bool query_logs: Query logs
        :param bool query_metrics: Query metrics
        :param bool setup_alerts: Setup alerts
        :param bool setup_logs_rules: Setup logs rules
        :param bool setup_metrics_rules: Setup metrics rules
        :param bool write_logs: Write logs
        :param bool write_metrics: Write metrics
        """
        if query_logs is not None:
            pulumi.set(__self__, "query_logs", query_logs)
        if query_metrics is not None:
            pulumi.set(__self__, "query_metrics", query_metrics)
        if setup_alerts is not None:
            pulumi.set(__self__, "setup_alerts", setup_alerts)
        if setup_logs_rules is not None:
            pulumi.set(__self__, "setup_logs_rules", setup_logs_rules)
        if setup_metrics_rules is not None:
            pulumi.set(__self__, "setup_metrics_rules", setup_metrics_rules)
        if write_logs is not None:
            pulumi.set(__self__, "write_logs", write_logs)
        if write_metrics is not None:
            pulumi.set(__self__, "write_metrics", write_metrics)

    @property
    @pulumi.getter(name="queryLogs")
    def query_logs(self) -> Optional[bool]:
        """
        Query logs
        """
        return pulumi.get(self, "query_logs")

    @property
    @pulumi.getter(name="queryMetrics")
    def query_metrics(self) -> Optional[bool]:
        """
        Query metrics
        """
        return pulumi.get(self, "query_metrics")

    @property
    @pulumi.getter(name="setupAlerts")
    def setup_alerts(self) -> Optional[bool]:
        """
        Setup alerts
        """
        return pulumi.get(self, "setup_alerts")

    @property
    @pulumi.getter(name="setupLogsRules")
    def setup_logs_rules(self) -> Optional[bool]:
        """
        Setup logs rules
        """
        return pulumi.get(self, "setup_logs_rules")

    @property
    @pulumi.getter(name="setupMetricsRules")
    def setup_metrics_rules(self) -> Optional[bool]:
        """
        Setup metrics rules
        """
        return pulumi.get(self, "setup_metrics_rules")

    @property
    @pulumi.getter(name="writeLogs")
    def write_logs(self) -> Optional[bool]:
        """
        Write logs
        """
        return pulumi.get(self, "write_logs")

    @property
    @pulumi.getter(name="writeMetrics")
    def write_metrics(self) -> Optional[bool]:
        """
        Write metrics
        """
        return pulumi.get(self, "write_metrics")


@pulumi.output_type
class DomainRecordGeoIp(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.DomainRecordGeoIpMatch']):
        """
        :param Sequence['DomainRecordGeoIpMatchArgs'] matches: The list of matches. *(Can be more than 1)*
        """
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.DomainRecordGeoIpMatch']:
        """
        The list of matches. *(Can be more than 1)*
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class DomainRecordGeoIpMatch(dict):
    def __init__(__self__, *,
                 data: str,
                 continents: Optional[Sequence[str]] = None,
                 countries: Optional[Sequence[str]] = None):
        """
        :param str data: The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        :param Sequence[str] continents: List of continents (eg: `EU` for Europe, `NA` for North America, `AS` for Asia...). [List of all continents code](https://api.scaleway.com/domain-private/v2beta1/continents)
        :param Sequence[str] countries: List of countries (eg: `FR` for France, `US` for the United States, `GB` for Great Britain...). [List of all countries code](https://api.scaleway.com/domain-private/v2beta1/countries)
        """
        pulumi.set(__self__, "data", data)
        if continents is not None:
            pulumi.set(__self__, "continents", continents)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def continents(self) -> Optional[Sequence[str]]:
        """
        List of continents (eg: `EU` for Europe, `NA` for North America, `AS` for Asia...). [List of all continents code](https://api.scaleway.com/domain-private/v2beta1/continents)
        """
        return pulumi.get(self, "continents")

    @property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[str]]:
        """
        List of countries (eg: `FR` for France, `US` for the United States, `GB` for Great Britain...). [List of all countries code](https://api.scaleway.com/domain-private/v2beta1/countries)
        """
        return pulumi.get(self, "countries")


@pulumi.output_type
class DomainRecordHttpService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mustContain":
            suggest = "must_contain"
        elif key == "userAgent":
            suggest = "user_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRecordHttpService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRecordHttpService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRecordHttpService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ips: Sequence[str],
                 must_contain: str,
                 strategy: str,
                 url: str,
                 user_agent: Optional[str] = None):
        """
        :param Sequence[str] ips: List of IPs to check
        :param str must_contain: Text to search
        :param str strategy: Strategy to return an IP from the IPs list. Can be `random` or `hashed`
        :param str url: URL to match the `must_contain` text to validate an IP
        :param str user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)

    @property
    @pulumi.getter
    def ips(self) -> Sequence[str]:
        """
        List of IPs to check
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> str:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        """
        Strategy to return an IP from the IPs list. Can be `random` or `hashed`
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL to match the `must_contain` text to validate an IP
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[str]:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class DomainRecordView(dict):
    def __init__(__self__, *,
                 data: str,
                 subnet: str):
        """
        :param str data: The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        :param str subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class DomainRecordWeighted(dict):
    def __init__(__self__, *,
                 ip: str,
                 weight: int):
        """
        :param str ip: The weighted IP
        :param int weight: The weight of the IP as an integer UInt32.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of the IP as an integer UInt32.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class IamPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionSetNames":
            suggest = "permission_set_names"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "projectIds":
            suggest = "project_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IamPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IamPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IamPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission_set_names: Sequence[str],
                 organization_id: Optional[str] = None,
                 project_ids: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] permission_set_names: Names of permission sets bound to the rule.
        :param str organization_id: ID of organization scoped to the rule.
        :param Sequence[str] project_ids: List of project IDs scoped to the rule.
        """
        pulumi.set(__self__, "permission_set_names", permission_set_names)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)

    @property
    @pulumi.getter(name="permissionSetNames")
    def permission_set_names(self) -> Sequence[str]:
        """
        Names of permission sets bound to the rule.
        """
        return pulumi.get(self, "permission_set_names")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[str]:
        """
        ID of organization scoped to the rule.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[Sequence[str]]:
        """
        List of project IDs scoped to the rule.
        """
        return pulumi.get(self, "project_ids")


@pulumi.output_type
class InstanceImageAdditionalVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationDate":
            suggest = "creation_date"
        elif key == "exportUri":
            suggest = "export_uri"
        elif key == "modificationDate":
            suggest = "modification_date"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceImageAdditionalVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceImageAdditionalVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceImageAdditionalVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_date: Optional[str] = None,
                 export_uri: Optional[str] = None,
                 id: Optional[str] = None,
                 modification_date: Optional[str] = None,
                 name: Optional[str] = None,
                 organization: Optional[str] = None,
                 project: Optional[str] = None,
                 server: Optional[Mapping[str, str]] = None,
                 size: Optional[int] = None,
                 state: Optional[str] = None,
                 tags: Optional[Sequence[str]] = None,
                 volume_type: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str creation_date: Date of the volume creation.
        :param str export_uri: The export URI of the volume.
        :param str id: ID of the server containing the volume.
        :param str modification_date: Date of volume latest update.
        :param str name: The name of the image. If not provided it will be randomly generated.
        :param str organization: The organization ID the volume is associated with.
        :param str project: ID of the project the volume is associated with
        :param Mapping[str, str] server: Description of the server containing the volume (in case the image is a backup from a server).
        :param int size: The size of the volume.
        :param str state: State of the volume.
        :param Sequence[str] tags: A list of tags to apply to the image.
        :param str volume_type: The type of volume, possible values are `l_ssd` and `b_ssd`.
        :param str zone: The zone in which the image should be created.
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if export_uri is not None:
            pulumi.set(__self__, "export_uri", export_uri)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if modification_date is not None:
            pulumi.set(__self__, "modification_date", modification_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[str]:
        """
        Date of the volume creation.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="exportUri")
    def export_uri(self) -> Optional[str]:
        """
        The export URI of the volume.
        """
        return pulumi.get(self, "export_uri")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modificationDate")
    def modification_date(self) -> Optional[str]:
        """
        Date of volume latest update.
        """
        return pulumi.get(self, "modification_date")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> Optional[str]:
        """
        The organization ID the volume is associated with.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        ID of the project the volume is associated with
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def server(self) -> Optional[Mapping[str, str]]:
        """
        Description of the server containing the volume (in case the image is a backup from a server).
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        State of the volume.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        """
        The type of volume, possible values are `l_ssd` and `b_ssd`.
        """
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The zone in which the image should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceSecurityGroupInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 ip: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 port: Optional[int] = None,
                 port_range: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param int port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 ip: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 port: Optional[int] = None,
                 port_range: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param int port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupRulesInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupRulesInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupRulesInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupRulesInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 ip: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 port: Optional[int] = None,
                 port_range: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupRulesOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupRulesOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupRulesOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupRulesOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 ip: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 port: Optional[int] = None,
                 port_range: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: str,
                 mac_address: Optional[str] = None,
                 status: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> str:
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceServerRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "volumeId":
            suggest = "volume_id"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot: Optional[bool] = None,
                 delete_on_termination: Optional[bool] = None,
                 name: Optional[str] = None,
                 size_in_gb: Optional[int] = None,
                 volume_id: Optional[str] = None,
                 volume_type: Optional[str] = None):
        """
        :param bool delete_on_termination: Forces deletion of the root volume on instance termination.
        :param str name: The name of the server.
        :param int size_in_gb: Size of the root volume in gigabytes.
               To find the right size use [this endpoint](https://api.scaleway.com/instance/v1/zones/fr-par-1/products/servers) and
               check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
               Updates to this field will recreate a new resource.
        :param str volume_id: The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        :param str volume_type: Volume type of root volume, can be `b_ssd` or `l_ssd`, default value depends on server type
        """
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def boot(self) -> Optional[bool]:
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[int]:
        """
        Size of the root volume in gigabytes.
        To find the right size use [this endpoint](https://api.scaleway.com/instance/v1/zones/fr-par-1/products/servers) and
        check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
        Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[str]:
        """
        The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        """
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        """
        Volume type of root volume, can be `b_ssd` or `l_ssd`, default value depends on server type
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class InstanceSnapshotImport(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        """
        :param str bucket: Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        :param str key: Key of the object to import
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key of the object to import
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class IotDeviceCertificate(dict):
    def __init__(__self__, *,
                 crt: Optional[str] = None,
                 key: Optional[str] = None):
        """
        :param str key: The private key of the device, in case it is generated by Scaleway.
        """
        if crt is not None:
            pulumi.set(__self__, "crt", crt)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> Optional[str]:
        return pulumi.get(self, "crt")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The private key of the device, in case it is generated by Scaleway.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class IotDeviceMessageFilters(dict):
    def __init__(__self__, *,
                 publish: Optional['outputs.IotDeviceMessageFiltersPublish'] = None,
                 subscribe: Optional['outputs.IotDeviceMessageFiltersSubscribe'] = None):
        """
        :param 'IotDeviceMessageFiltersPublishArgs' publish: Rules used to restrict topics the device can publish to.
        :param 'IotDeviceMessageFiltersSubscribeArgs' subscribe: Rules used to restrict topics the device can subscribe to.
        """
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if subscribe is not None:
            pulumi.set(__self__, "subscribe", subscribe)

    @property
    @pulumi.getter
    def publish(self) -> Optional['outputs.IotDeviceMessageFiltersPublish']:
        """
        Rules used to restrict topics the device can publish to.
        """
        return pulumi.get(self, "publish")

    @property
    @pulumi.getter
    def subscribe(self) -> Optional['outputs.IotDeviceMessageFiltersSubscribe']:
        """
        Rules used to restrict topics the device can subscribe to.
        """
        return pulumi.get(self, "subscribe")


@pulumi.output_type
class IotDeviceMessageFiltersPublish(dict):
    def __init__(__self__, *,
                 policy: Optional[str] = None,
                 topics: Optional[Sequence[str]] = None):
        """
        :param str policy: Same as publish rules.
        :param Sequence[str] topics: Same as publish rules.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[str]]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class IotDeviceMessageFiltersSubscribe(dict):
    def __init__(__self__, *,
                 policy: Optional[str] = None,
                 topics: Optional[Sequence[str]] = None):
        """
        :param str policy: Same as publish rules.
        :param Sequence[str] topics: Same as publish rules.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[str]]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class IotRouteDatabase(dict):
    def __init__(__self__, *,
                 dbname: str,
                 host: str,
                 password: str,
                 port: int,
                 query: str,
                 username: str):
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def dbname(self) -> str:
        return pulumi.get(self, "dbname")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def query(self) -> str:
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class IotRouteRest(dict):
    def __init__(__self__, *,
                 headers: Mapping[str, str],
                 uri: str,
                 verb: str):
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "verb", verb)

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, str]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def verb(self) -> str:
        return pulumi.get(self, "verb")


@pulumi.output_type
class IotRouteS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketRegion":
            suggest = "bucket_region"
        elif key == "objectPrefix":
            suggest = "object_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotRouteS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotRouteS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotRouteS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 bucket_region: str,
                 strategy: str,
                 object_prefix: Optional[str] = None):
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "strategy", strategy)
        if object_prefix is not None:
            pulumi.set(__self__, "object_prefix", object_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> str:
        return pulumi.get(self, "bucket_region")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter(name="objectPrefix")
    def object_prefix(self) -> Optional[str]:
        return pulumi.get(self, "object_prefix")


@pulumi.output_type
class K8sClusterAutoUpgrade(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceWindowDay":
            suggest = "maintenance_window_day"
        elif key == "maintenanceWindowStartHour":
            suggest = "maintenance_window_start_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sClusterAutoUpgrade. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sClusterAutoUpgrade.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sClusterAutoUpgrade.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: bool,
                 maintenance_window_day: str,
                 maintenance_window_start_hour: int):
        """
        :param bool enable: Set to `true` to enable Kubernetes patch version auto upgrades.
               > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        :param str maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param int maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Set to `true` to enable Kubernetes patch version auto upgrades.
        > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> str:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> int:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")


@pulumi.output_type
class K8sClusterAutoscalerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "balanceSimilarNodeGroups":
            suggest = "balance_similar_node_groups"
        elif key == "disableScaleDown":
            suggest = "disable_scale_down"
        elif key == "expendablePodsPriorityCutoff":
            suggest = "expendable_pods_priority_cutoff"
        elif key == "ignoreDaemonsetsUtilization":
            suggest = "ignore_daemonsets_utilization"
        elif key == "maxGracefulTerminationSec":
            suggest = "max_graceful_termination_sec"
        elif key == "scaleDownDelayAfterAdd":
            suggest = "scale_down_delay_after_add"
        elif key == "scaleDownUnneededTime":
            suggest = "scale_down_unneeded_time"
        elif key == "scaleDownUtilizationThreshold":
            suggest = "scale_down_utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sClusterAutoscalerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sClusterAutoscalerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sClusterAutoscalerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[bool] = None,
                 disable_scale_down: Optional[bool] = None,
                 estimator: Optional[str] = None,
                 expander: Optional[str] = None,
                 expendable_pods_priority_cutoff: Optional[int] = None,
                 ignore_daemonsets_utilization: Optional[bool] = None,
                 max_graceful_termination_sec: Optional[int] = None,
                 scale_down_delay_after_add: Optional[str] = None,
                 scale_down_unneeded_time: Optional[str] = None,
                 scale_down_utilization_threshold: Optional[float] = None):
        """
        :param bool balance_similar_node_groups: Detect similar node groups and balance the number of nodes between them.
        :param bool disable_scale_down: Disables the scale down feature of the autoscaler.
        :param str estimator: Type of resource estimator to be used in scale up.
        :param str expander: Type of node group expander to be used in scale up.
        :param int expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param bool ignore_daemonsets_utilization: Ignore DaemonSet pods when calculating resource utilization for scaling down.
        :param int max_graceful_termination_sec: Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        :param str scale_down_delay_after_add: How long after scale up that scale down evaluation resumes.
        :param str scale_down_unneeded_time: How long a node should be unneeded before it is eligible for scale down.
        :param float scale_down_utilization_threshold: Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if disable_scale_down is not None:
            pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        if estimator is not None:
            pulumi.set(__self__, "estimator", estimator)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if expendable_pods_priority_cutoff is not None:
            pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        if ignore_daemonsets_utilization is not None:
            pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[bool]:
        """
        Detect similar node groups and balance the number of nodes between them.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> Optional[bool]:
        """
        Disables the scale down feature of the autoscaler.
        """
        return pulumi.get(self, "disable_scale_down")

    @property
    @pulumi.getter
    def estimator(self) -> Optional[str]:
        """
        Type of resource estimator to be used in scale up.
        """
        return pulumi.get(self, "estimator")

    @property
    @pulumi.getter
    def expander(self) -> Optional[str]:
        """
        Type of node group expander to be used in scale up.
        """
        return pulumi.get(self, "expander")

    @property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> Optional[int]:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> Optional[bool]:
        """
        Ignore DaemonSet pods when calculating resource utilization for scaling down.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[int]:
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[str]:
        """
        How long after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[str]:
        """
        How long a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[float]:
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "scale_down_utilization_threshold")


@pulumi.output_type
class K8sClusterKubeconfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterCaCertificate":
            suggest = "cluster_ca_certificate"
        elif key == "configFile":
            suggest = "config_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sClusterKubeconfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sClusterKubeconfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sClusterKubeconfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_ca_certificate: Optional[str] = None,
                 config_file: Optional[str] = None,
                 host: Optional[str] = None,
                 token: Optional[str] = None):
        """
        :param str cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param str config_file: The raw kubeconfig file.
        :param str host: The URL of the Kubernetes API server.
        :param str token: The token to connect to the Kubernetes API server.
        """
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[str]:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[str]:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class K8sClusterOpenIdConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "groupsClaims":
            suggest = "groups_claims"
        elif key == "groupsPrefix":
            suggest = "groups_prefix"
        elif key == "requiredClaims":
            suggest = "required_claims"
        elif key == "usernameClaim":
            suggest = "username_claim"
        elif key == "usernamePrefix":
            suggest = "username_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sClusterOpenIdConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sClusterOpenIdConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sClusterOpenIdConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 issuer_url: str,
                 groups_claims: Optional[Sequence[str]] = None,
                 groups_prefix: Optional[str] = None,
                 required_claims: Optional[Sequence[str]] = None,
                 username_claim: Optional[str] = None,
                 username_prefix: Optional[str] = None):
        """
        :param str client_id: A client id that all tokens must be issued for
        :param str issuer_url: URL of the provider which allows the API server to discover public signing keys
        :param Sequence[str] groups_claims: JWT claim to use as the user's group
        :param str groups_prefix: Prefix prepended to group claims
        :param Sequence[str] required_claims: Multiple key=value pairs that describes a required claim in the ID Token
        :param str username_claim: JWT claim to use as the user name
        :param str username_prefix: Prefix prepended to username
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claims is not None:
            pulumi.set(__self__, "groups_claims", groups_claims)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        A client id that all tokens must be issued for
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Optional[Sequence[str]]:
        """
        JWT claim to use as the user's group
        """
        return pulumi.get(self, "groups_claims")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[str]:
        """
        Prefix prepended to group claims
        """
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence[str]]:
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[str]:
        """
        JWT claim to use as the user name
        """
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[str]:
        """
        Prefix prepended to username
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class K8sPoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIp":
            suggest = "public_ip"
        elif key == "publicIpV6":
            suggest = "public_ip_v6"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sPoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sPoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sPoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 public_ip: Optional[str] = None,
                 public_ip_v6: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str name: The name for the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param str public_ip: The public IPv4.
        :param str public_ip_v6: The public IPv6.
        :param str status: The status of the node.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_v6 is not None:
            pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name for the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        """
        The public IPv4.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIpV6")
    def public_ip_v6(self) -> Optional[str]:
        """
        The public IPv6.
        """
        return pulumi.get(self, "public_ip_v6")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class K8sPoolUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sPoolUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sPoolUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sPoolUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[int] = None,
                 max_unavailable: Optional[int] = None):
        """
        :param int max_surge: The maximum number of nodes to be created during the upgrade
        :param int max_unavailable: The maximum number of nodes that can be not ready at the same time
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[int]:
        """
        The maximum number of nodes to be created during the upgrade
        """
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[int]:
        """
        The maximum number of nodes that can be not ready at the same time
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class LbBackendHealthCheckHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbBackendHealthCheckHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbBackendHealthCheckHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbBackendHealthCheckHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: str,
                 code: Optional[int] = None,
                 host_header: Optional[str] = None,
                 method: Optional[str] = None):
        """
        :param str uri: The HTTP endpoint URL to call for HC requests.
        :param int code: The expected HTTP status code.
        :param str host_header: The HTTP host header to use for HC requests.
        :param str method: The HTTP method to use for HC requests.
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The HTTP endpoint URL to call for HC requests.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        The expected HTTP status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[str]:
        """
        The HTTP host header to use for HC requests.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The HTTP method to use for HC requests.
        """
        return pulumi.get(self, "method")


@pulumi.output_type
class LbBackendHealthCheckHttps(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbBackendHealthCheckHttps. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbBackendHealthCheckHttps.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbBackendHealthCheckHttps.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: str,
                 code: Optional[int] = None,
                 host_header: Optional[str] = None,
                 method: Optional[str] = None,
                 sni: Optional[str] = None):
        """
        :param str uri: The HTTP endpoint URL to call for HC requests.
        :param int code: The expected HTTP status code.
        :param str host_header: The HTTP host header to use for HC requests.
        :param str method: The HTTP method to use for HC requests.
        :param str sni: The SNI to use for HC requests over SSL.
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if sni is not None:
            pulumi.set(__self__, "sni", sni)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The HTTP endpoint URL to call for HC requests.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        The expected HTTP status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[str]:
        """
        The HTTP host header to use for HC requests.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The HTTP method to use for HC requests.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def sni(self) -> Optional[str]:
        """
        The SNI to use for HC requests over SSL.
        """
        return pulumi.get(self, "sni")


@pulumi.output_type
class LbBackendHealthCheckTcp(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class LbCertificateCustomCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateChain":
            suggest = "certificate_chain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbCertificateCustomCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbCertificateCustomCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbCertificateCustomCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_chain: str):
        """
        :param str certificate_chain: Full PEM-formatted certificate chain.
        """
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> str:
        """
        Full PEM-formatted certificate chain.
        """
        return pulumi.get(self, "certificate_chain")


@pulumi.output_type
class LbCertificateLetsencrypt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbCertificateLetsencrypt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbCertificateLetsencrypt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbCertificateLetsencrypt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: str,
                 subject_alternative_names: Optional[Sequence[str]] = None):
        """
        :param str common_name: Main domain of the certificate. A new certificate will be created if this field is changed.
        :param Sequence[str] subject_alternative_names: Array of alternative domain names.  A new certificate will be created if this field is changed.
        """
        pulumi.set(__self__, "common_name", common_name)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        Main domain of the certificate. A new certificate will be created if this field is changed.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence[str]]:
        """
        Array of alternative domain names.  A new certificate will be created if this field is changed.
        """
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class LbFrontendAcl(dict):
    def __init__(__self__, *,
                 action: 'outputs.LbFrontendAclAction',
                 match: 'outputs.LbFrontendAclMatch',
                 name: Optional[str] = None):
        """
        :param 'LbFrontendAclActionArgs' action: Action to undertake when an ACL filter matches.
        :param 'LbFrontendAclMatchArgs' match: The ACL match rule. At least `ip_subnet` or `http_filter` and `http_filter_value` are required.
        :param str name: The ACL name. If not provided it will be randomly generated.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match", match)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.LbFrontendAclAction':
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def match(self) -> 'outputs.LbFrontendAclMatch':
        """
        The ACL match rule. At least `ip_subnet` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LbFrontendAclAction(dict):
    def __init__(__self__, *,
                 type: str):
        """
        :param str type: The action type. Possible values are: `allow` or `deny`.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The action type. Possible values are: `allow` or `deny`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LbFrontendAclMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpFilter":
            suggest = "http_filter"
        elif key == "httpFilterOption":
            suggest = "http_filter_option"
        elif key == "httpFilterValues":
            suggest = "http_filter_values"
        elif key == "ipSubnets":
            suggest = "ip_subnets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbFrontendAclMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbFrontendAclMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbFrontendAclMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_filter: Optional[str] = None,
                 http_filter_option: Optional[str] = None,
                 http_filter_values: Optional[Sequence[str]] = None,
                 invert: Optional[bool] = None,
                 ip_subnets: Optional[Sequence[str]] = None):
        """
        :param str http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param Sequence[str] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case-insensitive.
        :param bool invert: If set to `true`, the condition will be of type "unless".
        :param Sequence[str] ip_subnets: A list of IPs or CIDR v4/v6 addresses of the client of the session to match.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[str]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[str]:
        return pulumi.get(self, "http_filter_option")

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[Sequence[str]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case-insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @property
    @pulumi.getter
    def invert(self) -> Optional[bool]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[Sequence[str]]:
        """
        A list of IPs or CIDR v4/v6 addresses of the client of the session to match.
        """
        return pulumi.get(self, "ip_subnets")


@pulumi.output_type
class LbPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "dhcpConfig":
            suggest = "dhcp_config"
        elif key == "staticConfig":
            suggest = "static_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: str,
                 dhcp_config: Optional[bool] = None,
                 static_config: Optional[str] = None,
                 status: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str private_network_id: (Required) The ID of the Private Network to associate.
        :param bool dhcp_config: (Optional) Set to true if you want to let DHCP assign IP addresses. See below.
        :param str static_config: (Optional) Define a local ip address of your choice for the load balancer instance. See below.
        :param str zone: `zone`) The zone of the load-balancer.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if dhcp_config is not None:
            pulumi.set(__self__, "dhcp_config", dhcp_config)
        if static_config is not None:
            pulumi.set(__self__, "static_config", static_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> str:
        """
        (Required) The ID of the Private Network to associate.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="dhcpConfig")
    def dhcp_config(self) -> Optional[bool]:
        """
        (Optional) Set to true if you want to let DHCP assign IP addresses. See below.
        """
        return pulumi.get(self, "dhcp_config")

    @property
    @pulumi.getter(name="staticConfig")
    def static_config(self) -> Optional[str]:
        """
        (Optional) Define a local ip address of your choice for the load balancer instance. See below.
        """
        return pulumi.get(self, "static_config")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        `zone`) The zone of the load-balancer.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class MnqCredentialNatsCredentials(dict):
    def __init__(__self__, *,
                 content: Optional[str] = None):
        """
        :param str content: Raw content of the NATS credentials file.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        Raw content of the NATS credentials file.
        """
        return pulumi.get(self, "content")


@pulumi.output_type
class MnqCredentialSqsSnsCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MnqCredentialSqsSnsCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MnqCredentialSqsSnsCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MnqCredentialSqsSnsCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[str] = None,
                 permissions: Optional['outputs.MnqCredentialSqsSnsCredentialsPermissions'] = None,
                 secret_key: Optional[str] = None):
        """
        :param str access_key: The ID of the key.
        :param 'MnqCredentialSqsSnsCredentialsPermissionsArgs' permissions: List of permissions associated to this Credential. Only one of permissions may be set.
        :param str secret_key: The Secret value of the key.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        The ID of the key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def permissions(self) -> Optional['outputs.MnqCredentialSqsSnsCredentialsPermissions']:
        """
        List of permissions associated to this Credential. Only one of permissions may be set.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The Secret value of the key.
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class MnqCredentialSqsSnsCredentialsPermissions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canManage":
            suggest = "can_manage"
        elif key == "canPublish":
            suggest = "can_publish"
        elif key == "canReceive":
            suggest = "can_receive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MnqCredentialSqsSnsCredentialsPermissions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MnqCredentialSqsSnsCredentialsPermissions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MnqCredentialSqsSnsCredentialsPermissions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_manage: Optional[bool] = None,
                 can_publish: Optional[bool] = None,
                 can_receive: Optional[bool] = None):
        """
        :param bool can_manage: . Defines if user can manage the associated resource(s).
        :param bool can_publish: . Defines if user can publish messages to the service.
        :param bool can_receive: . Defines if user can receive messages from the service.
        """
        if can_manage is not None:
            pulumi.set(__self__, "can_manage", can_manage)
        if can_publish is not None:
            pulumi.set(__self__, "can_publish", can_publish)
        if can_receive is not None:
            pulumi.set(__self__, "can_receive", can_receive)

    @property
    @pulumi.getter(name="canManage")
    def can_manage(self) -> Optional[bool]:
        """
        . Defines if user can manage the associated resource(s).
        """
        return pulumi.get(self, "can_manage")

    @property
    @pulumi.getter(name="canPublish")
    def can_publish(self) -> Optional[bool]:
        """
        . Defines if user can publish messages to the service.
        """
        return pulumi.get(self, "can_publish")

    @property
    @pulumi.getter(name="canReceive")
    def can_receive(self) -> Optional[bool]:
        """
        . Defines if user can receive messages from the service.
        """
        return pulumi.get(self, "can_receive")


@pulumi.output_type
class ObjectBucketAclAccessControlPolicy(dict):
    def __init__(__self__, *,
                 owner: 'outputs.ObjectBucketAclAccessControlPolicyOwner',
                 grants: Optional[Sequence['outputs.ObjectBucketAclAccessControlPolicyGrant']] = None):
        pulumi.set(__self__, "owner", owner)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)

    @property
    @pulumi.getter
    def owner(self) -> 'outputs.ObjectBucketAclAccessControlPolicyOwner':
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def grants(self) -> Optional[Sequence['outputs.ObjectBucketAclAccessControlPolicyGrant']]:
        return pulumi.get(self, "grants")


@pulumi.output_type
class ObjectBucketAclAccessControlPolicyGrant(dict):
    def __init__(__self__, *,
                 permission: str,
                 grantee: Optional['outputs.ObjectBucketAclAccessControlPolicyGrantGrantee'] = None):
        pulumi.set(__self__, "permission", permission)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)

    @property
    @pulumi.getter
    def permission(self) -> str:
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def grantee(self) -> Optional['outputs.ObjectBucketAclAccessControlPolicyGrantGrantee']:
        return pulumi.get(self, "grantee")


@pulumi.output_type
class ObjectBucketAclAccessControlPolicyGrantGrantee(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketAclAccessControlPolicyGrantGrantee. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketAclAccessControlPolicyGrantGrantee.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketAclAccessControlPolicyGrantGrantee.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 type: str,
                 display_name: Optional[str] = None):
        """
        :param str id: The `region`,`bucket` and `acl` separated by (`/`).
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The `region`,`bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ObjectBucketAclAccessControlPolicyOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketAclAccessControlPolicyOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketAclAccessControlPolicyOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketAclAccessControlPolicyOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 display_name: Optional[str] = None):
        """
        :param str id: The `region`,`bucket` and `acl` separated by (`/`).
        """
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The `region`,`bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ObjectBucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        :param Sequence[str] allowed_origins: Specifies which origins are allowed.
        :param Sequence[str] allowed_headers: Specifies which headers are allowed.
        :param Sequence[str] expose_headers: Specifies expose header in the response.
        :param int max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies expose header in the response.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class ObjectBucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 abort_incomplete_multipart_upload_days: Optional[int] = None,
                 expiration: Optional['outputs.ObjectBucketLifecycleRuleExpiration'] = None,
                 id: Optional[str] = None,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 transitions: Optional[Sequence['outputs.ObjectBucketLifecycleRuleTransition']] = None):
        """
        :param bool enabled: The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway S3 doesn't perform any of the actions defined in the rule.
        :param int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        :param 'ObjectBucketLifecycleRuleExpirationArgs' expiration: Specifies a period in the object's expire (documented below).
        :param str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param str prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param Mapping[str, str] tags: Specifies object tags key and value.
        :param Sequence['ObjectBucketLifecycleRuleTransitionArgs'] transitions: Specifies a period in the object's transitions (documented below).
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway S3 doesn't perform any of the actions defined in the rule.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[int]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.ObjectBucketLifecycleRuleExpiration']:
        """
        Specifies a period in the object's expire (documented below).
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.ObjectBucketLifecycleRuleTransition']]:
        """
        Specifies a period in the object's transitions (documented below).
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class ObjectBucketLifecycleRuleExpiration(dict):
    def __init__(__self__, *,
                 days: int):
        """
        :param int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class ObjectBucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 days: Optional[int] = None):
        """
        :param str storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/storage/object/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.
        :param int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/storage/object/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class ObjectBucketLockConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketLockConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketLockConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketLockConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: 'outputs.ObjectBucketLockConfigurationRuleDefaultRetention'):
        pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> 'outputs.ObjectBucketLockConfigurationRuleDefaultRetention':
        return pulumi.get(self, "default_retention")


@pulumi.output_type
class ObjectBucketLockConfigurationRuleDefaultRetention(dict):
    def __init__(__self__, *,
                 mode: str,
                 days: Optional[int] = None,
                 years: Optional[int] = None):
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def years(self) -> Optional[int]:
        return pulumi.get(self, "years")


@pulumi.output_type
class ObjectBucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ObjectBucketWebsiteConfigurationErrorDocument(dict):
    def __init__(__self__, *,
                 key: str):
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class ObjectBucketWebsiteConfigurationIndexDocument(dict):
    def __init__(__self__, *,
                 suffix: str):
        pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def suffix(self) -> str:
        return pulumi.get(self, "suffix")


@pulumi.output_type
class RdbAclAclRule(dict):
    def __init__(__self__, *,
                 ip: str,
                 description: Optional[str] = None):
        """
        :param str ip: The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param str description: A text describing this rule. Default description: `IP allowed`
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A text describing this rule. Default description: `IP allowed`
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class RdbInstanceLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdbInstanceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdbInstanceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdbInstanceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[str] = None,
                 hostname: Optional[str] = None,
                 ip: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param str endpoint_id: The ID of the endpoint of the private network.
        :param str hostname: Name of the endpoint.
        :param str ip: IP of the endpoint.
        :param str name: The name of the Database Instance.
        :param int port: Port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        """
        The ID of the endpoint of the private network.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        IP of the endpoint.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RdbInstancePrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipNet":
            suggest = "ip_net"
        elif key == "pnId":
            suggest = "pn_id"
        elif key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdbInstancePrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdbInstancePrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdbInstancePrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_net: str,
                 pn_id: str,
                 endpoint_id: Optional[str] = None,
                 hostname: Optional[str] = None,
                 ip: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 zone: Optional[str] = None):
        """
        :param str endpoint_id: The ID of the endpoint of the private network.
        :param str hostname: Name of the endpoint.
        :param str ip: IP of the endpoint.
        :param str name: The name of the Database Instance.
        :param int port: Port of the endpoint.
        """
        pulumi.set(__self__, "ip_net", ip_net)
        pulumi.set(__self__, "pn_id", pn_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> str:
        return pulumi.get(self, "ip_net")

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> str:
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        """
        The ID of the endpoint of the private network.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        IP of the endpoint.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port of the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        return pulumi.get(self, "zone")


@pulumi.output_type
class RdbInstanceReadReplica(dict):
    def __init__(__self__, *,
                 ip: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param str ip: IP of the endpoint.
        :param str name: The name of the Database Instance.
        :param int port: Port of the endpoint.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        IP of the endpoint.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RdbReadReplicaDirectAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdbReadReplicaDirectAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdbReadReplicaDirectAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdbReadReplicaDirectAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[str] = None,
                 hostname: Optional[str] = None,
                 ip: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param str endpoint_id: The ID of the endpoint of the read replica.
        :param str hostname: Hostname of the endpoint. Only one of ip and hostname may be set.
        :param str ip: IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        :param str name: Name of the endpoint.
        :param int port: TCP port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        """
        The ID of the endpoint of the read replica.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Hostname of the endpoint. Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RdbReadReplicaPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "serviceIp":
            suggest = "service_ip"
        elif key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdbReadReplicaPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdbReadReplicaPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdbReadReplicaPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: str,
                 service_ip: str,
                 endpoint_id: Optional[str] = None,
                 hostname: Optional[str] = None,
                 ip: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 zone: Optional[str] = None):
        """
        :param str private_network_id: UUID of the private network to be connected to the read replica.
        :param str service_ip: Endpoint IPv4 address with a CIDR notation. Check documentation about IP and subnet
               limitations. (IP network).
        :param str endpoint_id: The ID of the endpoint of the read replica.
        :param str hostname: Hostname of the endpoint. Only one of ip and hostname may be set.
        :param str ip: IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        :param str name: Name of the endpoint.
        :param int port: TCP port of the endpoint.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        pulumi.set(__self__, "service_ip", service_ip)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> str:
        """
        UUID of the private network to be connected to the read replica.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> str:
        """
        Endpoint IPv4 address with a CIDR notation. Check documentation about IP and subnet
        limitations. (IP network).
        """
        return pulumi.get(self, "service_ip")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        """
        The ID of the endpoint of the read replica.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Hostname of the endpoint. Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        IPv4 address of the endpoint (IP address). Only one of ip and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        return pulumi.get(self, "zone")


@pulumi.output_type
class RedisClusterAcl(dict):
    def __init__(__self__, *,
                 ip: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param str ip: The ip range to whitelist
               in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param str description: A text describing this rule. Default description: `Allow IP`
        :param str id: The UUID of the private network resource.
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The ip range to whitelist
        in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A text describing this rule. Default description: `Allow IP`
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The UUID of the private network resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RedisClusterPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceIps":
            suggest = "service_ips"
        elif key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedisClusterPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedisClusterPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedisClusterPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 service_ips: Sequence[str],
                 endpoint_id: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str id: The UUID of the private network resource.
        :param Sequence[str] service_ips: Endpoint IPv4 addresses
               in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at
               least one IP per node.
        :param str zone: `zone`) The zone in which the
               Redis Cluster should be created.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_ips", service_ips)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The UUID of the private network resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> Sequence[str]:
        """
        Endpoint IPv4 addresses
        in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at
        least one IP per node.
        """
        return pulumi.get(self, "service_ips")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        `zone`) The zone in which the
        Redis Cluster should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class RedisClusterPublicNetwork(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 ips: Optional[Sequence[str]] = None,
                 port: Optional[int] = None):
        """
        :param str id: The UUID of the private network resource.
        :param Sequence[str] ips: Lis of IPv4 address of the endpoint (IP address).
        :param int port: TCP port of the endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The UUID of the private network resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[str]]:
        """
        Lis of IPv4 address of the endpoint (IP address).
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetBaremetalOfferCpusResult(dict):
    def __init__(__self__, *,
                 core_count: int,
                 frequency: int,
                 name: str,
                 thread_count: int):
        """
        :param int core_count: Number of core on this CPU.
        :param int frequency: Frequency of the memory in MHz.
        :param str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param int thread_count: Number of thread on this CPU.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "thread_count", thread_count)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> int:
        """
        Number of core on this CPU.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def frequency(self) -> int:
        """
        Frequency of the memory in MHz.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="threadCount")
    def thread_count(self) -> int:
        """
        Number of thread on this CPU.
        """
        return pulumi.get(self, "thread_count")


@pulumi.output_type
class GetBaremetalOfferDiskResult(dict):
    def __init__(__self__, *,
                 capacity: int,
                 type: str):
        """
        :param int capacity: Capacity of the memory in GB.
        :param str type: Type of memory.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def capacity(self) -> int:
        """
        Capacity of the memory in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of memory.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBaremetalOfferMemoryResult(dict):
    def __init__(__self__, *,
                 capacity: int,
                 frequency: int,
                 is_ecc: bool,
                 type: str):
        """
        :param int capacity: Capacity of the memory in GB.
        :param int frequency: Frequency of the memory in MHz.
        :param bool is_ecc: True if error-correcting code is available on this memory.
        :param str type: Type of memory.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "is_ecc", is_ecc)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def capacity(self) -> int:
        """
        Capacity of the memory in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def frequency(self) -> int:
        """
        Frequency of the memory in MHz.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="isEcc")
    def is_ecc(self) -> bool:
        """
        True if error-correcting code is available on this memory.
        """
        return pulumi.get(self, "is_ecc")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of memory.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBaremetalServerIpResult(dict):
    def __init__(__self__, *,
                 address: str,
                 id: str,
                 reverse: str,
                 version: str):
        """
        :param str id: The ID of the server.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> str:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> str:
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetBaremetalServerOptionResult(dict):
    def __init__(__self__, *,
                 expires_at: str,
                 id: str,
                 name: str):
        """
        :param str id: The ID of the server.
        :param str name: The server name. Only one of `name` and `server_id` should be specified.
        """
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The server name. Only one of `name` and `server_id` should be specified.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetBaremetalServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 id: str,
                 status: str,
                 updated_at: str,
                 vlan: int):
        """
        :param str id: The ID of the server.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def vlan(self) -> int:
        return pulumi.get(self, "vlan")


@pulumi.output_type
class GetCockpitEndpointResult(dict):
    def __init__(__self__, *,
                 alertmanager_url: str,
                 grafana_url: str,
                 logs_url: str,
                 metrics_url: str):
        """
        :param str alertmanager_url: The alertmanager URL
        :param str grafana_url: The grafana URL
        :param str logs_url: The logs URL
        :param str metrics_url: The metrics URL
        """
        pulumi.set(__self__, "alertmanager_url", alertmanager_url)
        pulumi.set(__self__, "grafana_url", grafana_url)
        pulumi.set(__self__, "logs_url", logs_url)
        pulumi.set(__self__, "metrics_url", metrics_url)

    @property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> str:
        """
        The alertmanager URL
        """
        return pulumi.get(self, "alertmanager_url")

    @property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> str:
        """
        The grafana URL
        """
        return pulumi.get(self, "grafana_url")

    @property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> str:
        """
        The logs URL
        """
        return pulumi.get(self, "logs_url")

    @property
    @pulumi.getter(name="metricsUrl")
    def metrics_url(self) -> str:
        """
        The metrics URL
        """
        return pulumi.get(self, "metrics_url")


@pulumi.output_type
class GetDomainRecordGeoIpResult(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.GetDomainRecordGeoIpMatchResult']):
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetDomainRecordGeoIpMatchResult']:
        return pulumi.get(self, "matches")


@pulumi.output_type
class GetDomainRecordGeoIpMatchResult(dict):
    def __init__(__self__, *,
                 continents: Sequence[str],
                 countries: Sequence[str],
                 data: str):
        """
        :param str data: The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
               Cannot be used with `record_id`.
        """
        pulumi.set(__self__, "continents", continents)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def continents(self) -> Sequence[str]:
        return pulumi.get(self, "continents")

    @property
    @pulumi.getter
    def countries(self) -> Sequence[str]:
        return pulumi.get(self, "countries")

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        Cannot be used with `record_id`.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class GetDomainRecordHttpServiceResult(dict):
    def __init__(__self__, *,
                 ips: Sequence[str],
                 must_contain: str,
                 strategy: str,
                 url: str,
                 user_agent: str):
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_agent", user_agent)

    @property
    @pulumi.getter
    def ips(self) -> Sequence[str]:
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> str:
        return pulumi.get(self, "must_contain")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> str:
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class GetDomainRecordViewResult(dict):
    def __init__(__self__, *,
                 data: str,
                 subnet: str):
        """
        :param str data: The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
               Cannot be used with `record_id`.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The content of the record (an IPv4 for an `A`, a string for a `TXT`...).
        Cannot be used with `record_id`.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def subnet(self) -> str:
        return pulumi.get(self, "subnet")


@pulumi.output_type
class GetDomainRecordWeightedResult(dict):
    def __init__(__self__, *,
                 ip: str,
                 weight: int):
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetInstanceSecurityGroupInboundRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 ip: str,
                 ip_range: str,
                 port: int,
                 port_range: str,
                 protocol: str):
        """
        :param str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param str ip: The ip this rule apply to.
        :param str ip_range: The ip range (e.g `192.168.1.0/24`) this rule apply to.
        :param int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The ip this rule apply to.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        """
        The ip range (e.g `192.168.1.0/24`) this rule apply to.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> str:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetInstanceSecurityGroupOutboundRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 ip: str,
                 ip_range: str,
                 port: int,
                 port_range: str,
                 protocol: str):
        """
        :param str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param str ip: The ip this rule apply to.
        :param str ip_range: The ip range (e.g `192.168.1.0/24`) this rule apply to.
        :param int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The ip this rule apply to.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        """
        The ip range (e.g `192.168.1.0/24`) this rule apply to.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> str:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetInstanceServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 mac_address: str,
                 pn_id: str,
                 status: str,
                 zone: str):
        """
        :param str zone: `zone`) The zone in which the server exists.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> str:
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        `zone`) The zone in which the server exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceServerRootVolumeResult(dict):
    def __init__(__self__, *,
                 boot: bool,
                 delete_on_termination: bool,
                 name: str,
                 size_in_gb: int,
                 volume_id: str,
                 volume_type: str):
        """
        :param bool delete_on_termination: Forces deletion of the root volume on instance termination.
        :param str name: The server name. Only one of `name` and `server_id` should be specified.
        :param int size_in_gb: Size of the root volume in gigabytes.
        :param str volume_id: The volume ID of the root volume of the server.
        """
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        pulumi.set(__self__, "volume_id", volume_id)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def boot(self) -> bool:
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> bool:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The server name. Only one of `name` and `server_id` should be specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> int:
        """
        Size of the root volume in gigabytes.
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> str:
        """
        The volume ID of the root volume of the server.
        """
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetInstanceServersServerResult(dict):
    def __init__(__self__, *,
                 boot_type: str,
                 bootscript_id: str,
                 enable_dynamic_ip: bool,
                 enable_ipv6: bool,
                 id: str,
                 image: str,
                 ipv6_address: str,
                 ipv6_gateway: str,
                 ipv6_prefix_length: int,
                 name: str,
                 organization_id: str,
                 placement_group_id: str,
                 placement_group_policy_respected: bool,
                 private_ip: str,
                 project_id: str,
                 public_ip: str,
                 security_group_id: str,
                 state: str,
                 tags: Sequence[str],
                 type: str,
                 zone: str):
        """
        :param str boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param str bootscript_id: The ID of the bootscript.
        :param bool enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param bool enable_ipv6: Determines if IPv6 is enabled for the server.
        :param str id: The ID of the server.
        :param str image: The UUID or the label of the base image used by the server.
        :param str ipv6_address: The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        :param str ipv6_gateway: The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        :param int ipv6_prefix_length: The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        :param str name: The server name used as filter. Servers with a name like it are listed.
        :param str organization_id: The organization ID the server is associated with.
        :param str placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        :param str private_ip: The Scaleway internal IP address of the server.
        :param str project_id: The ID of the project the server is associated with.
        :param str public_ip: The public IPv4 address of the server.
        :param str security_group_id: The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        :param str state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param Sequence[str] tags: List of tags used as filter. Servers with these exact tags are listed.
        :param str type: The commercial type of the server.
        :param str zone: `zone`) The zone in which servers exist.
        """
        pulumi.set(__self__, "boot_type", boot_type)
        pulumi.set(__self__, "bootscript_id", bootscript_id)
        pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        pulumi.set(__self__, "ipv6_prefix_length", ipv6_prefix_length)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "placement_group_id", placement_group_id)
        pulumi.set(__self__, "placement_group_policy_respected", placement_group_policy_respected)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> str:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @property
    @pulumi.getter(name="bootscriptId")
    def bootscript_id(self) -> str:
        """
        The ID of the bootscript.
        """
        return pulumi.get(self, "bootscript_id")

    @property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> bool:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> bool:
        """
        Determines if IPv6 is enabled for the server.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The UUID or the label of the base image used by the server.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> str:
        """
        The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="ipv6PrefixLength")
    def ipv6_prefix_length(self) -> int:
        """
        The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The server name used as filter. Servers with a name like it are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> str:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> bool:
        return pulumi.get(self, "placement_group_policy_respected")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The Scaleway internal IP address of the server.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IPv4 address of the server.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        List of tags used as filter. Servers with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The commercial type of the server.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        `zone`) The zone in which servers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceSnapshotImportResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class GetIotDeviceCertificateResult(dict):
    def __init__(__self__, *,
                 crt: str,
                 key: str):
        pulumi.set(__self__, "crt", crt)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> str:
        return pulumi.get(self, "crt")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class GetIotDeviceMessageFilterResult(dict):
    def __init__(__self__, *,
                 publishes: Sequence['outputs.GetIotDeviceMessageFilterPublishResult'],
                 subscribes: Sequence['outputs.GetIotDeviceMessageFilterSubscribeResult']):
        pulumi.set(__self__, "publishes", publishes)
        pulumi.set(__self__, "subscribes", subscribes)

    @property
    @pulumi.getter
    def publishes(self) -> Sequence['outputs.GetIotDeviceMessageFilterPublishResult']:
        return pulumi.get(self, "publishes")

    @property
    @pulumi.getter
    def subscribes(self) -> Sequence['outputs.GetIotDeviceMessageFilterSubscribeResult']:
        return pulumi.get(self, "subscribes")


@pulumi.output_type
class GetIotDeviceMessageFilterPublishResult(dict):
    def __init__(__self__, *,
                 policy: str,
                 topics: Sequence[str]):
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Sequence[str]:
        return pulumi.get(self, "topics")


@pulumi.output_type
class GetIotDeviceMessageFilterSubscribeResult(dict):
    def __init__(__self__, *,
                 policy: str,
                 topics: Sequence[str]):
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Sequence[str]:
        return pulumi.get(self, "topics")


@pulumi.output_type
class GetK8sClusterAutoUpgradeResult(dict):
    def __init__(__self__, *,
                 enable: bool,
                 maintenance_window_day: str,
                 maintenance_window_start_hour: int):
        """
        :param bool enable: True if Kubernetes patch version auto upgrades is enabled.
        :param str maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param int maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        True if Kubernetes patch version auto upgrades is enabled.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> str:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> int:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")


@pulumi.output_type
class GetK8sClusterAutoscalerConfigResult(dict):
    def __init__(__self__, *,
                 balance_similar_node_groups: bool,
                 disable_scale_down: bool,
                 estimator: str,
                 expander: str,
                 expendable_pods_priority_cutoff: int,
                 ignore_daemonsets_utilization: bool,
                 max_graceful_termination_sec: int,
                 scale_down_delay_after_add: str,
                 scale_down_unneeded_time: str,
                 scale_down_utilization_threshold: float):
        """
        :param bool balance_similar_node_groups: True if detecting similar node groups and balance the number of nodes between them is enabled.
        :param bool disable_scale_down: True if the scale down feature of the autoscaler is disabled.
        :param str estimator: The type of resource estimator used in scale up.
        :param str expander: The type of node group expander be used in scale up.
        :param int expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param bool ignore_daemonsets_utilization: True if ignoring DaemonSet pods when calculating resource utilization for scaling down is enabled.
        :param str scale_down_delay_after_add: The duration after scale up that scale down evaluation resumes.
        :param str scale_down_unneeded_time: The duration a node should be unneeded before it is eligible for scale down.
        """
        pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        pulumi.set(__self__, "estimator", estimator)
        pulumi.set(__self__, "expander", expander)
        pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> bool:
        """
        True if detecting similar node groups and balance the number of nodes between them is enabled.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> bool:
        """
        True if the scale down feature of the autoscaler is disabled.
        """
        return pulumi.get(self, "disable_scale_down")

    @property
    @pulumi.getter
    def estimator(self) -> str:
        """
        The type of resource estimator used in scale up.
        """
        return pulumi.get(self, "estimator")

    @property
    @pulumi.getter
    def expander(self) -> str:
        """
        The type of node group expander be used in scale up.
        """
        return pulumi.get(self, "expander")

    @property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> int:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> bool:
        """
        True if ignoring DaemonSet pods when calculating resource utilization for scaling down is enabled.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> int:
        return pulumi.get(self, "max_graceful_termination_sec")

    @property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> str:
        """
        The duration after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> str:
        """
        The duration a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> float:
        return pulumi.get(self, "scale_down_utilization_threshold")


@pulumi.output_type
class GetK8sClusterKubeconfigResult(dict):
    def __init__(__self__, *,
                 cluster_ca_certificate: str,
                 config_file: str,
                 host: str,
                 token: str):
        """
        :param str cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param str config_file: The raw kubeconfig file.
        :param str host: The URL of the Kubernetes API server.
        :param str token: The token to connect to the Kubernetes API server.
        """
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "config_file", config_file)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> str:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> str:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetK8sClusterOpenIdConnectConfigResult(dict):
    def __init__(__self__, *,
                 client_id: str,
                 groups_claims: Sequence[str],
                 groups_prefix: str,
                 issuer_url: str,
                 required_claims: Sequence[str],
                 username_claim: str,
                 username_prefix: str):
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "groups_claims", groups_claims)
        pulumi.set(__self__, "groups_prefix", groups_prefix)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "required_claims", required_claims)
        pulumi.set(__self__, "username_claim", username_claim)
        pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Sequence[str]:
        return pulumi.get(self, "groups_claims")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> str:
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Sequence[str]:
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> str:
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> str:
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class GetK8sPoolNodeResult(dict):
    def __init__(__self__, *,
                 name: str,
                 public_ip: str,
                 public_ip_v6: str,
                 status: str):
        """
        :param str name: The pool name. Only one of `name` and `pool_id` should be specified. `cluster_id` should be specified with `name`.
        :param str public_ip: The public IPv4.
        :param str public_ip_v6: The public IPv6.
        :param str status: The status of the node.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The pool name. Only one of `name` and `pool_id` should be specified. `cluster_id` should be specified with `name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IPv4.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIpV6")
    def public_ip_v6(self) -> str:
        """
        The public IPv6.
        """
        return pulumi.get(self, "public_ip_v6")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetK8sPoolUpgradePolicyResult(dict):
    def __init__(__self__, *,
                 max_surge: int,
                 max_unavailable: int):
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> int:
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> int:
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class GetLbAclsAclResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetLbAclsAclActionResult'],
                 created_at: str,
                 description: str,
                 frontend_id: str,
                 id: str,
                 index: int,
                 matches: Sequence['outputs.GetLbAclsAclMatchResult'],
                 name: str,
                 update_at: str):
        """
        :param Sequence['GetLbAclsAclActionArgs'] actions: The action that has been undertaken when an ACL filter had matched.
        :param str created_at: The date at which the ACL was created (RFC 3339 format).
        :param str description: The description of the ACL resource.
        :param str frontend_id: The frontend ID this ACL is attached to. ACLs with a frontend ID like it are listed.
               > **Important:** LB Frontends' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param str id: The associated ACL ID.
               > **Important:** LB ACLs' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param int index: The order between the ACLs.
        :param Sequence['GetLbAclsAclMatchArgs'] matches: The ACL match rule.
        :param str name: The ACL name used as filter. ACLs with a name like it are listed.
        :param str update_at: The date at which the ACL was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "frontend_id", frontend_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "matches", matches)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "update_at", update_at)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetLbAclsAclActionResult']:
        """
        The action that has been undertaken when an ACL filter had matched.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date at which the ACL was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the ACL resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> str:
        """
        The frontend ID this ACL is attached to. ACLs with a frontend ID like it are listed.
        > **Important:** LB Frontends' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The associated ACL ID.
        > **Important:** LB ACLs' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        The order between the ACLs.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetLbAclsAclMatchResult']:
        """
        The ACL match rule.
        """
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The ACL name used as filter. ACLs with a name like it are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> str:
        """
        The date at which the ACL was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetLbAclsAclActionResult(dict):
    def __init__(__self__, *,
                 type: str):
        """
        :param str type: The action type.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The action type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLbAclsAclMatchResult(dict):
    def __init__(__self__, *,
                 http_filter: str,
                 http_filter_option: str,
                 http_filter_values: Sequence[str],
                 invert: bool,
                 ip_subnets: Sequence[str]):
        """
        :param str http_filter: The matched HTTP filter.
        :param Sequence[str] http_filter_values: The possible values matched for a given HTTP filter.
        :param bool invert: The condition will be of type "unless" if invert is set to `true`
        :param Sequence[str] ip_subnets: A list of matched IPs or CIDR v4/v6 addresses of the client of the session.
        """
        pulumi.set(__self__, "http_filter", http_filter)
        pulumi.set(__self__, "http_filter_option", http_filter_option)
        pulumi.set(__self__, "http_filter_values", http_filter_values)
        pulumi.set(__self__, "invert", invert)
        pulumi.set(__self__, "ip_subnets", ip_subnets)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> str:
        """
        The matched HTTP filter.
        """
        return pulumi.get(self, "http_filter")

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> str:
        return pulumi.get(self, "http_filter_option")

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Sequence[str]:
        """
        The possible values matched for a given HTTP filter.
        """
        return pulumi.get(self, "http_filter_values")

    @property
    @pulumi.getter
    def invert(self) -> bool:
        """
        The condition will be of type "unless" if invert is set to `true`
        """
        return pulumi.get(self, "invert")

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Sequence[str]:
        """
        A list of matched IPs or CIDR v4/v6 addresses of the client of the session.
        """
        return pulumi.get(self, "ip_subnets")


@pulumi.output_type
class GetLbBackendHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 code: int,
                 host_header: str,
                 method: str,
                 sni: str,
                 uri: str):
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "sni", sni)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def code(self) -> int:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> str:
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def method(self) -> str:
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def sni(self) -> str:
        return pulumi.get(self, "sni")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetLbBackendHealthCheckTcpResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetLbBackendsBackendResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 failover_host: str,
                 forward_port: int,
                 forward_port_algorithm: str,
                 forward_protocol: str,
                 health_check_delay: str,
                 health_check_http: Sequence['outputs.GetLbBackendsBackendHealthCheckHttpResult'],
                 health_check_https: Sequence['outputs.GetLbBackendsBackendHealthCheckHttpResult'],
                 health_check_max_retries: int,
                 health_check_port: int,
                 health_check_tcps: Sequence['outputs.GetLbBackendsBackendHealthCheckTcpResult'],
                 health_check_timeout: str,
                 id: str,
                 ignore_ssl_server_verify: bool,
                 lb_id: str,
                 name: str,
                 on_marked_down_action: str,
                 proxy_protocol: str,
                 server_ips: Sequence[str],
                 ssl_bridging: bool,
                 sticky_sessions: str,
                 sticky_sessions_cookie_name: str,
                 timeout_connect: str,
                 timeout_server: str,
                 timeout_tunnel: str,
                 update_at: str):
        """
        :param str created_at: The date at which the backend was created (RFC 3339 format).
        :param str failover_host: Scaleway S3 bucket website to be served in case all backend servers are down.
        :param int forward_port: User sessions will be forwarded to this port of backend servers.
        :param str forward_port_algorithm: Load balancing algorithm.
        :param str forward_protocol: Backend protocol.
        :param str health_check_delay: Interval between two HC requests.
        :param Sequence['GetLbBackendsBackendHealthCheckHttpArgs'] health_check_http: This block enable HTTP health check.
        :param Sequence['GetLbBackendsBackendHealthCheckHttpArgs'] health_check_https: This block enable HTTPS health check.
        :param int health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down.
        :param int health_check_port: Port the HC requests will be sent to.
        :param Sequence['GetLbBackendsBackendHealthCheckTcpArgs'] health_check_tcps: This block enable TCP health check.
        :param str health_check_timeout: Timeout before we consider a HC request failed.
        :param str id: The associated backend ID.
        :param bool ignore_ssl_server_verify: Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection.
        :param str lb_id: The load-balancer ID this backend is attached to. backends with a LB ID like it are listed.
        :param str name: The backend name used as filter. Backends with a name like it are listed.
        :param str on_marked_down_action: Modify what occurs when a backend server is marked down.
        :param str proxy_protocol: The type of PROXY protocol.
        :param Sequence[str] server_ips: List of backend server IP addresses.
        :param bool ssl_bridging: Enables SSL between load balancer and backend servers.
        :param str sticky_sessions: Enables cookie-based session persistence.
        :param str sticky_sessions_cookie_name: Cookie name for sticky sessions.
        :param str timeout_connect: Maximum initial server connection establishment time.
        :param str timeout_server: Maximum server connection inactivity time.
        :param str timeout_tunnel: Maximum tunnel inactivity time.
        :param str update_at: The date at which the backend was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "failover_host", failover_host)
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "forward_port_algorithm", forward_port_algorithm)
        pulumi.set(__self__, "forward_protocol", forward_protocol)
        pulumi.set(__self__, "health_check_delay", health_check_delay)
        pulumi.set(__self__, "health_check_http", health_check_http)
        pulumi.set(__self__, "health_check_https", health_check_https)
        pulumi.set(__self__, "health_check_max_retries", health_check_max_retries)
        pulumi.set(__self__, "health_check_port", health_check_port)
        pulumi.set(__self__, "health_check_tcps", health_check_tcps)
        pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ignore_ssl_server_verify", ignore_ssl_server_verify)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "on_marked_down_action", on_marked_down_action)
        pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        pulumi.set(__self__, "server_ips", server_ips)
        pulumi.set(__self__, "ssl_bridging", ssl_bridging)
        pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        pulumi.set(__self__, "sticky_sessions_cookie_name", sticky_sessions_cookie_name)
        pulumi.set(__self__, "timeout_connect", timeout_connect)
        pulumi.set(__self__, "timeout_server", timeout_server)
        pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)
        pulumi.set(__self__, "update_at", update_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date at which the backend was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="failoverHost")
    def failover_host(self) -> str:
        """
        Scaleway S3 bucket website to be served in case all backend servers are down.
        """
        return pulumi.get(self, "failover_host")

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> int:
        """
        User sessions will be forwarded to this port of backend servers.
        """
        return pulumi.get(self, "forward_port")

    @property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> str:
        """
        Load balancing algorithm.
        """
        return pulumi.get(self, "forward_port_algorithm")

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> str:
        """
        Backend protocol.
        """
        return pulumi.get(self, "forward_protocol")

    @property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> str:
        """
        Interval between two HC requests.
        """
        return pulumi.get(self, "health_check_delay")

    @property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> Sequence['outputs.GetLbBackendsBackendHealthCheckHttpResult']:
        """
        This block enable HTTP health check.
        """
        return pulumi.get(self, "health_check_http")

    @property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> Sequence['outputs.GetLbBackendsBackendHealthCheckHttpResult']:
        """
        This block enable HTTPS health check.
        """
        return pulumi.get(self, "health_check_https")

    @property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> int:
        """
        Number of allowed failed HC requests before the backend server is marked down.
        """
        return pulumi.get(self, "health_check_max_retries")

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> int:
        """
        Port the HC requests will be sent to.
        """
        return pulumi.get(self, "health_check_port")

    @property
    @pulumi.getter(name="healthCheckTcps")
    def health_check_tcps(self) -> Sequence['outputs.GetLbBackendsBackendHealthCheckTcpResult']:
        """
        This block enable TCP health check.
        """
        return pulumi.get(self, "health_check_tcps")

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> str:
        """
        Timeout before we consider a HC request failed.
        """
        return pulumi.get(self, "health_check_timeout")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The associated backend ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreSslServerVerify")
    def ignore_ssl_server_verify(self) -> bool:
        """
        Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection.
        """
        return pulumi.get(self, "ignore_ssl_server_verify")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> str:
        """
        The load-balancer ID this backend is attached to. backends with a LB ID like it are listed.
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The backend name used as filter. Backends with a name like it are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> str:
        """
        Modify what occurs when a backend server is marked down.
        """
        return pulumi.get(self, "on_marked_down_action")

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> str:
        """
        The type of PROXY protocol.
        """
        return pulumi.get(self, "proxy_protocol")

    @property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Sequence[str]:
        """
        List of backend server IP addresses.
        """
        return pulumi.get(self, "server_ips")

    @property
    @pulumi.getter(name="sslBridging")
    def ssl_bridging(self) -> bool:
        """
        Enables SSL between load balancer and backend servers.
        """
        return pulumi.get(self, "ssl_bridging")

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> str:
        """
        Enables cookie-based session persistence.
        """
        return pulumi.get(self, "sticky_sessions")

    @property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> str:
        """
        Cookie name for sticky sessions.
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> str:
        """
        Maximum initial server connection establishment time.
        """
        return pulumi.get(self, "timeout_connect")

    @property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> str:
        """
        Maximum server connection inactivity time.
        """
        return pulumi.get(self, "timeout_server")

    @property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> str:
        """
        Maximum tunnel inactivity time.
        """
        return pulumi.get(self, "timeout_tunnel")

    @property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> str:
        """
        The date at which the backend was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetLbBackendsBackendHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 code: int,
                 host_header: str,
                 method: str,
                 sni: str,
                 uri: str):
        """
        :param int code: The expected HTTP status code.
        :param str host_header: The HTTP host header to use for HC requests.
        :param str method: The HTTP method to use for HC requests.
        :param str sni: The SNI to use for HC requests over SSL.
        :param str uri: The HTTPS endpoint URL to call for HC requests.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "sni", sni)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The expected HTTP status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> str:
        """
        The HTTP host header to use for HC requests.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The HTTP method to use for HC requests.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def sni(self) -> str:
        """
        The SNI to use for HC requests over SSL.
        """
        return pulumi.get(self, "sni")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The HTTPS endpoint URL to call for HC requests.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetLbBackendsBackendHealthCheckTcpResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetLbCertificateCustomCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_chain: str):
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> str:
        return pulumi.get(self, "certificate_chain")


@pulumi.output_type
class GetLbCertificateLetsencryptResult(dict):
    def __init__(__self__, *,
                 common_name: str,
                 subject_alternative_names: Sequence[str]):
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence[str]:
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class GetLbFrontendAclResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetLbFrontendAclActionResult'],
                 matches: Sequence['outputs.GetLbFrontendAclMatchResult'],
                 name: str):
        """
        :param str name: The name of the frontend.
               - When using the `name` you should specify the `lb-id`
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "matches", matches)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetLbFrontendAclActionResult']:
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetLbFrontendAclMatchResult']:
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the frontend.
        - When using the `name` you should specify the `lb-id`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLbFrontendAclActionResult(dict):
    def __init__(__self__, *,
                 type: str):
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLbFrontendAclMatchResult(dict):
    def __init__(__self__, *,
                 http_filter: str,
                 http_filter_option: str,
                 http_filter_values: Sequence[str],
                 invert: bool,
                 ip_subnets: Sequence[str]):
        pulumi.set(__self__, "http_filter", http_filter)
        pulumi.set(__self__, "http_filter_option", http_filter_option)
        pulumi.set(__self__, "http_filter_values", http_filter_values)
        pulumi.set(__self__, "invert", invert)
        pulumi.set(__self__, "ip_subnets", ip_subnets)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> str:
        return pulumi.get(self, "http_filter")

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> str:
        return pulumi.get(self, "http_filter_option")

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Sequence[str]:
        return pulumi.get(self, "http_filter_values")

    @property
    @pulumi.getter
    def invert(self) -> bool:
        return pulumi.get(self, "invert")

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Sequence[str]:
        return pulumi.get(self, "ip_subnets")


@pulumi.output_type
class GetLbFrontendsFrontendResult(dict):
    def __init__(__self__, *,
                 backend_id: str,
                 certificate_ids: Sequence[str],
                 created_at: str,
                 enable_http3: bool,
                 id: str,
                 inbound_port: int,
                 lb_id: str,
                 name: str,
                 timeout_client: str,
                 update_at: str):
        """
        :param str backend_id: The load-balancer backend ID this frontend is attached to.
               > **Important:** LB backends' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param Sequence[str] certificate_ids: List of Certificate IDs that are used by the frontend.
        :param str created_at: The date at which the frontend was created (RFC 3339 format).
        :param bool enable_http3: If HTTP/3 protocol is activated.
        :param str id: The associated frontend ID.
               > **Important:** LB frontends' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param int inbound_port: TCP port the frontend listen to.
        :param str lb_id: The load-balancer ID this frontend is attached to. frontends with a LB ID like it are listed.
        :param str name: The frontend name used as filter. Frontends with a name like it are listed.
        :param str timeout_client: Maximum inactivity time on the client side.
        :param str update_at: The date at which the frontend was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "enable_http3", enable_http3)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inbound_port", inbound_port)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "timeout_client", timeout_client)
        pulumi.set(__self__, "update_at", update_at)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> str:
        """
        The load-balancer backend ID this frontend is attached to.
        > **Important:** LB backends' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "backend_id")

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Sequence[str]:
        """
        List of Certificate IDs that are used by the frontend.
        """
        return pulumi.get(self, "certificate_ids")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date at which the frontend was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="enableHttp3")
    def enable_http3(self) -> bool:
        """
        If HTTP/3 protocol is activated.
        """
        return pulumi.get(self, "enable_http3")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The associated frontend ID.
        > **Important:** LB frontends' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inboundPort")
    def inbound_port(self) -> int:
        """
        TCP port the frontend listen to.
        """
        return pulumi.get(self, "inbound_port")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> str:
        """
        The load-balancer ID this frontend is attached to. frontends with a LB ID like it are listed.
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The frontend name used as filter. Frontends with a name like it are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="timeoutClient")
    def timeout_client(self) -> str:
        """
        Maximum inactivity time on the client side.
        """
        return pulumi.get(self, "timeout_client")

    @property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> str:
        """
        The date at which the frontend was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetLbIpsIpResult(dict):
    def __init__(__self__, *,
                 id: str,
                 ip_address: str,
                 lb_id: str,
                 organization_id: str,
                 project_id: str,
                 reverse: str,
                 zone: str):
        """
        :param str id: The associated IP ID.
        :param str ip_address: The IP Address
        :param str lb_id: The associated load-balancer ID if any
        :param str organization_id: The organization ID the load-balancer is associated with.
        :param str project_id: The ID of the project the load-balancer is associated with.
        :param str reverse: The reverse domain associated with this IP.
        :param str zone: `zone`) The zone in which IPs exist.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The associated IP ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP Address
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> str:
        """
        The associated load-balancer ID if any
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization ID the load-balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project the load-balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def reverse(self) -> str:
        """
        The reverse domain associated with this IP.
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        `zone`) The zone in which IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLbPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 dhcp_config: bool,
                 private_network_id: str,
                 static_configs: Sequence[str],
                 status: str,
                 zone: str):
        """
        :param str zone: (Defaults to provider `zone`) The zone in which the LB exists.
        """
        pulumi.set(__self__, "dhcp_config", dhcp_config)
        pulumi.set(__self__, "private_network_id", private_network_id)
        pulumi.set(__self__, "static_configs", static_configs)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="dhcpConfig")
    def dhcp_config(self) -> bool:
        return pulumi.get(self, "dhcp_config")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> str:
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="staticConfigs")
    def static_configs(self) -> Sequence[str]:
        return pulumi.get(self, "static_configs")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        (Defaults to provider `zone`) The zone in which the LB exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLbRoutesRouteResult(dict):
    def __init__(__self__, *,
                 backend_id: str,
                 created_at: str,
                 frontend_id: str,
                 id: str,
                 match_host_header: str,
                 match_sni: str,
                 update_at: str):
        """
        :param str backend_id: The backend ID destination of redirection
        :param str created_at: The date at which the route was created (RFC 3339 format).
        :param str frontend_id: The frontend ID origin of redirection used as a filter. routes with a frontend ID like it are listed.
        :param str id: The associated route ID.
        :param str match_host_header: Specifies the host of the server to which the request is being sent.
        :param str match_sni: Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        :param str update_at: The date at which the route was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "frontend_id", frontend_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "match_host_header", match_host_header)
        pulumi.set(__self__, "match_sni", match_sni)
        pulumi.set(__self__, "update_at", update_at)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> str:
        """
        The backend ID destination of redirection
        """
        return pulumi.get(self, "backend_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date at which the route was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> str:
        """
        The frontend ID origin of redirection used as a filter. routes with a frontend ID like it are listed.
        """
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The associated route ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="matchHostHeader")
    def match_host_header(self) -> str:
        """
        Specifies the host of the server to which the request is being sent.
        """
        return pulumi.get(self, "match_host_header")

    @property
    @pulumi.getter(name="matchSni")
    def match_sni(self) -> str:
        """
        Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        """
        return pulumi.get(self, "match_sni")

    @property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> str:
        """
        The date at which the route was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetLbsLbResult(dict):
    def __init__(__self__, *,
                 backend_count: int,
                 created_at: str,
                 description: str,
                 frontend_count: int,
                 id: str,
                 instances: Sequence['outputs.GetLbsLbInstanceResult'],
                 ips: Sequence['outputs.GetLbsLbIpResult'],
                 name: str,
                 organization_id: str,
                 private_network_count: int,
                 project_id: str,
                 route_count: int,
                 ssl_compatibility_level: str,
                 status: str,
                 subscriber: str,
                 tags: Sequence[str],
                 type: str,
                 updated_at: str,
                 zone: str):
        """
        :param int backend_count: Number of backends the Load balancer has.
        :param str created_at: Date at which the Load balancer was created.
        :param str description: The description of the load-balancer.
        :param int frontend_count: Number of frontends the Load balancer has.
        :param str id: The ID of the load-balancer.
        :param Sequence['GetLbsLbInstanceArgs'] instances: List of underlying instances.
        :param Sequence['GetLbsLbIpArgs'] ips: List of IPs attached to the Load balancer.
        :param str name: The load balancer name used as a filter. LBs with a name like it are listed.
        :param str organization_id: The organization ID the load-balancer is associated with.
        :param int private_network_count: Number of private networks attached to the Load balancer.
        :param str project_id: The ID of the project the load-balancer is associated with.
        :param int route_count: Number of routes the Load balancer has.
        :param str ssl_compatibility_level: Determines the minimal SSL version which needs to be supported on client side.
        :param str status: The state of the LB's instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        :param str subscriber: The subscriber information.
        :param Sequence[str] tags: The tags associated with the load-balancer.
        :param str type: The offer type of the load-balancer.
        :param str updated_at: Date at which the Load balancer was updated.
        :param str zone: `zone`) The zone in which LBs exist.
        """
        pulumi.set(__self__, "backend_count", backend_count)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "frontend_count", frontend_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "private_network_count", private_network_count)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "route_count", route_count)
        pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subscriber", subscriber)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="backendCount")
    def backend_count(self) -> int:
        """
        Number of backends the Load balancer has.
        """
        return pulumi.get(self, "backend_count")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Date at which the Load balancer was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the load-balancer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frontendCount")
    def frontend_count(self) -> int:
        """
        Number of frontends the Load balancer has.
        """
        return pulumi.get(self, "frontend_count")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the load-balancer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetLbsLbInstanceResult']:
        """
        List of underlying instances.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetLbsLbIpResult']:
        """
        List of IPs attached to the Load balancer.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The load balancer name used as a filter. LBs with a name like it are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization ID the load-balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="privateNetworkCount")
    def private_network_count(self) -> int:
        """
        Number of private networks attached to the Load balancer.
        """
        return pulumi.get(self, "private_network_count")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project the load-balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="routeCount")
    def route_count(self) -> int:
        """
        Number of routes the Load balancer has.
        """
        return pulumi.get(self, "route_count")

    @property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> str:
        """
        Determines the minimal SSL version which needs to be supported on client side.
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The state of the LB's instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subscriber(self) -> str:
        """
        The subscriber information.
        """
        return pulumi.get(self, "subscriber")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        The tags associated with the load-balancer.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The offer type of the load-balancer.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Date at which the Load balancer was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        `zone`) The zone in which LBs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLbsLbInstanceResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 id: str,
                 ip_address: str,
                 status: str,
                 updated_at: str,
                 zone: str):
        """
        :param str created_at: Date at which the Load balancer was created.
        :param str id: The ID of the load-balancer.
        :param str status: The state of the LB's instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        :param str updated_at: Date at which the Load balancer was updated.
        :param str zone: `zone`) The zone in which LBs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Date at which the Load balancer was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the load-balancer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The state of the LB's instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Date at which the Load balancer was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        `zone`) The zone in which LBs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLbsLbIpResult(dict):
    def __init__(__self__, *,
                 id: str,
                 ip_address: str,
                 lb_id: str,
                 organization_id: str,
                 project_id: str,
                 reverse: str,
                 zone: str):
        """
        :param str id: The ID of the load-balancer.
        :param str organization_id: The organization ID the load-balancer is associated with.
        :param str project_id: The ID of the project the load-balancer is associated with.
        :param str zone: `zone`) The zone in which LBs exist.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the load-balancer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> str:
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization ID the load-balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project the load-balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def reverse(self) -> str:
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        `zone`) The zone in which LBs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetObjectBucketCorsRuleResult(dict):
    def __init__(__self__, *,
                 allowed_headers: Sequence[str],
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 expose_headers: Sequence[str],
                 max_age_seconds: int):
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[str]:
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> int:
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class GetObjectBucketLifecycleRuleResult(dict):
    def __init__(__self__, *,
                 abort_incomplete_multipart_upload_days: int,
                 enabled: bool,
                 expirations: Sequence['outputs.GetObjectBucketLifecycleRuleExpirationResult'],
                 id: str,
                 prefix: str,
                 tags: Mapping[str, str],
                 transitions: Sequence['outputs.GetObjectBucketLifecycleRuleTransitionResult']):
        """
        :param str id: The unique name of the bucket.
        """
        pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expirations", expirations)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> int:
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expirations(self) -> Sequence['outputs.GetObjectBucketLifecycleRuleExpirationResult']:
        return pulumi.get(self, "expirations")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique name of the bucket.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def transitions(self) -> Sequence['outputs.GetObjectBucketLifecycleRuleTransitionResult']:
        return pulumi.get(self, "transitions")


@pulumi.output_type
class GetObjectBucketLifecycleRuleExpirationResult(dict):
    def __init__(__self__, *,
                 days: int):
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> int:
        return pulumi.get(self, "days")


@pulumi.output_type
class GetObjectBucketLifecycleRuleTransitionResult(dict):
    def __init__(__self__, *,
                 days: int,
                 storage_class: str):
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def days(self) -> int:
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetObjectBucketVersioningResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetRdbAclAclRuleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 ip: str):
        """
        :param str description: A simple text describing this rule
        :param str ip: The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A simple text describing this rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetRdbInstanceLoadBalancerResult(dict):
    def __init__(__self__, *,
                 endpoint_id: str,
                 hostname: str,
                 ip: str,
                 name: str,
                 port: int):
        """
        :param str name: The name of the RDB instance.
               Only one of `name` and `instance_id` should be specified.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the RDB instance.
        Only one of `name` and `instance_id` should be specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRdbInstancePrivateNetworkResult(dict):
    def __init__(__self__, *,
                 endpoint_id: str,
                 hostname: str,
                 ip: str,
                 ip_net: str,
                 name: str,
                 pn_id: str,
                 port: int,
                 zone: str):
        """
        :param str name: The name of the RDB instance.
               Only one of `name` and `instance_id` should be specified.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_net", ip_net)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> str:
        return pulumi.get(self, "ip_net")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the RDB instance.
        Only one of `name` and `instance_id` should be specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> str:
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetRdbInstanceReadReplicaResult(dict):
    def __init__(__self__, *,
                 ip: str,
                 name: str,
                 port: int):
        """
        :param str name: The name of the RDB instance.
               Only one of `name` and `instance_id` should be specified.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the RDB instance.
        Only one of `name` and `instance_id` should be specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRedisClusterAclResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 ip: str):
        """
        :param str id: The ID of the Redis cluster.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetRedisClusterPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 endpoint_id: str,
                 id: str,
                 service_ips: Sequence[str],
                 zone: str):
        """
        :param str id: The ID of the Redis cluster.
        :param str zone: `region`) The zone in which the server exists.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_ips", service_ips)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> Sequence[str]:
        return pulumi.get(self, "service_ips")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        `region`) The zone in which the server exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetRedisClusterPublicNetworkResult(dict):
    def __init__(__self__, *,
                 id: str,
                 ips: Sequence[str],
                 port: int):
        """
        :param str id: The ID of the Redis cluster.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ips(self) -> Sequence[str]:
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")


@pulumi.output_type
class GetWebHostOfferProductResult(dict):
    def __init__(__self__, *,
                 databases_quota: int,
                 email_accounts_quota: int,
                 email_storage_quota: int,
                 hosting_storage_quota: int,
                 name: str,
                 option: bool,
                 ram: int,
                 support_included: bool,
                 v_cpu: int):
        """
        :param int databases_quota: The quota of databases.
        :param int email_accounts_quota: The quota of email accounts.
        :param int email_storage_quota: The quota of email storage.
        :param int hosting_storage_quota: The quota of hosting storage.
        :param str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param bool option: The product option.
        :param int ram: The capacity of the memory in GB.
        :param bool support_included: If support is included.
        :param int v_cpu: The number of cores.
        """
        pulumi.set(__self__, "databases_quota", databases_quota)
        pulumi.set(__self__, "email_accounts_quota", email_accounts_quota)
        pulumi.set(__self__, "email_storage_quota", email_storage_quota)
        pulumi.set(__self__, "hosting_storage_quota", hosting_storage_quota)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "option", option)
        pulumi.set(__self__, "ram", ram)
        pulumi.set(__self__, "support_included", support_included)
        pulumi.set(__self__, "v_cpu", v_cpu)

    @property
    @pulumi.getter(name="databasesQuota")
    def databases_quota(self) -> int:
        """
        The quota of databases.
        """
        return pulumi.get(self, "databases_quota")

    @property
    @pulumi.getter(name="emailAccountsQuota")
    def email_accounts_quota(self) -> int:
        """
        The quota of email accounts.
        """
        return pulumi.get(self, "email_accounts_quota")

    @property
    @pulumi.getter(name="emailStorageQuota")
    def email_storage_quota(self) -> int:
        """
        The quota of email storage.
        """
        return pulumi.get(self, "email_storage_quota")

    @property
    @pulumi.getter(name="hostingStorageQuota")
    def hosting_storage_quota(self) -> int:
        """
        The quota of hosting storage.
        """
        return pulumi.get(self, "hosting_storage_quota")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def option(self) -> bool:
        """
        The product option.
        """
        return pulumi.get(self, "option")

    @property
    @pulumi.getter
    def ram(self) -> int:
        """
        The capacity of the memory in GB.
        """
        return pulumi.get(self, "ram")

    @property
    @pulumi.getter(name="supportIncluded")
    def support_included(self) -> bool:
        """
        If support is included.
        """
        return pulumi.get(self, "support_included")

    @property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> int:
        """
        The number of cores.
        """
        return pulumi.get(self, "v_cpu")


