# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['LbRouteArgs', 'LbRoute']

@pulumi.input_type
class LbRouteArgs:
    def __init__(__self__, *,
                 backend_id: pulumi.Input[str],
                 frontend_id: pulumi.Input[str],
                 match_host_header: Optional[pulumi.Input[str]] = None,
                 match_sni: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LbRoute resource.
        :param pulumi.Input[str] backend_id: The ID of the backend to which the route is associated.
        :param pulumi.Input[str] frontend_id: The ID of the frontend to which the route is associated.
        :param pulumi.Input[str] match_host_header: The Host request header specifies the host of the server to which the request is being sent.
               Only one of `match_sni` and `match_host_header` should be specified.
        :param pulumi.Input[str] match_sni: The Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
               Only one of `match_sni` and `match_host_header` should be specified.
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "frontend_id", frontend_id)
        if match_host_header is not None:
            pulumi.set(__self__, "match_host_header", match_host_header)
        if match_sni is not None:
            pulumi.set(__self__, "match_sni", match_sni)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> pulumi.Input[str]:
        """
        The ID of the backend to which the route is associated.
        """
        return pulumi.get(self, "backend_id")

    @backend_id.setter
    def backend_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend_id", value)

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> pulumi.Input[str]:
        """
        The ID of the frontend to which the route is associated.
        """
        return pulumi.get(self, "frontend_id")

    @frontend_id.setter
    def frontend_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "frontend_id", value)

    @property
    @pulumi.getter(name="matchHostHeader")
    def match_host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The Host request header specifies the host of the server to which the request is being sent.
        Only one of `match_sni` and `match_host_header` should be specified.
        """
        return pulumi.get(self, "match_host_header")

    @match_host_header.setter
    def match_host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_host_header", value)

    @property
    @pulumi.getter(name="matchSni")
    def match_sni(self) -> Optional[pulumi.Input[str]]:
        """
        The Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        Only one of `match_sni` and `match_host_header` should be specified.
        """
        return pulumi.get(self, "match_sni")

    @match_sni.setter
    def match_sni(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_sni", value)


@pulumi.input_type
class _LbRouteState:
    def __init__(__self__, *,
                 backend_id: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 frontend_id: Optional[pulumi.Input[str]] = None,
                 match_host_header: Optional[pulumi.Input[str]] = None,
                 match_sni: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LbRoute resources.
        :param pulumi.Input[str] backend_id: The ID of the backend to which the route is associated.
        :param pulumi.Input[str] created_at: The date at which the route was created.
        :param pulumi.Input[str] frontend_id: The ID of the frontend to which the route is associated.
        :param pulumi.Input[str] match_host_header: The Host request header specifies the host of the server to which the request is being sent.
               Only one of `match_sni` and `match_host_header` should be specified.
        :param pulumi.Input[str] match_sni: The Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
               Only one of `match_sni` and `match_host_header` should be specified.
        :param pulumi.Input[str] updated_at: The date at which the route was last updated.
        """
        if backend_id is not None:
            pulumi.set(__self__, "backend_id", backend_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if frontend_id is not None:
            pulumi.set(__self__, "frontend_id", frontend_id)
        if match_host_header is not None:
            pulumi.set(__self__, "match_host_header", match_host_header)
        if match_sni is not None:
            pulumi.set(__self__, "match_sni", match_sni)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the backend to which the route is associated.
        """
        return pulumi.get(self, "backend_id")

    @backend_id.setter
    def backend_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date at which the route was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the frontend to which the route is associated.
        """
        return pulumi.get(self, "frontend_id")

    @frontend_id.setter
    def frontend_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frontend_id", value)

    @property
    @pulumi.getter(name="matchHostHeader")
    def match_host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The Host request header specifies the host of the server to which the request is being sent.
        Only one of `match_sni` and `match_host_header` should be specified.
        """
        return pulumi.get(self, "match_host_header")

    @match_host_header.setter
    def match_host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_host_header", value)

    @property
    @pulumi.getter(name="matchSni")
    def match_sni(self) -> Optional[pulumi.Input[str]]:
        """
        The Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        Only one of `match_sni` and `match_host_header` should be specified.
        """
        return pulumi.get(self, "match_sni")

    @match_sni.setter
    def match_sni(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_sni", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date at which the route was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class LbRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_id: Optional[pulumi.Input[str]] = None,
                 frontend_id: Optional[pulumi.Input[str]] = None,
                 match_host_header: Optional[pulumi.Input[str]] = None,
                 match_sni: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Load-Balancer Routes. For more information, see [the documentation](https://developers.scaleway.com/en/products/lb/zoned_api/#route-ff94b7).
        It is useful to manage the Service Name Indicator (SNI) for a route between a frontend and a backend.

        ## Examples

        ### With SNI

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        ip01 = scaleway.LbIp("ip01")
        lb01 = scaleway.Lb("lb01",
            ip_id=ip01.id,
            type="lb-s")
        bkd01 = scaleway.LbBackend("bkd01",
            lb_id=lb01.id,
            forward_protocol="tcp",
            forward_port=80,
            proxy_protocol="none")
        frt01 = scaleway.LbFrontend("frt01",
            lb_id=lb01.id,
            backend_id=bkd01.id,
            inbound_port=80)
        rt01 = scaleway.LbRoute("rt01",
            frontend_id=frt01.id,
            backend_id=bkd01.id,
            match_sni="sni.scaleway.com")
        ```

        ### With host-header

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        ip01 = scaleway.LbIp("ip01")
        lb01 = scaleway.Lb("lb01",
            ip_id=ip01.id,
            type="lb-s")
        bkd01 = scaleway.LbBackend("bkd01",
            lb_id=lb01.id,
            forward_protocol="tcp",
            forward_port=80,
            proxy_protocol="none")
        frt01 = scaleway.LbFrontend("frt01",
            lb_id=lb01.id,
            backend_id=bkd01.id,
            inbound_port=80)
        rt01 = scaleway.LbRoute("rt01",
            frontend_id=frt01.id,
            backend_id=bkd01.id,
            match_host_header="host.scaleway.com")
        ```

        ## Import

        Load-Balancer frontend can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/lbRoute:LbRoute main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend_id: The ID of the backend to which the route is associated.
        :param pulumi.Input[str] frontend_id: The ID of the frontend to which the route is associated.
        :param pulumi.Input[str] match_host_header: The Host request header specifies the host of the server to which the request is being sent.
               Only one of `match_sni` and `match_host_header` should be specified.
        :param pulumi.Input[str] match_sni: The Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
               Only one of `match_sni` and `match_host_header` should be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LbRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Load-Balancer Routes. For more information, see [the documentation](https://developers.scaleway.com/en/products/lb/zoned_api/#route-ff94b7).
        It is useful to manage the Service Name Indicator (SNI) for a route between a frontend and a backend.

        ## Examples

        ### With SNI

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        ip01 = scaleway.LbIp("ip01")
        lb01 = scaleway.Lb("lb01",
            ip_id=ip01.id,
            type="lb-s")
        bkd01 = scaleway.LbBackend("bkd01",
            lb_id=lb01.id,
            forward_protocol="tcp",
            forward_port=80,
            proxy_protocol="none")
        frt01 = scaleway.LbFrontend("frt01",
            lb_id=lb01.id,
            backend_id=bkd01.id,
            inbound_port=80)
        rt01 = scaleway.LbRoute("rt01",
            frontend_id=frt01.id,
            backend_id=bkd01.id,
            match_sni="sni.scaleway.com")
        ```

        ### With host-header

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        ip01 = scaleway.LbIp("ip01")
        lb01 = scaleway.Lb("lb01",
            ip_id=ip01.id,
            type="lb-s")
        bkd01 = scaleway.LbBackend("bkd01",
            lb_id=lb01.id,
            forward_protocol="tcp",
            forward_port=80,
            proxy_protocol="none")
        frt01 = scaleway.LbFrontend("frt01",
            lb_id=lb01.id,
            backend_id=bkd01.id,
            inbound_port=80)
        rt01 = scaleway.LbRoute("rt01",
            frontend_id=frt01.id,
            backend_id=bkd01.id,
            match_host_header="host.scaleway.com")
        ```

        ## Import

        Load-Balancer frontend can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/lbRoute:LbRoute main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param LbRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LbRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_id: Optional[pulumi.Input[str]] = None,
                 frontend_id: Optional[pulumi.Input[str]] = None,
                 match_host_header: Optional[pulumi.Input[str]] = None,
                 match_sni: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LbRouteArgs.__new__(LbRouteArgs)

            if backend_id is None and not opts.urn:
                raise TypeError("Missing required property 'backend_id'")
            __props__.__dict__["backend_id"] = backend_id
            if frontend_id is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_id'")
            __props__.__dict__["frontend_id"] = frontend_id
            __props__.__dict__["match_host_header"] = match_host_header
            __props__.__dict__["match_sni"] = match_sni
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(LbRoute, __self__).__init__(
            'scaleway:index/lbRoute:LbRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_id: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            frontend_id: Optional[pulumi.Input[str]] = None,
            match_host_header: Optional[pulumi.Input[str]] = None,
            match_sni: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'LbRoute':
        """
        Get an existing LbRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend_id: The ID of the backend to which the route is associated.
        :param pulumi.Input[str] created_at: The date at which the route was created.
        :param pulumi.Input[str] frontend_id: The ID of the frontend to which the route is associated.
        :param pulumi.Input[str] match_host_header: The Host request header specifies the host of the server to which the request is being sent.
               Only one of `match_sni` and `match_host_header` should be specified.
        :param pulumi.Input[str] match_sni: The Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
               Only one of `match_sni` and `match_host_header` should be specified.
        :param pulumi.Input[str] updated_at: The date at which the route was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LbRouteState.__new__(_LbRouteState)

        __props__.__dict__["backend_id"] = backend_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["frontend_id"] = frontend_id
        __props__.__dict__["match_host_header"] = match_host_header
        __props__.__dict__["match_sni"] = match_sni
        __props__.__dict__["updated_at"] = updated_at
        return LbRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> pulumi.Output[str]:
        """
        The ID of the backend to which the route is associated.
        """
        return pulumi.get(self, "backend_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date at which the route was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> pulumi.Output[str]:
        """
        The ID of the frontend to which the route is associated.
        """
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter(name="matchHostHeader")
    def match_host_header(self) -> pulumi.Output[Optional[str]]:
        """
        The Host request header specifies the host of the server to which the request is being sent.
        Only one of `match_sni` and `match_host_header` should be specified.
        """
        return pulumi.get(self, "match_host_header")

    @property
    @pulumi.getter(name="matchSni")
    def match_sni(self) -> pulumi.Output[Optional[str]]:
        """
        The Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        Only one of `match_sni` and `match_host_header` should be specified.
        """
        return pulumi.get(self, "match_sni")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date at which the route was last updated.
        """
        return pulumi.get(self, "updated_at")

