# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetRdbDatabaseBackupResult',
    'AwaitableGetRdbDatabaseBackupResult',
    'get_rdb_database_backup',
    'get_rdb_database_backup_output',
]

@pulumi.output_type
class GetRdbDatabaseBackupResult:
    """
    A collection of values returned by getRdbDatabaseBackup.
    """
    def __init__(__self__, backup_id=None, created_at=None, database_name=None, expires_at=None, id=None, instance_id=None, instance_name=None, name=None, region=None, size=None, updated_at=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if expires_at and not isinstance(expires_at, str):
            raise TypeError("Expected argument 'expires_at' to be a str")
        pulumi.set(__self__, "expires_at", expires_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[str]:
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> int:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        return pulumi.get(self, "updated_at")


class AwaitableGetRdbDatabaseBackupResult(GetRdbDatabaseBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRdbDatabaseBackupResult(
            backup_id=self.backup_id,
            created_at=self.created_at,
            database_name=self.database_name,
            expires_at=self.expires_at,
            id=self.id,
            instance_id=self.instance_id,
            instance_name=self.instance_name,
            name=self.name,
            region=self.region,
            size=self.size,
            updated_at=self.updated_at)


def get_rdb_database_backup(backup_id: Optional[str] = None,
                            instance_id: Optional[str] = None,
                            name: Optional[str] = None,
                            region: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRdbDatabaseBackupResult:
    """
    Gets information about an RDB backup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    find_by_name = scaleway.get_rdb_database_backup(name="mybackup")
    find_by_name_and_instance = scaleway.get_rdb_database_backup(instance_id="11111111-1111-1111-1111-111111111111",
        name="mybackup")
    find_by_id = scaleway.get_rdb_database_backup(backup_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str backup_id: The RDB backup ID.
           Only one of the `name` and `backup_id` should be specified.
    :param str instance_id: The RDB instance ID.
    :param str name: The name of the RDB instance.
           Only one of the `name` and `backup_id` should be specified.
    :param str region: `region`) The region in which the Database Instance should be created.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getRdbDatabaseBackup:getRdbDatabaseBackup', __args__, opts=opts, typ=GetRdbDatabaseBackupResult).value

    return AwaitableGetRdbDatabaseBackupResult(
        backup_id=__ret__.backup_id,
        created_at=__ret__.created_at,
        database_name=__ret__.database_name,
        expires_at=__ret__.expires_at,
        id=__ret__.id,
        instance_id=__ret__.instance_id,
        instance_name=__ret__.instance_name,
        name=__ret__.name,
        region=__ret__.region,
        size=__ret__.size,
        updated_at=__ret__.updated_at)


@_utilities.lift_output_func(get_rdb_database_backup)
def get_rdb_database_backup_output(backup_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   name: Optional[pulumi.Input[Optional[str]]] = None,
                                   region: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRdbDatabaseBackupResult]:
    """
    Gets information about an RDB backup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    find_by_name = scaleway.get_rdb_database_backup(name="mybackup")
    find_by_name_and_instance = scaleway.get_rdb_database_backup(instance_id="11111111-1111-1111-1111-111111111111",
        name="mybackup")
    find_by_id = scaleway.get_rdb_database_backup(backup_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str backup_id: The RDB backup ID.
           Only one of the `name` and `backup_id` should be specified.
    :param str instance_id: The RDB instance ID.
    :param str name: The name of the RDB instance.
           Only one of the `name` and `backup_id` should be specified.
    :param str region: `region`) The region in which the Database Instance should be created.
    """
    ...
