"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.arbitrary_input_intervals = exports.ArbitraryInputIntervals = exports.createScalableTarget = void 0;
const scalingcommon = require("@aws-cdk/aws-autoscaling-common");
const fc = require("fast-check");
const appscaling = require("../lib");
function createScalableTarget(scope) {
    return new appscaling.ScalableTarget(scope, 'Target', {
        serviceNamespace: appscaling.ServiceNamespace.DYNAMODB,
        scalableDimension: 'test:TestCount',
        resourceId: 'test:this/test',
        minCapacity: 1,
        maxCapacity: 20,
    });
}
exports.createScalableTarget = createScalableTarget;
class ArbitraryInputIntervals extends fc.Arbitrary {
    generate(mrng) {
        const ret = scalingcommon.generateArbitraryIntervals(mrng);
        return new fc.Shrinkable(ret.intervals);
    }
}
exports.ArbitraryInputIntervals = ArbitraryInputIntervals;
function arbitrary_input_intervals() {
    return new ArbitraryInputIntervals();
}
exports.arbitrary_input_intervals = arbitrary_input_intervals;
//# sourceMappingURL=data:application/json;base64,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