# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_stack_hci_client_enums import *


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class ArcSetting(ProxyResource):
    """ArcSetting details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the ArcSetting proxy resource. Possible values
     include: "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning".
    :vartype provisioning_state: str or ~azure_stack_hci_client.models.ProvisioningState
    :ivar arc_instance_resource_group: The resource group that hosts the Arc agents, ie. Hybrid
     Compute Machine resources.
    :vartype arc_instance_resource_group: str
    :ivar aggregate_state: Aggregate state of Arc agent across the nodes in this HCI cluster.
     Possible values include: "NotSpecified", "Error", "Succeeded", "Canceled", "Failed",
     "Connected", "Disconnected", "Deleted", "Creating", "Updating", "Deleting", "Moving",
     "PartiallySucceeded", "PartiallyConnected", "InProgress".
    :vartype aggregate_state: str or ~azure_stack_hci_client.models.ArcSettingAggregateState
    :ivar per_node_details: State of Arc agent in each of the nodes.
    :vartype per_node_details: list[~azure_stack_hci_client.models.PerNodeState]
    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure_stack_hci_client.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure_stack_hci_client.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'aggregate_state': {'readonly': True},
        'per_node_details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'arc_instance_resource_group': {'key': 'properties.arcInstanceResourceGroup', 'type': 'str'},
        'aggregate_state': {'key': 'properties.aggregateState', 'type': 'str'},
        'per_node_details': {'key': 'properties.perNodeDetails', 'type': '[PerNodeState]'},
        'created_by': {'key': 'systemData.createdBy', 'type': 'str'},
        'created_by_type': {'key': 'systemData.createdByType', 'type': 'str'},
        'created_at': {'key': 'systemData.createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'systemData.lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'systemData.lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'systemData.lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        arc_instance_resource_group: Optional[str] = None,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword arc_instance_resource_group: The resource group that hosts the Arc agents, ie. Hybrid
         Compute Machine resources.
        :paramtype arc_instance_resource_group: str
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure_stack_hci_client.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure_stack_hci_client.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(ArcSetting, self).__init__(**kwargs)
        self.provisioning_state = None
        self.arc_instance_resource_group = arc_instance_resource_group
        self.aggregate_state = None
        self.per_node_details = None
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class ArcSettingList(msrest.serialization.Model):
    """List of ArcSetting proxy resources for the HCI cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ArcSetting proxy resources.
    :vartype value: list[~azure_stack_hci_client.models.ArcSetting]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ArcSetting]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ArcSettingList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Cluster(TrackedResource):
    """Cluster details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: Provisioning state. Possible values include: "Succeeded", "Failed",
     "Canceled", "Accepted", "Provisioning".
    :vartype provisioning_state: str or ~azure_stack_hci_client.models.ProvisioningState
    :ivar status: Status of the cluster agent. Possible values include: "NotYetRegistered",
     "ConnectedRecently", "NotConnectedRecently", "Disconnected", "Error".
    :vartype status: str or ~azure_stack_hci_client.models.Status
    :ivar cloud_id: Unique, immutable resource id.
    :vartype cloud_id: str
    :ivar cloud_management_endpoint: Endpoint configured for management from the Azure portal.
    :vartype cloud_management_endpoint: str
    :ivar aad_client_id: App id of cluster AAD identity.
    :vartype aad_client_id: str
    :ivar aad_tenant_id: Tenant id of cluster AAD identity.
    :vartype aad_tenant_id: str
    :ivar desired_properties: Desired properties of the cluster.
    :vartype desired_properties: ~azure_stack_hci_client.models.ClusterDesiredProperties
    :ivar reported_properties: Properties reported by cluster agent.
    :vartype reported_properties: ~azure_stack_hci_client.models.ClusterReportedProperties
    :ivar trial_days_remaining: Number of days remaining in the trial period.
    :vartype trial_days_remaining: float
    :ivar billing_model: Type of billing applied to the resource.
    :vartype billing_model: str
    :ivar registration_timestamp: First cluster sync timestamp.
    :vartype registration_timestamp: ~datetime.datetime
    :ivar last_sync_timestamp: Most recent cluster sync timestamp.
    :vartype last_sync_timestamp: ~datetime.datetime
    :ivar last_billing_timestamp: Most recent billing meter timestamp.
    :vartype last_billing_timestamp: ~datetime.datetime
    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure_stack_hci_client.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure_stack_hci_client.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'cloud_id': {'readonly': True},
        'reported_properties': {'readonly': True},
        'trial_days_remaining': {'readonly': True},
        'billing_model': {'readonly': True},
        'registration_timestamp': {'readonly': True},
        'last_sync_timestamp': {'readonly': True},
        'last_billing_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'cloud_id': {'key': 'properties.cloudId', 'type': 'str'},
        'cloud_management_endpoint': {'key': 'properties.cloudManagementEndpoint', 'type': 'str'},
        'aad_client_id': {'key': 'properties.aadClientId', 'type': 'str'},
        'aad_tenant_id': {'key': 'properties.aadTenantId', 'type': 'str'},
        'desired_properties': {'key': 'properties.desiredProperties', 'type': 'ClusterDesiredProperties'},
        'reported_properties': {'key': 'properties.reportedProperties', 'type': 'ClusterReportedProperties'},
        'trial_days_remaining': {'key': 'properties.trialDaysRemaining', 'type': 'float'},
        'billing_model': {'key': 'properties.billingModel', 'type': 'str'},
        'registration_timestamp': {'key': 'properties.registrationTimestamp', 'type': 'iso-8601'},
        'last_sync_timestamp': {'key': 'properties.lastSyncTimestamp', 'type': 'iso-8601'},
        'last_billing_timestamp': {'key': 'properties.lastBillingTimestamp', 'type': 'iso-8601'},
        'created_by': {'key': 'systemData.createdBy', 'type': 'str'},
        'created_by_type': {'key': 'systemData.createdByType', 'type': 'str'},
        'created_at': {'key': 'systemData.createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'systemData.lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'systemData.lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'systemData.lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        cloud_management_endpoint: Optional[str] = None,
        aad_client_id: Optional[str] = None,
        aad_tenant_id: Optional[str] = None,
        desired_properties: Optional["ClusterDesiredProperties"] = None,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword cloud_management_endpoint: Endpoint configured for management from the Azure portal.
        :paramtype cloud_management_endpoint: str
        :keyword aad_client_id: App id of cluster AAD identity.
        :paramtype aad_client_id: str
        :keyword aad_tenant_id: Tenant id of cluster AAD identity.
        :paramtype aad_tenant_id: str
        :keyword desired_properties: Desired properties of the cluster.
        :paramtype desired_properties: ~azure_stack_hci_client.models.ClusterDesiredProperties
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure_stack_hci_client.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure_stack_hci_client.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(Cluster, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.status = None
        self.cloud_id = None
        self.cloud_management_endpoint = cloud_management_endpoint
        self.aad_client_id = aad_client_id
        self.aad_tenant_id = aad_tenant_id
        self.desired_properties = desired_properties
        self.reported_properties = None
        self.trial_days_remaining = None
        self.billing_model = None
        self.registration_timestamp = None
        self.last_sync_timestamp = None
        self.last_billing_timestamp = None
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class ClusterDesiredProperties(msrest.serialization.Model):
    """Desired properties of the cluster.

    :ivar windows_server_subscription: Desired state of Windows Server Subscription. Possible
     values include: "Disabled", "Enabled".
    :vartype windows_server_subscription: str or
     ~azure_stack_hci_client.models.WindowsServerSubscription
    :ivar diagnostic_level: Desired level of diagnostic data emitted by the cluster. Possible
     values include: "Off", "Basic", "Enhanced".
    :vartype diagnostic_level: str or ~azure_stack_hci_client.models.DiagnosticLevel
    """

    _attribute_map = {
        'windows_server_subscription': {'key': 'windowsServerSubscription', 'type': 'str'},
        'diagnostic_level': {'key': 'diagnosticLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        windows_server_subscription: Optional[Union[str, "WindowsServerSubscription"]] = None,
        diagnostic_level: Optional[Union[str, "DiagnosticLevel"]] = None,
        **kwargs
    ):
        """
        :keyword windows_server_subscription: Desired state of Windows Server Subscription. Possible
         values include: "Disabled", "Enabled".
        :paramtype windows_server_subscription: str or
         ~azure_stack_hci_client.models.WindowsServerSubscription
        :keyword diagnostic_level: Desired level of diagnostic data emitted by the cluster. Possible
         values include: "Off", "Basic", "Enhanced".
        :paramtype diagnostic_level: str or ~azure_stack_hci_client.models.DiagnosticLevel
        """
        super(ClusterDesiredProperties, self).__init__(**kwargs)
        self.windows_server_subscription = windows_server_subscription
        self.diagnostic_level = diagnostic_level


class ClusterList(msrest.serialization.Model):
    """List of clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of clusters.
    :vartype value: list[~azure_stack_hci_client.models.Cluster]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Cluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Cluster"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of clusters.
        :paramtype value: list[~azure_stack_hci_client.models.Cluster]
        """
        super(ClusterList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterNode(msrest.serialization.Model):
    """Cluster node details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the cluster node.
    :vartype name: str
    :ivar id: Id of the node in the cluster.
    :vartype id: float
    :ivar windows_server_subscription: State of Windows Server Subscription. Possible values
     include: "Disabled", "Enabled".
    :vartype windows_server_subscription: str or
     ~azure_stack_hci_client.models.WindowsServerSubscription
    :ivar manufacturer: Manufacturer of the cluster node hardware.
    :vartype manufacturer: str
    :ivar model: Model name of the cluster node hardware.
    :vartype model: str
    :ivar os_name: Operating system running on the cluster node.
    :vartype os_name: str
    :ivar os_version: Version of the operating system running on the cluster node.
    :vartype os_version: str
    :ivar serial_number: Immutable id of the cluster node.
    :vartype serial_number: str
    :ivar core_count: Number of physical cores on the cluster node.
    :vartype core_count: float
    :ivar memory_in_gi_b: Total available memory on the cluster node (in GiB).
    :vartype memory_in_gi_b: float
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'windows_server_subscription': {'readonly': True},
        'manufacturer': {'readonly': True},
        'model': {'readonly': True},
        'os_name': {'readonly': True},
        'os_version': {'readonly': True},
        'serial_number': {'readonly': True},
        'core_count': {'readonly': True},
        'memory_in_gi_b': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'float'},
        'windows_server_subscription': {'key': 'windowsServerSubscription', 'type': 'str'},
        'manufacturer': {'key': 'manufacturer', 'type': 'str'},
        'model': {'key': 'model', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'float'},
        'memory_in_gi_b': {'key': 'memoryInGiB', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ClusterNode, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.windows_server_subscription = None
        self.manufacturer = None
        self.model = None
        self.os_name = None
        self.os_version = None
        self.serial_number = None
        self.core_count = None
        self.memory_in_gi_b = None


class ClusterPatch(msrest.serialization.Model):
    """Cluster details to update.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar cloud_management_endpoint: Endpoint configured for management from the Azure portal.
    :vartype cloud_management_endpoint: str
    :ivar aad_client_id: App id of cluster AAD identity.
    :vartype aad_client_id: str
    :ivar aad_tenant_id: Tenant id of cluster AAD identity.
    :vartype aad_tenant_id: str
    :ivar desired_properties: Desired properties of the cluster.
    :vartype desired_properties: ~azure_stack_hci_client.models.ClusterDesiredProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'cloud_management_endpoint': {'key': 'properties.cloudManagementEndpoint', 'type': 'str'},
        'aad_client_id': {'key': 'properties.aadClientId', 'type': 'str'},
        'aad_tenant_id': {'key': 'properties.aadTenantId', 'type': 'str'},
        'desired_properties': {'key': 'properties.desiredProperties', 'type': 'ClusterDesiredProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        cloud_management_endpoint: Optional[str] = None,
        aad_client_id: Optional[str] = None,
        aad_tenant_id: Optional[str] = None,
        desired_properties: Optional["ClusterDesiredProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword cloud_management_endpoint: Endpoint configured for management from the Azure portal.
        :paramtype cloud_management_endpoint: str
        :keyword aad_client_id: App id of cluster AAD identity.
        :paramtype aad_client_id: str
        :keyword aad_tenant_id: Tenant id of cluster AAD identity.
        :paramtype aad_tenant_id: str
        :keyword desired_properties: Desired properties of the cluster.
        :paramtype desired_properties: ~azure_stack_hci_client.models.ClusterDesiredProperties
        """
        super(ClusterPatch, self).__init__(**kwargs)
        self.tags = tags
        self.cloud_management_endpoint = cloud_management_endpoint
        self.aad_client_id = aad_client_id
        self.aad_tenant_id = aad_tenant_id
        self.desired_properties = desired_properties


class ClusterReportedProperties(msrest.serialization.Model):
    """Properties reported by cluster agent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cluster_name: Name of the on-prem cluster connected to this resource.
    :vartype cluster_name: str
    :ivar cluster_id: Unique id generated by the on-prem cluster.
    :vartype cluster_id: str
    :ivar cluster_version: Version of the cluster software.
    :vartype cluster_version: str
    :ivar nodes: List of nodes reported by the cluster.
    :vartype nodes: list[~azure_stack_hci_client.models.ClusterNode]
    :ivar last_updated: Last time the cluster reported the data.
    :vartype last_updated: ~datetime.datetime
    :ivar imds_attestation: IMDS attestation status of the cluster. Possible values include:
     "Disabled", "Enabled".
    :vartype imds_attestation: str or ~azure_stack_hci_client.models.ImdsAttestation
    :ivar diagnostic_level: Level of diagnostic data emitted by the cluster. Possible values
     include: "Off", "Basic", "Enhanced".
    :vartype diagnostic_level: str or ~azure_stack_hci_client.models.DiagnosticLevel
    """

    _validation = {
        'cluster_name': {'readonly': True},
        'cluster_id': {'readonly': True},
        'cluster_version': {'readonly': True},
        'nodes': {'readonly': True},
        'last_updated': {'readonly': True},
        'imds_attestation': {'readonly': True},
    }

    _attribute_map = {
        'cluster_name': {'key': 'clusterName', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'str'},
        'cluster_version': {'key': 'clusterVersion', 'type': 'str'},
        'nodes': {'key': 'nodes', 'type': '[ClusterNode]'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'imds_attestation': {'key': 'imdsAttestation', 'type': 'str'},
        'diagnostic_level': {'key': 'diagnosticLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        diagnostic_level: Optional[Union[str, "DiagnosticLevel"]] = None,
        **kwargs
    ):
        """
        :keyword diagnostic_level: Level of diagnostic data emitted by the cluster. Possible values
         include: "Off", "Basic", "Enhanced".
        :paramtype diagnostic_level: str or ~azure_stack_hci_client.models.DiagnosticLevel
        """
        super(ClusterReportedProperties, self).__init__(**kwargs)
        self.cluster_name = None
        self.cluster_id = None
        self.cluster_version = None
        self.nodes = None
        self.last_updated = None
        self.imds_attestation = None
        self.diagnostic_level = diagnostic_level


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure_stack_hci_client.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure_stack_hci_client.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure_stack_hci_client.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure_stack_hci_client.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class Extension(ProxyResource):
    """Details of a particular extension in HCI Cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the Extension proxy resource. Possible values
     include: "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning".
    :vartype provisioning_state: str or ~azure_stack_hci_client.models.ProvisioningState
    :ivar aggregate_state: Aggregate state of Arc Extensions across the nodes in this HCI cluster.
     Possible values include: "NotSpecified", "Error", "Succeeded", "Canceled", "Failed",
     "Connected", "Disconnected", "Deleted", "Creating", "Updating", "Deleting", "Moving",
     "PartiallySucceeded", "PartiallyConnected", "InProgress".
    :vartype aggregate_state: str or ~azure_stack_hci_client.models.ExtensionAggregateState
    :ivar per_node_extension_details: State of Arc Extension in each of the nodes.
    :vartype per_node_extension_details: list[~azure_stack_hci_client.models.PerNodeExtensionState]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_extension_parameters_type: Specifies the type of the extension; an
     example is "CustomScriptExtension".
    :vartype type_properties_extension_parameters_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: any
    :ivar protected_settings: Protected settings (may contain secrets).
    :vartype protected_settings: any
    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure_stack_hci_client.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure_stack_hci_client.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'aggregate_state': {'readonly': True},
        'per_node_extension_details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'aggregate_state': {'key': 'properties.aggregateState', 'type': 'str'},
        'per_node_extension_details': {'key': 'properties.perNodeExtensionDetails', 'type': '[PerNodeExtensionState]'},
        'force_update_tag': {'key': 'properties.extensionParameters.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.extensionParameters.publisher', 'type': 'str'},
        'type_properties_extension_parameters_type': {'key': 'properties.extensionParameters.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.extensionParameters.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.extensionParameters.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.extensionParameters.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.extensionParameters.protectedSettings', 'type': 'object'},
        'created_by': {'key': 'systemData.createdBy', 'type': 'str'},
        'created_by_type': {'key': 'systemData.createdByType', 'type': 'str'},
        'created_at': {'key': 'systemData.createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'systemData.lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'systemData.lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'systemData.lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_extension_parameters_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_extension_parameters_type: Specifies the type of the extension; an
         example is "CustomScriptExtension".
        :paramtype type_properties_extension_parameters_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: any
        :keyword protected_settings: Protected settings (may contain secrets).
        :paramtype protected_settings: any
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure_stack_hci_client.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure_stack_hci_client.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(Extension, self).__init__(**kwargs)
        self.provisioning_state = None
        self.aggregate_state = None
        self.per_node_extension_details = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_extension_parameters_type = type_properties_extension_parameters_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class ExtensionList(msrest.serialization.Model):
    """List of Extensions in HCI cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Extensions in HCI cluster.
    :vartype value: list[~azure_stack_hci_client.models.Extension]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Extension]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExtensionList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure_stack_hci_client.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure_stack_hci_client.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure_stack_hci_client.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure_stack_hci_client.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure_stack_hci_client.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PerNodeExtensionState(msrest.serialization.Model):
    """Status of Arc Extension for a particular node in HCI Cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the node in HCI Cluster.
    :vartype name: str
    :ivar extension: Fully qualified resource ID for the particular Arc Extension on this node.
    :vartype extension: str
    :ivar state: State of Arc Extension in this node. Possible values include: "NotSpecified",
     "Error", "Succeeded", "Canceled", "Failed", "Connected", "Disconnected", "Deleted", "Creating",
     "Updating", "Deleting", "Moving".
    :vartype state: str or ~azure_stack_hci_client.models.NodeExtensionState
    """

    _validation = {
        'name': {'readonly': True},
        'extension': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'extension': {'key': 'extension', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PerNodeExtensionState, self).__init__(**kwargs)
        self.name = None
        self.extension = None
        self.state = None


class PerNodeState(msrest.serialization.Model):
    """Status of Arc agent for a particular node in HCI Cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Node in HCI Cluster.
    :vartype name: str
    :ivar arc_instance: Fully qualified resource ID for the Arc agent of this node.
    :vartype arc_instance: str
    :ivar state: State of Arc agent in this node. Possible values include: "NotSpecified", "Error",
     "Succeeded", "Canceled", "Failed", "Connected", "Disconnected", "Deleted", "Creating",
     "Updating", "Deleting", "Moving".
    :vartype state: str or ~azure_stack_hci_client.models.NodeArcState
    """

    _validation = {
        'name': {'readonly': True},
        'arc_instance': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'arc_instance': {'key': 'arcInstance', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PerNodeState, self).__init__(**kwargs)
        self.name = None
        self.arc_instance = None
        self.state = None
