# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['picsellia_tf2',
 'picsellia_tf2.object_detection',
 'picsellia_tf2.object_detection.anchor_generators',
 'picsellia_tf2.object_detection.box_coders',
 'picsellia_tf2.object_detection.builders',
 'picsellia_tf2.object_detection.core',
 'picsellia_tf2.object_detection.data_decoders',
 'picsellia_tf2.object_detection.dataset_tools',
 'picsellia_tf2.object_detection.dataset_tools.context_rcnn',
 'picsellia_tf2.object_detection.inference',
 'picsellia_tf2.object_detection.legacy',
 'picsellia_tf2.object_detection.matchers',
 'picsellia_tf2.object_detection.meta_architectures',
 'picsellia_tf2.object_detection.metrics',
 'picsellia_tf2.object_detection.models',
 'picsellia_tf2.object_detection.models.keras_models',
 'picsellia_tf2.object_detection.models.keras_models.base_models',
 'picsellia_tf2.object_detection.packages.tf1',
 'picsellia_tf2.object_detection.packages.tf2',
 'picsellia_tf2.object_detection.predictors',
 'picsellia_tf2.object_detection.predictors.heads',
 'picsellia_tf2.object_detection.protos',
 'picsellia_tf2.object_detection.tpu_exporters',
 'picsellia_tf2.object_detection.tpu_exporters.testdata',
 'picsellia_tf2.object_detection.utils',
 'picsellia_tf2.slim',
 'picsellia_tf2.slim.datasets',
 'picsellia_tf2.slim.deployment',
 'picsellia_tf2.slim.nets',
 'picsellia_tf2.slim.nets.mobilenet',
 'picsellia_tf2.slim.nets.nasnet',
 'picsellia_tf2.slim.preprocessing']

package_data = \
{'': ['*'],
 'picsellia_tf2.object_detection': ['colab_tutorials/*',
                                    'configs/tf2/*',
                                    'data/*',
                                    'dockerfiles/android/*',
                                    'dockerfiles/tf1/*',
                                    'dockerfiles/tf2/*',
                                    'g3doc/*',
                                    'g3doc/img/*',
                                    'samples/cloud/*',
                                    'samples/configs/*',
                                    'test_data/*',
                                    'test_images/*',
                                    'test_images/ducky/test/*',
                                    'test_images/ducky/train/*',
                                    'test_images/snapshot_serengeti/*'],
 'picsellia_tf2.object_detection.dataset_tools': ['densepose/*'],
 'picsellia_tf2.object_detection.tpu_exporters.testdata': ['faster_rcnn/*',
                                                           'ssd/*'],
 'picsellia_tf2.slim': ['scripts/*'],
 'picsellia_tf2.slim.nets.mobilenet': ['g3doc/*']}

install_requires = \
['Cython==0.29.21',
 'Pillow>=9.2.0',
 'absl-py==0.10.0',
 'apache-beam==2.27.0',
 'avro-python3==1.9.2.1',
 'contextlib2==0.6.0.post1',
 'ipython>=7.16.1',
 'keras==2.6.0',
 'lvis==0.5.3',
 'lxml==4.6.2',
 'matplotlib==3.3.4',
 'numpy>=1.19,<1.20.0',
 'pandas<=1.1.5',
 'pycocotools>=2.0.5,<3.0.0',
 'scipy==1.4.1',
 'six==1.15.0',
 'tensorflow==2.6.0',
 'tf-models-official==2.3.0',
 'tf-slim==1.1.0']

setup_kwargs = {
    'name': 'picsellia-tf2',
    'version': '0.11.1',
    'description': 'Wrapper of Tensorflow Object Detection Library for Picsellia',
    'long_description': '# Picsellia TF2\n\nThis package is a wrapper of Tensorflow Object Detection\nIt is mostly used for training models around Tensorflow environment\n',
    'author': 'Pierre-Nicolas Tiffreau',
    'author_email': 'pierre-nicolas@picsellia.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4',
}


setup(**setup_kwargs)
