import versioneer
from setuptools import find_packages, setup

REQUIREMENTS = ['drb', 'drb-impl-file']

with open('README.md') as fh:
    long_description = fh.read()

setup(
    name='drb-impl-image',
    packages=find_packages(include=['drb_impl_image']),
    description='DRB Image implementation',
    long_description=long_description,
    author='GAEL Systems',
    author_email='info@gael.fr',
    url='https://gitlab.com/drb-python/impl/image',
    install_requires=REQUIREMENTS,
    setup_requires=['setuptools_scm'],
    test_suite='tests',
    classifiers=[
        "Programming Language :: Python :: 3.8",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent"
    ],
    python_requires='>=3.8',
    entry_points={'drb.impl': 'mage = drb_impl_image.image_node_factory'},
    use_scm_version=True,
    version=versioneer.get_version(),
    cmdclass=versioneer.get_cmdclass(),
    include_package_data=True,
)
