; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "${AppName}"
!define PRODUCT_VERSION "${Version}"
!define DIST_DIR "${DistDir}"
!define PRODUCT_PUBLISHER "HandsFree, Inc."
!define PRODUCT_WEB_SITE "https://game.handsfree.work"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\${PRODUCT_NAME}.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define ROOT_DIR "${RootDir}"
# SetCompressor bzip2 # zlib

; MUI 1.67 compatible ------
!include "MUI2.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${ROOT_DIR}\extra\favicon.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

BrandingText "HandsFree"

; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page


!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\${PRODUCT_NAME}.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "SimpChinese"
;!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"

OutFile "${ROOT_DIR}\dist\${PRODUCT_NAME}-${PRODUCT_VERSION}-setup.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show


; װʱԶرеӦ

Function SilentSearchCallback

  Pop $R0
  Pop $R1
  Pop $R2

  ${If} $R0 == -1
    MessageBox MB_OK|MB_ICONEXCLAMATION `رս̳ $R2!`
  ${ElseIf} ${Cmd} `MessageBox MB_YESNO|MB_ICONQUESTION 'ӦУǷر' IDYES`
    Push autoclose
  ${Else}
    Push false
  ${EndIf}

FunctionEnd



Section LockedList
  LockedList::AddModule \${PRODUCT_NAME}.exe
  GetFunctionAddress $R0 SilentSearchCallback
  LockedList::SilentSearch $R0
  Pop $R0
  DetailPrint $R0
  SetAutoClose false
SectionEnd



; жʱԶرеӦ

Function un.SilentSearchCallback

  Pop $R0
  Pop $R1
  Pop $R2

  ${If} $R0 == -1
    MessageBox MB_OK|MB_ICONEXCLAMATION `رս̳ $R2!`
  ${ElseIf} ${Cmd} `MessageBox MB_YESNO|MB_ICONQUESTION 'ӦУǷر' IDYES`
    Push autoclose
  ${Else}
    Push false
  ${EndIf}

FunctionEnd

Section un.LockedList
  LockedList::AddModule \${PRODUCT_NAME}.exe
  GetFunctionAddress $R0 un.SilentSearchCallback
  LockedList::SilentSearch $R0
  Pop $R0
  DetailPrint $R0
  SetAutoClose false
SectionEnd


Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File /nonfatal /r "${ROOT_DIR}\dist\${DIST_DIR}\*.*"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$DESKTOP\${PRODUCT_NAME}.lnk" "$INSTDIR\${PRODUCT_NAME}.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\${PRODUCT_NAME}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\${PRODUCT_NAME}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) ѳɹشļƳ"
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "ȷʵҪȫƳ $(^Name) 估е" IDYES +2
  Abort
FunctionEnd



Section Uninstall

  Delete "$INSTDIR\uninst.exe"
  RMDir /r "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd