CREATE TABLE IF NOT EXISTS `fs_tns_sources` (
  `primaryId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'An internal counter',
  `TNSId` varchar(20) NOT NULL,
  `TNSName` varchar(20) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `decDeg` double DEFAULT NULL,
  `decSex` varchar(45) DEFAULT NULL,
  `discDate` datetime DEFAULT NULL,
  `discMag` double DEFAULT NULL,
  `discMagFilter` varchar(45) DEFAULT NULL,
  `discSurvey` varchar(100) DEFAULT NULL,
  `discoveryName` varchar(100) DEFAULT NULL,
  `objectUrl` varchar(200) DEFAULT NULL,
  `raDeg` double DEFAULT NULL,
  `raSex` varchar(45) DEFAULT NULL,
  `specType` varchar(100) DEFAULT NULL,
  `transRedshift` double DEFAULT NULL,
  `updated` tinyint(4) DEFAULT '0',
  `dateLastModified` datetime DEFAULT NULL,
  `hostName` VARCHAR(100) NULL DEFAULT NULL,
  `hostRedshift` DOUBLE NULL DEFAULT NULL, 
  `survey` VARCHAR(100) NULL DEFAULT NULL,
  PRIMARY KEY (`primaryId`),
  UNIQUE KEY `tnsid` (`TNSId`)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;
            
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bdd" ,"AT2021bdd" ,"-14.71278" ,"-14:42:46.00" ,"2021-01-08 05:13:55.200" ,"20.02" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ql" ,null ,null ,"https://www.wis-tns.org/object/2021bdd" ,"348.1922167" ,"23:12:46.132" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bdd", `TNSName`="AT2021bdd", `decDeg`="-14.71278", `decSex`="-14:42:46.00", `discDate`="2021-01-08 05:13:55.200", `discMag`="20.02", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ql", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bdd", `raDeg`="348.1922167", `raSex`="23:12:46.132", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bdc" ,"AT2021bdc" ,"17.735122" ,"+17:44:06.44" ,"2021-01-16 09:12:57.600" ,"20.8" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qk" ,null ,null ,"https://www.wis-tns.org/object/2021bdc" ,"126.38292083" ,"08:25:31.901" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bdc", `TNSName`="AT2021bdc", `decDeg`="17.735122", `decSex`="+17:44:06.44", `discDate`="2021-01-16 09:12:57.600", `discMag`="20.8", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qk", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bdc", `raDeg`="126.38292083", `raSex`="08:25:31.901", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bdb" ,"AT2021bdb" ,"-6.31208" ,"-06:18:43.50" ,"2021-01-05 07:52:19.200" ,"21.83" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qj" ,null ,null ,"https://www.wis-tns.org/object/2021bdb" ,"67.45259583333333" ,"04:29:48.623" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bdb", `TNSName`="AT2021bdb", `decDeg`="-6.31208", `decSex`="-06:18:43.50", `discDate`="2021-01-05 07:52:19.200", `discMag`="21.83", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qj", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bdb", `raDeg`="67.45259583333333", `raSex`="04:29:48.623", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bda" ,"AT2021bda" ,"-12.019225" ,"-12:01:09.21" ,"2021-01-15 10:42:14.400" ,"20.1" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qi" ,null ,null ,"https://www.wis-tns.org/object/2021bda" ,"128.29965833333333" ,"08:33:11.918" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bda", `TNSName`="AT2021bda", `decDeg`="-12.019225", `decSex`="-12:01:09.21", `discDate`="2021-01-15 10:42:14.400", `discMag`="20.1", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qi", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bda", `raDeg`="128.29965833333333", `raSex`="08:33:11.918", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcz" ,"AT2021bcz" ,"8.580089" ,"+08:34:48.32" ,"2021-01-15 14:21:07.200" ,"21.5" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qh" ,null ,null ,"https://www.wis-tns.org/object/2021bcz" ,"200.84838333333335" ,"13:23:23.612" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcz", `TNSName`="AT2021bcz", `decDeg`="8.580089", `decSex`="+08:34:48.32", `discDate`="2021-01-15 14:21:07.200", `discMag`="21.5", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qh", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcz", `raDeg`="200.84838333333335", `raSex`="13:23:23.612", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcy" ,"AT2021bcy" ,"27.3156" ,"+27:18:56.16" ,"2021-01-06 06:53:16.800" ,"21.26" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qg" ,null ,null ,"https://www.wis-tns.org/object/2021bcy" ,"10.02475" ,"00:40:05.940" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcy", `TNSName`="AT2021bcy", `decDeg`="27.3156", `decSex`="+27:18:56.16", `discDate`="2021-01-06 06:53:16.800", `discMag`="21.26", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qg", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcy", `raDeg`="10.02475", `raSex`="00:40:05.940", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcx" ,"AT2021bcx" ,"17.527025" ,"+17:31:37.29" ,"2021-01-16 09:12:57.600" ,"21.2" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qf" ,null ,null ,"https://www.wis-tns.org/object/2021bcx" ,"129.7215125" ,"08:38:53.163" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcx", `TNSName`="AT2021bcx", `decDeg`="17.527025", `decSex`="+17:31:37.29", `discDate`="2021-01-16 09:12:57.600", `discMag`="21.2", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qf", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcx", `raDeg`="129.7215125", `raSex`="08:38:53.163", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcw" ,"AT2021bcw" ,"-22.316578" ,"-22:18:59.68" ,"2021-01-07 06:44:38.400" ,"21.17" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qe" ,null ,null ,"https://www.wis-tns.org/object/2021bcw" ,"49.70740417" ,"03:18:49.777" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcw", `TNSName`="AT2021bcw", `decDeg`="-22.316578", `decSex`="-22:18:59.68", `discDate`="2021-01-07 06:44:38.400", `discMag`="21.17", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qe", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcw", `raDeg`="49.70740417", `raSex`="03:18:49.777", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcv" ,"AT2021bcv" ,"25.564672" ,"+25:33:52.82" ,"2021-01-16 07:56:38.400" ,"21.83" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qc" ,null ,null ,"https://www.wis-tns.org/object/2021bcv" ,"52.19165" ,"03:28:45.996" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcv", `TNSName`="AT2021bcv", `decDeg`="25.564672", `decSex`="+25:33:52.82", `discDate`="2021-01-16 07:56:38.400", `discMag`="21.83", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qc", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcv", `raDeg`="52.19165", `raSex`="03:28:45.996", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcu" ,"AT2021bcu" ,"15.194247" ,"+15:11:39.29" ,"2021-01-14 15:31:40.800" ,"21.73" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qb" ,null ,null ,"https://www.wis-tns.org/object/2021bcu" ,"153.8245875" ,"10:15:17.901" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcu", `TNSName`="AT2021bcu", `decDeg`="15.194247", `decSex`="+15:11:39.29", `discDate`="2021-01-14 15:31:40.800", `discMag`="21.73", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qb", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcu", `raDeg`="153.8245875", `raSex`="10:15:17.901", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bct" ,"AT2021bct" ,"-18.618033" ,"-18:37:04.92" ,"2021-01-16 06:59:02.400" ,"21.14" ,"w-PS1" ,"Pan-STARRS1" ,"PS21qa" ,null ,null ,"https://www.wis-tns.org/object/2021bct" ,"74.8525125" ,"04:59:24.603" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bct", `TNSName`="AT2021bct", `decDeg`="-18.618033", `decSex`="-18:37:04.92", `discDate`="2021-01-16 06:59:02.400", `discMag`="21.14", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21qa", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bct", `raDeg`="74.8525125", `raSex`="04:59:24.603", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcs" ,"AT2021bcs" ,"38.601178" ,"+38:36:04.24" ,"2021-01-12 10:59:31.200" ,"21.56" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pu" ,null ,null ,"https://www.wis-tns.org/object/2021bcs" ,"129.6888417" ,"08:38:45.322" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcs", `TNSName`="AT2021bcs", `decDeg`="38.601178", `decSex`="+38:36:04.24", `discDate`="2021-01-12 10:59:31.200", `discMag`="21.56", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pu", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcs", `raDeg`="129.6888417", `raSex`="08:38:45.322", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcr" ,"AT2021bcr" ,"12.031428" ,"+12:01:53.14" ,"2021-01-12 15:25:55.200" ,"21.46" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pt" ,null ,null ,"https://www.wis-tns.org/object/2021bcr" ,"170.09464583" ,"11:20:22.715" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcr", `TNSName`="AT2021bcr", `decDeg`="12.031428", `decSex`="+12:01:53.14", `discDate`="2021-01-12 15:25:55.200", `discMag`="21.46", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pt", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcr", `raDeg`="170.09464583", `raSex`="11:20:22.715", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcq" ,"AT2021bcq" ,"47.974856" ,"+47:58:29.48" ,"2021-01-12 09:40:19.200" ,"21.52" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ps" ,null ,null ,"https://www.wis-tns.org/object/2021bcq" ,"104.8508833" ,"06:59:24.212" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcq", `TNSName`="AT2021bcq", `decDeg`="47.974856", `decSex`="+47:58:29.48", `discDate`="2021-01-12 09:40:19.200", `discMag`="21.52", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ps", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcq", `raDeg`="104.8508833", `raSex`="06:59:24.212", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcp" ,"AT2021bcp" ,"-10.163658" ,"-10:09:49.17" ,"2021-01-17 07:55:12.000" ,"21.8" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pr" ,null ,null ,"https://www.wis-tns.org/object/2021bcp" ,"76.67437083333333" ,"05:06:41.849" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcp", `TNSName`="AT2021bcp", `decDeg`="-10.163658", `decSex`="-10:09:49.17", `discDate`="2021-01-17 07:55:12.000", `discMag`="21.8", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pr", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcp", `raDeg`="76.67437083333333", `raSex`="05:06:41.849", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bco" ,"AT2021bco" ,"-3.010267" ,"-03:00:36.96" ,"2021-01-05 06:38:52.800" ,"20.53" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pq" ,null ,null ,"https://www.wis-tns.org/object/2021bco" ,"34.6691583" ,"02:18:40.598" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bco", `TNSName`="AT2021bco", `decDeg`="-3.010267", `decSex`="-03:00:36.96", `discDate`="2021-01-05 06:38:52.800", `discMag`="20.53", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pq", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bco", `raDeg`="34.6691583", `raSex`="02:18:40.598", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcn" ,"AT2021bcn" ,"42.505097" ,"+42:30:18.35" ,"2021-01-17 15:07:12.000" ,"21.76" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pp" ,null ,null ,"https://www.wis-tns.org/object/2021bcn" ,"179.858375" ,"11:59:26.010" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcn", `TNSName`="AT2021bcn", `decDeg`="42.505097", `decSex`="+42:30:18.35", `discDate`="2021-01-17 15:07:12.000", `discMag`="21.76", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pp", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcn", `raDeg`="179.858375", `raSex`="11:59:26.010", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcm" ,"AT2021bcm" ,"14.523592" ,"+14:31:24.93" ,"2021-01-14 15:25:55.200" ,"21.18" ,"w-PS1" ,"Pan-STARRS1" ,"PS21po" ,null ,null ,"https://www.wis-tns.org/object/2021bcm" ,"155.7288583" ,"10:22:54.926" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcm", `TNSName`="AT2021bcm", `decDeg`="14.523592", `decSex`="+14:31:24.93", `discDate`="2021-01-14 15:25:55.200", `discMag`="21.18", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21po", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcm", `raDeg`="155.7288583", `raSex`="10:22:54.926", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcl" ,"AT2021bcl" ,"-5.467606" ,"-05:28:03.38" ,"2021-01-21 11:34:04.800" ,"20.97" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pn" ,null ,null ,"https://www.wis-tns.org/object/2021bcl" ,"147.0835583" ,"09:48:20.054" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcl", `TNSName`="AT2021bcl", `decDeg`="-5.467606", `decSex`="-05:28:03.38", `discDate`="2021-01-21 11:34:04.800", `discMag`="20.97", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pn", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcl", `raDeg`="147.0835583", `raSex`="09:48:20.054", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bck" ,"AT2021bck" ,"8.576572" ,"+08:34:35.66" ,"2021-01-15 14:21:07.200" ,"21.53" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pm" ,null ,null ,"https://www.wis-tns.org/object/2021bck" ,"200.1509875" ,"13:20:36.237" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bck", `TNSName`="AT2021bck", `decDeg`="8.576572", `decSex`="+08:34:35.66", `discDate`="2021-01-15 14:21:07.200", `discMag`="21.53", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pm", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bck", `raDeg`="200.1509875", `raSex`="13:20:36.237", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcj" ,"AT2021bcj" ,"18.611464" ,"+18:36:41.27" ,"2021-01-11 06:47:31.200" ,"20.98" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pl" ,null ,null ,"https://www.wis-tns.org/object/2021bcj" ,"31.31832917" ,"02:05:16.399" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcj", `TNSName`="AT2021bcj", `decDeg`="18.611464", `decSex`="+18:36:41.27", `discDate`="2021-01-11 06:47:31.200", `discMag`="20.98", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pl", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcj", `raDeg`="31.31832917", `raSex`="02:05:16.399", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bci" ,"AT2021bci" ,"9.367431" ,"+09:22:02.75" ,"2021-01-15 11:52:48.000" ,"21.11" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pk" ,null ,null ,"https://www.wis-tns.org/object/2021bci" ,"165.82782083" ,"11:03:18.677" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bci", `TNSName`="AT2021bci", `decDeg`="9.367431", `decSex`="+09:22:02.75", `discDate`="2021-01-15 11:52:48.000", `discMag`="21.11", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pk", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bci", `raDeg`="165.82782083", `raSex`="11:03:18.677", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bch" ,"AT2021bch" ,"5.195089" ,"+05:11:42.32" ,"2021-01-12 06:00:00.000" ,"21.05" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pj" ,null ,null ,"https://www.wis-tns.org/object/2021bch" ,"30.30597083" ,"02:01:13.433" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bch", `TNSName`="AT2021bch", `decDeg`="5.195089", `decSex`="+05:11:42.32", `discDate`="2021-01-12 06:00:00.000", `discMag`="21.05", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pj", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bch", `raDeg`="30.30597083", `raSex`="02:01:13.433", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcg" ,"AT2021bcg" ,"23.806483" ,"+23:48:23.34" ,"2021-01-16 09:47:31.200" ,"21.03" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pi" ,null ,null ,"https://www.wis-tns.org/object/2021bcg" ,"128.03288333333333" ,"08:32:07.892" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcg", `TNSName`="AT2021bcg", `decDeg`="23.806483", `decSex`="+23:48:23.34", `discDate`="2021-01-16 09:47:31.200", `discMag`="21.03", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pi", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcg", `raDeg`="128.03288333333333", `raSex`="08:32:07.892", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcf" ,"AT2021bcf" ,"-18.589878" ,"-18:35:23.56" ,"2021-01-16 06:46:04.800" ,"21.58" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ph" ,null ,null ,"https://www.wis-tns.org/object/2021bcf" ,"61.214779166666666" ,"04:04:51.547" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcf", `TNSName`="AT2021bcf", `decDeg`="-18.589878", `decSex`="-18:35:23.56", `discDate`="2021-01-16 06:46:04.800", `discMag`="21.58", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ph", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcf", `raDeg`="61.214779166666666", `raSex`="04:04:51.547", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bce" ,"AT2021bce" ,"17.968461" ,"+17:58:06.46" ,"2021-01-09 10:33:36.000" ,"20.9" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pg" ,null ,null ,"https://www.wis-tns.org/object/2021bce" ,"164.6856" ,"10:58:44.544" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bce", `TNSName`="AT2021bce", `decDeg`="17.968461", `decSex`="+17:58:06.46", `discDate`="2021-01-09 10:33:36.000", `discMag`="20.9", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pg", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bce", `raDeg`="164.6856", `raSex`="10:58:44.544", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcd" ,"AT2021bcd" ,"-7.83995" ,"-07:50:23.82" ,"2021-01-24 15:30:14.400" ,"20.01" ,"w-PS1" ,"Pan-STARRS1" ,"PS21pd" ,null ,null ,"https://www.wis-tns.org/object/2021bcd" ,"222.6931417" ,"14:50:46.354" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcd", `TNSName`="AT2021bcd", `decDeg`="-7.83995", `decSex`="-07:50:23.82", `discDate`="2021-01-24 15:30:14.400", `discMag`="20.01", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21pd", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcd", `raDeg`="222.6931417", `raSex`="14:50:46.354", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcc" ,"AT2021bcc" ,"-2.33289" ,"-02:19:58.40" ,"2021-01-11 12:43:12.000" ,"21.31" ,"w-PS1" ,"Pan-STARRS1" ,"PS21oy" ,null ,null ,"https://www.wis-tns.org/object/2021bcc" ,"141.7247583" ,"09:26:53.942" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcc", `TNSName`="AT2021bcc", `decDeg`="-2.33289", `decSex`="-02:19:58.40", `discDate`="2021-01-11 12:43:12.000", `discMag`="21.31", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21oy", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcc", `raDeg`="141.7247583", `raSex`="09:26:53.942", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bcb" ,"AT2021bcb" ,"16.910144" ,"+16:54:36.52" ,"2021-01-11 07:00:28.800" ,"21.7" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ox" ,null ,null ,"https://www.wis-tns.org/object/2021bcb" ,"45.56197917" ,"03:02:14.875" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcb", `TNSName`="AT2021bcb", `decDeg`="16.910144", `decSex`="+16:54:36.52", `discDate`="2021-01-11 07:00:28.800", `discMag`="21.7", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ox", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bcb", `raDeg`="45.56197917", `raSex`="03:02:14.875", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bca" ,"AT2021bca" ,"-7.173794" ,"-07:10:25.66" ,"2021-01-21 11:28:19.200" ,"20.62" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ov" ,null ,null ,"https://www.wis-tns.org/object/2021bca" ,"144.949925" ,"09:39:47.982" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bca", `TNSName`="AT2021bca", `decDeg`="-7.173794", `decSex`="-07:10:25.66", `discDate`="2021-01-21 11:28:19.200", `discMag`="20.62", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ov", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bca", `raDeg`="144.949925", `raSex`="09:39:47.982", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbz" ,"AT2021bbz" ,"20.324461" ,"+20:19:28.06" ,"2021-01-23 05:45:36.000" ,"17.86" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21alc" ,null ,null ,"https://www.wis-tns.org/object/2021bbz" ,"176.348333" ,"11:45:23.600" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbz", `TNSName`="AT2021bbz", `decDeg`="20.324461", `decSex`="+20:19:28.06", `discDate`="2021-01-23 05:45:36.000", `discMag`="17.86", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21alc", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbz", `raDeg`="176.348333", `raSex`="11:45:23.600", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bby" ,"AT2021bby" ,"33.1501" ,"+33:09:00.36" ,"2021-01-23 21:34:33.600" ,"19.68" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ala" ,null ,null ,"https://www.wis-tns.org/object/2021bby" ,"328.809583" ,"21:55:14.300" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bby", `TNSName`="AT2021bby", `decDeg`="33.1501", `decSex`="+33:09:00.36", `discDate`="2021-01-23 21:34:33.600", `discMag`="19.68", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ala", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bby", `raDeg`="328.809583", `raSex`="21:55:14.300", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbx" ,"AT2021bbx" ,"-43.839631" ,"-43:50:22.67" ,"2021-01-24 00:56:09.600" ,"17.32" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akz" ,null ,null ,"https://www.wis-tns.org/object/2021bbx" ,"138.7452917" ,"09:14:58.870" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbx", `TNSName`="AT2021bbx", `decDeg`="-43.839631", `decSex`="-43:50:22.67", `discDate`="2021-01-24 00:56:09.600", `discMag`="17.32", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akz", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbx", `raDeg`="138.7452917", `raSex`="09:14:58.870", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbw" ,"AT2021bbw" ,"-49.184619" ,"-49:11:04.63" ,"2021-01-23 17:15:21.600" ,"17.75" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21aky" ,null ,null ,"https://www.wis-tns.org/object/2021bbw" ,"134.844625" ,"08:59:22.710" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbw", `TNSName`="AT2021bbw", `decDeg`="-49.184619", `decSex`="-49:11:04.63", `discDate`="2021-01-23 17:15:21.600", `discMag`="17.75", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21aky", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbw", `raDeg`="134.844625", `raSex`="08:59:22.710", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbv" ,"AT2021bbv" ,"8.9263" ,"+08:55:34.68" ,"2021-01-23 23:57:07.200" ,"18.7" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akw" ,null ,null ,"https://www.wis-tns.org/object/2021bbv" ,"172.5867917" ,"11:30:20.830" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbv", `TNSName`="AT2021bbv", `decDeg`="8.9263", `decSex`="+08:55:34.68", `discDate`="2021-01-23 23:57:07.200", `discMag`="18.7", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akw", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbv", `raDeg`="172.5867917", `raSex`="11:30:20.830", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbu" ,"AT2021bbu" ,"-65.882931" ,"-65:52:58.55" ,"2021-01-23 05:38:24.000" ,"18.98" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akv" ,null ,null ,"https://www.wis-tns.org/object/2021bbu" ,"94.865375" ,"06:19:27.690" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbu", `TNSName`="AT2021bbu", `decDeg`="-65.882931", `decSex`="-65:52:58.55", `discDate`="2021-01-23 05:38:24.000", `discMag`="18.98", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akv", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbu", `raDeg`="94.865375", `raSex`="06:19:27.690", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbt" ,"AT2021bbt" ,"42.733039" ,"+42:43:58.94" ,"2021-01-23 13:59:31.200" ,"18.66" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akt" ,null ,null ,"https://www.wis-tns.org/object/2021bbt" ,"321.9535" ,"21:27:48.840" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbt", `TNSName`="AT2021bbt", `decDeg`="42.733039", `decSex`="+42:43:58.94", `discDate`="2021-01-23 13:59:31.200", `discMag`="18.66", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akt", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbt", `raDeg`="321.9535", `raSex`="21:27:48.840", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbs" ,"AT2021bbs" ,"15.808239" ,"+15:48:29.66" ,"2021-01-23 17:49:55.200" ,"18.53" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21aks" ,null ,null ,"https://www.wis-tns.org/object/2021bbs" ,"175.5890417" ,"11:42:21.370" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbs", `TNSName`="AT2021bbs", `decDeg`="15.808239", `decSex`="+15:48:29.66", `discDate`="2021-01-23 17:49:55.200", `discMag`="18.53", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21aks", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbs", `raDeg`="175.5890417", `raSex`="11:42:21.370", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbr" ,"AT2021bbr" ,"28.259192" ,"+28:15:33.09" ,"2021-01-15 15:27:21.600" ,"21.25" ,"g-Sloan" ,"Pan-STARRS1" ,"PS21ot" ,null ,null ,"https://www.wis-tns.org/object/2021bbr" ,"207.37972916666666" ,"13:49:31.135" ,"YSE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbr", `TNSName`="AT2021bbr", `decDeg`="28.259192", `decSex`="+28:15:33.09", `discDate`="2021-01-15 15:27:21.600", `discMag`="21.25", `discMagFilter`="g-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ot", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbr", `raDeg`="207.37972916666666", `raSex`="13:49:31.135", `reportingSurvey`="YSE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbq" ,"AT2021bbq" ,"19.95978" ,"+19:57:35.20" ,"2021-01-16 13:06:14.400" ,"21" ,"r-Sloan" ,"Pan-STARRS1" ,"PS21os" ,null ,null ,"https://www.wis-tns.org/object/2021bbq" ,"179.911375" ,"11:59:38.730" ,"YSE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbq", `TNSName`="AT2021bbq", `decDeg`="19.95978", `decSex`="+19:57:35.20", `discDate`="2021-01-16 13:06:14.400", `discMag`="21", `discMagFilter`="r-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21os", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbq", `raDeg`="179.911375", `raSex`="11:59:38.730", `reportingSurvey`="YSE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbp" ,"AT2021bbp" ,"38.748733" ,"+38:44:55.44" ,"2021-01-13 05:19:40.800" ,"20.59" ,"i-Sloan" ,"Pan-STARRS1" ,"PS21or" ,null ,null ,"https://www.wis-tns.org/object/2021bbp" ,"42.148583" ,"02:48:35.660" ,"YSE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbp", `TNSName`="AT2021bbp", `decDeg`="38.748733", `decSex`="+38:44:55.44", `discDate`="2021-01-13 05:19:40.800", `discMag`="20.59", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21or", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbp", `raDeg`="42.148583", `raSex`="02:48:35.660", `reportingSurvey`="YSE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbo" ,"AT2021bbo" ,"-72.38906" ,"-72:23:20.60" ,"2021-01-20 22:10:41.376" ,"12.9" ,"Clear-" ,"MASTER" ,"MASTER OT J160455.05-722320.6" ,null ,null ,"https://www.wis-tns.org/object/2021bbo" ,"241.229375" ,"16:04:55.050" ,"MASTER" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbo", `TNSName`="AT2021bbo", `decDeg`="-72.38906", `decSex`="-72:23:20.60", `discDate`="2021-01-20 22:10:41.376", `discMag`="12.9", `discMagFilter`="Clear-", `discSurvey`="MASTER", `discoveryName`="MASTER OT J160455.05-722320.6", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbo", `raDeg`="241.229375", `raSex`="16:04:55.050", `reportingSurvey`="MASTER", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbn" ,"AT2021bbn" ,"14.49403" ,"+14:29:38.50" ,"2021-01-24 00:32:30.048" ,"16.9" ,"Clear-" ,"MASTER" ,"MASTER OT J104946.32+142938.5" ,null ,null ,"https://www.wis-tns.org/object/2021bbn" ,"162.443" ,"10:49:46.320" ,"MASTER" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbn", `TNSName`="AT2021bbn", `decDeg`="14.49403", `decSex`="+14:29:38.50", `discDate`="2021-01-24 00:32:30.048", `discMag`="16.9", `discMagFilter`="Clear-", `discSurvey`="MASTER", `discoveryName`="MASTER OT J104946.32+142938.5", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbn", `raDeg`="162.443", `raSex`="10:49:46.320", `reportingSurvey`="MASTER", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbm" ,"AT2021bbm" ,"68.591478" ,"+68:35:29.32" ,"2021-01-24 10:20:38.400" ,"17.412" ,"orange-ATLAS" ,"ATLAS" ,"ATLAS21dao" ,null ,null ,"https://www.wis-tns.org/object/2021bbm" ,"146.28030417" ,"09:45:07.273" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbm", `TNSName`="AT2021bbm", `decDeg`="68.591478", `decSex`="+68:35:29.32", `discDate`="2021-01-24 10:20:38.400", `discMag`="17.412", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS21dao", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbm", `raDeg`="146.28030417", `raSex`="09:45:07.273", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbl" ,"AT2021bbl" ,"-57.725131" ,"-57:43:30.47" ,"2021-01-22 17:21:07.200" ,"18.4" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akr" ,null ,null ,"https://www.wis-tns.org/object/2021bbl" ,"128.98" ,"08:35:55.200" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbl", `TNSName`="AT2021bbl", `decDeg`="-57.725131", `decSex`="-57:43:30.47", `discDate`="2021-01-22 17:21:07.200", `discMag`="18.4", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akr", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbl", `raDeg`="128.98", `raSex`="08:35:55.200", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbk" ,"AT2021bbk" ,"29.005511" ,"+29:00:19.84" ,"2021-01-22 19:40:48.000" ,"13.58" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akq" ,null ,null ,"https://www.wis-tns.org/object/2021bbk" ,"334.12975" ,"22:16:31.140" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbk", `TNSName`="AT2021bbk", `decDeg`="29.005511", `decSex`="+29:00:19.84", `discDate`="2021-01-22 19:40:48.000", `discMag`="13.58", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akq", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbk", `raDeg`="334.12975", `raSex`="22:16:31.140", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbj" ,"AT2021bbj" ,"52.556769" ,"+52:33:24.37" ,"2021-01-22 21:57:36.000" ,"17.41" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akp" ,null ,null ,"https://www.wis-tns.org/object/2021bbj" ,"315.1465416666667" ,"21:00:35.170" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbj", `TNSName`="AT2021bbj", `decDeg`="52.556769", `decSex`="+52:33:24.37", `discDate`="2021-01-22 21:57:36.000", `discMag`="17.41", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akp", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbj", `raDeg`="315.1465416666667", `raSex`="21:00:35.170", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbi" ,"AT2021bbi" ,"54.747539" ,"+54:44:51.14" ,"2021-01-23 02:15:21.600" ,"16.43" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ako" ,null ,null ,"https://www.wis-tns.org/object/2021bbi" ,"310.8307917" ,"20:43:19.390" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbi", `TNSName`="AT2021bbi", `decDeg`="54.747539", `decSex`="+54:44:51.14", `discDate`="2021-01-23 02:15:21.600", `discMag`="16.43", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ako", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbi", `raDeg`="310.8307917", `raSex`="20:43:19.390", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbh" ,"AT2021bbh" ,"-66.224831" ,"-66:13:29.39" ,"2021-01-22 17:54:14.400" ,"18.82" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akm" ,null ,null ,"https://www.wis-tns.org/object/2021bbh" ,"47.859875" ,"03:11:26.370" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbh", `TNSName`="AT2021bbh", `decDeg`="-66.224831", `decSex`="-66:13:29.39", `discDate`="2021-01-22 17:54:14.400", `discMag`="18.82", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akm", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbh", `raDeg`="47.859875", `raSex`="03:11:26.370", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbg" ,"AT2021bbg" ,"-67.64789" ,"-67:38:52.40" ,"2021-01-22 23:41:16.800" ,"17.17" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akl" ,null ,null ,"https://www.wis-tns.org/object/2021bbg" ,"84.0074583" ,"05:36:01.790" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbg", `TNSName`="AT2021bbg", `decDeg`="-67.64789", `decSex`="-67:38:52.40", `discDate`="2021-01-22 23:41:16.800", `discMag`="17.17", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akl", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbg", `raDeg`="84.0074583", `raSex`="05:36:01.790", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbf" ,"AT2021bbf" ,"-65.02953" ,"-65:01:46.30" ,"2021-01-23 07:58:44.544" ,"16.5" ,"Clear-" ,"MASTER" ,"MASTER OT J173617.84-650146.7" ,null ,null ,"https://www.wis-tns.org/object/2021bbf" ,"264.07425" ,"17:36:17.820" ,"MASTER" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `TNSName`="AT2021bbf", `decDeg`="-65.02953", `decSex`="-65:01:46.30", `discDate`="2021-01-23 07:58:44.544", `discMag`="16.5", `discMagFilter`="Clear-", `discSurvey`="MASTER", `discoveryName`="MASTER OT J173617.84-650146.7", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbf", `raDeg`="264.07425", `raSex`="17:36:17.820", `reportingSurvey`="MASTER", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbe" ,"AT2021bbe" ,"41.870469" ,"+41:52:13.69" ,"2021-01-23 02:38:55.968" ,"20" ,"Clear-" ,"GSNST" ,"GSNST-21ak" ,"2MASX J12390832+4152247" ,null ,"https://www.wis-tns.org/object/2021bbe" ,"189.7880917" ,"12:39:09.142" ,"GSNST" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbe", `TNSName`="AT2021bbe", `decDeg`="41.870469", `decSex`="+41:52:13.69", `discDate`="2021-01-23 02:38:55.968", `discMag`="20", `discMagFilter`="Clear-", `discSurvey`="GSNST", `discoveryName`="GSNST-21ak", `hostName`="2MASX J12390832+4152247", `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbe", `raDeg`="189.7880917", `raSex`="12:39:09.142", `reportingSurvey`="GSNST", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbd" ,"AT2021bbd" ,"-3.719044" ,"-03:43:08.56" ,"2021-01-17 14:36:57.600" ,"20.73" ,"g-Sloan" ,"Pan-STARRS1" ,"PS21oq" ,null ,null ,"https://www.wis-tns.org/object/2021bbd" ,"189.8944375" ,"12:39:34.665" ,"YSE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbd", `TNSName`="AT2021bbd", `decDeg`="-3.719044", `decSex`="-03:43:08.56", `discDate`="2021-01-17 14:36:57.600", `discMag`="20.73", `discMagFilter`="g-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21oq", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbd", `raDeg`="189.8944375", `raSex`="12:39:34.665", `reportingSurvey`="YSE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbc" ,"AT2021bbc" ,"-4.017644" ,"-04:01:03.52" ,"2021-01-15 14:05:16.800" ,"20.94" ,"g-Sloan" ,"Pan-STARRS1" ,"PS21op" ,null ,null ,"https://www.wis-tns.org/object/2021bbc" ,"194.22290833333332" ,"12:56:53.498" ,"YSE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbc", `TNSName`="AT2021bbc", `decDeg`="-4.017644", `decSex`="-04:01:03.52", `discDate`="2021-01-15 14:05:16.800", `discMag`="20.94", `discMagFilter`="g-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21op", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbc", `raDeg`="194.22290833333332", `raSex`="12:56:53.498", `reportingSurvey`="YSE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bbb" ,"AT2021bbb" ,"-3.27564" ,"-03:16:32.30" ,"2021-01-15 14:05:16.800" ,"20.56" ,"g-Sloan" ,"Pan-STARRS1" ,"PS21oo" ,null ,null ,"https://www.wis-tns.org/object/2021bbb" ,"194.85922917" ,"12:59:26.215" ,"YSE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbb", `TNSName`="AT2021bbb", `decDeg`="-3.27564", `decSex`="-03:16:32.30", `discDate`="2021-01-15 14:05:16.800", `discMag`="20.56", `discMagFilter`="g-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21oo", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bbb", `raDeg`="194.85922917", `raSex`="12:59:26.215", `reportingSurvey`="YSE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bba" ,"AT2021bba" ,"7.450317" ,"+07:27:01.14" ,"2021-01-15 11:52:48.000" ,"21.29" ,"w-PS1" ,"Pan-STARRS1" ,"PS21on" ,null ,null ,"https://www.wis-tns.org/object/2021bba" ,"166.34990416666668" ,"11:05:23.977" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bba", `TNSName`="AT2021bba", `decDeg`="7.450317", `decSex`="+07:27:01.14", `discDate`="2021-01-15 11:52:48.000", `discMag`="21.29", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21on", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bba", `raDeg`="166.34990416666668", `raSex`="11:05:23.977", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021baz" ,"AT2021baz" ,"17.512719" ,"+17:30:45.79" ,"2021-01-12 08:26:52.800" ,"21.91" ,"w-PS1" ,"Pan-STARRS1" ,"PS21om" ,null ,null ,"https://www.wis-tns.org/object/2021baz" ,"52.7751833" ,"03:31:06.044" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baz", `TNSName`="AT2021baz", `decDeg`="17.512719", `decSex`="+17:30:45.79", `discDate`="2021-01-12 08:26:52.800", `discMag`="21.91", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21om", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021baz", `raDeg`="52.7751833", `raSex`="03:31:06.044", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bay" ,"AT2021bay" ,"13.329628" ,"+13:19:46.66" ,"2021-01-14 15:36:00.000" ,"21.82" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ol" ,null ,null ,"https://www.wis-tns.org/object/2021bay" ,"152.63162083" ,"10:10:31.589" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bay", `TNSName`="AT2021bay", `decDeg`="13.329628", `decSex`="+13:19:46.66", `discDate`="2021-01-14 15:36:00.000", `discMag`="21.82", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ol", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bay", `raDeg`="152.63162083", `raSex`="10:10:31.589", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bax" ,"AT2021bax" ,"7.922272" ,"+07:55:20.18" ,"2021-01-15 14:21:07.200" ,"21.8" ,"w-PS1" ,"Pan-STARRS1" ,"PS21oj" ,null ,null ,"https://www.wis-tns.org/object/2021bax" ,"201.2218167" ,"13:24:53.236" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bax", `TNSName`="AT2021bax", `decDeg`="7.922272", `decSex`="+07:55:20.18", `discDate`="2021-01-15 14:21:07.200", `discMag`="21.8", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21oj", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bax", `raDeg`="201.2218167", `raSex`="13:24:53.236", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021baw" ,"AT2021baw" ,"14.188561" ,"+14:11:18.82" ,"2021-01-15 11:41:16.800" ,"21.85" ,"w-PS1" ,"Pan-STARRS1" ,"PS21oi" ,null ,null ,"https://www.wis-tns.org/object/2021baw" ,"155.05238333333332" ,"10:20:12.572" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baw", `TNSName`="AT2021baw", `decDeg`="14.188561", `decSex`="+14:11:18.82", `discDate`="2021-01-15 11:41:16.800", `discMag`="21.85", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21oi", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021baw", `raDeg`="155.05238333333332", `raSex`="10:20:12.572", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bav" ,"AT2021bav" ,"35.002533" ,"+35:00:09.12" ,"2021-01-16 05:44:09.600" ,"20.64" ,"w-PS1" ,"Pan-STARRS1" ,"PS21oh" ,null ,null ,"https://www.wis-tns.org/object/2021bav" ,"40.8252583" ,"02:43:18.062" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bav", `TNSName`="AT2021bav", `decDeg`="35.002533", `decSex`="+35:00:09.12", `discDate`="2021-01-16 05:44:09.600", `discMag`="20.64", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21oh", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bav", `raDeg`="40.8252583", `raSex`="02:43:18.062", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bau" ,"AT2021bau" ,"20.072264" ,"+20:04:20.15" ,"2021-01-12 09:15:50.400" ,"21.47" ,"w-PS1" ,"Pan-STARRS1" ,"PS21of" ,null ,null ,"https://www.wis-tns.org/object/2021bau" ,"53.9697667" ,"03:35:52.744" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bau", `TNSName`="AT2021bau", `decDeg`="20.072264", `decSex`="+20:04:20.15", `discDate`="2021-01-12 09:15:50.400", `discMag`="21.47", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21of", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bau", `raDeg`="53.9697667", `raSex`="03:35:52.744", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bat" ,"AT2021bat" ,"-22.577003" ,"-22:34:37.21" ,"2021-01-16 06:57:36.000" ,"21.82" ,"w-PS1" ,"Pan-STARRS1" ,"PS21oe" ,null ,null ,"https://www.wis-tns.org/object/2021bat" ,"72.67945416666667" ,"04:50:43.069" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bat", `TNSName`="AT2021bat", `decDeg`="-22.577003", `decSex`="-22:34:37.21", `discDate`="2021-01-16 06:57:36.000", `discMag`="21.82", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21oe", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bat", `raDeg`="72.67945416666667", `raSex`="04:50:43.069", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bas" ,"AT2021bas" ,"52.415203" ,"+52:24:54.73" ,"2021-01-07 15:33:07.200" ,"21.83" ,"i-Sloan" ,"Pan-STARRS1" ,"PS21od" ,null ,null ,"https://www.wis-tns.org/object/2021bas" ,"161.7860125" ,"10:47:08.643" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bas", `TNSName`="AT2021bas", `decDeg`="52.415203", `decSex`="+52:24:54.73", `discDate`="2021-01-07 15:33:07.200", `discMag`="21.83", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21od", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bas", `raDeg`="161.7860125", `raSex`="10:47:08.643", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bar" ,"AT2021bar" ,"18.560983" ,"+18:33:39.54" ,"2021-01-16 09:14:24.000" ,"21.19" ,"w-PS1" ,"Pan-STARRS1" ,"PS21oc" ,null ,null ,"https://www.wis-tns.org/object/2021bar" ,"129.29302917" ,"08:37:10.327" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bar", `TNSName`="AT2021bar", `decDeg`="18.560983", `decSex`="+18:33:39.54", `discDate`="2021-01-16 09:14:24.000", `discMag`="21.19", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21oc", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bar", `raDeg`="129.29302917", `raSex`="08:37:10.327", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021baq" ,"AT2021baq" ,"40.781153" ,"+40:46:52.15" ,"2021-01-17 14:58:33.600" ,"21.41" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ob" ,null ,null ,"https://www.wis-tns.org/object/2021baq" ,"166.18181666666666" ,"11:04:43.636" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baq", `TNSName`="AT2021baq", `decDeg`="40.781153", `decSex`="+40:46:52.15", `discDate`="2021-01-17 14:58:33.600", `discMag`="21.41", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ob", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021baq", `raDeg`="166.18181666666666", `raSex`="11:04:43.636", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bap" ,"AT2021bap" ,"36.710536" ,"+36:42:37.93" ,"2021-01-17 15:01:26.400" ,"21.39" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nz" ,null ,null ,"https://www.wis-tns.org/object/2021bap" ,"169.07159583" ,"11:16:17.183" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bap", `TNSName`="AT2021bap", `decDeg`="36.710536", `decSex`="+36:42:37.93", `discDate`="2021-01-17 15:01:26.400", `discMag`="21.39", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nz", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bap", `raDeg`="169.07159583", `raSex`="11:16:17.183", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bao" ,"AT2021bao" ,"10.750772" ,"+10:45:02.78" ,"2021-01-14 15:21:36.000" ,"21.05" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ny" ,null ,null ,"https://www.wis-tns.org/object/2021bao" ,"151.8690625" ,"10:07:28.575" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bao", `TNSName`="AT2021bao", `decDeg`="10.750772", `decSex`="+10:45:02.78", `discDate`="2021-01-14 15:21:36.000", `discMag`="21.05", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ny", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bao", `raDeg`="151.8690625", `raSex`="10:07:28.575", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ban" ,"AT2021ban" ,"-20.004567" ,"-20:00:16.44" ,"2021-01-16 06:46:04.800" ,"20.69" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nx" ,null ,null ,"https://www.wis-tns.org/object/2021ban" ,"60.894" ,"04:03:34.560" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ban", `TNSName`="AT2021ban", `decDeg`="-20.004567", `decSex`="-20:00:16.44", `discDate`="2021-01-16 06:46:04.800", `discMag`="20.69", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nx", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021ban", `raDeg`="60.894", `raSex`="04:03:34.560", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bam" ,"AT2021bam" ,"20.266708" ,"+20:16:00.15" ,"2021-01-12 08:22:33.600" ,"21.76" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nv" ,null ,null ,"https://www.wis-tns.org/object/2021bam" ,"53.645175" ,"03:34:34.842" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bam", `TNSName`="AT2021bam", `decDeg`="20.266708", `decSex`="+20:16:00.15", `discDate`="2021-01-12 08:22:33.600", `discMag`="21.76", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nv", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bam", `raDeg`="53.645175", `raSex`="03:34:34.842", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bal" ,"AT2021bal" ,"-21.359131" ,"-21:21:32.87" ,"2021-01-16 06:54:43.200" ,"20.99" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nu" ,null ,null ,"https://www.wis-tns.org/object/2021bal" ,"69.8445417" ,"04:39:22.690" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bal", `TNSName`="AT2021bal", `decDeg`="-21.359131", `decSex`="-21:21:32.87", `discDate`="2021-01-16 06:54:43.200", `discMag`="20.99", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nu", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bal", `raDeg`="69.8445417", `raSex`="04:39:22.690", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bak" ,"AT2021bak" ,"51.934253" ,"+51:56:03.31" ,"2021-01-12 09:28:48.000" ,"21.05" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ns" ,null ,null ,"https://www.wis-tns.org/object/2021bak" ,"92.99382917" ,"06:11:58.519" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bak", `TNSName`="AT2021bak", `decDeg`="51.934253", `decSex`="+51:56:03.31", `discDate`="2021-01-12 09:28:48.000", `discMag`="21.05", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ns", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bak", `raDeg`="92.99382917", `raSex`="06:11:58.519", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021baj" ,"AT2021baj" ,"13.437375" ,"+13:26:14.55" ,"2021-01-16 10:32:09.600" ,"21.39" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nq" ,null ,null ,"https://www.wis-tns.org/object/2021baj" ,"146.032475" ,"09:44:07.794" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baj", `TNSName`="AT2021baj", `decDeg`="13.437375", `decSex`="+13:26:14.55", `discDate`="2021-01-16 10:32:09.600", `discMag`="21.39", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nq", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021baj", `raDeg`="146.032475", `raSex`="09:44:07.794", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bai" ,"AT2021bai" ,"43.733997" ,"+43:44:02.39" ,"2021-01-17 15:07:12.000" ,"20.78" ,"w-PS1" ,"Pan-STARRS1" ,"PS21np" ,null ,null ,"https://www.wis-tns.org/object/2021bai" ,"178.296583" ,"11:53:11.180" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bai", `TNSName`="AT2021bai", `decDeg`="43.733997", `decSex`="+43:44:02.39", `discDate`="2021-01-17 15:07:12.000", `discMag`="20.78", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21np", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bai", `raDeg`="178.296583", `raSex`="11:53:11.180", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bah" ,"AT2021bah" ,"-56.619519" ,"-56:37:10.27" ,"2021-01-21 23:16:48.000" ,"18.34" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akk" ,null ,null ,"https://www.wis-tns.org/object/2021bah" ,"137.530917" ,"09:10:07.420" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bah", `TNSName`="AT2021bah", `decDeg`="-56.619519", `decSex`="-56:37:10.27", `discDate`="2021-01-21 23:16:48.000", `discMag`="18.34", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akk", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bah", `raDeg`="137.530917", `raSex`="09:10:07.420", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bag" ,"AT2021bag" ,"42.277769" ,"+42:16:39.97" ,"2021-01-21 15:41:45.600" ,"12.06" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akj" ,null ,null ,"https://www.wis-tns.org/object/2021bag" ,"330.680375" ,"22:02:43.290" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bag", `TNSName`="AT2021bag", `decDeg`="42.277769", `decSex`="+42:16:39.97", `discDate`="2021-01-21 15:41:45.600", `discMag`="12.06", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akj", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bag", `raDeg`="330.680375", `raSex`="22:02:43.290", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021baf" ,"AT2021baf" ,"39.405839" ,"+39:24:21.02" ,"2021-01-22 03:37:26.400" ,"12.2" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21aki" ,null ,null ,"https://www.wis-tns.org/object/2021baf" ,"182.63575" ,"12:10:32.580" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baf", `TNSName`="AT2021baf", `decDeg`="39.405839", `decSex`="+39:24:21.02", `discDate`="2021-01-22 03:37:26.400", `discMag`="12.2", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21aki", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021baf", `raDeg`="182.63575", `raSex`="12:10:32.580", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bae" ,"AT2021bae" ,"-69.835961" ,"-69:50:09.46" ,"2021-01-22 11:44:09.600" ,"16.67" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akg" ,null ,null ,"https://www.wis-tns.org/object/2021bae" ,"74.45904166666666" ,"04:57:50.170" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bae", `TNSName`="AT2021bae", `decDeg`="-69.835961", `decSex`="-69:50:09.46", `discDate`="2021-01-22 11:44:09.600", `discMag`="16.67", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akg", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bae", `raDeg`="74.45904166666666", `raSex`="04:57:50.170", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bad" ,"AT2021bad" ,"-43.1532" ,"-43:09:11.52" ,"2021-01-22 11:03:50.400" ,"18.42" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akf" ,null ,null ,"https://www.wis-tns.org/object/2021bad" ,"147.23625" ,"09:48:56.700" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bad", `TNSName`="AT2021bad", `decDeg`="-43.1532", `decSex`="-43:09:11.52", `discDate`="2021-01-22 11:03:50.400", `discMag`="18.42", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akf", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bad", `raDeg`="147.23625", `raSex`="09:48:56.700", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bac" ,"AT2021bac" ,"-55.305069" ,"-55:18:18.25" ,"2021-01-04 06:10:04.800" ,"19.84" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ake" ,null ,null ,"https://www.wis-tns.org/object/2021bac" ,"12.273333" ,"00:49:05.600" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bac", `TNSName`="AT2021bac", `decDeg`="-55.305069", `decSex`="-55:18:18.25", `discDate`="2021-01-04 06:10:04.800", `discMag`="19.84", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ake", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bac", `raDeg`="12.273333", `raSex`="00:49:05.600", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bab" ,"AT2021bab" ,"41.336089" ,"+41:20:09.92" ,"2021-01-22 05:21:07.200" ,"19.62" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21akc" ,null ,null ,"https://www.wis-tns.org/object/2021bab" ,"184.214125" ,"12:16:51.390" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bab", `TNSName`="AT2021bab", `decDeg`="41.336089", `decSex`="+41:20:09.92", `discDate`="2021-01-22 05:21:07.200", `discMag`="19.62", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21akc", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bab", `raDeg`="184.214125", `raSex`="12:16:51.390", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021baa" ,"AT2021baa" ,"37.94206" ,"+37:56:31.40" ,"2021-01-03 15:23:02.400" ,"20.35" ,"i-Sloan" ,"Pan-STARRS1" ,"PS21no" ,null ,null ,"https://www.wis-tns.org/object/2021baa" ,"216.4583125" ,"14:25:49.995" ,"YSE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baa", `TNSName`="AT2021baa", `decDeg`="37.94206", `decSex`="+37:56:31.40", `discDate`="2021-01-03 15:23:02.400", `discMag`="20.35", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21no", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021baa", `raDeg`="216.4583125", `raSex`="14:25:49.995", `reportingSurvey`="YSE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azz" ,"AT2021azz" ,"-8.488983" ,"-08:29:20.34" ,"2021-01-15 10:45:07.200" ,"20.55" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nn" ,null ,null ,"https://www.wis-tns.org/object/2021azz" ,"128.3047917" ,"08:33:13.150" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azz", `TNSName`="AT2021azz", `decDeg`="-8.488983", `decSex`="-08:29:20.34", `discDate`="2021-01-15 10:45:07.200", `discMag`="20.55", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nn", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azz", `raDeg`="128.3047917", `raSex`="08:33:13.150", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azy" ,"AT2021azy" ,"14.659703" ,"+14:39:34.93" ,"2021-01-15 14:24:00.000" ,"21.17" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nm" ,null ,null ,"https://www.wis-tns.org/object/2021azy" ,"204.03090417" ,"13:36:07.417" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azy", `TNSName`="AT2021azy", `decDeg`="14.659703", `decSex`="+14:39:34.93", `discDate`="2021-01-15 14:24:00.000", `discMag`="21.17", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nm", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azy", `raDeg`="204.03090417", `raSex`="13:36:07.417", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azx" ,"AT2021azx" ,"-19.422469" ,"-19:25:20.89" ,"2021-01-16 06:46:04.800" ,"20.54" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nl" ,null ,null ,"https://www.wis-tns.org/object/2021azx" ,"62.25485417" ,"04:09:01.165" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azx", `TNSName`="AT2021azx", `decDeg`="-19.422469", `decSex`="-19:25:20.89", `discDate`="2021-01-16 06:46:04.800", `discMag`="20.54", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nl", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azx", `raDeg`="62.25485417", `raSex`="04:09:01.165", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azw" ,"AT2021azw" ,"-3.63428" ,"-03:38:03.40" ,"2021-01-05 06:44:38.400" ,"20.99" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nk" ,null ,null ,"https://www.wis-tns.org/object/2021azw" ,"40.06082917" ,"02:40:14.599" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azw", `TNSName`="AT2021azw", `decDeg`="-3.63428", `decSex`="-03:38:03.40", `discDate`="2021-01-05 06:44:38.400", `discMag`="20.99", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nk", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azw", `raDeg`="40.06082917", `raSex`="02:40:14.599", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azv" ,"AT2021azv" ,"10.392675" ,"+10:23:33.63" ,"2021-01-16 10:22:04.800" ,"20.71" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nf" ,null ,null ,"https://www.wis-tns.org/object/2021azv" ,"141.18762083333334" ,"09:24:45.029" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azv", `TNSName`="AT2021azv", `decDeg`="10.392675", `decSex`="+10:23:33.63", `discDate`="2021-01-16 10:22:04.800", `discMag`="20.71", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nf", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azv", `raDeg`="141.18762083333334", `raSex`="09:24:45.029", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azu" ,"AT2021azu" ,"-13.035147" ,"-13:02:06.53" ,"2021-01-14 07:17:45.600" ,"21.37" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nd" ,null ,null ,"https://www.wis-tns.org/object/2021azu" ,"69.8732917" ,"04:39:29.590" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azu", `TNSName`="AT2021azu", `decDeg`="-13.035147", `decSex`="-13:02:06.53", `discDate`="2021-01-14 07:17:45.600", `discMag`="21.37", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nd", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azu", `raDeg`="69.8732917", `raSex`="04:39:29.590", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azt" ,"AT2021azt" ,"-14.096269" ,"-14:05:46.57" ,"2021-01-12 06:54:43.200" ,"21.18" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nc" ,null ,null ,"https://www.wis-tns.org/object/2021azt" ,"44.44824166666667" ,"02:57:47.578" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azt", `TNSName`="AT2021azt", `decDeg`="-14.096269", `decSex`="-14:05:46.57", `discDate`="2021-01-12 06:54:43.200", `discMag`="21.18", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nc", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azt", `raDeg`="44.44824166666667", `raSex`="02:57:47.578", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azs" ,"AT2021azs" ,"-2.38683" ,"-02:23:12.60" ,"2021-01-06 05:36:57.600" ,"20.93" ,"w-PS1" ,"Pan-STARRS1" ,"PS21nb" ,null ,null ,"https://www.wis-tns.org/object/2021azs" ,"11.29707083" ,"00:45:11.297" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azs", `TNSName`="AT2021azs", `decDeg`="-2.38683", `decSex`="-02:23:12.60", `discDate`="2021-01-06 05:36:57.600", `discMag`="20.93", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21nb", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azs", `raDeg`="11.29707083", `raSex`="00:45:11.297", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azr" ,"AT2021azr" ,"8.976822" ,"+08:58:36.56" ,"2021-01-15 14:28:19.200" ,"21.24" ,"w-PS1" ,"Pan-STARRS1" ,"PS21my" ,null ,null ,"https://www.wis-tns.org/object/2021azr" ,"208.6087333" ,"13:54:26.096" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azr", `TNSName`="AT2021azr", `decDeg`="8.976822", `decSex`="+08:58:36.56", `discDate`="2021-01-15 14:28:19.200", `discMag`="21.24", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21my", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azr", `raDeg`="208.6087333", `raSex`="13:54:26.096", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azq" ,"AT2021azq" ,"-4.685572" ,"-04:41:08.06" ,"2021-01-07 07:49:26.400" ,"20.92" ,"w-PS1" ,"Pan-STARRS1" ,"PS21mx" ,null ,null ,"https://www.wis-tns.org/object/2021azq" ,"48.71810833333333" ,"03:14:52.346" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azq", `TNSName`="AT2021azq", `decDeg`="-4.685572", `decSex`="-04:41:08.06", `discDate`="2021-01-07 07:49:26.400", `discMag`="20.92", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21mx", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azq", `raDeg`="48.71810833333333", `raSex`="03:14:52.346", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azp" ,"AT2021azp" ,"22.81864" ,"+22:49:07.10" ,"2021-01-12 08:29:45.600" ,"21.07" ,"w-PS1" ,"Pan-STARRS1" ,"PS21mw" ,null ,null ,"https://www.wis-tns.org/object/2021azp" ,"57.9427875" ,"03:51:46.269" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azp", `TNSName`="AT2021azp", `decDeg`="22.81864", `decSex`="+22:49:07.10", `discDate`="2021-01-12 08:29:45.600", `discMag`="21.07", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21mw", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azp", `raDeg`="57.9427875", `raSex`="03:51:46.269", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azo" ,"AT2021azo" ,"-20.927542" ,"-20:55:39.15" ,"2021-01-07 11:32:38.400" ,"18.39" ,"g-ZTF" ,"ZTF" ,"ZTF21aagkfgh" ,null ,null ,"https://www.wis-tns.org/object/2021azo" ,"178.90097917" ,"11:55:36.235" ,"ZTF" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azo", `TNSName`="AT2021azo", `decDeg`="-20.927542", `decSex`="-20:55:39.15", `discDate`="2021-01-07 11:32:38.400", `discMag`="18.39", `discMagFilter`="g-ZTF", `discSurvey`="ZTF", `discoveryName`="ZTF21aagkfgh", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azo", `raDeg`="178.90097917", `raSex`="11:55:36.235", `reportingSurvey`="ZTF", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azn" ,"AT2021azn" ,"58.830669" ,"+58:49:50.41" ,"2021-01-20 20:12:28.800" ,"19.31" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21aka" ,null ,null ,"https://www.wis-tns.org/object/2021azn" ,"324.291125" ,"21:37:09.870" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azn", `TNSName`="AT2021azn", `decDeg`="58.830669", `decSex`="+58:49:50.41", `discDate`="2021-01-20 20:12:28.800", `discMag`="19.31", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21aka", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azn", `raDeg`="324.291125", `raSex`="21:37:09.870", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azm" ,"AT2021azm" ,"-64.015561" ,"-64:00:56.02" ,"2021-01-21 05:22:33.600" ,"16.47" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajz" ,null ,null ,"https://www.wis-tns.org/object/2021azm" ,"134.14220833333334" ,"08:56:34.130" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azm", `TNSName`="AT2021azm", `decDeg`="-64.015561", `decSex`="-64:00:56.02", `discDate`="2021-01-21 05:22:33.600", `discMag`="16.47", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajz", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azm", `raDeg`="134.14220833333334", `raSex`="08:56:34.130", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azl" ,"AT2021azl" ,"42.725489" ,"+42:43:31.76" ,"2021-01-21 01:55:12.000" ,"17.13" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajy" ,null ,null ,"https://www.wis-tns.org/object/2021azl" ,"333.095833" ,"22:12:23.000" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azl", `TNSName`="AT2021azl", `decDeg`="42.725489", `decSex`="+42:43:31.76", `discDate`="2021-01-21 01:55:12.000", `discMag`="17.13", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajy", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azl", `raDeg`="333.095833", `raSex`="22:12:23.000", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azk" ,"AT2021azk" ,"75.436789" ,"+75:26:12.44" ,"2021-01-20 10:20:38.400" ,"18.75" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajx" ,null ,null ,"https://www.wis-tns.org/object/2021azk" ,"295.4647083" ,"19:41:51.530" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azk", `TNSName`="AT2021azk", `decDeg`="75.436789", `decSex`="+75:26:12.44", `discDate`="2021-01-20 10:20:38.400", `discMag`="18.75", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajx", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azk", `raDeg`="295.4647083", `raSex`="19:41:51.530", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azj" ,"AT2021azj" ,"-48.113431" ,"-48:06:48.35" ,"2021-01-21 00:18:43.200" ,"17.46" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajt" ,null ,null ,"https://www.wis-tns.org/object/2021azj" ,"2.4752917" ,"00:09:54.070" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azj", `TNSName`="AT2021azj", `decDeg`="-48.113431", `decSex`="-48:06:48.35", `discDate`="2021-01-21 00:18:43.200", `discMag`="17.46", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajt", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azj", `raDeg`="2.4752917", `raSex`="00:09:54.070", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azi" ,"AT2021azi" ,"55.893989" ,"+55:53:38.36" ,"2021-01-20 21:18:43.200" ,"18.91" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajr" ,null ,null ,"https://www.wis-tns.org/object/2021azi" ,"186.84879166666667" ,"12:27:23.710" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azi", `TNSName`="AT2021azi", `decDeg`="55.893989", `decSex`="+55:53:38.36", `discDate`="2021-01-20 21:18:43.200", `discMag`="18.91", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajr", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azi", `raDeg`="186.84879166666667", `raSex`="12:27:23.710", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azh" ,"AT2021azh" ,"59.112839" ,"+59:06:46.22" ,"2021-01-21 08:15:21.600" ,"18.61" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajp" ,null ,null ,"https://www.wis-tns.org/object/2021azh" ,"319.659125" ,"21:18:38.190" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azh", `TNSName`="AT2021azh", `decDeg`="59.112839", `decSex`="+59:06:46.22", `discDate`="2021-01-21 08:15:21.600", `discMag`="18.61", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajp", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azh", `raDeg`="319.659125", `raSex`="21:18:38.190", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azg" ,"AT2021azg" ,"-64.694881" ,"-64:41:41.57" ,"2021-01-21 06:01:26.400" ,"18.66" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajo" ,null ,null ,"https://www.wis-tns.org/object/2021azg" ,"20.3285" ,"01:21:18.840" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azg", `TNSName`="AT2021azg", `decDeg`="-64.694881", `decSex`="-64:41:41.57", `discDate`="2021-01-21 06:01:26.400", `discMag`="18.66", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajo", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azg", `raDeg`="20.3285", `raSex`="01:21:18.840", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azf" ,"AT2021azf" ,"-25.84761" ,"-25:50:51.40" ,"2021-01-20 16:43:40.800" ,"18.96" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajn" ,null ,null ,"https://www.wis-tns.org/object/2021azf" ,"160.37495833333332" ,"10:41:29.990" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azf", `TNSName`="AT2021azf", `decDeg`="-25.84761", `decSex`="-25:50:51.40", `discDate`="2021-01-20 16:43:40.800", `discMag`="18.96", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajn", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azf", `raDeg`="160.37495833333332", `raSex`="10:41:29.990", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aze" ,"AT2021aze" ,"32.044869" ,"+32:02:41.53" ,"2021-01-20 15:46:04.800" ,"18.53" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajm" ,null ,null ,"https://www.wis-tns.org/object/2021aze" ,"174.491625" ,"11:37:57.990" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aze", `TNSName`="AT2021aze", `decDeg`="32.044869", `decSex`="+32:02:41.53", `discDate`="2021-01-20 15:46:04.800", `discMag`="18.53", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajm", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021aze", `raDeg`="174.491625", `raSex`="11:37:57.990", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azd" ,"AT2021azd" ,"39.519" ,"+39:31:08.40" ,"2021-01-19 19:49:26.400" ,"14.74" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21ajl" ,null ,null ,"https://www.wis-tns.org/object/2021azd" ,"339.423667" ,"22:37:41.680" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azd", `TNSName`="AT2021azd", `decDeg`="39.519", `decSex`="+39:31:08.40", `discDate`="2021-01-19 19:49:26.400", `discMag`="14.74", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21ajl", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azd", `raDeg`="339.423667", `raSex`="22:37:41.680", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azc" ,"AT2021azc" ,"-40.623892" ,"-40:37:26.01" ,"2021-01-21 14:39:50.400" ,"18.919" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS21dan" ,null ,null ,"https://www.wis-tns.org/object/2021azc" ,"158.6706" ,"10:34:40.944" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azc", `TNSName`="AT2021azc", `decDeg`="-40.623892", `decSex`="-40:37:26.01", `discDate`="2021-01-21 14:39:50.400", `discMag`="18.919", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS21dan", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azc", `raDeg`="158.6706", `raSex`="10:34:40.944", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021azb" ,"AT2021azb" ,"-33.300153" ,"-33:18:00.55" ,"2021-01-21 15:04:19.200" ,"19.376" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS21dal" ,null ,null ,"https://www.wis-tns.org/object/2021azb" ,"167.89870417" ,"11:11:35.689" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azb", `TNSName`="AT2021azb", `decDeg`="-33.300153", `decSex`="-33:18:00.55", `discDate`="2021-01-21 15:04:19.200", `discMag`="19.376", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS21dal", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021azb", `raDeg`="167.89870417", `raSex`="11:11:35.689", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aza" ,"AT2021aza" ,"-18.031847" ,"-18:01:54.65" ,"2021-01-21 14:47:02.400" ,"19.326" ,"cyan-ATLAS" ,"ATLAS" ,"ATLAS21dak" ,null ,null ,"https://www.wis-tns.org/object/2021aza" ,"156.258875" ,"10:25:02.130" ,"ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aza", `TNSName`="AT2021aza", `decDeg`="-18.031847", `decSex`="-18:01:54.65", `discDate`="2021-01-21 14:47:02.400", `discMag`="19.326", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS", `discoveryName`="ATLAS21dak", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021aza", `raDeg`="156.258875", `raSex`="10:25:02.130", `reportingSurvey`="ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ayz" ,"AT2021ayz" ,"-2.98811" ,"-02:59:17.20" ,"2021-01-05 07:49:26.400" ,"21.47" ,"w-PS1" ,"Pan-STARRS1" ,"PS21mt" ,null ,null ,"https://www.wis-tns.org/object/2021ayz" ,"62.58019583" ,"04:10:19.247" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ayz", `TNSName`="AT2021ayz", `decDeg`="-2.98811", `decSex`="-02:59:17.20", `discDate`="2021-01-05 07:49:26.400", `discMag`="21.47", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21mt", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021ayz", `raDeg`="62.58019583", `raSex`="04:10:19.247", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021avg" ,"SN2021avg" ,"14.527969" ,"+14:31:40.69" ,"2021-01-17 12:25:55.200" ,"19.499" ,"cyan-ATLAS" ,"ATLAS, ZTF, GaiaAlerts" ,"ATLAS21cux" ,null ,null ,"https://www.wis-tns.org/object/2021avg" ,"174.99575" ,"11:39:58.980" ,"ATLAS, ZTF, GaiaAlerts" ,"SN II" ,"0.031", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `TNSName`="SN2021avg", `decDeg`="14.527969", `decSex`="+14:31:40.69", `discDate`="2021-01-17 12:25:55.200", `discMag`="19.499", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, ZTF, GaiaAlerts", `discoveryName`="ATLAS21cux", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021avg", `raDeg`="174.99575", `raSex`="11:39:58.980", `reportingSurvey`="ATLAS, ZTF, GaiaAlerts", `specType`="SN II", `transRedshift`="0.031" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aul" ,"SN2021aul" ,"5.142872" ,"+05:08:34.34" ,"2021-01-18 10:29:49.001" ,"18.9834" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF21aagbeah" ,"CGCG 037-048" ,"0.040002" ,"https://www.wis-tns.org/object/2021aul" ,"157.29195" ,"10:29:10.068" ,"ALeRCE, ATLAS, Pan-STARRS1" ,"SN II" ,"0.04", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aul", `TNSName`="SN2021aul", `decDeg`="5.142872", `decSex`="+05:08:34.34", `discDate`="2021-01-18 10:29:49.001", `discMag`="18.9834", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF21aagbeah", `hostName`="CGCG 037-048", `hostRedshift`="0.040002", `objectUrl`="https://www.wis-tns.org/object/2021aul", `raDeg`="157.29195", `raSex`="10:29:10.068", `reportingSurvey`="ALeRCE, ATLAS, Pan-STARRS1", `specType`="SN II", `transRedshift`="0.04" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021atv" ,"AT2021atv" ,"-9.003106" ,"-09:00:11.18" ,"2021-01-14 10:51:42.998" ,"20.7315" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aagclzp" ,null ,null ,"https://www.wis-tns.org/object/2021atv" ,"166.73445417" ,"11:06:56.269" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021atv", `TNSName`="AT2021atv", `decDeg`="-9.003106", `decSex`="-09:00:11.18", `discDate`="2021-01-14 10:51:42.998", `discMag`="20.7315", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aagclzp", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021atv", `raDeg`="166.73445417", `raSex`="11:06:56.269", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aqq" ,"SN2021aqq" ,"41.574219" ,"+41:34:27.19" ,"2021-01-15 10:41:32.997" ,"20.5625" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aafjjee" ,"WISEA J104433.53+413429.2" ,"0.049234" ,"https://www.wis-tns.org/object/2021aqq" ,"161.14073333333334" ,"10:44:33.776" ,"ALeRCE, Pan-STARRS1" ,"SN Ia" ,"0.04918", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aqq", `TNSName`="SN2021aqq", `decDeg`="41.574219", `decSex`="+41:34:27.19", `discDate`="2021-01-15 10:41:32.997", `discMag`="20.5625", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aafjjee", `hostName`="WISEA J104433.53+413429.2", `hostRedshift`="0.049234", `objectUrl`="https://www.wis-tns.org/object/2021aqq", `raDeg`="161.14073333333334", `raSex`="10:44:33.776", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.04918" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021apj" ,"AT2021apj" ,"42.69039" ,"+42:41:25.40" ,"2021-01-11 09:48:05.000" ,"20.1114" ,"r-ZTF" ,"ZTF, GaiaAlerts" ,"ZTF21aaeolfd" ,"WISEA J121754.96+424132.9" ,"0.073284" ,"https://www.wis-tns.org/object/2021apj" ,"184.47225" ,"12:17:53.340" ,"ALeRCE, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `TNSName`="AT2021apj", `decDeg`="42.69039", `decSex`="+42:41:25.40", `discDate`="2021-01-11 09:48:05.000", `discMag`="20.1114", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, GaiaAlerts", `discoveryName`="ZTF21aaeolfd", `hostName`="WISEA J121754.96+424132.9", `hostRedshift`="0.073284", `objectUrl`="https://www.wis-tns.org/object/2021apj", `raDeg`="184.47225", `raSex`="12:17:53.340", `reportingSurvey`="ALeRCE, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021apd" ,"SN2021apd" ,"3.755244" ,"+03:45:18.88" ,"2021-01-13 05:24:00.000" ,"19.77" ,"i-Sloan" ,"Pan-STARRS1, ATLAS" ,"PS21iw" ,null ,null ,"https://www.wis-tns.org/object/2021apd" ,"16.37522917" ,"01:05:30.055" ,"YSE, ATLAS, Pan-STARRS1" ,"SN Ia" ,"0.1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apd", `TNSName`="SN2021apd", `decDeg`="3.755244", `decSex`="+03:45:18.88", `discDate`="2021-01-13 05:24:00.000", `discMag`="19.77", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1, ATLAS", `discoveryName`="PS21iw", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021apd", `raDeg`="16.37522917", `raSex`="01:05:30.055", `reportingSurvey`="YSE, ATLAS, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.1" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aog" ,"AT2021aog" ,"14.4267" ,"+14:25:36.12" ,"2021-01-09 02:55:40.800" ,"19.52" ,"r-ZTF" ,"ZTF, GaiaAlerts" ,"ZTF18abxptoa" ,null ,null ,"https://www.wis-tns.org/object/2021aog" ,"343.32875" ,"22:53:18.900" ,"ZTF, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aog", `TNSName`="AT2021aog", `decDeg`="14.4267", `decSex`="+14:25:36.12", `discDate`="2021-01-09 02:55:40.800", `discMag`="19.52", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, GaiaAlerts", `discoveryName`="ZTF18abxptoa", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021aog", `raDeg`="343.32875", `raSex`="22:53:18.900", `reportingSurvey`="ZTF, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ajh" ,"AT2021ajh" ,"50.704311" ,"+50:42:15.52" ,"2021-01-14 13:47:59.000" ,"19.222" ,"cyan-ATLAS" ,"ATLAS, GaiaAlerts" ,"ATLAS21bto" ,null ,null ,"https://www.wis-tns.org/object/2021ajh" ,"182.5035417" ,"12:10:00.850" ,"ATLAS, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ajh", `TNSName`="AT2021ajh", `decDeg`="50.704311", `decSex`="+50:42:15.52", `discDate`="2021-01-14 13:47:59.000", `discMag`="19.222", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, GaiaAlerts", `discoveryName`="ATLAS21bto", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021ajh", `raDeg`="182.5035417", `raSex`="12:10:00.850", `reportingSurvey`="ATLAS, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aii" ,"AT2021aii" ,"34.907814" ,"+34:54:28.13" ,"2021-01-14 07:53:21.002" ,"20.4813" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aaefmlt" ,"SDSS J074007.48+345427.7" ,"0.314" ,"https://www.wis-tns.org/object/2021aii" ,"115.03189583" ,"07:40:07.655" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aii", `TNSName`="AT2021aii", `decDeg`="34.907814", `decSex`="+34:54:28.13", `discDate`="2021-01-14 07:53:21.002", `discMag`="20.4813", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aaefmlt", `hostName`="SDSS J074007.48+345427.7", `hostRedshift`="0.314", `objectUrl`="https://www.wis-tns.org/object/2021aii", `raDeg`="115.03189583", `raSex`="07:40:07.655", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aib" ,"AT2021aib" ,"-13.984894" ,"-13:59:05.62" ,"2021-01-12 13:01:05.002" ,"20.1539" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF21aaeknki" ,"WISEA J144836.55-135904.9" ,"0.09657" ,"https://www.wis-tns.org/object/2021aib" ,"222.15072083" ,"14:48:36.173" ,"ALeRCE, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aib", `TNSName`="AT2021aib", `decDeg`="-13.984894", `decSex`="-13:59:05.62", `discDate`="2021-01-12 13:01:05.002", `discMag`="20.1539", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF21aaeknki", `hostName`="WISEA J144836.55-135904.9", `hostRedshift`="0.09657", `objectUrl`="https://www.wis-tns.org/object/2021aib", `raDeg`="222.15072083", `raSex`="14:48:36.173", `reportingSurvey`="ALeRCE, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aew" ,"AT2021aew" ,"-18.533411" ,"-18:32:00.28" ,"2021-01-13 08:31:12.000" ,"19.707" ,"cyan-ATLAS" ,"ATLAS, Pan-STARRS1" ,"ATLAS21brr" ,null ,null ,"https://www.wis-tns.org/object/2021aew" ,"62.4047625" ,"04:09:37.143" ,"ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aew", `TNSName`="AT2021aew", `decDeg`="-18.533411", `decSex`="-18:32:00.28", `discDate`="2021-01-13 08:31:12.000", `discMag`="19.707", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, Pan-STARRS1", `discoveryName`="ATLAS21brr", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021aew", `raDeg`="62.4047625", `raSex`="04:09:37.143", `reportingSurvey`="ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021aaj" ,"AT2021aaj" ,"35.958075" ,"+35:57:29.07" ,"2021-01-12 07:30:43.200" ,"19.346" ,"cyan-ATLAS" ,"ATLAS, Pan-STARRS1" ,"ATLAS21bgq" ,null ,null ,"https://www.wis-tns.org/object/2021aaj" ,"39.5332083" ,"02:38:07.970" ,"ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aaj", `TNSName`="AT2021aaj", `decDeg`="35.958075", `decSex`="+35:57:29.07", `discDate`="2021-01-12 07:30:43.200", `discMag`="19.346", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, Pan-STARRS1", `discoveryName`="ATLAS21bgq", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021aaj", `raDeg`="39.5332083", `raSex`="02:38:07.970", `reportingSurvey`="ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021yk" ,"SN2021yk" ,"-15.050175" ,"-15:03:00.63" ,"2021-01-10 11:24:00.000" ,"19.118" ,"cyan-ATLAS" ,"ATLAS, Pan-STARRS1" ,"ATLAS21bdw" ,null ,null ,"https://www.wis-tns.org/object/2021yk" ,"136.902583" ,"09:07:36.620" ,"ATLAS, Pan-STARRS1" ,"SN Ia" ,"0.075345", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021yk", `TNSName`="SN2021yk", `decDeg`="-15.050175", `decSex`="-15:03:00.63", `discDate`="2021-01-10 11:24:00.000", `discMag`="19.118", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, Pan-STARRS1", `discoveryName`="ATLAS21bdw", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021yk", `raDeg`="136.902583", `raSex`="09:07:36.620", `reportingSurvey`="ATLAS, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.075345" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021xv" ,"SN2021xv" ,"36.779536" ,"+36:46:46.33" ,"2021-01-10 12:23:34.999" ,"19.9349" ,"r-ZTF" ,"ZTF, ATLAS" ,"ZTF21aadatfg" ,"SDSS J160732.83+364646.1" ,"0.061" ,"https://www.wis-tns.org/object/2021xv" ,"241.88670833333333" ,"16:07:32.810" ,"ALeRCE, ATLAS, Fink, ZTF" ,"SN Ic-BL" ,"0.05", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `TNSName`="SN2021xv", `decDeg`="36.779536", `decSex`="+36:46:46.33", `discDate`="2021-01-10 12:23:34.999", `discMag`="19.9349", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS", `discoveryName`="ZTF21aadatfg", `hostName`="SDSS J160732.83+364646.1", `hostRedshift`="0.061", `objectUrl`="https://www.wis-tns.org/object/2021xv", `raDeg`="241.88670833333333", `raSex`="16:07:32.810", `reportingSurvey`="ALeRCE, ATLAS, Fink, ZTF", `specType`="SN Ic-BL", `transRedshift`="0.05" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021xh" ,"AT2021xh" ,"30.644542" ,"+30:38:40.35" ,"2021-01-06 02:48:50.003" ,"20.7024" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aacvfed" ,"SDSS J000031.02+303838.4" ,"0.09" ,"https://www.wis-tns.org/object/2021xh" ,"0.12862917" ,"00:00:30.871" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xh", `TNSName`="AT2021xh", `decDeg`="30.644542", `decSex`="+30:38:40.35", `discDate`="2021-01-06 02:48:50.003", `discMag`="20.7024", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aacvfed", `hostName`="SDSS J000031.02+303838.4", `hostRedshift`="0.09", `objectUrl`="https://www.wis-tns.org/object/2021xh", `raDeg`="0.12862917", `raSex`="00:00:30.871", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021us" ,"AT2021us" ,"18.32665" ,"+18:19:35.94" ,"2021-01-07 10:43:51.004" ,"20.1995" ,"r-ZTF" ,"ZTF, Pan-STARRS1, ATLAS, GaiaAlerts" ,"ZTF21aacsuwx" ,"SDSS J115118.15+181933.2" ,"0.088" ,"https://www.wis-tns.org/object/2021us" ,"177.825" ,"11:51:18.000" ,"ALeRCE, YSE, ATLAS, Fink, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `TNSName`="AT2021us", `decDeg`="18.32665", `decSex`="+18:19:35.94", `discDate`="2021-01-07 10:43:51.004", `discMag`="20.1995", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS, GaiaAlerts", `discoveryName`="ZTF21aacsuwx", `hostName`="SDSS J115118.15+181933.2", `hostRedshift`="0.088", `objectUrl`="https://www.wis-tns.org/object/2021us", `raDeg`="177.825", `raSex`="11:51:18.000", `reportingSurvey`="ALeRCE, YSE, ATLAS, Fink, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021tz" ,"AT2021tz" ,"36.571869" ,"+36:34:18.73" ,"2021-01-09 02:52:35.999" ,"19.4773" ,"r-ZTF" ,"ZTF, ATLAS, GaiaAlerts" ,"ZTF21aacndur" ,"WISEA J215841.81+363415.7" ,null ,"https://www.wis-tns.org/object/2021tz" ,"329.6745" ,"21:58:41.880" ,"ALeRCE, ATLAS, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021tz", `TNSName`="AT2021tz", `decDeg`="36.571869", `decSex`="+36:34:18.73", `discDate`="2021-01-09 02:52:35.999", `discMag`="19.4773", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, GaiaAlerts", `discoveryName`="ZTF21aacndur", `hostName`="WISEA J215841.81+363415.7", `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021tz", `raDeg`="329.6745", `raSex`="21:58:41.880", `reportingSurvey`="ALeRCE, ATLAS, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021sl" ,"AT2021sl" ,"-7.554344" ,"-07:33:15.64" ,"2021-01-08 08:30:26.001" ,"19.6895" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF21aachbpq" ,"WISEA J092158.83-073322.8" ,null ,"https://www.wis-tns.org/object/2021sl" ,"140.49679166666667" ,"09:21:59.230" ,"ALeRCE, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021sl", `TNSName`="AT2021sl", `decDeg`="-7.554344", `decSex`="-07:33:15.64", `discDate`="2021-01-08 08:30:26.001", `discMag`="19.6895", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF21aachbpq", `hostName`="WISEA J092158.83-073322.8", `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021sl", `raDeg`="140.49679166666667", `raSex`="09:21:59.230", `reportingSurvey`="ALeRCE, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021rz" ,"AT2021rz" ,"22.676475" ,"+22:40:35.31" ,"2021-01-06 08:14:07.996" ,"20.1781" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aacizpp" ,"SDSS J081103.37+224034.7" ,"0.147" ,"https://www.wis-tns.org/object/2021rz" ,"122.76440833333334" ,"08:11:03.458" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021rz", `TNSName`="AT2021rz", `decDeg`="22.676475", `decSex`="+22:40:35.31", `discDate`="2021-01-06 08:14:07.996", `discMag`="20.1781", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aacizpp", `hostName`="SDSS J081103.37+224034.7", `hostRedshift`="0.147", `objectUrl`="https://www.wis-tns.org/object/2021rz", `raDeg`="122.76440833333334", `raSex`="08:11:03.458", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ry" ,"AT2021ry" ,"18.345344" ,"+18:20:43.24" ,"2021-01-06 08:14:07.996" ,"20.2656" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aablerm" ,"SDSS J081619.69+182045.0" ,"0.106" ,"https://www.wis-tns.org/object/2021ry" ,"124.0823375" ,"08:16:19.761" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ry", `TNSName`="AT2021ry", `decDeg`="18.345344", `decSex`="+18:20:43.24", `discDate`="2021-01-06 08:14:07.996", `discMag`="20.2656", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aablerm", `hostName`="SDSS J081619.69+182045.0", `hostRedshift`="0.106", `objectUrl`="https://www.wis-tns.org/object/2021ry", `raDeg`="124.0823375", `raSex`="08:16:19.761", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021qd" ,"AT2021qd" ,"15.08595" ,"+15:05:09.42" ,"2021-01-05 08:05:38.996" ,"20.3475" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF21aabvkkk" ,"SDSS J082410.16+150508.6" ,"0.245" ,"https://www.wis-tns.org/object/2021qd" ,"126.042125" ,"08:24:10.110" ,"ALeRCE, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021qd", `TNSName`="AT2021qd", `decDeg`="15.08595", `decSex`="+15:05:09.42", `discDate`="2021-01-05 08:05:38.996", `discMag`="20.3475", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF21aabvkkk", `hostName`="SDSS J082410.16+150508.6", `hostRedshift`="0.245", `objectUrl`="https://www.wis-tns.org/object/2021qd", `raDeg`="126.042125", `raSex`="08:24:10.110", `reportingSurvey`="ALeRCE, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ov" ,"AT2021ov" ,"32.226214" ,"+32:13:34.37" ,"2021-01-04 15:46:04.800" ,"19.62" ,"z-Sloan" ,"Pan-STARRS1" ,"PS21ci" ,null ,null ,"https://www.wis-tns.org/object/2021ov" ,"212.0755375" ,"14:08:18.129" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ov", `TNSName`="AT2021ov", `decDeg`="32.226214", `decSex`="+32:13:34.37", `discDate`="2021-01-04 15:46:04.800", `discMag`="19.62", `discMagFilter`="z-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ci", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021ov", `raDeg`="212.0755375", `raSex`="14:08:18.129", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ne" ,"AT2021ne" ,"8.062725" ,"+08:03:45.81" ,"2021-01-05 07:52:19.200" ,"19.224" ,"cyan-ATLAS" ,"ATLAS, ZTF, Pan-STARRS1" ,"ATLAS21amu" ,null ,null ,"https://www.wis-tns.org/object/2021ne" ,"46.5144125" ,"03:06:03.459" ,"ATLAS, ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ne", `TNSName`="AT2021ne", `decDeg`="8.062725", `decSex`="+08:03:45.81", `discDate`="2021-01-05 07:52:19.200", `discMag`="19.224", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, ZTF, Pan-STARRS1", `discoveryName`="ATLAS21amu", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021ne", `raDeg`="46.5144125", `raSex`="03:06:03.459", `reportingSurvey`="ATLAS, ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021jv" ,"AT2021jv" ,"-8.373628" ,"-08:22:25.06" ,"2021-01-03 07:49:26.400" ,"21.17" ,"i-Sloan" ,"Pan-STARRS1" ,"PS21af" ,null ,null ,"https://www.wis-tns.org/object/2021jv" ,"59.64307083333333" ,"03:58:34.337" ,"YSE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021jv", `TNSName`="AT2021jv", `decDeg`="-8.373628", `decSex`="-08:22:25.06", `discDate`="2021-01-03 07:49:26.400", `discMag`="21.17", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21af", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021jv", `raDeg`="59.64307083333333", `raSex`="03:58:34.337", `reportingSurvey`="YSE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ik" ,"AT2021ik" ,"27.023761" ,"+27:01:25.54" ,"2021-01-05 02:44:25.999" ,"19.6578" ,"g-ZTF" ,"ZTF, ATLAS, GaiaAlerts" ,"ZTF21aaazjia" ,"SDSS J224120.58+270123.1" ,"0.084" ,"https://www.wis-tns.org/object/2021ik" ,"340.336917" ,"22:41:20.860" ,"ALeRCE, ATLAS, Fink, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `TNSName`="AT2021ik", `decDeg`="27.023761", `decSex`="+27:01:25.54", `discDate`="2021-01-05 02:44:25.999", `discMag`="19.6578", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, GaiaAlerts", `discoveryName`="ZTF21aaazjia", `hostName`="SDSS J224120.58+270123.1", `hostRedshift`="0.084", `objectUrl`="https://www.wis-tns.org/object/2021ik", `raDeg`="340.336917", `raSex`="22:41:20.860", `reportingSurvey`="ALeRCE, ATLAS, Fink, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021gl" ,"SN2021gl" ,"-7.4746" ,"-07:28:28.56" ,"2021-01-02 09:43:12.000" ,"18.73" ,"r-ZTF" ,"ZTF, ATLAS, GaiaAlerts" ,"ZTF21aaagzee" ,null ,null ,"https://www.wis-tns.org/object/2021gl" ,"164.40658333333334" ,"10:57:37.580" ,"ZTF, ATLAS, Fink, GaiaAlerts" ,"SN Ia" ,"0.06", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `TNSName`="SN2021gl", `decDeg`="-7.4746", `decSex`="-07:28:28.56", `discDate`="2021-01-02 09:43:12.000", `discMag`="18.73", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, GaiaAlerts", `discoveryName`="ZTF21aaagzee", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021gl", `raDeg`="164.40658333333334", `raSex`="10:57:37.580", `reportingSurvey`="ZTF, ATLAS, Fink, GaiaAlerts", `specType`="SN Ia", `transRedshift`="0.06" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ff" ,"AT2021ff" ,"35.763303" ,"+35:45:47.89" ,"2021-01-04 06:23:29.003" ,"20.4224" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aaaszmu" ,"GALEXASC J071725.32+354547.7" ,null ,"https://www.wis-tns.org/object/2021ff" ,"109.3562167" ,"07:17:25.492" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ff", `TNSName`="AT2021ff", `decDeg`="35.763303", `decSex`="+35:45:47.89", `discDate`="2021-01-04 06:23:29.003", `discMag`="20.4224", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aaaszmu", `hostName`="GALEXASC J071725.32+354547.7", `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021ff", `raDeg`="109.3562167", `raSex`="07:17:25.492", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021eq" ,"AT2021eq" ,"39.647706" ,"+39:38:51.74" ,"2021-01-02 05:42:28.002" ,"20.4039" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF21aaaseqt" ,"WISEA J025516.42+393848.5" ,null ,"https://www.wis-tns.org/object/2021eq" ,"43.8188125" ,"02:55:16.515" ,"ALeRCE, ATLAS, Fink, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `TNSName`="AT2021eq", `decDeg`="39.647706", `decSex`="+39:38:51.74", `discDate`="2021-01-02 05:42:28.002", `discMag`="20.4039", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF21aaaseqt", `hostName`="WISEA J025516.42+393848.5", `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021eq", `raDeg`="43.8188125", `raSex`="02:55:16.515", `reportingSurvey`="ALeRCE, ATLAS, Fink, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021em" ,"AT2021em" ,"7.966069" ,"+07:57:57.85" ,"2021-01-02 05:36:18.003" ,"20.1803" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aaarnna" ,"SDSS J033118.76+075757.3" ,"0.56" ,"https://www.wis-tns.org/object/2021em" ,"52.82816666666667" ,"03:31:18.760" ,"ALeRCE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021em", `TNSName`="AT2021em", `decDeg`="7.966069", `decSex`="+07:57:57.85", `discDate`="2021-01-02 05:36:18.003", `discMag`="20.1803", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aaarnna", `hostName`="SDSS J033118.76+075757.3", `hostRedshift`="0.56", `objectUrl`="https://www.wis-tns.org/object/2021em", `raDeg`="52.82816666666667", `raSex`="03:31:18.760", `reportingSurvey`="ALeRCE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021dc" ,"AT2021dc" ,"53.87325" ,"+53:52:23.70" ,"2021-01-03 10:44:25.996" ,"18.8337" ,"g-ZTF" ,"ZTF, GaiaAlerts" ,"ZTF21aaaollj" ,"WISEA J133504.35+535224.1" ,"0.06647" ,"https://www.wis-tns.org/object/2021dc" ,"203.76733333333334" ,"13:35:04.160" ,"ALeRCE, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021dc", `TNSName`="AT2021dc", `decDeg`="53.87325", `decSex`="+53:52:23.70", `discDate`="2021-01-03 10:44:25.996", `discMag`="18.8337", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, GaiaAlerts", `discoveryName`="ZTF21aaaollj", `hostName`="WISEA J133504.35+535224.1", `hostRedshift`="0.06647", `objectUrl`="https://www.wis-tns.org/object/2021dc", `raDeg`="203.76733333333334", `raSex`="13:35:04.160", `reportingSurvey`="ALeRCE, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bv" ,"AT2021bv" ,"76.86717" ,"+76:52:01.80" ,"2021-01-01 10:15:18.003" ,"19.3326" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF21aaahhso" ,"WISEA J082213.44+765158.4" ,null ,"https://www.wis-tns.org/object/2021bv" ,"125.56536666666666" ,"08:22:15.688" ,"ALeRCE, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bv", `TNSName`="AT2021bv", `decDeg`="76.86717", `decSex`="+76:52:01.80", `discDate`="2021-01-01 10:15:18.003", `discMag`="19.3326", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF21aaahhso", `hostName`="WISEA J082213.44+765158.4", `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bv", `raDeg`="125.56536666666666", `raSex`="08:22:15.688", `reportingSurvey`="ALeRCE, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021bg" ,"AT2021bg" ,"1.830261" ,"+01:49:48.94" ,"2021-01-03 05:12:28.800" ,"21.11" ,"z-Sloan" ,"Pan-STARRS1" ,"PS21h" ,null ,null ,"https://www.wis-tns.org/object/2021bg" ,"17.364375" ,"01:09:27.450" ,"YSE, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bg", `TNSName`="AT2021bg", `decDeg`="1.830261", `decSex`="+01:49:48.94", `discDate`="2021-01-03 05:12:28.800", `discMag`="21.11", `discMagFilter`="z-Sloan", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21h", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021bg", `raDeg`="17.364375", `raSex`="01:09:27.450", `reportingSurvey`="YSE, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021ab" ,"SN2021ab" ,"-26.46939" ,"-26:28:09.80" ,"2021-01-01 11:33:32.003" ,"18.7325" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1, GaiaAlerts" ,"ZTF21aaabuoj" ,"WISEA J102348.94-262810.4" ,null ,"https://www.wis-tns.org/object/2021ab" ,"155.953583" ,"10:23:48.860" ,"ALeRCE, ATLAS, Pan-STARRS1, GaiaAlerts" ,"SN Ia" ,"0.07", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `TNSName`="SN2021ab", `decDeg`="-26.46939", `decSex`="-26:28:09.80", `discDate`="2021-01-01 11:33:32.003", `discMag`="18.7325", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1, GaiaAlerts", `discoveryName`="ZTF21aaabuoj", `hostName`="WISEA J102348.94-262810.4", `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2021ab", `raDeg`="155.953583", `raSex`="10:23:48.860", `reportingSurvey`="ALeRCE, ATLAS, Pan-STARRS1, GaiaAlerts", `specType`="SN Ia", `transRedshift`="0.07" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2021G" ,"SN2021G" ,"42.2003" ,"+42:12:01.08" ,"2021-01-01 10:28:52.997" ,"19.1914" ,"g-ZTF" ,"ZTF, ATLAS, GaiaAlerts, Pan-STARRS1" ,"ZTF21aaabtyq" ,"WISEA J114639.05+421201.3" ,"0.051295" ,"https://www.wis-tns.org/object/2021g" ,"176.664583" ,"11:46:39.500" ,"ALeRCE, ATLAS, Fink, GaiaAlerts, Pan-STARRS1" ,"SN Ia" ,"0.0512", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `TNSName`="SN2021G", `decDeg`="42.2003", `decSex`="+42:12:01.08", `discDate`="2021-01-01 10:28:52.997", `discMag`="19.1914", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, GaiaAlerts, Pan-STARRS1", `discoveryName`="ZTF21aaabtyq", `hostName`="WISEA J114639.05+421201.3", `hostRedshift`="0.051295", `objectUrl`="https://www.wis-tns.org/object/2021g", `raDeg`="176.664583", `raSex`="11:46:39.500", `reportingSurvey`="ALeRCE, ATLAS, Fink, GaiaAlerts, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.0512" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aewd" ,"AT2020aewd" ,"39.147206" ,"+39:08:49.94" ,"2020-12-12 11:42:43.200" ,"21.5" ,"w-PS1" ,"Pan-STARRS1" ,"PS21py" ,null ,null ,"https://www.wis-tns.org/object/2020aewd" ,"111.15750417" ,"07:24:37.801" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aewd", `TNSName`="AT2020aewd", `decDeg`="39.147206", `decSex`="+39:08:49.94", `discDate`="2020-12-12 11:42:43.200", `discMag`="21.5", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21py", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aewd", `raDeg`="111.15750417", `raSex`="07:24:37.801", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aewc" ,"AT2020aewc" ,"49.428181" ,"+49:25:41.45" ,"2020-12-20 20:35:31.200" ,"17.27" ,"G-Gaia" ,"GaiaAlerts" ,"Gaia21alb" ,null ,null ,"https://www.wis-tns.org/object/2020aewc" ,"312.936875" ,"20:51:44.850" ,"GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aewc", `TNSName`="AT2020aewc", `decDeg`="49.428181", `decSex`="+49:25:41.45", `discDate`="2020-12-20 20:35:31.200", `discMag`="17.27", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts", `discoveryName`="Gaia21alb", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aewc", `raDeg`="312.936875", `raSex`="20:51:44.850", `reportingSurvey`="GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aewb" ,"AT2020aewb" ,"-8.793886" ,"-08:47:37.99" ,"2020-12-17 10:13:26.400" ,"21.94" ,"w-PS1" ,"Pan-STARRS1" ,"PS21ok" ,null ,null ,"https://www.wis-tns.org/object/2020aewb" ,"81.19177917" ,"05:24:46.027" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aewb", `TNSName`="AT2020aewb", `decDeg`="-8.793886", `decSex`="-08:47:37.99", `discDate`="2020-12-17 10:13:26.400", `discMag`="21.94", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS21ok", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aewb", `raDeg`="81.19177917", `raSex`="05:24:46.027", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aeuv" ,"SN2020aeuv" ,"13.332125" ,"+13:19:55.65" ,"2020-12-21 12:11:31.200" ,"19.69" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20aczgmai" ,null ,null ,"https://www.wis-tns.org/object/2020aeuv" ,"203.9281917" ,"13:35:42.766" ,"ZTF, ATLAS, Pan-STARRS1" ,"SN IIn" ,"0.042843", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `TNSName`="SN2020aeuv", `decDeg`="13.332125", `decSex`="+13:19:55.65", `discDate`="2020-12-21 12:11:31.200", `discMag`="19.69", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20aczgmai", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aeuv", `raDeg`="203.9281917", `raSex`="13:35:42.766", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`="SN IIn", `transRedshift`="0.042843" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aeuh" ,"AT2020aeuh" ,"37.703478" ,"+37:42:12.52" ,"2020-12-25 14:42:43.200" ,"19.268" ,"cyan-ATLAS" ,"ATLAS, Pan-STARRS1" ,"ATLAS20bkbb" ,null ,null ,"https://www.wis-tns.org/object/2020aeuh" ,"188.9660625" ,"12:35:51.855" ,"ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuh", `TNSName`="AT2020aeuh", `decDeg`="37.703478", `decSex`="+37:42:12.52", `discDate`="2020-12-25 14:42:43.200", `discMag`="19.268", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, Pan-STARRS1", `discoveryName`="ATLAS20bkbb", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aeuh", `raDeg`="188.9660625", `raSex`="12:35:51.855", `reportingSurvey`="ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aetm" ,"AT2020aetm" ,"33.700464" ,"+33:42:01.67" ,"2020-12-22 07:17:29.184" ,"20.7676" ,"g-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF21aaaszmm" ,null ,null ,"https://www.wis-tns.org/object/2020aetm" ,"111.61197917" ,"07:26:26.875" ,"ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aetm", `TNSName`="AT2020aetm", `decDeg`="33.700464", `decSex`="+33:42:01.67", `discDate`="2020-12-22 07:17:29.184", `discMag`="20.7676", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF21aaaszmm", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aetm", `raDeg`="111.61197917", `raSex`="07:26:26.875", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aeqo" ,"SN2020aeqo" ,"-11.978661" ,"-11:58:43.18" ,"2020-12-29 07:35:02.400" ,"18.198" ,"orange-ATLAS" ,"ATLAS, GaiaAlerts, Pan-STARRS1" ,"ATLAS20bjua" ,null ,null ,"https://www.wis-tns.org/object/2020aeqo" ,"47.464125" ,"03:09:51.390" ,"ATLAS, GaiaAlerts, Pan-STARRS1" ,"SN II" ,"0.031", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeqo", `TNSName`="SN2020aeqo", `decDeg`="-11.978661", `decSex`="-11:58:43.18", `discDate`="2020-12-29 07:35:02.400", `discMag`="18.198", `discMagFilter`="orange-ATLAS", `discSurvey`="ATLAS, GaiaAlerts, Pan-STARRS1", `discoveryName`="ATLAS20bjua", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aeqo", `raDeg`="47.464125", `raSex`="03:09:51.390", `reportingSurvey`="ATLAS, GaiaAlerts, Pan-STARRS1", `specType`="SN II", `transRedshift`="0.031" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aenl" ,"AT2020aenl" ,"21.811808" ,"+21:48:42.51" ,"2020-12-10 10:39:21.600" ,"20.47" ,"w-PS1" ,"Pan-STARRS1" ,"PS20ntv" ,null ,null ,"https://www.wis-tns.org/object/2020aenl" ,"132.1423667" ,"08:48:34.168" ,"Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenl", `TNSName`="AT2020aenl", `decDeg`="21.811808", `decSex`="+21:48:42.51", `discDate`="2020-12-10 10:39:21.600", `discMag`="20.47", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1", `discoveryName`="PS20ntv", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aenl", `raDeg`="132.1423667", `raSex`="08:48:34.168", `reportingSurvey`="Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aenf" ,"AT2020aenf" ,"8.77828" ,"+08:46:41.80" ,"2020-12-23 11:47:02.400" ,"20.95" ,"w-PS1" ,"Pan-STARRS1, ZTF" ,"PS20nti" ,null ,null ,"https://www.wis-tns.org/object/2020aenf" ,"142.5769375" ,"09:30:18.465" ,"Pan-STARRS1, ALeRCE" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenf", `TNSName`="AT2020aenf", `decDeg`="8.77828", `decSex`="+08:46:41.80", `discDate`="2020-12-23 11:47:02.400", `discMag`="20.95", `discMagFilter`="w-PS1", `discSurvey`="Pan-STARRS1, ZTF", `discoveryName`="PS20nti", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aenf", `raDeg`="142.5769375", `raSex`="09:30:18.465", `reportingSurvey`="Pan-STARRS1, ALeRCE", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adlz" ,"AT2020adlz" ,"3.075903" ,"+03:04:33.25" ,"2020-12-10 15:11:31.200" ,"19.68" ,"i-Sloan" ,"Pan-STARRS1, ATLAS" ,"PS20mmp" ,null ,null ,"https://www.wis-tns.org/object/2020adlz" ,"149.38372916666665" ,"09:57:32.095" ,"YSE, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlz", `TNSName`="AT2020adlz", `decDeg`="3.075903", `decSex`="+03:04:33.25", `discDate`="2020-12-10 15:11:31.200", `discMag`="19.68", `discMagFilter`="i-Sloan", `discSurvey`="Pan-STARRS1, ATLAS", `discoveryName`="PS20mmp", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020adlz", `raDeg`="149.38372916666665", `raSex`="09:57:32.095", `reportingSurvey`="YSE, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adlp" ,"SN2020adlp" ,"39.707661" ,"+39:42:27.58" ,"2020-12-20 09:28:49.996" ,"20.3126" ,"g-ZTF" ,"ZTF, Pan-STARRS1, ATLAS" ,"ZTF20acyvbhj" ,"WISEA J080700.81+394220.6" ,"0.078466" ,"https://www.wis-tns.org/object/2020adlp" ,"121.75645" ,"08:07:01.548" ,"ALeRCE, ZTF, Pan-STARRS1, ATLAS, YSE" ,"SN Ia" ,"0.07848", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `TNSName`="SN2020adlp", `decDeg`="39.707661", `decSex`="+39:42:27.58", `discDate`="2020-12-20 09:28:49.996", `discMag`="20.3126", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS", `discoveryName`="ZTF20acyvbhj", `hostName`="WISEA J080700.81+394220.6", `hostRedshift`="0.078466", `objectUrl`="https://www.wis-tns.org/object/2020adlp", `raDeg`="121.75645", `raSex`="08:07:01.548", `reportingSurvey`="ALeRCE, ZTF, Pan-STARRS1, ATLAS, YSE", `specType`="SN Ia", `transRedshift`="0.07848" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020adbk" ,"SN2020adbk" ,"31.103453" ,"+31:06:12.43" ,"2020-12-16 08:35:39.002" ,"19.8786" ,"g-ZTF" ,"ZTF, Pan-STARRS1, ATLAS" ,"ZTF20acxqnhn" ,"SDSS J081925.47+310610.5" ,"0.12" ,"https://www.wis-tns.org/object/2020adbk" ,"124.8560667" ,"08:19:25.456" ,"ALeRCE, ZTF, Pan-STARRS1, ATLAS" ,"SN Ia-pec" ,"0.083", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `TNSName`="SN2020adbk", `decDeg`="31.103453", `decSex`="+31:06:12.43", `discDate`="2020-12-16 08:35:39.002", `discMag`="19.8786", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS", `discoveryName`="ZTF20acxqnhn", `hostName`="SDSS J081925.47+310610.5", `hostRedshift`="0.12", `objectUrl`="https://www.wis-tns.org/object/2020adbk", `raDeg`="124.8560667", `raSex`="08:19:25.456", `reportingSurvey`="ALeRCE, ZTF, Pan-STARRS1, ATLAS", `specType`="SN Ia-pec", `transRedshift`="0.083" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acuc" ,"AT2020acuc" ,"13.801461" ,"+13:48:05.26" ,"2020-12-15 11:59:03.002" ,"19.5295" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acxsxbc" ,"2MASX J13521306+1348055" ,"0.06297" ,"https://www.wis-tns.org/object/2020acuc" ,"208.0571583" ,"13:52:13.718" ,"ALeRCE, ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `TNSName`="AT2020acuc", `decDeg`="13.801461", `decSex`="+13:48:05.26", `discDate`="2020-12-15 11:59:03.002", `discMag`="19.5295", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acxsxbc", `hostName`="2MASX J13521306+1348055", `hostRedshift`="0.06297", `objectUrl`="https://www.wis-tns.org/object/2020acuc", `raDeg`="208.0571583", `raSex`="13:52:13.718", `reportingSurvey`="ALeRCE, ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acma" ,"SN2020acma" ,"-28.90855" ,"-28:54:30.78" ,"2020-12-12 14:12:28.800" ,"17.99" ,"cyan-ATLAS" ,"ATLAS, Pan-STARRS1, GaiaAlerts" ,"ATLAS20bhnw" ,null ,null ,"https://www.wis-tns.org/object/2020acma" ,"159.491083" ,"10:37:57.860" ,"ATLAS, Pan-STARRS1, GaiaAlerts" ,"SN Ia" ,"0.014", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acma", `TNSName`="SN2020acma", `decDeg`="-28.90855", `decSex`="-28:54:30.78", `discDate`="2020-12-12 14:12:28.800", `discMag`="17.99", `discMagFilter`="cyan-ATLAS", `discSurvey`="ATLAS, Pan-STARRS1, GaiaAlerts", `discoveryName`="ATLAS20bhnw", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020acma", `raDeg`="159.491083", `raSex`="10:37:57.860", `reportingSurvey`="ATLAS, Pan-STARRS1, GaiaAlerts", `specType`="SN Ia", `transRedshift`="0.014" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020achf" ,"AT2020achf" ,"7.532539" ,"+07:31:57.14" ,"2020-12-05 12:19:28.128" ,"19.06" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acvewsv" ,null ,null ,"https://www.wis-tns.org/object/2020achf" ,"201.2880625" ,"13:25:09.135" ,"ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020achf", `TNSName`="AT2020achf", `decDeg`="7.532539", `decSex`="+07:31:57.14", `discDate`="2020-12-05 12:19:28.128", `discMag`="19.06", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acvewsv", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020achf", `raDeg`="201.2880625", `raSex`="13:25:09.135", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acew" ,"SN2020acew" ,"-27.834292" ,"-27:50:03.45" ,"2020-12-10 12:28:14.002" ,"18.2807" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acwqjaw" ,"WISEA J100344.01-275001.8" ,null ,"https://www.wis-tns.org/object/2020acew" ,"150.9322583" ,"10:03:43.742" ,"ALeRCE, ZTF, Pan-STARRS1" ,"SN Ia" ,"0.067", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acew", `TNSName`="SN2020acew", `decDeg`="-27.834292", `decSex`="-27:50:03.45", `discDate`="2020-12-10 12:28:14.002", `discMag`="18.2807", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acwqjaw", `hostName`="WISEA J100344.01-275001.8", `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020acew", `raDeg`="150.9322583", `raSex`="10:03:43.742", `reportingSurvey`="ALeRCE, ZTF, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.067" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020acau" ,"AT2020acau" ,"8.335478" ,"+08:20:07.72" ,"2020-12-03 12:37:26.400" ,"18.75" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20actoerz" ,null ,null ,"https://www.wis-tns.org/object/2020acau" ,"205.95330417" ,"13:43:48.793" ,"ZTF, ATLAS, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acau", `TNSName`="AT2020acau", `decDeg`="8.335478", `decSex`="+08:20:07.72", `discDate`="2020-12-03 12:37:26.400", `discMag`="18.75", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20actoerz", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020acau", `raDeg`="205.95330417", `raSex`="13:43:48.793", `reportingSurvey`="ZTF, ATLAS, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abwa" ,"AT2020abwa" ,"25.51367" ,"+25:30:49.20" ,"2020-12-05 10:41:57.984" ,"19.6169" ,"g-ZTF" ,"ZTF, Pan-STARRS1, ATLAS" ,"ZTF20acveyal" ,null ,null ,"https://www.wis-tns.org/object/2020abwa" ,"116.65805" ,"07:46:37.932" ,"ZTF, Pan-STARRS1, ATLAS" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `TNSName`="AT2020abwa", `decDeg`="25.51367", `decSex`="+25:30:49.20", `discDate`="2020-12-05 10:41:57.984", `discMag`="19.6169", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, Pan-STARRS1, ATLAS", `discoveryName`="ZTF20acveyal", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020abwa", `raDeg`="116.65805", `raSex`="07:46:37.932", `reportingSurvey`="ZTF, Pan-STARRS1, ATLAS", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020abey" ,"AT2020abey" ,"-16.276289" ,"-16:16:34.64" ,"2020-11-15 04:13:26.400" ,"19.89" ,"r-ZTF" ,"ZTF, GaiaAlerts" ,"ZTF20acqpkxj" ,null ,null ,"https://www.wis-tns.org/object/2020abey" ,"352.358667" ,"23:29:26.080" ,"ZTF, GaiaAlerts" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abey", `TNSName`="AT2020abey", `decDeg`="-16.276289", `decSex`="-16:16:34.64", `discDate`="2020-11-15 04:13:26.400", `discMag`="19.89", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, GaiaAlerts", `discoveryName`="ZTF20acqpkxj", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020abey", `raDeg`="352.358667", `raSex`="23:29:26.080", `reportingSurvey`="ZTF, GaiaAlerts", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020aaqv" ,"AT2020aaqv" ,"20.102358" ,"+20:06:08.49" ,"2020-11-17 12:09:05.184" ,"20.2" ,"r-ZTF" ,"ZTF, Pan-STARRS1" ,"ZTF20acrachm" ,null ,null ,"https://www.wis-tns.org/object/2020aaqv" ,"121.61525417" ,"08:06:27.661" ,"ZTF, Pan-STARRS1" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aaqv", `TNSName`="AT2020aaqv", `decDeg`="20.102358", `decSex`="+20:06:08.49", `discDate`="2020-11-17 12:09:05.184", `discMag`="20.2", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, Pan-STARRS1", `discoveryName`="ZTF20acrachm", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020aaqv", `raDeg`="121.61525417", `raSex`="08:06:27.661", `reportingSurvey`="ZTF, Pan-STARRS1", `specType`=null, `transRedshift`=null ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020zko" ,"SN2020zko" ,"43.286728" ,"+43:17:12.22" ,"2020-11-12 11:23:35.998" ,"19.1696" ,"r-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acpxvez" ,"WISEA J115217.35+431713.4" ,"0.050826" ,"https://www.wis-tns.org/object/2020zko" ,"178.0725167" ,"11:52:17.404" ,"ALeRCE, ZTF, Fink, ATLAS, Pan-STARRS1" ,"SN Ia" ,"0.051", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `TNSName`="SN2020zko", `decDeg`="43.286728", `decSex`="+43:17:12.22", `discDate`="2020-11-12 11:23:35.998", `discMag`="19.1696", `discMagFilter`="r-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acpxvez", `hostName`="WISEA J115217.35+431713.4", `hostRedshift`="0.050826", `objectUrl`="https://www.wis-tns.org/object/2020zko", `raDeg`="178.0725167", `raSex`="11:52:17.404", `reportingSurvey`="ALeRCE, ZTF, Fink, ATLAS, Pan-STARRS1", `specType`="SN Ia", `transRedshift`="0.051" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020ytk" ,"SN2020ytk" ,"-10.096736" ,"-10:05:48.25" ,"2020-11-02 05:03:32.999" ,"19.2657" ,"g-ZTF" ,"ZTF, ATLAS, Pan-STARRS1" ,"ZTF20acorjop" ,"SDSS J005522.28-100546.6" ,"0.489" ,"https://www.wis-tns.org/object/2020ytk" ,"13.84275" ,"00:55:22.260" ,"ALeRCE, ATLAS, Pan-STARRS1, ZTF" ,"SN II" ,"0.058", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `TNSName`="SN2020ytk", `decDeg`="-10.096736", `decSex`="-10:05:48.25", `discDate`="2020-11-02 05:03:32.999", `discMag`="19.2657", `discMagFilter`="g-ZTF", `discSurvey`="ZTF, ATLAS, Pan-STARRS1", `discoveryName`="ZTF20acorjop", `hostName`="SDSS J005522.28-100546.6", `hostRedshift`="0.489", `objectUrl`="https://www.wis-tns.org/object/2020ytk", `raDeg`="13.84275", `raSex`="00:55:22.260", `reportingSurvey`="ALeRCE, ATLAS, Pan-STARRS1, ZTF", `specType`="SN II", `transRedshift`="0.058" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2020pub" ,"SN2020pub" ,"-22.705289" ,"-22:42:19.04" ,"2020-07-19 17:33:56.160" ,"15.4" ,"Clear-" ,"MASTER, GaiaAlerts, ATLAS, ZTF, Pan-STARRS1" ,"MASTER OT J103735.45-224219.8" ,null ,null ,"https://www.wis-tns.org/object/2020pub" ,"159.39816666666667" ,"10:37:35.560" ,"MASTER, GaiaAlerts, ATLAS, ZTF, Pan-STARRS1" ,"SN II" ,"0.011", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `TNSName`="SN2020pub", `decDeg`="-22.705289", `decSex`="-22:42:19.04", `discDate`="2020-07-19 17:33:56.160", `discMag`="15.4", `discMagFilter`="Clear-", `discSurvey`="MASTER, GaiaAlerts, ATLAS, ZTF, Pan-STARRS1", `discoveryName`="MASTER OT J103735.45-224219.8", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2020pub", `raDeg`="159.39816666666667", `raSex`="10:37:35.560", `reportingSurvey`="MASTER, GaiaAlerts, ATLAS, ZTF, Pan-STARRS1", `specType`="SN II", `transRedshift`="0.011" ;
INSERT IGNORE INTO `fs_tns_sources` (`TNSId`,`TNSName`,`decDeg`,`decSex`,`discDate`,`discMag`,`discMagFilter`,`discSurvey`,`discoveryName`,`hostName`,`hostRedshift`,`objectUrl`,`raDeg`,`raSex`,`reportingSurvey`,`specType`,`transRedshift`, dateCreated) VALUES ("2016dre" ,"AT2016dre" ,"-47.86297" ,"-47:51:46.70" ,"2016-02-11 12:47:31.000" ,"15.17" ,"G-Gaia" ,"GaiaAlerts, MASTER" ,"Gaia16adj" ,null ,null ,"https://www.wis-tns.org/object/2016dre" ,"13.59" ,"00:54:21.600" ,"GaiaAlerts, MASTER" ,null ,null, NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2016dre", `TNSName`="AT2016dre", `decDeg`="-47.86297", `decSex`="-47:51:46.70", `discDate`="2016-02-11 12:47:31.000", `discMag`="15.17", `discMagFilter`="G-Gaia", `discSurvey`="GaiaAlerts, MASTER", `discoveryName`="Gaia16adj", `hostName`=null, `hostRedshift`=null, `objectUrl`="https://www.wis-tns.org/object/2016dre", `raDeg`="13.59", `raSex`="00:54:21.600", `reportingSurvey`="GaiaAlerts, MASTER", `specType`=null, `transRedshift`=null ;