CREATE TABLE IF NOT EXISTS `fs_tns_photometry` (
  `primaryId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'An internal counter',
  `TNSId` varchar(20) NOT NULL,
  `dateCreated` datetime DEFAULT CURRENT_TIMESTAMP,
  `exptime` double DEFAULT NULL,
  `filter` varchar(100) DEFAULT NULL,
  `limitingMag` tinyint(4) DEFAULT NULL,
  `mag` double DEFAULT NULL,
  `magErr` double DEFAULT NULL,
  `magUnit` varchar(100) DEFAULT NULL,
  `objectName` varchar(100) DEFAULT NULL,
  `obsdate` datetime DEFAULT NULL,
  `reportAddedDate` datetime DEFAULT NULL,
  `suggestedType` varchar(100) DEFAULT NULL,
  `survey` varchar(100) DEFAULT NULL,
  `telescope` varchar(100) DEFAULT NULL,
  `updated` tinyint(4) DEFAULT '0',
  `dateLastModified` datetime DEFAULT NULL,
  `remarks` VARCHAR(800) NULL DEFAULT NULL,
  `sourceComment` VARCHAR(800) NULL DEFAULT NULL,
  PRIMARY KEY (`primaryId`),
  UNIQUE KEY `tnsid_survey_obsdate` (`TNSId`,`survey`,`obsdate`),
  UNIQUE INDEX `u_tnsid_survey_obsdate` (`TNSId` ASC, `survey` ASC, `obsdate` ASC),
  UNIQUE INDEX `u_tnsid_obsdate_objname` (`TNSId` ASC, `obsdate` ASC, `objectName` ASC)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=latin1;
            
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bdd" ,"45" ,"w-PS1" ,"0" ,"20.02" ,"0.07" ,"ABMag" ,"PS21ql" ,"2021-01-08 05:13:55" ,"2021-01-25 12:20:11" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bdd", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.02", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS21ql", `obsdate`="2021-01-08 05:13:55", `reportAddedDate`="2021-01-25 12:20:11", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bdc" ,"45" ,"w-PS1" ,"0" ,"20.8" ,"0.13" ,"ABMag" ,"PS21qk" ,"2021-01-16 09:12:58" ,"2021-01-25 12:19:28" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bdc", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.8", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS21qk", `obsdate`="2021-01-16 09:12:58", `reportAddedDate`="2021-01-25 12:19:28", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bdb" ,"45" ,"w-PS1" ,"0" ,"21.83" ,"0.15" ,"ABMag" ,"PS21qj" ,"2021-01-05 07:52:19" ,"2021-01-25 12:18:27" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bdb", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.83", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS21qj", `obsdate`="2021-01-05 07:52:19", `reportAddedDate`="2021-01-25 12:18:27", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bda" ,"45" ,"w-PS1" ,"0" ,"20.1" ,"0.07" ,"ABMag" ,"PS21qi" ,"2021-01-15 10:42:14" ,"2021-01-25 12:17:31" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bda", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.1", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS21qi", `obsdate`="2021-01-15 10:42:14", `reportAddedDate`="2021-01-25 12:17:31", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcz" ,"45" ,"w-PS1" ,"0" ,"21.5" ,"0.07" ,"ABMag" ,"PS21qh" ,"2021-01-15 14:21:07" ,"2021-01-25 12:16:55" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.5", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS21qh", `obsdate`="2021-01-15 14:21:07", `reportAddedDate`="2021-01-25 12:16:55", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcy" ,"45" ,"w-PS1" ,"0" ,"21.26" ,"0.08" ,"ABMag" ,"PS21qg" ,"2021-01-06 06:53:17" ,"2021-01-25 12:15:45" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcy", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.26", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS21qg", `obsdate`="2021-01-06 06:53:17", `reportAddedDate`="2021-01-25 12:15:45", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcx" ,"45" ,"w-PS1" ,"0" ,"21.2" ,"0.15" ,"ABMag" ,"PS21qf" ,"2021-01-16 09:12:58" ,"2021-01-25 12:14:13" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcx", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.2", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS21qf", `obsdate`="2021-01-16 09:12:58", `reportAddedDate`="2021-01-25 12:14:13", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcw" ,"45" ,"w-PS1" ,"0" ,"21.17" ,"0.1" ,"ABMag" ,"PS21qe" ,"2021-01-07 06:44:38" ,"2021-01-25 12:13:40" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcw", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.17", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21qe", `obsdate`="2021-01-07 06:44:38", `reportAddedDate`="2021-01-25 12:13:40", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcv" ,"45" ,"w-PS1" ,"0" ,"21.83" ,"0.27" ,"ABMag" ,"PS21qc" ,"2021-01-16 07:56:38" ,"2021-01-25 12:08:40" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcv", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.83", `magErr`="0.27", `magUnit`="ABMag", `objectName`="PS21qc", `obsdate`="2021-01-16 07:56:38", `reportAddedDate`="2021-01-25 12:08:40", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcu" ,"45" ,"w-PS1" ,"0" ,"21.73" ,"0.3" ,"ABMag" ,"PS21qb" ,"2021-01-14 15:31:41" ,"2021-01-25 12:07:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcu", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.73", `magErr`="0.3", `magUnit`="ABMag", `objectName`="PS21qb", `obsdate`="2021-01-14 15:31:41", `reportAddedDate`="2021-01-25 12:07:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bct" ,"45" ,"w-PS1" ,"0" ,"21.14" ,"0.1" ,"ABMag" ,"PS21qa" ,"2021-01-16 06:59:02" ,"2021-01-25 12:05:53" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bct", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.14", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21qa", `obsdate`="2021-01-16 06:59:02", `reportAddedDate`="2021-01-25 12:05:53", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcs" ,"45" ,"w-PS1" ,"0" ,"21.56" ,"0.06" ,"ABMag" ,"PS21pu" ,"2021-01-12 10:59:31" ,"2021-01-25 11:56:54" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcs", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.56", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS21pu", `obsdate`="2021-01-12 10:59:31", `reportAddedDate`="2021-01-25 11:56:54", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcr" ,"45" ,"w-PS1" ,"0" ,"21.46" ,"0.12" ,"ABMag" ,"PS21pt" ,"2021-01-12 15:25:55" ,"2021-01-25 11:56:08" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcr", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.46", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS21pt", `obsdate`="2021-01-12 15:25:55", `reportAddedDate`="2021-01-25 11:56:08", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcq" ,"45" ,"w-PS1" ,"0" ,"21.52" ,"0.14" ,"ABMag" ,"PS21ps" ,"2021-01-12 09:40:19" ,"2021-01-25 11:55:34" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcq", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.52", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS21ps", `obsdate`="2021-01-12 09:40:19", `reportAddedDate`="2021-01-25 11:55:34", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcp" ,"45" ,"w-PS1" ,"0" ,"21.8" ,"0.15" ,"ABMag" ,"PS21pr" ,"2021-01-17 07:55:12" ,"2021-01-25 11:51:38" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcp", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.8", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS21pr", `obsdate`="2021-01-17 07:55:12", `reportAddedDate`="2021-01-25 11:51:38", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bco" ,"45" ,"w-PS1" ,"0" ,"20.53" ,"0.05" ,"ABMag" ,"PS21pq" ,"2021-01-05 06:38:53" ,"2021-01-25 11:47:14" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bco", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.53", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21pq", `obsdate`="2021-01-05 06:38:53", `reportAddedDate`="2021-01-25 11:47:14", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcn" ,"45" ,"w-PS1" ,"0" ,"21.76" ,"0.1" ,"ABMag" ,"PS21pp" ,"2021-01-17 15:07:12" ,"2021-01-25 10:59:36" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcn", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.76", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21pp", `obsdate`="2021-01-17 15:07:12", `reportAddedDate`="2021-01-25 10:59:36", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcm" ,"45" ,"w-PS1" ,"0" ,"21.18" ,"0.15" ,"ABMag" ,"PS21po" ,"2021-01-14 15:25:55" ,"2021-01-25 10:57:47" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.18", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS21po", `obsdate`="2021-01-14 15:25:55", `reportAddedDate`="2021-01-25 10:57:47", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcl" ,"45" ,"w-PS1" ,"0" ,"20.97" ,"0.15" ,"ABMag" ,"PS21pn" ,"2021-01-21 11:34:05" ,"2021-01-25 10:56:51" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.97", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS21pn", `obsdate`="2021-01-21 11:34:05", `reportAddedDate`="2021-01-25 10:56:51", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bck" ,"45" ,"w-PS1" ,"0" ,"21.53" ,"0.08" ,"ABMag" ,"PS21pm" ,"2021-01-15 14:21:07" ,"2021-01-25 10:55:48" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bck", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.53", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS21pm", `obsdate`="2021-01-15 14:21:07", `reportAddedDate`="2021-01-25 10:55:48", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcj" ,"45" ,"w-PS1" ,"0" ,"20.98" ,"0.14" ,"ABMag" ,"PS21pl" ,"2021-01-11 06:47:31" ,"2021-01-25 10:55:04" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcj", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.98", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS21pl", `obsdate`="2021-01-11 06:47:31", `reportAddedDate`="2021-01-25 10:55:04", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bci" ,"45" ,"w-PS1" ,"0" ,"21.11" ,"0.17" ,"ABMag" ,"PS21pk" ,"2021-01-15 11:52:48" ,"2021-01-25 10:54:21" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bci", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.11", `magErr`="0.17", `magUnit`="ABMag", `objectName`="PS21pk", `obsdate`="2021-01-15 11:52:48", `reportAddedDate`="2021-01-25 10:54:21", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bch" ,"45" ,"w-PS1" ,"0" ,"21.05" ,"0.12" ,"ABMag" ,"PS21pj" ,"2021-01-12 06:00:00" ,"2021-01-25 10:53:39" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bch", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.05", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS21pj", `obsdate`="2021-01-12 06:00:00", `reportAddedDate`="2021-01-25 10:53:39", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcg" ,"45" ,"w-PS1" ,"0" ,"21.03" ,"0.1" ,"ABMag" ,"PS21pi" ,"2021-01-16 09:47:31" ,"2021-01-25 10:52:53" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcg", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.03", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21pi", `obsdate`="2021-01-16 09:47:31", `reportAddedDate`="2021-01-25 10:52:53", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcf" ,"45" ,"w-PS1" ,"0" ,"21.58" ,"0.13" ,"ABMag" ,"PS21ph" ,"2021-01-16 06:46:05" ,"2021-01-25 10:52:13" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcf", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.58", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS21ph", `obsdate`="2021-01-16 06:46:05", `reportAddedDate`="2021-01-25 10:52:13", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bce" ,"45" ,"w-PS1" ,"0" ,"20.9" ,"0.23" ,"ABMag" ,"PS21pg" ,"2021-01-09 10:33:36" ,"2021-01-25 10:50:34" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bce", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.9", `magErr`="0.23", `magUnit`="ABMag", `objectName`="PS21pg", `obsdate`="2021-01-09 10:33:36", `reportAddedDate`="2021-01-25 10:50:34", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcd" ,"45" ,"w-PS1" ,"0" ,"20.01" ,"0.19" ,"ABMag" ,"PS21pd" ,"2021-01-24 15:30:14" ,"2021-01-25 10:39:43" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcd", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.01", `magErr`="0.19", `magUnit`="ABMag", `objectName`="PS21pd", `obsdate`="2021-01-24 15:30:14", `reportAddedDate`="2021-01-25 10:39:43", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcc" ,"45" ,"w-PS1" ,"0" ,"21.31" ,"0.25" ,"ABMag" ,"PS21oy" ,"2021-01-11 12:43:12" ,"2021-01-25 10:35:50" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcc", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.31", `magErr`="0.25", `magUnit`="ABMag", `objectName`="PS21oy", `obsdate`="2021-01-11 12:43:12", `reportAddedDate`="2021-01-25 10:35:50", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bcb" ,"45" ,"w-PS1" ,"0" ,"21.7" ,"0.29" ,"ABMag" ,"PS21ox" ,"2021-01-11 07:00:29" ,"2021-01-25 10:33:59" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bcb", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.7", `magErr`="0.29", `magUnit`="ABMag", `objectName`="PS21ox", `obsdate`="2021-01-11 07:00:29", `reportAddedDate`="2021-01-25 10:33:59", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bca" ,"45" ,"w-PS1" ,"0" ,"20.62" ,"0.12" ,"ABMag" ,"PS21ov" ,"2021-01-21 11:28:19" ,"2021-01-25 10:29:46" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bca", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.62", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS21ov", `obsdate`="2021-01-21 11:28:19", `reportAddedDate`="2021-01-25 10:29:46", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbz" ,"60" ,"G-Gaia" ,"0" ,"17.86" ,"0.2" ,"ABMag" ,"Gaia21alc" ,"2021-01-23 05:45:36" ,"2021-01-25 09:12:39" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbz", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.86", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21alc", `obsdate`="2021-01-23 05:45:36", `reportAddedDate`="2021-01-25 09:12:39", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbz" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21alc" ,"2021-01-12 05:36:58" ,"2021-01-25 09:12:39" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbz", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21alc", `obsdate`="2021-01-12 05:36:58", `reportAddedDate`="2021-01-25 09:12:39", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bby" ,"60" ,"G-Gaia" ,"0" ,"19.68" ,"0.2" ,"ABMag" ,"Gaia21ala" ,"2021-01-23 21:34:34" ,"2021-01-25 06:35:17" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bby", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="19.68", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ala", `obsdate`="2021-01-23 21:34:34", `reportAddedDate`="2021-01-25 06:35:17", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bby" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ala" ,"2020-11-13 03:01:26" ,"2021-01-25 06:35:17" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bby", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ala", `obsdate`="2020-11-13 03:01:26", `reportAddedDate`="2021-01-25 06:35:17", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbx" ,"60" ,"G-Gaia" ,"0" ,"17.32" ,"0.2" ,"ABMag" ,"Gaia21akz" ,"2021-01-24 00:56:10" ,"2021-01-25 06:34:55" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbx", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.32", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akz", `obsdate`="2021-01-24 00:56:10", `reportAddedDate`="2021-01-25 06:34:55", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbx" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akz" ,"2020-06-30 16:50:53" ,"2021-01-25 06:34:55" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbx", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akz", `obsdate`="2020-06-30 16:50:53", `reportAddedDate`="2021-01-25 06:34:55", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbw" ,"60" ,"G-Gaia" ,"0" ,"17.75" ,"0.2" ,"ABMag" ,"Gaia21aky" ,"2021-01-23 17:15:22" ,"2021-01-25 06:34:27" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbw", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.75", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21aky", `obsdate`="2021-01-23 17:15:22", `reportAddedDate`="2021-01-25 06:34:27", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbw" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21aky" ,"2019-02-18 11:16:48" ,"2021-01-25 06:34:27" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbw", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21aky", `obsdate`="2019-02-18 11:16:48", `reportAddedDate`="2021-01-25 06:34:27", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbv" ,"60" ,"G-Gaia" ,"0" ,"18.7" ,"0.2" ,"ABMag" ,"Gaia21akw" ,"2021-01-23 23:57:07" ,"2021-01-25 06:33:51" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbv", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.7", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akw", `obsdate`="2021-01-23 23:57:07", `reportAddedDate`="2021-01-25 06:33:51", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbv" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akw" ,"2021-01-14 23:49:55" ,"2021-01-25 06:33:51" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbv", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akw", `obsdate`="2021-01-14 23:49:55", `reportAddedDate`="2021-01-25 06:33:51", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbu" ,"60" ,"G-Gaia" ,"0" ,"18.98" ,"0.2" ,"ABMag" ,"Gaia21akv" ,"2021-01-23 05:38:24" ,"2021-01-25 06:33:31" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbu", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.98", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akv", `obsdate`="2021-01-23 05:38:24", `reportAddedDate`="2021-01-25 06:33:31", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbu" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akv" ,"2020-12-26 13:40:47" ,"2021-01-25 06:33:31" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbu", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akv", `obsdate`="2020-12-26 13:40:47", `reportAddedDate`="2021-01-25 06:33:31", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbt" ,"60" ,"G-Gaia" ,"0" ,"18.66" ,"0.2" ,"ABMag" ,"Gaia21akt" ,"2021-01-23 13:59:31" ,"2021-01-25 06:32:52" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbt", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.66", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akt", `obsdate`="2021-01-23 13:59:31", `reportAddedDate`="2021-01-25 06:32:52", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbt" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akt" ,"2020-11-15 10:55:12" ,"2021-01-25 06:32:52" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbt", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akt", `obsdate`="2020-11-15 10:55:12", `reportAddedDate`="2021-01-25 06:32:52", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbs" ,"60" ,"G-Gaia" ,"0" ,"18.53" ,"0.2" ,"ABMag" ,"Gaia21aks" ,"2021-01-23 17:49:55" ,"2021-01-25 06:32:18" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbs", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.53", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21aks", `obsdate`="2021-01-23 17:49:55", `reportAddedDate`="2021-01-25 06:32:18", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbs" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21aks" ,"2018-07-11 09:46:05" ,"2021-01-25 06:32:18" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbs", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21aks", `obsdate`="2018-07-11 09:46:05", `reportAddedDate`="2021-01-25 06:32:18", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbr" ,"27" ,"g-Sloan" ,"0" ,"21.25" ,"0.18" ,"ABMag" ,"PS21ot" ,"2021-01-15 15:27:22" ,"2021-01-24 19:46:45" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbr", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="21.25", `magErr`="0.18", `magUnit`="ABMag", `objectName`="PS21ot", `obsdate`="2021-01-15 15:27:22", `reportAddedDate`="2021-01-24 19:46:45", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbq" ,"27" ,"r-Sloan" ,"0" ,"21" ,"0.24" ,"ABMag" ,"PS21os" ,"2021-01-16 13:06:14" ,"2021-01-24 19:44:08" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbq", `exptime`="27", `filter`="r-Sloan", `limitingMag`="0", `mag`="21", `magErr`="0.24", `magUnit`="ABMag", `objectName`="PS21os", `obsdate`="2021-01-16 13:06:14", `reportAddedDate`="2021-01-24 19:44:08", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbp" ,"27" ,"i-Sloan" ,"0" ,"20.59" ,"0.11" ,"ABMag" ,"PS21or" ,"2021-01-13 05:19:41" ,"2021-01-24 19:39:26" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbp", `exptime`="27", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.59", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS21or", `obsdate`="2021-01-13 05:19:41", `reportAddedDate`="2021-01-24 19:39:26", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbo" ,"60" ,"Clear-" ,"0" ,"12.8" ,null ,"VegaMag" ,"MASTER OT J160455.05-722320.6" ,"2021-01-20 23:05:20" ,"2021-01-24 17:03:23" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbo", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="12.8", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J160455.05-722320.6", `obsdate`="2021-01-20 23:05:20", `reportAddedDate`="2021-01-24 17:03:23", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbo" ,"60" ,"Clear-" ,"0" ,"12.9" ,null ,"VegaMag" ,"MASTER OT J160455.05-722320.6" ,"2021-01-20 22:10:41" ,"2021-01-24 17:03:23" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbo", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="12.9", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J160455.05-722320.6", `obsdate`="2021-01-20 22:10:41", `reportAddedDate`="2021-01-24 17:03:23", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbo" ,"180" ,"Clear-" ,"1" ,"20" ,null ,"VegaMag" ,"MASTER OT J160455.05-722320.6" ,"2020-05-16 23:29:20" ,"2021-01-24 17:03:23" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbo", `exptime`="180", `filter`="Clear-", `limitingMag`="1", `mag`="20", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J160455.05-722320.6", `obsdate`="2020-05-16 23:29:20", `reportAddedDate`="2021-01-24 17:03:23", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbn" ,"180" ,"Clear-" ,"0" ,"16.9" ,null ,"VegaMag" ,"MASTER OT J104946.32+142938.5" ,"2021-01-24 00:37:08" ,"2021-01-24 16:32:04" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbn", `exptime`="180", `filter`="Clear-", `limitingMag`="0", `mag`="16.9", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J104946.32+142938.5", `obsdate`="2021-01-24 00:37:08", `reportAddedDate`="2021-01-24 16:32:04", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbn" ,"180" ,"Clear-" ,"0" ,"16.9" ,null ,"VegaMag" ,"MASTER OT J104946.32+142938.5" ,"2021-01-24 00:32:30" ,"2021-01-24 16:32:04" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbn", `exptime`="180", `filter`="Clear-", `limitingMag`="0", `mag`="16.9", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J104946.32+142938.5", `obsdate`="2021-01-24 00:32:30", `reportAddedDate`="2021-01-24 16:32:04", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbn" ,"180" ,"Clear-" ,"1" ,"19.9" ,null ,"VegaMag" ,"MASTER OT J104946.32+142938.5" ,"2020-03-01 19:30:36" ,"2021-01-24 16:32:04" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbn", `exptime`="180", `filter`="Clear-", `limitingMag`="1", `mag`="19.9", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J104946.32+142938.5", `obsdate`="2020-03-01 19:30:36", `reportAddedDate`="2021-01-24 16:32:04", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbm" ,"30" ,"orange-ATLAS" ,"0" ,"17.412" ,"0.099" ,"ABMag" ,"ATLAS21dao" ,"2021-01-24 10:20:38" ,"2021-01-24 14:30:03" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbm", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="17.412", `magErr`="0.099", `magUnit`="ABMag", `objectName`="ATLAS21dao", `obsdate`="2021-01-24 10:20:38", `reportAddedDate`="2021-01-24 14:30:03", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbm" ,"30" ,"cyan-ATLAS" ,"1" ,"19.78" ,null ,"ABMag" ,"ATLAS21dao" ,"2021-01-16 11:57:07" ,"2021-01-24 14:30:03" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbm", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.78", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21dao", `obsdate`="2021-01-16 11:57:07", `reportAddedDate`="2021-01-24 14:30:03", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbl" ,"60" ,"G-Gaia" ,"0" ,"18.4" ,"0.2" ,"ABMag" ,"Gaia21akr" ,"2021-01-22 17:21:07" ,"2021-01-24 13:54:42" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbl", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.4", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akr", `obsdate`="2021-01-22 17:21:07", `reportAddedDate`="2021-01-24 13:54:42", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbl" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akr" ,"2020-07-04 21:07:12" ,"2021-01-24 13:54:42" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbl", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akr", `obsdate`="2020-07-04 21:07:12", `reportAddedDate`="2021-01-24 13:54:42", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbk" ,"60" ,"G-Gaia" ,"0" ,"13.58" ,"0.2" ,"ABMag" ,"Gaia21akq" ,"2021-01-22 19:40:48" ,"2021-01-24 10:46:29" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbk", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="13.58", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akq", `obsdate`="2021-01-22 19:40:48", `reportAddedDate`="2021-01-24 10:46:29", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbk" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akq" ,"2020-11-11 15:00:00" ,"2021-01-24 10:46:29" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbk", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akq", `obsdate`="2020-11-11 15:00:00", `reportAddedDate`="2021-01-24 10:46:29", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbj" ,"60" ,"G-Gaia" ,"0" ,"17.41" ,"0.2" ,"ABMag" ,"Gaia21akp" ,"2021-01-22 21:57:36" ,"2021-01-24 10:45:15" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbj", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.41", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akp", `obsdate`="2021-01-22 21:57:36", `reportAddedDate`="2021-01-24 10:45:15", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbj" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akp" ,"2019-08-24 09:47:31" ,"2021-01-24 10:45:15" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbj", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akp", `obsdate`="2019-08-24 09:47:31", `reportAddedDate`="2021-01-24 10:45:15", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbi" ,"60" ,"G-Gaia" ,"0" ,"16.43" ,"0.2" ,"ABMag" ,"Gaia21ako" ,"2021-01-23 02:15:22" ,"2021-01-24 10:44:15" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbi", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="16.43", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ako", `obsdate`="2021-01-23 02:15:22", `reportAddedDate`="2021-01-24 10:44:15", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbi" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ako" ,"2020-12-22 08:38:24" ,"2021-01-24 10:44:15" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbi", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ako", `obsdate`="2020-12-22 08:38:24", `reportAddedDate`="2021-01-24 10:44:15", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbh" ,"60" ,"G-Gaia" ,"0" ,"18.82" ,"0.2" ,"ABMag" ,"Gaia21akm" ,"2021-01-22 17:54:14" ,"2021-01-24 10:41:06" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbh", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.82", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akm", `obsdate`="2021-01-22 17:54:14", `reportAddedDate`="2021-01-24 10:41:06", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbh" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akm" ,"2020-12-30 18:02:53" ,"2021-01-24 10:41:06" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbh", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akm", `obsdate`="2020-12-30 18:02:53", `reportAddedDate`="2021-01-24 10:41:06", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbg" ,"60" ,"G-Gaia" ,"0" ,"17.17" ,"0.2" ,"ABMag" ,"Gaia21akl" ,"2021-01-22 23:41:17" ,"2021-01-24 10:39:47" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbg", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.17", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akl", `obsdate`="2021-01-22 23:41:17", `reportAddedDate`="2021-01-24 10:39:47", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbg" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akl" ,"2020-06-04 01:20:38" ,"2021-01-24 10:39:47" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbg", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akl", `obsdate`="2020-06-04 01:20:38", `reportAddedDate`="2021-01-24 10:39:47", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"60" ,"Clear-" ,"0" ,"16.3" ,null ,"VegaMag" ,"MASTER OT J173617.82-650146.3" ,"2021-01-23 07:57:25" ,"2021-01-24 09:07:02" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="16.3", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.82-650146.3", `obsdate`="2021-01-23 07:57:25", `reportAddedDate`="2021-01-24 09:07:02", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"60" ,"Clear-" ,"0" ,"16.3" ,null ,"VegaMag" ,"MASTER OT J173617.82-650146.3" ,"2021-01-23 07:50:48" ,"2021-01-24 09:07:02" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="16.3", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.82-650146.3", `obsdate`="2021-01-23 07:50:48", `reportAddedDate`="2021-01-24 09:07:02", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"540" ,"Clear-" ,"1" ,"19.8" ,null ,"VegaMag" ,"MASTER OT J173617.82-650146.3" ,"2017-01-27 07:21:29" ,"2021-01-24 09:07:02" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="540", `filter`="Clear-", `limitingMag`="1", `mag`="19.8", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.82-650146.3", `obsdate`="2017-01-27 07:21:29", `reportAddedDate`="2021-01-24 09:07:02", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"60" ,"Clear-" ,"0" ,"16.4" ,null ,"VegaMag" ,"MASTER OT J173617.85-650146.5" ,"2021-01-23 08:08:03" ,"2021-01-24 09:06:43" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="16.4", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.85-650146.5", `obsdate`="2021-01-23 08:08:03", `reportAddedDate`="2021-01-24 09:06:43", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"60" ,"Clear-" ,"0" ,"16.3" ,null ,"VegaMag" ,"MASTER OT J173617.85-650146.5" ,"2021-01-23 07:57:25" ,"2021-01-24 09:06:43" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="16.3", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.85-650146.5", `obsdate`="2021-01-23 07:57:25", `reportAddedDate`="2021-01-24 09:06:43", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"540" ,"Clear-" ,"1" ,"19.8" ,null ,"VegaMag" ,"MASTER OT J173617.85-650146.5" ,"2017-01-27 07:21:29" ,"2021-01-24 09:06:43" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="540", `filter`="Clear-", `limitingMag`="1", `mag`="19.8", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.85-650146.5", `obsdate`="2017-01-27 07:21:29", `reportAddedDate`="2021-01-24 09:06:43", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"60" ,"Clear-" ,"0" ,"16.6" ,null ,"VegaMag" ,"MASTER OT J173617.84-650146.7" ,"2021-01-23 08:09:22" ,"2021-01-24 09:06:14" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="16.6", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.84-650146.7", `obsdate`="2021-01-23 08:09:22", `reportAddedDate`="2021-01-24 09:06:14", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"60" ,"Clear-" ,"0" ,"16.5" ,null ,"VegaMag" ,"MASTER OT J173617.84-650146.7" ,"2021-01-23 07:58:45" ,"2021-01-24 09:06:14" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="16.5", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.84-650146.7", `obsdate`="2021-01-23 07:58:45", `reportAddedDate`="2021-01-24 09:06:14", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbf" ,"540" ,"Clear-" ,"1" ,"19.8" ,null ,"VegaMag" ,"MASTER OT J173617.84-650146.7" ,"2017-01-27 07:21:29" ,"2021-01-24 09:06:14" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbf", `exptime`="540", `filter`="Clear-", `limitingMag`="1", `mag`="19.8", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J173617.84-650146.7", `obsdate`="2017-01-27 07:21:29", `reportAddedDate`="2021-01-24 09:06:14", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbe" ,"600" ,"Clear-" ,"0" ,"20" ,"0.355" ,"ABMag" ,"GSNST-21ak" ,"2021-01-23 02:38:56" ,"2021-01-24 03:53:24" ,"GSNST" ,"PSN" ,"GSNST" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbe", `exptime`="600", `filter`="Clear-", `limitingMag`="0", `mag`="20", `magErr`="0.355", `magUnit`="ABMag", `objectName`="GSNST-21ak", `obsdate`="2021-01-23 02:38:56", `reportAddedDate`="2021-01-24 03:53:24", `reportingGroup`="GSNST", `suggestedType`="PSN", `survey`="GSNST", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbe" ,"300" ,"Clear-" ,"1" ,"21" ,null ,"ABMag" ,"GSNST-21ak" ,"2020-12-30 04:22:03" ,"2021-01-24 03:53:24" ,"GSNST" ,"PSN" ,"GSNST" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbe", `exptime`="300", `filter`="Clear-", `limitingMag`="1", `mag`="21", `magErr`=null, `magUnit`="ABMag", `objectName`="GSNST-21ak", `obsdate`="2020-12-30 04:22:03", `reportAddedDate`="2021-01-24 03:53:24", `reportingGroup`="GSNST", `suggestedType`="PSN", `survey`="GSNST", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbd" ,"27" ,"g-Sloan" ,"0" ,"20.73" ,"0.3" ,"ABMag" ,"PS21oq" ,"2021-01-17 14:36:58" ,"2021-01-23 20:43:19" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbd", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="20.73", `magErr`="0.3", `magUnit`="ABMag", `objectName`="PS21oq", `obsdate`="2021-01-17 14:36:58", `reportAddedDate`="2021-01-23 20:43:19", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbc" ,"27" ,"g-Sloan" ,"0" ,"20.94" ,"0.14" ,"ABMag" ,"PS21op" ,"2021-01-15 14:05:17" ,"2021-01-23 20:38:08" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbc", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="20.94", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS21op", `obsdate`="2021-01-15 14:05:17", `reportAddedDate`="2021-01-23 20:38:08", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bbb" ,"27" ,"g-Sloan" ,"0" ,"20.56" ,"0.17" ,"ABMag" ,"PS21oo" ,"2021-01-15 14:05:17" ,"2021-01-23 20:36:28" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bbb", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="20.56", `magErr`="0.17", `magUnit`="ABMag", `objectName`="PS21oo", `obsdate`="2021-01-15 14:05:17", `reportAddedDate`="2021-01-23 20:36:28", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bba" ,"45" ,"w-PS1" ,"0" ,"21.53" ,"0.19" ,"ABMag" ,"PS21on" ,"2020-12-23 14:47:02" ,"2021-01-23 17:24:19" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bba", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.53", `magErr`="0.19", `magUnit`="ABMag", `objectName`="PS21on", `obsdate`="2020-12-23 14:47:02", `reportAddedDate`="2021-01-23 17:24:19", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bba" ,"45" ,"w-PS1" ,"0" ,"21.29" ,"0.21" ,"ABMag" ,"PS21on" ,"2021-01-15 11:52:48" ,"2021-01-23 17:24:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bba", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.29", `magErr`="0.21", `magUnit`="ABMag", `objectName`="PS21on", `obsdate`="2021-01-15 11:52:48", `reportAddedDate`="2021-01-23 17:24:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021baz" ,"45" ,"w-PS1" ,"0" ,"21.91" ,"0.3" ,"ABMag" ,"PS21om" ,"2021-01-12 08:26:53" ,"2021-01-23 17:19:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.91", `magErr`="0.3", `magUnit`="ABMag", `objectName`="PS21om", `obsdate`="2021-01-12 08:26:53", `reportAddedDate`="2021-01-23 17:19:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bay" ,"45" ,"w-PS1" ,"0" ,"21.82" ,"0.3" ,"ABMag" ,"PS21ol" ,"2021-01-14 15:36:00" ,"2021-01-23 17:16:02" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bay", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.82", `magErr`="0.3", `magUnit`="ABMag", `objectName`="PS21ol", `obsdate`="2021-01-14 15:36:00", `reportAddedDate`="2021-01-23 17:16:02", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bax" ,"45" ,"w-PS1" ,"0" ,"21.8" ,"0.08" ,"ABMag" ,"PS21oj" ,"2021-01-15 14:21:07" ,"2021-01-23 17:10:36" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bax", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.8", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS21oj", `obsdate`="2021-01-15 14:21:07", `reportAddedDate`="2021-01-23 17:10:36", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021baw" ,"45" ,"w-PS1" ,"0" ,"21.85" ,"0.22" ,"ABMag" ,"PS21oi" ,"2021-01-15 11:41:17" ,"2021-01-23 17:09:12" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baw", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.85", `magErr`="0.22", `magUnit`="ABMag", `objectName`="PS21oi", `obsdate`="2021-01-15 11:41:17", `reportAddedDate`="2021-01-23 17:09:12", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bav" ,"45" ,"w-PS1" ,"0" ,"20.64" ,"0.1" ,"ABMag" ,"PS21oh" ,"2021-01-16 05:44:10" ,"2021-01-23 17:07:31" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bav", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.64", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21oh", `obsdate`="2021-01-16 05:44:10", `reportAddedDate`="2021-01-23 17:07:31", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bau" ,"45" ,"w-PS1" ,"0" ,"21.47" ,"0.15" ,"ABMag" ,"PS21of" ,"2021-01-12 09:15:50" ,"2021-01-23 17:03:14" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bau", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.47", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS21of", `obsdate`="2021-01-12 09:15:50", `reportAddedDate`="2021-01-23 17:03:14", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bat" ,"45" ,"w-PS1" ,"0" ,"21.82" ,"0.16" ,"ABMag" ,"PS21oe" ,"2021-01-16 06:57:36" ,"2021-01-23 17:01:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bat", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.82", `magErr`="0.16", `magUnit`="ABMag", `objectName`="PS21oe", `obsdate`="2021-01-16 06:57:36", `reportAddedDate`="2021-01-23 17:01:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bas" ,"45" ,"i-Sloan" ,"0" ,"21.83" ,"0.29" ,"ABMag" ,"PS21od" ,"2021-01-07 15:33:07" ,"2021-01-23 16:58:14" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bas", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="21.83", `magErr`="0.29", `magUnit`="ABMag", `objectName`="PS21od", `obsdate`="2021-01-07 15:33:07", `reportAddedDate`="2021-01-23 16:58:14", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bar" ,"45" ,"w-PS1" ,"0" ,"21.19" ,"0.14" ,"ABMag" ,"PS21oc" ,"2021-01-16 09:14:24" ,"2021-01-23 16:57:28" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bar", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.19", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS21oc", `obsdate`="2021-01-16 09:14:24", `reportAddedDate`="2021-01-23 16:57:28", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021baq" ,"45" ,"w-PS1" ,"0" ,"21.41" ,"0.21" ,"ABMag" ,"PS21ob" ,"2021-01-17 14:58:34" ,"2021-01-23 16:56:43" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baq", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.41", `magErr`="0.21", `magUnit`="ABMag", `objectName`="PS21ob", `obsdate`="2021-01-17 14:58:34", `reportAddedDate`="2021-01-23 16:56:43", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bap" ,"45" ,"w-PS1" ,"0" ,"21.39" ,"0.12" ,"ABMag" ,"PS21nz" ,"2021-01-17 15:01:26" ,"2021-01-23 16:54:45" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bap", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.39", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS21nz", `obsdate`="2021-01-17 15:01:26", `reportAddedDate`="2021-01-23 16:54:45", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bao" ,"45" ,"w-PS1" ,"0" ,"21.05" ,"0.22" ,"ABMag" ,"PS21ny" ,"2021-01-14 15:21:36" ,"2021-01-23 16:46:02" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bao", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.05", `magErr`="0.22", `magUnit`="ABMag", `objectName`="PS21ny", `obsdate`="2021-01-14 15:21:36", `reportAddedDate`="2021-01-23 16:46:02", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ban" ,"45" ,"w-PS1" ,"0" ,"20.69" ,"0.07" ,"ABMag" ,"PS21nx" ,"2021-01-16 06:46:05" ,"2021-01-23 16:44:53" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ban", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.69", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS21nx", `obsdate`="2021-01-16 06:46:05", `reportAddedDate`="2021-01-23 16:44:53", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bam" ,"45" ,"w-PS1" ,"0" ,"21.76" ,"0.23" ,"ABMag" ,"PS21nv" ,"2021-01-12 08:22:34" ,"2021-01-23 16:42:40" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bam", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.76", `magErr`="0.23", `magUnit`="ABMag", `objectName`="PS21nv", `obsdate`="2021-01-12 08:22:34", `reportAddedDate`="2021-01-23 16:42:40", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bal" ,"45" ,"w-PS1" ,"0" ,"20.99" ,"0.08" ,"ABMag" ,"PS21nu" ,"2021-01-16 06:54:43" ,"2021-01-23 16:41:18" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bal", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.99", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS21nu", `obsdate`="2021-01-16 06:54:43", `reportAddedDate`="2021-01-23 16:41:18", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bak" ,"45" ,"w-PS1" ,"0" ,"21.05" ,"0.08" ,"ABMag" ,"PS21ns" ,"2021-01-12 09:28:48" ,"2021-01-23 16:39:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bak", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.05", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS21ns", `obsdate`="2021-01-12 09:28:48", `reportAddedDate`="2021-01-23 16:39:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021baj" ,"45" ,"w-PS1" ,"0" ,"21.39" ,"0.14" ,"ABMag" ,"PS21nq" ,"2021-01-16 10:32:10" ,"2021-01-23 16:36:38" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baj", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.39", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS21nq", `obsdate`="2021-01-16 10:32:10", `reportAddedDate`="2021-01-23 16:36:38", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bai" ,"45" ,"w-PS1" ,"0" ,"20.78" ,"0.05" ,"ABMag" ,"PS21np" ,"2021-01-17 15:07:12" ,"2021-01-23 16:36:07" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bai", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.78", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21np", `obsdate`="2021-01-17 15:07:12", `reportAddedDate`="2021-01-23 16:36:07", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bah" ,"60" ,"G-Gaia" ,"0" ,"18.34" ,"0.2" ,"ABMag" ,"Gaia21akk" ,"2021-01-21 23:16:48" ,"2021-01-23 13:05:33" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bah", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.34", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akk", `obsdate`="2021-01-21 23:16:48", `reportAddedDate`="2021-01-23 13:05:33", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bah" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akk" ,"2020-12-22 17:35:31" ,"2021-01-23 13:05:33" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bah", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akk", `obsdate`="2020-12-22 17:35:31", `reportAddedDate`="2021-01-23 13:05:33", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bag" ,"60" ,"G-Gaia" ,"0" ,"12.06" ,"0.2" ,"ABMag" ,"Gaia21akj" ,"2021-01-21 15:41:46" ,"2021-01-23 13:05:17" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bag", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="12.06", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akj", `obsdate`="2021-01-21 15:41:46", `reportAddedDate`="2021-01-23 13:05:17", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bag" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akj" ,"2020-10-27 15:11:31" ,"2021-01-23 13:05:17" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bag", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akj", `obsdate`="2020-10-27 15:11:31", `reportAddedDate`="2021-01-23 13:05:17", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021baf" ,"60" ,"G-Gaia" ,"0" ,"12.2" ,"0.2" ,"ABMag" ,"Gaia21aki" ,"2021-01-22 03:37:26" ,"2021-01-23 13:04:55" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baf", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="12.2", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21aki", `obsdate`="2021-01-22 03:37:26", `reportAddedDate`="2021-01-23 13:04:55", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021baf" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21aki" ,"2021-01-07 23:16:48" ,"2021-01-23 13:04:55" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baf", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21aki", `obsdate`="2021-01-07 23:16:48", `reportAddedDate`="2021-01-23 13:04:55", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bae" ,"60" ,"G-Gaia" ,"0" ,"16.67" ,"0.2" ,"ABMag" ,"Gaia21akg" ,"2021-01-22 11:44:10" ,"2021-01-23 13:04:21" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bae", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="16.67", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akg", `obsdate`="2021-01-22 11:44:10", `reportAddedDate`="2021-01-23 13:04:21", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bae" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akg" ,"2019-05-26 23:42:43" ,"2021-01-23 13:04:21" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bae", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akg", `obsdate`="2019-05-26 23:42:43", `reportAddedDate`="2021-01-23 13:04:21", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bad" ,"60" ,"G-Gaia" ,"0" ,"18.42" ,"0.2" ,"ABMag" ,"Gaia21akf" ,"2021-01-22 11:03:50" ,"2021-01-23 13:04:02" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bad", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.42", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akf", `obsdate`="2021-01-22 11:03:50", `reportAddedDate`="2021-01-23 13:04:02", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bad" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akf" ,"2020-12-19 11:26:53" ,"2021-01-23 13:04:02" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bad", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akf", `obsdate`="2020-12-19 11:26:53", `reportAddedDate`="2021-01-23 13:04:02", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bac" ,"60" ,"G-Gaia" ,"0" ,"19.84" ,"0.2" ,"ABMag" ,"Gaia21ake" ,"2021-01-04 06:10:05" ,"2021-01-23 13:03:46" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bac", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="19.84", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ake", `obsdate`="2021-01-04 06:10:05", `reportAddedDate`="2021-01-23 13:03:46", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bac" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ake" ,"2020-11-29 20:48:29" ,"2021-01-23 13:03:46" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bac", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ake", `obsdate`="2020-11-29 20:48:29", `reportAddedDate`="2021-01-23 13:03:46", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bab" ,"60" ,"G-Gaia" ,"0" ,"19.62" ,"0.2" ,"ABMag" ,"Gaia21akc" ,"2021-01-22 05:21:07" ,"2021-01-23 13:02:31" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bab", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="19.62", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akc", `obsdate`="2021-01-22 05:21:07", `reportAddedDate`="2021-01-23 13:02:31", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bab" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akc" ,"2021-01-07 09:30:14" ,"2021-01-23 13:02:31" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bab", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akc", `obsdate`="2021-01-07 09:30:14", `reportAddedDate`="2021-01-23 13:02:31", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021baa" ,"27" ,"i-Sloan" ,"0" ,"20.35" ,"0.22" ,"ABMag" ,"PS21no" ,"2021-01-03 15:23:02" ,"2021-01-22 13:15:04" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021baa", `exptime`="27", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.35", `magErr`="0.22", `magUnit`="ABMag", `objectName`="PS21no", `obsdate`="2021-01-03 15:23:02", `reportAddedDate`="2021-01-22 13:15:04", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azz" ,"45" ,"w-PS1" ,"0" ,"20.55" ,"0.11" ,"ABMag" ,"PS21nn" ,"2021-01-15 10:45:07" ,"2021-01-22 11:46:55" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.55", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS21nn", `obsdate`="2021-01-15 10:45:07", `reportAddedDate`="2021-01-22 11:46:55", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azy" ,"45" ,"w-PS1" ,"0" ,"21.17" ,"0.07" ,"ABMag" ,"PS21nm" ,"2021-01-15 14:24:00" ,"2021-01-22 11:43:56" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azy", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.17", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS21nm", `obsdate`="2021-01-15 14:24:00", `reportAddedDate`="2021-01-22 11:43:56", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azx" ,"45" ,"w-PS1" ,"0" ,"20.54" ,"0.05" ,"ABMag" ,"PS21nl" ,"2021-01-16 06:46:05" ,"2021-01-22 11:42:43" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azx", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.54", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21nl", `obsdate`="2021-01-16 06:46:05", `reportAddedDate`="2021-01-22 11:42:43", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azw" ,"45" ,"w-PS1" ,"0" ,"20.99" ,"0.08" ,"ABMag" ,"PS21nk" ,"2021-01-05 06:44:38" ,"2021-01-22 11:42:09" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azw", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.99", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS21nk", `obsdate`="2021-01-05 06:44:38", `reportAddedDate`="2021-01-22 11:42:09", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azv" ,"45" ,"w-PS1" ,"0" ,"20.71" ,"0.15" ,"ABMag" ,"PS21nf" ,"2021-01-16 10:22:05" ,"2021-01-22 11:35:51" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azv", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.71", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS21nf", `obsdate`="2021-01-16 10:22:05", `reportAddedDate`="2021-01-22 11:35:51", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azu" ,"45" ,"w-PS1" ,"0" ,"21.37" ,"0.27" ,"ABMag" ,"PS21nd" ,"2021-01-14 07:17:46" ,"2021-01-22 11:33:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azu", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.37", `magErr`="0.27", `magUnit`="ABMag", `objectName`="PS21nd", `obsdate`="2021-01-14 07:17:46", `reportAddedDate`="2021-01-22 11:33:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azt" ,"45" ,"w-PS1" ,"0" ,"21.18" ,"0.1" ,"ABMag" ,"PS21nc" ,"2021-01-12 06:54:43" ,"2021-01-22 11:32:23" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azt", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.18", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21nc", `obsdate`="2021-01-12 06:54:43", `reportAddedDate`="2021-01-22 11:32:23", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azs" ,"45" ,"w-PS1" ,"0" ,"20.93" ,"0.09" ,"ABMag" ,"PS21nb" ,"2021-01-06 05:36:58" ,"2021-01-22 11:31:52" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azs", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.93", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS21nb", `obsdate`="2021-01-06 05:36:58", `reportAddedDate`="2021-01-22 11:31:52", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azr" ,"45" ,"w-PS1" ,"0" ,"21.24" ,"0.07" ,"ABMag" ,"PS21my" ,"2021-01-15 14:28:19" ,"2021-01-22 11:22:37" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azr", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.24", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS21my", `obsdate`="2021-01-15 14:28:19", `reportAddedDate`="2021-01-22 11:22:37", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azq" ,"45" ,"w-PS1" ,"0" ,"20.92" ,"0.05" ,"ABMag" ,"PS21mx" ,"2021-01-07 07:49:26" ,"2021-01-22 11:21:19" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azq", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.92", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21mx", `obsdate`="2021-01-07 07:49:26", `reportAddedDate`="2021-01-22 11:21:19", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azp" ,"45" ,"w-PS1" ,"0" ,"21.07" ,"0.12" ,"ABMag" ,"PS21mw" ,"2021-01-12 08:29:46" ,"2021-01-22 11:20:05" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azp", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.07", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS21mw", `obsdate`="2021-01-12 08:29:46", `reportAddedDate`="2021-01-22 11:20:05", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azo" ,"30" ,"g-ZTF" ,"0" ,"17.98" ,null ,"ABMag" ,"ZTF21aagkfgh" ,"2021-01-20 10:33:36" ,"2021-01-22 09:59:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="17.98", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aagkfgh", `obsdate`="2021-01-20 10:33:36", `reportAddedDate`="2021-01-22 09:59:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azo" ,"30" ,"g-ZTF" ,"0" ,"18.39" ,null ,"ABMag" ,"ZTF21aagkfgh" ,"2021-01-07 11:32:38" ,"2021-01-22 09:59:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.39", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aagkfgh", `obsdate`="2021-01-07 11:32:38", `reportAddedDate`="2021-01-22 09:59:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azo" ,"30" ,"g-ZTF" ,"1" ,"19.27" ,null ,"ABMag" ,"ZTF21aagkfgh" ,"2021-01-05 12:36:00" ,"2021-01-22 09:59:24" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azo", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.27", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aagkfgh", `obsdate`="2021-01-05 12:36:00", `reportAddedDate`="2021-01-22 09:59:24", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azn" ,"60" ,"G-Gaia" ,"0" ,"19.31" ,"0.2" ,"ABMag" ,"Gaia21aka" ,"2021-01-20 20:12:29" ,"2021-01-22 09:04:33" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azn", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="19.31", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21aka", `obsdate`="2021-01-20 20:12:29", `reportAddedDate`="2021-01-22 09:04:33", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azn" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21aka" ,"2020-11-17 05:11:02" ,"2021-01-22 09:04:33" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azn", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21aka", `obsdate`="2020-11-17 05:11:02", `reportAddedDate`="2021-01-22 09:04:33", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azm" ,"60" ,"G-Gaia" ,"0" ,"16.47" ,"0.2" ,"ABMag" ,"Gaia21ajz" ,"2021-01-21 05:22:34" ,"2021-01-22 09:04:06" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azm", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="16.47", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajz", `obsdate`="2021-01-21 05:22:34", `reportAddedDate`="2021-01-22 09:04:06", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azm" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajz" ,"2020-11-18 18:24:29" ,"2021-01-22 09:04:06" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azm", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajz", `obsdate`="2020-11-18 18:24:29", `reportAddedDate`="2021-01-22 09:04:06", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azl" ,"60" ,"G-Gaia" ,"0" ,"17.13" ,"0.2" ,"ABMag" ,"Gaia21ajy" ,"2021-01-21 01:55:12" ,"2021-01-22 09:03:31" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azl", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.13", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajy", `obsdate`="2021-01-21 01:55:12", `reportAddedDate`="2021-01-22 09:03:31", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azl" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajy" ,"2020-09-04 04:39:22" ,"2021-01-22 09:03:31" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azl", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajy", `obsdate`="2020-09-04 04:39:22", `reportAddedDate`="2021-01-22 09:03:31", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azk" ,"60" ,"G-Gaia" ,"0" ,"18.75" ,"0.2" ,"ABMag" ,"Gaia21ajx" ,"2021-01-20 10:20:38" ,"2021-01-22 09:03:09" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azk", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.75", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajx", `obsdate`="2021-01-20 10:20:38", `reportAddedDate`="2021-01-22 09:03:09", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azk" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajx" ,"2020-10-29 05:32:38" ,"2021-01-22 09:03:09" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azk", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajx", `obsdate`="2020-10-29 05:32:38", `reportAddedDate`="2021-01-22 09:03:09", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azj" ,"60" ,"G-Gaia" ,"0" ,"17.46" ,"0.2" ,"ABMag" ,"Gaia21ajt" ,"2021-01-21 00:18:43" ,"2021-01-22 08:59:44" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azj", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.46", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajt", `obsdate`="2021-01-21 00:18:43", `reportAddedDate`="2021-01-22 08:59:44", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azj" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajt" ,"2021-01-06 14:00:58" ,"2021-01-22 08:59:44" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azj", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajt", `obsdate`="2021-01-06 14:00:58", `reportAddedDate`="2021-01-22 08:59:44", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azi" ,"60" ,"G-Gaia" ,"0" ,"18.91" ,"0.2" ,"ABMag" ,"Gaia21ajr" ,"2021-01-20 21:18:43" ,"2021-01-22 08:59:03" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azi", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.91", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajr", `obsdate`="2021-01-20 21:18:43", `reportAddedDate`="2021-01-22 08:59:03", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azi" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajr" ,"2021-01-04 23:02:24" ,"2021-01-22 08:59:03" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azi", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajr", `obsdate`="2021-01-04 23:02:24", `reportAddedDate`="2021-01-22 08:59:03", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azh" ,"60" ,"G-Gaia" ,"0" ,"18.61" ,"0.2" ,"ABMag" ,"Gaia21ajp" ,"2021-01-21 08:15:22" ,"2021-01-22 08:58:05" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azh", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.61", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajp", `obsdate`="2021-01-21 08:15:22", `reportAddedDate`="2021-01-22 08:58:05", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azh" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajp" ,"2020-10-28 03:27:22" ,"2021-01-22 08:58:05" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azh", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajp", `obsdate`="2020-10-28 03:27:22", `reportAddedDate`="2021-01-22 08:58:05", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azg" ,"60" ,"G-Gaia" ,"0" ,"18.66" ,"0.2" ,"ABMag" ,"Gaia21ajo" ,"2021-01-21 06:01:26" ,"2021-01-22 08:57:45" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azg", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.66", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajo", `obsdate`="2021-01-21 06:01:26", `reportAddedDate`="2021-01-22 08:57:45", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azg" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajo" ,"2020-10-28 21:01:26" ,"2021-01-22 08:57:45" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azg", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajo", `obsdate`="2020-10-28 21:01:26", `reportAddedDate`="2021-01-22 08:57:45", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azf" ,"60" ,"G-Gaia" ,"0" ,"18.96" ,"0.2" ,"ABMag" ,"Gaia21ajn" ,"2021-01-20 16:43:41" ,"2021-01-22 08:57:21" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azf", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.96", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajn", `obsdate`="2021-01-20 16:43:41", `reportAddedDate`="2021-01-22 08:57:21", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azf" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajn" ,"2019-04-18 18:59:02" ,"2021-01-22 08:57:21" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azf", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajn", `obsdate`="2019-04-18 18:59:02", `reportAddedDate`="2021-01-22 08:57:21", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aze" ,"60" ,"G-Gaia" ,"0" ,"18.53" ,"0.2" ,"ABMag" ,"Gaia21ajm" ,"2021-01-20 15:46:05" ,"2021-01-22 08:56:46" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aze", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.53", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajm", `obsdate`="2021-01-20 15:46:05", `reportAddedDate`="2021-01-22 08:56:46", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aze" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajm" ,"2020-10-30 10:48:00" ,"2021-01-22 08:56:46" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aze", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajm", `obsdate`="2020-10-30 10:48:00", `reportAddedDate`="2021-01-22 08:56:46", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azd" ,"60" ,"G-Gaia" ,"0" ,"14.74" ,"0.2" ,"ABMag" ,"Gaia21ajl" ,"2021-01-19 19:49:26" ,"2021-01-22 08:56:09" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azd", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="14.74", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajl", `obsdate`="2021-01-19 19:49:26", `reportAddedDate`="2021-01-22 08:56:09", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azd" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajl" ,"2019-10-30 19:53:46" ,"2021-01-22 08:56:09" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azd", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajl", `obsdate`="2019-10-30 19:53:46", `reportAddedDate`="2021-01-22 08:56:09", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azc" ,"30" ,"cyan-ATLAS" ,"0" ,"18.919" ,"0.127" ,"ABMag" ,"ATLAS21dan" ,"2021-01-21 14:39:50" ,"2021-01-22 01:20:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azc", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.919", `magErr`="0.127", `magUnit`="ABMag", `objectName`="ATLAS21dan", `obsdate`="2021-01-21 14:39:50", `reportAddedDate`="2021-01-22 01:20:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azc" ,"30" ,"cyan-ATLAS" ,"1" ,"19.45" ,null ,"ABMag" ,"ATLAS21dan" ,"2021-01-17 12:08:38" ,"2021-01-22 01:20:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azc", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.45", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21dan", `obsdate`="2021-01-17 12:08:38", `reportAddedDate`="2021-01-22 01:20:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azb" ,"30" ,"cyan-ATLAS" ,"0" ,"19.376" ,"0.154" ,"ABMag" ,"ATLAS21dal" ,"2021-01-21 15:04:19" ,"2021-01-22 01:18:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.376", `magErr`="0.154", `magUnit`="ABMag", `objectName`="ATLAS21dal", `obsdate`="2021-01-21 15:04:19", `reportAddedDate`="2021-01-22 01:18:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021azb" ,"30" ,"cyan-ATLAS" ,"1" ,"19.63" ,null ,"ABMag" ,"ATLAS21dal" ,"2021-01-17 12:53:17" ,"2021-01-22 01:18:08" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021azb", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.63", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21dal", `obsdate`="2021-01-17 12:53:17", `reportAddedDate`="2021-01-22 01:18:08", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aza" ,"30" ,"cyan-ATLAS" ,"0" ,"19.326" ,"0.175" ,"ABMag" ,"ATLAS21dak" ,"2021-01-21 14:47:02" ,"2021-01-22 01:17:07" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aza", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.326", `magErr`="0.175", `magUnit`="ABMag", `objectName`="ATLAS21dak", `obsdate`="2021-01-21 14:47:02", `reportAddedDate`="2021-01-22 01:17:07", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aza" ,"30" ,"cyan-ATLAS" ,"1" ,"19.71" ,null ,"ABMag" ,"ATLAS21dak" ,"2021-01-17 12:02:53" ,"2021-01-22 01:17:07" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aza", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.71", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21dak", `obsdate`="2021-01-17 12:02:53", `reportAddedDate`="2021-01-22 01:17:07", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ayz" ,"45" ,"w-PS1" ,"0" ,"21.47" ,"0.1" ,"ABMag" ,"PS21mt" ,"2021-01-05 07:49:26" ,"2021-01-22 00:02:45" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ayz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.47", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21mt", `obsdate`="2021-01-05 07:49:26", `reportAddedDate`="2021-01-22 00:02:45", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,null ,"g-ZTF" ,"0" ,"19.64" ,"0.19" ,"ABMag" ,"ZTF21aafkktu" ,"2021-01-17 10:05:23" ,"2021-01-25 09:44:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`=null, `filter`="g-ZTF", `limitingMag`="0", `mag`="19.64", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF21aafkktu", `obsdate`="2021-01-17 10:05:23", `reportAddedDate`="2021-01-25 09:44:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,null ,"r-ZTF" ,"1" ,"19.79" ,null ,"ABMag" ,"ZTF21aafkktu" ,"2021-01-15 10:28:08" ,"2021-01-25 09:44:18" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`=null, `filter`="r-ZTF", `limitingMag`="1", `mag`="19.79", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aafkktu", `obsdate`="2021-01-15 10:28:08", `reportAddedDate`="2021-01-25 09:44:18", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,"60" ,"G-Gaia" ,"0" ,"18.41" ,"0.2" ,"ABMag" ,"Gaia21aku" ,"2021-01-23 22:04:48" ,"2021-01-25 06:33:15" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.41", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21aku", `obsdate`="2021-01-23 22:04:48", `reportAddedDate`="2021-01-25 06:33:15", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21aku" ,"2021-01-13 11:44:10" ,"2021-01-25 06:33:15" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21aku", `obsdate`="2021-01-13 11:44:10", `reportAddedDate`="2021-01-25 06:33:15", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,"30" ,"g-ZTF" ,"0" ,"18.4" ,null ,"ABMag" ,"ZTF21aafkktu" ,"2021-01-20 10:52:19" ,"2021-01-20 19:59:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.4", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aafkktu", `obsdate`="2021-01-20 10:52:19", `reportAddedDate`="2021-01-20 19:59:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,"30" ,"g-ZTF" ,"0" ,"19.64" ,null ,"ABMag" ,"ZTF21aafkktu" ,"2021-01-17 10:04:48" ,"2021-01-20 19:59:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.64", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aafkktu", `obsdate`="2021-01-17 10:04:48", `reportAddedDate`="2021-01-20 19:59:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,"30" ,"r-ZTF" ,"1" ,"19.79" ,null ,"ABMag" ,"ZTF21aafkktu" ,"2021-01-15 10:27:50" ,"2021-01-20 19:59:28" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.79", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aafkktu", `obsdate`="2021-01-15 10:27:50", `reportAddedDate`="2021-01-20 19:59:28", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,"30" ,"cyan-ATLAS" ,"0" ,"19.499" ,"0.158" ,"ABMag" ,"ATLAS21cux" ,"2021-01-17 12:25:55" ,"2021-01-19 00:41:43" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.499", `magErr`="0.158", `magUnit`="ABMag", `objectName`="ATLAS21cux", `obsdate`="2021-01-17 12:25:55", `reportAddedDate`="2021-01-19 00:41:43", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021avg" ,"30" ,"cyan-ATLAS" ,"1" ,"19.89" ,null ,"ABMag" ,"ATLAS21cux" ,"2021-01-15 15:43:12" ,"2021-01-19 00:41:43" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021avg", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.89", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21cux", `obsdate`="2021-01-15 15:43:12", `reportAddedDate`="2021-01-19 00:41:43", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aul" ,"45" ,"w-PS1" ,"0" ,"19.06" ,"0.05" ,"ABMag" ,"PS21ou" ,"2021-01-21 13:07:41" ,"2021-01-24 23:36:30" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aul", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.06", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21ou", `obsdate`="2021-01-21 13:07:41", `reportAddedDate`="2021-01-24 23:36:30", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aul" ,"30" ,"cyan-ATLAS" ,"0" ,"18.888" ,"0.143" ,"ABMag" ,"ATLAS21cvb" ,"2021-01-18 10:10:34" ,"2021-01-19 00:45:59" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aul", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.888", `magErr`="0.143", `magUnit`="ABMag", `objectName`="ATLAS21cvb", `obsdate`="2021-01-18 10:10:34", `reportAddedDate`="2021-01-19 00:45:59", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aul" ,"30" ,"cyan-ATLAS" ,"1" ,"19.62" ,null ,"ABMag" ,"ATLAS21cvb" ,"2021-01-16 09:23:02" ,"2021-01-19 00:45:59" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aul", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.62", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21cvb", `obsdate`="2021-01-16 09:23:02", `reportAddedDate`="2021-01-19 00:45:59", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aul" ,"30" ,"g-ZTF" ,"0" ,"18.9834" ,"0.0761957" ,"ABMag" ,"ZTF21aagbeah" ,"2021-01-18 10:29:49" ,"2021-01-18 18:27:34" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aul", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.9834", `magErr`="0.0761957", `magUnit`="ABMag", `objectName`="ZTF21aagbeah", `obsdate`="2021-01-18 10:29:49", `reportAddedDate`="2021-01-18 18:27:34", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aul" ,"30" ,"g-ZTF" ,"1" ,"20.6416" ,null ,"ABMag" ,"ZTF21aagbeah" ,"2021-01-16 11:12:03" ,"2021-01-18 18:27:34" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aul", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.6416", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aagbeah", `obsdate`="2021-01-16 11:12:03", `reportAddedDate`="2021-01-18 18:27:34", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021atv" ,"45" ,"w-PS1" ,"0" ,"20.7" ,"0.1" ,"ABMag" ,"PS21nj" ,"2021-01-15 13:01:55" ,"2021-01-22 11:41:43" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021atv", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.7", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21nj", `obsdate`="2021-01-15 13:01:55", `reportAddedDate`="2021-01-22 11:41:43", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021atv" ,"30" ,"g-ZTF" ,"0" ,"20.1754" ,"0.209486" ,"ABMag" ,"ZTF21aagclzp" ,"2021-01-18 11:26:56" ,"2021-01-18 18:27:34" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021atv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1754", `magErr`="0.209486", `magUnit`="ABMag", `objectName`="ZTF21aagclzp", `obsdate`="2021-01-18 11:26:56", `reportAddedDate`="2021-01-18 18:27:34", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021atv" ,"30" ,"r-ZTF" ,"0" ,"20.3222" ,"0.271685" ,"ABMag" ,"ZTF21aagclzp" ,"2021-01-16 10:35:42" ,"2021-01-18 18:27:34" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021atv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.3222", `magErr`="0.271685", `magUnit`="ABMag", `objectName`="ZTF21aagclzp", `obsdate`="2021-01-16 10:35:42", `reportAddedDate`="2021-01-18 18:27:34", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021atv" ,"30" ,"g-ZTF" ,"0" ,"20.7315" ,"0.373217" ,"ABMag" ,"ZTF21aagclzp" ,"2021-01-14 10:51:43" ,"2021-01-18 18:27:34" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021atv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.7315", `magErr`="0.373217", `magUnit`="ABMag", `objectName`="ZTF21aagclzp", `obsdate`="2021-01-14 10:51:43", `reportAddedDate`="2021-01-18 18:27:34", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021atv" ,"30" ,"g-ZTF" ,"1" ,"20.1897" ,null ,"ABMag" ,"ZTF21aagclzp" ,"2021-01-12 12:59:28" ,"2021-01-18 18:27:34" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021atv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.1897", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aagclzp", `obsdate`="2021-01-12 12:59:28", `reportAddedDate`="2021-01-18 18:27:34", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aqq" ,"45" ,"i-Sloan" ,"0" ,"18.31" ,"0.1" ,"ABMag" ,"PS21pf" ,"2021-01-23 11:05:17" ,"2021-01-25 10:41:03" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aqq", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="18.31", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21pf", `obsdate`="2021-01-23 11:05:17", `reportAddedDate`="2021-01-25 10:41:03", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aqq" ,"30" ,"g-ZTF" ,"0" ,"19.4922" ,"0.113842" ,"ABMag" ,"ZTF21aafjjee" ,"2021-01-17 10:24:06" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aqq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4922", `magErr`="0.113842", `magUnit`="ABMag", `objectName`="ZTF21aafjjee", `obsdate`="2021-01-17 10:24:06", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aqq" ,"30" ,"r-ZTF" ,"0" ,"19.4754" ,"0.112558" ,"ABMag" ,"ZTF21aafjjee" ,"2021-01-17 08:53:49" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aqq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4754", `magErr`="0.112558", `magUnit`="ABMag", `objectName`="ZTF21aafjjee", `obsdate`="2021-01-17 08:53:49", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aqq" ,"30" ,"g-ZTF" ,"0" ,"20.5625" ,"0.320833" ,"ABMag" ,"ZTF21aafjjee" ,"2021-01-15 10:41:33" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aqq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.5625", `magErr`="0.320833", `magUnit`="ABMag", `objectName`="ZTF21aafjjee", `obsdate`="2021-01-15 10:41:33", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aqq" ,"30" ,"r-ZTF" ,"1" ,"19.8791" ,null ,"ABMag" ,"ZTF21aafjjee" ,"2021-01-15 10:13:32" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aqq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8791", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aafjjee", `obsdate`="2021-01-15 10:13:32", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apj" ,"60" ,"G-Gaia" ,"0" ,"18.88" ,"0.2" ,"ABMag" ,"Gaia21akh" ,"2021-01-22 03:33:07" ,"2021-01-23 13:04:34" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.88", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akh", `obsdate`="2021-01-22 03:33:07", `reportAddedDate`="2021-01-23 13:04:34", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apj" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akh" ,"2021-01-07 03:27:22" ,"2021-01-23 13:04:34" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akh", `obsdate`="2021-01-07 03:27:22", `reportAddedDate`="2021-01-23 13:04:34", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apj" ,"30" ,"r-ZTF" ,"0" ,"19.0609" ,"0.0979604" ,"ABMag" ,"ZTF21aaeolfd" ,"2021-01-17 11:45:03" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.0609", `magErr`="0.0979604", `magUnit`="ABMag", `objectName`="ZTF21aaeolfd", `obsdate`="2021-01-17 11:45:03", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apj" ,"30" ,"g-ZTF" ,"0" ,"19.0857" ,"0.0883689" ,"ABMag" ,"ZTF21aaeolfd" ,"2021-01-17 10:21:20" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.0857", `magErr`="0.0883689", `magUnit`="ABMag", `objectName`="ZTF21aaeolfd", `obsdate`="2021-01-17 10:21:20", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apj" ,"30" ,"g-ZTF" ,"0" ,"19.7052" ,"0.145869" ,"ABMag" ,"ZTF21aaeolfd" ,"2021-01-13 10:39:14" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7052", `magErr`="0.145869", `magUnit`="ABMag", `objectName`="ZTF21aaeolfd", `obsdate`="2021-01-13 10:39:14", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apj" ,"30" ,"g-ZTF" ,"0" ,"20.2393" ,"0.417583" ,"ABMag" ,"ZTF21aaeolfd" ,"2021-01-11 11:27:37" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2393", `magErr`="0.417583", `magUnit`="ABMag", `objectName`="ZTF21aaeolfd", `obsdate`="2021-01-11 11:27:37", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apj" ,"30" ,"r-ZTF" ,"0" ,"20.1114" ,"0.269939" ,"ABMag" ,"ZTF21aaeolfd" ,"2021-01-11 09:48:05" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1114", `magErr`="0.269939", `magUnit`="ABMag", `objectName`="ZTF21aaeolfd", `obsdate`="2021-01-11 09:48:05", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apj" ,"30" ,"r-ZTF" ,"1" ,"20.2474" ,null ,"ABMag" ,"ZTF21aaeolfd" ,"2021-01-09 11:21:25" ,"2021-01-17 19:17:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apj", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.2474", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaeolfd", `obsdate`="2021-01-09 11:21:25", `reportAddedDate`="2021-01-17 19:17:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apd" ,"45" ,"w-PS1" ,"0" ,"19.95" ,"0.07" ,"ABMag" ,"PS21iw" ,"2021-01-12 05:15:22" ,"2021-01-23 16:37:08" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apd", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.95", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS21iw", `obsdate`="2021-01-12 05:15:22", `reportAddedDate`="2021-01-23 16:37:08", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apd" ,"30" ,"cyan-ATLAS" ,"0" ,"19.267" ,"0.177" ,"ABMag" ,"ATLAS21crg" ,"2021-01-16 05:24:00" ,"2021-01-18 00:38:26" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.267", `magErr`="0.177", `magUnit`="ABMag", `objectName`="ATLAS21crg", `obsdate`="2021-01-16 05:24:00", `reportAddedDate`="2021-01-18 00:38:26", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apd" ,"30" ,"cyan-ATLAS" ,"1" ,"19.56" ,null ,"ABMag" ,"ATLAS21crg" ,"2021-01-12 07:03:22" ,"2021-01-18 00:38:26" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.56", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21crg", `obsdate`="2021-01-12 07:03:22", `reportAddedDate`="2021-01-18 00:38:26", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021apd" ,"27" ,"i-Sloan" ,"0" ,"19.77" ,"0.05" ,"ABMag" ,"PS21iw" ,"2021-01-13 05:24:00" ,"2021-01-17 14:59:52" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021apd", `exptime`="27", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.77", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21iw", `obsdate`="2021-01-13 05:24:00", `reportAddedDate`="2021-01-17 14:59:52", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aog" ,"60" ,"G-Gaia" ,"0" ,"18.74" ,"0.2" ,"ABMag" ,"Gaia21ajw" ,"2021-01-20 09:08:38" ,"2021-01-22 09:02:32" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aog", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.74", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajw", `obsdate`="2021-01-20 09:08:38", `reportAddedDate`="2021-01-22 09:02:32", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aog" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajw" ,"2020-12-13 19:59:31" ,"2021-01-22 09:02:32" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aog", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajw", `obsdate`="2020-12-13 19:59:31", `reportAddedDate`="2021-01-22 09:02:32", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aog" ,"30" ,"r-ZTF" ,"0" ,"18.99" ,null ,"ABMag" ,"ZTF18abxptoa" ,"2021-01-15 02:41:17" ,"2021-01-16 22:00:29" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aog", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.99", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18abxptoa", `obsdate`="2021-01-15 02:41:17", `reportAddedDate`="2021-01-16 22:00:29", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aog" ,"30" ,"r-ZTF" ,"0" ,"19.52" ,null ,"ABMag" ,"ZTF18abxptoa" ,"2021-01-09 02:55:41" ,"2021-01-16 22:00:29" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aog", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.52", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18abxptoa", `obsdate`="2021-01-09 02:55:41", `reportAddedDate`="2021-01-16 22:00:29", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aog" ,"30" ,"g-ZTF" ,"1" ,"18.92" ,null ,"ABMag" ,"ZTF18abxptoa" ,"2021-01-07 03:28:48" ,"2021-01-16 22:00:29" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aog", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="18.92", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF18abxptoa", `obsdate`="2021-01-07 03:28:48", `reportAddedDate`="2021-01-16 22:00:29", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ajh" ,"60" ,"G-Gaia" ,"0" ,"17.22" ,"0.2" ,"ABMag" ,"Gaia21aju" ,"2021-01-20 17:11:02" ,"2021-01-22 09:00:39" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ajh", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.22", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21aju", `obsdate`="2021-01-20 17:11:02", `reportAddedDate`="2021-01-22 09:00:39", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ajh" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21aju" ,"2021-01-06 05:06:43" ,"2021-01-22 09:00:39" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ajh", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21aju", `obsdate`="2021-01-06 05:06:43", `reportAddedDate`="2021-01-22 09:00:39", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ajh" ,"30" ,"cyan-ATLAS" ,"0" ,"19.222" ,"0.132" ,"ABMag" ,"ATLAS21bto" ,"2021-01-14 13:47:59" ,"2021-01-15 03:11:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ajh", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.222", `magErr`="0.132", `magUnit`="ABMag", `objectName`="ATLAS21bto", `obsdate`="2021-01-14 13:47:59", `reportAddedDate`="2021-01-15 03:11:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ajh" ,"30" ,"cyan-ATLAS" ,"1" ,"19.64" ,null ,"ABMag" ,"ATLAS21bto" ,"2021-01-12 14:02:24" ,"2021-01-15 03:11:51" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ajh", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.64", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21bto", `obsdate`="2021-01-12 14:02:24", `reportAddedDate`="2021-01-15 03:11:51", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aii" ,"45" ,"w-PS1" ,"0" ,"20.83" ,"0.12" ,"ABMag" ,"PS21nt" ,"2021-01-15 09:41:46" ,"2021-01-23 16:40:31" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aii", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.83", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS21nt", `obsdate`="2021-01-15 09:41:46", `reportAddedDate`="2021-01-23 16:40:31", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aii" ,"30" ,"r-ZTF" ,"0" ,"20.4813" ,"0.187299" ,"ABMag" ,"ZTF21aaefmlt" ,"2021-01-14 07:53:21" ,"2021-01-14 20:56:19" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aii", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4813", `magErr`="0.187299", `magUnit`="ABMag", `objectName`="ZTF21aaefmlt", `obsdate`="2021-01-14 07:53:21", `reportAddedDate`="2021-01-14 20:56:19", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aii" ,"30" ,"g-ZTF" ,"1" ,"20.7638" ,null ,"ABMag" ,"ZTF21aaefmlt" ,"2021-01-14 06:19:10" ,"2021-01-14 20:56:19" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aii", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.7638", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaefmlt", `obsdate`="2021-01-14 06:19:10", `reportAddedDate`="2021-01-14 20:56:19", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aib" ,"45" ,"w-PS1" ,"0" ,"18.88" ,"0.08" ,"ABMag" ,"PS21pe" ,"2021-01-24 15:27:22" ,"2021-01-25 10:40:10" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aib", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="18.88", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS21pe", `obsdate`="2021-01-24 15:27:22", `reportAddedDate`="2021-01-25 10:40:10", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aib" ,"30" ,"cyan-ATLAS" ,"0" ,"19.044" ,"0.154" ,"ABMag" ,"ATLAS21csf" ,"2021-01-17 14:18:14" ,"2021-01-18 19:53:34" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aib", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.044", `magErr`="0.154", `magUnit`="ABMag", `objectName`="ATLAS21csf", `obsdate`="2021-01-17 14:18:14", `reportAddedDate`="2021-01-18 19:53:34", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aib" ,"30" ,"cyan-ATLAS" ,"1" ,"19.48" ,null ,"ABMag" ,"ATLAS21csf" ,"2021-01-16 15:00:00" ,"2021-01-18 19:53:34" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aib", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.48", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21csf", `obsdate`="2021-01-16 15:00:00", `reportAddedDate`="2021-01-18 19:53:34", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aib" ,"30" ,"g-ZTF" ,"0" ,"19.7345" ,"0.167711" ,"ABMag" ,"ZTF21aaeknki" ,"2021-01-14 12:30:11" ,"2021-01-14 20:56:19" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aib", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.7345", `magErr`="0.167711", `magUnit`="ABMag", `objectName`="ZTF21aaeknki", `obsdate`="2021-01-14 12:30:11", `reportAddedDate`="2021-01-14 20:56:19", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aib" ,"30" ,"g-ZTF" ,"0" ,"20.1539" ,"0.239455" ,"ABMag" ,"ZTF21aaeknki" ,"2021-01-12 13:01:05" ,"2021-01-14 20:56:19" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aib", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1539", `magErr`="0.239455", `magUnit`="ABMag", `objectName`="ZTF21aaeknki", `obsdate`="2021-01-12 13:01:05", `reportAddedDate`="2021-01-14 20:56:19", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aib" ,"30" ,"r-ZTF" ,"1" ,"19.8127" ,null ,"ABMag" ,"ZTF21aaeknki" ,"2021-01-12 12:28:57" ,"2021-01-14 20:56:19" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aib", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.8127", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaeknki", `obsdate`="2021-01-12 12:28:57", `reportAddedDate`="2021-01-14 20:56:19", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aew" ,"45" ,"w-PS1" ,"0" ,"19.66" ,"0.03" ,"ABMag" ,"PS21qm" ,"2021-01-16 06:46:05" ,"2021-01-25 12:21:05" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aew", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.66", `magErr`="0.03", `magUnit`="ABMag", `objectName`="PS21qm", `obsdate`="2021-01-16 06:46:05", `reportAddedDate`="2021-01-25 12:21:05", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aew" ,"30" ,"cyan-ATLAS" ,"0" ,"19.707" ,"0.183" ,"ABMag" ,"ATLAS21brr" ,"2021-01-13 08:31:12" ,"2021-01-13 22:44:56" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aew", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.707", `magErr`="0.183", `magUnit`="ABMag", `objectName`="ATLAS21brr", `obsdate`="2021-01-13 08:31:12", `reportAddedDate`="2021-01-13 22:44:56", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aew" ,"30" ,"cyan-ATLAS" ,"1" ,"18.65" ,null ,"ABMag" ,"ATLAS21brr" ,"2021-01-09 08:49:55" ,"2021-01-13 22:44:56" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aew", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="18.65", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21brr", `obsdate`="2021-01-09 08:49:55", `reportAddedDate`="2021-01-13 22:44:56", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aaj" ,"45" ,"w-PS1" ,"0" ,"18.06" ,"0.02" ,"ABMag" ,"PS21oz" ,"2021-01-16 05:45:36" ,"2021-01-25 10:36:55" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aaj", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="18.06", `magErr`="0.02", `magUnit`="ABMag", `objectName`="PS21oz", `obsdate`="2021-01-16 05:45:36", `reportAddedDate`="2021-01-25 10:36:55", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aaj" ,"30" ,"cyan-ATLAS" ,"0" ,"19.346" ,"0.139" ,"ABMag" ,"ATLAS21bgq" ,"2021-01-12 07:30:43" ,"2021-01-12 15:24:45" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aaj", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.346", `magErr`="0.139", `magUnit`="ABMag", `objectName`="ATLAS21bgq", `obsdate`="2021-01-12 07:30:43", `reportAddedDate`="2021-01-12 15:24:45", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021aaj" ,"30" ,"cyan-ATLAS" ,"1" ,"19.97" ,null ,"ABMag" ,"ATLAS21bgq" ,"2021-01-07 07:17:46" ,"2021-01-12 15:24:45" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021aaj", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.97", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21bgq", `obsdate`="2021-01-07 07:17:46", `reportAddedDate`="2021-01-12 15:24:45", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021yk" ,"45" ,"w-PS1" ,"0" ,"18.86" ,"0.02" ,"ABMag" ,"PS21nr" ,"2021-01-17 10:13:26" ,"2021-01-23 16:37:36" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021yk", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="18.86", `magErr`="0.02", `magUnit`="ABMag", `objectName`="PS21nr", `obsdate`="2021-01-17 10:13:26", `reportAddedDate`="2021-01-23 16:37:36", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021yk" ,"30" ,"cyan-ATLAS" ,"0" ,"19.118" ,"0.125" ,"ABMag" ,"ATLAS21bdw" ,"2021-01-10 11:24:00" ,"2021-01-10 21:40:52" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021yk", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.118", `magErr`="0.125", `magUnit`="ABMag", `objectName`="ATLAS21bdw", `obsdate`="2021-01-10 11:24:00", `reportAddedDate`="2021-01-10 21:40:52", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021yk" ,"30" ,"cyan-ATLAS" ,"1" ,"15.83" ,null ,"ABMag" ,"ATLAS21bdw" ,"2021-01-09 13:36:29" ,"2021-01-10 21:40:52" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021yk", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="15.83", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21bdw", `obsdate`="2021-01-09 13:36:29", `reportAddedDate`="2021-01-10 21:40:52", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,null ,"r-ZTF" ,"0" ,"19.93" ,"0.17" ,"ABMag" ,"ZTF21aadatfg" ,"2021-01-10 12:23:28" ,"2021-01-25 09:38:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`=null, `filter`="r-ZTF", `limitingMag`="0", `mag`="19.93", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF21aadatfg", `obsdate`="2021-01-10 12:23:28", `reportAddedDate`="2021-01-25 09:38:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,null ,"r-ZTF" ,"1" ,"19.52" ,null ,"ABMag" ,"ZTF21aadatfg" ,"2021-01-07 13:14:44" ,"2021-01-25 09:38:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`=null, `filter`="r-ZTF", `limitingMag`="1", `mag`="19.52", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aadatfg", `obsdate`="2021-01-07 13:14:44", `reportAddedDate`="2021-01-25 09:38:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,"30" ,"r-ZTF" ,"0" ,"19.9349" ,"0.170379" ,"ABMag" ,"ZTF21aadatfg" ,"2021-01-10 12:23:35" ,"2021-01-18 20:19:04" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9349", `magErr`="0.170379", `magUnit`="ABMag", `objectName`="ZTF21aadatfg", `obsdate`="2021-01-10 12:23:35", `reportAddedDate`="2021-01-18 20:19:04", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,"30" ,"r-ZTF" ,"1" ,"19.5207" ,null ,"ABMag" ,"ZTF21aadatfg" ,"2021-01-07 13:14:51" ,"2021-01-18 20:19:04" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5207", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aadatfg", `obsdate`="2021-01-07 13:14:51", `reportAddedDate`="2021-01-18 20:19:04", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,"30" ,"cyan-ATLAS" ,"0" ,"18.266" ,"0.066" ,"ABMag" ,"ATLAS21cmb" ,"2021-01-16 15:23:02" ,"2021-01-17 19:30:29" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.266", `magErr`="0.066", `magUnit`="ABMag", `objectName`="ATLAS21cmb", `obsdate`="2021-01-16 15:23:02", `reportAddedDate`="2021-01-17 19:30:29", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,"30" ,"orange-ATLAS" ,"1" ,"18.79" ,null ,"ABMag" ,"ATLAS21cmb" ,"2021-01-08 16:03:22" ,"2021-01-17 19:30:29" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.79", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21cmb", `obsdate`="2021-01-08 16:03:22", `reportAddedDate`="2021-01-17 19:30:29", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,"30" ,"g-ZTF" ,"0" ,"19.897" ,"0.212239" ,"ABMag" ,"ZTF21aadatfg" ,"2021-01-10 13:08:33" ,"2021-01-10 17:09:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.897", `magErr`="0.212239", `magUnit`="ABMag", `objectName`="ZTF21aadatfg", `obsdate`="2021-01-10 13:08:33", `reportAddedDate`="2021-01-10 17:09:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,"30" ,"r-ZTF" ,"0" ,"19.9349" ,"0.170379" ,"ABMag" ,"ZTF21aadatfg" ,"2021-01-10 12:23:35" ,"2021-01-10 17:09:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9349", `magErr`="0.170379", `magUnit`="ABMag", `objectName`="ZTF21aadatfg", `obsdate`="2021-01-10 12:23:35", `reportAddedDate`="2021-01-10 17:09:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xv" ,"30" ,"r-ZTF" ,"1" ,"19.5207" ,null ,"ABMag" ,"ZTF21aadatfg" ,"2021-01-07 13:14:51" ,"2021-01-10 17:09:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.5207", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aadatfg", `obsdate`="2021-01-07 13:14:51", `reportAddedDate`="2021-01-10 17:09:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xh" ,"45" ,"w-PS1" ,"0" ,"20.74" ,"0.05" ,"ABMag" ,"PS21ng" ,"2021-01-06 06:44:38" ,"2021-01-22 11:38:42" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xh", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.74", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21ng", `obsdate`="2021-01-06 06:44:38", `reportAddedDate`="2021-01-22 11:38:42", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xh" ,"30" ,"r-ZTF" ,"0" ,"20.1593" ,"0.198573" ,"ABMag" ,"ZTF21aacvfed" ,"2021-01-10 03:27:20" ,"2021-01-10 17:09:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1593", `magErr`="0.198573", `magUnit`="ABMag", `objectName`="ZTF21aacvfed", `obsdate`="2021-01-10 03:27:20", `reportAddedDate`="2021-01-10 17:09:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xh" ,"30" ,"g-ZTF" ,"0" ,"20.0733" ,"0.291302" ,"ABMag" ,"ZTF21aacvfed" ,"2021-01-08 05:59:40" ,"2021-01-10 17:09:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0733", `magErr`="0.291302", `magUnit`="ABMag", `objectName`="ZTF21aacvfed", `obsdate`="2021-01-08 05:59:40", `reportAddedDate`="2021-01-10 17:09:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xh" ,"30" ,"g-ZTF" ,"0" ,"20.7293" ,"0.258665" ,"ABMag" ,"ZTF21aacvfed" ,"2021-01-06 03:51:58" ,"2021-01-10 17:09:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xh", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.7293", `magErr`="0.258665", `magUnit`="ABMag", `objectName`="ZTF21aacvfed", `obsdate`="2021-01-06 03:51:58", `reportAddedDate`="2021-01-10 17:09:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xh" ,"30" ,"r-ZTF" ,"0" ,"20.7024" ,"0.2512" ,"ABMag" ,"ZTF21aacvfed" ,"2021-01-06 02:48:50" ,"2021-01-10 17:09:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.7024", `magErr`="0.2512", `magUnit`="ABMag", `objectName`="ZTF21aacvfed", `obsdate`="2021-01-06 02:48:50", `reportAddedDate`="2021-01-10 17:09:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021xh" ,"30" ,"r-ZTF" ,"1" ,"20.1743" ,null ,"ABMag" ,"ZTF21aacvfed" ,"2021-01-04 03:49:52" ,"2021-01-10 17:09:20" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021xh", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1743", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aacvfed", `obsdate`="2021-01-04 03:49:52", `reportAddedDate`="2021-01-10 17:09:20", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"60" ,"G-Gaia" ,"0" ,"18.98" ,"0.2" ,"ABMag" ,"Gaia21akx" ,"2021-01-11 21:51:50" ,"2021-01-25 06:34:08" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.98", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akx", `obsdate`="2021-01-11 21:51:50", `reportAddedDate`="2021-01-25 06:34:08", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akx" ,"2020-12-07 22:27:50" ,"2021-01-25 06:34:08" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akx", `obsdate`="2020-12-07 22:27:50", `reportAddedDate`="2021-01-25 06:34:08", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"r-ZTF" ,"0" ,"20.1995" ,"0.254255" ,"ABMag" ,"ZTF21aacsuwx" ,"2021-01-07 10:43:51" ,"2021-01-17 20:17:11" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1995", `magErr`="0.254255", `magUnit`="ABMag", `objectName`="ZTF21aacsuwx", `obsdate`="2021-01-07 10:43:51", `reportAddedDate`="2021-01-17 20:17:11", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"r-ZTF" ,"1" ,"19.7931" ,null ,"ABMag" ,"ZTF21aacsuwx" ,"2021-01-03 11:24:53" ,"2021-01-17 20:17:11" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7931", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aacsuwx", `obsdate`="2021-01-03 11:24:53", `reportAddedDate`="2021-01-17 20:17:11", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"cyan-ATLAS" ,"0" ,"18.513" ,"0.104" ,"ABMag" ,"ATLAS21chc" ,"2021-01-15 14:42:43" ,"2021-01-16 11:20:39" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.513", `magErr`="0.104", `magUnit`="ABMag", `objectName`="ATLAS21chc", `obsdate`="2021-01-15 14:42:43", `reportAddedDate`="2021-01-16 11:20:39", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"orange-ATLAS" ,"1" ,"19.56" ,null ,"ABMag" ,"ATLAS21chc" ,"2021-01-07 13:56:38" ,"2021-01-16 11:20:39" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.56", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21chc", `obsdate`="2021-01-07 13:56:38", `reportAddedDate`="2021-01-16 11:20:39", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"27" ,"g-Sloan" ,"0" ,"19.62" ,"0.09" ,"ABMag" ,"PS21gd" ,"2021-01-08 13:49:26" ,"2021-01-14 01:41:48" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="19.62", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS21gd", `obsdate`="2021-01-08 13:49:26", `reportAddedDate`="2021-01-14 01:41:48", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"r-ZTF" ,"0" ,"19.4581" ,"0.140732" ,"ABMag" ,"ZTF21aacsuwx" ,"2021-01-09 11:15:15" ,"2021-01-09 19:24:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4581", `magErr`="0.140732", `magUnit`="ABMag", `objectName`="ZTF21aacsuwx", `obsdate`="2021-01-09 11:15:15", `reportAddedDate`="2021-01-09 19:24:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"g-ZTF" ,"0" ,"19.4541" ,"0.128974" ,"ABMag" ,"ZTF21aacsuwx" ,"2021-01-09 09:39:35" ,"2021-01-09 19:24:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.4541", `magErr`="0.128974", `magUnit`="ABMag", `objectName`="ZTF21aacsuwx", `obsdate`="2021-01-09 09:39:35", `reportAddedDate`="2021-01-09 19:24:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"g-ZTF" ,"0" ,"20.1828" ,"0.329653" ,"ABMag" ,"ZTF21aacsuwx" ,"2021-01-07 11:07:14" ,"2021-01-09 19:24:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1828", `magErr`="0.329653", `magUnit`="ABMag", `objectName`="ZTF21aacsuwx", `obsdate`="2021-01-07 11:07:14", `reportAddedDate`="2021-01-09 19:24:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"r-ZTF" ,"0" ,"20.1995" ,"0.254255" ,"ABMag" ,"ZTF21aacsuwx" ,"2021-01-07 10:43:51" ,"2021-01-09 19:24:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1995", `magErr`="0.254255", `magUnit`="ABMag", `objectName`="ZTF21aacsuwx", `obsdate`="2021-01-07 10:43:51", `reportAddedDate`="2021-01-09 19:24:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021us" ,"30" ,"r-ZTF" ,"1" ,"19.7931" ,null ,"ABMag" ,"ZTF21aacsuwx" ,"2021-01-03 11:24:53" ,"2021-01-09 19:24:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021us", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7931", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aacsuwx", `obsdate`="2021-01-03 11:24:53", `reportAddedDate`="2021-01-09 19:24:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021tz" ,"60" ,"G-Gaia" ,"0" ,"18.25" ,"0.2" ,"ABMag" ,"Gaia21akn" ,"2021-01-22 19:50:53" ,"2021-01-24 10:43:39" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021tz", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.25", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akn", `obsdate`="2021-01-22 19:50:53", `reportAddedDate`="2021-01-24 10:43:39", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021tz" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akn" ,"2020-12-17 22:06:14" ,"2021-01-24 10:43:39" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021tz", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akn", `obsdate`="2020-12-17 22:06:14", `reportAddedDate`="2021-01-24 10:43:39", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021tz" ,"30" ,"cyan-ATLAS" ,"0" ,"18.228" ,"0.11" ,"ABMag" ,"ATLAS21btd" ,"2021-01-14 05:03:50" ,"2021-01-14 16:45:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021tz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.228", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ATLAS21btd", `obsdate`="2021-01-14 05:03:50", `reportAddedDate`="2021-01-14 16:45:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021tz" ,"30" ,"cyan-ATLAS" ,"1" ,"19.55" ,null ,"ABMag" ,"ATLAS21btd" ,"2021-01-04 05:54:14" ,"2021-01-14 16:45:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021tz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.55", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21btd", `obsdate`="2021-01-04 05:54:14", `reportAddedDate`="2021-01-14 16:45:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021tz" ,"30" ,"g-ZTF" ,"0" ,"19.3053" ,"0.136341" ,"ABMag" ,"ZTF21aacndur" ,"2021-01-09 03:22:18" ,"2021-01-09 19:24:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021tz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3053", `magErr`="0.136341", `magUnit`="ABMag", `objectName`="ZTF21aacndur", `obsdate`="2021-01-09 03:22:18", `reportAddedDate`="2021-01-09 19:24:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021tz" ,"30" ,"r-ZTF" ,"0" ,"19.4773" ,"0.157706" ,"ABMag" ,"ZTF21aacndur" ,"2021-01-09 02:52:36" ,"2021-01-09 19:24:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021tz", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.4773", `magErr`="0.157706", `magUnit`="ABMag", `objectName`="ZTF21aacndur", `obsdate`="2021-01-09 02:52:36", `reportAddedDate`="2021-01-09 19:24:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021tz" ,"30" ,"g-ZTF" ,"1" ,"19.7802" ,null ,"ABMag" ,"ZTF21aacndur" ,"2021-01-07 03:18:57" ,"2021-01-09 19:24:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021tz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7802", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aacndur", `obsdate`="2021-01-07 03:18:57", `reportAddedDate`="2021-01-09 19:24:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021sl" ,"45" ,"w-PS1" ,"0" ,"19.45" ,"0.1" ,"ABMag" ,"PS21nh" ,"2021-01-11 12:07:12" ,"2021-01-22 11:39:22" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021sl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.45", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21nh", `obsdate`="2021-01-11 12:07:12", `reportAddedDate`="2021-01-22 11:39:22", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021sl" ,"30" ,"orange-ATLAS" ,"0" ,"19.443" ,"0.19" ,"ABMag" ,"ATLAS21azo" ,"2021-01-08 12:56:10" ,"2021-01-08 22:22:56" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021sl", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="19.443", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ATLAS21azo", `obsdate`="2021-01-08 12:56:10", `reportAddedDate`="2021-01-08 22:22:56", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021sl" ,"30" ,"orange-ATLAS" ,"1" ,"19.62" ,null ,"ABMag" ,"ATLAS21azo" ,"2021-01-07 12:41:46" ,"2021-01-08 22:22:56" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021sl", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.62", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21azo", `obsdate`="2021-01-07 12:41:46", `reportAddedDate`="2021-01-08 22:22:56", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021sl" ,"30" ,"g-ZTF" ,"0" ,"19.3413" ,"0.100708" ,"ABMag" ,"ZTF21aachbpq" ,"2021-01-08 09:03:20" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021sl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3413", `magErr`="0.100708", `magUnit`="ABMag", `objectName`="ZTF21aachbpq", `obsdate`="2021-01-08 09:03:20", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021sl" ,"30" ,"r-ZTF" ,"0" ,"19.6895" ,"0.139196" ,"ABMag" ,"ZTF21aachbpq" ,"2021-01-08 08:30:26" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021sl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.6895", `magErr`="0.139196", `magUnit`="ABMag", `objectName`="ZTF21aachbpq", `obsdate`="2021-01-08 08:30:26", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021sl" ,"30" ,"g-ZTF" ,"1" ,"19.2164" ,null ,"ABMag" ,"ZTF21aachbpq" ,"2021-01-06 10:34:43" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021sl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.2164", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aachbpq", `obsdate`="2021-01-06 10:34:43", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021rz" ,"45" ,"w-PS1" ,"0" ,"20.22" ,"0.11" ,"ABMag" ,"PS21ow" ,"2021-01-16 09:02:53" ,"2021-01-25 10:32:36" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021rz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.22", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS21ow", `obsdate`="2021-01-16 09:02:53", `reportAddedDate`="2021-01-25 10:32:36", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021rz" ,"30" ,"g-ZTF" ,"0" ,"20.6902" ,"0.193327" ,"ABMag" ,"ZTF21aacizpp" ,"2021-01-08 09:57:25" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021rz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.6902", `magErr`="0.193327", `magUnit`="ABMag", `objectName`="ZTF21aacizpp", `obsdate`="2021-01-08 09:57:25", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021rz" ,"30" ,"g-ZTF" ,"0" ,"20.2783" ,"0.222483" ,"ABMag" ,"ZTF21aacizpp" ,"2021-01-08 09:09:26" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021rz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2783", `magErr`="0.222483", `magUnit`="ABMag", `objectName`="ZTF21aacizpp", `obsdate`="2021-01-08 09:09:26", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021rz" ,"30" ,"g-ZTF" ,"0" ,"20.1781" ,"0.273152" ,"ABMag" ,"ZTF21aacizpp" ,"2021-01-06 08:14:08" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021rz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1781", `magErr`="0.273152", `magUnit`="ABMag", `objectName`="ZTF21aacizpp", `obsdate`="2021-01-06 08:14:08", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021rz" ,"30" ,"g-ZTF" ,"1" ,"20.4518" ,null ,"ABMag" ,"ZTF21aacizpp" ,"2021-01-06 07:53:27" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021rz", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.4518", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aacizpp", `obsdate`="2021-01-06 07:53:27", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ry" ,"45" ,"w-PS1" ,"0" ,"20.52" ,"0.11" ,"ABMag" ,"PS21mz" ,"2021-01-16 09:08:38" ,"2021-01-22 11:29:03" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ry", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.52", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS21mz", `obsdate`="2021-01-16 09:08:38", `reportAddedDate`="2021-01-22 11:29:03", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ry" ,"30" ,"g-ZTF" ,"0" ,"20.1461" ,"0.170743" ,"ABMag" ,"ZTF21aablerm" ,"2021-01-08 09:09:26" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ry", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1461", `magErr`="0.170743", `magUnit`="ABMag", `objectName`="ZTF21aablerm", `obsdate`="2021-01-08 09:09:26", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ry" ,"30" ,"g-ZTF" ,"0" ,"20.2656" ,"0.24141" ,"ABMag" ,"ZTF21aablerm" ,"2021-01-06 08:14:08" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ry", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.2656", `magErr`="0.24141", `magUnit`="ABMag", `objectName`="ZTF21aablerm", `obsdate`="2021-01-06 08:14:08", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ry" ,"30" ,"r-ZTF" ,"1" ,"20.3022" ,null ,"ABMag" ,"ZTF21aablerm" ,"2021-01-06 07:08:11" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ry", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.3022", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aablerm", `obsdate`="2021-01-06 07:08:11", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021qd" ,"45" ,"w-PS1" ,"0" ,"19.94" ,"0.09" ,"ABMag" ,"PS21ni" ,"2021-01-09 09:04:19" ,"2021-01-22 11:40:10" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021qd", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.94", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS21ni", `obsdate`="2021-01-09 09:04:19", `reportAddedDate`="2021-01-22 11:40:10", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021qd" ,"30" ,"cyan-ATLAS" ,"0" ,"19.558" ,"0.147" ,"ABMag" ,"ATLAS21cjt" ,"2021-01-15 12:04:19" ,"2021-01-16 14:19:46" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021qd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.558", `magErr`="0.147", `magUnit`="ABMag", `objectName`="ATLAS21cjt", `obsdate`="2021-01-15 12:04:19", `reportAddedDate`="2021-01-16 14:19:46", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021qd" ,"30" ,"cyan-ATLAS" ,"1" ,"19.49" ,null ,"ABMag" ,"ATLAS21cjt" ,"2021-01-13 15:14:24" ,"2021-01-16 14:19:46" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021qd", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.49", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21cjt", `obsdate`="2021-01-13 15:14:24", `reportAddedDate`="2021-01-16 14:19:46", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021qd" ,"30" ,"r-ZTF" ,"0" ,"19.9633" ,"0.150152" ,"ABMag" ,"ZTF21aabvkkk" ,"2021-01-07 08:38:56" ,"2021-01-07 22:24:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021qd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.9633", `magErr`="0.150152", `magUnit`="ABMag", `objectName`="ZTF21aabvkkk", `obsdate`="2021-01-07 08:38:56", `reportAddedDate`="2021-01-07 22:24:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021qd" ,"30" ,"g-ZTF" ,"0" ,"20.1339" ,"0.19225" ,"ABMag" ,"ZTF21aabvkkk" ,"2021-01-07 08:08:10" ,"2021-01-07 22:24:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021qd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1339", `magErr`="0.19225", `magUnit`="ABMag", `objectName`="ZTF21aabvkkk", `obsdate`="2021-01-07 08:08:10", `reportAddedDate`="2021-01-07 22:24:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021qd" ,"30" ,"r-ZTF" ,"0" ,"20.3475" ,"0.309821" ,"ABMag" ,"ZTF21aabvkkk" ,"2021-01-05 08:05:39" ,"2021-01-07 22:24:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021qd", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.3475", `magErr`="0.309821", `magUnit`="ABMag", `objectName`="ZTF21aabvkkk", `obsdate`="2021-01-05 08:05:39", `reportAddedDate`="2021-01-07 22:24:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021qd" ,"30" ,"g-ZTF" ,"1" ,"19.7885" ,null ,"ABMag" ,"ZTF21aabvkkk" ,"2021-01-03 10:10:15" ,"2021-01-07 22:24:13" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021qd", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.7885", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aabvkkk", `obsdate`="2021-01-03 10:10:15", `reportAddedDate`="2021-01-07 22:24:13", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ov" ,"120" ,"z-Sloan" ,"0" ,"19.65" ,"0.12" ,"ABMag" ,"PS21ci" ,"2021-01-03 16:01:55" ,"2021-01-22 11:34:17" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ov", `exptime`="120", `filter`="z-Sloan", `limitingMag`="0", `mag`="19.65", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS21ci", `obsdate`="2021-01-03 16:01:55", `reportAddedDate`="2021-01-22 11:34:17", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ov" ,"120" ,"z-Sloan" ,"0" ,"19.62" ,"0.16" ,"ABMag" ,"PS21ci" ,"2021-01-04 15:46:05" ,"2021-01-07 14:28:12" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ov", `exptime`="120", `filter`="z-Sloan", `limitingMag`="0", `mag`="19.62", `magErr`="0.16", `magUnit`="ABMag", `objectName`="PS21ci", `obsdate`="2021-01-04 15:46:05", `reportAddedDate`="2021-01-07 14:28:12", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ne" ,"45" ,"w-PS1" ,"0" ,"19.5" ,"0.04" ,"ABMag" ,"PS21pa" ,"2021-01-15 07:13:26" ,"2021-01-25 10:37:29" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ne", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.5", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS21pa", `obsdate`="2021-01-15 07:13:26", `reportAddedDate`="2021-01-25 10:37:29", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ne" ,"30" ,"r-ZTF" ,"0" ,"19.31" ,null ,"ABMag" ,"ZTF21aaaelsm" ,"2021-01-08 05:06:43" ,"2021-01-09 01:59:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ne", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.31", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaelsm", `obsdate`="2021-01-08 05:06:43", `reportAddedDate`="2021-01-09 01:59:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ne" ,"30" ,"r-ZTF" ,"0" ,"19.51" ,null ,"ABMag" ,"ZTF21aaaelsm" ,"2021-01-02 05:36:58" ,"2021-01-09 01:59:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ne", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.51", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaelsm", `obsdate`="2021-01-02 05:36:58", `reportAddedDate`="2021-01-09 01:59:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ne" ,"30" ,"r-ZTF" ,"1" ,"19.25" ,null ,"ABMag" ,"ZTF21aaaelsm" ,"2020-12-27 07:17:46" ,"2021-01-09 01:59:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ne", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.25", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaelsm", `obsdate`="2020-12-27 07:17:46", `reportAddedDate`="2021-01-09 01:59:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ne" ,"30" ,"cyan-ATLAS" ,"0" ,"19.224" ,"0.127" ,"ABMag" ,"ATLAS21amu" ,"2021-01-05 07:52:19" ,"2021-01-07 02:10:13" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ne", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.224", `magErr`="0.127", `magUnit`="ABMag", `objectName`="ATLAS21amu", `obsdate`="2021-01-05 07:52:19", `reportAddedDate`="2021-01-07 02:10:13", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ne" ,"30" ,"orange-ATLAS" ,"1" ,"19.2" ,null ,"ABMag" ,"ATLAS21amu" ,"2021-01-04 09:27:22" ,"2021-01-07 02:10:13" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ne", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.2", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21amu", `obsdate`="2021-01-04 09:27:22", `reportAddedDate`="2021-01-07 02:10:13", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021jv" ,"45" ,"i-Sloan" ,"0" ,"20.57" ,"0.23" ,"ABMag" ,"PS21af" ,"2020-12-22 08:29:46" ,"2021-01-25 10:49:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021jv", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="20.57", `magErr`="0.23", `magUnit`="ABMag", `objectName`="PS21af", `obsdate`="2020-12-22 08:29:46", `reportAddedDate`="2021-01-25 10:49:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021jv" ,"27" ,"i-Sloan" ,"0" ,"21.17" ,"0.23" ,"ABMag" ,"PS21af" ,"2021-01-03 07:49:26" ,"2021-01-06 17:17:20" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021jv", `exptime`="27", `filter`="i-Sloan", `limitingMag`="0", `mag`="21.17", `magErr`="0.23", `magUnit`="ABMag", `objectName`="PS21af", `obsdate`="2021-01-03 07:49:26", `reportAddedDate`="2021-01-06 17:17:20", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,"60" ,"G-Gaia" ,"0" ,"17.93" ,"0.2" ,"ABMag" ,"Gaia21ajs" ,"2021-01-20 13:36:29" ,"2021-01-22 08:59:24" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.93", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajs", `obsdate`="2021-01-20 13:36:29", `reportAddedDate`="2021-01-22 08:59:24", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajs" ,"2020-12-16 09:54:43" ,"2021-01-22 08:59:24" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajs", `obsdate`="2020-12-16 09:54:43", `reportAddedDate`="2021-01-22 08:59:24", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,"30" ,"g-ZTF" ,"0" ,"19.6578" ,"0.123122" ,"ABMag" ,"ZTF21aaazjia" ,"2021-01-05 02:44:26" ,"2021-01-17 20:17:11" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6578", `magErr`="0.123122", `magUnit`="ABMag", `objectName`="ZTF21aaazjia", `obsdate`="2021-01-05 02:44:26", `reportAddedDate`="2021-01-17 20:17:11", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,"30" ,"g-ZTF" ,"1" ,"20.0608" ,null ,"ABMag" ,"ZTF21aaazjia" ,"2021-01-01 02:18:29" ,"2021-01-17 20:17:11" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0608", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaazjia", `obsdate`="2021-01-01 02:18:29", `reportAddedDate`="2021-01-17 20:17:11", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,"30" ,"cyan-ATLAS" ,"0" ,"18.032" ,"0.068" ,"ABMag" ,"ATLAS21bod" ,"2021-01-13 05:26:53" ,"2021-01-13 17:10:27" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.032", `magErr`="0.068", `magUnit`="ABMag", `objectName`="ATLAS21bod", `obsdate`="2021-01-13 05:26:53", `reportAddedDate`="2021-01-13 17:10:27", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,"30" ,"cyan-ATLAS" ,"1" ,"19.51" ,null ,"ABMag" ,"ATLAS21bod" ,"2021-01-05 06:24:29" ,"2021-01-13 17:10:27" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.51", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21bod", `obsdate`="2021-01-05 06:24:29", `reportAddedDate`="2021-01-13 17:10:27", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,"30" ,"r-ZTF" ,"0" ,"19.7407" ,"0.16417" ,"ABMag" ,"ZTF21aaazjia" ,"2021-01-05 03:15:57" ,"2021-01-05 20:13:17" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.7407", `magErr`="0.16417", `magUnit`="ABMag", `objectName`="ZTF21aaazjia", `obsdate`="2021-01-05 03:15:57", `reportAddedDate`="2021-01-05 20:13:17", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,"30" ,"g-ZTF" ,"0" ,"19.6578" ,"0.123122" ,"ABMag" ,"ZTF21aaazjia" ,"2021-01-05 02:44:26" ,"2021-01-05 20:13:17" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6578", `magErr`="0.123122", `magUnit`="ABMag", `objectName`="ZTF21aaazjia", `obsdate`="2021-01-05 02:44:26", `reportAddedDate`="2021-01-05 20:13:17", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ik" ,"30" ,"r-ZTF" ,"1" ,"19.4787" ,null ,"ABMag" ,"ZTF21aaazjia" ,"2021-01-01 02:58:20" ,"2021-01-05 20:13:17" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ik", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.4787", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaazjia", `obsdate`="2021-01-01 02:58:20", `reportAddedDate`="2021-01-05 20:13:17", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,"60" ,"G-Gaia" ,"0" ,"18.43" ,"0.2" ,"ABMag" ,"Gaia21ajq" ,"2021-01-20 22:26:24" ,"2021-01-22 08:58:40" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.43", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajq", `obsdate`="2021-01-20 22:26:24", `reportAddedDate`="2021-01-22 08:58:40", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajq" ,"2020-12-12 06:41:46" ,"2021-01-22 08:58:40" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajq", `obsdate`="2020-12-12 06:41:46", `reportAddedDate`="2021-01-22 08:58:40", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,"30" ,"r-ZTF" ,"0" ,"18.7318" ,"0.203732" ,"ABMag" ,"ZTF21aaagzee" ,"2021-01-02 09:43:33" ,"2021-01-12 20:19:24" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.7318", `magErr`="0.203732", `magUnit`="ABMag", `objectName`="ZTF21aaagzee", `obsdate`="2021-01-02 09:43:33", `reportAddedDate`="2021-01-12 20:19:24", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,"30" ,"r-ZTF" ,"1" ,"18.6913" ,null ,"ABMag" ,"ZTF21aaagzee" ,"2020-12-27 10:10:07" ,"2021-01-12 20:19:24" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.6913", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaagzee", `obsdate`="2020-12-27 10:10:07", `reportAddedDate`="2021-01-12 20:19:24", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,"30" ,"orange-ATLAS" ,"0" ,"18.397" ,"0.114" ,"ABMag" ,"ATLAS21ahk" ,"2021-01-06 12:46:05" ,"2021-01-06 21:00:01" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.397", `magErr`="0.114", `magUnit`="ABMag", `objectName`="ATLAS21ahk", `obsdate`="2021-01-06 12:46:05", `reportAddedDate`="2021-01-06 21:00:01", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,"30" ,"orange-ATLAS" ,"1" ,"18.73" ,null ,"ABMag" ,"ATLAS21ahk" ,"2021-01-02 13:39:22" ,"2021-01-06 21:00:01" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.73", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21ahk", `obsdate`="2021-01-02 13:39:22", `reportAddedDate`="2021-01-06 21:00:01", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,"30" ,"g-ZTF" ,"0" ,"18.35" ,null ,"ABMag" ,"ZTF21aaagzee" ,"2021-01-05 10:03:22" ,"2021-01-05 20:01:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.35", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaagzee", `obsdate`="2021-01-05 10:03:22", `reportAddedDate`="2021-01-05 20:01:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,"30" ,"r-ZTF" ,"0" ,"18.73" ,null ,"ABMag" ,"ZTF21aaagzee" ,"2021-01-02 09:43:12" ,"2021-01-05 20:01:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.73", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaagzee", `obsdate`="2021-01-02 09:43:12", `reportAddedDate`="2021-01-05 20:01:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021gl" ,"30" ,"r-ZTF" ,"1" ,"18.69" ,null ,"ABMag" ,"ZTF21aaagzee" ,"2020-12-27 10:10:34" ,"2021-01-05 20:01:57" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021gl", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.69", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaagzee", `obsdate`="2020-12-27 10:10:34", `reportAddedDate`="2021-01-05 20:01:57", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ff" ,"45" ,"w-PS1" ,"0" ,"20.4" ,"0.1" ,"ABMag" ,"PS21pv" ,"2021-01-15 09:34:34" ,"2021-01-25 11:57:33" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ff", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.4", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS21pv", `obsdate`="2021-01-15 09:34:34", `reportAddedDate`="2021-01-25 11:57:33", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ff" ,"30" ,"g-ZTF" ,"0" ,"20.4224" ,"0.201932" ,"ABMag" ,"ZTF21aaaszmu" ,"2021-01-04 06:23:29" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ff", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.4224", `magErr`="0.201932", `magUnit`="ABMag", `objectName`="ZTF21aaaszmu", `obsdate`="2021-01-04 06:23:29", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ff" ,"30" ,"g-ZTF" ,"1" ,"19.4654" ,null ,"ABMag" ,"ZTF21aaaszmu" ,"2021-01-02 10:13:15" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ff", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.4654", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaszmu", `obsdate`="2021-01-02 10:13:15", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"45" ,"w-PS1" ,"0" ,"19.28" ,"0.05" ,"ABMag" ,"PS21na" ,"2021-01-16 05:49:55" ,"2021-01-22 11:31:33" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.28", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21na", `obsdate`="2021-01-16 05:49:55", `reportAddedDate`="2021-01-22 11:31:33", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"30" ,"r-ZTF" ,"0" ,"20.4039" ,"0.262176" ,"ABMag" ,"ZTF21aaaseqt" ,"2021-01-02 05:42:28" ,"2021-01-12 20:19:24" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4039", `magErr`="0.262176", `magUnit`="ABMag", `objectName`="ZTF21aaaseqt", `obsdate`="2021-01-02 05:42:28", `reportAddedDate`="2021-01-12 20:19:24", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"30" ,"r-ZTF" ,"1" ,"19.7074" ,null ,"ABMag" ,"ZTF21aaaseqt" ,"2020-12-27 07:14:36" ,"2021-01-12 20:19:24" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7074", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaseqt", `obsdate`="2020-12-27 07:14:36", `reportAddedDate`="2021-01-12 20:19:24", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"30" ,"cyan-ATLAS" ,"0" ,"19.625" ,"0.176" ,"ABMag" ,"ATLAS21bgp" ,"2021-01-12 07:33:36" ,"2021-01-12 14:39:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.625", `magErr`="0.176", `magUnit`="ABMag", `objectName`="ATLAS21bgp", `obsdate`="2021-01-12 07:33:36", `reportAddedDate`="2021-01-12 14:39:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"30" ,"cyan-ATLAS" ,"1" ,"19.84" ,null ,"ABMag" ,"ATLAS21bgp" ,"2021-01-08 07:22:05" ,"2021-01-12 14:39:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.84", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21bgp", `obsdate`="2021-01-08 07:22:05", `reportAddedDate`="2021-01-12 14:39:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"30" ,"g-ZTF" ,"0" ,"20.4614" ,"0.185913" ,"ABMag" ,"ZTF21aaaseqt" ,"2021-01-04 05:25:37" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.4614", `magErr`="0.185913", `magUnit`="ABMag", `objectName`="ZTF21aaaseqt", `obsdate`="2021-01-04 05:25:37", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"30" ,"r-ZTF" ,"0" ,"20.1376" ,"0.225845" ,"ABMag" ,"ZTF21aaaseqt" ,"2021-01-04 04:27:53" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1376", `magErr`="0.225845", `magUnit`="ABMag", `objectName`="ZTF21aaaseqt", `obsdate`="2021-01-04 04:27:53", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"30" ,"r-ZTF" ,"0" ,"20.4039" ,"0.262176" ,"ABMag" ,"ZTF21aaaseqt" ,"2021-01-02 05:42:28" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.4039", `magErr`="0.262176", `magUnit`="ABMag", `objectName`="ZTF21aaaseqt", `obsdate`="2021-01-02 05:42:28", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021eq" ,"30" ,"r-ZTF" ,"1" ,"19.7074" ,null ,"ABMag" ,"ZTF21aaaseqt" ,"2020-12-27 07:14:36" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021eq", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.7074", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaseqt", `obsdate`="2020-12-27 07:14:36", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021em" ,"45" ,"w-PS1" ,"0" ,"20.13" ,"0.06" ,"ABMag" ,"PS21px" ,"2021-01-15 07:17:46" ,"2021-01-25 11:58:53" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021em", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.13", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS21px", `obsdate`="2021-01-15 07:17:46", `reportAddedDate`="2021-01-25 11:58:53", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021em" ,"30" ,"g-ZTF" ,"0" ,"20.1571" ,"0.180215" ,"ABMag" ,"ZTF21aaarnna" ,"2021-01-04 05:36:39" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021em", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.1571", `magErr`="0.180215", `magUnit`="ABMag", `objectName`="ZTF21aaarnna", `obsdate`="2021-01-04 05:36:39", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021em" ,"30" ,"r-ZTF" ,"0" ,"19.8762" ,"0.193414" ,"ABMag" ,"ZTF21aaarnna" ,"2021-01-04 04:11:47" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021em", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.8762", `magErr`="0.193414", `magUnit`="ABMag", `objectName`="ZTF21aaarnna", `obsdate`="2021-01-04 04:11:47", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021em" ,"30" ,"r-ZTF" ,"0" ,"20.1803" ,"0.332423" ,"ABMag" ,"ZTF21aaarnna" ,"2021-01-02 05:36:18" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021em", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.1803", `magErr`="0.332423", `magUnit`="ABMag", `objectName`="ZTF21aaarnna", `obsdate`="2021-01-02 05:36:18", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021em" ,"30" ,"g-ZTF" ,"1" ,"19.2124" ,null ,"ABMag" ,"ZTF21aaarnna" ,"2020-12-28 05:06:20" ,"2021-01-04 21:44:30" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021em", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.2124", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaarnna", `obsdate`="2020-12-28 05:06:20", `reportAddedDate`="2021-01-04 21:44:30", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021dc" ,"60" ,"G-Gaia" ,"0" ,"18.57" ,"0.2" ,"ABMag" ,"Gaia21ald" ,"2021-01-02 23:05:17" ,"2021-01-25 09:13:58" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021dc", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.57", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ald", `obsdate`="2021-01-02 23:05:17", `reportAddedDate`="2021-01-25 09:13:58", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021dc" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ald" ,"2020-11-30 03:54:43" ,"2021-01-25 09:13:58" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021dc", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ald", `obsdate`="2020-11-30 03:54:43", `reportAddedDate`="2021-01-25 09:13:58", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021dc" ,"30" ,"g-ZTF" ,"0" ,"18.8337" ,"0.13044" ,"ABMag" ,"ZTF21aaaollj" ,"2021-01-03 10:44:26" ,"2021-01-03 20:12:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021dc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.8337", `magErr`="0.13044", `magUnit`="ABMag", `objectName`="ZTF21aaaollj", `obsdate`="2021-01-03 10:44:26", `reportAddedDate`="2021-01-03 20:12:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021dc" ,"30" ,"r-ZTF" ,"1" ,"19.6897" ,null ,"ABMag" ,"ZTF21aaaollj" ,"2021-01-03 09:21:05" ,"2021-01-03 20:12:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021dc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.6897", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaollj", `obsdate`="2021-01-03 09:21:05", `reportAddedDate`="2021-01-03 20:12:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bv" ,"45" ,"i-Sloan" ,"0" ,"19.43" ,"0.2" ,"ABMag" ,"PS21ne" ,"2021-01-02 12:37:26" ,"2021-01-22 11:35:10" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bv", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.43", `magErr`="0.2", `magUnit`="ABMag", `objectName`="PS21ne", `obsdate`="2021-01-02 12:37:26", `reportAddedDate`="2021-01-22 11:35:10", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bv" ,"30" ,"cyan-ATLAS" ,"0" ,"19.059" ,"0.119" ,"ABMag" ,"ATLAS21azi" ,"2021-01-08 10:30:43" ,"2021-01-08 22:17:32" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bv", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.059", `magErr`="0.119", `magUnit`="ABMag", `objectName`="ATLAS21azi", `obsdate`="2021-01-08 10:30:43", `reportAddedDate`="2021-01-08 22:17:32", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bv" ,"30" ,"orange-ATLAS" ,"1" ,"19.33" ,null ,"ABMag" ,"ATLAS21azi" ,"2021-01-06 13:04:48" ,"2021-01-08 22:17:32" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bv", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.33", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21azi", `obsdate`="2021-01-06 13:04:48", `reportAddedDate`="2021-01-08 22:17:32", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bv" ,"30" ,"r-ZTF" ,"0" ,"19.3135" ,"0.136412" ,"ABMag" ,"ZTF21aaahhso" ,"2021-01-03 08:18:34" ,"2021-01-03 20:12:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.3135", `magErr`="0.136412", `magUnit`="ABMag", `objectName`="ZTF21aaahhso", `obsdate`="2021-01-03 08:18:34", `reportAddedDate`="2021-01-03 20:12:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bv" ,"30" ,"g-ZTF" ,"0" ,"19.2769" ,"0.160696" ,"ABMag" ,"ZTF21aaahhso" ,"2021-01-03 06:22:59" ,"2021-01-03 20:12:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.2769", `magErr`="0.160696", `magUnit`="ABMag", `objectName`="ZTF21aaahhso", `obsdate`="2021-01-03 06:22:59", `reportAddedDate`="2021-01-03 20:12:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bv" ,"30" ,"g-ZTF" ,"0" ,"19.3326" ,"0.326802" ,"ABMag" ,"ZTF21aaahhso" ,"2021-01-01 10:15:18" ,"2021-01-03 20:12:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.3326", `magErr`="0.326802", `magUnit`="ABMag", `objectName`="ZTF21aaahhso", `obsdate`="2021-01-01 10:15:18", `reportAddedDate`="2021-01-03 20:12:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bv" ,"30" ,"r-ZTF" ,"1" ,"18.5308" ,null ,"ABMag" ,"ZTF21aaahhso" ,"2021-01-01 09:39:00" ,"2021-01-03 20:12:24" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.5308", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaahhso", `obsdate`="2021-01-01 09:39:00", `reportAddedDate`="2021-01-03 20:12:24", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bg" ,"45" ,"w-PS1" ,"0" ,"20.82" ,"0.14" ,"ABMag" ,"PS21h" ,"2021-01-12 05:18:14" ,"2021-01-25 12:03:34" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bg", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.82", `magErr`="0.14", `magUnit`="ABMag", `objectName`="PS21h", `obsdate`="2021-01-12 05:18:14", `reportAddedDate`="2021-01-25 12:03:34", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021bg" ,"27" ,"z-Sloan" ,"0" ,"21.11" ,"0.26" ,"ABMag" ,"PS21h" ,"2021-01-03 05:12:29" ,"2021-01-03 15:27:50" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021bg", `exptime`="27", `filter`="z-Sloan", `limitingMag`="0", `mag`="21.11", `magErr`="0.26", `magUnit`="ABMag", `objectName`="PS21h", `obsdate`="2021-01-03 05:12:29", `reportAddedDate`="2021-01-03 15:27:50", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,"60" ,"G-Gaia" ,"0" ,"18.78" ,"0.2" ,"ABMag" ,"Gaia21akd" ,"2021-01-22 10:48:00" ,"2021-01-23 13:02:59" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.78", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akd", `obsdate`="2021-01-22 10:48:00", `reportAddedDate`="2021-01-23 13:02:59", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akd" ,"2020-12-15 23:12:29" ,"2021-01-23 13:02:59" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akd", `obsdate`="2020-12-15 23:12:29", `reportAddedDate`="2021-01-23 13:02:59", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,"45" ,"i-Sloan" ,"0" ,"18.84" ,"0.05" ,"ABMag" ,"PS21ex" ,"2021-01-03 13:42:14" ,"2021-01-11 02:49:08" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="18.84", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21ex", `obsdate`="2021-01-03 13:42:14", `reportAddedDate`="2021-01-11 02:49:08", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,"30" ,"orange-ATLAS" ,"0" ,"18.445" ,"0.132" ,"ABMag" ,"ATLAS21akd" ,"2021-01-05 12:46:05" ,"2021-01-07 00:24:13" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.445", `magErr`="0.132", `magUnit`="ABMag", `objectName`="ATLAS21akd", `obsdate`="2021-01-05 12:46:05", `reportAddedDate`="2021-01-07 00:24:13", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,"30" ,"orange-ATLAS" ,"1" ,"18.93" ,null ,"ABMag" ,"ATLAS21akd" ,"2021-01-03 13:22:05" ,"2021-01-07 00:24:13" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.93", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21akd", `obsdate`="2021-01-03 13:22:05", `reportAddedDate`="2021-01-07 00:24:13", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,"30" ,"r-ZTF" ,"0" ,"18.6056" ,"0.130692" ,"ABMag" ,"ZTF21aaabuoj" ,"2021-01-02 12:29:51" ,"2021-01-02 18:34:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.6056", `magErr`="0.130692", `magUnit`="ABMag", `objectName`="ZTF21aaabuoj", `obsdate`="2021-01-02 12:29:51", `reportAddedDate`="2021-01-02 18:34:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,"30" ,"g-ZTF" ,"0" ,"18.5213" ,"0.144498" ,"ABMag" ,"ZTF21aaabuoj" ,"2021-01-02 10:33:31" ,"2021-01-02 18:34:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.5213", `magErr`="0.144498", `magUnit`="ABMag", `objectName`="ZTF21aaabuoj", `obsdate`="2021-01-02 10:33:31", `reportAddedDate`="2021-01-02 18:34:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,"30" ,"g-ZTF" ,"0" ,"18.7325" ,"0.193327" ,"ABMag" ,"ZTF21aaabuoj" ,"2021-01-01 11:33:32" ,"2021-01-02 18:34:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.7325", `magErr`="0.193327", `magUnit`="ABMag", `objectName`="ZTF21aaabuoj", `obsdate`="2021-01-01 11:33:32", `reportAddedDate`="2021-01-02 18:34:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021ab" ,"30" ,"r-ZTF" ,"1" ,"20.0535" ,null ,"ABMag" ,"ZTF21aaabuoj" ,"2020-12-21 12:04:03" ,"2021-01-02 18:34:12" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021ab", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.0535", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaabuoj", `obsdate`="2020-12-21 12:04:03", `reportAddedDate`="2021-01-02 18:34:12", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"45" ,"i-Sloan" ,"0" ,"18.66" ,"0.12" ,"ABMag" ,"PS21pc" ,"2021-01-24 13:32:10" ,"2021-01-25 10:39:07" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="18.66", `magErr`="0.12", `magUnit`="ABMag", `objectName`="PS21pc", `obsdate`="2021-01-24 13:32:10", `reportAddedDate`="2021-01-25 10:39:07", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"60" ,"G-Gaia" ,"0" ,"18.22" ,"0.2" ,"ABMag" ,"Gaia21adl" ,"2021-01-08 15:27:22" ,"2021-01-10 18:29:10" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.22", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21adl", `obsdate`="2021-01-08 15:27:22", `reportAddedDate`="2021-01-10 18:29:10", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21adl" ,"2020-12-02 10:16:19" ,"2021-01-10 18:29:10" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21adl", `obsdate`="2020-12-02 10:16:19", `reportAddedDate`="2021-01-10 18:29:10", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"30" ,"g-ZTF" ,"0" ,"19.1914" ,"0.260618" ,"ABMag" ,"ZTF21aaabtyq" ,"2021-01-01 10:28:53" ,"2021-01-07 20:19:35" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.1914", `magErr`="0.260618", `magUnit`="ABMag", `objectName`="ZTF21aaabtyq", `obsdate`="2021-01-01 10:28:53", `reportAddedDate`="2021-01-07 20:19:35", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"30" ,"g-ZTF" ,"1" ,"19.1045" ,null ,"ABMag" ,"ZTF21aaabtyq" ,"2020-12-23 09:54:38" ,"2021-01-07 20:19:35" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.1045", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaabtyq", `obsdate`="2020-12-23 09:54:38", `reportAddedDate`="2021-01-07 20:19:35", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"30" ,"orange-ATLAS" ,"0" ,"18.761" ,"0.133" ,"ABMag" ,"ATLAS21aar" ,"2021-01-04 14:08:10" ,"2021-01-05 03:13:45" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.761", `magErr`="0.133", `magUnit`="ABMag", `objectName`="ATLAS21aar", `obsdate`="2021-01-04 14:08:10", `reportAddedDate`="2021-01-05 03:13:45", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"30" ,"orange-ATLAS" ,"1" ,"18.41" ,null ,"ABMag" ,"ATLAS21aar" ,"2021-01-02 12:57:36" ,"2021-01-05 03:13:45" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.41", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21aar", `obsdate`="2021-01-02 12:57:36", `reportAddedDate`="2021-01-05 03:13:45", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"30" ,"r-ZTF" ,"0" ,"18.9378" ,"0.154732" ,"ABMag" ,"ZTF21aaabtyq" ,"2021-01-01 11:14:58" ,"2021-01-01 16:43:48" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.9378", `magErr`="0.154732", `magUnit`="ABMag", `objectName`="ZTF21aaabtyq", `obsdate`="2021-01-01 11:14:58", `reportAddedDate`="2021-01-01 16:43:48", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"30" ,"g-ZTF" ,"0" ,"19.1914" ,"0.260618" ,"ABMag" ,"ZTF21aaabtyq" ,"2021-01-01 10:28:53" ,"2021-01-01 16:43:48" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.1914", `magErr`="0.260618", `magUnit`="ABMag", `objectName`="ZTF21aaabtyq", `obsdate`="2021-01-01 10:28:53", `reportAddedDate`="2021-01-01 16:43:48", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2021G" ,"30" ,"r-ZTF" ,"1" ,"18.1893" ,null ,"ABMag" ,"ZTF21aaabtyq" ,"2020-12-23 11:42:07" ,"2021-01-01 16:43:48" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2021G", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="18.1893", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaabtyq", `obsdate`="2020-12-23 11:42:07", `reportAddedDate`="2021-01-01 16:43:48", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aewd" ,"45" ,"w-PS1" ,"0" ,"21.5" ,"0.23" ,"ABMag" ,"PS21py" ,"2020-12-12 11:42:43" ,"2021-01-25 12:00:52" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aewd", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.5", `magErr`="0.23", `magUnit`="ABMag", `objectName`="PS21py", `obsdate`="2020-12-12 11:42:43", `reportAddedDate`="2021-01-25 12:00:52", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aewc" ,"60" ,"G-Gaia" ,"0" ,"17.27" ,"0.2" ,"ABMag" ,"Gaia21alb" ,"2020-12-20 20:35:31" ,"2021-01-25 06:35:38" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aewc", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="17.27", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21alb", `obsdate`="2020-12-20 20:35:31", `reportAddedDate`="2021-01-25 06:35:38", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aewc" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21alb" ,"2020-09-15 16:33:35" ,"2021-01-25 06:35:38" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aewc", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21alb", `obsdate`="2020-09-15 16:33:35", `reportAddedDate`="2021-01-25 06:35:38", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aewb" ,"45" ,"w-PS1" ,"0" ,"21.94" ,"0.24" ,"ABMag" ,"PS21ok" ,"2020-12-17 10:13:26" ,"2021-01-23 17:12:19" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aewb", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.94", `magErr`="0.24", `magUnit`="ABMag", `objectName`="PS21ok", `obsdate`="2020-12-17 10:13:26", `reportAddedDate`="2021-01-23 17:12:19", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuv" ,null ,"r-ZTF" ,"0" ,"19.69" ,"0.17" ,"ABMag" ,"ZTF20aczgmai" ,"2020-12-21 12:11:31" ,"2021-01-25 09:41:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `exptime`=null, `filter`="r-ZTF", `limitingMag`="0", `mag`="19.69", `magErr`="0.17", `magUnit`="ABMag", `objectName`="ZTF20aczgmai", `obsdate`="2020-12-21 12:11:31", `reportAddedDate`="2021-01-25 09:41:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuv" ,null ,"g-ZTF" ,"1" ,"20.27" ,null ,"ABMag" ,"ZTF20aczgmai" ,"2020-12-21 11:18:14" ,"2021-01-25 09:41:44" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `exptime`=null, `filter`="g-ZTF", `limitingMag`="1", `mag`="20.27", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczgmai", `obsdate`="2020-12-21 11:18:14", `reportAddedDate`="2021-01-25 09:41:44", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuv" ,"45" ,"w-PS1" ,"0" ,"18.81" ,"0.01" ,"ABMag" ,"PS21jn" ,"2021-01-15 14:24:00" ,"2021-01-18 20:01:24" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="18.81", `magErr`="0.01", `magUnit`="ABMag", `objectName`="PS21jn", `obsdate`="2021-01-15 14:24:00", `reportAddedDate`="2021-01-18 20:01:24", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuv" ,"30" ,"cyan-ATLAS" ,"0" ,"18.73" ,"0.107" ,"ABMag" ,"ATLAS21cjj" ,"2021-01-15 14:02:24" ,"2021-01-16 14:13:38" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.73", `magErr`="0.107", `magUnit`="ABMag", `objectName`="ATLAS21cjj", `obsdate`="2021-01-15 14:02:24", `reportAddedDate`="2021-01-16 14:13:38", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuv" ,"30" ,"orange-ATLAS" ,"1" ,"18.27" ,null ,"ABMag" ,"ATLAS21cjj" ,"2021-01-07 16:07:41" ,"2021-01-16 14:13:38" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.27", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21cjj", `obsdate`="2021-01-07 16:07:41", `reportAddedDate`="2021-01-16 14:13:38", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuv" ,"30" ,"g-ZTF" ,"0" ,"19.12" ,null ,"ABMag" ,"ZTF20aczgmai" ,"2021-01-09 12:57:36" ,"2021-01-09 19:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.12", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczgmai", `obsdate`="2021-01-09 12:57:36", `reportAddedDate`="2021-01-09 19:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuv" ,"30" ,"r-ZTF" ,"0" ,"19.69" ,null ,"ABMag" ,"ZTF20aczgmai" ,"2020-12-21 12:11:31" ,"2021-01-09 19:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.69", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczgmai", `obsdate`="2020-12-21 12:11:31", `reportAddedDate`="2021-01-09 19:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuv" ,"30" ,"g-ZTF" ,"1" ,"20.27" ,null ,"ABMag" ,"ZTF20aczgmai" ,"2020-12-21 11:18:14" ,"2021-01-09 19:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.27", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20aczgmai", `obsdate`="2020-12-21 11:18:14", `reportAddedDate`="2021-01-09 19:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuh" ,"120" ,"z-Sloan" ,"0" ,"20.54" ,"0.2" ,"ABMag" ,"PS21pz" ,"2021-01-14 16:04:48" ,"2021-01-25 12:04:54" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuh", `exptime`="120", `filter`="z-Sloan", `limitingMag`="0", `mag`="20.54", `magErr`="0.2", `magUnit`="ABMag", `objectName`="PS21pz", `obsdate`="2021-01-14 16:04:48", `reportAddedDate`="2021-01-25 12:04:54", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuh" ,"30" ,"cyan-ATLAS" ,"0" ,"19.268" ,"0.138" ,"ABMag" ,"ATLAS20bkbb" ,"2020-12-25 14:42:43" ,"2021-01-07 00:43:11" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuh", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.268", `magErr`="0.138", `magUnit`="ABMag", `objectName`="ATLAS20bkbb", `obsdate`="2020-12-25 14:42:43", `reportAddedDate`="2021-01-07 00:43:11", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeuh" ,"30" ,"cyan-ATLAS" ,"1" ,"19.74" ,null ,"ABMag" ,"ATLAS20bkbb" ,"2020-12-23 14:38:24" ,"2021-01-07 00:43:11" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeuh", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.74", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bkbb", `obsdate`="2020-12-23 14:38:24", `reportAddedDate`="2021-01-07 00:43:11", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aetm" ,"45" ,"w-PS1" ,"0" ,"19.94" ,"0.07" ,"ABMag" ,"PS21nw" ,"2021-01-15 09:36:00" ,"2021-01-23 16:43:22" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aetm", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.94", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS21nw", `obsdate`="2021-01-15 09:36:00", `reportAddedDate`="2021-01-23 16:43:22", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aetm" ,"30" ,"g-ZTF" ,"0" ,"20.7676" ,null ,"ABMag" ,"ZTF21aaaszmm" ,"2020-12-22 07:17:29" ,"2021-01-06 19:00:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aetm", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.7676", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaszmm", `obsdate`="2020-12-22 07:17:29", `reportAddedDate`="2021-01-06 19:00:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aetm" ,"30" ,"r-ZTF" ,"1" ,"20.1117" ,null ,"ABMag" ,"ZTF21aaaszmm" ,"2020-12-20 10:23:42" ,"2021-01-06 19:00:40" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aetm", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1117", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaaszmm", `obsdate`="2020-12-20 10:23:42", `reportAddedDate`="2021-01-06 19:00:40", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeqo" ,"45" ,"i-Sloan" ,"0" ,"18.22" ,"0.08" ,"ABMag" ,"PS21mv" ,"2020-12-28 08:44:10" ,"2021-01-22 11:18:59" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeqo", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="18.22", `magErr`="0.08", `magUnit`="ABMag", `objectName`="PS21mv", `obsdate`="2020-12-28 08:44:10", `reportAddedDate`="2021-01-22 11:18:59", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeqo" ,"60" ,"G-Gaia" ,"0" ,"18" ,"0.2" ,"ABMag" ,"Gaia21abc" ,"2020-12-31 07:01:55" ,"2021-01-02 14:15:40" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeqo", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21abc", `obsdate`="2020-12-31 07:01:55", `reportAddedDate`="2021-01-02 14:15:40", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeqo" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21abc" ,"2020-12-14 14:42:43" ,"2021-01-02 14:15:40" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeqo", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21abc", `obsdate`="2020-12-14 14:42:43", `reportAddedDate`="2021-01-02 14:15:40", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeqo" ,"30" ,"orange-ATLAS" ,"0" ,"18.198" ,"0.108" ,"ABMag" ,"ATLAS20bjua" ,"2020-12-29 07:35:02" ,"2020-12-31 01:34:06" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeqo", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.198", `magErr`="0.108", `magUnit`="ABMag", `objectName`="ATLAS20bjua", `obsdate`="2020-12-29 07:35:02", `reportAddedDate`="2020-12-31 01:34:06", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aeqo" ,"30" ,"orange-ATLAS" ,"1" ,"19.29" ,null ,"ABMag" ,"ATLAS20bjua" ,"2020-12-23 06:33:07" ,"2020-12-31 01:34:06" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aeqo", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.29", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bjua", `obsdate`="2020-12-23 06:33:07", `reportAddedDate`="2020-12-31 01:34:06", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aenl" ,"45" ,"w-PS1" ,"0" ,"20.86" ,"0.15" ,"ABMag" ,"PS20ntv" ,"2021-01-16 09:17:17" ,"2021-01-23 16:35:27" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.86", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20ntv", `obsdate`="2021-01-16 09:17:17", `reportAddedDate`="2021-01-23 16:35:27", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aenl" ,"45" ,"w-PS1" ,"0" ,"20.47" ,"0.15" ,"ABMag" ,"PS20ntv" ,"2020-12-10 10:39:22" ,"2020-12-29 17:36:01" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenl", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.47", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20ntv", `obsdate`="2020-12-10 10:39:22", `reportAddedDate`="2020-12-29 17:36:01", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aenf" ,"45" ,"w-PS1" ,"0" ,"20.35" ,"0.11" ,"ABMag" ,"PS20nti" ,"2021-01-16 10:24:58" ,"2021-01-22 11:23:24" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenf", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.35", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20nti", `obsdate`="2021-01-16 10:24:58", `reportAddedDate`="2021-01-22 11:23:24", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aenf" ,"30" ,"r-ZTF" ,"0" ,"20.0738" ,"0.179458" ,"ABMag" ,"ZTF21aaciiuk" ,"2021-01-08 10:49:04" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenf", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.0738", `magErr`="0.179458", `magUnit`="ABMag", `objectName`="ZTF21aaciiuk", `obsdate`="2021-01-08 10:49:04", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aenf" ,"30" ,"g-ZTF" ,"0" ,"20.0867" ,"0.202226" ,"ABMag" ,"ZTF21aaciiuk" ,"2021-01-08 09:34:26" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenf", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.0867", `magErr`="0.202226", `magUnit`="ABMag", `objectName`="ZTF21aaciiuk", `obsdate`="2021-01-08 09:34:26", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aenf" ,"30" ,"g-ZTF" ,"1" ,"17.5857" ,null ,"ABMag" ,"ZTF21aaciiuk" ,"2021-01-06 10:42:50" ,"2021-01-08 19:18:22" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenf", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="17.5857", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF21aaciiuk", `obsdate`="2021-01-06 10:42:50", `reportAddedDate`="2021-01-08 19:18:22", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aenf" ,"45" ,"w-PS1" ,"0" ,"20.95" ,"0.11" ,"ABMag" ,"PS20nti" ,"2020-12-23 11:47:02" ,"2020-12-29 17:25:50" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aenf", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.95", `magErr`="0.11", `magUnit`="ABMag", `objectName`="PS20nti", `obsdate`="2020-12-23 11:47:02", `reportAddedDate`="2020-12-29 17:25:50", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlz" ,"45" ,"w-PS1" ,"0" ,"20.47" ,"0.07" ,"ABMag" ,"PS20mmp" ,"2021-01-12 14:03:50" ,"2021-01-25 11:59:50" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlz", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.47", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20mmp", `obsdate`="2021-01-12 14:03:50", `reportAddedDate`="2021-01-25 11:59:50", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlz" ,"30" ,"cyan-ATLAS" ,"0" ,"19.206" ,"0.14" ,"ABMag" ,"ATLAS20bjwy" ,"2020-12-25 13:09:07" ,"2020-12-31 23:38:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.206", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ATLAS20bjwy", `obsdate`="2020-12-25 13:09:07", `reportAddedDate`="2020-12-31 23:38:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlz" ,"30" ,"cyan-ATLAS" ,"1" ,"19.74" ,null ,"ABMag" ,"ATLAS20bjwy" ,"2020-12-23 12:59:02" ,"2020-12-31 23:38:23" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlz", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.74", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bjwy", `obsdate`="2020-12-23 12:59:02", `reportAddedDate`="2020-12-31 23:38:23", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlz" ,"27" ,"i-Sloan" ,"0" ,"19.68" ,"0.1" ,"ABMag" ,"PS20mmp" ,"2020-12-10 15:11:31" ,"2020-12-22 23:03:29" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlz", `exptime`="27", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.68", `magErr`="0.1", `magUnit`="ABMag", `objectName`="PS20mmp", `obsdate`="2020-12-10 15:11:31", `reportAddedDate`="2020-12-22 23:03:29", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"27" ,"g-Sloan" ,"0" ,"18.37" ,"0.03" ,"ABMag" ,"PS20ntd" ,"2021-01-12 10:46:34" ,"2021-01-24 11:08:31" ,"YSE" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="27", `filter`="g-Sloan", `limitingMag`="0", `mag`="18.37", `magErr`="0.03", `magUnit`="ABMag", `objectName`="PS20ntd", `obsdate`="2021-01-12 10:46:34", `reportAddedDate`="2021-01-24 11:08:31", `reportingGroup`="YSE", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"30" ,"orange-ATLAS" ,"0" ,"18.168" ,"0.128" ,"ABMag" ,"ATLAS21alk" ,"2021-01-02 10:26:24" ,"2021-01-07 01:30:37" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.168", `magErr`="0.128", `magUnit`="ABMag", `objectName`="ATLAS21alk", `obsdate`="2021-01-02 10:26:24", `reportAddedDate`="2021-01-07 01:30:37", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"30" ,"orange-ATLAS" ,"1" ,"19.32" ,null ,"ABMag" ,"ATLAS21alk" ,"2020-12-26 12:11:31" ,"2021-01-07 01:30:37" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.32", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS21alk", `obsdate`="2020-12-26 12:11:31", `reportAddedDate`="2021-01-07 01:30:37", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"45" ,"i-Sloan" ,"0" ,"19.59" ,"0.13" ,"ABMag" ,"PS20ntd" ,"2020-12-24 11:24:00" ,"2020-12-29 17:24:05" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.59", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS20ntd", `obsdate`="2020-12-24 11:24:00", `reportAddedDate`="2020-12-29 17:24:05", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"30" ,"g-ZTF" ,"0" ,"18.64" ,"0.09" ,"ABMag" ,"ZTF20acyvbhj" ,"2020-12-27 06:17:06" ,"2020-12-27 07:22:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.64", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acyvbhj", `obsdate`="2020-12-27 06:17:06", `reportAddedDate`="2020-12-27 07:22:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"30" ,"g-ZTF" ,"0" ,"19.86" ,"0.13" ,"ABMag" ,"ZTF20acyvbhj" ,"2020-12-22 09:16:03" ,"2020-12-27 07:22:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.86", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acyvbhj", `obsdate`="2020-12-22 09:16:03", `reportAddedDate`="2020-12-27 07:22:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"30" ,"r-ZTF" ,"1" ,"20.1758" ,null ,"ABMag" ,"ZTF20acyvbhj" ,"2020-12-20 10:46:18" ,"2020-12-27 07:22:23" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1758", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyvbhj", `obsdate`="2020-12-20 10:46:18", `reportAddedDate`="2020-12-27 07:22:23", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"30" ,"g-ZTF" ,"0" ,"19.8579" ,"0.130022" ,"ABMag" ,"ZTF20acyvbhj" ,"2020-12-22 09:16:03" ,"2020-12-22 21:41:11" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8579", `magErr`="0.130022", `magUnit`="ABMag", `objectName`="ZTF20acyvbhj", `obsdate`="2020-12-22 09:16:03", `reportAddedDate`="2020-12-22 21:41:11", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"30" ,"g-ZTF" ,"0" ,"20.3126" ,"0.219415" ,"ABMag" ,"ZTF20acyvbhj" ,"2020-12-20 09:28:50" ,"2020-12-22 21:41:11" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="20.3126", `magErr`="0.219415", `magUnit`="ABMag", `objectName`="ZTF20acyvbhj", `obsdate`="2020-12-20 09:28:50", `reportAddedDate`="2020-12-22 21:41:11", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adlp" ,"30" ,"g-ZTF" ,"1" ,"20.0988" ,null ,"ABMag" ,"ZTF20acyvbhj" ,"2020-12-17 09:48:21" ,"2020-12-22 21:41:11" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adlp", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0988", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acyvbhj", `obsdate`="2020-12-17 09:48:21", `reportAddedDate`="2020-12-22 21:41:11", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"120" ,"z-Sloan" ,"0" ,"20.35" ,"0.24" ,"ABMag" ,"PS20ntl" ,"2021-01-08 15:31:41" ,"2021-01-22 11:43:22" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="120", `filter`="z-Sloan", `limitingMag`="0", `mag`="20.35", `magErr`="0.24", `magUnit`="ABMag", `objectName`="PS20ntl", `obsdate`="2021-01-08 15:31:41", `reportAddedDate`="2021-01-22 11:43:22", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"cyan-ATLAS" ,"0" ,"18.954" ,"0.11" ,"ABMag" ,"ATLAS20bjxj" ,"2020-12-22 11:25:26" ,"2020-12-31 23:47:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="18.954", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ATLAS20bjxj", `obsdate`="2020-12-22 11:25:26", `reportAddedDate`="2020-12-31 23:47:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"cyan-ATLAS" ,"1" ,"19.88" ,null ,"ABMag" ,"ATLAS20bjxj" ,"2020-12-14 11:51:22" ,"2020-12-31 23:47:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.88", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bjxj", `obsdate`="2020-12-14 11:51:22", `reportAddedDate`="2020-12-31 23:47:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"45" ,"w-PS1" ,"0" ,"21.11" ,"0.19" ,"ABMag" ,"PS20ntl" ,"2020-12-11 11:32:38" ,"2020-12-29 17:31:25" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.11", `magErr`="0.19", `magUnit`="ABMag", `objectName`="PS20ntl", `obsdate`="2020-12-11 11:32:38", `reportAddedDate`="2020-12-29 17:31:25", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"0" ,"19.79" ,"0.18" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-16 09:46:24" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.79", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-16 09:46:24", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"g-ZTF" ,"0" ,"19.88" ,"0.13" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-16 08:35:39" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.88", `magErr`="0.13", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-16 08:35:39", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"1" ,"20.1751" ,null ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-13 11:23:32" ,"2020-12-20 09:59:21" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1751", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-13 11:23:32", `reportAddedDate`="2020-12-20 09:59:21", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"0" ,"19.5041" ,"0.111692" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-18 10:03:24" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5041", `magErr`="0.111692", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-18 10:03:24", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"0" ,"19.792" ,"0.175306" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-16 09:46:24" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.792", `magErr`="0.175306", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-16 09:46:24", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"g-ZTF" ,"0" ,"19.8786" ,"0.132383" ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-16 08:35:39" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.8786", `magErr`="0.132383", `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-16 08:35:39", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020adbk" ,"30" ,"r-ZTF" ,"1" ,"20.1751" ,null ,"ABMag" ,"ZTF20acxqnhn" ,"2020-12-13 11:23:32" ,"2020-12-18 21:09:36" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020adbk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="20.1751", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxqnhn", `obsdate`="2020-12-13 11:23:32", `reportAddedDate`="2020-12-18 21:09:36", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"45" ,"w-PS1" ,"0" ,"20.9" ,"0.05" ,"ABMag" ,"PS21og" ,"2021-01-15 14:26:53" ,"2021-01-23 17:04:26" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.9", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21og", `obsdate`="2021-01-15 14:26:53", `reportAddedDate`="2021-01-23 17:04:26", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"r-ZTF" ,"0" ,"19.49" ,"0.16" ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-20 12:25:46" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.49", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-20 12:25:46", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"r-ZTF" ,"0" ,"19.16" ,"0.14" ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-17 13:03:30" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.16", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-17 13:03:30", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"g-ZTF" ,"1" ,"20.2776" ,null ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-15 13:03:51" ,"2020-12-20 13:00:11" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.2776", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-15 13:03:51", `reportAddedDate`="2020-12-20 13:00:11", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"r-ZTF" ,"0" ,"19.5295" ,"0.190354" ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-15 11:59:03" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5295", `magErr`="0.190354", `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-15 11:59:03", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acuc" ,"30" ,"g-ZTF" ,"1" ,"19.9541" ,null ,"ABMag" ,"ZTF20acxsxbc" ,"2020-12-11 13:02:39" ,"2020-12-15 22:17:31" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acuc", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="19.9541", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxsxbc", `obsdate`="2020-12-11 13:02:39", `reportAddedDate`="2020-12-15 22:17:31", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acma" ,"60" ,"G-Gaia" ,"0" ,"15.89" ,"0.2" ,"ABMag" ,"Gaia21ajv" ,"2020-12-16 17:09:36" ,"2021-01-22 09:01:24" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acma", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="15.89", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21ajv", `obsdate`="2020-12-16 17:09:36", `reportAddedDate`="2021-01-22 09:01:24", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acma" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21ajv" ,"2020-11-10 11:54:14" ,"2021-01-22 09:01:24" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acma", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21ajv", `obsdate`="2020-11-10 11:54:14", `reportAddedDate`="2021-01-22 09:01:24", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acma" ,"45" ,"i-Sloan" ,"0" ,"15.98" ,null ,"ABMag" ,"PS21u" ,"2021-01-03 13:23:31" ,"2021-01-05 18:32:04" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acma", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="15.98", `magErr`=null, `magUnit`="ABMag", `objectName`="PS21u", `obsdate`="2021-01-03 13:23:31", `reportAddedDate`="2021-01-05 18:32:04", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acma" ,"30" ,"cyan-ATLAS" ,"0" ,"17.99" ,"0.061" ,"ABMag" ,"ATLAS20bhnw" ,"2020-12-12 14:12:29" ,"2020-12-12 21:50:41" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acma", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="17.99", `magErr`="0.061", `magUnit`="ABMag", `objectName`="ATLAS20bhnw", `obsdate`="2020-12-12 14:12:29", `reportAddedDate`="2020-12-12 21:50:41", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acma" ,"30" ,"orange-ATLAS" ,"1" ,"19.53" ,null ,"ABMag" ,"ATLAS20bhnw" ,"2020-12-10 14:49:55" ,"2020-12-12 21:50:41" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acma", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.53", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bhnw", `obsdate`="2020-12-10 14:49:55", `reportAddedDate`="2020-12-12 21:50:41", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020achf" ,"45" ,"w-PS1" ,"0" ,"20.7" ,"0.04" ,"ABMag" ,"PS21pw" ,"2021-01-15 14:21:07" ,"2021-01-25 11:58:17" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020achf", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.7", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS21pw", `obsdate`="2021-01-15 14:21:07", `reportAddedDate`="2021-01-25 11:58:17", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020achf" ,"30" ,"cyan-ATLAS" ,"0" ,"19.709" ,"0.187" ,"ABMag" ,"ATLAS20bjzm" ,"2020-12-21 15:23:02" ,"2021-01-06 23:58:41" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020achf", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.709", `magErr`="0.187", `magUnit`="ABMag", `objectName`="ATLAS20bjzm", `obsdate`="2020-12-21 15:23:02", `reportAddedDate`="2021-01-06 23:58:41", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020achf" ,"30" ,"orange-ATLAS" ,"1" ,"19.1" ,null ,"ABMag" ,"ATLAS20bjzm" ,"2020-12-07 15:31:41" ,"2021-01-06 23:58:41" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020achf", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="19.1", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bjzm", `obsdate`="2020-12-07 15:31:41", `reportAddedDate`="2021-01-06 23:58:41", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020achf" ,"30" ,"r-ZTF" ,"0" ,"19.29" ,"0.18" ,"ABMag" ,"ZTF20acvewsv" ,"2020-12-11 12:19:08" ,"2020-12-11 12:54:59" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020achf", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.29", `magErr`="0.18", `magUnit`="ABMag", `objectName`="ZTF20acvewsv", `obsdate`="2020-12-11 12:19:08", `reportAddedDate`="2020-12-11 12:54:59", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020achf" ,"30" ,"r-ZTF" ,"0" ,"19.06" ,"0.16" ,"ABMag" ,"ZTF20acvewsv" ,"2020-12-05 12:19:28" ,"2020-12-11 12:54:59" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020achf", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.06", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acvewsv", `obsdate`="2020-12-05 12:19:28", `reportAddedDate`="2020-12-11 12:54:59", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acew" ,"45" ,"i-Sloan" ,"0" ,"19.18" ,"0.04" ,"ABMag" ,"PS21mu" ,"2021-01-03 13:13:26" ,"2021-01-22 11:18:03" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acew", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.18", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS21mu", `obsdate`="2021-01-03 13:13:26", `reportAddedDate`="2021-01-22 11:18:03", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acew" ,"30" ,"r-ZTF" ,"0" ,"18.4" ,"0.11" ,"ABMag" ,"ZTF20acwqjaw" ,"2020-12-12 11:31:49" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acew", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.4", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20acwqjaw", `obsdate`="2020-12-12 11:31:49", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acew" ,"30" ,"r-ZTF" ,"0" ,"18.28" ,"0.08" ,"ABMag" ,"ZTF20acwqjaw" ,"2020-12-10 12:28:14" ,"2020-12-15 11:56:42" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acew", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.28", `magErr`="0.08", `magUnit`="ABMag", `objectName`="ZTF20acwqjaw", `obsdate`="2020-12-10 12:28:14", `reportAddedDate`="2020-12-15 11:56:42", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acew" ,"30" ,"r-ZTF" ,"0" ,"18.2807" ,"0.0805035" ,"ABMag" ,"ZTF20acwqjaw" ,"2020-12-10 12:28:14" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acew", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.2807", `magErr`="0.0805035", `magUnit`="ABMag", `objectName`="ZTF20acwqjaw", `obsdate`="2020-12-10 12:28:14", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acew" ,"30" ,"r-ZTF" ,"1" ,"19.2169" ,null ,"ABMag" ,"ZTF20acwqjaw" ,"2020-12-05 12:05:47" ,"2020-12-10 18:51:35" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acew", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.2169", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acwqjaw", `obsdate`="2020-12-05 12:05:47", `reportAddedDate`="2020-12-10 18:51:35", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acau" ,"45" ,"w-PS1" ,"0" ,"20.76" ,"0.04" ,"ABMag" ,"PS21qd" ,"2021-01-15 14:29:46" ,"2021-01-25 12:11:46" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acau", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.76", `magErr`="0.04", `magUnit`="ABMag", `objectName`="PS21qd", `obsdate`="2021-01-15 14:29:46", `reportAddedDate`="2021-01-25 12:11:46", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acau" ,"30" ,"cyan-ATLAS" ,"0" ,"19.091" ,"0.133" ,"ABMag" ,"ATLAS20bikb" ,"2020-12-14 15:12:58" ,"2020-12-15 20:35:39" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acau", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.091", `magErr`="0.133", `magUnit`="ABMag", `objectName`="ATLAS20bikb", `obsdate`="2020-12-14 15:12:58", `reportAddedDate`="2020-12-15 20:35:39", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acau" ,"30" ,"orange-ATLAS" ,"1" ,"18.58" ,null ,"ABMag" ,"ATLAS20bikb" ,"2020-12-07 15:51:50" ,"2020-12-15 20:35:39" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acau", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.58", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bikb", `obsdate`="2020-12-07 15:51:50", `reportAddedDate`="2020-12-15 20:35:39", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acau" ,"30" ,"r-ZTF" ,"0" ,"18.89" ,"0.11" ,"ABMag" ,"ZTF20actoerz" ,"2020-12-11 12:17:47" ,"2020-12-11 12:54:59" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acau", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.89", `magErr`="0.11", `magUnit`="ABMag", `objectName`="ZTF20actoerz", `obsdate`="2020-12-11 12:17:47", `reportAddedDate`="2020-12-11 12:54:59", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acau" ,"30" ,"g-ZTF" ,"0" ,"18.72" ,"0.1" ,"ABMag" ,"ZTF20actoerz" ,"2020-12-05 12:53:41" ,"2020-12-11 12:54:59" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acau", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.72", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20actoerz", `obsdate`="2020-12-05 12:53:41", `reportAddedDate`="2020-12-11 12:54:59", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acau" ,"30" ,"g-ZTF" ,"0" ,"18.72" ,null ,"ABMag" ,"ZTF20actoerz" ,"2020-12-05 12:53:17" ,"2020-12-10 06:43:50" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acau", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.72", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20actoerz", `obsdate`="2020-12-05 12:53:17", `reportAddedDate`="2020-12-10 06:43:50", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020acau" ,"30" ,"g-ZTF" ,"0" ,"18.75" ,null ,"ABMag" ,"ZTF20actoerz" ,"2020-12-03 12:37:26" ,"2020-12-10 06:43:50" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020acau", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.75", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20actoerz", `obsdate`="2020-12-03 12:37:26", `reportAddedDate`="2020-12-10 06:43:50", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"45" ,"w-PS1" ,"0" ,"20.55" ,"0.15" ,"ABMag" ,"PS20nuu" ,"2021-01-14 12:00:00" ,"2021-01-25 12:10:25" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.55", `magErr`="0.15", `magUnit`="ABMag", `objectName`="PS20nuu", `obsdate`="2021-01-14 12:00:00", `reportAddedDate`="2021-01-25 12:10:25", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"30" ,"cyan-ATLAS" ,"0" ,"19.409" ,"0.135" ,"ABMag" ,"ATLAS20bjto" ,"2020-12-22 11:28:19" ,"2020-12-31 01:20:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="0", `mag`="19.409", `magErr`="0.135", `magUnit`="ABMag", `objectName`="ATLAS20bjto", `obsdate`="2020-12-22 11:28:19", `reportAddedDate`="2020-12-31 01:20:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"30" ,"cyan-ATLAS" ,"1" ,"19.87" ,null ,"ABMag" ,"ATLAS20bjto" ,"2020-12-14 11:12:29" ,"2020-12-31 01:20:49" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.87", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bjto", `obsdate`="2020-12-14 11:12:29", `reportAddedDate`="2020-12-31 01:20:49", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"45" ,"w-PS1" ,"0" ,"19.16" ,"0.05" ,"ABMag" ,"PS20nuu" ,"2020-12-11 13:53:46" ,"2020-12-29 17:48:22" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.16", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS20nuu", `obsdate`="2020-12-11 13:53:46", `reportAddedDate`="2020-12-29 17:48:22", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"30" ,"r-ZTF" ,"0" ,"19.2" ,"0.1" ,"ABMag" ,"ZTF20acveyal" ,"2020-12-10 11:58:49" ,"2020-12-10 12:37:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.2", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acveyal", `obsdate`="2020-12-10 11:58:49", `reportAddedDate`="2020-12-10 12:37:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"30" ,"g-ZTF" ,"0" ,"19.25" ,"0.14" ,"ABMag" ,"ZTF20acveyal" ,"2020-12-10 08:34:23" ,"2020-12-10 12:37:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.25", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acveyal", `obsdate`="2020-12-10 08:34:23", `reportAddedDate`="2020-12-10 12:37:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"30" ,"r-ZTF" ,"1" ,"19.583" ,null ,"ABMag" ,"ZTF20acveyal" ,"2020-12-01 11:08:41" ,"2020-12-10 12:37:03" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.583", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acveyal", `obsdate`="2020-12-01 11:08:41", `reportAddedDate`="2020-12-10 12:37:03", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"30" ,"g-ZTF" ,"0" ,"19.6169" ,null ,"ABMag" ,"ZTF20acveyal" ,"2020-12-05 10:41:58" ,"2020-12-07 09:30:25" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.6169", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acveyal", `obsdate`="2020-12-05 10:41:58", `reportAddedDate`="2020-12-07 09:30:25", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abwa" ,"30" ,"r-ZTF" ,"1" ,"19.583" ,null ,"ABMag" ,"ZTF20acveyal" ,"2020-12-01 11:08:41" ,"2020-12-07 09:30:25" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abwa", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.583", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acveyal", `obsdate`="2020-12-01 11:08:41", `reportAddedDate`="2020-12-07 09:30:25", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abey" ,"60" ,"G-Gaia" ,"0" ,"16.72" ,"0.2" ,"ABMag" ,"Gaia21akb" ,"2021-01-22 00:50:24" ,"2021-01-23 13:01:20" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abey", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="16.72", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia21akb", `obsdate`="2021-01-22 00:50:24", `reportAddedDate`="2021-01-23 13:01:20", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abey" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia21akb" ,"2020-10-30 09:59:02" ,"2021-01-23 13:01:20" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abey", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia21akb", `obsdate`="2020-10-30 09:59:02", `reportAddedDate`="2021-01-23 13:01:20", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abey" ,"30" ,"g-ZTF" ,"0" ,"18.92" ,null ,"ABMag" ,"ZTF20acqpkxj" ,"2020-11-30 03:05:46" ,"2020-11-30 03:40:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abey", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="18.92", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqpkxj", `obsdate`="2020-11-30 03:05:46", `reportAddedDate`="2020-11-30 03:40:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abey" ,"30" ,"r-ZTF" ,"0" ,"19.89" ,null ,"ABMag" ,"ZTF20acqpkxj" ,"2020-11-15 04:13:26" ,"2020-11-30 03:40:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abey", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.89", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqpkxj", `obsdate`="2020-11-15 04:13:26", `reportAddedDate`="2020-11-30 03:40:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020abey" ,"30" ,"r-ZTF" ,"1" ,"19.59" ,null ,"ABMag" ,"ZTF20acqpkxj" ,"2020-11-14 05:58:34" ,"2020-11-30 03:40:36" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020abey", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.59", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acqpkxj", `obsdate`="2020-11-14 05:58:34", `reportAddedDate`="2020-11-30 03:40:36", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aaqv" ,"45" ,"w-PS1" ,"0" ,"21.18" ,"0.18" ,"ABMag" ,"PS21pb" ,"2021-01-16 09:04:19" ,"2021-01-25 10:45:00" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aaqv", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="21.18", `magErr`="0.18", `magUnit`="ABMag", `objectName`="PS21pb", `obsdate`="2021-01-16 09:04:19", `reportAddedDate`="2021-01-25 10:45:00", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aaqv" ,"45" ,"w-PS1" ,"0" ,"20.4" ,"0.24" ,"ABMag" ,"PS21pb" ,"2020-11-14 12:15:50" ,"2021-01-25 10:38:36" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aaqv", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.4", `magErr`="0.24", `magUnit`="ABMag", `objectName`="PS21pb", `obsdate`="2020-11-14 12:15:50", `reportAddedDate`="2021-01-25 10:38:36", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aaqv" ,"30" ,"g-ZTF" ,"0" ,"19.48" ,"0.14" ,"ABMag" ,"ZTF20acrachm" ,"2020-11-20 10:38:48" ,"2020-11-21 00:17:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aaqv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.48", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acrachm", `obsdate`="2020-11-20 10:38:48", `reportAddedDate`="2020-11-21 00:17:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aaqv" ,"30" ,"r-ZTF" ,"0" ,"20.2" ,"0.19" ,"ABMag" ,"ZTF20acrachm" ,"2020-11-17 12:09:05" ,"2020-11-21 00:17:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aaqv", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="20.2", `magErr`="0.19", `magUnit`="ABMag", `objectName`="ZTF20acrachm", `obsdate`="2020-11-17 12:09:05", `reportAddedDate`="2020-11-21 00:17:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020aaqv" ,"30" ,"g-ZTF" ,"1" ,"20.7476" ,null ,"ABMag" ,"ZTF20acrachm" ,"2020-11-17 10:37:41" ,"2020-11-21 00:17:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020aaqv", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.7476", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acrachm", `obsdate`="2020-11-17 10:37:41", `reportAddedDate`="2020-11-21 00:17:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"45" ,"w-PS1" ,"0" ,"20.19" ,"0.07" ,"ABMag" ,"PS20nsu" ,"2021-01-17 15:07:12" ,"2021-01-23 16:44:05" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="20.19", `magErr`="0.07", `magUnit`="ABMag", `objectName`="PS20nsu", `obsdate`="2021-01-17 15:07:12", `reportAddedDate`="2021-01-23 16:44:05", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"45" ,"i-Sloan" ,"0" ,"18.62" ,"0.09" ,"ABMag" ,"PS20nsu" ,"2020-12-02 14:28:19" ,"2020-12-29 17:17:40" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="18.62", `magErr`="0.09", `magUnit`="ABMag", `objectName`="PS20nsu", `obsdate`="2020-12-02 14:28:19", `reportAddedDate`="2020-12-29 17:17:40", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"orange-ATLAS" ,"0" ,"17.903" ,"0.094" ,"ABMag" ,"ATLAS20bggs" ,"2020-11-29 13:22:05" ,"2020-11-30 15:12:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="17.903", `magErr`="0.094", `magUnit`="ABMag", `objectName`="ATLAS20bggs", `obsdate`="2020-11-29 13:22:05", `reportAddedDate`="2020-11-30 15:12:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"cyan-ATLAS" ,"1" ,"19.49" ,null ,"ABMag" ,"ATLAS20bggs" ,"2020-07-18 06:31:41" ,"2020-11-30 15:12:24" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="cyan-ATLAS", `limitingMag`="1", `mag`="19.49", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bggs", `obsdate`="2020-07-18 06:31:41", `reportAddedDate`="2020-11-30 15:12:24", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"r-ZTF" ,"0" ,"19.1696" ,"0.115976" ,"ABMag" ,"ZTF20acpxvez" ,"2020-11-12 11:23:36" ,"2020-11-25 06:23:50" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.1696", `magErr`="0.115976", `magUnit`="ABMag", `objectName`="ZTF20acpxvez", `obsdate`="2020-11-12 11:23:36", `reportAddedDate`="2020-11-25 06:23:50", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"r-ZTF" ,"1" ,"19.848" ,null ,"ABMag" ,"ZTF20acpxvez" ,"2020-11-06 11:51:19" ,"2020-11-25 06:23:50" ,"Fink" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.848", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpxvez", `obsdate`="2020-11-06 11:51:19", `reportAddedDate`="2020-11-25 06:23:50", `reportingGroup`="Fink", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"g-ZTF" ,"0" ,"19.06" ,"0.14" ,"ABMag" ,"ZTF20acpxvez" ,"2020-11-12 12:21:02" ,"2020-11-17 12:19:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.06", `magErr`="0.14", `magUnit`="ABMag", `objectName`="ZTF20acpxvez", `obsdate`="2020-11-12 12:21:02", `reportAddedDate`="2020-11-17 12:19:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"r-ZTF" ,"0" ,"19.17" ,"0.12" ,"ABMag" ,"ZTF20acpxvez" ,"2020-11-12 11:23:36" ,"2020-11-17 12:19:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.17", `magErr`="0.12", `magUnit`="ABMag", `objectName`="ZTF20acpxvez", `obsdate`="2020-11-12 11:23:36", `reportAddedDate`="2020-11-17 12:19:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"r-ZTF" ,"1" ,"19.848" ,null ,"ABMag" ,"ZTF20acpxvez" ,"2020-11-06 11:51:19" ,"2020-11-17 12:19:15" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.848", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpxvez", `obsdate`="2020-11-06 11:51:19", `reportAddedDate`="2020-11-17 12:19:15", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"g-ZTF" ,"0" ,"19.056" ,"0.142282" ,"ABMag" ,"ZTF20acpxvez" ,"2020-11-12 12:21:02" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.056", `magErr`="0.142282", `magUnit`="ABMag", `objectName`="ZTF20acpxvez", `obsdate`="2020-11-12 12:21:02", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"r-ZTF" ,"0" ,"19.1696" ,"0.115976" ,"ABMag" ,"ZTF20acpxvez" ,"2020-11-12 11:23:36" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.1696", `magErr`="0.115976", `magUnit`="ABMag", `objectName`="ZTF20acpxvez", `obsdate`="2020-11-12 11:23:36", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020zko" ,"30" ,"r-ZTF" ,"1" ,"19.848" ,null ,"ABMag" ,"ZTF20acpxvez" ,"2020-11-06 11:51:19" ,"2020-11-12 21:03:09" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020zko", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.848", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acpxvez", `obsdate`="2020-11-06 11:51:19", `reportAddedDate`="2020-11-12 21:03:09", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"45" ,"w-PS1" ,"0" ,"19.92" ,"0.06" ,"ABMag" ,"PS20kvz" ,"2021-01-07 05:45:36" ,"2021-01-22 11:20:40" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.92", `magErr`="0.06", `magUnit`="ABMag", `objectName`="PS20kvz", `obsdate`="2021-01-07 05:45:36", `reportAddedDate`="2021-01-22 11:20:40", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"30" ,"r-ZTF" ,"0" ,"19.59" ,"0.16" ,"ABMag" ,"ZTF20acorjop" ,"2020-11-02 06:22:50" ,"2020-11-11 07:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.59", `magErr`="0.16", `magUnit`="ABMag", `objectName`="ZTF20acorjop", `obsdate`="2020-11-02 06:22:50", `reportAddedDate`="2020-11-11 07:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"30" ,"g-ZTF" ,"0" ,"19.27" ,"0.22" ,"ABMag" ,"ZTF20acorjop" ,"2020-11-02 05:03:33" ,"2020-11-11 07:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.27", `magErr`="0.22", `magUnit`="ABMag", `objectName`="ZTF20acorjop", `obsdate`="2020-11-02 05:03:33", `reportAddedDate`="2020-11-11 07:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"30" ,"g-ZTF" ,"1" ,"20.9796" ,null ,"ABMag" ,"ZTF20acorjop" ,"2020-10-22 07:36:08" ,"2020-11-11 07:01:55" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.9796", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acorjop", `obsdate`="2020-10-22 07:36:08", `reportAddedDate`="2020-11-11 07:01:55", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"45" ,"i-Sloan" ,"0" ,"19.55" ,"0.13" ,"ABMag" ,"PS20kvz" ,"2020-11-04 07:33:36" ,"2020-11-08 13:51:32" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="45", `filter`="i-Sloan", `limitingMag`="0", `mag`="19.55", `magErr`="0.13", `magUnit`="ABMag", `objectName`="PS20kvz", `obsdate`="2020-11-04 07:33:36", `reportAddedDate`="2020-11-08 13:51:32", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"30" ,"orange-ATLAS" ,"0" ,"19.021" ,"0.136" ,"ABMag" ,"ATLAS20beyi" ,"2020-11-07 09:08:38" ,"2020-11-07 23:57:31" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="19.021", `magErr`="0.136", `magUnit`="ABMag", `objectName`="ATLAS20beyi", `obsdate`="2020-11-07 09:08:38", `reportAddedDate`="2020-11-07 23:57:31", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"30" ,"orange-ATLAS" ,"1" ,"17.29" ,null ,"ABMag" ,"ATLAS20beyi" ,"2020-11-05 10:12:00" ,"2020-11-07 23:57:31" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="17.29", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20beyi", `obsdate`="2020-11-05 10:12:00", `reportAddedDate`="2020-11-07 23:57:31", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"30" ,"r-ZTF" ,"0" ,"19.5937" ,"0.156014" ,"ABMag" ,"ZTF20acorjop" ,"2020-11-02 06:22:50" ,"2020-11-02 19:19:58" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="19.5937", `magErr`="0.156014", `magUnit`="ABMag", `objectName`="ZTF20acorjop", `obsdate`="2020-11-02 06:22:50", `reportAddedDate`="2020-11-02 19:19:58", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"30" ,"g-ZTF" ,"0" ,"19.2657" ,"0.21729" ,"ABMag" ,"ZTF20acorjop" ,"2020-11-02 05:03:33" ,"2020-11-02 19:19:58" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.2657", `magErr`="0.21729", `magUnit`="ABMag", `objectName`="ZTF20acorjop", `obsdate`="2020-11-02 05:03:33", `reportAddedDate`="2020-11-02 19:19:58", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020ytk" ,"30" ,"r-ZTF" ,"1" ,"19.0863" ,null ,"ABMag" ,"ZTF20acorjop" ,"2020-10-31 07:52:50" ,"2020-11-02 19:19:58" ,"ALeRCE" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020ytk", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="19.0863", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acorjop", `obsdate`="2020-10-31 07:52:50", `reportAddedDate`="2020-11-02 19:19:58", `reportingGroup`="ALeRCE", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"45" ,"w-PS1" ,"0" ,"19.34" ,"0.05" ,"ABMag" ,"PS21oa" ,"2021-01-16 13:24:58" ,"2021-01-23 16:55:16" ,"Pan-STARRS1" ,"PSN" ,"Pan-STARRS1" ,"PS1_GPC1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="45", `filter`="w-PS1", `limitingMag`="0", `mag`="19.34", `magErr`="0.05", `magUnit`="ABMag", `objectName`="PS21oa", `obsdate`="2021-01-16 13:24:58", `reportAddedDate`="2021-01-23 16:55:16", `reportingGroup`="Pan-STARRS1", `suggestedType`="PSN", `survey`="Pan-STARRS1", `telescope`="PS1_GPC1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"30" ,"r-ZTF" ,"0" ,"18.89" ,"0.09" ,"ABMag" ,"ZTF20acxkfrm" ,"2020-12-21 12:04:43" ,"2020-12-21 12:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.89", `magErr`="0.09", `magUnit`="ABMag", `objectName`="ZTF20acxkfrm", `obsdate`="2020-12-21 12:04:43", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"30" ,"r-ZTF" ,"0" ,"18.79" ,"0.1" ,"ABMag" ,"ZTF20acxkfrm" ,"2020-12-21 12:04:03" ,"2020-12-21 12:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.79", `magErr`="0.1", `magUnit`="ABMag", `objectName`="ZTF20acxkfrm", `obsdate`="2020-12-21 12:04:03", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"30" ,"g-ZTF" ,"1" ,"20.0634" ,null ,"ABMag" ,"ZTF20acxkfrm" ,"2020-12-21 11:02:48" ,"2020-12-21 12:18:53" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="30", `filter`="g-ZTF", `limitingMag`="1", `mag`="20.0634", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxkfrm", `obsdate`="2020-12-21 11:02:48", `reportAddedDate`="2020-12-21 12:18:53", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"30" ,"r-ZTF" ,"0" ,"18.67" ,null ,"ABMag" ,"ZTF20acxkfrm" ,"2020-12-13 12:04:19" ,"2020-12-14 06:37:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="30", `filter`="r-ZTF", `limitingMag`="0", `mag`="18.67", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxkfrm", `obsdate`="2020-12-13 12:04:19", `reportAddedDate`="2020-12-14 06:37:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"30" ,"g-ZTF" ,"0" ,"19.92" ,null ,"ABMag" ,"ZTF20acxkfrm" ,"2020-12-11 12:33:07" ,"2020-12-14 06:37:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="30", `filter`="g-ZTF", `limitingMag`="0", `mag`="19.92", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxkfrm", `obsdate`="2020-12-11 12:33:07", `reportAddedDate`="2020-12-14 06:37:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"30" ,"r-ZTF" ,"1" ,"16.58" ,null ,"ABMag" ,"ZTF20acxkfrm" ,"2020-12-09 12:02:53" ,"2020-12-14 06:37:51" ,"ZTF" ,"PSN" ,"ZTF" ,"P48_ZTF-Cam", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="30", `filter`="r-ZTF", `limitingMag`="1", `mag`="16.58", `magErr`=null, `magUnit`="ABMag", `objectName`="ZTF20acxkfrm", `obsdate`="2020-12-09 12:02:53", `reportAddedDate`="2020-12-14 06:37:51", `reportingGroup`="ZTF", `suggestedType`="PSN", `survey`="ZTF", `telescope`="P48_ZTF-Cam" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"30" ,"orange-ATLAS" ,"0" ,"18.616" ,"0.15" ,"ABMag" ,"ATLAS20bglm" ,"2020-12-02 14:11:02" ,"2020-12-03 01:11:33" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="0", `mag`="18.616", `magErr`="0.15", `magUnit`="ABMag", `objectName`="ATLAS20bglm", `obsdate`="2020-12-02 14:11:02", `reportAddedDate`="2020-12-03 01:11:33", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"30" ,"orange-ATLAS" ,"1" ,"18.84" ,null ,"ABMag" ,"ATLAS20bglm" ,"2020-11-30 15:25:55" ,"2020-12-03 01:11:33" ,"ATLAS" ,"PSN" ,"ATLAS" ,"ATLAS1_ACAM1", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="30", `filter`="orange-ATLAS", `limitingMag`="1", `mag`="18.84", `magErr`=null, `magUnit`="ABMag", `objectName`="ATLAS20bglm", `obsdate`="2020-11-30 15:25:55", `reportAddedDate`="2020-12-03 01:11:33", `reportingGroup`="ATLAS", `suggestedType`="PSN", `survey`="ATLAS", `telescope`="ATLAS1_ACAM1" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"60" ,"G-Gaia" ,"0" ,"18.63" ,"0.2" ,"ABMag" ,"Gaia20ezg" ,"2020-10-27 05:39:50" ,"2020-10-29 09:28:11" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="18.63", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia20ezg", `obsdate`="2020-10-27 05:39:50", `reportAddedDate`="2020-10-29 09:28:11", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia20ezg" ,"2020-06-25 05:05:17" ,"2020-10-29 09:28:11" ,"GaiaAlerts" ,"PSN" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia20ezg", `obsdate`="2020-06-25 05:05:17", `reportAddedDate`="2020-10-29 09:28:11", `reportingGroup`="GaiaAlerts", `suggestedType`="PSN", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"60" ,"Clear-" ,"0" ,"15.5" ,null ,"VegaMag" ,"MASTER OT J103735.45-224219.8" ,"2020-07-19 17:39:18" ,"2020-07-20 16:42:00" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="15.5", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J103735.45-224219.8", `obsdate`="2020-07-19 17:39:18", `reportAddedDate`="2020-07-20 16:42:00", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"60" ,"Clear-" ,"0" ,"15.4" ,null ,"VegaMag" ,"MASTER OT J103735.45-224219.8" ,"2020-07-19 17:33:56" ,"2020-07-20 16:42:00" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="15.4", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J103735.45-224219.8", `obsdate`="2020-07-19 17:33:56", `reportAddedDate`="2020-07-20 16:42:00", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2020pub" ,"60" ,"Clear-" ,"1" ,"19.7" ,null ,"VegaMag" ,"MASTER OT J103735.45-224219.8" ,"2015-01-21 21:50:55" ,"2020-07-20 16:42:00" ,"MASTER" ,"PSN" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2020pub", `exptime`="60", `filter`="Clear-", `limitingMag`="1", `mag`="19.7", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J103735.45-224219.8", `obsdate`="2015-01-21 21:50:55", `reportAddedDate`="2020-07-20 16:42:00", `reportingGroup`="MASTER", `suggestedType`="PSN", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2016dre" ,"60" ,"Clear-" ,"0" ,"15" ,null ,"VegaMag" ,"MASTER OT J005421.68-475146.7" ,"2021-01-24 02:05:00" ,"2021-01-24 17:22:57" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2016dre", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="15", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J005421.68-475146.7", `obsdate`="2021-01-24 02:05:00", `reportAddedDate`="2021-01-24 17:22:57", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2016dre" ,"60" ,"Clear-" ,"0" ,"15" ,null ,"VegaMag" ,"MASTER OT J005421.68-475146.7" ,"2021-01-24 01:50:16" ,"2021-01-24 17:22:57" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2016dre", `exptime`="60", `filter`="Clear-", `limitingMag`="0", `mag`="15", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J005421.68-475146.7", `obsdate`="2021-01-24 01:50:16", `reportAddedDate`="2021-01-24 17:22:57", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2016dre" ,"180" ,"Clear-" ,"1" ,"19.9" ,null ,"VegaMag" ,"MASTER OT J005421.68-475146.7" ,"2016-11-01 03:33:29" ,"2021-01-24 17:22:57" ,"MASTER" ,"Other" ,"MASTER" ,"Other_Other", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2016dre", `exptime`="180", `filter`="Clear-", `limitingMag`="1", `mag`="19.9", `magErr`=null, `magUnit`="VegaMag", `objectName`="MASTER OT J005421.68-475146.7", `obsdate`="2016-11-01 03:33:29", `reportAddedDate`="2021-01-24 17:22:57", `reportingGroup`="MASTER", `suggestedType`="Other", `survey`="MASTER", `telescope`="Other_Other" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2016dre" ,"60" ,"G-Gaia" ,"0" ,"15.17" ,"0.2" ,"ABMag" ,"Gaia16adj" ,"2016-02-11 12:47:31" ,"2016-07-22 10:56:32" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2016dre", `exptime`="60", `filter`="G-Gaia", `limitingMag`="0", `mag`="15.17", `magErr`="0.2", `magUnit`="ABMag", `objectName`="Gaia16adj", `obsdate`="2016-02-11 12:47:31", `reportAddedDate`="2016-07-22 10:56:32", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;
INSERT IGNORE INTO `fs_tns_photometry` (`TNSId`,`exptime`,`filter`,`limitingMag`,`mag`,`magErr`,`magUnit`,`objectName`,`obsdate`,`reportAddedDate`,`reportingGroup`,`suggestedType`,`survey`,`telescope`, dateCreated) VALUES ("2016dre" ,null ,"G-Gaia" ,"1" ,"21.5" ,null ,"ABMag" ,"Gaia16adj" ,"2016-01-30 12:41:45" ,"2016-07-22 10:56:32" ,"GaiaAlerts" ,"Other" ,"GaiaAlerts" ,"Gaia_Gaia-photometric", NOW())  ON DUPLICATE KEY UPDATE  `TNSId`="2016dre", `exptime`=null, `filter`="G-Gaia", `limitingMag`="1", `mag`="21.5", `magErr`=null, `magUnit`="ABMag", `objectName`="Gaia16adj", `obsdate`="2016-01-30 12:41:45", `reportAddedDate`="2016-07-22 10:56:32", `reportingGroup`="GaiaAlerts", `suggestedType`="Other", `survey`="GaiaAlerts", `telescope`="Gaia_Gaia-photometric" ;