"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
class Runtime {
    constructor(name, family, props = {}) {
        var _b, _c;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_RuntimeFamily(family);
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_LambdaRuntimeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        const imageName = (_b = props.bundlingDockerImage) !== null && _b !== void 0 ? _b : `public.ecr.aws/sam/build-${name}`;
        this.bundlingDockerImage = core_1.DockerImage.fromRegistry(imageName);
        this.bundlingImage = this.bundlingDockerImage;
        this.supportsCodeGuruProfiling = (_c = props.supportsCodeGuruProfiling) !== null && _c !== void 0 ? _c : false;
        Runtime.ALL.push(this);
    }
    toString() {
        return this.name;
    }
    runtimeEquals(other) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_Runtime(other);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.runtimeEquals);
            }
            throw error;
        }
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-lambda.Runtime", version: "1.155.0" };
/** A list of all known `Runtime`'s. */
Runtime.ALL = new Array();
/**
 * The NodeJS runtime (nodejs)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 4.3 runtime (nodejs4.3)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 6.10 runtime (nodejs6.10)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 8.10 runtime (nodejs8.10)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 10.x runtime (nodejs10.x)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 12.x runtime (nodejs12.x)
 */
Runtime.NODEJS_12_X = new Runtime('nodejs12.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 14.x runtime (nodejs14.x)
 */
Runtime.NODEJS_14_X = new Runtime('nodejs14.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The Python 2.7 runtime (python2.7)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
 */
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.6 runtime (python3.6)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
 */
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.7 runtime (python3.7)
 */
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.8 runtime (python3.8)
 */
Runtime.PYTHON_3_8 = new Runtime('python3.8', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.9 runtime (python3.9)
 */
Runtime.PYTHON_3_9 = new Runtime('python3.9', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 runtime (java8)
 */
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 Corretto runtime (java8.al2)
 */
Runtime.JAVA_8_CORRETTO = new Runtime('java8.al2', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 11 runtime (java11)
 */
Runtime.JAVA_11 = new Runtime('java11', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The .NET 6 runtime (dotnet6)
 */
Runtime.DOTNET_6 = new Runtime('dotnet6', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 1.0 runtime (dotnetcore1.0)
 * Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.0 runtime (dotnetcore2.0)
 * Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.1 runtime (dotnetcore2.1)
 * Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 3.1 runtime (dotnetcore3.1)
 */
Runtime.DOTNET_CORE_3_1 = new Runtime('dotnetcore3.1', RuntimeFamily.DOTNET_CORE);
/**
 * The Go 1.x runtime (go1.x)
 */
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO);
/**
 * The Ruby 2.5 runtime (ruby2.5)
 * Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Ruby runtime.
 */
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY);
/**
 * The Ruby 2.7 runtime (ruby2.7)
 */
Runtime.RUBY_2_7 = new Runtime('ruby2.7', RuntimeFamily.RUBY);
/**
 * The custom provided runtime (provided)
 */
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
/**
 * The custom provided runtime (provided)
 */
Runtime.PROVIDED_AL2 = new Runtime('provided.al2', RuntimeFamily.OTHER);
/**
 * A special runtime entry to be used when function is using a docker image.
 */
Runtime.FROM_IMAGE = new Runtime('FROM_IMAGE');
//# sourceMappingURL=data:application/json;base64,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