# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mauna_sdk',
 'mauna_sdk.api',
 'mauna_sdk.api.enum',
 'mauna_sdk.api.input',
 'mauna_sdk.schema_config']

package_data = \
{'': ['*'], 'mauna_sdk': ['schema/*']}

install_requires = \
['cryptography>=3.4.6,<4.0.0',
 'gql[all]==3.0.0a5',
 'py-gql-client>=1.0.1,<2.0.0',
 'requests>=2.25.1,<3.0.0']

extras_require = \
{':python_version >= "3.6" and python_version < "3.7"': ['dataclasses>=0.6,<0.7']}

entry_points = \
{'console_scripts': ['codegen = scripts.codegen:main']}

setup_kwargs = {
    'name': 'mauna-sdk',
    'version': '0.2.21',
    'description': 'Mauna SDK',
    'long_description': '# Mauna SDK\n\n## Installation and usage\n\n### Build\n\n`poetry install`\n\n`poetry run codegen`\n\n`poetry build`\n\n### Install\n\n`pip install mauna_sdk`\n\n## API list\n\n### api.chitchat\n\nTakes an input and a list of history messages, determines if chitchat is started and generates the corresponding response\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.chitchat import chitchat\nfrom mauna_sdk.api.input.turn import Turn, Agent\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = chitchat.execute(\n    client, \n    input="This is the good weather today", \n    history=[\n        Turn(agent=Agent.USER, said="Hello"),\n        Turn(agent=Agent.BOT, said="Hi there")\n    ]\n)\n# result == chitchat.chitchatData.ChitchatResponse(response=\'{\\\'response\\\': "It\\\'s been raining for a few days now."}\')\n```\n\n### api.commonsenseReasoning\n\nPulls various relations out of the given text\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.commonsense_reasoning import commonsenseReasoning\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = commonsenseReasoning.execute(client, text="Hello")\n# result == [\n#   commonsenseReasoning.commonsenseReasoningData.RelationResult(\n#     type=\'xAttr\', \n#     result=[\n#       \'determined\', \n#       \'curious\', \n#       \'brave\', \n#       \'confident\', \n#       \'capable\', \n#       \'smart\', \n#       \'dedicated\', \n#       \'thoughtful\', \n#       \'careless\', \n#       \'mean\'\n#     ]\n#   ), \n#   commonsenseReasoning.commonsenseReasoningData.RelationResult(\n#     type=\'xEffect\', \n#     result=[\n#       \'gets yelled at\', \n#       \'personx sweats from nervousness\', \n#       \'gets called a liar\', \n#       \'personx is arrested\', \n#       \'gets arrested\', \n#       \'gets tired\', \n#       \'is praised\', \n#       \'personx sweats\', \n#       \'none\', \n#       \'personx is arrested for assault\'\n#     ]\n#   ), \n#   commonsenseReasoning.commonsenseReasoningData.RelationResult(\n#     type=\'xIntent\', \n#     result=[\n#       \'to have fun\', \n#       \'to get something done\', \n#       \'to satisfy his hunger\', \n#       \'to show off skills\', \n#       \'to satisfy his cravings\', \n#       \'to do something\', \n#       \'to have a good time\', \n#       \'to show off\', \n#       \'none\', \n#       \'to be a part of something\'\n#     ]\n#   ), \n#   commonsenseReasoning.commonsenseReasoningData.RelationResult(\n#     type=\'xWant\', \n#     result=[\n#       \'to take a break\', \n#       \'to be successful\', \n#       \'to do something else\', \n#       \'to go home\', \n#       \'to have fun\', \n#       \'to have a good time\', \n#       \'to show off\', \n#       \'to rest\', \n#       \'to show off their skills\', \n#       \'to show off their new purchase\'\n#     ]\n#   )\n# ]\n```\n\n### api.conceptnetGrounding\n\nTakes a text and returns related texts, according to relation type(s).\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.conceptnet_grounding import conceptnetGrounding\nfrom mauna_sdk.api.enum.relations import Relations\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = conceptnetGrounding.execute(client, text="max with axe", relations=[Relations.CapableOf])\n# result == [\n#   conceptnetGrounding.conceptnetGroundingData.RelationResult(\n#     type=\'CapableOf\', \n#     result=[\n#       \'chop down tree\', \n#       \'split wood\', \n#       \'chop wood\', \n#       \'cut wood\', \n#       \'break window\', \n#       \'chop firewood\', \n#       \'cut firewood\', \n#       \'cut lumber\', \n#       \'cut tree\', \n#       \'cut you in half\'\n#     ]\n#   )\n# ]\n```\n\n### api.parseACE\n\nTakes an ACE text and an output format and produces the parsed ACE according to the format\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.parse_ace import parseACE\nfrom mauna_sdk.api.enum.a_c_e_output_type import ACEOutputType\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = parseACE.execute(client, text="John walks.", format=ACEOutputType.drs)\n# result == parseACE.parseACEData.ACEResult(parsed="drs([A],[predicate(A,walk,named(\'John\'))-1/2])\\n")\n```\n\n### api.parseContext\n\nTakes a list of turns (`{ content: string }`) and parses them to produce a semantic frames-based context object.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.parse_context import parseContext\nfrom mauna_sdk.api.input.context_object import ContextObject\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = parseContext.execute(client, turns=[ContextObject(content="Today is a good day")])\n# result == [\n#   parseContext.parseContextData.ContextResult(\n#     context=parseContext.parseContextData.ContextResult.SlingDocument(\n#       mentions=[\n#         parseContext.parseContextData.ContextResult.SlingDocument.SlingMention(\n#             evokes=[\'{=#1 :DATE}\'], \n#             phrase=\'Today\'\n#           ), \n#         parseContext.parseContextData.ContextResult.SlingDocument.SlingMention(\n#           evokes=[\'{=#1 :/pb/predicate /pb/ARG1: {=#2 :DATE} /pb/ARG2: {=#3 :thing}}\'], phrase=\'is\'\n#         ), \n#         parseContext.parseContextData.ContextResult.SlingDocument.SlingMention(\n#           evokes=[\'{=#1 :thing}\'], phrase=\'day\'\n#         )\n#       ]\n#     )\n#   )\n# ]\n```\n\n### api.paraphraseSentence\n\nTakes an english sentence and produces paraphrased versions of it that retain the semantic meaning of the original.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.paraphrase_sentence import paraphraseSentence\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = paraphraseSentence.execute(client, sentence="I like tomatoes", count=2)\n# result == paraphraseSentence.paraphraseSentenceData.Paraphrase(\n#   paraphrases=[\n#     \'I like tomatoes.\', \n#     \'I enjoy tomatoes.\', \n#     \'I like to eat tomatoes.\', \n#     \'I am a fan of tomatoes.\', \n#     \'I enjoy eating tomatoes.\', \n#     \'I like eating tomatoes.\', \n#     \'I love tomatoes.\', \n#     \'I like the taste of tomatoes.\', \n#     \'I like fresh tomatoes.\', \n#     \'I like to eat fruit.\'\n#   ]\n#   )\n```\n\n### api.predictNextTurn\n\nTakes a list of utterances as history and a list of possible alternatives that can be replied with. Returns the most likely alternative and confidence in that prediction.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.predict_next_turn import predictNextTurn\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = predictNextTurn.execute(client, history=["Hello", "How are you?"], alternatives=["I am fine", "Hello"])\n# result == [\n#   predictNextTurn.predictNextTurnData.DialogAlternative(\n#     nextTurn=\'I am fine\', \n#     confidence=0.6935682892799377\n#   ), \n#   predictNextTurn.predictNextTurnData.DialogAlternative(\n#     nextTurn=\'Hello\', \n#     confidence=0.5061840415000916\n#   )\n# ]\n```\n\n### api.matchIntent\n\nTakes a list of intents (with slots) and a user input. Performs structured information extraction to find the correct intent and fill the corresponding slots.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.match_intent import matchIntent\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = matchIntent.execute(\n    client,\n    input="I require insurance",\n    intent=[\n        "Someone requires insurance", \n        "An ENTITYPERSON takes out insurance"\n    ]\n)\n# result == matchIntent.matchIntentData.MatchIntentOutput(\n#   matches=[\n#     matchIntent.matchIntentData.MatchIntentOutput.PhraseMatch(\n#       intent=\'Someone requires insurance\', \n#       confidence=1.0, \n#       slots=[\n#         matchIntent.matchIntentData.MatchIntentOutput.PhraseMatch.WordMatch(\n#           slot=\'require\', \n#           value=\'require\', \n#           match_type=\'direct\', \n#           confidence=1.0\n#         ), \n#         matchIntent.matchIntentData.MatchIntentOutput.PhraseMatch.WordMatch(\n#           slot=\'insurance\', \n#           value=\'insurance\', \n#           match_type=\'direct\', \n#           confidence=1.0)\n#       ]\n#     )\n#   ]\n# )\n```\n\n### api.measureSimilarity\n\nTakes a target sentence and a list of other sentences to compare with for similarity. Returns an array of pairwise similarity scores.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.measure_similarity import measureSimilarity\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = measureSimilarity.execute(\n    client, sentence="Today is a good day", \n    compareWith=["Today is an awesome day", "Today is a bad day"]\n)\n# result == measureSimilarity.measureSimilarityData.SentenceSimilarityScores(\n#   result=[\n#     measureSimilarity.measureSimilarityData.SentenceSimilarityScores.PairSimilarity(\n#       score=0.6445285081863403, \n#       sentencePair=[\'Today is a good day\', \'Today is an awesome day\']\n#     ), \n#     measureSimilarity.measureSimilarityData.SentenceSimilarityScores.PairSimilarity(\n#       score=0.3357277512550354, \n#       sentencePair=[\'Today is a good day\', \'Today is a bad day\']\n#     )\n#   ]\n# )\n```\n\n### api.resolveCoreferences\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.resolve_coreferences import resolveCoreferences\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = resolveCoreferences.execute(client, text="Emma said that she thinks that Nelson really likes to dance.")\n# result == resolveCoreferences.resolveCoreferencesData.NlpDoc(\n#   coref=resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension(\n#     detected=True, \n#     resolvedOutput=\'Emma said that Emma thinks that Nelson really likes to dance.\', \n#     clusters=[\n#       resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores(\n#         mention=\'Emma\', \n#         references=[\n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'Emma\', \n#             score=0.9530903100967407\n#           )\n#         ]\n#       ), \n#       resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores(\n#         mention=\'she\', \n#         references=[\n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'she\', \n#             score=0.2935597896575928\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'Emma\', \n#             score=8.278848648071289\n#           )\n#         ]\n#       ), \n#       resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores(\n#         mention=\'she thinks that Nelson really likes to dance\', \n#         references=[\n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'she thinks that Nelson really likes to dance\', \n#             score=1.7855921983718872\n#           ),\n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'Emma\', \n#             score=-1.801807165145874\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'she\', \n#             score=-1.6977876424789429\n#           )\n#         ]\n#       ), \n#       resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores(\n#         mention=\'Nelson\', \n#         references=[\n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'Nelson\', \n#             score=0.4910166263580322\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'Emma\', \n#             score=-2.120563507080078\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'she\', \n#             score=-2.0476505756378174\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'she thinks that Nelson really likes to dance\', \n#             score=-1.5593587160110474\n#           )\n#         ]\n#       ), \n#       resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores(\n#         mention=\'Nelson really likes to dance\', \n#         references=[\n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'Nelson really likes to dance\', \n#             score=1.6450811624526978\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'Emma\', \n#             score=-1.7996364831924438\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'she\', \n#             score=-2.02427339553833\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'she thinks that Nelson really likes to dance\', \n#             score=-1.497442603111267\n#           ), \n#           resolveCoreferences.resolveCoreferencesData.NlpDoc.DocExtension.CorefScores.Scores(\n#             match=\'Nelson\', \n#             score=-1.5290888547897339\n#           )\n#         ]\n#       )\n#     ]\n#   )\n# )\n```\n\n### api.toVec\n\nTakes an English text as an input and returns vector representation for passage, its sentences and entities if found.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.to_vec import toVec\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = toVec.execute(client, text="John likes to play piano")\n# result == toVec.toVecData.NlpDoc(\n#   has_vector=True, \n#   vector=[\n#     0.08898600190877914, \n#     ...\n#   ], \n#   vector_norm=3.998985419599661, \n#   sentences=[\n#     toVec.toVecData.NlpDoc.Span(\n#       has_vector=True, \n#       vector_norm=3.9989852905273438, \n#       vector=[\n#         0.08898600190877914, \n#         ...\n#       ], \n#       text=\'John likes to play piano\'\n#     )\n#   ], \n#   entities=[\n#     toVec.toVecData.NlpDoc.Span(\n#       has_vector=True, \n#       vector_norm=6.533577919006348, \n#       vector=[\n#         -0.29218998551368713, \n#         ...\n#       ], \n#       text=\'John\'\n#     )\n#   ]\n# )\n```\n\n### api.getSentiment\n\nTakes plain English input and returns overall and sentence-level sentiment information. Represents positivity or negativity of the passage as a floating point value.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.get_sentiment import getSentiment\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = getSentiment.execute(client, text="The movie is awesome")\n# result == getSentiment.getSentimentData.NlpDoc(\n#   sentiment=0.9467527270317078, \n#   sentences=[\n#     getSentiment.getSentimentData.NlpDoc.Span(\n#       text=\'The movie is awesome\', \n#       sentiment=0.0\n#     )\n#   ]\n# )\n```\n\n### api.parseText\n\nTakes some plain English input and returns parsed categories, entities and sentences.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.parse_text import parseText\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = parseText.execute(client, text="Today is a good day")\n# result == parseText.parseTextData.NlpDoc(\n#   categories=[], \n#   entities=[\n#     parseText.parseTextData.NlpDoc.Span(\n#       label=\'DATE\', \n#       lemma=\'today\', \n#       text=\'Today\'\n#     ), \n#     parseText.parseTextData.NlpDoc.Span(\n#       label=\'DATE\', \n#       lemma=\'a good day\', \n#       text=\'a good day\'\n#     )\n#   ], \n#   sentences=[\n#     parseText.parseTextData.NlpDoc.Span(\n#       label=\'\', \n#       lemma=\'today be a good day\', \n#       text=\'Today is a good day\'\n#     )\n#   ]\n# )\n```\n\n### api.extractNumericData\n\nTakes some text and extracts numeric references as a list of tokens with numeric annotations.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.extract_numeric_data import extractNumericData\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = extractNumericData.execute(client, text="I told you two")\n# result == extractNumericData.extractNumericDataData.NlpDoc(\n#   tokens=[\n#     extractNumericData.extractNumericDataData.NlpDoc.Token(\n#       numeric_analysis=extractNumericData.extractNumericDataData.NlpDoc.Token.TokenExtension(\n#         data=None, \n#         has_numeric=False\n#       )\n#     ), \n#     extractNumericData.extractNumericDataData.NlpDoc.Token(\n#       numeric_analysis=extractNumericData.extractNumericDataData.NlpDoc.Token.TokenExtension(\n#         data=None, \n#         has_numeric=False\n#       )\n#     ), \n#     extractNumericData.extractNumericDataData.NlpDoc.Token(\n#       numeric_analysis=extractNumericData.extractNumericDataData.NlpDoc.Token.TokenExtension(\n#         data=None, \n#         has_numeric=False\n#       )\n#     ), \n#     extractNumericData.extractNumericDataData.NlpDoc.Token(\n#       numeric_analysis=extractNumericData.extractNumericDataData.NlpDoc.Token.TokenExtension(\n#         data=\'PEOPLE\', \n#         has_numeric=True\n#       )\n#     )\n#   ]\n# )\n```\n\n### api.parseTextTokens\n\nTakes some plain English string as input and returns a list of its tokens annotated with linguistic information.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.parse_text_tokens import parseTextTokens\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = parseTextTokens.execute(client, text="Hello there")\n# result == parseTextTokens.parseTextTokensData.NlpDoc(\n#   tokens=[\n#     parseTextTokens.parseTextTokensData.NlpDoc.Token(\n#       dependency=\'ROOT\', \n#       entity_type=\'\', \n#       is_alpha=True, \n#       is_currency=False, \n#       is_digit=False, is_oov=False, \n#       is_sent_start=True, \n#       is_stop=False, \n#       is_title=True, \n#       lemma=\'hello\', \n#       like_email=False, \n#       like_num=False, \n#       like_url=False, \n#       part_of_speech=\'INTJ\', \n#       prob=-10.583807945251465, \n#       tag=\'UH\', \n#       text=\'Hello\'\n#     ), \n#     parseTextTokens.parseTextTokensData.NlpDoc.Token(\n#       dependency=\'advmod\', \n#       entity_type=\'\', \n#       is_alpha=True, \n#       is_currency=False, \n#       is_digit=False, \n#       is_oov=False, \n#       is_sent_start=None, \n#       is_stop=True, \n#       is_title=False, \n#       lemma=\'there\', \n#       like_email=False, \n#       like_num=False, \n#       like_url=False, \n#       part_of_speech=\'ADV\', \n#       prob=-6.135282039642334, \n#       tag=\'RB\', \n#       text=\'there\'\n#     )\n#   ]\n# )\n```\n\n### api.renderCSS\n\nTakes ssml and corresponding styles as a css string. Returns base64 encoded audio.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.render_css import renderCSS\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = renderCSS.execute(client, ssml="<s class=\'test\'>Hello</s>", css=".test {volume: 120%;}")\n# result == renderCSS.renderCSSData.ComposeResult(\n#   result={\'$result\': {\'callTextToSpeech\': {\'audioB64\': \'UklGRoDyAgBXQVZFZm ... \'}}, \'$context\': {}}\n# )\n```\n\n### api.speechToText\n\nTakes base64 encoded audio as input and returns a list of possible transcripts (sorted in order of decreasing confidence).\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.speech_to_text import speechToText\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = speechToText.execute(client, audio="AAAA ...")\n# result == speechToText.speechToTextData.STTResult(\n#   transcript=[\n#     speechToText.speechToTextData.STTResult.TextAlternative(text="Hello.")\n#   ]\n# )\n```\n\n### api.textToSpeech\n\nTakes text (`string`) as input and returns audio encoded as a base64 string.\n\n```python\nfrom mauna_sdk import Mauna\nfrom mauna_sdk.api.text_to_speech import textToSpeech\n\n\ndeveloper_id = <int> # Check your profile on the dashboard for this.\napi_key = "<64 letter api key available on your mauna dashboard>"\nclient = Mauna(api_key, developer_id)\nresult = textToSpeech.execute(client, text="Hello")\n# result == textToSpeech.textToSpeechData.TTSResult(audio=\'UklGRpJb ...\')\n```\n',
    'author': 'Dmitry Paramonov',
    'author_email': 'asmatic075@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
