#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from .input.turn import Turn


# fmt: off
QUERY: List[str] = ["""
query predictNextTurn($history: [Turn!]!, $input: [String!]!) {
  result: callNextDialogTurn(history: $history, input: $input) {
    nextTurns: result {
      alternative
      score
    }
  }
}

"""
]


class predictNextTurn:
    @dataclass(frozen=True)
    class predictNextTurnData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Result(DataClassJsonMixin):
            @dataclass(frozen=True)
            class DialogAlternative(DataClassJsonMixin):
                alternative: Optional[str]
                score: Optional[Number]

            nextTurns: Optional[List[DialogAlternative]]

        result: Optional[Result]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, history: List[Turn] = [], input: List[str] = []) -> Optional[predictNextTurnData.Result]:
        variables: Dict[str, Any] = {"history": history, "input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.predictNextTurnData.from_dict(response_text)
        return res.result

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, history: List[Turn] = [], input: List[str] = []) -> Optional[predictNextTurnData.Result]:
        variables: Dict[str, Any] = {"history": history, "input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.predictNextTurnData.from_dict(response_text)
        return res.result
