#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from .input.turn import Turn


# fmt: off
QUERY: List[str] = ["""
query chitchat($input: String!, $history: [Turn!]!) {
  result: callChitchat(history: $history, input: $input) {
    reply: result
  }
}

"""
]


class chitchat:
    @dataclass(frozen=True)
    class chitchatData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ChitchatResponse(DataClassJsonMixin):
            reply: Optional[str]

        result: Optional[ChitchatResponse]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: str, history: List[Turn] = []) -> Optional[chitchatData.ChitchatResponse]:
        variables: Dict[str, Any] = {"input": input, "history": history}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.chitchatData.from_dict(response_text)
        return res.result

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: str, history: List[Turn] = []) -> Optional[chitchatData.ChitchatResponse]:
        variables: Dict[str, Any] = {"input": input, "history": history}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.chitchatData.from_dict(response_text)
        return res.result
