"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const appscaling = require("../lib");
const util_1 = require("./util");
module.exports = {
    'test scalable target creation'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new appscaling.ScalableTarget(stack, 'Target', {
            serviceNamespace: appscaling.ServiceNamespace.DynamoDb,
            scalableDimension: 'test:TestCount',
            resourceId: 'test:this/test',
            minCapacity: 1,
            maxCapacity: 20,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApplicationAutoScaling::ScalableTarget', {
            ServiceNamespace: 'dynamodb',
            ScalableDimension: 'test:TestCount',
            ResourceId: 'test:this/test',
            MinCapacity: 1,
            MaxCapacity: 20,
        }));
        test.done();
    },
    'add scheduled scaling'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const target = util_1.createScalableTarget(stack);
        // WHEN
        target.scaleOnSchedule('ScaleUp', {
            schedule: 'rate(1 second)',
            maxCapacity: 50,
            minCapacity: 1,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApplicationAutoScaling::ScalableTarget', {
            ScheduledActions: [
                {
                    ScalableTargetAction: {
                        MaxCapacity: 50,
                        MinCapacity: 1
                    },
                    Schedule: "rate(1 second)",
                    ScheduledActionName: "ScaleUp"
                }
            ]
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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