"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Helper class to generate Cron expressions
 */
class Cron {
    /**
     * Return a cron expression to run every day at a particular time
     *
     * The time is specified in UTC.
     *
     * @param hour The hour in UTC to schedule this action
     * @param minute The minute in the our to schedule this action (defaults to 0)
     */
    static dailyUtc(hour, minute) {
        minute = minute || 0;
        // 3rd and 5th expression are mutually exclusive, one of them should be ?
        return `cron(${minute} ${hour} * * ?)`;
    }
}
exports.Cron = Cron;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3Jvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNyb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7R0FFRztBQUNILE1BQWEsSUFBSTtJQUVmOzs7Ozs7O09BT0c7SUFDSSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQVksRUFBRSxNQUFlO1FBQ2xELE1BQU0sR0FBRyxNQUFNLElBQUksQ0FBQyxDQUFDO1FBQ3JCLHlFQUF5RTtRQUN6RSxPQUFPLFFBQVEsTUFBTSxJQUFJLElBQUksU0FBUyxDQUFDO0lBQ3pDLENBQUM7Q0FDRjtBQWZELG9CQWVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBIZWxwZXIgY2xhc3MgdG8gZ2VuZXJhdGUgQ3JvbiBleHByZXNzaW9uc1xuICovXG5leHBvcnQgY2xhc3MgQ3JvbiB7XG5cbiAgLyoqXG4gICAqIFJldHVybiBhIGNyb24gZXhwcmVzc2lvbiB0byBydW4gZXZlcnkgZGF5IGF0IGEgcGFydGljdWxhciB0aW1lXG4gICAqXG4gICAqIFRoZSB0aW1lIGlzIHNwZWNpZmllZCBpbiBVVEMuXG4gICAqXG4gICAqIEBwYXJhbSBob3VyIFRoZSBob3VyIGluIFVUQyB0byBzY2hlZHVsZSB0aGlzIGFjdGlvblxuICAgKiBAcGFyYW0gbWludXRlIFRoZSBtaW51dGUgaW4gdGhlIG91ciB0byBzY2hlZHVsZSB0aGlzIGFjdGlvbiAoZGVmYXVsdHMgdG8gMClcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZGFpbHlVdGMoaG91cjogbnVtYmVyLCBtaW51dGU/OiBudW1iZXIpIHtcbiAgICBtaW51dGUgPSBtaW51dGUgfHwgMDtcbiAgICAvLyAzcmQgYW5kIDV0aCBleHByZXNzaW9uIGFyZSBtdXR1YWxseSBleGNsdXNpdmUsIG9uZSBvZiB0aGVtIHNob3VsZCBiZSA/XG4gICAgcmV0dXJuIGBjcm9uKCR7bWludXRlfSAke2hvdXJ9ICogKiA/KWA7XG4gIH1cbn0iXX0=