/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.model;

public class OSMTag {
    private static final String KEY_VALUE_SEPARATOR = "=";
    private final boolean forcePolygonLine;
    private final short id;
    private final String key;
    private final boolean labelPosition;
    private final boolean renderable;
    private final String value;
    private final byte zoomAppear;

    public static OSMTag fromOSMTag(OSMTag otherTag, short newID) {
        return new OSMTag(newID, otherTag.getKey(), otherTag.getValue(), otherTag.getZoomAppear(), otherTag.isRenderable(), otherTag.isForcePolygonLine(), otherTag.isLabelPosition());
    }

    public static String tagKey(String key, String value) {
        return key + KEY_VALUE_SEPARATOR + value;
    }

    public OSMTag(short id, String key, String value, byte zoomAppear, boolean renderable, boolean forcePolygonLine, boolean labelPosition) {
        this.id = id;
        this.key = key;
        this.value = value;
        this.zoomAppear = zoomAppear;
        this.renderable = renderable;
        this.forcePolygonLine = forcePolygonLine;
        this.labelPosition = labelPosition;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OSMTag)) {
            return false;
        }
        OSMTag other = (OSMTag)obj;
        return this.id == other.id;
    }

    public final short getId() {
        return this.id;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getValue() {
        return this.value;
    }

    public final byte getZoomAppear() {
        return this.zoomAppear;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public final boolean isBuilding() {
        return this.key.equals("building");
    }

    public final boolean isBuildingPart() {
        return this.key.equals("building:part");
    }

    public final boolean isCoastline() {
        return this.key.equals("natural") && this.value.equals("coastline");
    }

    public final boolean isForcePolygonLine() {
        return this.forcePolygonLine;
    }

    public boolean isLabelPosition() {
        return this.labelPosition;
    }

    public final boolean isRenderable() {
        return this.renderable;
    }

    public final String tagKey() {
        return this.key + KEY_VALUE_SEPARATOR + this.value;
    }

    public final String toString() {
        return "OSMTag [id=" + this.id + ", key=" + this.key + ", value=" + this.value + ", zoomAppear=" + this.zoomAppear + ", renderable=" + this.renderable + ", labelPosition=" + this.labelPosition + "]";
    }
}

