/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.GenericObjectSerializationFactory;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class EntitySorter
implements SinkSource {
    private FileBasedSort<EntityContainer> fileBasedSort;
    private Sink sink;

    public EntitySorter(Comparator<EntityContainer> comparator) {
        this(comparator, true);
    }

    public EntitySorter(Comparator<EntityContainer> comparator, boolean useCompression) {
        this.fileBasedSort = new FileBasedSort<EntityContainer>(new GenericObjectSerializationFactory(), comparator, useCompression);
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        this.sink.initialize(metaData);
    }

    @Override
    public void process(EntityContainer entityContainer) {
        this.fileBasedSort.add(entityContainer);
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void complete() {
        try (ReleasableIterator<EntityContainer> iterator = this.fileBasedSort.iterate();){
            while (iterator.hasNext()) {
                this.sink.process((EntityContainer)iterator.next());
            }
            this.sink.complete();
        }
    }

    @Override
    public void close() {
        this.fileBasedSort.close();
        this.sink.close();
    }
}

