/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.database;

import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;

public class DbOrderedFeature<T extends Storeable>
extends DbFeature<T> {
    private int sequenceId;

    public DbOrderedFeature(long entityId, T feature, int sequenceId) {
        super(entityId, feature);
        this.sequenceId = sequenceId;
    }

    public DbOrderedFeature(StoreReader sr, StoreClassRegister scr) {
        super(sr, scr);
        this.sequenceId = sr.readInteger();
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        super.store(sw, scr);
        sw.writeInteger(this.sequenceId);
    }

    public int getSequenceId() {
        return this.sequenceId;
    }
}

