/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.database.DbFeatureHistory;
import org.openstreetmap.osmosis.core.database.FeatureCollectionLoader;
import org.openstreetmap.osmosis.core.database.FeaturePopulator;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.PeekableIterator;
import org.openstreetmap.osmosis.core.store.Storeable;

public class FeatureHistoryPopulator<Te extends Entity, Tf extends Storeable, Tdbf extends DbFeature<Tf>>
implements FeaturePopulator<Te> {
    private PeekableIterator<DbFeatureHistory<Tdbf>> source;
    private FeatureCollectionLoader<Te, Tf> featureLoader;

    public FeatureHistoryPopulator(ReleasableIterator<DbFeatureHistory<Tdbf>> source, FeatureCollectionLoader<Te, Tf> featureLoader) {
        this.source = new PeekableIterator(source);
        this.featureLoader = featureLoader;
    }

    public void populateFeatures(Te entity) {
        while (this.source.hasNext() && ((DbFeature)((DbFeatureHistory)this.source.peekNext()).getFeature()).getEntityId() == entity.getId() && ((DbFeatureHistory)this.source.peekNext()).getVersion() == entity.getVersion()) {
            this.featureLoader.getFeatureCollection(entity).add(((DbFeature)((DbFeatureHistory)this.source.next()).getFeature()).getFeature());
        }
    }

    public void close() {
        this.source.close();
    }
}

