/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.List;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistory;
import org.openstreetmap.osmosis.apidb.v0_6.impl.FeatureHistoryPopulator;
import org.openstreetmap.osmosis.apidb.v0_6.impl.TagCollectionLoader;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.database.DbFeatureHistory;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;

public class EntityHistoryReader<T extends Entity>
implements ReleasableIterator<EntityHistory<T>> {
    private ReleasableContainer releasableContainer = new ReleasableContainer();
    private ReleasableIterator<EntityHistory<T>> entityIterator;
    private FeatureHistoryPopulator<T, Tag, ?> tagPopulator;
    private List<FeatureHistoryPopulator<T, ?, ?>> featurePopulators;
    private EntityHistory<T> nextValue;

    public EntityHistoryReader(ReleasableIterator<EntityHistory<T>> entityIterator, ReleasableIterator<DbFeatureHistory<DbFeature<Tag>>> tagIterator, List<FeatureHistoryPopulator<T, ?, ?>> featurePopulators) {
        this.entityIterator = (ReleasableIterator)this.releasableContainer.add(entityIterator);
        this.tagPopulator = (FeatureHistoryPopulator)this.releasableContainer.add(new FeatureHistoryPopulator(tagIterator, new TagCollectionLoader()));
        for (FeatureHistoryPopulator<T, ?, ?> featurePopulator : featurePopulators) {
            this.releasableContainer.add(featurePopulator);
        }
        this.featurePopulators = featurePopulators;
    }

    private EntityHistory<T> readNextEntityHistory() {
        EntityHistory entityHistory = (EntityHistory)this.entityIterator.next();
        Entity entity = (Entity)entityHistory.getEntity();
        this.tagPopulator.populateFeatures((T)entity);
        for (FeatureHistoryPopulator<T, ?, ?> populator : this.featurePopulators) {
            populator.populateFeatures((T)entity);
        }
        return entityHistory;
    }

    public boolean hasNext() {
        while (this.nextValue == null && this.entityIterator.hasNext()) {
            this.nextValue = this.readNextEntityHistory();
        }
        return this.nextValue != null;
    }

    public EntityHistory<T> next() {
        if (!this.hasNext()) {
            throw new OsmosisRuntimeException("No records are available, call hasNext first.");
        }
        EntityHistory<T> result = this.nextValue;
        this.nextValue = null;
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.releasableContainer.close();
    }
}

