/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.util.CharsetUtil;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceServerControl;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceServerHandler;

public class SequenceNumberServerHandler
extends SequenceServerHandler {
    public SequenceNumberServerHandler(SequenceServerControl control) {
        super(control);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleRequest(ChannelHandlerContext ctx, HttpRequest request) {
        boolean follow;
        long nextSequenceNumber;
        String sequenceNumberUri = "sequenceNumber";
        String contentType = "text/plain";
        String uri = request.getUri();
        if (!uri.startsWith("/")) {
            throw new OsmosisRuntimeException("Uri doesn't start with a / character: " + uri);
        }
        LinkedList<String> uriElements = new LinkedList<String>(Arrays.asList(uri.split("/")));
        if (uriElements.size() > 0) {
            uriElements.remove();
        }
        if (uriElements.isEmpty() || !"sequenceNumber".equals(uriElements.remove())) {
            throw new SequenceServerHandler.ResourceNotFoundException();
        }
        if (uriElements.isEmpty()) {
            throw new SequenceServerHandler.ResourceNotFoundException();
        }
        String sequenceStartString = (String)uriElements.remove();
        if ("current".equals(sequenceStartString)) {
            nextSequenceNumber = this.getControl().getLatestSequenceNumber();
        } else {
            try {
                nextSequenceNumber = Long.parseLong(sequenceStartString);
            }
            catch (NumberFormatException e) {
                throw new SequenceServerHandler.BadRequestException("Requested sequence number of " + sequenceStartString + " is not a number.");
            }
        }
        if (!uriElements.isEmpty()) {
            String tailElement = (String)uriElements.remove();
            if (!"tail".equals(tailElement)) throw new SequenceServerHandler.ResourceNotFoundException();
            follow = true;
        } else {
            follow = false;
        }
        if (!uriElements.isEmpty()) {
            throw new SequenceServerHandler.ResourceNotFoundException();
        }
        this.initiateSequenceWriting(ctx, "text/plain", nextSequenceNumber, follow);
    }

    @Override
    protected void writeSequence(ChannelHandlerContext ctx, ChannelFuture future, long sequenceNumber) {
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)Long.toString(sequenceNumber), (Charset)CharsetUtil.UTF_8);
        DefaultHttpChunk chunk = new DefaultHttpChunk(buffer);
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)chunk);
    }
}

