# This file is part of the Reproducible and Reusable Data Analysis Workflow
# Server (flowServ).
#
# Copyright (C) 2019-2021 NYU.
#
# flowServ is free software; you can redistribute it and/or modify it under the
# terms of the MIT License; see LICENSE file for more details.

"""Handle for remote workflows. Maintains at least the remote workflow
identifier, the output files that will be generated be a successful workflow
ru, as well as the last reported workflow state.
"""


class RemoteWorkflowObject(object):
    """Base class for remote workflow handles. Remote workflows may have an
    identifier that differs from the run identifier that is managed by
    flowServ. The remote identifier is maintained by the handle, together with
    the last reported workflow state, and the list of output files that are
    generated by successful workflow runs. The names of output files are path
    that are relative to the root directory of the remote environment that
    executes the workflow.
    """
    def __init__(self, workflow_id, state, output_files):
        """Initialize thw remote workflow identifier and the last reported
        workflow state.

        Parameters
        ----------
        workflow_id: string
            Unique identifier for the remote workflow.
        state: flowserv.model.workflow.state.WorkflowState
            Last reported state of the remote forkflow.
        output_files: list(string)
            Identifier (relative paths) of the generated output files
        """
        self.workflow_id = workflow_id
        self.state = state
        self._output_files = output_files

    def output_files(self):
        """Get list of output files.

        Returns
        -------
        list(string)
        """
        return self._output_files
