import requests
import json
from requests.auth import HTTPBasicAuth
from os import environ
import random
import string

headers = {'Content-Type': 'application/json'}

class Instance:
    from os import environ
    def __init__(self,
                 rabbitmq_host=environ.get('RABBITMQ_HOST') or '127.0.0.1',
                 rabbitmq_port=environ.get('RABBITMQ_PORT') or '15672',
                 rabbitmq_admin_user=environ.get('RABBITMQ_ADMIN_USER') or 'guest',
                 rabbitmq_admin_password=environ.get('RABBITMQ_ADMIN_PASSWORD)') or 'guest',
                 rabbitmq_tls_enabled=environ.get('RABBITMQ_TLS_ENABLED') or False
                 ):
        if rabbitmq_tls_enabled:
            rabbitmq_scheme = 'https://'
        else:
            rabbitmq_scheme = 'http://'
        self.rabbitmq_baseurl = rabbitmq_scheme + rabbitmq_host + ':' + str(rabbitmq_port) + '/api'
        self.rabbitmq_auth = HTTPBasicAuth(rabbitmq_admin_user, rabbitmq_admin_password)
    class VirtualHost:
        @staticmethod
        def create(vhost):
            http_method = 'PUT'
            description = f"Description_for_{vhost}"
            tags = f"Tags_{vhost}"
            service = 'vhosts'
            data = {
                'description': description,
                'tags': tags
            }
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{vhost}"
            auth = Instance().rabbitmq_auth
            print(f"Talking to URL: {url}")
            r = requests.request(http_method, url,data=json.dumps(data),headers=headers,auth=auth)
            print(r.status_code)

        @staticmethod
        def delete(vhost):
            http_method = 'DELETE'
            service = 'vhosts'
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{vhost}"
            print(f"Talking to URL: {url}")
            r = requests.request(http_method, url, headers=headers,auth=auth)
            print(r.status_code)
    class User:
        @staticmethod
        def create(user, password=None):
            http_method = 'PUT'
            tags = f"Tags-{user}"
            service = 'users'
            if password is None:
                password = ''.join(random.choice(string.ascii_letters + string.digits) for _ in range(16))
                print(f"Generating password for user: {user}, password: {password}")
            data = {
                'password': password,
                'tags': tags
            }
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{user}"
            print(f"Talking to URL: {baseurl}, {url}")
            r = requests.request(http_method, url, data=json.dumps(data), headers=headers,auth=auth)
            print(r.status_code)

        @staticmethod
        def delete(user):
            http_method = 'DELETE'
            service = 'users'
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{user}"
            print(f"Talking to URL: {baseurl}, {url}")
            r = requests.request(http_method, url, headers=headers,auth=auth)
            print(r.status_code)
    class Exchange:
        @staticmethod
        def create(vhost=None, exchange=None, exchange_type=None, durable=True):
            # /api/exchanges/vhost/name
            if exchange_type not in ["direct", "fanout", "topic"]:
                exchange_type = 'fanout'
            http_method = 'PUT'
            service = 'exchanges'
            data = {
                "type": exchange_type,
                "auto_delete": False,
                "durable": durable,
                "internal": False,
                "arguments": {}
            }
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{vhost}/{exchange}"
            print(f"Talking to URL: {url}")
            r = requests.request(http_method, url, data=json.dumps(data), headers=headers,auth=auth)
            print(r.status_code)
        @staticmethod
        def delete(vhost=None,exchange=None):
            http_method = 'DELETE'
            service = 'exchanges'
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{vhost}/{exchange}"
            print(f"Talking to URL: {url}")
            r = requests.request(http_method, url, headers=headers,auth=auth)
            print(r.status_code)
    class Queue:
        # /api/queues/vhost/name
        @staticmethod
        def create(vhost=None, queue=None, durable=True):
            http_method = 'PUT'
            service = 'queues'
            data = {
                "auto_delete": False,
                "durable": durable,
                "arguments": {}
            }
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{vhost}/{queue}"
            print(f"Talking to URL: {url}")
            r = requests.request(http_method, url, data=json.dumps(data), headers=headers,auth=auth)
            print(r.status_code)
        @staticmethod
        def delete(vhost=None,queue=None):
            http_method = 'DELETE'
            service = 'queues'
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{vhost}/{queue}"
            print(f"Talking to URL: {url}")
            r = requests.request(http_method, url, headers=headers,auth=auth)
            print(r.status_code)
    class Binding:
        #/api/bindings/$vhost/e/$exchange/q/$queue
        @staticmethod
        def create(vhost=None, exchange=None, queue=None, routing_key=None):
            http_method = 'POST'
            service = 'bindings'
            if routing_key is None:
                routing_key = f"routing_key-{queue}"
            data = {
                "routing_key": routing_key,
                "arguments": {}
            }
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{vhost}/e/{exchange}/q/{queue}"
            print(f"Talking to URL: {url}")
            r = requests.request(http_method, url, data=json.dumps(data), headers=headers,auth=auth)
            print(r.status_code)
        @staticmethod
        def delete(vhost=None, exchange=None, queue=None, routing_key=None):
            # /api/bindings/$vhost/e/$exchange/q/$queue/${routing_key}
            http_method = 'DELETE'
            service = 'bindings'
            auth = Instance().rabbitmq_auth
            baseurl = Instance().rabbitmq_baseurl
            url = f"{baseurl}/{service}/{vhost}/e/{exchange}/q/{queue}/{routing_key}"
            print(f"Talking to URL: {url}")
            r = requests.request(http_method, url, headers=headers,auth=auth)
            print(r.status_code)