# pyrabbitmq

### Scenarios
The library is not proposed with same functions as 'pika'.
It helps to initialize a rabbitmq instance via its native API in following cases:
- Many rabbitmq instances to be kicked via scripts but not its management UI, or
- For some reason you need reset rabbitmq instances more often.

Good Luck.

### Usage

```python
from pyrabbitmq import connection

# rmq = connection.Instance(
#     rabbitmq_host="127.0.0.1",
#     rabbitmq_port="5673",
#     rabbitmq_admin_user="guest",
#     rabbitmq_admin_password="guest",
#     rabbitmq_tls_enabled=False
# )

# It reads the rabbitmq os $env values. 
# If no $env variables find, default values used..
rmq = connection.Instance()

# Virtual Hosts
v = rmq.VirtualHost
v.create('a-vhost-name')
v.delete('a-vhost-name')

# Users
u = rmq.User
u.create('test-user','test-user-password')
u.delete('test-user')

# Queues
q = rmq.Queue
q.create(vhost='vhost01', queue='queue01')
q.delete(vhost='vhost01', queue='queue01')

# Bindings
b = rmq.Binding
b.create(vhost='vhost01',exchange='exchange01', queue='queue01')
b.delete(vhost='vhost01',exchange='exchange01',queue='queue01',routing_key='routing_key-queue01')


```