import os
import responses
from tests.unit.test_wrapper import TestWrapper
from wotapi.action.vehicles_statistics import VehicleStatisticsData
from wotapi.orm.data_model import VehiclesStatisticsModel


class TestVehiclesStatisticsData(TestWrapper):

    @responses.activate
    def test_etl_data(self):
        responses.add(
            responses.GET,
            'https://api.worldoftanks.eu/wot/tanks/stats/',
            json=self.mock_response_vehicles_statistics(),
            status=200
        )

        p = VehicleStatisticsData()
        data = p.etl_data(
            application_id=self.test_application_id,
            account_id=self.test_account_id,
            token=self.test_token,
            load_to_db=False,
            realm=self.test_realm,
            db_path=os.getcwd()
        )
        print(data)
        expected_data = [{'statistics_data': [
            {'account_id': 'mock_account_id', 'battle_type': 'clan', 'spotted': 0, 'battles_on_stunning_vehicles': 0,
             'max_xp': 2230, 'xp': 0, 'survived_battles': 0, 'dropped_capture_points': 0, 'hits_percents': 0,
             'draws': 0, 'battles': 0, 'damage_received': 0, 'frags': 0, 'stun_number': 0, 'capture_points': 0,
             'stun_assisted_damage': 0, 'max_damage': 0, 'hits': 0, 'battle_avg_xp': 0, 'wins': 0, 'losses': 0,
             'damage_dealt': 0, 'max_frags': 9, 'shots': 0, 'direct_hits_received': None, 'explosion_hits': None,
             'piercings_received': None, 'piercings': None, 'no_damage_direct_hits_received': None,
             'explosion_hits_received': None, 'tanking_factor': None, 'avg_damage_blocked': None, 'mark_of_mastery': 4,
             'in_garage': True, 'tank_id': 8993},
            {'account_id': 'mock_account_id', 'battle_type': 'all', 'spotted': 1029, 'battles_on_stunning_vehicles': 0,
             'max_xp': 2230, 'xp': 634958, 'survived_battles': 260, 'dropped_capture_points': 814, 'hits_percents': 76,
             'draws': 7, 'battles': 921, 'damage_received': 1359820, 'frags': 1024, 'stun_number': 0,
             'capture_points': 347, 'stun_assisted_damage': 0, 'max_damage': None, 'hits': 7371, 'battle_avg_xp': 689,
             'wins': 454, 'losses': 460, 'damage_dealt': 1682530, 'max_frags': 9, 'shots': 9666,
             'direct_hits_received': 4879, 'explosion_hits': 2, 'piercings_received': 3902, 'piercings': 5043,
             'no_damage_direct_hits_received': 970, 'explosion_hits_received': 285, 'tanking_factor': 0.19,
             'avg_damage_blocked': 275.15, 'mark_of_mastery': 4, 'in_garage': True, 'tank_id': 8993},
            {'account_id': 'mock_account_id', 'battle_type': 'regular_team', 'spotted': 0,
             'battles_on_stunning_vehicles': 0, 'max_xp': 2230, 'xp': 0, 'survived_battles': 0,
             'dropped_capture_points': 0, 'hits_percents': 0, 'draws': 0, 'battles': 0, 'damage_received': 0,
             'frags': 0, 'stun_number': 0, 'capture_points': 0, 'stun_assisted_damage': 0, 'max_damage': 0, 'hits': 0,
             'battle_avg_xp': 0, 'wins': 0, 'losses': 0, 'damage_dealt': 0, 'max_frags': 9, 'shots': 0,
             'direct_hits_received': None, 'explosion_hits': None, 'piercings_received': None, 'piercings': None,
             'no_damage_direct_hits_received': None, 'explosion_hits_received': None, 'tanking_factor': None,
             'avg_damage_blocked': None, 'mark_of_mastery': 4, 'in_garage': True, 'tank_id': 8993},
            {'account_id': 'mock_account_id', 'battle_type': 'company', 'spotted': 0, 'battles_on_stunning_vehicles': 0,
             'max_xp': 2230, 'xp': 0, 'survived_battles': 0, 'dropped_capture_points': 0, 'hits_percents': 0,
             'draws': 0, 'battles': 0, 'damage_received': 0, 'frags': 0, 'stun_number': 0, 'capture_points': 0,
             'stun_assisted_damage': 0, 'max_damage': None, 'hits': 0, 'battle_avg_xp': 0, 'wins': 0, 'losses': 0,
             'damage_dealt': 0, 'max_frags': 9, 'shots': 0, 'direct_hits_received': None, 'explosion_hits': None,
             'piercings_received': None, 'piercings': None, 'no_damage_direct_hits_received': None,
             'explosion_hits_received': None, 'tanking_factor': None, 'avg_damage_blocked': None, 'mark_of_mastery': 4,
             'in_garage': True, 'tank_id': 8993},
            {'account_id': 'mock_account_id', 'battle_type': 'stronghold_skirmish', 'spotted': 0,
             'battles_on_stunning_vehicles': 0, 'max_xp': 2230, 'xp': 0, 'survived_battles': 0,
             'dropped_capture_points': 0, 'hits_percents': 0, 'draws': 0, 'battles': 0, 'damage_received': 0,
             'frags': 0, 'stun_number': 0, 'capture_points': 0, 'stun_assisted_damage': 0, 'max_damage': 0, 'hits': 0,
             'battle_avg_xp': 0, 'wins': 0, 'losses': 0, 'damage_dealt': 0, 'max_frags': 9, 'shots': 0,
             'direct_hits_received': 0, 'explosion_hits': 0, 'piercings_received': 0, 'piercings': 0,
             'no_damage_direct_hits_received': 0, 'explosion_hits_received': 0, 'tanking_factor': 0.0,
             'avg_damage_blocked': None, 'mark_of_mastery': 4, 'in_garage': True, 'tank_id': 8993},
            {'account_id': 'mock_account_id', 'battle_type': 'stronghold_defense', 'spotted': 0,
             'battles_on_stunning_vehicles': 0, 'max_xp': 2230, 'xp': 0, 'survived_battles': 0,
             'dropped_capture_points': 0, 'hits_percents': 0, 'draws': 0, 'battles': 0, 'damage_received': 0,
             'frags': 0, 'stun_number': 0, 'capture_points': 0, 'stun_assisted_damage': 0, 'max_damage': 0, 'hits': 0,
             'battle_avg_xp': 0, 'wins': 0, 'losses': 0, 'damage_dealt': 0, 'max_frags': 9, 'shots': 0,
             'direct_hits_received': 0, 'explosion_hits': 0, 'piercings_received': 0, 'piercings': 0,
             'no_damage_direct_hits_received': 0, 'explosion_hits_received': 0, 'tanking_factor': 0.0,
             'avg_damage_blocked': None, 'mark_of_mastery': 4, 'in_garage': True, 'tank_id': 8993},
            {'account_id': 'mock_account_id', 'battle_type': 'globalmap', 'spotted': 0,
             'battles_on_stunning_vehicles': 0, 'max_xp': 2230, 'xp': 0, 'survived_battles': 0,
             'dropped_capture_points': 0, 'hits_percents': 0, 'draws': 0, 'battles': 0, 'damage_received': 0,
             'frags': 0, 'stun_number': 0, 'capture_points': 0, 'stun_assisted_damage': 0, 'max_damage': None,
             'hits': 0, 'battle_avg_xp': 0, 'wins': 0, 'losses': 0, 'damage_dealt': 0, 'max_frags': 9, 'shots': 0,
             'direct_hits_received': 0, 'explosion_hits': 0, 'piercings_received': 0, 'piercings': 0,
             'no_damage_direct_hits_received': 0, 'explosion_hits_received': 0, 'tanking_factor': 0.0,
             'avg_damage_blocked': 0.0, 'mark_of_mastery': 4, 'in_garage': True, 'tank_id': 8993},
            {'account_id': 'mock_account_id', 'battle_type': 'team', 'spotted': 0, 'battles_on_stunning_vehicles': 0,
             'max_xp': 2230, 'xp': 0, 'survived_battles': 0, 'dropped_capture_points': 0, 'hits_percents': 0,
             'draws': 0, 'battles': 0, 'damage_received': 0, 'frags': 0, 'stun_number': 0, 'capture_points': 0,
             'stun_assisted_damage': 0, 'max_damage': 0, 'hits': 0, 'battle_avg_xp': 0, 'wins': 0, 'losses': 0,
             'damage_dealt': 0, 'max_frags': 9, 'shots': 0, 'direct_hits_received': None, 'explosion_hits': None,
             'piercings_received': None, 'piercings': None, 'no_damage_direct_hits_received': None,
             'explosion_hits_received': None, 'tanking_factor': None, 'avg_damage_blocked': None, 'mark_of_mastery': 4,
             'in_garage': True, 'tank_id': 8993}], 'frags_data': [
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3921', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2961', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2849', 'frags': 14},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5713', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '17473', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2657', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '64065', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '15393', 'frags': 12},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2097', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7953', 'frags': 12},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4225', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5457', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7457', 'frags': 11},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13089', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '55297', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13569', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4145', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '63793', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5377', 'frags': 28},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1073', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4385', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16161', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3857', 'frags': 9},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7697', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10817', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '62785', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '817', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13841', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11025', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16673', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14353', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8225', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14673', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '50961', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '6465', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '64561', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '57121', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '15425', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3137', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3649', 'frags': 17},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7969', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '54289', 'frags': 12},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7441', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4737', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '6657', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5185', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11537', 'frags': 12},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13313', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '18449', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '12305', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '17953', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5697', 'frags': 16},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8705', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '59649', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1665', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10753', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8977', 'frags': 9},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13857', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '18177', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '19201', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13889', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1921', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8529', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '273', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '18961', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '6145', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10513', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '64049', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '22017', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '21505', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '51361', 'frags': 10},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '52097', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2305', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7249', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5969', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '12097', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '18241', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11601', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2177', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8737', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8961', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5681', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '529', 'frags': 11},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16129', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2417', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16897', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16657', 'frags': 14},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '15953', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4193', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '305', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3153', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '50193', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '9489', 'frags': 10},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '19969', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10785', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16401', 'frags': 23},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4353', 'frags': 13},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14337', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11009', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1297', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '15681', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7425', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '55633', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8721', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '513', 'frags': 11},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2161', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11297', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4113', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '9249', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '59169', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '59905', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '20737', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2593', 'frags': 12},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16641', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14609', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '15649', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4433', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8465', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5137', 'frags': 17},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '48641', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1905', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '63297', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10257', 'frags': 12},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10001', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8193', 'frags': 10},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3217', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2209', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1585', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '57377', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '18753', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '55313', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1121', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7233', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10017', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '6209', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14625', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '63041', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '49665', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3873', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '9505', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '9745', 'frags': 16},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14145', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10241', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7489', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '9233', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7169', 'frags': 9},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '61713', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3377', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3681', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3889', 'frags': 12},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16417', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '57889', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '60945', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1841', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11521', 'frags': 26},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3905', 'frags': 18},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2865', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '7937', 'frags': 17},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2433', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3633', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14401', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '12369', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '12545', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '60177', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '15377', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13345', 'frags': 11},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5889', 'frags': 6},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '16913', 'frags': 9},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '58913', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '63553', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '49409', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '61761', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '12113', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '49', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11073', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4929', 'frags': 22},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '18209', 'frags': 11},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13137', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8449', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '1569', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '17217', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '5921', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '10769', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '19745', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14865', 'frags': 11},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4097', 'frags': 4},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '2721', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '61505', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '52561', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '52609', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11041', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '17665', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14161', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '12049', 'frags': 9},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '9217', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '13825', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '21249', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '17153', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '9297', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11793', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8993', 'frags': 8},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '4913', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '3425', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '64817', 'frags': 1},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '19217', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '8481', 'frags': 5},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '62017', 'frags': 3},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '14881', 'frags': 7},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '55569', 'frags': 2},
            {'account_id': 'mock_account_id', 'tank_id': 8993, 'opponent_tank_id': '11841', 'frags': 4}]}]

        self.assertListEqual(data, expected_data)

    @responses.activate
    def test_etl_data_loading_into_db(self):
        responses.add(
            responses.GET,
            'https://api.worldoftanks.eu/wot/tanks/stats/',
            json=self.mock_response_vehicles_statistics(),
            status=200
        )

        p = VehicleStatisticsData()
        p.etl_data(
            application_id=self.test_application_id,
            account_id=self.test_account_id,
            token=self.test_token,
            load_to_db=True,
            realm=self.test_realm,
            db_path=self.db_path
        )

        data_exists = self.db_loader.check_if_data_exists(model=VehiclesStatisticsModel)
        self.assertEqual(data_exists, True)
