skrm [![Coverage Status](https://coveralls.io/repos/github/PoncinMatthieu/skrm/badge.svg?branch=master)](https://coveralls.io/github/PoncinMatthieu/skrm?branch=master)
====

skrm stands for simple keyring manager.
It is a small python script allowing you to store keys associated to tags into an encrypted file, using GPG.

This is a very handy solution for unix users to store securely their passwords and retreive them quicky.

Install
-------
Use pip:
```
pip install skrm
```

User Prefs
----------
skrm uses an optional configuration file to avoid you setting every options in the command line.
Here is an exemple of userpref file that should be placed in '~/.skrm/user.prefs':

    File=/home/ponpon/.skrm/bdd.gpg
    recipient=Poncin Matthieu


Usage
-----

    usage: ./skrm [OPTIONS] [COMMANDS] [TAGS]
    skrm stands for simple keyring manager, it stores keys with tags into a file encrypted using gpg.
    skrm will ask for the master password to encrypt/decrypt the storing file.
    OPTIONS:
        -h, --help: Print usage.
        -g, --get: Return keyrings matching strictly the given tags. This option is used by default. If a keyId is selected, a get or a search return only the keyring matching the keyId.
        -s, --search: Return keyrings matching the given tags (tags are interpreted as a regex expression).
        -c, --clip: Copy the key of the last matched keyring from a get or a search into the clipboard using xclip. Nothing will be printed out to the shell.
    COMMANDS:
        --file=[FILENAME]: use the given file to read/store keyrings.
        --recipient=[USER_ID_NAME]: set the user id name for gpg to get the key and encrypt the file.
        --pass=[MASTER_PASS]: set the master pass to use when encrypting or decrypting the file.
        --add=[KEY]: add a key to the file with the specified tags.
        --select=[KEYID]: select a keyring using its key id. To use with a command like "remove" or "update".
        --remove: remove the selected key.
        --update=[KEY]: update the selected key.
        --backup=[HOSTDEST]: scp the bdd file to the given host destination.
    TAGS:
        A list of strings to define tags you want to use for any commands keyring related management.


Examples
--------
To add a new key with the associated tags: Password WebSite Twitter MyUserName

    skrm --add="myPass" Password WebSite Twitter MyUserName

To get one or multiple keys, you only need to specify the tags you want to match.
The tags are not case sensitive.

    skrm twitter
    -> 0 : ['Password', 'WebSite', 'Twitter', 'MyUserName', 'myPass']

If you don't remember the exact string for your tags, you can use the option -s

    skrm -s twit
    -> 0 : ['Password', 'WebSite', 'Twitter', 'MyUserName', 'myPass']

To copy directly your key into the clipboard

    skrm -c twitter
    -> copy the key into the clipboard.

To select a keyring, you must use its key id

    skrm --select=0
    -> 0 : ['Password', 'WebSite', 'Twitter', 'MyUserName', 'myPass']

To remove a keyring

    skrm --select=0 --remove

To update a key

    skrm --select=0 --update="MyNewPass"

To insert new tags to a keyring

    skrm --select=0 --insert=2 MyNewTag1 MyNewTag2
    -> 0 : ['Password', 'WebSite', 'Twitter', 'MyNewTag1', 'MyNewTag2', 'MyUserName', 'myPass']

To backup your bdd file to a remote server using scp

    skrm --backup="myBackupServer:~/.skrm/"

