"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrImageScanNotify = void 0;
const path = require("path");
const events = require("@aws-cdk/aws-events");
const target = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const _lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class EcrImageScanNotify extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaFun = new _lambda.Function(this, 'lambda_fun', {
            handler: 'lambda_function.lambda_handler',
            code: _lambda.Code.fromAsset(path.join(__dirname, '../function')),
            runtime: _lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(3),
            environment: {
                WEBHOOK_URL: props.webhookUrl,
                CHANNEL: props.channel,
            },
        });
        const ecrReadOnlyPolicyStatement = new iam.PolicyStatement({
            actions: ['ecr:DescribeImages'],
            resources: ['*'],
        });
        lambdaFun.role.addToPrincipalPolicy(ecrReadOnlyPolicyStatement);
        const ecrScanTarget = new target.LambdaFunction(lambdaFun);
        new events.Rule(this, 'EventBusEcrImageScan', {
            ruleName: 'EventBusEcrImageScanRule',
            description: 'ECR Scan and event to lambda to Slack',
            targets: [ecrScanTarget],
            eventPattern: {
                source: ['aws.ecr'],
                detailType: ['ECR Image Scan'],
            },
        });
    }
}
exports.EcrImageScanNotify = EcrImageScanNotify;
//# sourceMappingURL=data:application/json;base64,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