"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUserPoolAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const core_1 = require("@aws-cdk/core");
/**
 * Authorize Http Api routes on whether the requester is registered as part of
 * an AWS Cognito user pool.
 */
class HttpUserPoolAuthorizer {
    /**
     * Initialize a Cognito user pool authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param pool The user pool to use for authorization
     * @param props Properties to configure the authorizer
     */
    constructor(id, pool, props = {}) {
        this.id = id;
        this.pool = pool;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpUserPoolAuthorizerProps(props);
    }
    bind(options) {
        var _b, _c, _d, _e;
        if (!this.authorizer) {
            const region = (_b = this.props.userPoolRegion) !== null && _b !== void 0 ? _b : core_1.Stack.of(options.scope).region;
            const clients = (_c = this.props.userPoolClients) !== null && _c !== void 0 ? _c : [this.pool.addClient('UserPoolAuthorizerClient')];
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_d = this.props.identitySource) !== null && _d !== void 0 ? _d : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: (_e = this.props.authorizerName) !== null && _e !== void 0 ? _e : this.id,
                jwtAudience: clients.map((c) => c.userPoolClientId),
                jwtIssuer: `https://cognito-idp.${region}.amazonaws.com/${this.pool.userPoolId}`,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpUserPoolAuthorizer = HttpUserPoolAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpUserPoolAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpUserPoolAuthorizer", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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