"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.views = self.__class__.views(path + ["views"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.server = self.__class__.server(path + ["server"], service)
        super().__init__(path, service)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)

    class preferences(TUIMenu):
        """
        Set preferences.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.navigation = self.__class__.navigation(path + ["navigation"], service)
            self.appearance = self.__class__.appearance(path + ["appearance"], service)
            self.graphics = self.__class__.graphics(path + ["graphics"], service)
            self.meshing_workflow = self.__class__.meshing_workflow(path + ["meshing_workflow"], service)
            self.mat_pro_app = self.__class__.mat_pro_app(path + ["mat_pro_app"], service)
            self.general = self.__class__.general(path + ["general"], service)
            self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
            self.gpuapp = self.__class__.gpuapp(path + ["gpuapp"], service)
            self.simulation = self.__class__.simulation(path + ["simulation"], service)
            self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
            super().__init__(path, service)

        class navigation(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mouse_mapping = self.__class__.mouse_mapping(path + ["mouse_mapping"], service)
                super().__init__(path, service)

            class mouse_mapping(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.basic = self.__class__.basic(path + ["basic"], service)
                    self.additional = self.__class__.additional(path + ["additional"], service)
                    super().__init__(path, service)
                def mousemaptheme(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/navigation/mouse_mapping/mousemaptheme").execute(*args, **kwargs)

                class basic(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/mmb").execute(*args, **kwargs)
                    def rmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/rmb").execute(*args, **kwargs)
                    def rmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/rmbclick").execute(*args, **kwargs)
                    def lmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/lmbclick").execute(*args, **kwargs)
                    def lmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/lmb").execute(*args, **kwargs)
                    def mmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/mmbclick").execute(*args, **kwargs)

                class additional(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ctrllmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrllmbdrag").execute(*args, **kwargs)
                    def shiftmmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftmmbdrag").execute(*args, **kwargs)
                    def shiftrmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftrmbdrag").execute(*args, **kwargs)
                    def shiftlmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftlmbdrag").execute(*args, **kwargs)
                    def ctrllmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrllmbclick").execute(*args, **kwargs)
                    def ctrlmmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlmmbclick").execute(*args, **kwargs)
                    def ctrlmmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlmmbdrag").execute(*args, **kwargs)
                    def ctrlrmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlrmbclick").execute(*args, **kwargs)
                    def mouseprobe(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mouseprobe").execute(*args, **kwargs)
                    def mousewheel(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mousewheel").execute(*args, **kwargs)
                    def mousewheelsensitivity(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mousewheelsensitivity").execute(*args, **kwargs)
                    def ctrlrmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlrmbdrag").execute(*args, **kwargs)
                    def shiftmmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftmmbclick").execute(*args, **kwargs)
                    def shiftrmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftrmbclick").execute(*args, **kwargs)
                    def shiftlmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftlmbclick").execute(*args, **kwargs)
                    def reversewheeldirection(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/reversewheeldirection").execute(*args, **kwargs)

        class appearance(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.charts = self.__class__.charts(path + ["charts"], service)
                self.ansys_logo = self.__class__.ansys_logo(path + ["ansys_logo"], service)
                self.selections = self.__class__.selections(path + ["selections"], service)
                super().__init__(path, service)
            def quick_property_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/quick_property_view").execute(*args, **kwargs)
            def titles(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/titles").execute(*args, **kwargs)
            def application_font_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/application_font_size").execute(*args, **kwargs)
            def surface_emissivity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_emissivity").execute(*args, **kwargs)
            def ruler(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/ruler").execute(*args, **kwargs)
            def surface_specularity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_specularity").execute(*args, **kwargs)
            def graphics_foreground_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_foreground_color").execute(*args, **kwargs)
            def number_of_pastel_colors(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/number_of_pastel_colors").execute(*args, **kwargs)
            def graphics_background_style(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_style").execute(*args, **kwargs)
            def graphics_color_theme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_color_theme").execute(*args, **kwargs)
            def graphics_background_color2(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_color2").execute(*args, **kwargs)
            def graphics_surface_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_surface_color").execute(*args, **kwargs)
            def pastel_color_saturation(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/pastel_color_saturation").execute(*args, **kwargs)
            def graphics_title_window_framecolor(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_title_window_framecolor").execute(*args, **kwargs)
            def completer(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/completer").execute(*args, **kwargs)
            def show_model_edges(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_model_edges").execute(*args, **kwargs)
            def model_color_scheme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/model_color_scheme").execute(*args, **kwargs)
            def group_by_tree_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/group_by_tree_view").execute(*args, **kwargs)
            def custom_title_bar(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/custom_title_bar").execute(*args, **kwargs)
            def show_interface_children_zone(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_interface_children_zone").execute(*args, **kwargs)
            def graphics_partition_boundary_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_partition_boundary_color").execute(*args, **kwargs)
            def titles_border_offset(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/titles_border_offset").execute(*args, **kwargs)
            def graphics_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_view").execute(*args, **kwargs)
            def graphics_default_manual_node_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_default_manual_node_color").execute(*args, **kwargs)
            def number_of_files_recently_used(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/number_of_files_recently_used").execute(*args, **kwargs)
            def color_theme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/color_theme").execute(*args, **kwargs)
            def surface_specularity_for_contours(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_specularity_for_contours").execute(*args, **kwargs)
            def solution_mode_edge_color_in_meshing_mode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/solution_mode_edge_color_in_meshing_mode").execute(*args, **kwargs)
            def graphics_wall_face_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_wall_face_color").execute(*args, **kwargs)
            def pastel_color_value(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/pastel_color_value").execute(*args, **kwargs)
            def graphics_edge_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_edge_color").execute(*args, **kwargs)
            def graphics_background_color1(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_color1").execute(*args, **kwargs)
            def show_enabled_models(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_enabled_models").execute(*args, **kwargs)
            def axis_triad(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/axis_triad").execute(*args, **kwargs)
            def graphics_default_manual_face_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_default_manual_face_color").execute(*args, **kwargs)
            def default_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/default_view").execute(*args, **kwargs)

            class charts(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.font = self.__class__.font(path + ["font"], service)
                    self.text_color = self.__class__.text_color(path + ["text_color"], service)
                    super().__init__(path, service)
                def plots_behavior(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/plots_behavior").execute(*args, **kwargs)
                def modern_plots_points_threshold(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/modern_plots_points_threshold").execute(*args, **kwargs)
                def legend_visibility(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/legend_visibility").execute(*args, **kwargs)
                def legend_alignment(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/legend_alignment").execute(*args, **kwargs)
                def enable_open_glfor_modern_plots(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/enable_open_glfor_modern_plots").execute(*args, **kwargs)
                def print_residuals_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/print_residuals_data").execute(*args, **kwargs)
                def modern_plots_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/modern_plots_enabled").execute(*args, **kwargs)
                def curve_colors(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/curve_colors").execute(*args, **kwargs)
                def print_plot_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/print_plot_data").execute(*args, **kwargs)
                def tooltip_interpolation(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/tooltip_interpolation").execute(*args, **kwargs)
                def threshold(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/threshold").execute(*args, **kwargs)

                class font(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def title(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/title").execute(*args, **kwargs)
                    def axes_titles(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/axes_titles").execute(*args, **kwargs)
                    def legend(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/legend").execute(*args, **kwargs)
                    def axes(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/axes").execute(*args, **kwargs)

                class text_color(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def title(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/title").execute(*args, **kwargs)
                    def axes(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/axes").execute(*args, **kwargs)
                    def legend(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/legend").execute(*args, **kwargs)
                    def axes_titles(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/axes_titles").execute(*args, **kwargs)

            class ansys_logo(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def visible(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/ansys_logo/visible").execute(*args, **kwargs)
                def color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/ansys_logo/color").execute(*args, **kwargs)

            class selections(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def highlight_edge_weight(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_edge_weight").execute(*args, **kwargs)
                def highlight_specular_component(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_specular_component").execute(*args, **kwargs)
                def highlight_edge_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_edge_color").execute(*args, **kwargs)
                def highlight_transparency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_transparency").execute(*args, **kwargs)
                def probe_tooltip_show_delay_timer(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/probe_tooltip_show_delay_timer").execute(*args, **kwargs)
                def general_displacement(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/general_displacement").execute(*args, **kwargs)
                def highlight_face_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_face_color").execute(*args, **kwargs)
                def probe_tooltip_hide_delay_timer(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/probe_tooltip_hide_delay_timer").execute(*args, **kwargs)
                def mouse_over_highlight_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/mouse_over_highlight_enabled").execute(*args, **kwargs)
                def mouse_hover_probe_values_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/mouse_hover_probe_values_enabled").execute(*args, **kwargs)
                def highlight_gloss(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_gloss").execute(*args, **kwargs)

        class graphics(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.lighting = self.__class__.lighting(path + ["lighting"], service)
                self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                self.material_effects = self.__class__.material_effects(path + ["material_effects"], service)
                self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
                self.meshing_mode = self.__class__.meshing_mode(path + ["meshing_mode"], service)
                self.boundary_markers = self.__class__.boundary_markers(path + ["boundary_markers"], service)
                self.colormap_settings = self.__class__.colormap_settings(path + ["colormap_settings"], service)
                self.performance = self.__class__.performance(path + ["performance"], service)
                self.manage_hoops_memory = self.__class__.manage_hoops_memory(path + ["manage_hoops_memory"], service)
                self.export_video_settings = self.__class__.export_video_settings(path + ["export_video_settings"], service)
                self.hardcopy_settings = self.__class__.hardcopy_settings(path + ["hardcopy_settings"], service)
                self.transparency = self.__class__.transparency(path + ["transparency"], service)
                self.graphics_effects = self.__class__.graphics_effects(path + ["graphics_effects"], service)
                super().__init__(path, service)
            def double_buffering(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/double_buffering").execute(*args, **kwargs)
            def marker_drawing_mode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/marker_drawing_mode").execute(*args, **kwargs)
            def switch_to_open_glfor_remote_visualization(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/switch_to_open_glfor_remote_visualization").execute(*args, **kwargs)
            def force_key_frame_animation_markers_to_off(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/force_key_frame_animation_markers_to_off").execute(*args, **kwargs)
            def event_poll_timeout(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/event_poll_timeout").execute(*args, **kwargs)
            def show_hidden_surfaces(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/show_hidden_surfaces").execute(*args, **kwargs)
            def hidden_surface_removal_method(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/hidden_surface_removal_method").execute(*args, **kwargs)
            def point_tool_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/point_tool_size").execute(*args, **kwargs)
            def higher_resolution_graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/higher_resolution_graphics_window_line_width").execute(*args, **kwargs)
            def remove_partition_lines_tolerance(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/remove_partition_lines_tolerance").execute(*args, **kwargs)
            def remove_partition_lines(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/remove_partition_lines").execute(*args, **kwargs)
            def max_graphics_text_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/max_graphics_text_size").execute(*args, **kwargs)
            def test_use_external_function(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/test_use_external_function").execute(*args, **kwargs)
            def graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/graphics_window_line_width").execute(*args, **kwargs)
            def graphics_window_point_symbol(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/graphics_window_point_symbol").execute(*args, **kwargs)
            def animation_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/animation_option").execute(*args, **kwargs)
            def event_poll_interval(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/event_poll_interval").execute(*args, **kwargs)
            def plot_legend_margin(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/plot_legend_margin").execute(*args, **kwargs)
            def enable_non_object_based_workflow(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/enable_non_object_based_workflow").execute(*args, **kwargs)
            def set_camera_normal_to_surface_increments(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/set_camera_normal_to_surface_increments").execute(*args, **kwargs)
            def text_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/text_window_line_width").execute(*args, **kwargs)
            def min_graphics_text_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/min_graphics_text_size").execute(*args, **kwargs)
            def scroll_wheel_event_end_timer(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/scroll_wheel_event_end_timer").execute(*args, **kwargs)
            def lower_resolution_graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/lower_resolution_graphics_window_line_width").execute(*args, **kwargs)
            def show_hidden_lines(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/show_hidden_lines").execute(*args, **kwargs)
            def rotation_centerpoint_visible(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/rotation_centerpoint_visible").execute(*args, **kwargs)

            class lighting(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def headlight(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/headlight").execute(*args, **kwargs)
                def ambient_light_intensity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/ambient_light_intensity").execute(*args, **kwargs)
                def headlight_intensity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/headlight_intensity").execute(*args, **kwargs)
                def lighting_method(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/lighting_method").execute(*args, **kwargs)

            class vector_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def line_arrow3_dperpendicular_radius(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/line_arrow3_dperpendicular_radius").execute(*args, **kwargs)
                def arrow3_dradius2_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrow3_dradius2_factor").execute(*args, **kwargs)
                def arrowhead3_dradius1_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrowhead3_dradius1_factor").execute(*args, **kwargs)
                def arrow3_dradius1_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrow3_dradius1_factor").execute(*args, **kwargs)

            class material_effects(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def parameterization_source(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/parameterization_source").execute(*args, **kwargs)
                def decimation_filter(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/decimation_filter").execute(*args, **kwargs)
                def tiling_style(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/tiling_style").execute(*args, **kwargs)

            class embedded_windows(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def show_border_for_embedded_window(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/show_border_for_embedded_window").execute(*args, **kwargs)
                def default_embedded_windows_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/default_embedded_windows_view").execute(*args, **kwargs)
                def default_embedded_mesh_windows_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/default_embedded_mesh_windows_view").execute(*args, **kwargs)
                def save_embedded_window_layout(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/save_embedded_window_layout").execute(*args, **kwargs)

            class meshing_mode(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def graphics_window_display_timeout(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/meshing_mode/graphics_window_display_timeout").execute(*args, **kwargs)
                def graphics_window_display_timeout_value(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/meshing_mode/graphics_window_display_timeout_value").execute(*args, **kwargs)

            class boundary_markers(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def exclude_from_bounding(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/exclude_from_bounding").execute(*args, **kwargs)
                def enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/enabled").execute(*args, **kwargs)
                def color_option(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/color_option").execute(*args, **kwargs)
                def outlet_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/outlet_color").execute(*args, **kwargs)
                def marker_size_limiting_scale_multiplier(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/marker_size_limiting_scale_multiplier").execute(*args, **kwargs)
                def show_inlet_markers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/show_inlet_markers").execute(*args, **kwargs)
                def markers_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/markers_limit").execute(*args, **kwargs)
                def scale_marker(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/scale_marker").execute(*args, **kwargs)
                def marker_fraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/marker_fraction").execute(*args, **kwargs)
                def inlet_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/inlet_color").execute(*args, **kwargs)
                def show_outlet_markers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/show_outlet_markers").execute(*args, **kwargs)

            class colormap_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def major_length_to_screen_ratio_when_vertical(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/major_length_to_screen_ratio_when_vertical").execute(*args, **kwargs)
                def text_font_fixed_vertical_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_vertical_size").execute(*args, **kwargs)
                def text_behavior(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_behavior").execute(*args, **kwargs)
                def text_font_fixed_units(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_units").execute(*args, **kwargs)
                def text_font_fixed_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_size").execute(*args, **kwargs)
                def text_font_automatic_vertical_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_vertical_size").execute(*args, **kwargs)
                def alignment(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/alignment").execute(*args, **kwargs)
                def text_font_name(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_name").execute(*args, **kwargs)
                def isolines_position_offset(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/isolines_position_offset").execute(*args, **kwargs)
                def border_style(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/border_style").execute(*args, **kwargs)
                def margin_from_edge_to_screen_ratio(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/margin_from_edge_to_screen_ratio").execute(*args, **kwargs)
                def auto_refit_on_resize(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/auto_refit_on_resize").execute(*args, **kwargs)
                def text_font_fixed_horizontal_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_horizontal_size").execute(*args, **kwargs)
                def max_size_scale_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/max_size_scale_factor").execute(*args, **kwargs)
                def number_format_precision(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/number_format_precision").execute(*args, **kwargs)
                def major_length_to_screen_ratio_when_horizontal(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/major_length_to_screen_ratio_when_horizontal").execute(*args, **kwargs)
                def skip_value(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/skip_value").execute(*args, **kwargs)
                def labels(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/labels").execute(*args, **kwargs)
                def colormap(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/colormap").execute(*args, **kwargs)
                def number_format_type(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/number_format_type").execute(*args, **kwargs)
                def text_truncation_limit_for_horizontal_colormaps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_truncation_limit_for_horizontal_colormaps").execute(*args, **kwargs)
                def aspect_ratio_when_horizontal(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/aspect_ratio_when_horizontal").execute(*args, **kwargs)
                def min_size_scale_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/min_size_scale_factor").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/show_colormap").execute(*args, **kwargs)
                def text_font_automatic_horizontal_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_horizontal_size").execute(*args, **kwargs)
                def text_font_automatic_units(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_units").execute(*args, **kwargs)
                def preserve_aspect_ratio_for_hardcopy(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/preserve_aspect_ratio_for_hardcopy").execute(*args, **kwargs)
                def log_scale(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/log_scale").execute(*args, **kwargs)
                def text_font_automatic_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_size").execute(*args, **kwargs)
                def automatic_resize(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/automatic_resize").execute(*args, **kwargs)
                def levels(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/levels").execute(*args, **kwargs)
                def text_truncation_limit_for_vertical_colormaps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_truncation_limit_for_vertical_colormaps").execute(*args, **kwargs)
                def use_no_sub_windows(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/use_no_sub_windows").execute(*args, **kwargs)
                def type(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/type").execute(*args, **kwargs)
                def aspect_ratio_when_vertical(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/aspect_ratio_when_vertical").execute(*args, **kwargs)

            class performance(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.minimum_frame_rate = self.__class__.minimum_frame_rate(path + ["minimum_frame_rate"], service)
                    self.fast_display_mode = self.__class__.fast_display_mode(path + ["fast_display_mode"], service)
                    super().__init__(path, service)
                def ratio_of_target_frame_rate_to_classify_heavy_geometry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/ratio_of_target_frame_rate_to_classify_heavy_geometry").execute(*args, **kwargs)
                def ratio_of_target_frame_rate_to_declassify_heavy_geometry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/ratio_of_target_frame_rate_to_declassify_heavy_geometry").execute(*args, **kwargs)
                def optimize_for(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/optimize_for").execute(*args, **kwargs)

                class minimum_frame_rate(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def target_fps(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/target_fps").execute(*args, **kwargs)
                    def maximum_culling_threshold(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/maximum_culling_threshold").execute(*args, **kwargs)
                    def minimum_culling_threshold(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/minimum_culling_threshold").execute(*args, **kwargs)
                    def enabled(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/enabled").execute(*args, **kwargs)
                    def fixed_culling_value(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/fixed_culling_value").execute(*args, **kwargs)
                    def dynamic_adjustment(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/dynamic_adjustment").execute(*args, **kwargs)

                class fast_display_mode(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def perimeter_edges_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/perimeter_edges_shown").execute(*args, **kwargs)
                    def silhouette_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/silhouette_shown").execute(*args, **kwargs)
                    def markers_decimation(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/markers_decimation").execute(*args, **kwargs)
                    def status(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/status").execute(*args, **kwargs)
                    def nodes_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/nodes_shown").execute(*args, **kwargs)
                    def faces_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/faces_shown").execute(*args, **kwargs)
                    def transparency(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/transparency").execute(*args, **kwargs)
                    def culling(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/culling").execute(*args, **kwargs)

            class manage_hoops_memory(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/manage_hoops_memory/enabled").execute(*args, **kwargs)
                def hsfimport_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/manage_hoops_memory/hsfimport_limit").execute(*args, **kwargs)

            class export_video_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advanced_video_quality_options = self.__class__.advanced_video_quality_options(path + ["advanced_video_quality_options"], service)
                    super().__init__(path, service)
                def video_smooth_scaling(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_smooth_scaling").execute(*args, **kwargs)
                def video_resoution_y(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_resoution_y").execute(*args, **kwargs)
                def video_format(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_format").execute(*args, **kwargs)
                def video_resoution_x(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_resoution_x").execute(*args, **kwargs)
                def video_fps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_fps").execute(*args, **kwargs)
                def video_quality(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_quality").execute(*args, **kwargs)
                def video_scale(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_scale").execute(*args, **kwargs)
                def video_use_frame_resolution(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_use_frame_resolution").execute(*args, **kwargs)

                class advanced_video_quality_options(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def bitrate(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/bitrate").execute(*args, **kwargs)
                    def enable_h264(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/enable_h264").execute(*args, **kwargs)
                    def compression_method(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/compression_method").execute(*args, **kwargs)
                    def bit_rate_quality(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/bit_rate_quality").execute(*args, **kwargs)

            class hardcopy_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export_edges_for_avz(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/export_edges_for_avz").execute(*args, **kwargs)
                def save_embedded_windows_in_hardcopy(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/save_embedded_windows_in_hardcopy").execute(*args, **kwargs)
                def transparent_embedded_windows(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/transparent_embedded_windows").execute(*args, **kwargs)
                def hardcopy_driver(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardcopy_driver").execute(*args, **kwargs)
                def hardcopy_line_width(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardcopy_line_width").execute(*args, **kwargs)
                def hardware_image_accel(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardware_image_accel").execute(*args, **kwargs)
                def post_script_permission_override(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/post_script_permission_override").execute(*args, **kwargs)
                def save_embedded_hardcopies_separately(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/save_embedded_hardcopies_separately").execute(*args, **kwargs)

            class transparency(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def zsort_options(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/zsort_options").execute(*args, **kwargs)
                def depth_peeling_layers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/depth_peeling_layers").execute(*args, **kwargs)
                def quick_moves(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/quick_moves").execute(*args, **kwargs)
                def algorithm_for_modern_drivers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/algorithm_for_modern_drivers").execute(*args, **kwargs)
                def depth_peeling_preference(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/depth_peeling_preference").execute(*args, **kwargs)

            class graphics_effects(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def bloom_blur(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_blur").execute(*args, **kwargs)
                def grid_plane_size_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_size_factor").execute(*args, **kwargs)
                def update_after_mouse_release(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/update_after_mouse_release").execute(*args, **kwargs)
                def bloom_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_enabled").execute(*args, **kwargs)
                def grid_plane_offset(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_offset").execute(*args, **kwargs)
                def show_marker_reflections(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/show_marker_reflections").execute(*args, **kwargs)
                def anti_aliasing(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/anti_aliasing").execute(*args, **kwargs)
                def simple_shadows_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/simple_shadows_enabled").execute(*args, **kwargs)
                def bloom_strength(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_strength").execute(*args, **kwargs)
                def show_edge_reflections(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/show_edge_reflections").execute(*args, **kwargs)
                def grid_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_color").execute(*args, **kwargs)
                def grid_plane_count(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_count").execute(*args, **kwargs)
                def reflections_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/reflections_enabled").execute(*args, **kwargs)
                def ambient_occlusion_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_enabled").execute(*args, **kwargs)
                def grid_plane_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_enabled").execute(*args, **kwargs)
                def plane_direction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/plane_direction").execute(*args, **kwargs)
                def ambient_occlusion_strength(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_strength").execute(*args, **kwargs)
                def ambient_occlusion_quality(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_quality").execute(*args, **kwargs)
                def shadow_map_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/shadow_map_enabled").execute(*args, **kwargs)

        class meshing_workflow(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.draw_settings = self.__class__.draw_settings(path + ["draw_settings"], service)
                super().__init__(path, service)
            def temp_folder(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/temp_folder").execute(*args, **kwargs)
            def verbosity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/verbosity").execute(*args, **kwargs)
            def checkpointing_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/checkpointing_option").execute(*args, **kwargs)
            def save_checkpoint_files(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/save_checkpoint_files").execute(*args, **kwargs)
            def templates_folder(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/templates_folder").execute(*args, **kwargs)

            class draw_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def facet_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/facet_limit").execute(*args, **kwargs)
                def auto_draw(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/auto_draw").execute(*args, **kwargs)
                def face_zone_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/face_zone_limit").execute(*args, **kwargs)

        class mat_pro_app(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def beta_features(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/beta_features").execute(*args, **kwargs)
            def focus(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/focus").execute(*args, **kwargs)
            def warning(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/warning").execute(*args, **kwargs)

        class general(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def utlcreate_physics_on_mode_change(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/utlcreate_physics_on_mode_change").execute(*args, **kwargs)
            def key_behavioral_changes_message(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/key_behavioral_changes_message").execute(*args, **kwargs)
            def flow_model(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/flow_model").execute(*args, **kwargs)
            def initial_physics_volume_definitions(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/initial_physics_volume_definitions").execute(*args, **kwargs)
            def enable_parametric_study(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/enable_parametric_study").execute(*args, **kwargs)
            def laplace_auto_partition_default(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/laplace_auto_partition_default").execute(*args, **kwargs)
            def utlmode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/utlmode").execute(*args, **kwargs)
            def automatic_transcript(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/automatic_transcript").execute(*args, **kwargs)
            def advanced_partition(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/advanced_partition").execute(*args, **kwargs)
            def dock_editor(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/dock_editor").execute(*args, **kwargs)
            def default_ioformat(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/default_ioformat").execute(*args, **kwargs)
            def qaservice_message(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/qaservice_message").execute(*args, **kwargs)
            def idle_timeout(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/idle_timeout").execute(*args, **kwargs)

        class turbo_workflow(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.face_zone_settings = self.__class__.face_zone_settings(path + ["face_zone_settings"], service)
                self.graphics_settings = self.__class__.graphics_settings(path + ["graphics_settings"], service)
                self.cell_zone_settings = self.__class__.cell_zone_settings(path + ["cell_zone_settings"], service)
                super().__init__(path, service)
            def checkpointing_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/turbo_workflow/checkpointing_option").execute(*args, **kwargs)
            def save_checkpoint_files(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/turbo_workflow/save_checkpoint_files").execute(*args, **kwargs)

            class face_zone_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def outlet_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/outlet_region").execute(*args, **kwargs)
                def periodic1_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/periodic1_region").execute(*args, **kwargs)
                def inlet_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/inlet_region").execute(*args, **kwargs)
                def hub_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/hub_region").execute(*args, **kwargs)
                def interior_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/interior_region").execute(*args, **kwargs)
                def blade_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/blade_region").execute(*args, **kwargs)
                def tip1_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/tip1_region").execute(*args, **kwargs)
                def symmetry_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/symmetry_region").execute(*args, **kwargs)
                def tip2_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/tip2_region").execute(*args, **kwargs)
                def fzsearch_order(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/fzsearch_order").execute(*args, **kwargs)
                def shroud_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/shroud_region").execute(*args, **kwargs)
                def periodic2_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/periodic2_region").execute(*args, **kwargs)

            class graphics_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def auto_draw(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/graphics_settings/auto_draw").execute(*args, **kwargs)

            class cell_zone_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def czsearch_order(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/czsearch_order").execute(*args, **kwargs)
                def rotating(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/rotating").execute(*args, **kwargs)
                def stationary(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/stationary").execute(*args, **kwargs)

        class gpuapp(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def alpha_features(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/gpuapp/alpha_features").execute(*args, **kwargs)

        class simulation(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
                super().__init__(path, service)
            def local_residual_scaling(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/simulation/local_residual_scaling").execute(*args, **kwargs)
            def flow_model(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/simulation/flow_model").execute(*args, **kwargs)

            class report_definitions(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def report_plot_history_data_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/simulation/report_definitions/report_plot_history_data_size").execute(*args, **kwargs)
                def automatic_plot_file(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/simulation/report_definitions/automatic_plot_file").execute(*args, **kwargs)

        class parametric_study(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.layout_options = self.__class__.layout_options(path + ["layout_options"], service)
                self.update_options = self.__class__.update_options(path + ["update_options"], service)
                super().__init__(path, service)

            class layout_options(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def current_case_parameters(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/layout_options/current_case_parameters").execute(*args, **kwargs)
                def parametric_study_tree(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/layout_options/parametric_study_tree").execute(*args, **kwargs)

            class update_options(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable_auto_refresh(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/enable_auto_refresh").execute(*args, **kwargs)
                def capture_sim_report_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/capture_sim_report_data").execute(*args, **kwargs)
                def save_project_after_dpupdate(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/save_project_after_dpupdate").execute(*args, **kwargs)
                def auto_refresh_time(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/auto_refresh_time").execute(*args, **kwargs)
                def write_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/write_data").execute(*args, **kwargs)

    class turbo_post(TUIMenu):
        """
        Enter the turbo menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def avg_contours(self, *args, **kwargs):
            """
            Displays average contours.
            """
            return PyMenu(self.service, "/turbo_post/avg_contours").execute(*args, **kwargs)
        def xy_plot_avg(self, *args, **kwargs):
            """
            Displays average XY plots.
            """
            return PyMenu(self.service, "/turbo_post/xy_plot_avg").execute(*args, **kwargs)
        def current_topology(self, *args, **kwargs):
            """
            Sets the current turbo topology for global use.
            """
            return PyMenu(self.service, "/turbo_post/current_topology").execute(*args, **kwargs)
        def write_report(self, *args, **kwargs):
            """
            Writes the turbo report to file.
            """
            return PyMenu(self.service, "/turbo_post/write_report").execute(*args, **kwargs)
        def compute_report(self, *args, **kwargs):
            """
            Computes turbomachinery quantities.
            """
            return PyMenu(self.service, "/turbo_post/compute_report").execute(*args, **kwargs)
        def two_d_contours(self, *args, **kwargs):
            """
            Display 2d contours.
            """
            return PyMenu(self.service, "/turbo_post/two_d_contours").execute(*args, **kwargs)

    class turbo_workflow(TUIMenu):
        """
        Enter the turbo workflow menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.workflow = self.__class__.workflow(path + ["workflow"], service)
            super().__init__(path, service)

        class workflow(TUIMenu):
            """
            Enter the workflow menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def enable(self, *args, **kwargs):
                """
                Enable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/enable").execute(*args, **kwargs)
            def reset(self, *args, **kwargs):
                """
                Reset the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/reset").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/disable").execute(*args, **kwargs)

    class mesh(TUIMenu):
        """
        Enter the mesh menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.geometry = self.__class__.geometry(path + ["geometry"], service)
            self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
            self.repair_improve = self.__class__.repair_improve(path + ["repair_improve"], service)
            self.reorder = self.__class__.reorder(path + ["reorder"], service)
            self.polyhedra = self.__class__.polyhedra(path + ["polyhedra"], service)
            self.surface_mesh = self.__class__.surface_mesh(path + ["surface_mesh"], service)
            self.adapt = self.__class__.adapt(path + ["adapt"], service)
            super().__init__(path, service)
        def units(self, *args, **kwargs):
            """
            Set unit conversion factors.
            """
            return PyMenu(self.service, "/mesh/units").execute(*args, **kwargs)
        def memory_usage(self, *args, **kwargs):
            """
            Reports solver memory use.
            """
            return PyMenu(self.service, "/mesh/memory_usage").execute(*args, **kwargs)
        def quality(self, *args, **kwargs):
            """
            Displays information about the quality of the mesh in the console, including the minimum orthogonal quality and the maximum aspect ratio. The level of detail displayed depends on the setting specified for mesh/check-verbosity.
            """
            return PyMenu(self.service, "/mesh/quality").execute(*args, **kwargs)
        def size_info(self, *args, **kwargs):
            """
            Prints mesh size.
            """
            return PyMenu(self.service, "/mesh/size_info").execute(*args, **kwargs)
        def enhanced_orthogonal_quality(self, *args, **kwargs):
            """
            Enables / disables an enhanced definition when calculating the orthogonal quality. When enabled, the orthogonal quality is defined using a variety quality measures, including: the orthogonality of a face relative to a vector between the face and cell centroids; a metric that detects poor cell shape at a local edge (such as twisting and/or concavity); and the variation of normals between the faces that can be constructed from the cell face. This enhanced definition is optimal for evaluating thin prism cells.
            """
            return PyMenu(self.service, "/mesh/enhanced_orthogonal_quality").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            To apply standard set of units to all quantities.
            """
            return PyMenu(self.service, "/mesh/set_unit_system").execute(*args, **kwargs)
        def rotate(self, *args, **kwargs):
            """
            Rotates the mesh.
            """
            return PyMenu(self.service, "/mesh/rotate").execute(*args, **kwargs)
        def translate(self, *args, **kwargs):
            """
            Prompts for the translation offset in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/translate").execute(*args, **kwargs)
        def check_before_solve(self, *args, **kwargs):
            """
            The default value for mesh/check-before-solve is “no”. If mesh/check-before-solve is set to “yes”, a mesh check operation will be invoked prior to starting solver. If grid check fails, solver will be interrupted, and relevant information will be printed in the Fluent console.
            """
            return PyMenu(self.service, "/mesh/check_before_solve").execute(*args, **kwargs)
        def scale(self, *args, **kwargs):
            """
            Prompts for the scaling factors in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/scale").execute(*args, **kwargs)
        def swap_mesh_faces(self, *args, **kwargs):
            """
            Swaps mesh faces.
            """
            return PyMenu(self.service, "/mesh/swap_mesh_faces").execute(*args, **kwargs)
        def show_periodic_shadow_zones(self, *args, **kwargs):
            """
            Option to show periodic shadow zones in user interface.
            """
            return PyMenu(self.service, "/mesh/show_periodic_shadow_zones").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets the level of details that will be added to the mesh check report generated by mesh/check. A value of 0 (the default) notes when checks are being performed, but does not list them individually. A value of 1 lists the individual checks as they are performed. A value of 2 enables the availability of additional mesh field variables, lists the individual checks as they are performed, and provides additional details (for example, the location of the problem, the affected cells).  The check-verbosity text command can also be used to set the level of detail displayed in the mesh quality report generated by mesh/quality. A value of 0 (the default) or 1 lists the minimum orthogonal quality and the maximum aspect ratio. A value of 2 adds information about the zones that contain the cells with the lowest quality, and additional metrics such as the maximum cell squish index and the minimum expansion ratio.
            """
            return PyMenu(self.service, "/mesh/check_verbosity").execute(*args, **kwargs)
        def redistribute_boundary_layer(self, *args, **kwargs):
            """
            Redistributes the nodes in a boundary layer zone to achieve a desired growth rate after anisotropic adaption.
            """
            return PyMenu(self.service, "/mesh/redistribute_boundary_layer").execute(*args, **kwargs)
        def adjacency(self, *args, **kwargs):
            """
            Views and renames face zones adjacent to selected cell  zones.
            """
            return PyMenu(self.service, "/mesh/adjacency").execute(*args, **kwargs)
        def mesh_info(self, *args, **kwargs):
            """
            Prints zone information size.
            """
            return PyMenu(self.service, "/mesh/mesh_info").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs various mesh consistency checks and displays a report in the console that lists the domain extents, the volume statistics, the face area statistics, and any warnings, as well as details about the various checks and mesh failures (depending on the setting specified for mesh/check-verbosity).
            """
            return PyMenu(self.service, "/mesh/check").execute(*args, **kwargs)
        def smooth_mesh(self, *args, **kwargs):
            """
            Smooths the mesh using quality-based, Laplacian, or skewness methods.
            """
            return PyMenu(self.service, "/mesh/smooth_mesh").execute(*args, **kwargs)
        def replace(self, *args, **kwargs):
            """
            Replace mesh and interpolate data.
            """
            return PyMenu(self.service, "/mesh/replace").execute(*args, **kwargs)

        class geometry(TUIMenu):
            """
            Enter the geometry menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/mesh/geometry/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/mesh/geometry/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/mesh/geometry/delete").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display geometry.
                """
                return PyMenu(self.service, "/mesh/geometry/display").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/mesh/geometry/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/mesh/geometry/list").execute(*args, **kwargs)

        class modify_zones(TUIMenu):
            """
            Enters the zone modification menu. For a description of the items in this menu, see define/boundary-conditions/modify-zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def slit_periodic(self, *args, **kwargs):
                """
                Slit a periodic zone into two symmetry zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_periodic").execute(*args, **kwargs)
            def sep_face_zone_region(self, *args, **kwargs):
                """
                Separate a face zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
            def slit_interior_between_diff_solids(self, *args, **kwargs):
                """
                Slit interior created between different solids into coupled walls.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
            def create_periodic_interface(self, *args, **kwargs):
                """
                Create a conformal or non-conformal periodic interface.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_periodic_interface").execute(*args, **kwargs)
            def extrude_face_zone_delta(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a list of deltas.
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
            def sep_cell_zone_region(self, *args, **kwargs):
                """
                Separate a cell zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
            def delete_cell_zone(self, *args, **kwargs):
                """
                Delete a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_cell_zone").execute(*args, **kwargs)
            def copy_move_cell_zone(self, *args, **kwargs):
                """
                Copy and translate or rotate a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
            def fuse_face_zones(self, *args, **kwargs):
                """
                Attempt to fuse zones by removing duplicate faces and nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/fuse_face_zones").execute(*args, **kwargs)
            def sep_face_zone_angle(self, *args, **kwargs):
                """
                Separate a face zone based on significant angle.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
            def extrude_face_zone_para(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
            def matching_tolerance(self, *args, **kwargs):
                """
                Set the normalized tolerance used for finding coincident nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/matching_tolerance").execute(*args, **kwargs)
            def merge_zones(self, *args, **kwargs):
                """
                Merge zones of the same type and condition into one.
                """
                return PyMenu(self.service, "/mesh/modify_zones/merge_zones").execute(*args, **kwargs)
            def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                """
                Change all solid zones motion specification from MRF to solid motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
            def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
            def create_all_shell_threads(self, *args, **kwargs):
                """
                Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
            def sep_face_zone_mark(self, *args, **kwargs):
                """
                Separate a face zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
            def scale_zone(self, *args, **kwargs):
                """
                Scale nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/scale_zone").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_name").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_type").execute(*args, **kwargs)
            def mrf_to_sliding_mesh(self, *args, **kwargs):
                """
                Change motion specification from MRF to moving mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
            def append_mesh(self, *args, **kwargs):
                """
                Append new mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/mesh/modify_zones/list_zones").execute(*args, **kwargs)
            def delete_all_shells(self, *args, **kwargs):
                """
                Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_all_shells").execute(*args, **kwargs)
            def sep_face_zone_face(self, *args, **kwargs):
                """
                Separate each face in a zone into unique zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
            def rotate_zone(self, *args, **kwargs):
                """
                Rotate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/rotate_zone").execute(*args, **kwargs)
            def recreate_all_shells(self, *args, **kwargs):
                """
                Create shell on all the walls where which were deleted using the command delete-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/recreate_all_shells").execute(*args, **kwargs)
            def change_zone_phase(self, *args, **kwargs):
                """
                Change the realgas phase for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_phase").execute(*args, **kwargs)
            def deactivate_cell_zone(self, *args, **kwargs):
                """
                Deactivate cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
            def append_mesh_data(self, *args, **kwargs):
                """
                Append new mesh with data.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh_data").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Attempt to establish conformal periodic face zone connectivity.
                """
                return PyMenu(self.service, "/mesh/modify_zones/make_periodic").execute(*args, **kwargs)
            def translate_zone(self, *args, **kwargs):
                """
                Translate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/translate_zone").execute(*args, **kwargs)
            def change_zone_state(self, *args, **kwargs):
                """
                Change the realgas material state for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_state").execute(*args, **kwargs)
            def orient_face_zone(self, *args, **kwargs):
                """
                Orient the face zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/orient_face_zone").execute(*args, **kwargs)
            def activate_cell_zone(self, *args, **kwargs):
                """
                Activate a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/activate_cell_zone").execute(*args, **kwargs)
            def replace_zone(self, *args, **kwargs):
                """
                Replace a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/replace_zone").execute(*args, **kwargs)
            def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
            def slit_face_zone(self, *args, **kwargs):
                """
                Slit a two-sided wall into two connected wall zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_face_zone").execute(*args, **kwargs)
            def sep_cell_zone_mark(self, *args, **kwargs):
                """
                Separate a cell zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)

        class repair_improve(TUIMenu):
            """
            Enter the repair and improve quality menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def report_poor_elements(self, *args, **kwargs):
                """
                Reports invalid and poor quality elements.
                """
                return PyMenu(self.service, "/mesh/repair_improve/report_poor_elements").execute(*args, **kwargs)
            def allow_repair_at_boundaries(self, *args, **kwargs):
                """
                Allows the adjustment of the positions of nodes on boundaries as part of the mesh repairs performed by the mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/allow_repair_at_boundaries").execute(*args, **kwargs)
            def include_local_polyhedra_conversion_in_repair(self, *args, **kwargs):
                """
                Enables/disables the local conversion of degenerate cells into polyhedra based on skewness criteria as part of the mesh repairs performed by the  mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/include_local_polyhedra_conversion_in_repair").execute(*args, **kwargs)
            def repair_periodic(self, *args, **kwargs):
                """
                Modifies the mesh to enforce a rotational angle or translational distance for periodic boundaries. For translationally periodic boundaries, the command computes an average translation distance and adjusts the node coordinates on the shadow face zone to match this distance. For rotationally periodic boundaries, the command prompts for an angle and adjusts the node coordinates on the shadow face zone using this angle and the defined rotational axis for the cell zone.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_periodic").execute(*args, **kwargs)
            def repair_face_node_order(self, *args, **kwargs):
                """
                Modifies face nodes to repair faces with improper face node order and, therefore, eliminates any resulting left-handed faces.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_node_order").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_wall_distance").execute(*args, **kwargs)
            def repair(self, *args, **kwargs):
                """
                Repairs mesh problems identified by the mesh check, if possible. The repairs include fixing cells that have the wrong node order, the wrong face handedness, faces that are small or nonexistent, or very poor quality. Only interior nodes are repositioned by default; boundary nodes may be repositioned if the  mesh/repair-improve/allow-repair-at-boundaries text command is enabled. Note that highly skewed cells may be converted into polyhedra, depending on whether the  mesh/repair-improve/include-local-polyhedra-conversion-in-repair text command is enabled.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair").execute(*args, **kwargs)
            def repair_face_handedness(self, *args, **kwargs):
                """
                Modifies cell centroids to repair meshes that contain left-handed faces without face node order problems.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_handedness").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improves poor quality cells in the mesh, if possible.
                """
                return PyMenu(self.service, "/mesh/repair_improve/improve_quality").execute(*args, **kwargs)

        class reorder(TUIMenu):
            """
            Reorders domain menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def band_width(self, *args, **kwargs):
                """
                Prints cell bandwidth.
                """
                return PyMenu(self.service, "/mesh/reorder/band_width").execute(*args, **kwargs)
            def reorder_domain(self, *args, **kwargs):
                """
                Reorders cells and faces using the reverse Cuthill-McKee algorithm. Note that you must save a new case file (and a data file, if data exists) after reordering with this text command, as well as recreate any ray files and/or surface cluster information.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_domain").execute(*args, **kwargs)
            def reorder_zones(self, *args, **kwargs):
                """
                Reorders zones by partition, type, and ID.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_zones").execute(*args, **kwargs)

        class polyhedra(TUIMenu):
            """
            Enters the polyhedra menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                super().__init__(path, service)
            def convert_hanging_nodes_zones(self, *args, **kwargs):
                """
                Convert selected cell zones with hanging nodes and faces to polyhedra.
                The selected cell zones cannot be connected to other zones.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes_zones").execute(*args, **kwargs)
            def convert_hanging_nodes(self, *args, **kwargs):
                """
                Converts cells with hanging nodes/edges to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes").execute(*args, **kwargs)
            def convert_domain(self, *args, **kwargs):
                """
                Converts the entire domain to polyhedra cells.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_domain").execute(*args, **kwargs)
            def convert_skewed_cells(self, *args, **kwargs):
                """
                Converts skewed cells to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_skewed_cells").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the polyhedra options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def preserve_interior_zones(self, *args, **kwargs):
                    """
                    Enables the preservation of surfaces (that is, manifold zones of type interior) during the conversion of the domain to polyhedra. Note that only those zones with a name that includes the string you specify will be preserved.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_interior_zones").execute(*args, **kwargs)
                def migrate_and_reorder(self, *args, **kwargs):
                    """
                    Enables / disables the migration of newly created partitions to the compute-nodes and the reordering of the domain as part of polyhedra conversion. This is disabled by default, because it requires significant additional memory; when disabled, it is recommended that you save the case file after conversion, read it in a new Fluent session (so that the new / stored partitions become active), and then manually reorder using the mesh/reorder/reorder-domain text command. If you want to run the calculation in the current Fluent session you can enable the migrate-and-reorder? text command prior to conversion, but you must ensure that no more than half of the available memory of your system is currently used.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/migrate_and_reorder").execute(*args, **kwargs)
                def preserve_boundary_layer(self, *args, **kwargs):
                    """
                    Specifies whether boundary layer cells will be preserved when the domain is converted to polyhedra. When the value is set to 0 (default) ANSYS Fluent checks for high aspect ratio cells at the boundary layer and if any are found, Fluent asks if you want to preserve the boundary layer. When the value is set to 1, the boundary layer cells are never preserved; when it is set to 2, the boundary layer cells are always preserved (regardless of the aspect ratio of the boundary layer cells).
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_boundary_layer").execute(*args, **kwargs)

        class surface_mesh(TUIMenu):
            """
            Enters the Surface Mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display(self, *args, **kwargs):
                """
                Displays surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/display").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                Reads surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/read").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes surface mesh.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/delete").execute(*args, **kwargs)

        class adapt(TUIMenu):
            """
            Enters the mesh adaption menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.manage_criteria = self.__class__.manage_criteria(path + ["manage_criteria"], service)
                self.set = self.__class__.set(path + ["set"], service)
                self.geometry = self.__class__.geometry(path + ["geometry"], service)
                self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
                self.profile = self.__class__.profile(path + ["profile"], service)
                self.multi_layer_refinement = self.__class__.multi_layer_refinement(path + ["multi_layer_refinement"], service)
                super().__init__(path, service)
            def adapt_mesh(self, *args, **kwargs):
                """
                Performs manual adaption on the mesh according to the methods and settings that you specified.
                """
                return PyMenu(self.service, "/mesh/adapt/adapt_mesh").execute(*args, **kwargs)
            def anisotropic_adaption(self, *args, **kwargs):
                """
                Applies legacy anisotropic adaption to refine the boundary layers or registers. Cells will be split in the normal direction to the boundary face. Note that this text command is only available for 3D cases that have the adaption method set to hanging node.
                """
                return PyMenu(self.service, "/mesh/adapt/anisotropic_adaption").execute(*args, **kwargs)
            def manual_refinement_criteria(self, *args, **kwargs):
                """
                Set expression for manual refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_refinement_criteria").execute(*args, **kwargs)
            def display_adaption_cells(self, *args, **kwargs):
                """
                Displays the cells that are marked for adaption in the graphics window.
                """
                return PyMenu(self.service, "/mesh/adapt/display_adaption_cells").execute(*args, **kwargs)
            def manual_coarsening_criteria(self, *args, **kwargs):
                """
                Set expression for manual coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_coarsening_criteria").execute(*args, **kwargs)
            def coarsening_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/coarsening_criteria").execute(*args, **kwargs)
            def list_adaption_cells(self, *args, **kwargs):
                """
                Prints the number of cells marked for refinement, coarsening, and both to the console.
                """
                return PyMenu(self.service, "/mesh/adapt/list_adaption_cells").execute(*args, **kwargs)
            def free_hierarchy(self, *args, **kwargs):
                """
                Deletes the defined adaption hierarchy.
                """
                return PyMenu(self.service, "/mesh/adapt/free_hierarchy").execute(*args, **kwargs)
            def refinement_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/refinement_criteria").execute(*args, **kwargs)

            class manage_criteria(TUIMenu):
                """
                Enters the manage criteria menu, which provides text commands for managing automatic adaption criteria.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add(self, *args, **kwargs):
                    """
                    Adds a new automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all the existing automatic adaption criteria.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/edit").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def anisotropic_split_ratio(self, *args, **kwargs):
                    """
                    Sets the split ratio for the cells as part of anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_split_ratio").execute(*args, **kwargs)
                def anisotropic_boundary_zones(self, *args, **kwargs):
                    """
                    Allows you to select the boundary zones that specify directions for anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_boundary_zones").execute(*args, **kwargs)
                def dynamic_adaption(self, *args, **kwargs):
                    """
                    Adapt the mesh during solution.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption").execute(*args, **kwargs)
                def overset_adapt_dead_cells(self, *args, **kwargs):
                    """
                    Enables/disables the adaption of dead cells in overset meshes.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/overset_adapt_dead_cells").execute(*args, **kwargs)
                def encapsulate_children(self, *args, **kwargs):
                    """
                    Encapsulate all children of parent cells on the same partition.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/encapsulate_children").execute(*args, **kwargs)
                def dynamic_adaption_frequency(self, *args, **kwargs):
                    """
                    Set frequency for dynamic adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption_frequency").execute(*args, **kwargs)
                def display_settings(self, *args, **kwargs):
                    """
                    Sets the graphics display options for the refinement, coarsening, and common cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/display_settings").execute(*args, **kwargs)
                def method(self, *args, **kwargs):
                    """
                    Sets the adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/method").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Allows you set how much information about the adaption is printed to the console.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/verbosity").execute(*args, **kwargs)
                def additional_refinement_layers(self, *args, **kwargs):
                    """
                    Allows you to specify additional refinement layers (this is an advanced control).
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/additional_refinement_layers").execute(*args, **kwargs)
                def anisotropic_adaption(self, *args, **kwargs):
                    """
                    Enables / disables anisotropic adaption for prismatic cells as part of manual adaption. Note that this text command requires that the adaption method is set to PUMA.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_adaption").execute(*args, **kwargs)
                def cell_zones(self, *args, **kwargs):
                    """
                    Sets cell zones to be used for marking adaption. An empty list specifies that all zones are considered for adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/cell_zones").execute(*args, **kwargs)
                def maximum_refinement_level(self, *args, **kwargs):
                    """
                    Controls the number of levels of refinement used to split cells during the adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                def maximum_cell_count(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the total cell count of the mesh during adaption. Fluent uses this value to determine when to stop marking cells for refinement. A value of zero places no limits on the number of cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_cell_count").execute(*args, **kwargs)
                def minimum_edge_length(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the edge length for cells that are considered for refinement. Even if a cell is marked for refinement, it will not be refined if (for 3D) its volume is less than the cube of this field or (for 2D) its area is less than the square of this field. The default value of zero places no limits on the size of cells that are refined.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_edge_length").execute(*args, **kwargs)
                def minimum_cell_quality(self, *args, **kwargs):
                    """
                    Sets the minimum value allowed for the orthogonal quality of cells during adaption. If your solution diverges, you may find that using a higher minimum quality value resolves the issue. This text command is only available with the PUMA 3D adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_cell_quality").execute(*args, **kwargs)

            class geometry(TUIMenu):
                """
                Enters the geometry menu. Note that this text command menu is not available unless the adaption method is set to hanging node.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def reconstruct_geometry(self, *args, **kwargs):
                    """
                    Enables/disables geometry-based adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/reconstruct_geometry").execute(*args, **kwargs)
                def set_geometry_controls(self, *args, **kwargs):
                    """
                    Sets geometry controls for wall zones.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/set_geometry_controls").execute(*args, **kwargs)

            class cell_registers(TUIMenu):
                """
                Enters the cell registers menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/delete").execute(*args, **kwargs)
                def coarsen(self, *args, **kwargs):
                    """
                    Coarsen the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/coarsen").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all of the currently defined cell registers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list").execute(*args, **kwargs)
                def adapt(self, *args, **kwargs):
                    """
                    Adapt cell register objects.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/adapt").execute(*args, **kwargs)
                def refine(self, *args, **kwargs):
                    """
                    Refine the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/refine").execute(*args, **kwargs)
                def apply_poor_mesh_numerics(self, *args, **kwargs):
                    """
                    Applies poor mesh numerics to the mesh of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/edit").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Displays a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/display").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list_properties").execute(*args, **kwargs)

            class profile(TUIMenu):
                """
                Enters the profile menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def disable(self, *args, **kwargs):
                    """
                    Disables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/disable").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Prints adaption profiling results.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/print").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/enable").execute(*args, **kwargs)
                def clear(self, *args, **kwargs):
                    """
                    Clears the adaption profiling counters.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/clear").execute(*args, **kwargs)

            class multi_layer_refinement(TUIMenu):
                """
                Enter the multiple boundary layer refinement menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def parameters(self, *args, **kwargs):
                    """
                    Specify parameters for multiple boundary layer refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/parameters").execute(*args, **kwargs)
                def layer_count(self, *args, **kwargs):
                    """
                    Specify the layer count for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/layer_count").execute(*args, **kwargs)
                def boundary_zones(self, *args, **kwargs):
                    """
                    Specify boundary zones for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/boundary_zones").execute(*args, **kwargs)
                def refine_mesh(self, *args, **kwargs):
                    """
                    Refine the mesh for multiple boundary layers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/refine_mesh").execute(*args, **kwargs)

    class solve(TUIMenu):
        """
        Enter the solve menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.report_files = self.__class__.report_files(path + ["report_files"], service)
            self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            super().__init__(path, service)
        def dpm_update(self, *args, **kwargs):
            """
            Updates discrete phase source terms.
            """
            return PyMenu(self.service, "/solve/dpm_update").execute(*args, **kwargs)
        def mesh_motion(self, *args, **kwargs):
            """
            Performs mesh motion.
            """
            return PyMenu(self.service, "/solve/mesh_motion").execute(*args, **kwargs)
        def dual_time_iterate(self, *args, **kwargs):
            """
            Performs unsteady iterations for a specified number of time steps.
            """
            return PyMenu(self.service, "/solve/dual_time_iterate").execute(*args, **kwargs)
        def iterate(self, *args, **kwargs):
            """
            Performs a specified number of iterations.  This option is still available during transient simulations, since it can be used to add more iterations to the same time step after interrupting iterations within a time step.
            """
            return PyMenu(self.service, "/solve/iterate").execute(*args, **kwargs)
        def iterate_steady_2way_fsi(self, *args, **kwargs):
            """
            Perform a specified number of steps.
            """
            return PyMenu(self.service, "/solve/iterate_steady_2way_fsi").execute(*args, **kwargs)
        def update_physical_time(self, *args, **kwargs):
            """
            Advances the unsteady solution to the next physical time level. Using this command in conjunction with theiterate command allows you to manually advance the solution in time (rather than doing it automatically with the dual-time-iterate command).
            """
            return PyMenu(self.service, "/solve/update_physical_time").execute(*args, **kwargs)
        def patch(self, *args, **kwargs):
            """
            Patches a value for a flow variable in the domain. You can either provide a numerical value, which you can enter directly, or you can enter an expression, which must be entered within quotation marks.
            """
            return PyMenu(self.service, "/solve/patch").execute(*args, **kwargs)
        def multistage_time_iterate(self, *args, **kwargs):
            """
            Perform unsteady iterations.
            """
            return PyMenu(self.service, "/solve/multistage_time_iterate").execute(*args, **kwargs)
        def convergence_conditions(self, *args, **kwargs):
            """
            Enters the convergence conditions menu.
            """
            return PyMenu(self.service, "/solve/convergence_conditions").execute(*args, **kwargs)

        class report_plots(TUIMenu):
            """
            Enters the report plots menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes a report plot object.
                """
                return PyMenu(self.service, "/solve/report_plots/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report plots.
                """
                return PyMenu(self.service, "/solve/report_plots/list").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/clear_data").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Defines the curves for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/curves").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report plot objects.
                """
                return PyMenu(self.service, "/solve/report_plots/delete_all").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/add").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/list_properties").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Defines the axes for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/axes").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plots the specified report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/plot").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enters the set solution parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.enhanced_les_numerics = self.__class__.enhanced_les_numerics(path + ["enhanced_les_numerics"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                super().__init__(path, service)
            def courant_number(self, *args, **kwargs):
                """
                Sets the fine-grid Courant number (time step factor). This command is available only for the coupled solvers.
                """
                return PyMenu(self.service, "/solve/set/courant_number").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Sets the sub time step calculation method for VOF calculations.
                """
                return PyMenu(self.service, "/solve/set/vof_explicit_controls").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Sets gradient options.
                """
                return PyMenu(self.service, "/solve/set/gradient_scheme").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enters the residual tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/residual_tolerance").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Sets the order in which the model equations are solved, which can affect the convergence speed when you are using the pressure-based solver. The standard method is enabled by default and corresponds to the ordering shown in  and  in the Theory Guide; alternatively, you can select theoptimized-for-volumetric-expansion method, which is recommended for flows in which the density is strongly dependent on thermal effects, chemical composition, and so on (such as combustion simulations). This text command is not available for steady simulations and/or when a multiphase model is enabled.
                """
                return PyMenu(self.service, "/solve/set/equation_ordering").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Sets all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solve/set/set_all_species_together").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Switches between the modified treatment of node-based gradients at boundary cells and the legacy treatment (R14.5.7 and earlier). If using the density-based solver, you can also specify the extended treatment. For details, see .
                """
                return PyMenu(self.service, "/solve/set/nb_gradient_boundary_option").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Sets pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solve/set/bc_pressure_extrapolations").execute(*args, **kwargs)
            def correction_tolerance(self, *args, **kwargs):
                """
                Enters the correction tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/correction_tolerance").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Sets solution steering parameters.
                """
                return PyMenu(self.service, "/solve/set/set_solution_steering").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Enables / disables the variable time step size formulation for second-order implicit transient formulations. If you disable the variable time step size formulation, note that any change in the time step size will introduce an error proportional to the change in the time step size ratio.
                """
                return PyMenu(self.service, "/solve/set/second_order_time_options").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Sets the number of iterations for a steady-state simulation without starting the calculation.
                """
                return PyMenu(self.service, "/solve/set/number_of_iterations").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Sets the number of iterations for which convergence monitors are reported. The default is 1 (after every iteration).
                """
                return PyMenu(self.service, "/solve/set/reporting_interval").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Specifies whether you want to lock (or “freeze”) the temperature values for all the cells in solid zones (including those to which you have a hooked an energy source through a UDF) and in walls that have shell conduction enabled, so that the values do not change during further solver iterations.
                """
                return PyMenu(self.service, "/solve/set/lock_solid_temperature").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enables a modified NITA scheme and other setting changes that can speed up the simulation. This option is only available with the Large Eddy Simulation (LES) turbulence model, and is intended for unreacting flow simulations that use a constant-density fluid.
                """
                return PyMenu(self.service, "/solve/set/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def multi_stage(self, *args, **kwargs):
                """
                Sets the multi-stage coefficients and the dissipation and viscous evaluation stages. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_stage").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enters the under-relaxation menu, which allows you to set the under-relaxation factor for each equation that is being solved in a segregated manner.
                """
                return PyMenu(self.service, "/solve/set/under_relaxation").execute(*args, **kwargs)
            def slope_limiter_set(self, *args, **kwargs):
                """
                Selects a new Fluent solver slope limiter.
                """
                return PyMenu(self.service, "/solve/set/slope_limiter_set").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solve/set/flux_type").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enters the discretization scheme menu. This allows you to select the discretization scheme for the convection terms in the solution equations. The following text commands can make a selection from a subset of the models in the following table:.
                """
                return PyMenu(self.service, "/solve/set/discretization_scheme").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solve/set/material_property_warnings").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enters the max-corrections menu.
                """
                return PyMenu(self.service, "/solve/set/max_corrections").execute(*args, **kwargs)
            def multi_grid_controls(self, *args, **kwargs):
                """
                Sets multigrid parameters and termination criteria.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_controls").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension_expert").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enables solution steering for the density-based solver.
                """
                return PyMenu(self.service, "/solve/set/solution_steering").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Selects the equations to be solved.
                """
                return PyMenu(self.service, "/solve/set/equations").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when quantities are being limited. By default, limiter warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/limiter_warnings").execute(*args, **kwargs)
            def enable_output_dp_dt(self, *args, **kwargs):
                """
                Controls whether the output field variabledp-dt will be available for transient simulation postprocessing. If you select no, pressure fields at the previous time steps will not be stored in memory which reduces memory usage.
                """
                return PyMenu(self.service, "/solve/set/enable_output_dp_dt").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enters the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solve/set/relaxation_factor").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Sets pressure-velocity controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls").execute(*args, **kwargs)
            def expert(self, *args, **kwargs):
                """
                Sets expert options.
                """
                return PyMenu(self.service, "/solve/set/expert").execute(*args, **kwargs)
            def relaxation_method(self, *args, **kwargs):
                """
                Sets the solver relaxation method.
                """
                return PyMenu(self.service, "/solve/set/relaxation_method").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Enables data sampling for steady or unsteady flow statistics.
                """
                return PyMenu(self.service, "/solve/set/data_sampling").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Sets controls to default values.
                """
                return PyMenu(self.service, "/solve/set/set_controls_to_default").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Sets solver limits for various solution variables, in order to improve the stability of the solution.
                """
                return PyMenu(self.service, "/solve/set/limits").execute(*args, **kwargs)
            def p_v_controls_advanced(self, *args, **kwargs):
                """
                Set advanced pressure-velocity coupling controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls_advanced").execute(*args, **kwargs)
            def moving_mesh_numerics(self, *args, **kwargs):
                """
                Transient options for sliding, moving, and/or dynamic mesh.
                """
                return PyMenu(self.service, "/solve/set/moving_mesh_numerics").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Completely disables reconstruction, resulting in totally first-order accuracy.
                """
                return PyMenu(self.service, "/solve/set/disable_reconstruction").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Sets damping function in flow direction. This command appears only when the VOF model is enabled. Select the damping function to be used:
                Index
                Damping Function
                0
                Linear
                1
                Quadratic
                2
                Cubic
                3
                Cosine.
                """
                return PyMenu(self.service, "/solve/set/numerical_beach_controls").execute(*args, **kwargs)
            def multi_grid_fas(self, *args, **kwargs):
                """
                Sets the parameters that control the FAS multigrid solver. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_fas").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Sets anisotropic drag parameters for the Eulerian multiphase model.
                """
                return PyMenu(self.service, "/solve/set/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Sets the implicit residual smoothing parameters. This command is available only for the explicit coupled solver.
                """
                return PyMenu(self.service, "/solve/set/residual_smoothing").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Sets the solution methods to the default settings.
                """
                return PyMenu(self.service, "/solve/set/set_solution_methods_to_default").execute(*args, **kwargs)
            def multi_grid_amg(self, *args, **kwargs):
                """
                Sets the parameters that govern the algebraic multigrid procedure.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_amg").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solve/set/time_step").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/variable_time_stepping").execute(*args, **kwargs)
            def reactions(self, *args, **kwargs):
                """
                Enables the species reaction sources and sets relaxation factor.
                """
                return PyMenu(self.service, "/solve/set/reactions").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                For flows that do not transition from sub-critical to super-critical, or vice-versa, you can speed-up the solution calculation by updating the frequency of Froude number during run time.
                """
                return PyMenu(self.service, "/solve/set/open_channel_controls").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Selects which pressure-velocity coupling scheme is to be used. Five schemes are available:.
                """
                return PyMenu(self.service, "/solve/set/p_v_coupling").execute(*args, **kwargs)
            def numerics(self, *args, **kwargs):
                """
                Sets numerics options.
                """
                return PyMenu(self.service, "/solve/set/numerics").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Sets the amount of residual information to be printed. A value of 0 (the default) prints residuals at the end of each fine grid iteration. A value of 1 prints residuals after every stage of the fine grid iteration. A value of 2 prints residuals after every stage on every grid level.
                """
                return PyMenu(self.service, "/solve/set/residual_verbosity").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Sets the heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/solve/set/heterogeneous_stiff_chemistry").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Sets surface-tension calculation options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension").execute(*args, **kwargs)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/adaptive_time_stepping").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Sets the reference density method for the Eulerian multiphase model. The following options are available:
                0 (default): Averaged density of the phase
                1: Cell density of the phase
                1: Constant value of 1
                1: Cell density of the phase
                See  for more information.
                """
                return PyMenu(self.service, "/solve/set/mp_reference_density").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Sets phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solve/set/phase_based_vof_discretization").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Sets VOF numeric options.
                """
                return PyMenu(self.service, "/solve/set/vof_numerics").execute(*args, **kwargs)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Sets solver options for stiff chemistry solutions.
                """
                return PyMenu(self.service, "/solve/set/stiff_chemistry").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when reversed flow occurs at inlets and outlets, and when mass-flow inlets develop supersonic regions. By default, flow warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/flow_warnings").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enables convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solve/set/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Enters the advanced settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.turbomachinery_specific_numerics = self.__class__.turbomachinery_specific_numerics(path + ["turbomachinery_specific_numerics"], service)
                    self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                    self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                    super().__init__(path, service)
                def skewness_correction_enhanced(self, *args, **kwargs):
                    """
                    Enable enhanced skewness correction scheme.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/skewness_correction_enhanced").execute(*args, **kwargs)
                def correction_form(self, *args, **kwargs):
                    """
                    S.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/correction_form").execute(*args, **kwargs)
                def explicit_under_relaxation_value(self, *args, **kwargs):
                    """
                    Explicit under-relaxation value.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/explicit_under_relaxation_value").execute(*args, **kwargs)
                def bcd_weights_freeze(self, *args, **kwargs):
                    """
                    Enables/disables freezing of weighting coefficients of the central differencing and the upwind components of the BCD scheme. This dialog command requires the iteration number, after which the BCD scheme weights are to be frozen at each timestep. Freezing the BCD weighting coefficients may help to improve convergence of the timestep iterations as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_weights_freeze").execute(*args, **kwargs)
                def bcd_boundedness(self, *args, **kwargs):
                    """
                    Specifies the BCD scheme parameter, which controls the boundedness strength of the BCD scheme in the pressure-based solver, as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_boundedness").execute(*args, **kwargs)
                def singhal_et_al_cavitation_model(self, *args, **kwargs):
                    """
                    Enables/disables the availability of the Singhal et al. cavitation model option, which can then be enabled in the Multiphase Model dialog box or by using the following text command: define/phases/set-domain-properties/interaction-domain/heat-mass-reaction/cavitation/cavitation?.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/singhal_et_al_cavitation_model").execute(*args, **kwargs)
                def show_all_discretization_schemes(self, *args, **kwargs):
                    """
                    Enables/disables the availability of all applicable discretization schemes.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/show_all_discretization_schemes").execute(*args, **kwargs)
                def energy_numerical_noise_filter(self, *args, **kwargs):
                    """
                    Enables/disables a filter to eliminate non-physical numerical noise in the energy field. Numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present. Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive. This text command is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_numerical_noise_filter").execute(*args, **kwargs)
                def anisotropic_solid_heat_transfer(self, *args, **kwargs):
                    """
                    Set up the heat transfer for anisotropic solid zones.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/anisotropic_solid_heat_transfer").execute(*args, **kwargs)
                def energy_reconstruction_gradient_limiting(self, *args, **kwargs):
                    """
                    Enable limiting of reconstruction gradient for the energy equation.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_reconstruction_gradient_limiting").execute(*args, **kwargs)
                def retain_temporary_solver_mem(self, *args, **kwargs):
                    """
                    Enables/disables the retention of temporary solver memory, which retains gradient data and makes some advanced options available for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_temporary_solver_mem").execute(*args, **kwargs)
                def retain_cell_residuals(self, *args, **kwargs):
                    """
                    Enables/disables the retention of cell residuals for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_cell_residuals").execute(*args, **kwargs)
                def linearized_mass_transfer_udf(self, *args, **kwargs):
                    """
                    Enables/disables the use of a linearized mass transfer user-defined function (that is, the DEFINE_LINEARIZED_MASS_TRANSFER macro), as opposed to a mass transfer user-defined function (that is, the DEFINE_MASS_TRANSFER macro).
                    """
                    return PyMenu(self.service, "/solve/set/advanced/linearized_mass_transfer_udf").execute(*args, **kwargs)
                def alternate_wall_temp_formulation(self, *args, **kwargs):
                    """
                    Enables/disables an alternate formulation for wall temperatures.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/alternate_wall_temp_formulation").execute(*args, **kwargs)

                class turbomachinery_specific_numerics(TUIMenu):
                    """
                    Enter turbomachinery specific numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Activate/deactivate turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/enable").execute(*args, **kwargs)
                    def settings(self, *args, **kwargs):
                        """
                        Adjust settings for turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/settings").execute(*args, **kwargs)

                class secondary_gradient_limiting(TUIMenu):
                    """
                    Enters the secondary gradient limiting menu. This menu is only available when the define/models/solver/pressure-based text command is enabled.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def energy(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the energy  calculations on coupled two-sided walls. This limiting can help prevent  divergence when the cells on such walls have poor orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                    def mesh_quality_limits(self, *args, **kwargs):
                        """
                        Defines the mesh quality limits used when applying secondary  gradient limiting to faces on coupled two-sided walls. Shifting this  range closer to 1 will decrease the risk of divergence, but at the cost  of accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)
                    def uds(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the user-defined  scalar (UDS) calculations on coupled two-sided walls. This limiting can  help prevent divergence when the cells on such walls have poor  orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/uds").execute(*args, **kwargs)

                class non_reflecting_boundary_treatment(TUIMenu):
                    """
                    Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enters the warped-face gradient correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables gradient enhancement computations and specifies whether Fluent uses fast or memory saving mode.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class enhanced_les_numerics(TUIMenu):
                """
                Enter enhanced LES options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def optimized_advection(self, *args, **kwargs):
                    """
                    Use advection scheme optimized for LES.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_advection").execute(*args, **kwargs)
                def optimized_cd(self, *args, **kwargs):
                    """
                    Use optimized central difference discretization.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_cd").execute(*args, **kwargs)
                def optimized_algorithm(self, *args, **kwargs):
                    """
                    Use solver algorithm optimized for LES.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_algorithm").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Specifies overset meshing solver options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Selects the interpolation method for overset interfaces. Note that the least squares method is recommended for sliding mesh cases.
                    """
                    return PyMenu(self.service, "/solve/set/overset/interpolation_method").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    Uses the pressure gradient of the donor cell in the interpolation of pressure for its receptor cell.
                    """
                    return PyMenu(self.service, "/solve/set/overset/high_order_pressure").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enables/disables a numerical treatment that attempts to assign reasonable data values to orphan cells.
                    """
                    return PyMenu(self.service, "/solve/set/overset/orphan_cell_treatment").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enters the NITA expert control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Enables/disables coupling of the neighbor and skewness corrections.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Setting this to 1, enables the verbosity for NITA diagnostics. The default value of 0 disables verbosity output for NITA diagnostics.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/set_verbosity").execute(*args, **kwargs)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Enables and sets hybrid NITA options. For more details, see .
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.models = self.__class__.models(path + ["models"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    super().__init__(path, service)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/verbosity").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enters the poor mesh numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Resets the list of poor cells included by the default, cell quality, user-defined, cell gradient quality, and solution and cell quality criteria.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells (those with an orthogonal quality of 0, as well as those identified by other enabled criteria), and defines whether the local solution correction is 0th, 1st, or 2nd order.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Enables/disables the relocation of select cell centroids, to improve the orthogonality metrics and solution stability. It is applied to cells when the criterion value is equal to or less than a threshold value defined as part of the text command. Note that the enhanced metrics are only apparent when reporting the quality in the solution mode of Fluent, and not in the meshing mode.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Prints out a listing of the poor cells for each criterion: default, cell quality, and user-defined, and (if enabled) cell gradient quality and solution and cell quality.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Includes a register for the poor mesh numerics or not.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def user_defined_on_register_auto(self, *args, **kwargs):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register_auto").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells with an orthogonal quality that is equal to or less than the threshold defined by the solve/set/poor-mesh-numerics/set-quality-threshold text command (which by default is set to 0.05).
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the cell gradient quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command. This criterion is only available with the pressure-based solver, and is not supported for cases that have periodic boundaries.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the solution and cell quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command, and at a specified frequency (of iterations or time steps). This criterion is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Sets the orthogonal quality threshold used for applying poor mesh numerics when the solve/set/poor-mesh-numerics/cell-quality-based? text command is enabled. By default, cells with an orthogonal quality of 0.05 or lower are corrected.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Enter the menu for specifying quantities and zones for steady and unsteady flow statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dft_datasets = self.__class__.dft_datasets(path + ["dft_datasets"], service)
                    super().__init__(path, service)
                def list_datasets(self, *args, **kwargs):
                    """
                    Lists the combinations of zones and quantities that are defined for sampling steady and unsteady flow statistics.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/list_datasets").execute(*args, **kwargs)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Specify zone and quantity combinations for sampling Fourier coefficients of unsteady flows.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_datasets").execute(*args, **kwargs)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/remove_dataset").execute(*args, **kwargs)

                class dft_datasets(TUIMenu):
                    """
                    Data sampling options for runtime discrete Fourier transform.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def quantities(self, *args, **kwargs):
                        """
                        Select quantities for a new DFT dataset. Enter () to complete the quantity selection.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/quantities").execute(*args, **kwargs)
                    def add_datasets(self, *args, **kwargs):
                        """
                        Add DFT datasets.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/add_datasets").execute(*args, **kwargs)
                    def freq_min_max(self, *args, **kwargs):
                        """
                        Specify the minimum and the maximum frequency for a band.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_min_max").execute(*args, **kwargs)
                    def freq_tone_and_sampling(self, *args, **kwargs):
                        """
                        Specify single tone frequency and sampling duration as the number of tone periods.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_tone_and_sampling").execute(*args, **kwargs)
                    def zones(self, *args, **kwargs):
                        """
                        Select zones for a new DFT dataset.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/zones").execute(*args, **kwargs)
                    def freq_step_and_sampling(self, *args, **kwargs):
                        """
                        Specify either the band resolution or the sampling timesteps number. The other value will be computed consistently.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_step_and_sampling").execute(*args, **kwargs)
                    def band_or_tone(self, *args, **kwargs):
                        """
                        Specify, whether a new dataset is for DFT in a frequency band resolved by many harmonics or for a single tone.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/band_or_tone").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solve/set/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/expert").execute(*args, **kwargs)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets the relaxation factor.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Selects the variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class fast_transient_settings(TUIMenu):
                """
                Enters the fast transient settings menu. This menu is only available for transient cases that use the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rk2(self, *args, **kwargs):
                    """
                    Allows you to enable the use of a two-stage Runge-Kutta scheme for time integration, or revert to the default multi-stage Runge-Kutta scheme. This text command is only available for transient cases that use the density-based explicit formulation.
                    """
                    return PyMenu(self.service, "/solve/set/fast_transient_settings/rk2").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enters the transient controls menu, which allows you to define settings related to time advancement for transient flow calculations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing the next time step. The predictor algorithm is a computation that sets a better initial condition for the time step. It uses the rate of change between the prediction and the correction as an indicator for whether the next time step should be larger, smaller, or the same as the current one.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/predict_next_time").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the convective time scale (global Courant number): the time-step-size calculation depends on the mesh density and velocity in interfacial cells. This method is available for all multiphase models using the implicit or explicit volume fraction formulation, except for the wet steam model.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Specifies whether to define the transient advancement either directly by entering a time step size / period / frequency (using the text commands available in thesolve/set/transient-controls menu) or indirectly by entering a Courant number value (using the solve/set/courant-number text command). This text command is only available for the density-based solver when both the explicit formulation and explicit transient formulation are used.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/specified_time_step").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent as the calculation proceeds such that the Courant–Friedrichs–Lewy (CFL) condition is satisfied, using the specified Courant number.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which a specified period or frequency is the basis for determining the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which you directly specify the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Specifies the time interval for acoustic data sampling. This text command is only available when both the Ffowcs Williams and Hawkings model is selected and the density-based solver is used with the explicit formulation and explicit transient formulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size used for solid zones is independent from that used for fluid zones. This text command is only available when both a solid zone exists and energy is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size is defined by a user-defined function (UDF) that uses theDEFINE_DELTAT macro.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the total number of time steps that the simulation will run (which includes any time steps that have already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to1.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Enables / disables an option that allows for better prediction of the flow field in rotating fluid zones at every time step, in order to speed up the calculation. This text command is only available for transient simulations.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial conditions at time step n+1. The predictor algorithm is a computation that sets a better initial condition for the time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Sets the amount of incremental (that is, additional) time to run the simulation, regardless of how much time has already been run in previous calculations. This text command is only available when the solve/set/transient-controls/duration-specification-method is set to3.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/incremental_time").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enters the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the specified truncation error tolerance.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Sets the total amount of time that the simulation will be run (which includes any time that has already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to2.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_time").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Sets the magnitude of the (physical) time step . This text command is only available when the solve/set/transient-controls/fixed-user-specified text command is set toyes.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Sets the maximum flow time.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_flow_time").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Allows you to open theSimulation Status dialog box, which reports details about the simulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solution_status").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    When enabled, if the truncation error within a time step exceeds the specified tolerance Fluent will automatically undo the current calculation and make another attempt with the time step reduced by 1/2. This will be attempted up to 5 times after which Fluent will accept the result and proceed to the next time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/undo_timestep").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Sets the method by which you will specify the duration of the calculation. The duration can be defined by the total time, the total number of time steps, the incremental time, or the number of incremental time steps. In this context, "total" indicates that Fluent will consider the amount of time / steps that have already been solved and stop appropriately, whereas "incremental" indicates that the solution will proceed for a specified amount of time / steps regardless of what has previously been calculated. This text command is only available when the time stepping is adaptive or based on a user-defined function.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation.  This option is available when automatic initialization and case modification is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation without starting the calculation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Enters the menu for setting multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Enables/disables the physics-driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        When enabled, various time scales (depending on the selection) are  printed to the console window at every time step. This text command is  available with the moving mesh CFL constraint and with the physics-based  constraint.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Enters the menu for choosing the time-scale options. This menu  becomes available after you enable the physics-driven time-step  constraints using the solve/set/transient-controls/multiphase-specific-time-constraints/physics-based-constraint?  text command.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the viscous time scale. This option is disabled by default. This command is not available with inviscid flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the surface-tension-driven time scale. This option is available only if the surface tension force modeling is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the gravitational time scale. This option is available only if gravity is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the acoustic time scale. This option is available only for compressible flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)

            class amg_options(TUIMenu):
                """
                Enters the AMG options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def aggressive_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of a version of the AMG solver that is optimized for high coarsening rates. This option is recommended if the AMG solver diverges with the default settings.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)
                def amg_gpgpu_options(self, *args, **kwargs):
                    """
                    Set GPGPU AMG solver options.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                def conservative_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of conservative coarsening techniques for scalar and/or coupled equations that can improve parallel performance and/or convergence for some difficult cases.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                def laplace_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables Laplace coarsening for scalar and/or coupled equations.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/laplace_coarsening").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enters the pseudo time method menu. This menu is only available for cases that use a pressure-based segregated solver (SIMPLE, SIMPLEC, or PISO) or for steady-state cases that use the pressure-based coupled solver or the density-based implicit solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time settings for the calculation when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enters the relaxation factors menu, where you can set the pseudo time explicit relaxation factors for individual equations. These factors only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enters the advanced options menu, which allows you to enable / disable the pseudo time method for individual equations and define their pseudo time scale factors or under-relaxation factors, respectively. These settings only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity of the messages related to the pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/verbosity").execute(*args, **kwargs)
                def formulation(self, *args, **kwargs):
                    """
                    Enables and sets the pseudo time step size formulation or disables the pseudo time method option.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/formulation").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time Courant number when the local time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enters the divergence prevention menu. This menu is only available for the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables a divergence prevention option so that Fluent applies under-relaxation to the variables in select cells where the temperature and/or pressure values are approaching the minimum and/or maximum limits.
                    """
                    return PyMenu(self.service, "/solve/set/divergence_prevention/enable").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enters the menu to specify parameters of the acoustics wave equation solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the menu to specify the expert parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the implicit under-relaxation factor. Should be used only  with bad meshes, when the AMG linear solver does not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the explicit relaxation factor. Should be used only with  bad meshes, when iterations do not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Sets multiphase numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    super().__init__(path, service)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Enters the menu for the stability controls for multiphase flows. For more information about the below option, see  and .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.num_ventilation = self.__class__.num_ventilation(path + ["num_ventilation"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        super().__init__(path, service)

                    class hybrid_nita(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Sets the number of outer iterations.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Allows you to change the number of initial time-steps and the number of initial outer iterations to control solution stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Enters the menu for the instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Sets the Courant number limit for detecting unstable  events. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Sets the number of outer iterations for an unstable  event.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Sets the velocity limit for detecting unstable events.  This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enables/disables the instability detector to deal with  possible instability problems. Once this option is enabled,  additional instability detection options become  available.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Selects the CFL number type for detection of an unstable  event. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Enters the menu for the pressure-velocity coupling controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            super().__init__(path, service)

                        class skewness_correction(TUIMenu):
                            """
                            Enters the skewness correction menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Enables/disables the limited pressure correction  gradient in skewness terms for the PISO, SIMPLEC, or  fractional step pressure-coupling schemes.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Enters the stability controls menu for the Rhie-Chow interpolation.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Enables/disables the low-order velocity interpolation in  the flux calculation.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class coupled_vof(TUIMenu):
                            """
                            Enters the stability control menu for VOF cases that involve the Coupled pressure-velocity coupling scheme.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Allows you to use the linearized buoyancy force and the  blended treatment for the buoyancy force.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Enters the anti-diffusion menu. This item is available for VOF cases  with the Interfacial Anti-Diffusion option  enabled.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enables dynamic strength to reduce compression in the direction tangential to the interface.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Sets the cosine exponent in the dynamic strength treatment in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Sets the maximum value of dynamic anti-diffusion strength in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)

                    class num_ventilation(TUIMenu):
                        """
                        Numerical Ventilation Menu for VOF Model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable(self, *args, **kwargs):
                            """
                            Enable numerical ventilation treatment to remove trapped phase adjacent to wall.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/enable").execute(*args, **kwargs)
                        def trapped_phase_vof_min(self, *args, **kwargs):
                            """
                            Set trapped phase minimum volume fraction to activate numerical ventilation treatment for trapped phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_min").execute(*args, **kwargs)
                        def near_wall_treatment_options(self, *args, **kwargs):
                            """
                            Set near wall treatment options.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/near_wall_treatment_options").execute(*args, **kwargs)
                        def tau_estimation_options(self, *args, **kwargs):
                            """
                            Set time step size option for numerical ventilation treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/tau_estimation_options").execute(*args, **kwargs)
                        def trapped_phase_vof_max(self, *args, **kwargs):
                            """
                            Set trapped phase maximum volume fraction to activate numerical ventilation treatment for non-trapped phases.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_max").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            When enabled, solves the flow equation at the end of the iteration. This improves the behavior at the start of new time-step if the solution does not converge properly.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    Enters the solution-stabilization numerics menu. This item is available only for the VOF model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        super().__init__(path, service)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        When enabled, modifies solver settings for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        When enabled, uses additional controls for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Enters the menu for the velocity-limiting-treatment.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enables/disables the velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Specifies the maximum velocity magnitude.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            When enabled, the solver prints the number of velocity limited cells at each iteration.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Enters the menu for additional advanced stability controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Enables/disables the blended compressive discretization scheme.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Enters the viscous multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Forces harmonic averaging of cell viscosities to calculate face  viscosity used in momentum equation. This can improve convergence for  highly viscous flow applications (the VOF model only).
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Enters the default controls menu. This menu is available only for multiphase flows.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Applies the multiphase defaults (version 2020 R1) to the loaded case  file.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Enters the porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Allows you to fix the saturation (volume fraction) of the phase at  its user-specified residual saturation value.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Enters the compressible multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Enables an alternative formulation for compressible phases at an  inlet boundary. This formulation calculates static temperature and  pressure using an iterative method based on fundamental thermodynamic  relations.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Enables an enhanced numerical treatment that provides better  stability at startup and during calculation of compressible  flows.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)

                class boiling_parameters(TUIMenu):
                    """
                    Enters the menu for the multiphase boiling model parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        When enabled, considers liquid volume fraction effects by multiplying the heat transfer coefficients by the local liquid volume fraction.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)
                    def thin_film(self, *args, **kwargs):
                        """
                        When enabled, includes multiphase boiling thin film effects using .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Enters the menu for the multiphase heat mass transfer parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Enables the alternative treatment of the energy sources. For more  information, see .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Enters the menu for the area density.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Sets the minimum volume fraction for the area density and cavitation. This may be useful, for example, in cases when a species mass transfer model (such as the Symmetric model or Particle model) do not consider evaporation or condensation if the volume fraction of one of the phases is zero. The seeding allows for a phase change to occur in the fluid flow. The default value is 1e-6.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Enables/disables the interfacial area density Gradient-Symmetric model. For more information about this model, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Enters the cavitation heat mass transfer menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Sets the condensation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 0.2.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the vapor pressure after the turbulence and thermal correction. The default value is five times the vapor pressure, with consideration of turbulent and thermal effects for each cell and phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Sets the evaporation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 1.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enables/disables the turbulent diffusion treatment for a cavitating turbulent flow. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Sets the minimum vapor pressure limit for the cavitation mass-transfer model. The default value is 1 Pa.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Enters the menu for the advanced boiling options for the  semi-mechanistic boiling model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Sets the under-relaxation factor for boiling heat flux. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Enables/disables the two-resistance boiling framework to improve the robustness and accuracy of the solution of cases with multiple boiling mechanisms. For more information about this item, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes the expert options for the semi-mechanistic boiling model. For more information about these options, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Sets buffer layer height, verbosity, and open channel wave theory formulation.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Sets the buffer layer height.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Sets the open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Specifies which open channel wave theory formulation Fluent uses.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Provides text commands that allow you to undo enhancements to the default solver behavior.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R3 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2021 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_2023r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2023R1.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2023r1_default_changes").execute(*args, **kwargs)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2022 R1 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2021 R2 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Makes available the Pressure Discontinuity Sensor which is a binary identifier equal to 1 if a cell is in proximity of a pressure discontinuity.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Sets the level of stabilization used to achieve fast convergence. Enter a number 0-5 corresponding to the Mach number range that best characterizes the flow.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/expert").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Speed Numerics.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/enable").execute(*args, **kwargs)

        class cell_register_operations(TUIMenu):
            """
            Enters the cell register operations menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                Lists the currently defined cell register operations.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/add").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list_properties").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/delete").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enters the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                super().__init__(path, service)
            def set_defaults(self, *args, **kwargs):
                """
                Sets default initial values.
                """
                return PyMenu(self.service, "/solve/initialize/set_defaults").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Displays the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_time_sampled").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                Lists default values.
                """
                return PyMenu(self.service, "/solve/initialize/list_defaults").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Deletes wall film particles and initializes wall film variables to zero. This option is available only with the wall-film DPM boundary condition.
                """
                return PyMenu(self.service, "/solve/initialize/lwf_initialization").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Sets reference frame to absolute or relative.
                """
                return PyMenu(self.service, "/solve/initialize/reference_frame").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initializes using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solve/initialize/fmg_initialization").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enters the set full-multigrid for initialization menu. Initial values for each variable can be set within this menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Resets discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solve/initialize/dpm_reset").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solve/initialize/patch").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solve/initialize/repair_wall_distance").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Opens channel automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specifies the number of timesteps for ramping of sound sources and re-initializes the acoustics wave equation solution. For the initialized acoustics solution, Fluent reports the current state of the sound sources ramping.
                """
                return PyMenu(self.service, "/solve/initialize/init_acoustics_options").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/levelset_auto_init").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Displays the number of iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initializes unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/init_flow_statistics").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initializes the flow field with the current default values.
                """
                return PyMenu(self.service, "/solve/initialize/initialize_flow").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initializes using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solve/initialize/hyb_initialization").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enters the hybrid initialization menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initializes instantaneous velocity field out of steady state RANS results, for use before enabling a scale resolving simulation such as LES.
                """
                return PyMenu(self.service, "/solve/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Enters the menu for localized turbulent flow initialization.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Sets values for the turbulent intensity and turbulent viscosity ratio for localized initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables localized initialization of turbulent flow variables.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enters the compute default values menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initializes the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/axis").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enters the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_options(self, *args, **kwargs):
                    """
                    Sets options for patching and smoothing volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Sets solution monitors.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.residual = self.__class__.residual(path + ["residual"], service)
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                super().__init__(path, service)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solve/monitors/convergence_conditions").execute(*args, **kwargs)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solve/monitors/set_average_over").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enters the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def plot(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/plot").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Re-normalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/re_normalize").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Sets number of residuals to be saved with data. History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_save").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Sets normalization factors for currently monitored residuals (if normalize? is set to yes).
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/print").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Chooses which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/monitor").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Sets relative convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Chooses which currently monitored residuals should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/check_convergence").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Chooses whether to scale residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Sets convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Chooses whether to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalize").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Chooses whether to delete the residual history and reset iteration counter to 1.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/reset").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Enables/disables an enhanced formulation for the local scaling of the continuity residuals with the pressure-based solver, so that the absolute mass flow rate at each cell is used. This text command is only available when the computing of the local scale is enabled through the solve/monitors/residual/scale-by-coefficient? text command.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Sets the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_display").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Sets convergence criterion type.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/criterion_type").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Sets the number of iterations through which normalization factors will be maximized.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_maximize_norms").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/curves").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/axes").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/plot").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/add").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/clear_data").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/edit").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/add").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list_properties").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Enters the report definitions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Renames a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/rename").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/report_definitions/add").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/list_properties").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/compute").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report definition objects.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete_all").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report definitions.
                """
                return PyMenu(self.service, "/solve/report_definitions/list").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Creates a copy of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/copy").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Enters the cell registers menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solve/cell_registers/adapt").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solve/cell_registers/edit").execute(*args, **kwargs)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/coarsen").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/cell_registers/add").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/refine").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Applies poor mesh numerics to the mesh of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the currently defined cell registers.
                """
                return PyMenu(self.service, "/solve/cell_registers/list").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/display").execute(*args, **kwargs)

        class report_files(TUIMenu):
            """
            Enters the report files menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report file.
                """
                return PyMenu(self.service, "/solve/report_files/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report files.
                """
                return PyMenu(self.service, "/solve/report_files/list").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report file objects.
                """
                return PyMenu(self.service, "/solve/report_files/delete_all").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report file.
                """
                return PyMenu(self.service, "/solve/report_files/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report file.
                """
                return PyMenu(self.service, "/solve/report_files/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report file object.
                """
                return PyMenu(self.service, "/solve/report_files/delete").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report file.
                """
                return PyMenu(self.service, "/solve/report_files/clear_data").execute(*args, **kwargs)

        class execute_commands(TUIMenu):
            """
            Enters the execute commands menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def add_edit(self, *args, **kwargs):
                """
                Adds or edits execute commands.
                """
                return PyMenu(self.service, "/solve/execute_commands/add_edit").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/disable").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/copy").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/delete").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/enable").execute(*args, **kwargs)
            def export(self, *args, **kwargs):
                """
                Export execute-commands to a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/export").execute(*args, **kwargs)
            def import_(self, *args, **kwargs):
                """
                Import execute-commands from a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/import").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enters the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.objects = self.__class__.objects(path + ["objects"], service)
                self.playback = self.__class__.playback(path + ["playback"], service)
                self.define = self.__class__.define(path + ["define"], service)
                self.pulse = self.__class__.pulse(path + ["pulse"], service)
                super().__init__(path, service)

            class objects(TUIMenu):
                """
                Enters the object manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/delete").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/edit").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copies solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/copy").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Creates new solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/create").execute(*args, **kwargs)
                def clear_history(self, *args, **kwargs):
                    """
                    Clears solution animation object history.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/clear_history").execute(*args, **kwargs)

            class playback(TUIMenu):
                """
                Enters the animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def read(self, *args, **kwargs):
                    """
                    Reads new animation from file or already defined animations.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/read").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Writes animation sequence to the file.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/write").execute(*args, **kwargs)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Specify a custom start frame, increment, and end frame for video export.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def play(self, *args, **kwargs):
                    """
                    Plays the selected animation.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/play").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Plays the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/stored_view").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes animation sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/delete").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enters the video menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Controls whether the resolution of the saved video file matches that  of the images used to create it.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/use_original_resolution").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Sets the target frames per second (FPS) for the saved video  file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/fps").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/quality").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Specifies what format the video file will be written in (MP4 | AVI |  FLV | MOV | MPEG).
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/format").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/width").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Expands or collapses the resolution based on this scaling  factor.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/scale").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Sets the name of the saved video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/name").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/height").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)

            class define(TUIMenu):
                """
                Enters the animation definition menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def define_monitor(self, *args, **kwargs):
                    """
                    Defines new animation.
                    """
                    return PyMenu(self.service, "/solve/animate/define/define_monitor").execute(*args, **kwargs)
                def edit_monitor(self, *args, **kwargs):
                    """
                    Changes animation monitor attributes.
                    """
                    return PyMenu(self.service, "/solve/animate/define/edit_monitor").execute(*args, **kwargs)

            class pulse(TUIMenu):
                """
                Enter the pulse animation menu (only available when one or more particle track or pathline graphics objects are defined).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    self.hardcopy = self.__class__.hardcopy(path + ["hardcopy"], service)
                    super().__init__(path, service)
                def write(self, *args, **kwargs):
                    """
                    Select a pathline or particle track graphics object, specify whether you want to write a video file or picture files, and enter the destination directory for the files. Continuous pulse animations result in a 5 second video. Single pulse animations run for a full cycle.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/write").execute(*args, **kwargs)
                def pulse_mode(self, *args, **kwargs):
                    """
                    Set whether the pulse is a single pulse or continuous.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/pulse_mode").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enter the video window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/width").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/set_standard_resolution").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/use_original_resolution").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/height").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/format").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/quality").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/fps").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/name").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/scale").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate_scale").execute(*args, **kwargs)

                class hardcopy(TUIMenu):
                    """
                    Hardcopy options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.driver = self.__class__.driver(path + ["driver"], service)
                        self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                        super().__init__(path, service)
                    def dpi(self, *args, **kwargs):
                        """
                        Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/dpi").execute(*args, **kwargs)
                    def jpeg_hardcopy_quality(self, *args, **kwargs):
                        """
                        To set jpeg hardcopy quality.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/jpeg_hardcopy_quality").execute(*args, **kwargs)
                    def landscape(self, *args, **kwargs):
                        """
                        Plot hardcopies in landscape or portrait orientation.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/landscape").execute(*args, **kwargs)
                    def preview(self, *args, **kwargs):
                        """
                        Display a preview image of a hardcopy.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/preview").execute(*args, **kwargs)
                    def x_resolution(self, *args, **kwargs):
                        """
                        Set the width of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/x_resolution").execute(*args, **kwargs)
                    def invert_background(self, *args, **kwargs):
                        """
                        Use a white background when the picture is saved.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/invert_background").execute(*args, **kwargs)
                    def y_resolution(self, *args, **kwargs):
                        """
                        Set the height of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/y_resolution").execute(*args, **kwargs)
                    def use_window_resolution(self, *args, **kwargs):
                        """
                        Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/use_window_resolution").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/set_standard_resolution").execute(*args, **kwargs)

                    class driver(TUIMenu):
                        """
                        Enter the set hardcopy driver menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.post_format = self.__class__.post_format(path + ["post_format"], service)
                            super().__init__(path, service)
                        def avz(self, *args, **kwargs):
                            """
                            Use AVZ output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/avz").execute(*args, **kwargs)
                        def png(self, *args, **kwargs):
                            """
                            Use PNG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/png").execute(*args, **kwargs)
                        def hsf(self, *args, **kwargs):
                            """
                            Use HSF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/hsf").execute(*args, **kwargs)
                        def ppm(self, *args, **kwargs):
                            """
                            Produce PPM output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/ppm").execute(*args, **kwargs)
                        def tiff(self, *args, **kwargs):
                            """
                            Use TIFF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/tiff").execute(*args, **kwargs)
                        def glb(self, *args, **kwargs):
                            """
                            Use GLB output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/glb").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Set the hardcopy options. Available options are:
                            "no gamma correction", disables gamma correction of colors,
                            "physical size = (width,height)", where width and height
                            are the actual measurements of the printable area of the page
                            in centimeters.
                            "subscreen = (left,right,bottom,top)", where left,right,
                            bottom, and top are numbers in [-1,1] describing a subwindow on
                            the page in which to place the hardcopy.
                            The options may be combined by separating them with commas.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/options").execute(*args, **kwargs)
                        def post_script(self, *args, **kwargs):
                            """
                            Produce PostScript output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_script").execute(*args, **kwargs)
                        def vrml(self, *args, **kwargs):
                            """
                            Use VRML output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/vrml").execute(*args, **kwargs)
                        def eps(self, *args, **kwargs):
                            """
                            Produce encapsulated PostScript (EPS) output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/eps").execute(*args, **kwargs)
                        def dump_window(self, *args, **kwargs):
                            """
                            Set the command used to dump the graphics window to a file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/dump_window").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List the current hardcopy driver.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/list").execute(*args, **kwargs)
                        def jpeg(self, *args, **kwargs):
                            """
                            Produce JPEG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/jpeg").execute(*args, **kwargs)

                        class post_format(TUIMenu):
                            """
                            Enter the PostScript driver format menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vector(self, *args, **kwargs):
                                """
                                Use vector format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/vector").execute(*args, **kwargs)
                            def rle_raster(self, *args, **kwargs):
                                """
                                Use the run-length encoded raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/rle_raster").execute(*args, **kwargs)
                            def raster(self, *args, **kwargs):
                                """
                                Use the original raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/raster").execute(*args, **kwargs)
                            def fast_raster(self, *args, **kwargs):
                                """
                                Use the new raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/fast_raster").execute(*args, **kwargs)

                    class color_mode(TUIMenu):
                        """
                        Enter the hardcopy color mode menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def color(self, *args, **kwargs):
                            """
                            Plot hardcopies in color.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/color").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Display the current hardcopy color mode.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/list").execute(*args, **kwargs)
                        def mono_chrome(self, *args, **kwargs):
                            """
                            Convert color to monochrome (black and white) for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/mono_chrome").execute(*args, **kwargs)
                        def gray_scale(self, *args, **kwargs):
                            """
                            Convert color to grayscale for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/gray_scale").execute(*args, **kwargs)

    class simulation_reports(TUIMenu):
        """
        Enter the simulation reports menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
            super().__init__(path, service)
        def export_simulation_report_as_html(self, *args, **kwargs):
            """
            Export the provided simulation report as HTML.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
        def write_report_names_to_file(self, *args, **kwargs):
            """
            Write the list of currently generated report names to a txt file.
            """
            return PyMenu(self.service, "/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
        def duplicate_simulation_report(self, *args, **kwargs):
            """
            Duplicate a report and all of its settings to a new report.
            """
            return PyMenu(self.service, "/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
        def read_simulation_report_template_file(self, *args, **kwargs):
            """
            Read a JSON template file with existing Simulation Report settings.
            """
            return PyMenu(self.service, "/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
        def reset_report_to_defaults(self, *args, **kwargs):
            """
            Reset all report settings to default for the provided simulation report.
            """
            return PyMenu(self.service, "/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
        def view_simulation_report(self, *args, **kwargs):
            """
            View a simulation report that has already been generated. In batch mode this will print the report's URL.
            """
            return PyMenu(self.service, "/simulation_reports/view_simulation_report").execute(*args, **kwargs)
        def write_simulation_report_template_file(self, *args, **kwargs):
            """
            Write a JSON template file with this case's Simulation Report settings.
            """
            return PyMenu(self.service, "/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
        def export_simulation_report_as_pdf(self, *args, **kwargs):
            """
            Export the provided simulation report as a PDF file.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
        def delete_simulation_report(self, *args, **kwargs):
            """
            Delete the provided simulation report.
            """
            return PyMenu(self.service, "/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
        def rename_simulation_report(self, *args, **kwargs):
            """
            Rename a report which has already been generated.
            """
            return PyMenu(self.service, "/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
        def list_simulation_reports(self, *args, **kwargs):
            """
            List all report names.
            """
            return PyMenu(self.service, "/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
        def export_simulation_report_as_pptx(self, *args, **kwargs):
            """
            Export the provided simulation report as a PPT file.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_pptx").execute(*args, **kwargs)
        def generate_simulation_report(self, *args, **kwargs):
            """
            Generate a new simulation report or regenerate an existing simulation report with the provided name.
            """
            return PyMenu(self.service, "/simulation_reports/generate_simulation_report").execute(*args, **kwargs)

        class parametric_study(TUIMenu):
            """
            Enter the parametric study menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def generate_design_point_report(self, *args, **kwargs):
                """
                Generate a simulation report for an updated design point.
                """
                return PyMenu(self.service, "/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
            def generate_parametric_report(self, *args, **kwargs):
                """
                Generate a parametric report for your study.
                """
                return PyMenu(self.service, "/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

    class parameters__and__customization(TUIMenu):
        """
        Enter Parameters and custom menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            super().__init__(path, service)

        class user_defined(TUIMenu):
            """
            Enter the user-defined functions and scalars menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.real_gas_models = self.__class__.real_gas_models(path + ["real_gas_models"], service)
                super().__init__(path, service)
            def fan_model(self, *args, **kwargs):
                """
                Configure user-defined fan model.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/fan_model").execute(*args, **kwargs)
            def user_defined_node_memory(self, *args, **kwargs):
                """
                Allocate user-defined node memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_node_memory").execute(*args, **kwargs)
            def one_D_coupling(self, *args, **kwargs):
                """
                Load 1D library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/one_D_coupling").execute(*args, **kwargs)
            def use_contributed_cpp(self, *args, **kwargs):
                """
                Enable/disable use of cpp from the Fluent.Inc/contrib directory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_contributed_cpp").execute(*args, **kwargs)
            def user_defined_scalars(self, *args, **kwargs):
                """
                Define user-defined scalars.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_scalars").execute(*args, **kwargs)
            def compile_customized_addon_module(self, *args, **kwargs):
                """
                Compile customized addon module?.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compile_customized_addon_module").execute(*args, **kwargs)
            def use_built_in_compiler(self, *args, **kwargs):
                """
                Enable/disable the use of the built-in compiler.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_built_in_compiler").execute(*args, **kwargs)
            def auto_compile_compiled_udfs(self, *args, **kwargs):
                """
                For this Fluent session, specify whether to allow auto-compilation of compiled UDF when a case file (or settings file) is read.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/auto_compile_compiled_udfs").execute(*args, **kwargs)
            def compiled_functions(self, *args, **kwargs):
                """
                Open user-defined function library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compiled_functions").execute(*args, **kwargs)
            def execute_on_demand(self, *args, **kwargs):
                """
                Execute UDFs on demand.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/execute_on_demand").execute(*args, **kwargs)
            def user_defined_memory(self, *args, **kwargs):
                """
                Allocate user-defined memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_memory").execute(*args, **kwargs)
            def interpreted_functions(self, *args, **kwargs):
                """
                Load interpreted user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/interpreted_functions").execute(*args, **kwargs)
            def enable_udf_on_gpu(self, *args, **kwargs):
                """
                Compile UDFs with OpenCL support.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/enable_udf_on_gpu").execute(*args, **kwargs)
            def function_hooks(self, *args, **kwargs):
                """
                Hook up user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/function_hooks").execute(*args, **kwargs)

            class real_gas_models(TUIMenu):
                """
                Enable/configure real gas model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def user_defined_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined multispecies real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_multispecies_real_gas_model").execute(*args, **kwargs)
                def nist_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_multispecies_real_gas_model").execute(*args, **kwargs)
                def nist_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_real_gas_model").execute(*args, **kwargs)
                def user_defined_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_real_gas_model").execute(*args, **kwargs)
                def set_state(self, *args, **kwargs):
                    """
                    Select state for NIST real gas model.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/set_state").execute(*args, **kwargs)
                def nist_settings(self, *args, **kwargs):
                    """
                    Select refprop library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_settings").execute(*args, **kwargs)

        class parameters(TUIMenu):
            """
            Enter the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enable/disable parameters in the text user interface.
                """
                return PyMenu(self.service, "/parameters__and__customization/parameters/enable_in_TUI").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enter the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/delete").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/list").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/input_parameters").execute(*args, **kwargs)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/output_parameters").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enter the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/edit").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Write parameter value to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_to_file").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/delete").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Rename an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/rename").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Print all parameter values to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Write all parameter values to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/create").execute(*args, **kwargs)
                def print_to_console(self, *args, **kwargs):
                    """
                    Print parameter value to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_to_console").execute(*args, **kwargs)

    class surface(TUIMenu):
        """
        Enter the data surface manipulation menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.query = self.__class__.query(path + ["query"], service)
            self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
            super().__init__(path, service)
        def partition_surface(self, *args, **kwargs):
            """
            Defines a data surface consisting of mesh faces on the partition boundary.
            """
            return PyMenu(self.service, "/surface/partition_surface").execute(*args, **kwargs)
        def circle_slice(self, *args, **kwargs):
            """
            Extracts a circular slice.
            """
            return PyMenu(self.service, "/surface/circle_slice").execute(*args, **kwargs)
        def point_array(self, *args, **kwargs):
            """
            Extracts a rectangular array of data points.
            """
            return PyMenu(self.service, "/surface/point_array").execute(*args, **kwargs)
        def edit_surface(self, *args, **kwargs):
            """
            Allows you to edit any of the listed available surfaces.
            """
            return PyMenu(self.service, "/surface/edit_surface").execute(*args, **kwargs)
        def closest_point_search(self, *args, **kwargs):
            """
            Enable the point surface algorithm to look for the nearest point instead of reporting a creation failure.
            """
            return PyMenu(self.service, "/surface/closest_point_search").execute(*args, **kwargs)
        def zone_surface(self, *args, **kwargs):
            """
            Creates a surface of a designated zone and gives it a specified name.
            """
            return PyMenu(self.service, "/surface/zone_surface").execute(*args, **kwargs)
        def structural_point_surface(self, *args, **kwargs):
            """
            Defines a structural “point" surface by specifying the coordinates.
            """
            return PyMenu(self.service, "/surface/structural_point_surface").execute(*args, **kwargs)
        def multiple_plane_surfaces(self, *args, **kwargs):
            """
            Creates multiple planes at once. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_plane_surfaces").execute(*args, **kwargs)
        def line_slice(self, *args, **kwargs):
            """
            Extracts a linear slice in 2D, given the normal to the line and a distance from the origin.
            """
            return PyMenu(self.service, "/surface/line_slice").execute(*args, **kwargs)
        def plane_slice(self, *args, **kwargs):
            """
            Extracts a planar slice.
            """
            return PyMenu(self.service, "/surface/plane_slice").execute(*args, **kwargs)
        def mouse_line(self, *args, **kwargs):
            """
            Extracts a line surface that you define by using the mouse to select the endpoints.
            """
            return PyMenu(self.service, "/surface/mouse_line").execute(*args, **kwargs)
        def quadric_slice(self, *args, **kwargs):
            """
            Extracts a quadric slice.
            """
            return PyMenu(self.service, "/surface/quadric_slice").execute(*args, **kwargs)
        def transform_surface(self, *args, **kwargs):
            """
            Transforms surface.
            """
            return PyMenu(self.service, "/surface/transform_surface").execute(*args, **kwargs)
        def surface_cells(self, *args, **kwargs):
            """
            Extracts all cells intersected by a data surface.
            """
            return PyMenu(self.service, "/surface/surface_cells").execute(*args, **kwargs)
        def plane(self, *args, **kwargs):
            """
            Create a plane given 3 points bounded by the domain.
            """
            return PyMenu(self.service, "/surface/plane").execute(*args, **kwargs)
        def delete_surface(self, *args, **kwargs):
            """
            Removes a defined data surface.
            """
            return PyMenu(self.service, "/surface/delete_surface").execute(*args, **kwargs)
        def cone_slice(self, *args, **kwargs):
            """
            Extract a cone slice.
            """
            return PyMenu(self.service, "/surface/cone_slice").execute(*args, **kwargs)
        def plane_surface(self, *args, **kwargs):
            """
            Create a plane from a coordinate plane, point and normal, or three points.
            """
            return PyMenu(self.service, "/surface/plane_surface").execute(*args, **kwargs)
        def line_surface(self, *args, **kwargs):
            """
            Defines a “line" surface by specifying the two endpoint coordinates.
            """
            return PyMenu(self.service, "/surface/line_surface").execute(*args, **kwargs)
        def multiple_zone_surfaces(self, *args, **kwargs):
            """
            Creates multiple data surfaces at one time. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_zone_surfaces").execute(*args, **kwargs)
        def expression_volume(self, *args, **kwargs):
            """
            Create volume with boolean expression.
            """
            return PyMenu(self.service, "/surface/expression_volume").execute(*args, **kwargs)
        def sphere_slice(self, *args, **kwargs):
            """
            Extracts a spherical slice.
            """
            return PyMenu(self.service, "/surface/sphere_slice").execute(*args, **kwargs)
        def iso_clip(self, *args, **kwargs):
            """
            Clips a data surface (surface, curve, or point) between two isovalues.
            """
            return PyMenu(self.service, "/surface/iso_clip").execute(*args, **kwargs)
        def create_imprint_surface(self, *args, **kwargs):
            """
            Imprint surface.
            """
            return PyMenu(self.service, "/surface/create_imprint_surface").execute(*args, **kwargs)
        def ellipsoid_slice(self, *args, **kwargs):
            """
            Extract a ellipsoid slice.
            """
            return PyMenu(self.service, "/surface/ellipsoid_slice").execute(*args, **kwargs)
        def mouse_rake(self, *args, **kwargs):
            """
            Extracts a “rake" surface that you define by using the mouse to select the endpoints.
            """
            return PyMenu(self.service, "/surface/mouse_rake").execute(*args, **kwargs)
        def iso_surface(self, *args, **kwargs):
            """
            Extracts an iso-surface (surface, curve, or point) from the current data field.
            """
            return PyMenu(self.service, "/surface/iso_surface").execute(*args, **kwargs)
        def point_surface(self, *args, **kwargs):
            """
            Defines a “point" surface by specifying the coordinates.
            """
            return PyMenu(self.service, "/surface/point_surface").execute(*args, **kwargs)
        def group_surfaces(self, *args, **kwargs):
            """
            Group a set of surfaces.
            """
            return PyMenu(self.service, "/surface/group_surfaces").execute(*args, **kwargs)
        def list_surfaces(self, *args, **kwargs):
            """
            Displays the ID and name, and the number of point, curve, and surface facets of the current surfaces.
            """
            return PyMenu(self.service, "/surface/list_surfaces").execute(*args, **kwargs)
        def rake_surface(self, *args, **kwargs):
            """
            Extracts a “rake" surface, given the coordinates of the endpoints.
            """
            return PyMenu(self.service, "/surface/rake_surface").execute(*args, **kwargs)
        def ungroup_surface(self, *args, **kwargs):
            """
            Ungroup the surface(if grouped).
            """
            return PyMenu(self.service, "/surface/ungroup_surface").execute(*args, **kwargs)
        def mouse_plane(self, *args, **kwargs):
            """
            Extracts a planar surface defined by selecting three points with the mouse.
            """
            return PyMenu(self.service, "/surface/mouse_plane").execute(*args, **kwargs)
        def reset_zone_surfaces(self, *args, **kwargs):
            """
            Recreates missing surface zones by resetting the case surface list.
            """
            return PyMenu(self.service, "/surface/reset_zone_surfaces").execute(*args, **kwargs)
        def rename_surface(self, *args, **kwargs):
            """
            Renames a defined data surface.
            """
            return PyMenu(self.service, "/surface/rename_surface").execute(*args, **kwargs)
        def multiple_iso_surfaces(self, *args, **kwargs):
            """
            Creates multiple iso-surfaces at once. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_iso_surfaces").execute(*args, **kwargs)

        class query(TUIMenu):
            """
            Enter surface query menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def named_surface_list(self, *args, **kwargs):
                """
                Create named list of surfaces.
                """
                return PyMenu(self.service, "/surface/query/named_surface_list").execute(*args, **kwargs)
            def list_named_selection(self, *args, **kwargs):
                """
                List named selection of surface type.
                """
                return PyMenu(self.service, "/surface/query/list_named_selection").execute(*args, **kwargs)
            def list_queries(self, *args, **kwargs):
                """
                List all saved queries.
                """
                return PyMenu(self.service, "/surface/query/list_queries").execute(*args, **kwargs)
            def delete_query(self, *args, **kwargs):
                """
                Delete saved query.
                """
                return PyMenu(self.service, "/surface/query/delete_query").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List surfaces.
                """
                return PyMenu(self.service, "/surface/query/list_surfaces").execute(*args, **kwargs)

        class post_processing_volume(TUIMenu):
            """
            Enter post-processing volume menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def create_octree(self, *args, **kwargs):
                """
                Create post-processing octree mesh based on current case.
                """
                return PyMenu(self.service, "/surface/post_processing_volume/create_octree").execute(*args, **kwargs)
            def create_from_file(self, *args, **kwargs):
                """
                Read post-processing mesh from file.
                """
                return PyMenu(self.service, "/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)

    class results(TUIMenu):
        """
        Enter results menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.surface = self.__class__.surface(path + ["surface"], service)
            self.graphics = self.__class__.graphics(path + ["graphics"], service)
            self.graphics_window = self.__class__.graphics_window(path + ["graphics_window"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            self.report = self.__class__.report(path + ["report"], service)
            self.plot = self.__class__.plot(path + ["plot"], service)
            super().__init__(path, service)

        class surface(TUIMenu):
            """
            Enter the data surface manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
                self.query = self.__class__.query(path + ["query"], service)
                super().__init__(path, service)
            def plane_slice(self, *args, **kwargs):
                """
                Extract a planar slice.
                """
                return PyMenu(self.service, "/results/surface/plane_slice").execute(*args, **kwargs)
            def surface_cells(self, *args, **kwargs):
                """
                Extract all cells intersected by a data surface.
                """
                return PyMenu(self.service, "/results/surface/surface_cells").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List the number of facets in the defined surfaces.
                """
                return PyMenu(self.service, "/results/surface/list_surfaces").execute(*args, **kwargs)
            def iso_clip(self, *args, **kwargs):
                """
                Clip a data surface (surface, curve, or point) between two iso-values.
                """
                return PyMenu(self.service, "/results/surface/iso_clip").execute(*args, **kwargs)
            def plane(self, *args, **kwargs):
                """
                Create a plane given 3 points bounded by the domain.
                """
                return PyMenu(self.service, "/results/surface/plane").execute(*args, **kwargs)
            def rake_surface(self, *args, **kwargs):
                """
                Define a "rake" surface by specifying the end points.
                """
                return PyMenu(self.service, "/results/surface/rake_surface").execute(*args, **kwargs)
            def delete_surface(self, *args, **kwargs):
                """
                Remove a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/delete_surface").execute(*args, **kwargs)
            def line_slice(self, *args, **kwargs):
                """
                Extract a linear slice.
                """
                return PyMenu(self.service, "/results/surface/line_slice").execute(*args, **kwargs)
            def mouse_rake(self, *args, **kwargs):
                """
                Define a "rake" surface using the mouse to select the end points.
                """
                return PyMenu(self.service, "/results/surface/mouse_rake").execute(*args, **kwargs)
            def multiple_iso_surfaces(self, *args, **kwargs):
                """
                Create multiple iso-surfaces from the data field at specified spacing.
                """
                return PyMenu(self.service, "/results/surface/multiple_iso_surfaces").execute(*args, **kwargs)
            def partition_surface(self, *args, **kwargs):
                """
                Define a data surface on mesh faces on the partition boundary.
                """
                return PyMenu(self.service, "/results/surface/partition_surface").execute(*args, **kwargs)
            def multiple_zone_surfaces(self, *args, **kwargs):
                """
                Create multiple data surfaces at a time.
                """
                return PyMenu(self.service, "/results/surface/multiple_zone_surfaces").execute(*args, **kwargs)
            def circle_slice(self, *args, **kwargs):
                """
                Extract a circular slice.
                """
                return PyMenu(self.service, "/results/surface/circle_slice").execute(*args, **kwargs)
            def cone_slice(self, *args, **kwargs):
                """
                Extract a cone slice.
                """
                return PyMenu(self.service, "/results/surface/cone_slice").execute(*args, **kwargs)
            def reset_zone_surfaces(self, *args, **kwargs):
                """
                Reset case surface list.
                """
                return PyMenu(self.service, "/results/surface/reset_zone_surfaces").execute(*args, **kwargs)
            def transform_surface(self, *args, **kwargs):
                """
                Transform surface.
                """
                return PyMenu(self.service, "/results/surface/transform_surface").execute(*args, **kwargs)
            def quadric_slice(self, *args, **kwargs):
                """
                Extract a quadric slice.
                """
                return PyMenu(self.service, "/results/surface/quadric_slice").execute(*args, **kwargs)
            def point_array(self, *args, **kwargs):
                """
                Extract a rectangular array of data points.
                """
                return PyMenu(self.service, "/results/surface/point_array").execute(*args, **kwargs)
            def zone_surface(self, *args, **kwargs):
                """
                Define a data surface on a mesh zone.
                """
                return PyMenu(self.service, "/results/surface/zone_surface").execute(*args, **kwargs)
            def point_surface(self, *args, **kwargs):
                """
                Define a "point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/results/surface/point_surface").execute(*args, **kwargs)
            def create_imprint_surface(self, *args, **kwargs):
                """
                Imprint surface.
                """
                return PyMenu(self.service, "/results/surface/create_imprint_surface").execute(*args, **kwargs)
            def structural_point_surface(self, *args, **kwargs):
                """
                Define a "structural point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/results/surface/structural_point_surface").execute(*args, **kwargs)
            def iso_surface(self, *args, **kwargs):
                """
                Extract an iso-surface (surface, curve, or point) from the curent data field.
                """
                return PyMenu(self.service, "/results/surface/iso_surface").execute(*args, **kwargs)
            def multiple_plane_surfaces(self, *args, **kwargs):
                """
                Create multiple plane surfaces at specified spacing.
                """
                return PyMenu(self.service, "/results/surface/multiple_plane_surfaces").execute(*args, **kwargs)
            def rename_surface(self, *args, **kwargs):
                """
                Rename a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/rename_surface").execute(*args, **kwargs)
            def closest_point_search(self, *args, **kwargs):
                """
                Enable the point surface algorithm to look for the nearest point instead of reporting a creation failure.
                """
                return PyMenu(self.service, "/results/surface/closest_point_search").execute(*args, **kwargs)
            def mouse_plane(self, *args, **kwargs):
                """
                Define a plane surface using the mouse to select three points.
                """
                return PyMenu(self.service, "/results/surface/mouse_plane").execute(*args, **kwargs)
            def line_surface(self, *args, **kwargs):
                """
                Define a "line" surface by specifying the two endpoint coordinates.
                """
                return PyMenu(self.service, "/results/surface/line_surface").execute(*args, **kwargs)
            def ungroup_surface(self, *args, **kwargs):
                """
                Ungroup the surface(if grouped).
                """
                return PyMenu(self.service, "/results/surface/ungroup_surface").execute(*args, **kwargs)
            def plane_surface(self, *args, **kwargs):
                """
                Create a plane from a coordinate plane, point and normal, or three points.
                """
                return PyMenu(self.service, "/results/surface/plane_surface").execute(*args, **kwargs)
            def edit_surface(self, *args, **kwargs):
                """
                Edit a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/edit_surface").execute(*args, **kwargs)
            def group_surfaces(self, *args, **kwargs):
                """
                Group a set of surfaces.
                """
                return PyMenu(self.service, "/results/surface/group_surfaces").execute(*args, **kwargs)
            def expression_volume(self, *args, **kwargs):
                """
                Create volume with boolean expression.
                """
                return PyMenu(self.service, "/results/surface/expression_volume").execute(*args, **kwargs)
            def mouse_line(self, *args, **kwargs):
                """
                Define a line surface using the mouse to select two points.
                """
                return PyMenu(self.service, "/results/surface/mouse_line").execute(*args, **kwargs)
            def ellipsoid_slice(self, *args, **kwargs):
                """
                Extract a ellipsoid slice.
                """
                return PyMenu(self.service, "/results/surface/ellipsoid_slice").execute(*args, **kwargs)
            def sphere_slice(self, *args, **kwargs):
                """
                Extract a spherical slice.
                """
                return PyMenu(self.service, "/results/surface/sphere_slice").execute(*args, **kwargs)

            class post_processing_volume(TUIMenu):
                """
                Enter post-processing volume menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create_octree(self, *args, **kwargs):
                    """
                    Create post-processing octree mesh based on current case.
                    """
                    return PyMenu(self.service, "/results/surface/post_processing_volume/create_octree").execute(*args, **kwargs)
                def create_from_file(self, *args, **kwargs):
                    """
                    Read post-processing mesh from file.
                    """
                    return PyMenu(self.service, "/results/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter surface query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/results/surface/query/delete_query").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_queries").execute(*args, **kwargs)
                def named_surface_list(self, *args, **kwargs):
                    """
                    Create named list of surfaces.
                    """
                    return PyMenu(self.service, "/results/surface/query/named_surface_list").execute(*args, **kwargs)
                def list_surfaces(self, *args, **kwargs):
                    """
                    List surfaces.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_surfaces").execute(*args, **kwargs)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of surface type.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_named_selection").execute(*args, **kwargs)

        class graphics(TUIMenu):
            """
            Enter graphics menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.update_scene = self.__class__.update_scene(path + ["update_scene"], service)
                self.lights = self.__class__.lights(path + ["lights"], service)
                self.objects = self.__class__.objects(path + ["objects"], service)
                self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                super().__init__(path, service)
            def color_map(self, *args, **kwargs):
                """
                Enter the color-map menu.
                """
                return PyMenu(self.service, "/results/graphics/color_map").execute(*args, **kwargs)
            def clear_annotations(self, *args, **kwargs):
                """
                Delete all annotation text.
                """
                return PyMenu(self.service, "/results/graphics/clear_annotations").execute(*args, **kwargs)
            def annotate(self, *args, **kwargs):
                """
                Add a text annotation string to the active graphics window.
                """
                return PyMenu(self.service, "/results/graphics/annotate").execute(*args, **kwargs)
            def hsf_file(self, *args, **kwargs):
                """
                Display hoops stream file data to active graphics window.
                """
                return PyMenu(self.service, "/results/graphics/hsf_file").execute(*args, **kwargs)

            class update_scene(TUIMenu):
                """
                Enter the scene options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def iso_sweep(self, *args, **kwargs):
                    """
                    Change iso-sweep values.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/iso_sweep").execute(*args, **kwargs)
                def draw_frame(self, *args, **kwargs):
                    """
                    Enable/disable drawing of the bounding frame.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/draw_frame").execute(*args, **kwargs)
                def set_frame(self, *args, **kwargs):
                    """
                    Change frame options.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/set_frame").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Display selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/display").execute(*args, **kwargs)
                def pathline(self, *args, **kwargs):
                    """
                    Change pathline attributes.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/pathline").execute(*args, **kwargs)
                def overlays(self, *args, **kwargs):
                    """
                    Enable/disable the overlays option.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/overlays").execute(*args, **kwargs)
                def time(self, *args, **kwargs):
                    """
                    Change time-step value.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/time").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/delete").execute(*args, **kwargs)
                def transform(self, *args, **kwargs):
                    """
                    Apply transformation matrix on selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/transform").execute(*args, **kwargs)
                def select_geometry(self, *args, **kwargs):
                    """
                    Select geometry to be updated.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/select_geometry").execute(*args, **kwargs)

            class lights(TUIMenu):
                """
                Enter the lights menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_light(self, *args, **kwargs):
                    """
                    Add or modify a directional, colored light.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/set_light").execute(*args, **kwargs)
                def headlight_on(self, *args, **kwargs):
                    """
                    Turn the light that moves with the camera on or off.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/headlight_on").execute(*args, **kwargs)
                def lights_on(self, *args, **kwargs):
                    """
                    Turn all active lighting on/off.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/lights_on").execute(*args, **kwargs)
                def set_ambient_color(self, *args, **kwargs):
                    """
                    Set the ambient light color for the scene.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/set_ambient_color").execute(*args, **kwargs)
                def lighting_interpolation(self, *args, **kwargs):
                    """
                    Set lighting interpolation method.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/lighting_interpolation").execute(*args, **kwargs)

            class objects(TUIMenu):
                """
                Enter to add, edit, delete or display graphics objects.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/edit").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/copy").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create new graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/create").execute(*args, **kwargs)
                def add_to_graphics(self, *args, **kwargs):
                    """
                    Add graphics object to existing graphics.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/add_to_graphics").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Display graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/display").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/delete").execute(*args, **kwargs)

            class rendering_options(TUIMenu):
                """
                Enter the rendering options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def double_buffering(self, *args, **kwargs):
                    """
                    Enable/disable double-buffering.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/double_buffering").execute(*args, **kwargs)
                def driver(self, *args, **kwargs):
                    """
                    Change the current graphics driver.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/driver").execute(*args, **kwargs)
                def hidden_surfaces(self, *args, **kwargs):
                    """
                    Enable/disable hidden surface removal.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                def outer_face_cull(self, *args, **kwargs):
                    """
                    Enable/disable discarding outer faces during display.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/outer_face_cull").execute(*args, **kwargs)
                def auto_spin(self, *args, **kwargs):
                    """
                    Enable/disable mouse view rotations to continue to spin the display after the button is released.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/auto_spin").execute(*args, **kwargs)
                def hidden_surface_method(self, *args, **kwargs):
                    """
                    Specify the method to perform hidden line and hidden surface rendering.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                def face_displacement(self, *args, **kwargs):
                    """
                    Set face displacement value in Z-buffer units along the Camera Z-axis.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/face_displacement").execute(*args, **kwargs)
                def surface_edge_visibility(self, *args, **kwargs):
                    """
                    Set edge visibility flags for surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/surface_edge_visibility").execute(*args, **kwargs)
                def animation_option(self, *args, **kwargs):
                    """
                    Using Wireframe / All option during animation.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/animation_option").execute(*args, **kwargs)
                def color_map_alignment(self, *args, **kwargs):
                    """
                    Set the color bar alignment.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/color_map_alignment").execute(*args, **kwargs)
                def set_rendering_options(self, *args, **kwargs):
                    """
                    Set the rendering options.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/set_rendering_options").execute(*args, **kwargs)
                def device_info(self, *args, **kwargs):
                    """
                    List information for the graphics device.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/device_info").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    Enable/Disable colormap.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/show_colormap").execute(*args, **kwargs)
                def help_text_color(self, *args, **kwargs):
                    """
                    Set the color of screen help text.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/help_text_color").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.pdf_data = self.__class__.pdf_data(path + ["pdf_data"], service)
                    self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                    self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                    self.set = self.__class__.set(path + ["set"], service)
                    self.flamelet_data = self.__class__.flamelet_data(path + ["flamelet_data"], service)
                    super().__init__(path, service)
                def surface_mesh(self, *args, **kwargs):
                    """
                    Draw the mesh defined by the specified surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/surface_mesh").execute(*args, **kwargs)
                def reacting_channel_curves(self, *args, **kwargs):
                    """
                    Plot/Report the reacting channel variables.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/reacting_channel_curves").execute(*args, **kwargs)
                def set_list_tree_separator(self, *args, **kwargs):
                    """
                    Set the separator character for list tree.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/set_list_tree_separator").execute(*args, **kwargs)
                def surface_cells(self, *args, **kwargs):
                    """
                    Draw the cells on the specified surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/surface_cells").execute(*args, **kwargs)
                def multigrid_coarsening(self, *args, **kwargs):
                    """
                    Display a coarse mesh level from the last multigrid coarsening.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/multigrid_coarsening").execute(*args, **kwargs)
                def display_custom_vector(self, *args, **kwargs):
                    """
                    Display custom vector.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/display_custom_vector").execute(*args, **kwargs)
                def mesh_partition_boundary(self, *args, **kwargs):
                    """
                    Display mesh partition boundaries.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh_partition_boundary").execute(*args, **kwargs)
                def velocity_vector(self, *args, **kwargs):
                    """
                    Display velocity vectors.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/velocity_vector").execute(*args, **kwargs)
                def re_render(self, *args, **kwargs):
                    """
                    Re-render the last contour, profile, or velocity vector plot
                    with updated surfaces, meshes, lights, colormap, rendering options, etc.,
                    without recalculating the contour data.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/re_render").execute(*args, **kwargs)
                def add_custom_vector(self, *args, **kwargs):
                    """
                    Add new custom vector definition.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/add_custom_vector").execute(*args, **kwargs)
                def mesh(self, *args, **kwargs):
                    """
                    Display the mesh.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh").execute(*args, **kwargs)
                def mesh_outline(self, *args, **kwargs):
                    """
                    Display the mesh boundaries.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh_outline").execute(*args, **kwargs)
                def contour(self, *args, **kwargs):
                    """
                    Display contours of a flow variable.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/contour").execute(*args, **kwargs)
                def zone_mesh(self, *args, **kwargs):
                    """
                    Draw the mesh defined by specified face zones.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/zone_mesh").execute(*args, **kwargs)
                def vector(self, *args, **kwargs):
                    """
                    Display space vectors.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/vector").execute(*args, **kwargs)
                def profile(self, *args, **kwargs):
                    """
                    Display profiles of a flow variable.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/profile").execute(*args, **kwargs)
                def graphics_window_layout(self, *args, **kwargs):
                    """
                    Arrange the graphics window layout.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/graphics_window_layout").execute(*args, **kwargs)
                def re_scale(self, *args, **kwargs):
                    """
                    Re-render the last contour, profile, or velocity vector plot
                    with updated scale, surfaces, meshes, lights, colormap, rendering options, etc.,
                    without recalculating the field data.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/re_scale").execute(*args, **kwargs)

                class pdf_data(TUIMenu):
                    """
                    Enter the PDF data menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def carpet_plot(self, *args, **kwargs):
                        """
                        Enable/disable the display of a carpet plot of a property.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/carpet_plot").execute(*args, **kwargs)
                    def write_to_file(self, *args, **kwargs):
                        """
                        Enable/disable writing the 1D-slice to file instead of plot.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/write_to_file").execute(*args, **kwargs)
                    def draw_number_box(self, *args, **kwargs):
                        """
                        Enable/disable the display of the numbers box.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/draw_number_box").execute(*args, **kwargs)
                    def plot_1d_slice(self, *args, **kwargs):
                        """
                        Enable/disable a plot of the 1D-slice.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/plot_1d_slice").execute(*args, **kwargs)

                class particle_tracks(TUIMenu):
                    """
                    Enter the particle tracks menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def plot_write_xy_plot(self, *args, **kwargs):
                        """
                        Plot or write XY plot of particle tracks.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/particle_tracks/plot_write_xy_plot").execute(*args, **kwargs)
                    def particle_tracks(self, *args, **kwargs):
                        """
                        Calculate and display particle tracks from defined injections.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/particle_tracks/particle_tracks").execute(*args, **kwargs)

                class path_lines(TUIMenu):
                    """
                    Enter the pathlines menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def plot_write_xy_plot(self, *args, **kwargs):
                        """
                        Plot or write XY plot of pathline.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/plot_write_xy_plot").execute(*args, **kwargs)
                    def path_lines(self, *args, **kwargs):
                        """
                        Display pathlines from a surface.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/path_lines").execute(*args, **kwargs)
                    def write_to_files(self, *args, **kwargs):
                        """
                        Write Pathlines to a File.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/write_to_files").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the set menu to set display parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                        self.windows = self.__class__.windows(path + ["windows"], service)
                        self.picture = self.__class__.picture(path + ["picture"], service)
                        self.velocity_vectors = self.__class__.velocity_vectors(path + ["velocity_vectors"], service)
                        self.colors = self.__class__.colors(path + ["colors"], service)
                        self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                        self.contours = self.__class__.contours(path + ["contours"], service)
                        self.titles = self.__class__.titles(path + ["titles"], service)
                        self.lights = self.__class__.lights(path + ["lights"], service)
                        self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                        super().__init__(path, service)
                    def mesh_display_configuration(self, *args, **kwargs):
                        """
                        Set mesh display configuration.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_display_configuration").execute(*args, **kwargs)
                    def line_weight(self, *args, **kwargs):
                        """
                        Set the line-weight factor for the window.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/line_weight").execute(*args, **kwargs)
                    def mirror_zones(self, *args, **kwargs):
                        """
                        Set zones to mirror the domain about.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mirror_zones").execute(*args, **kwargs)
                    def mesh_partitions(self, *args, **kwargs):
                        """
                        Enable/disable drawing of the mesh partition boundaries.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_partitions").execute(*args, **kwargs)
                    def proximity_zones(self, *args, **kwargs):
                        """
                        Set zones to be used for boundary cell distance and boundary proximity.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/proximity_zones").execute(*args, **kwargs)
                    def element_shrink(self, *args, **kwargs):
                        """
                        Set percentage to shrink elements.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/element_shrink").execute(*args, **kwargs)
                    def periodic_instancing(self, *args, **kwargs):
                        """
                        Set periodic instancing.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/periodic_instancing").execute(*args, **kwargs)
                    def overlays(self, *args, **kwargs):
                        """
                        Enable/disable overlays.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/overlays").execute(*args, **kwargs)
                    def nodewt_based_interp(self, *args, **kwargs):
                        """
                        Use more accurate node-weight based interpolation for postprocessing.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/nodewt_based_interp").execute(*args, **kwargs)
                    def n_stream_func(self, *args, **kwargs):
                        """
                        Set the number of iterations used in computing stream function.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/n_stream_func").execute(*args, **kwargs)
                    def reset_graphics(self, *args, **kwargs):
                        """
                        Reset the graphics system.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/reset_graphics").execute(*args, **kwargs)
                    def render_mesh(self, *args, **kwargs):
                        """
                        Enable/disable rendering the mesh on top of contours, vectors, etc.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/render_mesh").execute(*args, **kwargs)
                    def mesh_zones(self, *args, **kwargs):
                        """
                        Set zone IDs to be drawn as mesh.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_zones").execute(*args, **kwargs)
                    def mesh_level(self, *args, **kwargs):
                        """
                        Set coarse mesh level to be drawn.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_level").execute(*args, **kwargs)
                    def marker_symbol(self, *args, **kwargs):
                        """
                        Set the type of markers used to represent points.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/marker_symbol").execute(*args, **kwargs)
                    def filled_mesh(self, *args, **kwargs):
                        """
                        Enable/disable the filled mesh option.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/filled_mesh").execute(*args, **kwargs)
                    def zero_angle_dir(self, *args, **kwargs):
                        """
                        Set the vector having zero angular coordinates.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/zero_angle_dir").execute(*args, **kwargs)
                    def duplicate_node_display(self, *args, **kwargs):
                        """
                        Set flag to remove duplicate nodes in mesh display.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/duplicate_node_display").execute(*args, **kwargs)
                    def color_map(self, *args, **kwargs):
                        """
                        Enter the color-map menu.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/color_map").execute(*args, **kwargs)
                    def mesh_surfaces(self, *args, **kwargs):
                        """
                        Set surface IDs to be drawn as mesh.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_surfaces").execute(*args, **kwargs)
                    def marker_size(self, *args, **kwargs):
                        """
                        Set the size of markers used to represent points.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/marker_size").execute(*args, **kwargs)

                    class path_lines(TUIMenu):
                        """
                        Enter the path-lines menu to set parameters for the display of pathlines.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def arrow_space(self, *args, **kwargs):
                            """
                            Set the spacing factor for arrows drawn on pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/arrow_space").execute(*args, **kwargs)
                        def error_control(self, *args, **kwargs):
                            """
                            Set error control during pathline computation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/error_control").execute(*args, **kwargs)
                        def twist_factor(self, *args, **kwargs):
                            """
                            Set the scale factor for twisting (ribbons only).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/twist_factor").execute(*args, **kwargs)
                        def reverse(self, *args, **kwargs):
                            """
                            Enable/disable the direction of path tracking.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/reverse").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set display style for pathlines (line/ribbon/cylinder).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/style").execute(*args, **kwargs)
                        def step_size(self, *args, **kwargs):
                            """
                            Set the step length between particle positions for path-lines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/step_size").execute(*args, **kwargs)
                        def maximum_error(self, *args, **kwargs):
                            """
                            Set the maximum error allowed while computing the pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/maximum_error").execute(*args, **kwargs)
                        def radius(self, *args, **kwargs):
                            """
                            Set the radius for pathline (ribbons/cylinder only) cross-section.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/radius").execute(*args, **kwargs)
                        def arrow_scale(self, *args, **kwargs):
                            """
                            Set the scale factor for arrows drawn on pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/arrow_scale").execute(*args, **kwargs)
                        def track_in_phase(self, *args, **kwargs):
                            """
                            Assign phase to display pathlines in.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/track_in_phase").execute(*args, **kwargs)
                        def marker_size(self, *args, **kwargs):
                            """
                            Set the marker size for particle drawing.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/marker_size").execute(*args, **kwargs)
                        def display_steps(self, *args, **kwargs):
                            """
                            Set the display stepping for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/display_steps").execute(*args, **kwargs)
                        def line_width(self, *args, **kwargs):
                            """
                            Set the width for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/line_width").execute(*args, **kwargs)
                        def relative_pathlines(self, *args, **kwargs):
                            """
                            Enable/disable the tracking of pathlines in a relative coordinate system.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/relative_pathlines").execute(*args, **kwargs)
                        def sphere_attrib(self, *args, **kwargs):
                            """
                            Specify size and no. of slices to be used in drawing sphere for sphere-style.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/sphere_attrib").execute(*args, **kwargs)
                        def maximum_steps(self, *args, **kwargs):
                            """
                            Set the maximum number of steps to take for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/maximum_steps").execute(*args, **kwargs)

                    class windows(TUIMenu):
                        """
                        Enter the window options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.xy = self.__class__.xy(path + ["xy"], service)
                            self.axes = self.__class__.axes(path + ["axes"], service)
                            self.text = self.__class__.text(path + ["text"], service)
                            self.scale = self.__class__.scale(path + ["scale"], service)
                            self.main = self.__class__.main(path + ["main"], service)
                            self.video = self.__class__.video(path + ["video"], service)
                            super().__init__(path, service)
                        def logo(self, *args, **kwargs):
                            """
                            .
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/logo").execute(*args, **kwargs)
                        def ruler(self, *args, **kwargs):
                            """
                            .
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/ruler").execute(*args, **kwargs)
                        def logo_color(self, *args, **kwargs):
                            """
                            .
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/logo_color").execute(*args, **kwargs)
                        def aspect_ratio(self, *args, **kwargs):
                            """
                            .
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/aspect_ratio").execute(*args, **kwargs)

                        class xy(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/bottom").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/top").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/left").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/border").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/visible").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/right").execute(*args, **kwargs)

                        class axes(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def clear(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/clear").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/bottom").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/visible").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/border").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/right").execute(*args, **kwargs)

                        class text(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def clear(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/clear").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/top").execute(*args, **kwargs)
                            def application(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/application").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/left").execute(*args, **kwargs)
                            def date(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/date").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/visible").execute(*args, **kwargs)
                            def alignment(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/alignment").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/bottom").execute(*args, **kwargs)
                            def company(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/company").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/right").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/border").execute(*args, **kwargs)

                        class scale(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/border").execute(*args, **kwargs)
                            def format(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/format").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/visible").execute(*args, **kwargs)
                            def margin(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/margin").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/bottom").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/left").execute(*args, **kwargs)
                            def font_size(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/font_size").execute(*args, **kwargs)
                            def clear(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/clear").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/top").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/right").execute(*args, **kwargs)

                        class main(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/right").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/left").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/bottom").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/visible").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/border").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/top").execute(*args, **kwargs)

                        class video(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def background(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/background").execute(*args, **kwargs)
                            def on(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/on").execute(*args, **kwargs)
                            def color_filter(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/color_filter").execute(*args, **kwargs)
                            def pixel_size(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/pixel_size").execute(*args, **kwargs)
                            def foreground(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/foreground").execute(*args, **kwargs)

                    class picture(TUIMenu):
                        """
                        Enter the hardcopy/save-picture options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                            self.driver = self.__class__.driver(path + ["driver"], service)
                            super().__init__(path, service)
                        def invert_background(self, *args, **kwargs):
                            """
                            Use a white background when the picture is saved.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/invert_background").execute(*args, **kwargs)
                        def landscape(self, *args, **kwargs):
                            """
                            Plot hardcopies in landscape or portrait orientation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/landscape").execute(*args, **kwargs)
                        def dpi(self, *args, **kwargs):
                            """
                            Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/dpi").execute(*args, **kwargs)
                        def y_resolution(self, *args, **kwargs):
                            """
                            Set the height of raster-formatted images in pixels (0 implies current window size).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/y_resolution").execute(*args, **kwargs)
                        def set_standard_resolution(self, *args, **kwargs):
                            """
                            Select from pre-defined resolution list.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/set_standard_resolution").execute(*args, **kwargs)
                        def preview(self, *args, **kwargs):
                            """
                            Display a preview image of a hardcopy.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/preview").execute(*args, **kwargs)
                        def use_window_resolution(self, *args, **kwargs):
                            """
                            Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/use_window_resolution").execute(*args, **kwargs)
                        def x_resolution(self, *args, **kwargs):
                            """
                            Set the width of raster-formatted images in pixels (0 implies current window size).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/x_resolution").execute(*args, **kwargs)
                        def jpeg_hardcopy_quality(self, *args, **kwargs):
                            """
                            To set jpeg hardcopy quality.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)

                        class color_mode(TUIMenu):
                            """
                            Enter the hardcopy color mode menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def gray_scale(self, *args, **kwargs):
                                """
                                Convert color to grayscale for hardcopy.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/gray_scale").execute(*args, **kwargs)
                            def mono_chrome(self, *args, **kwargs):
                                """
                                Convert color to monochrome (black and white) for hardcopy.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/mono_chrome").execute(*args, **kwargs)
                            def color(self, *args, **kwargs):
                                """
                                Plot hardcopies in color.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/color").execute(*args, **kwargs)
                            def list(self, *args, **kwargs):
                                """
                                Display the current hardcopy color mode.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/list").execute(*args, **kwargs)

                        class driver(TUIMenu):
                            """
                            Enter the set hardcopy driver menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.post_format = self.__class__.post_format(path + ["post_format"], service)
                                super().__init__(path, service)
                            def png(self, *args, **kwargs):
                                """
                                Use PNG output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/png").execute(*args, **kwargs)
                            def list(self, *args, **kwargs):
                                """
                                List the current hardcopy driver.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/list").execute(*args, **kwargs)
                            def dump_window(self, *args, **kwargs):
                                """
                                Set the command used to dump the graphics window to a file.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/dump_window").execute(*args, **kwargs)
                            def glb(self, *args, **kwargs):
                                """
                                Use GLB output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/glb").execute(*args, **kwargs)
                            def ppm(self, *args, **kwargs):
                                """
                                Produce PPM output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/ppm").execute(*args, **kwargs)
                            def eps(self, *args, **kwargs):
                                """
                                Produce encapsulated PostScript (EPS) output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/eps").execute(*args, **kwargs)
                            def hsf(self, *args, **kwargs):
                                """
                                Use HSF output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/hsf").execute(*args, **kwargs)
                            def jpeg(self, *args, **kwargs):
                                """
                                Produce JPEG output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/jpeg").execute(*args, **kwargs)
                            def vrml(self, *args, **kwargs):
                                """
                                Use VRML output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/vrml").execute(*args, **kwargs)
                            def tiff(self, *args, **kwargs):
                                """
                                Use TIFF output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/tiff").execute(*args, **kwargs)
                            def options(self, *args, **kwargs):
                                """
                                Set the hardcopy options. Available options are:
                                "no gamma correction", disables gamma correction of colors,
                                "physical size = (width,height)", where width and height
                                are the actual measurements of the printable area of the page
                                in centimeters.
                                "subscreen = (left,right,bottom,top)", where left,right,
                                bottom, and top are numbers in [-1,1] describing a subwindow on
                                the page in which to place the hardcopy.
                                The options may be combined by separating them with commas.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/options").execute(*args, **kwargs)
                            def post_script(self, *args, **kwargs):
                                """
                                Produce PostScript output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_script").execute(*args, **kwargs)
                            def avz(self, *args, **kwargs):
                                """
                                Use AVZ output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/avz").execute(*args, **kwargs)

                            class post_format(TUIMenu):
                                """
                                Enter the PostScript driver format menu.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    super().__init__(path, service)
                                def fast_raster(self, *args, **kwargs):
                                    """
                                    Use the new raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/fast_raster").execute(*args, **kwargs)
                                def vector(self, *args, **kwargs):
                                    """
                                    Use vector format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/vector").execute(*args, **kwargs)
                                def raster(self, *args, **kwargs):
                                    """
                                    Use the original raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/raster").execute(*args, **kwargs)
                                def rle_raster(self, *args, **kwargs):
                                    """
                                    Use the run-length encoded raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/rle_raster").execute(*args, **kwargs)

                    class velocity_vectors(TUIMenu):
                        """
                        Enter the menu to set parameters for display of velocity vectors.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def log_scale(self, *args, **kwargs):
                            """
                            Enable/disable the use of a log scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/log_scale").execute(*args, **kwargs)
                        def component_x(self, *args, **kwargs):
                            """
                            Enable/disable use of x-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_x").execute(*args, **kwargs)
                        def relative(self, *args, **kwargs):
                            """
                            Enable/disable the display of relative velocity vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/relative").execute(*args, **kwargs)
                        def constant_length(self, *args, **kwargs):
                            """
                            Enable/disable setting all vectors to have the same length.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/constant_length").execute(*args, **kwargs)
                        def color(self, *args, **kwargs):
                            """
                            Set the color used for all vectors. Set color to the null string to use the color map.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/color").execute(*args, **kwargs)
                        def scale_head(self, *args, **kwargs):
                            """
                            Set the value by which the vector head will be scaled.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/scale_head").execute(*args, **kwargs)
                        def global_range(self, *args, **kwargs):
                            """
                            Enable/disable the global range for vectors option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/global_range").execute(*args, **kwargs)
                        def auto_scale(self, *args, **kwargs):
                            """
                            Enable/disable auto-scale of all vectors so that vector overlap is minimal.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/auto_scale").execute(*args, **kwargs)
                        def render_mesh(self, *args, **kwargs):
                            """
                            Enable/disable rendering the mseh on top of contours, vectors, etc.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/render_mesh").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set the style with which the vectors will be drawn.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/style").execute(*args, **kwargs)
                        def scale(self, *args, **kwargs):
                            """
                            Set the value by which the vector length will be scaled.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/scale").execute(*args, **kwargs)
                        def in_plane(self, *args, **kwargs):
                            """
                            Toggle the display of in-plane velocity vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/in_plane").execute(*args, **kwargs)
                        def component_z(self, *args, **kwargs):
                            """
                            Enable/disable use of z-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_z").execute(*args, **kwargs)
                        def color_levels(self, *args, **kwargs):
                            """
                            Set the number of colors used from the color map.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/color_levels").execute(*args, **kwargs)
                        def node_values(self, *args, **kwargs):
                            """
                            Enable/disable plotting node values. Cell values will be plotted if "no".
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/node_values").execute(*args, **kwargs)
                        def component_y(self, *args, **kwargs):
                            """
                            Enable/disable use of y-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_y").execute(*args, **kwargs)
                        def surfaces(self, *args, **kwargs):
                            """
                            Set surfaces on which vectors are drawn.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/surfaces").execute(*args, **kwargs)

                    class colors(TUIMenu):
                        """
                        Enter the color options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.by_surface = self.__class__.by_surface(path + ["by_surface"], service)
                            self.by_type = self.__class__.by_type(path + ["by_type"], service)
                            super().__init__(path, service)
                        def outlet_faces(self, *args, **kwargs):
                            """
                            Set the color of outlet faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/outlet_faces").execute(*args, **kwargs)
                        def color_by_type(self, *args, **kwargs):
                            """
                            Determine whether to color meshes by type or by surface (ID).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/color_by_type").execute(*args, **kwargs)
                        def rans_les_interface_faces(self, *args, **kwargs):
                            """
                            Set the color of RANS/LES interface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/rans_les_interface_faces").execute(*args, **kwargs)
                        def user_color(self, *args, **kwargs):
                            """
                            Explicitly set color of display zone.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/user_color").execute(*args, **kwargs)
                        def inlet_faces(self, *args, **kwargs):
                            """
                            Set the color of inlet faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/inlet_faces").execute(*args, **kwargs)
                        def interface_faces(self, *args, **kwargs):
                            """
                            Set the color of mesh Interfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/interface_faces").execute(*args, **kwargs)
                        def free_surface_faces(self, *args, **kwargs):
                            """
                            Set the color of free-surface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/free_surface_faces").execute(*args, **kwargs)
                        def symmetry_faces(self, *args, **kwargs):
                            """
                            Set the color of symmetric faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/symmetry_faces").execute(*args, **kwargs)
                        def skip_label(self, *args, **kwargs):
                            """
                            Set the number of labels to be skipped in the colopmap scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/skip_label").execute(*args, **kwargs)
                        def graphics_color_theme(self, *args, **kwargs):
                            """
                            Enter the graphics color theme menu.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/graphics_color_theme").execute(*args, **kwargs)
                        def far_field_faces(self, *args, **kwargs):
                            """
                            Set the color of far field faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/far_field_faces").execute(*args, **kwargs)
                        def wall_faces(self, *args, **kwargs):
                            """
                            Set the color of wall faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/wall_faces").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List available colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/list").execute(*args, **kwargs)
                        def reset_colors(self, *args, **kwargs):
                            """
                            Reset individual mesh surface colors to the defaults.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/reset_colors").execute(*args, **kwargs)
                        def axis_faces(self, *args, **kwargs):
                            """
                            Set the color of axisymmetric faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/axis_faces").execute(*args, **kwargs)
                        def foreground(self, *args, **kwargs):
                            """
                            Set the foreground (text and window frame) color.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/foreground").execute(*args, **kwargs)
                        def surface(self, *args, **kwargs):
                            """
                            Set the color of surfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/surface").execute(*args, **kwargs)
                        def automatic_skip(self, *args, **kwargs):
                            """
                            Determine whether to skip labels in the colopmap scale automatically.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/automatic_skip").execute(*args, **kwargs)
                        def periodic_faces(self, *args, **kwargs):
                            """
                            Set the color of periodic faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/periodic_faces").execute(*args, **kwargs)
                        def background(self, *args, **kwargs):
                            """
                            Set the background (window) color.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/background").execute(*args, **kwargs)
                        def overset_faces(self, *args, **kwargs):
                            """
                            Set the color of overset faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/overset_faces").execute(*args, **kwargs)
                        def show_user_colors(self, *args, **kwargs):
                            """
                            List currently defined user colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/show_user_colors").execute(*args, **kwargs)
                        def reset_user_colors(self, *args, **kwargs):
                            """
                            Reset all user colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/reset_user_colors").execute(*args, **kwargs)
                        def internal_faces(self, *args, **kwargs):
                            """
                            Set the color of internal interface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/internal_faces").execute(*args, **kwargs)
                        def traction_faces(self, *args, **kwargs):
                            """
                            Set the color of traction faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/traction_faces").execute(*args, **kwargs)
                        def interior_faces(self, *args, **kwargs):
                            """
                            Set the color of interior faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/interior_faces").execute(*args, **kwargs)

                        class by_surface(TUIMenu):
                            """
                            Enter the surface(s) color and material assignment menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def reset(self, *args, **kwargs):
                                """
                                To reset colors and/or materials to the defaults.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/reset").execute(*args, **kwargs)
                            def list_surfaces_by_color(self, *args, **kwargs):
                                """
                                To list the surfaces by its color.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/list_surfaces_by_color").execute(*args, **kwargs)
                            def surfaces(self, *args, **kwargs):
                                """
                                Select the surface(s) to specify colors and/or materials.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/surfaces").execute(*args, **kwargs)
                            def list_surfaces_by_material(self, *args, **kwargs):
                                """
                                To list the surfaces by its material.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/list_surfaces_by_material").execute(*args, **kwargs)

                        class by_type(TUIMenu):
                            """
                            Enter the zone type color and material assignment menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.type_name = self.__class__.type_name(path + ["type_name"], service)
                                super().__init__(path, service)
                            def reset(self, *args, **kwargs):
                                """
                                To reset colors and/or materials to the defaults.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/reset").execute(*args, **kwargs)
                            def only_list_case_boundaries(self, *args, **kwargs):
                                """
                                Only list the boundary types that are assigned in this case.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/only_list_case_boundaries").execute(*args, **kwargs)

                            class type_name(TUIMenu):
                                """
                                Select the boundary type to specify colors and/or materials.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    super().__init__(path, service)
                                def far_field(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/far_field").execute(*args, **kwargs)
                                def internal(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/internal").execute(*args, **kwargs)
                                def interface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/interface").execute(*args, **kwargs)
                                def traction(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/traction").execute(*args, **kwargs)
                                def inlet(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/inlet").execute(*args, **kwargs)
                                def symmetry(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/symmetry").execute(*args, **kwargs)
                                def rans_les_interface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/rans_les_interface").execute(*args, **kwargs)
                                def overset(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/overset").execute(*args, **kwargs)
                                def axis(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/axis").execute(*args, **kwargs)
                                def wall(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/wall").execute(*args, **kwargs)
                                def outlet(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/outlet").execute(*args, **kwargs)
                                def free_surface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/free_surface").execute(*args, **kwargs)
                                def interior(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/interior").execute(*args, **kwargs)
                                def surface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/surface").execute(*args, **kwargs)
                                def periodic(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/periodic").execute(*args, **kwargs)

                    class rendering_options(TUIMenu):
                        """
                        Enter the rendering options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def driver(self, *args, **kwargs):
                            """
                            Change the current graphics driver.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/driver").execute(*args, **kwargs)
                        def surface_edge_visibility(self, *args, **kwargs):
                            """
                            Set edge visibility flags for surfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/surface_edge_visibility").execute(*args, **kwargs)
                        def help_text_color(self, *args, **kwargs):
                            """
                            Set the color of screen help text.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/help_text_color").execute(*args, **kwargs)
                        def hidden_surfaces(self, *args, **kwargs):
                            """
                            Enable/disable hidden surface removal.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                        def animation_option(self, *args, **kwargs):
                            """
                            Using Wireframe / All option during animation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/animation_option").execute(*args, **kwargs)
                        def hidden_surface_method(self, *args, **kwargs):
                            """
                            Specify the method to perform hidden line and hidden surface rendering.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                        def face_displacement(self, *args, **kwargs):
                            """
                            Set face displacement value in Z-buffer units along the Camera Z-axis.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/face_displacement").execute(*args, **kwargs)
                        def outer_face_cull(self, *args, **kwargs):
                            """
                            Enable/disable discarding outer faces during display.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/outer_face_cull").execute(*args, **kwargs)
                        def device_info(self, *args, **kwargs):
                            """
                            List information for the graphics device.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/device_info").execute(*args, **kwargs)
                        def set_rendering_options(self, *args, **kwargs):
                            """
                            Set the rendering options.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/set_rendering_options").execute(*args, **kwargs)
                        def color_map_alignment(self, *args, **kwargs):
                            """
                            Set the color bar alignment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/color_map_alignment").execute(*args, **kwargs)
                        def double_buffering(self, *args, **kwargs):
                            """
                            Enable/disable double-buffering.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/double_buffering").execute(*args, **kwargs)
                        def auto_spin(self, *args, **kwargs):
                            """
                            Enable/disable mouse view rotations to continue to spin the display after the button is released.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/auto_spin").execute(*args, **kwargs)
                        def show_colormap(self, *args, **kwargs):
                            """
                            Enable/Disable colormap.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/show_colormap").execute(*args, **kwargs)

                    class contours(TUIMenu):
                        """
                        Enter the contour options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def render_mesh(self, *args, **kwargs):
                            """
                            Determine whether or not to render the mesh on top of contours, vectors, etc.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/render_mesh").execute(*args, **kwargs)
                        def n_contour(self, *args, **kwargs):
                            """
                            Set the number of contour levels.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/n_contour").execute(*args, **kwargs)
                        def surfaces(self, *args, **kwargs):
                            """
                            Set surfaces to be contoured.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/surfaces").execute(*args, **kwargs)
                        def auto_range(self, *args, **kwargs):
                            """
                            Enable/disable auto-computation of range for contours.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/auto_range").execute(*args, **kwargs)
                        def clip_to_range(self, *args, **kwargs):
                            """
                            Enable/disable the clip to range option for filled contours.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/clip_to_range").execute(*args, **kwargs)
                        def node_values(self, *args, **kwargs):
                            """
                            Enable/disable the plot of node values.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/node_values").execute(*args, **kwargs)
                        def line_contours(self, *args, **kwargs):
                            """
                            Enable/disable the filled contour option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/line_contours").execute(*args, **kwargs)
                        def coloring(self, *args, **kwargs):
                            """
                            Select coloring option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/coloring").execute(*args, **kwargs)
                        def global_range(self, *args, **kwargs):
                            """
                            Enable/disable the global range for contours option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/global_range").execute(*args, **kwargs)
                        def log_scale(self, *args, **kwargs):
                            """
                            Enable/disable the use of a log scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/log_scale").execute(*args, **kwargs)
                        def filled_contours(self, *args, **kwargs):
                            """
                            Enable/disable the filled contour option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/filled_contours").execute(*args, **kwargs)

                    class titles(TUIMenu):
                        """
                        Set problem title.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def right_middle(self, *args, **kwargs):
                            """
                            Set the title text for right middle in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_middle").execute(*args, **kwargs)
                        def right_top(self, *args, **kwargs):
                            """
                            Set the title text for right top in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_top").execute(*args, **kwargs)
                        def left_bottom(self, *args, **kwargs):
                            """
                            Set the title text for left bottom in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/left_bottom").execute(*args, **kwargs)
                        def left_top(self, *args, **kwargs):
                            """
                            Set the title text for left top in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/left_top").execute(*args, **kwargs)
                        def right_bottom(self, *args, **kwargs):
                            """
                            Set the title text for right bottom in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_bottom").execute(*args, **kwargs)

                    class lights(TUIMenu):
                        """
                        Enter the lights menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def headlight_on(self, *args, **kwargs):
                            """
                            Turn the light that moves with the camera on or off.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/headlight_on").execute(*args, **kwargs)
                        def set_ambient_color(self, *args, **kwargs):
                            """
                            Set the ambient light color for the scene.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/set_ambient_color").execute(*args, **kwargs)
                        def lights_on(self, *args, **kwargs):
                            """
                            Turn all active lighting on/off.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/lights_on").execute(*args, **kwargs)
                        def set_light(self, *args, **kwargs):
                            """
                            Add or modify a directional, colored light.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/set_light").execute(*args, **kwargs)
                        def lighting_interpolation(self, *args, **kwargs):
                            """
                            Set lighting interpolation method.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/lighting_interpolation").execute(*args, **kwargs)

                    class particle_tracks(TUIMenu):
                        """
                        Enter the particle-tracks menu to set parameters for display of particle tracks.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                            self.sphere_settings = self.__class__.sphere_settings(path + ["sphere_settings"], service)
                            self.filter_settings = self.__class__.filter_settings(path + ["filter_settings"], service)
                            super().__init__(path, service)
                        def report_default_variables(self, *args, **kwargs):
                            """
                            Set the report variables to default.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_default_variables").execute(*args, **kwargs)
                        def history_filename(self, *args, **kwargs):
                            """
                            Specify the name of the particle history file.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/history_filename").execute(*args, **kwargs)
                        def coarsen_factor(self, *args, **kwargs):
                            """
                            Set the particle tracks coarsening factor.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/coarsen_factor").execute(*args, **kwargs)
                        def report_type(self, *args, **kwargs):
                            """
                            Set the report type for particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_type").execute(*args, **kwargs)
                        def marker_size(self, *args, **kwargs):
                            """
                            Set the marker size for particle drawing.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/marker_size").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set the display style for particle track (line/ribbon/cylinder/sphere).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/style").execute(*args, **kwargs)
                        def arrow_space(self, *args, **kwargs):
                            """
                            Set the spacing factor for arrows drawn on particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/arrow_space").execute(*args, **kwargs)
                        def display(self, *args, **kwargs):
                            """
                            Determine whether particle tracks will be displayed or only tracked.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/display").execute(*args, **kwargs)
                        def sphere_attrib(self, *args, **kwargs):
                            """
                            Specify size and number of slices to be used in drawing spheres.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_attrib").execute(*args, **kwargs)
                        def twist_factor(self, *args, **kwargs):
                            """
                            Set the scale factor for twisting (ribbons only).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/twist_factor").execute(*args, **kwargs)
                        def track_single_particle_stream(self, *args, **kwargs):
                            """
                            Specify the stream ID to be tracked.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/track_single_particle_stream").execute(*args, **kwargs)
                        def report_to(self, *args, **kwargs):
                            """
                            Specify the destination for the report (console, file, none).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_to").execute(*args, **kwargs)
                        def arrow_scale(self, *args, **kwargs):
                            """
                            Set the scale factor for arrows drawn on particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/arrow_scale").execute(*args, **kwargs)
                        def particle_skip(self, *args, **kwargs):
                            """
                            Specify how many particle tracks should be displayed.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/particle_skip").execute(*args, **kwargs)
                        def line_width(self, *args, **kwargs):
                            """
                            Set the width for particle track.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/line_width").execute(*args, **kwargs)
                        def report_variables(self, *args, **kwargs):
                            """
                            Set the report variables.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_variables").execute(*args, **kwargs)
                        def radius(self, *args, **kwargs):
                            """
                            Set the radius for particle track (ribbons/cylinder only) cross-section.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/radius").execute(*args, **kwargs)

                        class vector_settings(TUIMenu):
                            """
                            Set vector specific input.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vector_length_variable(self, *args, **kwargs):
                                """
                                Select a particle variable to specify the length of vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_length_variable").execute(*args, **kwargs)
                            def vector_variable(self, *args, **kwargs):
                                """
                                Select a particle vector function to specify vector direction.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_variable").execute(*args, **kwargs)
                            def color_variable(self, *args, **kwargs):
                                """
                                Specify whether the vectors should be colored by variable specified in /display/particle-track/particle-track (if false use a constant color).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/color_variable").execute(*args, **kwargs)
                            def style(self, *args, **kwargs):
                                """
                                Enable and set the display style for particle vectors (none/vector/centered-vector/centered-cylinder).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/style").execute(*args, **kwargs)
                            def length_to_head_ratio(self, *args, **kwargs):
                                """
                                Specify ratio of length to head for vectors and length to diameter for cylinders.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/length_to_head_ratio").execute(*args, **kwargs)
                            def vector_length(self, *args, **kwargs):
                                """
                                Specify the length of constant vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_length").execute(*args, **kwargs)
                            def length_variable(self, *args, **kwargs):
                                """
                                Specify whether the displayed vectors have length varying with another variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/length_variable").execute(*args, **kwargs)
                            def constant_color(self, *args, **kwargs):
                                """
                                Specify a constant color for the vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/constant_color").execute(*args, **kwargs)
                            def scale_factor(self, *args, **kwargs):
                                """
                                Specify a scale factor to enlarge/reduce the length of vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/scale_factor").execute(*args, **kwargs)

                        class sphere_settings(TUIMenu):
                            """
                            Provide sphere specific input.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def diameter(self, *args, **kwargs):
                                """
                                Diameter of the spheres when vary-diameter? is disabled.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/diameter").execute(*args, **kwargs)
                            def size_variable(self, *args, **kwargs):
                                """
                                Select a particle variable to size the spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/size_variable").execute(*args, **kwargs)
                            def smooth_parameter(self, *args, **kwargs):
                                """
                                Specify number of slices to be used in drawing spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/smooth_parameter").execute(*args, **kwargs)
                            def maximum(self, *args, **kwargs):
                                """
                                Set the maximum value of the sphere to be displayed.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/maximum").execute(*args, **kwargs)
                            def vary_diameter(self, *args, **kwargs):
                                """
                                Specify whether the spheres can vary with another variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/vary_diameter").execute(*args, **kwargs)
                            def minimum(self, *args, **kwargs):
                                """
                                Set the minimum value of the sphere to be displayed.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/minimum").execute(*args, **kwargs)
                            def auto_range(self, *args, **kwargs):
                                """
                                Specify whether displayed spheres should include auto range of variable to size spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/auto_range").execute(*args, **kwargs)
                            def scale_factor(self, *args, **kwargs):
                                """
                                Specify a scale factor to enlarge/reduce the size of spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/scale_factor").execute(*args, **kwargs)

                        class filter_settings(TUIMenu):
                            """
                            Set filter for particle display.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def maximum(self, *args, **kwargs):
                                """
                                Specify the upper bound for the filter variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/maximum").execute(*args, **kwargs)
                            def enable_filtering(self, *args, **kwargs):
                                """
                                Specify whether particle display is filtered.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/enable_filtering").execute(*args, **kwargs)
                            def minimum(self, *args, **kwargs):
                                """
                                Specify the lower bound for the filter variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/minimum").execute(*args, **kwargs)
                            def filter_variable(self, *args, **kwargs):
                                """
                                Select a variable used for filtering of particles.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/filter_variable").execute(*args, **kwargs)
                            def inside(self, *args, **kwargs):
                                """
                                Specify whether filter variable needs to be inside min/max to be displayed (else outside min/max).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/inside").execute(*args, **kwargs)

                class flamelet_data(TUIMenu):
                    """
                    Display flamelet data.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def carpet_plot(self, *args, **kwargs):
                        """
                        Enable/disable display of carpet plot of a property.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/carpet_plot").execute(*args, **kwargs)
                    def plot_1d_slice(self, *args, **kwargs):
                        """
                        Enable/disable plot of the 1D-slice.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/plot_1d_slice").execute(*args, **kwargs)
                    def draw_number_box(self, *args, **kwargs):
                        """
                        Enable/disable display of the numbers box.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/draw_number_box").execute(*args, **kwargs)
                    def write_to_file(self, *args, **kwargs):
                        """
                        Enable/disable writing the 1D-slice to file instead of plot.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/write_to_file").execute(*args, **kwargs)

        class graphics_window(TUIMenu):
            """
            Enter graphics window menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.views = self.__class__.views(path + ["views"], service)
                self.view_sync = self.__class__.view_sync(path + ["view_sync"], service)
                self.windows = self.__class__.windows(path + ["windows"], service)
                self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
                self.picture = self.__class__.picture(path + ["picture"], service)
                self.display_states = self.__class__.display_states(path + ["display_states"], service)
                self.titles = self.__class__.titles(path + ["titles"], service)
                super().__init__(path, service)
            def update_layout(self, *args, **kwargs):
                """
                Update the fluent layout.
                """
                return PyMenu(self.service, "/results/graphics_window/update_layout").execute(*args, **kwargs)
            def set_window_by_name(self, *args, **kwargs):
                """
                Set a reserved graphics window to be the active window by its name.
                """
                return PyMenu(self.service, "/results/graphics_window/set_window_by_name").execute(*args, **kwargs)
            def close_window(self, *args, **kwargs):
                """
                Close a user graphics window.
                """
                return PyMenu(self.service, "/results/graphics_window/close_window").execute(*args, **kwargs)
            def set_window(self, *args, **kwargs):
                """
                Set a user graphics window to be the active window.
                """
                return PyMenu(self.service, "/results/graphics_window/set_window").execute(*args, **kwargs)
            def close_window_by_name(self, *args, **kwargs):
                """
                Close a reserved graphics window by its name.
                """
                return PyMenu(self.service, "/results/graphics_window/close_window_by_name").execute(*args, **kwargs)
            def open_window(self, *args, **kwargs):
                """
                Open a user graphics window.
                """
                return PyMenu(self.service, "/results/graphics_window/open_window").execute(*args, **kwargs)
            def save_picture(self, *args, **kwargs):
                """
                Generate a "hardcopy" of the active window.
                """
                return PyMenu(self.service, "/results/graphics_window/save_picture").execute(*args, **kwargs)

            class views(TUIMenu):
                """
                Enter the view manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.display_states = self.__class__.display_states(path + ["display_states"], service)
                    self.camera = self.__class__.camera(path + ["camera"], service)
                    super().__init__(path, service)
                def write_views(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/write_views").execute(*args, **kwargs)
                def delete_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/delete_view").execute(*args, **kwargs)
                def default_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/default_view").execute(*args, **kwargs)
                def save_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/save_view").execute(*args, **kwargs)
                def auto_scale(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/auto_scale").execute(*args, **kwargs)
                def restore_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/restore_view").execute(*args, **kwargs)
                def list_views(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/list_views").execute(*args, **kwargs)
                def last_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/last_view").execute(*args, **kwargs)
                def read_views(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/read_views").execute(*args, **kwargs)
                def next_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/next_view").execute(*args, **kwargs)

                class display_states(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def copy(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/copy").execute(*args, **kwargs)
                    def rename(self, *args, **kwargs):
                        """
                        Rename object.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/rename").execute(*args, **kwargs)
                    def new(self, *args, **kwargs):
                        """
                        Create a new display-states object.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/new").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/list").execute(*args, **kwargs)
                    def write(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/write").execute(*args, **kwargs)
                    def restore_state(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/restore_state").execute(*args, **kwargs)
                    def read(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/read").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit display-states object.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/edit").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete object.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/delete").execute(*args, **kwargs)
                    def use_active(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/use_active").execute(*args, **kwargs)

                class camera(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def roll_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/roll_camera").execute(*args, **kwargs)
                    def pan_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/pan_camera").execute(*args, **kwargs)
                    def zoom_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/zoom_camera").execute(*args, **kwargs)
                    def position(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/position").execute(*args, **kwargs)
                    def field(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/field").execute(*args, **kwargs)
                    def orbit_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/orbit_camera").execute(*args, **kwargs)
                    def target(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/target").execute(*args, **kwargs)
                    def dolly_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/dolly_camera").execute(*args, **kwargs)
                    def projection(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/projection").execute(*args, **kwargs)
                    def up_vector(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/up_vector").execute(*args, **kwargs)

            class view_sync(TUIMenu):
                """
                Enter the display state manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remove_all(self, *args, **kwargs):
                    """
                    Unsynchronize all windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/remove_all").execute(*args, **kwargs)
                def stop(self, *args, **kwargs):
                    """
                    Stop view synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/stop").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Print window ids of open windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/list").execute(*args, **kwargs)
                def start(self, *args, **kwargs):
                    """
                    Start view synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/start").execute(*args, **kwargs)
                def add_all(self, *args, **kwargs):
                    """
                    Synchronize all windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/add_all").execute(*args, **kwargs)
                def remove(self, *args, **kwargs):
                    """
                    Remove list of window ids from synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/remove").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add list of window ids for synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/add").execute(*args, **kwargs)

            class windows(TUIMenu):
                """
                Enter the window options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.axes = self.__class__.axes(path + ["axes"], service)
                    self.video = self.__class__.video(path + ["video"], service)
                    self.text = self.__class__.text(path + ["text"], service)
                    self.scale = self.__class__.scale(path + ["scale"], service)
                    self.xy = self.__class__.xy(path + ["xy"], service)
                    self.main = self.__class__.main(path + ["main"], service)
                    super().__init__(path, service)
                def logo(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/logo").execute(*args, **kwargs)
                def aspect_ratio(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/aspect_ratio").execute(*args, **kwargs)
                def logo_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/logo_color").execute(*args, **kwargs)
                def ruler(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/ruler").execute(*args, **kwargs)

                class axes(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/border").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/visible").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/bottom").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/clear").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/right").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def color_filter(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/color_filter").execute(*args, **kwargs)
                    def on(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/on").execute(*args, **kwargs)
                    def foreground(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/foreground").execute(*args, **kwargs)
                    def pixel_size(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/pixel_size").execute(*args, **kwargs)
                    def background(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/background").execute(*args, **kwargs)

                class text(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/top").execute(*args, **kwargs)
                    def company(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/company").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/clear").execute(*args, **kwargs)
                    def application(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/application").execute(*args, **kwargs)
                    def date(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/date").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/visible").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/border").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/left").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/bottom").execute(*args, **kwargs)
                    def alignment(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/alignment").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/right").execute(*args, **kwargs)

                class scale(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def margin(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/margin").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/format").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/border").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/visible").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/bottom").execute(*args, **kwargs)
                    def font_size(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/font_size").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/top").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/right").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/clear").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/left").execute(*args, **kwargs)

                class xy(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/right").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/top").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/left").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/border").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/visible").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/bottom").execute(*args, **kwargs)

                class main(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def left(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/left").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/border").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/bottom").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/top").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/visible").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/right").execute(*args, **kwargs)

            class embedded_windows(TUIMenu):
                """
                Enter to embed, close, move-out embedded windows.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def close_all(self, *args, **kwargs):
                    """
                    Close all embedded windows for given parent window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/close_all").execute(*args, **kwargs)
                def move_out(self, *args, **kwargs):
                    """
                    Move out an embedded window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/move_out").execute(*args, **kwargs)
                def close(self, *args, **kwargs):
                    """
                    Close an embedded window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/close").execute(*args, **kwargs)
                def embed_in(self, *args, **kwargs):
                    """
                    Embed Window into another window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/embed_in").execute(*args, **kwargs)
                def move_out_all(self, *args, **kwargs):
                    """
                    Move out all embedded windows for given parent window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/move_out_all").execute(*args, **kwargs)

            class picture(TUIMenu):
                """
                Enter the hardcopy/save-picture options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.driver = self.__class__.driver(path + ["driver"], service)
                    self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                    super().__init__(path, service)
                def landscape(self, *args, **kwargs):
                    """
                    Plot hardcopies in landscape or portrait orientation.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/landscape").execute(*args, **kwargs)
                def y_resolution(self, *args, **kwargs):
                    """
                    Set the height of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/y_resolution").execute(*args, **kwargs)
                def preview(self, *args, **kwargs):
                    """
                    Display a preview image of a hardcopy.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/preview").execute(*args, **kwargs)
                def jpeg_hardcopy_quality(self, *args, **kwargs):
                    """
                    To set jpeg hardcopy quality.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)
                def use_window_resolution(self, *args, **kwargs):
                    """
                    Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/use_window_resolution").execute(*args, **kwargs)
                def set_standard_resolution(self, *args, **kwargs):
                    """
                    Select from pre-defined resolution list.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/set_standard_resolution").execute(*args, **kwargs)
                def x_resolution(self, *args, **kwargs):
                    """
                    Set the width of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/x_resolution").execute(*args, **kwargs)
                def dpi(self, *args, **kwargs):
                    """
                    Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/dpi").execute(*args, **kwargs)
                def invert_background(self, *args, **kwargs):
                    """
                    Use a white background when the picture is saved.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/invert_background").execute(*args, **kwargs)

                class driver(TUIMenu):
                    """
                    Enter the set hardcopy driver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.post_format = self.__class__.post_format(path + ["post_format"], service)
                        super().__init__(path, service)
                    def vrml(self, *args, **kwargs):
                        """
                        Use VRML output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/vrml").execute(*args, **kwargs)
                    def png(self, *args, **kwargs):
                        """
                        Use PNG output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/png").execute(*args, **kwargs)
                    def jpeg(self, *args, **kwargs):
                        """
                        Produce JPEG output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/jpeg").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the current hardcopy driver.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/list").execute(*args, **kwargs)
                    def glb(self, *args, **kwargs):
                        """
                        Use GLB output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/glb").execute(*args, **kwargs)
                    def avz(self, *args, **kwargs):
                        """
                        Use AVZ output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/avz").execute(*args, **kwargs)
                    def options(self, *args, **kwargs):
                        """
                        Set the hardcopy options. Available options are:
                        "no gamma correction", disables gamma correction of colors,
                        "physical size = (width,height)", where width and height
                        are the actual measurements of the printable area of the page
                        in centimeters.
                        "subscreen = (left,right,bottom,top)", where left,right,
                        bottom, and top are numbers in [-1,1] describing a subwindow on
                        the page in which to place the hardcopy.
                        The options may be combined by separating them with commas.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/options").execute(*args, **kwargs)
                    def tiff(self, *args, **kwargs):
                        """
                        Use TIFF output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/tiff").execute(*args, **kwargs)
                    def hsf(self, *args, **kwargs):
                        """
                        Use HSF output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/hsf").execute(*args, **kwargs)
                    def eps(self, *args, **kwargs):
                        """
                        Produce encapsulated PostScript (EPS) output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/eps").execute(*args, **kwargs)
                    def dump_window(self, *args, **kwargs):
                        """
                        Set the command used to dump the graphics window to a file.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/dump_window").execute(*args, **kwargs)
                    def post_script(self, *args, **kwargs):
                        """
                        Produce PostScript output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/post_script").execute(*args, **kwargs)
                    def ppm(self, *args, **kwargs):
                        """
                        Produce PPM output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/ppm").execute(*args, **kwargs)

                    class post_format(TUIMenu):
                        """
                        Enter the PostScript driver format menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vector(self, *args, **kwargs):
                            """
                            Use vector format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/vector").execute(*args, **kwargs)
                        def raster(self, *args, **kwargs):
                            """
                            Use the original raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/raster").execute(*args, **kwargs)
                        def fast_raster(self, *args, **kwargs):
                            """
                            Use the new raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/fast_raster").execute(*args, **kwargs)
                        def rle_raster(self, *args, **kwargs):
                            """
                            Use the run-length encoded raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/rle_raster").execute(*args, **kwargs)

                class color_mode(TUIMenu):
                    """
                    Enter the hardcopy color mode menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list(self, *args, **kwargs):
                        """
                        Display the current hardcopy color mode.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/list").execute(*args, **kwargs)
                    def mono_chrome(self, *args, **kwargs):
                        """
                        Convert color to monochrome (black and white) for hardcopy.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/mono_chrome").execute(*args, **kwargs)
                    def gray_scale(self, *args, **kwargs):
                        """
                        Convert color to grayscale for hardcopy.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/gray_scale").execute(*args, **kwargs)
                    def color(self, *args, **kwargs):
                        """
                        Plot hardcopies in color.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/color").execute(*args, **kwargs)

            class display_states(TUIMenu):
                """
                Enter the display state manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit a particular display state setting.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/edit").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Read display states from a file.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/read").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete a display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/delete").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Create a new display state with settings copied from an existing display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/copy").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Print the names of the available display states to the console.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/list").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create a new display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/create").execute(*args, **kwargs)
                def apply(self, *args, **kwargs):
                    """
                    Apply a display state to the active window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/apply").execute(*args, **kwargs)
                def use_active(self, *args, **kwargs):
                    """
                    Update an existing display state's settings to match those of the active graphics window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/use_active").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Write display states to a file.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/write").execute(*args, **kwargs)

            class titles(TUIMenu):
                """
                Set problem title.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def left_top(self, *args, **kwargs):
                    """
                    Set the title text for left top in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/left_top").execute(*args, **kwargs)
                def right_bottom(self, *args, **kwargs):
                    """
                    Set the title text for right bottom in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_bottom").execute(*args, **kwargs)
                def right_middle(self, *args, **kwargs):
                    """
                    Set the title text for right middle in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_middle").execute(*args, **kwargs)
                def left_bottom(self, *args, **kwargs):
                    """
                    Set the title text for left bottom in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/left_bottom").execute(*args, **kwargs)
                def right_top(self, *args, **kwargs):
                    """
                    Set the title text for right top in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_top").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enter the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.playback = self.__class__.playback(path + ["playback"], service)
                super().__init__(path, service)

            class playback(TUIMenu):
                """
                Enter animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def read(self, *args, **kwargs):
                    """
                    Read new animation from file or already-defined animations.
                    """
                    return PyMenu(self.service, "/results/animate/playback/read").execute(*args, **kwargs)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Set custom frames start, end, skip frames for video export.
                    """
                    return PyMenu(self.service, "/results/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete animation sequence.
                    """
                    return PyMenu(self.service, "/results/animate/playback/delete").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Write animation sequence to the file.
                    """
                    return PyMenu(self.service, "/results/animate/playback/write").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Play the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/results/animate/playback/stored_view").execute(*args, **kwargs)
                def play(self, *args, **kwargs):
                    """
                    Play the selected animation.
                    """
                    return PyMenu(self.service, "/results/animate/playback/play").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Set options for exporting video file menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/scale").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/name").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/width").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/fps").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/height").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/format").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/use_original_resolution").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/quality").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)

        class report(TUIMenu):
            """
            Enter the report menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.forces = self.__class__.forces(path + ["forces"], service)
                self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
                self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
                self.fluxes = self.__class__.fluxes(path + ["fluxes"], service)
                self.system = self.__class__.system(path + ["system"], service)
                self.modified_setting = self.__class__.modified_setting(path + ["modified_setting"], service)
                self.dpm_histogram = self.__class__.dpm_histogram(path + ["dpm_histogram"], service)
                self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                self.icing = self.__class__.icing(path + ["icing"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                super().__init__(path, service)
            def print_histogram(self, *args, **kwargs):
                """
                Print a histogram of a scalar quantity.
                """
                return PyMenu(self.service, "/results/report/print_histogram").execute(*args, **kwargs)
            def dpm_summary(self, *args, **kwargs):
                """
                Print discrete phase summary report of particle fates.
                """
                return PyMenu(self.service, "/results/report/dpm_summary").execute(*args, **kwargs)
            def dpm_sample(self, *args, **kwargs):
                """
                Sample trajectories at boundaries and lines/planes.
                """
                return PyMenu(self.service, "/results/report/dpm_sample").execute(*args, **kwargs)
            def dpm_extended_summary(self, *args, **kwargs):
                """
                Print extended discrete phase summary report of particle fates, with options.
                """
                return PyMenu(self.service, "/results/report/dpm_extended_summary").execute(*args, **kwargs)
            def element_mass_flow(self, *args, **kwargs):
                """
                Print list of element mass flow rates at boundaries.
                """
                return PyMenu(self.service, "/results/report/element_mass_flow").execute(*args, **kwargs)
            def summary(self, *args, **kwargs):
                """
                Print report summary.
                """
                return PyMenu(self.service, "/results/report/summary").execute(*args, **kwargs)
            def dpm_sample_sort_file(self, *args, **kwargs):
                """
                Enable writing of sorted DPM sample files.
                """
                return PyMenu(self.service, "/results/report/dpm_sample_sort_file").execute(*args, **kwargs)
            def dpm_sample_output_udf(self, *args, **kwargs):
                """
                Set the DPM sampling output UDF.
                """
                return PyMenu(self.service, "/results/report/dpm_sample_output_udf").execute(*args, **kwargs)
            def dpm_zone_summaries_per_injection(self, *args, **kwargs):
                """
                Enable per-injection zone DPM summaries.
                """
                return PyMenu(self.service, "/results/report/dpm_zone_summaries_per_injection").execute(*args, **kwargs)
            def mphase_summary(self, *args, **kwargs):
                """
                Multiphase Summary and Recommendations.
                """
                return PyMenu(self.service, "/results/report/mphase_summary").execute(*args, **kwargs)
            def volume_integrals(self, *args, **kwargs):
                """
                Volume Integral menu.
                """
                return PyMenu(self.service, "/results/report/volume_integrals").execute(*args, **kwargs)
            def aero_optical_distortions(self, *args, **kwargs):
                """
                Optics report menu.
                """
                return PyMenu(self.service, "/results/report/aero_optical_distortions").execute(*args, **kwargs)
            def uds_flow(self, *args, **kwargs):
                """
                Print list of UDS flow rate at boundaries.
                """
                return PyMenu(self.service, "/results/report/uds_flow").execute(*args, **kwargs)
            def write_histogram(self, *args, **kwargs):
                """
                Write a histogram of a scalar quantity to a file.
                """
                return PyMenu(self.service, "/results/report/write_histogram").execute(*args, **kwargs)
            def surface_integrals(self, *args, **kwargs):
                """
                Surface Integral menu.
                """
                return PyMenu(self.service, "/results/report/surface_integrals").execute(*args, **kwargs)
            def particle_summary(self, *args, **kwargs):
                """
                Print summary report for all current particles.
                """
                return PyMenu(self.service, "/results/report/particle_summary").execute(*args, **kwargs)
            def path_line_summary(self, *args, **kwargs):
                """
                Print path-line-summary report.
                """
                return PyMenu(self.service, "/results/report/path_line_summary").execute(*args, **kwargs)
            def projected_surface_area(self, *args, **kwargs):
                """
                Print total area of the projection of a group of surfaces to a plane.
                """
                return PyMenu(self.service, "/results/report/projected_surface_area").execute(*args, **kwargs)
            def species_mass_flow(self, *args, **kwargs):
                """
                Print list of species mass flow rates at boundaries.
                """
                return PyMenu(self.service, "/results/report/species_mass_flow").execute(*args, **kwargs)

            class forces(TUIMenu):
                """
                Force report menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_center(self, *args, **kwargs):
                    """
                    Print center of pressure on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/pressure_center").execute(*args, **kwargs)
                def wall_moments(self, *args, **kwargs):
                    """
                    Print integrated pressure and viscous moments on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/wall_moments").execute(*args, **kwargs)
                def wall_forces(self, *args, **kwargs):
                    """
                    Print integrated pressure and viscous forces on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/wall_forces").execute(*args, **kwargs)

            class simulation_reports(TUIMenu):
                """
                Enter the simulation reports menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
                    super().__init__(path, service)
                def export_simulation_report_as_pdf(self, *args, **kwargs):
                    """
                    Export the provided simulation report as a PDF file.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
                def write_report_names_to_file(self, *args, **kwargs):
                    """
                    Write the list of currently generated report names to a txt file.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
                def view_simulation_report(self, *args, **kwargs):
                    """
                    View a simulation report that has already been generated. In batch mode this will print the report's URL.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/view_simulation_report").execute(*args, **kwargs)
                def list_simulation_reports(self, *args, **kwargs):
                    """
                    List all report names.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
                def delete_simulation_report(self, *args, **kwargs):
                    """
                    Delete the provided simulation report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
                def write_simulation_report_template_file(self, *args, **kwargs):
                    """
                    Write a JSON template file with this case's Simulation Report settings.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
                def rename_simulation_report(self, *args, **kwargs):
                    """
                    Rename a report which has already been generated.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
                def reset_report_to_defaults(self, *args, **kwargs):
                    """
                    Reset all report settings to default for the provided simulation report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
                def read_simulation_report_template_file(self, *args, **kwargs):
                    """
                    Read a JSON template file with existing Simulation Report settings.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
                def export_simulation_report_as_pptx(self, *args, **kwargs):
                    """
                    Export the provided simulation report as a PPT file.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/export_simulation_report_as_pptx").execute(*args, **kwargs)
                def export_simulation_report_as_html(self, *args, **kwargs):
                    """
                    Export the provided simulation report as HTML.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
                def generate_simulation_report(self, *args, **kwargs):
                    """
                    Generate a new simulation report or regenerate an existing simulation report with the provided name.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
                def duplicate_simulation_report(self, *args, **kwargs):
                    """
                    Duplicate a report and all of its settings to a new report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)

                class parametric_study(TUIMenu):
                    """
                    Enter the parametric study menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def generate_design_point_report(self, *args, **kwargs):
                        """
                        Generate a simulation report for an updated design point.
                        """
                        return PyMenu(self.service, "/results/report/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
                    def generate_parametric_report(self, *args, **kwargs):
                        """
                        Generate a parametric report for your study.
                        """
                        return PyMenu(self.service, "/results/report/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

            class reference_values(TUIMenu):
                """
                Reference value menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.compute = self.__class__.compute(path + ["compute"], service)
                    super().__init__(path, service)
                def yplus(self, *args, **kwargs):
                    """
                    Set reference yplus for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/yplus").execute(*args, **kwargs)
                def density(self, *args, **kwargs):
                    """
                    Set reference density for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/density").execute(*args, **kwargs)
                def depth(self, *args, **kwargs):
                    """
                    Set reference depth for volume calculation.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/depth").execute(*args, **kwargs)
                def temperature(self, *args, **kwargs):
                    """
                    Set reference temperature for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/temperature").execute(*args, **kwargs)
                def zone(self, *args, **kwargs):
                    """
                    Set reference zone.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/zone").execute(*args, **kwargs)
                def velocity(self, *args, **kwargs):
                    """
                    Set reference velocity for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/velocity").execute(*args, **kwargs)
                def length(self, *args, **kwargs):
                    """
                    Set reference length for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/length").execute(*args, **kwargs)
                def enthalpy(self, *args, **kwargs):
                    """
                    Set reference enthalpy for enthalpy damping and normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/enthalpy").execute(*args, **kwargs)
                def pressure(self, *args, **kwargs):
                    """
                    Set reference pressure for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/pressure").execute(*args, **kwargs)
                def area(self, *args, **kwargs):
                    """
                    Set reference area for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/area").execute(*args, **kwargs)
                def viscosity(self, *args, **kwargs):
                    """
                    Set reference viscosity for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/viscosity").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List current reference values.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/list").execute(*args, **kwargs)

                class compute(TUIMenu):
                    """
                    Enter the compute menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def overset(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/overset").execute(*args, **kwargs)
                    def pressure_far_field(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                    def outlet_vent(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                    def network(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/network").execute(*args, **kwargs)
                    def radiator(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/radiator").execute(*args, **kwargs)
                    def intake_fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/intake_fan").execute(*args, **kwargs)
                    def fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/fan").execute(*args, **kwargs)
                    def interface(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/interface").execute(*args, **kwargs)
                    def mass_flow_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                    def degassing(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/degassing").execute(*args, **kwargs)
                    def outflow(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/outflow").execute(*args, **kwargs)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                    def periodic(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/periodic").execute(*args, **kwargs)
                    def rans_les_interface(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                    def recirculation_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                    def porous_jump(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/porous_jump").execute(*args, **kwargs)
                    def axis(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/axis").execute(*args, **kwargs)
                    def network_end(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/network_end").execute(*args, **kwargs)
                    def recirculation_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                    def symmetry(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/symmetry").execute(*args, **kwargs)
                    def interior(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/interior").execute(*args, **kwargs)
                    def inlet_vent(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                    def dummy_entry(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                    def wall(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/wall").execute(*args, **kwargs)
                    def geometry(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/geometry").execute(*args, **kwargs)
                    def fluid(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/fluid").execute(*args, **kwargs)
                    def mass_flow_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                    def solid(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/solid").execute(*args, **kwargs)
                    def shadow(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/shadow").execute(*args, **kwargs)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                    def exhaust_fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/exhaust_fan").execute(*args, **kwargs)

            class fluxes(TUIMenu):
                """
                Flux report menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rad_heat_trans(self, *args, **kwargs):
                    """
                    Print radiation heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/rad_heat_trans").execute(*args, **kwargs)
                def mass_flow(self, *args, **kwargs):
                    """
                    Print mass flow rate at inlets and outlets.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/mass_flow").execute(*args, **kwargs)
                def heat_transfer_sensible(self, *args, **kwargs):
                    """
                    Print sensible heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/heat_transfer_sensible").execute(*args, **kwargs)
                def pressure_work(self, *args, **kwargs):
                    """
                    Print pressure work rate at moving boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/pressure_work").execute(*args, **kwargs)
                def heat_transfer(self, *args, **kwargs):
                    """
                    Print heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/heat_transfer").execute(*args, **kwargs)
                def film_heat_transfer(self, *args, **kwargs):
                    """
                    Print film heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/film_heat_transfer").execute(*args, **kwargs)
                def film_mass_flow(self, *args, **kwargs):
                    """
                    Print film mass flow rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/film_mass_flow").execute(*args, **kwargs)
                def viscous_work(self, *args, **kwargs):
                    """
                    Print viscous work rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/viscous_work").execute(*args, **kwargs)

            class system(TUIMenu):
                """
                Sytem menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def time_stats(self, *args, **kwargs):
                    """
                    Time usage information.
                    """
                    return PyMenu(self.service, "/results/report/system/time_stats").execute(*args, **kwargs)
                def proc_stats(self, *args, **kwargs):
                    """
                    Fluent process information.
                    """
                    return PyMenu(self.service, "/results/report/system/proc_stats").execute(*args, **kwargs)
                def gpgpu_stats(self, *args, **kwargs):
                    """
                    GPGPU information.
                    """
                    return PyMenu(self.service, "/results/report/system/gpgpu_stats").execute(*args, **kwargs)
                def sys_stats(self, *args, **kwargs):
                    """
                    System information.
                    """
                    return PyMenu(self.service, "/results/report/system/sys_stats").execute(*args, **kwargs)

            class modified_setting(TUIMenu):
                """
                Enter the menu for setting up the Modified Settings Summary table.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def modified_setting(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/report/modified_setting/modified_setting").execute(*args, **kwargs)
                def write_user_setting(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/report/modified_setting/write_user_setting").execute(*args, **kwargs)

            class dpm_histogram(TUIMenu):
                """
                Enter the DPM histogram menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.setup_reduction = self.__class__.setup_reduction(path + ["setup_reduction"], service)
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def prep_dpm_sample_cont_plot_exprs(self, *args, **kwargs):
                    """
                    Prepare named expressions from data in a DPM sample file (collected at a cut plane surface) for contour plotting.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/prep_dpm_sample_cont_plot_exprs").execute(*args, **kwargs)
                def delete_sample(self, *args, **kwargs):
                    """
                    Delete a sample from loaded sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/delete_sample").execute(*args, **kwargs)
                def plot_sample(self, *args, **kwargs):
                    """
                    Plot a histogram of a loaded sample.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/plot_sample").execute(*args, **kwargs)
                def read_sample(self, *args, **kwargs):
                    """
                    Read a sample file and add it to the sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/read_sample").execute(*args, **kwargs)
                def compute_sample(self, *args, **kwargs):
                    """
                    Compute minimum/maximum of a sample variable.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/compute_sample").execute(*args, **kwargs)
                def write_sample(self, *args, **kwargs):
                    """
                    Write a histogram of a loaded sample into a file.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/write_sample").execute(*args, **kwargs)
                def pick_sample_to_reduce(self, *args, **kwargs):
                    """
                    Pick a sample for which to first set-up and then perform the data reduction.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/pick_sample_to_reduce").execute(*args, **kwargs)
                def reduce_picked_sample(self, *args, **kwargs):
                    """
                    Reduce a sample after first picking it and setting up all data-reduction options and parameters.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/reduce_picked_sample").execute(*args, **kwargs)
                def list_samples(self, *args, **kwargs):
                    """
                    Show all samples in loaded sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/list_samples").execute(*args, **kwargs)

                class setup_reduction(TUIMenu):
                    """
                    Set up the sample data reduction by specifying all relevant options and setting parameters as desired.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def logarithmic(self, *args, **kwargs):
                        """
                        Switch on or off logarithmic scaling to be used for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/logarithmic").execute(*args, **kwargs)
                    def list_settings(self, *args, **kwargs):
                        """
                        List all user inputs for the sample picked for data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/list_settings").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Set the minimum value of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/minimum").execute(*args, **kwargs)
                    def make_steady_from_unsteady_file(self, *args, **kwargs):
                        """
                        Specify whether the unsteady sample is to be reduced into a steady-state injection file.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/make_steady_from_unsteady_file").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Set the maximum value of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/maximum").execute(*args, **kwargs)
                    def number_of_bins(self, *args, **kwargs):
                        """
                        Set the number of bins to be used for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/number_of_bins").execute(*args, **kwargs)
                    def reset_min_and_max(self, *args, **kwargs):
                        """
                        Reset the min and max values of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/reset_min_and_max").execute(*args, **kwargs)
                    def weighting_variable(self, *args, **kwargs):
                        """
                        Choose the weighting variable for the averaging in each bin in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/weighting_variable").execute(*args, **kwargs)
                    def all_variables_number_of_bins(self, *args, **kwargs):
                        """
                        Set the number of bins to be used for ALL variables in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/all_variables_number_of_bins").execute(*args, **kwargs)
                    def use_weighting(self, *args, **kwargs):
                        """
                        Specify whether to use any weighting in the averaging that is done in each bin in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/use_weighting").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the settings menu for the histogram.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def maximum(self, *args, **kwargs):
                        """
                        Specify maximum value of x-axis variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/maximum").execute(*args, **kwargs)
                    def logarithmic(self, *args, **kwargs):
                        """
                        Use logarithmic scaling on the abscissa (variable axis)? -- Will not work unless all values are positive.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/logarithmic").execute(*args, **kwargs)
                    def weighting(self, *args, **kwargs):
                        """
                        Use weighting with additional variable when sorting data into samples.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/weighting").execute(*args, **kwargs)
                    def diameter_statistics(self, *args, **kwargs):
                        """
                        Compute Rosin Rammler parameters, Sauter and other mean diameters.
                        Requires specification of diameter as sampling variable.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/diameter_statistics").execute(*args, **kwargs)
                    def cumulation_curve(self, *args, **kwargs):
                        """
                        Compute a cumulative curve for sampling variable or correlation variable when correlation? was specified.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/cumulation_curve").execute(*args, **kwargs)
                    def histogram_mode(self, *args, **kwargs):
                        """
                        Use bars for histogram plot or xy-style.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/histogram_mode").execute(*args, **kwargs)
                    def correlation(self, *args, **kwargs):
                        """
                        Compute correlation of sampling variable with other variable.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/correlation").execute(*args, **kwargs)
                    def variable_power_3(self, *args, **kwargs):
                        """
                        Use the cubic of the cumulation variable during computation of the cumulative curve.
                        When the particle mass was not sampled, the diameter can be used instead.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/variable_power_3").execute(*args, **kwargs)
                    def percentage(self, *args, **kwargs):
                        """
                        Use percentages of bins to be computed.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/percentage").execute(*args, **kwargs)
                    def auto_range(self, *args, **kwargs):
                        """
                        Automatically compute range of sampling variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/auto_range").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Specify mimimum value of x-axis variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/minimum").execute(*args, **kwargs)
                    def number_of_bins(self, *args, **kwargs):
                        """
                        Specify the number of bins.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/number_of_bins").execute(*args, **kwargs)

            class population_balance(TUIMenu):
                """
                Population Balance menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def number_density(self, *args, **kwargs):
                    """
                    Set number density functions.
                    """
                    return PyMenu(self.service, "/results/report/population_balance/number_density").execute(*args, **kwargs)
                def moments(self, *args, **kwargs):
                    """
                    Set moments for population balance.
                    """
                    return PyMenu(self.service, "/results/report/population_balance/moments").execute(*args, **kwargs)

            class icing(TUIMenu):
                """
                Icing reports menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def particles_crystals_collection_eff(self, *args, **kwargs):
                    """
                    Print Crystals Collection Efficiency.
                    """
                    return PyMenu(self.service, "/results/report/icing/particles_crystals_collection_eff").execute(*args, **kwargs)
                def energy_of_ice_formation(self, *args, **kwargs):
                    """
                    Print Energy of Ice Formation.
                    """
                    return PyMenu(self.service, "/results/report/icing/energy_of_ice_formation").execute(*args, **kwargs)
                def mass_of_ice(self, *args, **kwargs):
                    """
                    Print Mass of Ice Accretion.
                    """
                    return PyMenu(self.service, "/results/report/icing/mass_of_ice").execute(*args, **kwargs)
                def particles_droplets_collection_eff(self, *args, **kwargs):
                    """
                    Print Droplets Collection Efficiency.
                    """
                    return PyMenu(self.service, "/results/report/icing/particles_droplets_collection_eff").execute(*args, **kwargs)
                def mass_of_water_impinged(self, *args, **kwargs):
                    """
                    Print Mass of Water Impingement.
                    """
                    return PyMenu(self.service, "/results/report/icing/mass_of_water_impinged").execute(*args, **kwargs)
                def energy_of_water_impinged(self, *args, **kwargs):
                    """
                    Print Energy of Water Impingement.
                    """
                    return PyMenu(self.service, "/results/report/icing/energy_of_water_impinged").execute(*args, **kwargs)
                def icing_energy_of_conduction(self, *args, **kwargs):
                    """
                    Print Energy of Conduction.
                    """
                    return PyMenu(self.service, "/results/report/icing/icing_energy_of_conduction").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enter the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def computed_heat_rejection(self, *args, **kwargs):
                    """
                    Print total heat rejection.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/computed_heat_rejection").execute(*args, **kwargs)
                def outlet_temperature(self, *args, **kwargs):
                    """
                    Print outlet temperature.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/outlet_temperature").execute(*args, **kwargs)
                def inlet_temperature(self, *args, **kwargs):
                    """
                    Print inlet temperature.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/inlet_temperature").execute(*args, **kwargs)
                def mass_flow_rate(self, *args, **kwargs):
                    """
                    Print mass flow rate.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/mass_flow_rate").execute(*args, **kwargs)
                def specific_heat(self, *args, **kwargs):
                    """
                    Print fluid's specific heat.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/specific_heat").execute(*args, **kwargs)

        class plot(TUIMenu):
            """
            Enter the XY plot menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
                self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
                self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
                super().__init__(path, service)
            def histogram_set(self, *args, **kwargs):
                """
                Enter the menu to set histogram plot parameters.
                """
                return PyMenu(self.service, "/results/plot/histogram_set").execute(*args, **kwargs)
            def set_boundary_val_off(self, *args, **kwargs):
                """
                Set boundary value off when node values off for XY/Solution Plot.
                Note: This setting is valid for current Fluent session only.
                """
                return PyMenu(self.service, "/results/plot/set_boundary_val_off").execute(*args, **kwargs)
            def solution(self, *args, **kwargs):
                """
                Plot solution on surfaces and/or zones.
                """
                return PyMenu(self.service, "/results/plot/solution").execute(*args, **kwargs)
            def plot_direction(self, *args, **kwargs):
                """
                Set plot direction for xy plot.
                """
                return PyMenu(self.service, "/results/plot/plot_direction").execute(*args, **kwargs)
            def file(self, *args, **kwargs):
                """
                Plot data from file.
                """
                return PyMenu(self.service, "/results/plot/file").execute(*args, **kwargs)
            def fft_set(self, *args, **kwargs):
                """
                Enter the menu to set histogram plot parameters.
                """
                return PyMenu(self.service, "/results/plot/fft_set").execute(*args, **kwargs)
            def datasources(self, *args, **kwargs):
                """
                Enter the menu to set data sources.
                """
                return PyMenu(self.service, "/results/plot/datasources").execute(*args, **kwargs)
            def circum_avg_radial(self, *args, **kwargs):
                """
                Compute iso-radial band surfaces and plot data vs radius on them.
                """
                return PyMenu(self.service, "/results/plot/circum_avg_radial").execute(*args, **kwargs)
            def residuals(self, *args, **kwargs):
                """
                Plot equation residual history.
                """
                return PyMenu(self.service, "/results/plot/residuals").execute(*args, **kwargs)
            def label_alignment(self, *args, **kwargs):
                """
                Set the alignment of xy plot label to horizontal or axis aligned.
                """
                return PyMenu(self.service, "/results/plot/label_alignment").execute(*args, **kwargs)
            def histogram(self, *args, **kwargs):
                """
                Plot a histogram of a specified scalar quantity.
                """
                return PyMenu(self.service, "/results/plot/histogram").execute(*args, **kwargs)
            def file_list(self, *args, **kwargs):
                """
                Plot data from multiple files.
                """
                return PyMenu(self.service, "/results/plot/file_list").execute(*args, **kwargs)
            def display_profile_data(self, *args, **kwargs):
                """
                Plot profile data.
                """
                return PyMenu(self.service, "/results/plot/display_profile_data").execute(*args, **kwargs)
            def circum_avg_axial(self, *args, **kwargs):
                """
                Compute iso-axial band surfaces and plot data vs axial coordinate on them.
                """
                return PyMenu(self.service, "/results/plot/circum_avg_axial").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot solution on surfaces.
                """
                return PyMenu(self.service, "/results/plot/plot").execute(*args, **kwargs)
            def solution_set(self, *args, **kwargs):
                """
                Enter the menu to set solution plot parameters.
                """
                return PyMenu(self.service, "/results/plot/solution_set").execute(*args, **kwargs)
            def change_fft_ref_pressure(self, *args, **kwargs):
                """
                Change acoustic reference pressure.
                """
                return PyMenu(self.service, "/results/plot/change_fft_ref_pressure").execute(*args, **kwargs)
            def file_set(self, *args, **kwargs):
                """
                Enter the menu to set file plot parameters.
                """
                return PyMenu(self.service, "/results/plot/file_set").execute(*args, **kwargs)
            def residuals_set(self, *args, **kwargs):
                """
                Enter the menu to set residual plot parameters.
                """
                return PyMenu(self.service, "/results/plot/residuals_set").execute(*args, **kwargs)
            def fft(self, *args, **kwargs):
                """
                Plot FFT of file data.
                """
                return PyMenu(self.service, "/results/plot/fft").execute(*args, **kwargs)

            class cumulative_plot(TUIMenu):
                """
                Plot Cumulative Force and Moments.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/delete").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Print the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/print").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/edit").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Write the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/write").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/list").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/plot").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/axes").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/curves").execute(*args, **kwargs)

            class ansys_sound_analysis(TUIMenu):
                """
                Ansys Sound analysis and specification.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def print_indicators(self, *args, **kwargs):
                    """
                    Print Ansys Sound indicators.
                    """
                    return PyMenu(self.service, "/results/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)
                def write_files(self, *args, **kwargs):
                    """
                    Write Ansys Sound out files.
                    """
                    return PyMenu(self.service, "/results/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)

            class flamelet_curves(TUIMenu):
                """
                Plot flamelet curves.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_to_file(self, *args, **kwargs):
                    """
                    Write curve to a file instead of plot.
                    """
                    return PyMenu(self.service, "/results/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)
                def plot_curves(self, *args, **kwargs):
                    """
                    Plot of a property.
                    """
                    return PyMenu(self.service, "/results/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)

    class define(TUIMenu):
        """
        Enter the define menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.phases = self.__class__.phases(path + ["phases"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.virtual_boundary = self.__class__.virtual_boundary(path + ["virtual_boundary"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
            self.profiles = self.__class__.profiles(path + ["profiles"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.spectral = self.__class__.spectral(path + ["spectral"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.curvilinear_coordinate_system = self.__class__.curvilinear_coordinate_system(path + ["curvilinear_coordinate_system"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.custom_field_functions = self.__class__.custom_field_functions(path + ["custom_field_functions"], service)
            super().__init__(path, service)
        def set_unit_system(self, *args, **kwargs):
            """
            Applies a standard set of units to all quantities. The options include default,si, british, andcgs.
            """
            return PyMenu(self.service, "/define/set_unit_system").execute(*args, **kwargs)
        def physics(self, *args, **kwargs):
            """
            Manage Physics-regions.
            """
            return PyMenu(self.service, "/define/physics").execute(*args, **kwargs)
        def injections(self, *args, **kwargs):
            """
            Enters the injections menu.  For a description of the items in this menu, see define/models/dpm/injections.
            """
            return PyMenu(self.service, "/define/injections").execute(*args, **kwargs)
        def enable_mesh_morpher_optimizer(self, *args, **kwargs):
            """
            Enables the mesh morpher/optimizer. When the mesh morpher/optimizer is enabled, the define/mesh-morpher-optimizer text command becomes available.
            """
            return PyMenu(self.service, "/define/enable_mesh_morpher_optimizer").execute(*args, **kwargs)
        def beta_feature_access(self, *args, **kwargs):
            """
            Enable access to beta features in the interface.
            """
            return PyMenu(self.service, "/define/beta_feature_access").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Sets unit conversion factors.
            """
            return PyMenu(self.service, "/define/units").execute(*args, **kwargs)

        class phases(TUIMenu):
            """
            Enters the phases menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                super().__init__(path, service)

            class iac_expert(TUIMenu):
                """
                Enters the IAC expert setting menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def ishii_kim_model(self, *args, **kwargs):
                    """
                    Sets Ishii-Kim model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/ishii_kim_model").execute(*args, **kwargs)
                def iac_pseudo_time_step(self, *args, **kwargs):
                    """
                    Set iac pseudo-time.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/iac_pseudo_time_step").execute(*args, **kwargs)
                def hibiki_ishii_model(self, *args, **kwargs):
                    """
                    Sets Hibiki-Ishii model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/hibiki_ishii_model").execute(*args, **kwargs)
                def yao_morel_model(self, *args, **kwargs):
                    """
                    Sets Yao-Morel model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/yao_morel_model").execute(*args, **kwargs)

            class set_domain_properties(TUIMenu):
                """
                Enters the menu to set phase domain properties.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                    super().__init__(path, service)
                def change_phases_names(self, *args, **kwargs):
                    """
                    Allows you to change the names of all the phases in your simulation.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)
                def phase_domains(self, *args, **kwargs):
                    """
                    Enters the menu to select a specific phase.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)

                class interaction_domain(TUIMenu):
                    """
                    Enters the menu to set the interaction domain 	properties.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                        self.forces = self.__class__.forces(path + ["forces"], service)
                        self.numerics = self.__class__.numerics(path + ["numerics"], service)
                        self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                        self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                        super().__init__(path, service)

                    class heat_mass_reactions(TUIMenu):
                        """
                        Enters the menu to set heat, mass-transfer, and reaction models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            super().__init__(path, service)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Allows you to define multiple heterogeneous reactions and stoichiometry. This option is available only with the species model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Species the heat transfer coefficient function between each pair of phases (constant-htc, nusselt-number, ranz-marshall, hughmark, tomiyama, fixed-to-sat-temp, two-resistance, or user-defined). This command is enable only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enters the menu to set cavitation models. This option is available only for the Mixture multiphase model with the Singhal-et-al cavitation model enabled via solve/set/advanced/singhal-et-al-cavitation-model.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Sets the vaporization pressure, surface tension coefficient, and non-condensable gas mass fraction. This command is available only when cavitation? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)

                    class forces(TUIMenu):
                        """
                        Enters the menu to set interfacial forces models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            super().__init__(path, service)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specifies the drag function, drag modification, and drag factor for each pair of phases. This command is available only with the Eulerian and Mixture multiphase models.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specifies the slip velocity function for each secondary phase with respect to the primary phase. This command is available only for the Mixture multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specifies the turbulence interaction model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specifies the wall lubrication model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specifies the restitution coefficient for collisions between each pair of granular phases, and for collisions between particles of the same granular phase. This command is available only for multiphase flows with two or more granular phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specifies the turbulent dispersion model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_model_type").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enters the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enables/disables the treatment of the contact angle specification at the porous jump boundary. This command is available only for the VOF multiphase model with the continuum surface stress model option and when sfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Selects the surface tension model. You can choose between the continuum surface force and continuum surface stress methods. This item is available only when sfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enables/disables the specification for a wall adhesion angle. This item is available only whensfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specifies the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Allows you to include the effects of surface tension along the fluid-fluid interface. This option is only available for the VOF and Eulerian multiphase models.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enters the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Specifies what form of the implicit method to use (default, option-2, or option-3). default models the entire virtual mass force while option-2 and option-3 model truncated expressions which may further improve convergence. This option is available only if vmass-implicit? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enables/disables the implicit method for the virtual mass force. This option can improve convergence in some cases. This option is available only if virtual-mass? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specifies the virtual mass coefficient for each pair of phases. This option is available only ifvirtual-mass? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Allows you to include the virtual mass force effect that occurs when a secondary phase accelerates relative to the primary phase. This command is available only with the Eulerian multiphase model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/visc_disp_factor").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enters the menu to set the lift force. This item is available only with the Eulerian multiphase model.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Enables/disables the Shaver-Podowski lift correction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                Specifies the lift function for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)

                    class numerics(TUIMenu):
                        """
                        Enters the menu to set numerics models. This menu is available for multiphase models with the sharp-dispersed and phase localized discretization interface modeling options (set in define/models/multiphase/interface-modeling-options).
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            super().__init__(path, service)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enters the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specifies the slope limiter to set a specific discretization scheme for each phase pair. A value of 0 corresponds to first order upwind, a value of 1 corresponds to second order upwind, a value of 2 applies the compressive scheme, and a value between 0 and 2 corresponds to a blended scheme. This option is available only wheninterphase-discr? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enables/disables phase localized compressive scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)

                    class interfacial_area(TUIMenu):
                        """
                        Enters the menu to set interfacial area models. This menu is available only for the Mixture and Eulerian multiphase models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            super().__init__(path, service)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Specifies the interfacial area model for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)

                    class model_transition(TUIMenu):
                        """
                        Enters the menu to set model transition mechanisms.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            super().__init__(path, service)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Sets the VOF-to-DPM model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)

        class materials(TUIMenu):
            """
            Enters the materials menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_base = self.__class__.data_base(path + ["data_base"], service)
                super().__init__(path, service)
            def change_create(self, *args, **kwargs):
                """
                Changes the properties of a locally-stored material or create a new material.   Generally, the properties you enter at the prompts will be filtered according to your case and model settings. However, some of the listed properties may not match the selection choice in the Graphics User Interface. Typically, those excessive properties in the Text User Interface will not be used in your simulation.
                """
                return PyMenu(self.service, "/define/materials/change_create").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a material from local storage.
                """
                return PyMenu(self.service, "/define/materials/delete").execute(*args, **kwargs)
            def copy_by_formula(self, *args, **kwargs):
                """
                Copies a material from the database by formula.
                """
                return PyMenu(self.service, "/define/materials/copy_by_formula").execute(*args, **kwargs)
            def list_materials(self, *args, **kwargs):
                """
                Lists all locally-stored materials.
                """
                return PyMenu(self.service, "/define/materials/list_materials").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a locally-stored material.
                """
                return PyMenu(self.service, "/define/materials/list_properties").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copies a material from the database.
                """
                return PyMenu(self.service, "/define/materials/copy").execute(*args, **kwargs)

            class data_base(TUIMenu):
                """
                Enters the material database menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edits material.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/edit").execute(*args, **kwargs)
                def database_type(self, *args, **kwargs):
                    """
                    Sets the database type 	(fluent-database, 	granta-mds, or 	user-defined).
                    """
                    return PyMenu(self.service, "/define/materials/data_base/database_type").execute(*args, **kwargs)
                def list_materials(self, *args, **kwargs):
                    """
                    Lists all materials in the database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/list_materials").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a material in the database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/list_properties").execute(*args, **kwargs)
                def save(self, *args, **kwargs):
                    """
                    Saves user-defined database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/save").execute(*args, **kwargs)
                def new(self, *args, **kwargs):
                    """
                    Defines new material.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/new").execute(*args, **kwargs)

        class overset_interfaces(TUIMenu):
            """
            Enters the overset interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                self.adapt = self.__class__.adapt(path + ["adapt"], service)
                self.cut_control = self.__class__.cut_control(path + ["cut_control"], service)
                super().__init__(path, service)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all overset interfaces in the domain.
                """
                return PyMenu(self.service, "/define/overset_interfaces/delete_all").execute(*args, **kwargs)
            def clear(self, *args, **kwargs):
                """
                Clears the domain connectivity of an overset interface. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/clear").execute(*args, **kwargs)
            def write_dci_to_case(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to case file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_dci_to_case").execute(*args, **kwargs)
            def debug_hole_cut(self, *args, **kwargs):
                """
                Debugging tool to troubleshoot hole cutting of overset interfaces. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/debug_hole_cut").execute(*args, **kwargs)
            def intersect_all(self, *args, **kwargs):
                """
                Executes hole cutting for all overset interfaces in the domain. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/intersect_all").execute(*args, **kwargs)
            def find_bounding_cell(self, *args, **kwargs):
                """
                Find bounding cell for given cell or search point.
                """
                return PyMenu(self.service, "/define/overset_interfaces/find_bounding_cell").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Creates an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/create").execute(*args, **kwargs)
            def intersect(self, *args, **kwargs):
                """
                Executes the hole cutting of an overset interface and establishes the domain connectivity. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/intersect").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists information about the overset interfaces. The output depends on the overset verbosity setting.
                """
                return PyMenu(self.service, "/define/overset_interfaces/list").execute(*args, **kwargs)
            def clear_all(self, *args, **kwargs):
                """
                Clears the domain connectivity of all overset interfaces. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/clear_all").execute(*args, **kwargs)
            def fill_dci(self, *args, **kwargs):
                """
                Fill overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/fill_dci").execute(*args, **kwargs)
            def find_all_bounding_cells(self, *args, **kwargs):
                """
                Find bounding cells for all cell centroids.
                """
                return PyMenu(self.service, "/define/overset_interfaces/find_all_bounding_cells").execute(*args, **kwargs)
            def check(self, *args, **kwargs):
                """
                Checks the integrity of the overset interfaces. Reports orphan cells and errors in the domain connectivity.
                """
                return PyMenu(self.service, "/define/overset_interfaces/check").execute(*args, **kwargs)
            def display_cells(self, *args, **kwargs):
                """
                Displays the overset cells marked using the text command define/overset-interfaces/mark-cells.
                """
                return PyMenu(self.service, "/define/overset_interfaces/display_cells").execute(*args, **kwargs)
            def free_dci(self, *args, **kwargs):
                """
                Free overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/free_dci").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/delete").execute(*args, **kwargs)
            def write_dci(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to a text file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_dci").execute(*args, **kwargs)
            def update_from_dci(self, *args, **kwargs):
                """
                Update all overset intrfaces from stored domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/update_from_dci").execute(*args, **kwargs)
            def set_mark_bounds(self, *args, **kwargs):
                """
                Allows you to set bounds so that any marking of cells is performed within a spherical region based on a specified origin and radius. This can be useful when diagnosing a local problem on a large mesh. This text command is only available if define/overset-interfaces/options/expert? is set to yes. After defining the bounds, you can then mark the cells using the define/overset-interfaces/mark-cell-change or define/overset-interfaces/mark-cells text command. To disable the bounds, enter a radius of 0.
                """
                return PyMenu(self.service, "/define/overset_interfaces/set_mark_bounds").execute(*args, **kwargs)
            def grid_priorities(self, *args, **kwargs):
                """
                Allows you to specify grid priorities on background and component meshes, used in the overlap minimization of an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/grid_priorities").execute(*args, **kwargs)
            def mark_cell_change(self, *args, **kwargs):
                """
                Marks cells that have undergone a specified overset cell type change (from solve,receptor, or dead to any other type) in the last time step. Adaption registers are automatically filled based on these markings. This text command is only available for unsteady simulations and if define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/mark_cell_change").execute(*args, **kwargs)
            def mark_cells(self, *args, **kwargs):
                """
                Marks the specified overset cells (solve, receptor, donor, orphan, or dead) and fills registers based on the markings. Display the marked cells via the text command define/overset-interfaces/display-cells.
                """
                return PyMenu(self.service, "/define/overset_interfaces/mark_cells").execute(*args, **kwargs)
            def write_cell_types(self, *args, **kwargs):
                """
                Write overset cell types into file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_cell_types").execute(*args, **kwargs)
            def read_dci_from_case(self, *args, **kwargs):
                """
                Read domain connectivity information (DCI) from case file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/read_dci_from_case").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the overset interface options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def update_before_case_write(self, *args, **kwargs):
                    """
                    Enables/disables the updating of the overset interfaces before writing a case file in the 	Common Fluids Format (CFF). This text command is only 	available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/update_before_case_write").execute(*args, **kwargs)
                def partial_cut_faces(self, *args, **kwargs):
                    """
                    Enables/disables enhanced hole cutting, where partially overlapping cut faces are 	decomposed into overlapping and non-overlapping 	fractions, and only the non-overlapping fractions 	participate in the hole cutting. This can help avoid the 	situation where a region or cell zone is erroneously 	identified as dead because of leakage during flood 	filling, even though it has overlapping boundaries that 	match well. When this text command is disabled, the 	partially overlapping faces are entirely protected from 	cutting.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/partial_cut_faces").execute(*args, **kwargs)
                def parallel(self, *args, **kwargs):
                    """
                    Allows you to select the algorithm used for overset parallel processing. You can 	select from the default cell exchange model or the local 	cell zone replication model; the cell exchange model 	should require less memory and may result in faster 	calculations.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/parallel").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specifies the level of detail printed in the console about overset 	interfaces.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/verbosity").execute(*args, **kwargs)
                def render_receptor_cells(self, *args, **kwargs):
                    """
                    Allows you to enable visualization of receptor cells in contour and mesh 	displays.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/render_receptor_cells").execute(*args, **kwargs)
                def solve_island_removal(self, *args, **kwargs):
                    """
                    Sets the method used to control the removal of isolated patches of solve cells. This text 	command is only available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/solve_island_removal").execute(*args, **kwargs)
                def donor_priority_method(self, *args, **kwargs):
                    """
                    Allows you to specify whether the cell donor priority used in the overlap 	minimization of an overset interface is inversely proportional to either the 	cell size or the distance to the nearest boundary.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/donor_priority_method").execute(*args, **kwargs)
                def mesh_interfaces(self, *args, **kwargs):
                    """
                    Allows the inclusion of non-conformal mesh interfaces 	inside overset cell zones, as long as the mesh 	interfaces do not spatially overlap with the cells where 	the overset interfaces lie.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/mesh_interfaces").execute(*args, **kwargs)
                def dead_cell_update(self, *args, **kwargs):
                    """
                    Enables/disables the updating of dead cells during the solution process, which may 	be helpful for some moving and dynamic mesh simulations 	(though at the cost of solver performance). You can 	enter the number of layers of dead cells adjacent to the 	receptor cells that you want updated, or enter -1 to request that all dead 	cells are updated. This text command is only available 	for transient simulations when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/dead_cell_update").execute(*args, **kwargs)
                def transient_caching(self, *args, **kwargs):
                    """
                    Sets the options to control caching of entities in transient overset simulations. This text 	command is only available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/transient_caching").execute(*args, **kwargs)
                def overlap_boundaries(self, *args, **kwargs):
                    """
                    Allows you to disable the detection of overlapping boundaries during hole cutting, 	in order to reduce the computational expense for cases 	that do not include such boundaries. When enabled, this 	text command also allows you to specify which boundary 	zones should be considered when detecting overlapping 	boundaries; this can be helpful when the default hole 	cutting process fails.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/overlap_boundaries").execute(*args, **kwargs)
                def modified_donor_search(self, *args, **kwargs):
                    """
                    Enables / disables modified donor search parameters. When enabled, these parameters result in 	a more extended donor search, which can be helpful for 	meshes with orphans. This text command is only available 	when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/modified_donor_search").execute(*args, **kwargs)
                def node_connected_donors(self, *args, **kwargs):
                    """
                    Allows you to switch between face or node connected donor cells. This text command is only 	available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/node_connected_donors").execute(*args, **kwargs)
                def auto_create(self, *args, **kwargs):
                    """
                    Enables the automatic creation of a default overset interface during 	initialization or mesh motion update.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/auto_create").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enables / disables overset-related expert tools.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/expert").execute(*args, **kwargs)
                def minimize_overlap(self, *args, **kwargs):
                    """
                    Allows you to disable overlap minimization during hole cutting.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/minimize_overlap").execute(*args, **kwargs)
                def modified_hole_cutting(self, *args, **kwargs):
                    """
                    Enables / disables modified hole cutting parameters. When enabled, the parameters used can 	help avoid dead cell zones that result from a hole 	cutting failure. This text command is only available 	when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/modified_hole_cutting").execute(*args, **kwargs)

            class adapt(TUIMenu):
                """
                Enters the overset adaption menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def adapt_mesh(self, *args, **kwargs):
                    """
                    Marks and adapts the mesh to improve your overset 	mesh.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/adapt/adapt_mesh").execute(*args, **kwargs)
                def mark_adaption(self, *args, **kwargs):
                    """
                    Marks cells to identify those that can be adapted in 	order to improve your overset mesh.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/adapt/mark_adaption").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enters the overset adaption set menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def buffer_layers(self, *args, **kwargs):
                        """
                        Sets the number of cell layers marked in addition to the cells marked for orphan adaption.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/buffer_layers").execute(*args, **kwargs)
                    def gap_resolution(self, *args, **kwargs):
                        """
                        Set the target (minimum) gap resolution used when marking cells for gap adaption.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/gap_resolution").execute(*args, **kwargs)
                    def anisotropic(self, *args, **kwargs):
                        """
                        Enable the option to use anisotropic adaption in prismatic cells.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/anisotropic").execute(*args, **kwargs)
                    def mark_coarsening(self, *args, **kwargs):
                        """
                        Enables/disables the option to coarsen the mesh if mesh refinement is no longer needed. This option is enabled by default.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_coarsening").execute(*args, **kwargs)
                    def mark_fixed_orphans(self, *args, **kwargs):
                        """
                        Enables/disables the option to also adapt based on cells that are not actual orphans because they were fixed by accepting neighbor donors. This option is only applied if define/overset-interfaces/adapt/set/mark-orphans? is enabled.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_fixed_orphans").execute(*args, **kwargs)
                    def length_ratio_max(self, *args, **kwargs):
                        """
                        Sets the length scale ratio threshold used to determine which cells are marked for adaption based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/length_ratio_max").execute(*args, **kwargs)
                    def mark_gaps(self, *args, **kwargs):
                        """
                        Enable the option to adapt underresolved gaps.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_gaps").execute(*args, **kwargs)
                    def mark_size(self, *args, **kwargs):
                        """
                        Enables/disables the option to adapt based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_size").execute(*args, **kwargs)
                    def adaption_sweeps(self, *args, **kwargs):
                        """
                        Sets the number of rounds of adaption applied during each adaption cycle.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/adaption_sweeps").execute(*args, **kwargs)
                    def maximum_refinement_level(self, *args, **kwargs):
                        """
                        Sets the maximum level of refinement during overset adaption, in conjunction with the value set using the mesh/adapt/set/maximum-refinement-level text command (the larger of the two values is used).
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                    def mark_orphans(self, *args, **kwargs):
                        """
                        Enables/disables the option to adapt for orphan reduction.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_orphans").execute(*args, **kwargs)
                    def automatic(self, *args, **kwargs):
                        """
                        Enable the option to automatically adapt overset meshes during solution update.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/automatic").execute(*args, **kwargs)

            class cut_control(TUIMenu):
                """
                Enters the overset hole cut control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.cut_seeds = self.__class__.cut_seeds(path + ["cut_seeds"], service)
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes the hole cut control for a boundary 	zone.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/delete").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Deletes the hole cut controls for all boundary 	zones.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Adds a hole cut control, so that a boundary zone does 	not cut specified cell zones.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists the defined hole cut controls.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/list").execute(*args, **kwargs)

                class cut_seeds(TUIMenu):
                    """
                    Enters the overset hole cut seeds menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list(self, *args, **kwargs):
                        """
                        List the defined hole cut seeds.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/list").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a hole cut seed.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/delete").execute(*args, **kwargs)
                    def delete_all(self, *args, **kwargs):
                        """
                        Delete all hole cut seeds.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/delete_all").execute(*args, **kwargs)
                    def cut_seeds_for_all_component_zones(self, *args, **kwargs):
                        """
                        Specifies whether all component zones get cut seeds, which cut pilot holes into the overlapping meshes that will then be enlarged during overlap minimization.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/cut_seeds_for_all_component_zones").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a hole cut seed.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/add").execute(*args, **kwargs)

        class virtual_boundary(TUIMenu):
            """
            Manage Virtual Boundaries.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def hole_geometry(self, *args, **kwargs):
                """
                Create a Hole Geometry template.
                """
                return PyMenu(self.service, "/define/virtual_boundary/hole_geometry").execute(*args, **kwargs)
            def boundary_interface(self, *args, **kwargs):
                """
                Create a Boundary Interface.
                """
                return PyMenu(self.service, "/define/virtual_boundary/boundary_interface").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enters the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.optics = self.__class__.optics(path + ["optics"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                super().__init__(path, service)
            def steady(self, *args, **kwargs):
                """
                Enables/disables the steady solution model.
                """
                return PyMenu(self.service, "/define/models/steady").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                Enable/disable the energy model.
                """
                return PyMenu(self.service, "/define/models/energy").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Selects the second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enables the dual potential MSMD battery model. For text commands that become available when the battery model is enabled, refer to Battery Model Text Commands.
                """
                return PyMenu(self.service, "/define/models/battery_model").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enables/disables the ablation model.
                """
                return PyMenu(self.service, "/define/models/ablation").execute(*args, **kwargs)
            def virtual_blade_model(self, *args, **kwargs):
                """
                Enter VBM model menu.
                """
                return PyMenu(self.service, "/define/models/virtual_blade_model").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Specifies whether or not the domain is axisymmetric.
                """
                return PyMenu(self.service, "/define/models/axisymmetric").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enables/disables the solidification and melting model.
                """
                return PyMenu(self.service, "/define/models/solidification_melting").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enables/disables frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/define/models/frozen_flux").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Selects the Newmark method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Selects the bounded second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enables/disables the soot model.
                """
                return PyMenu(self.service, "/define/models/soot").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enters the crevice model controls menu.
                """
                return PyMenu(self.service, "/define/models/crevice_model_controls").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Selects the explicit transient formulation. This text command is only available for unsteady cases that use the density-based solver with the explicit formulation.
                """
                return PyMenu(self.service, "/define/models/unsteady_global_time").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enables/disables the electric-potential model.
                """
                return PyMenu(self.service, "/define/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/define/models/vbm").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Selects the backward Euler method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_euler").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enables/disables noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/define/models/noniterative_time_advance").execute(*args, **kwargs)
            def crevice_model(self, *args, **kwargs):
                """
                Enables/disables the crevice model.
                """
                return PyMenu(self.service, "/define/models/crevice_model").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enables/disables axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/define/models/swirl").execute(*args, **kwargs)
            def nox(self, *args, **kwargs):
                """
                Enables/disables the NOx model.
                """
                return PyMenu(self.service, "/define/models/nox").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Selects the first-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_1st_order").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Loads addon module.
                """
                return PyMenu(self.service, "/define/models/addon_module").execute(*args, **kwargs)

            class radiation(TUIMenu):
                """
                Enters the radiation models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solar_parameters = self.__class__.solar_parameters(path + ["solar_parameters"], service)
                    self.dtrm_parameters = self.__class__.dtrm_parameters(path + ["dtrm_parameters"], service)
                    self.s2s_parameters = self.__class__.s2s_parameters(path + ["s2s_parameters"], service)
                    super().__init__(path, service)
                def discrete_ordinates(self, *args, **kwargs):
                    """
                    Enables/disables discrete ordinates radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/discrete_ordinates").execute(*args, **kwargs)
                def discrete_transfer(self, *args, **kwargs):
                    """
                    Enables/disables discrete transfer radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/discrete_transfer").execute(*args, **kwargs)
                def blending_factor(self, *args, **kwargs):
                    """
                    Sets numeric option for Discrete Ordinate model. Make sure thatSecond Order Upwind is selected for the Discrete Ordinates spatial 	discretization for the blending-factor option to 	appear in the text command list.
                    """
                    return PyMenu(self.service, "/define/models/radiation/blending_factor").execute(*args, **kwargs)
                def rosseland(self, *args, **kwargs):
                    """
                    Enables/disables Rosseland radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/rosseland").execute(*args, **kwargs)
                def apply_full_solar_irradiation(self, *args, **kwargs):
                    """
                    Enables/disables the application of the complete solar load to the first wavelength 	band only, reverting to the pre-2019 R1 behavior of the 	Solar Load and Discrete Ordinates models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/apply_full_solar_irradiation").execute(*args, **kwargs)
                def method_partially_specular_wall(self, *args, **kwargs):
                    """
                    Sets the method for partially specular wall with discrete ordinate model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/method_partially_specular_wall").execute(*args, **kwargs)
                def solar(self, *args, **kwargs):
                    """
                    Enables/disables solar model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar").execute(*args, **kwargs)
                def do_acceleration(self, *args, **kwargs):
                    """
                    Enables/disables the acceleration of the discrete 	ordinates (DO) radiation model calculations. Note that 	this text command is only available when running on 	Linux in parallel.
                    """
                    return PyMenu(self.service, "/define/models/radiation/do_acceleration").execute(*args, **kwargs)
                def solar_irradiation(self, *args, **kwargs):
                    """
                    Enables/disables the solar irradiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar_irradiation").execute(*args, **kwargs)
                def do_coupling(self, *args, **kwargs):
                    """
                    Enables/disables DO/energy coupling.
                    """
                    return PyMenu(self.service, "/define/models/radiation/do_coupling").execute(*args, **kwargs)
                def target_cells_per_volume_cluster(self, *args, **kwargs):
                    """
                    Sets the amount of coarsening of the radiation mesh 	for the Monte Carlo radiation model. A number greater 	than one implies coarsening, whereas equal to one 	implies no coarsening.
                    """
                    return PyMenu(self.service, "/define/models/radiation/target_cells_per_volume_cluster").execute(*args, **kwargs)
                def beta_radiation_features(self, *args, **kwargs):
                    """
                    Enable Radiation Models with Non-Iterative Time Advancement (NITA) as Beta features in FL12.0.
                    """
                    return PyMenu(self.service, "/define/models/radiation/beta_radiation_features").execute(*args, **kwargs)
                def solar_calculator(self, *args, **kwargs):
                    """
                    Calculates sun direction and intensity.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar_calculator").execute(*args, **kwargs)
                def fast_second_order_discrete_ordinate(self, *args, **kwargs):
                    """
                    Enables/disables the fast-second-order option for Discrete Ordinate Model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/fast_second_order_discrete_ordinate").execute(*args, **kwargs)
                def radiation_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for radiation models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/radiation_model_parameters").execute(*args, **kwargs)
                def solution_method_for_do_coupling(self, *args, **kwargs):
                    """
                    Enables/disables the solution method for DO/energy coupling.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solution_method_for_do_coupling").execute(*args, **kwargs)
                def mc_model_parameters(self, *args, **kwargs):
                    """
                    Specifies Monte Carlo model parameters. This text command is available only when the 	Monte Carlo model is enabled.
                    """
                    return PyMenu(self.service, "/define/models/radiation/mc_model_parameters").execute(*args, **kwargs)
                def s2s(self, *args, **kwargs):
                    """
                    Enables/disables S2S radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/s2s").execute(*args, **kwargs)
                def montecarlo(self, *args, **kwargs):
                    """
                    Enables/disables the Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/montecarlo").execute(*args, **kwargs)
                def mc_under_relaxation(self, *args, **kwargs):
                    """
                    Sets the under-relaxation factor for Monte Carlo radiation sources used in the 	energy equation.
                    """
                    return PyMenu(self.service, "/define/models/radiation/mc_under_relaxation").execute(*args, **kwargs)
                def non_gray_model_parameters(self, *args, **kwargs):
                    """
                    Sets parameters for non-gray model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/non_gray_model_parameters").execute(*args, **kwargs)
                def p1(self, *args, **kwargs):
                    """
                    Enables/disables P1 radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/p1").execute(*args, **kwargs)
                def wsggm_cell_based(self, *args, **kwargs):
                    """
                    Enables/disables WSGGM cell based method. Note that when enabled, the wsggm-cell-based option will 	become available in theAbsorption Coefficient drop-down list in the Create/Edit Materials dialog 	box.
                    """
                    return PyMenu(self.service, "/define/models/radiation/wsggm_cell_based").execute(*args, **kwargs)
                def radiation_iteration_parameters(self, *args, **kwargs):
                    """
                    Sets iteration parameters for radiation models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/radiation_iteration_parameters").execute(*args, **kwargs)

                class solar_parameters(TUIMenu):
                    """
                    Enters the solar parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def quad_tree_parameters(self, *args, **kwargs):
                        """
                        Sets quad-tree refinement parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/quad_tree_parameters").execute(*args, **kwargs)
                    def iteration_parameters(self, *args, **kwargs):
                        """
                        Sets update parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/iteration_parameters").execute(*args, **kwargs)
                    def sol_on_demand(self, *args, **kwargs):
                        """
                        Sets solar load on demand.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_on_demand").execute(*args, **kwargs)
                    def autoread_solar_data(self, *args, **kwargs):
                        """
                        Sets autoread solar data parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/autoread_solar_data").execute(*args, **kwargs)
                    def sol_adjacent_fluidcells(self, *args, **kwargs):
                        """
                        Sets solar load on for adjacent fluid cells.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_adjacent_fluidcells").execute(*args, **kwargs)
                    def autosave_solar_data(self, *args, **kwargs):
                        """
                        Sets autosave solar data parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/autosave_solar_data").execute(*args, **kwargs)
                    def solar_thread_control(self, *args, **kwargs):
                        """
                        Sets the number of threads to run the solar flux calculation. This item appears only when running in parallel with nodes located on a separate machine from the one running the host process andSolar Ray Tracing is enabled.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/solar_thread_control").execute(*args, **kwargs)
                    def sol_camera_pos(self, *args, **kwargs):
                        """
                        Sets camera position based on sun direction vector.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_camera_pos").execute(*args, **kwargs)
                    def scattering_fraction(self, *args, **kwargs):
                        """
                        Sets scattering fraction parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/scattering_fraction").execute(*args, **kwargs)
                    def illumination_parameters(self, *args, **kwargs):
                        """
                        Sets illumination parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/illumination_parameters").execute(*args, **kwargs)
                    def sun_direction_vector(self, *args, **kwargs):
                        """
                        Sets sun direction vector.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sun_direction_vector").execute(*args, **kwargs)
                    def ground_reflectivity(self, *args, **kwargs):
                        """
                        Sets ground reflectivity parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/ground_reflectivity").execute(*args, **kwargs)
                    def use_direction_from_sol_calc(self, *args, **kwargs):
                        """
                        Sets direction computed from solar calculator.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/use_direction_from_sol_calc").execute(*args, **kwargs)

                class dtrm_parameters(TUIMenu):
                    """
                    Enters the dtrm parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def check_ray_file(self, *args, **kwargs):
                        """
                        Reads DTRM rays file.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/check_ray_file").execute(*args, **kwargs)
                    def controls(self, *args, **kwargs):
                        """
                        Sets dtrm solution controls.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/controls").execute(*args, **kwargs)
                    def ray_trace(self, *args, **kwargs):
                        """
                        Creates DTRM rays for radiation.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/ray_trace").execute(*args, **kwargs)
                    def make_globs(self, *args, **kwargs):
                        """
                        Makes globs (coarser mesh) for radiation.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/make_globs").execute(*args, **kwargs)

                class s2s_parameters(TUIMenu):
                    """
                    Enters the S2S parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def print_zonewise_radiation(self, *args, **kwargs):
                        """
                        Prints the zonewise incoming radiation, viewfactors, and average temperature.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/print_zonewise_radiation").execute(*args, **kwargs)
                    def set_global_faces_per_surface_cluster(self, *args, **kwargs):
                        """
                        Sets global value of faces per surface cluster for all boundary zones.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/set_global_faces_per_surface_cluster").execute(*args, **kwargs)
                    def use_old_cluster_algorithm(self, *args, **kwargs):
                        """
                        Uses the old surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/use_old_cluster_algorithm").execute(*args, **kwargs)
                    def set_vf_parameters(self, *args, **kwargs):
                        """
                        Sets the parameters needed for the viewfactor calculations.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/set_vf_parameters").execute(*args, **kwargs)
                    def split_angle(self, *args, **kwargs):
                        """
                        Sets split angle for the clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/split_angle").execute(*args, **kwargs)
                    def compute_fpsc_values(self, *args, **kwargs):
                        """
                        Computes only fpsc values based on current settings.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_fpsc_values").execute(*args, **kwargs)
                    def use_new_cluster_algorithm(self, *args, **kwargs):
                        """
                        Uses the new surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/use_new_cluster_algorithm").execute(*args, **kwargs)
                    def compute_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write view factors from existing surface clusters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_vf_accelerated").execute(*args, **kwargs)
                    def compute_write_vf(self, *args, **kwargs):
                        """
                        Computes/writes surface clusters and view factors for S2S radiation model.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_write_vf").execute(*args, **kwargs)
                    def read_vf_file(self, *args, **kwargs):
                        """
                        Reads S2S file.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/read_vf_file").execute(*args, **kwargs)
                    def non_participating_boundary_zones_temperature(self, *args, **kwargs):
                        """
                        Sets temperature for the non-participating boundary zones.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/non_participating_boundary_zones_temperature").execute(*args, **kwargs)
                    def print_thread_clusters(self, *args, **kwargs):
                        """
                        Prints the following for all boundary threads: thread-id, number of faces, faces per surface cluster, and the number of surface clusters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/print_thread_clusters").execute(*args, **kwargs)
                    def enable_mesh_interface_clustering(self, *args, **kwargs):
                        """
                        Enables surface clusters on mesh interfaces.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/enable_mesh_interface_clustering").execute(*args, **kwargs)
                    def compute_vf_only(self, *args, **kwargs):
                        """
                        Computes/writes view factors only.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_vf_only").execute(*args, **kwargs)
                    def compute_clusters_and_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write surface cluster first and then view factors.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_clusters_and_vf_accelerated").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enters the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    super().__init__(path, service)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enables/disables Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def solution_options(self, *args, **kwargs):
                    """
                    Sets Eulerian Wall Film Model Solution Options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activates Eulerian Wall Film Equations.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Sets Film Material and Properties.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initializes Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enters the Coupled-Solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enables/disables the coupled solution method.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enables/disables the film curvature smoothing option and sets the smoothing parameters.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
        