# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.0, generator: @autorest/python@6.13.16)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import sys
from typing import (
    Any,
    Callable,
    Dict,
    IO,
    Iterator,
    List,
    Optional,
    Type,
    TypeVar,
    Union,
    cast,
    overload,
)

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]
]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_one_clicks_list_request(
    *, type: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/1-clicks"

    # Construct parameters
    if type is not None:
        _params["type"] = _SERIALIZER.query("type", type, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_one_clicks_install_kubernetes_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/1-clicks/kubernetes"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_account_get_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_ssh_keys_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_ssh_keys_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_ssh_keys_get_request(ssh_key_identifier: JSON, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys/{ssh_key_identifier}"
    path_format_arguments = {
        "ssh_key_identifier": _SERIALIZER.url(
            "ssh_key_identifier", ssh_key_identifier, "object"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_ssh_keys_update_request(
    ssh_key_identifier: JSON, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys/{ssh_key_identifier}"
    path_format_arguments = {
        "ssh_key_identifier": _SERIALIZER.url(
            "ssh_key_identifier", ssh_key_identifier, "object"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_ssh_keys_delete_request(
    ssh_key_identifier: JSON, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys/{ssh_key_identifier}"
    path_format_arguments = {
        "ssh_key_identifier": _SERIALIZER.url(
            "ssh_key_identifier", ssh_key_identifier, "object"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_actions_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/actions"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_actions_get_request(action_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/actions/{action_id}"
    path_format_arguments = {
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_list_request(
    *,
    page: int = 1,
    per_page: int = 20,
    with_projects: Optional[bool] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps"

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if with_projects is not None:
        _params["with_projects"] = _SERIALIZER.query(
            "with_projects", with_projects, "bool"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_delete_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_apps_get_request(
    id: str, *, name: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_update_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_apps_restart_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/restart"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_get_logs_active_deployment_request(  # pylint: disable=name-too-long
    app_id: str,
    component_name: str,
    *,
    follow: Optional[bool] = None,
    type: str = "UNSPECIFIED",
    pod_connection_timeout: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/components/{component_name}/logs"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "component_name": _SERIALIZER.url("component_name", component_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if follow is not None:
        _params["follow"] = _SERIALIZER.query("follow", follow, "bool")
    _params["type"] = _SERIALIZER.query("type", type, "str")
    if pod_connection_timeout is not None:
        _params["pod_connection_timeout"] = _SERIALIZER.query(
            "pod_connection_timeout", pod_connection_timeout, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_get_exec_active_deployment_request(  # pylint: disable=name-too-long
    app_id: str, component_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/components/{component_name}/exec"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "component_name": _SERIALIZER.url("component_name", component_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_list_deployments_request(
    app_id: str, *, page: int = 1, per_page: int = 20, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_create_deployment_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_get_deployment_request(
    app_id: str, deployment_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments/{deployment_id}"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_cancel_deployment_request(
    app_id: str, deployment_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments/{deployment_id}/cancel"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_get_logs_request(
    app_id: str,
    deployment_id: str,
    component_name: str,
    *,
    follow: Optional[bool] = None,
    type: str = "UNSPECIFIED",
    pod_connection_timeout: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = (
        "/v2/apps/{app_id}/deployments/{deployment_id}/components/{component_name}/logs"
    )
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
        "component_name": _SERIALIZER.url("component_name", component_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if follow is not None:
        _params["follow"] = _SERIALIZER.query("follow", follow, "bool")
    _params["type"] = _SERIALIZER.query("type", type, "str")
    if pod_connection_timeout is not None:
        _params["pod_connection_timeout"] = _SERIALIZER.query(
            "pod_connection_timeout", pod_connection_timeout, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_get_logs_aggregate_request(
    app_id: str,
    deployment_id: str,
    *,
    follow: Optional[bool] = None,
    type: str = "UNSPECIFIED",
    pod_connection_timeout: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments/{deployment_id}/logs"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if follow is not None:
        _params["follow"] = _SERIALIZER.query("follow", follow, "bool")
    _params["type"] = _SERIALIZER.query("type", type, "str")
    if pod_connection_timeout is not None:
        _params["pod_connection_timeout"] = _SERIALIZER.query(
            "pod_connection_timeout", pod_connection_timeout, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_get_exec_request(
    app_id: str, deployment_id: str, component_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = (
        "/v2/apps/{app_id}/deployments/{deployment_id}/components/{component_name}/exec"
    )
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
        "component_name": _SERIALIZER.url("component_name", component_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_get_logs_active_deployment_aggregate_request(  # pylint: disable=name-too-long
    app_id: str,
    *,
    follow: Optional[bool] = None,
    type: str = "UNSPECIFIED",
    pod_connection_timeout: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/logs"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if follow is not None:
        _params["follow"] = _SERIALIZER.query("follow", follow, "bool")
    _params["type"] = _SERIALIZER.query("type", type, "str")
    if pod_connection_timeout is not None:
        _params["pod_connection_timeout"] = _SERIALIZER.query(
            "pod_connection_timeout", pod_connection_timeout, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_list_instance_sizes_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/tiers/instance_sizes"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_get_instance_size_request(slug: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/tiers/instance_sizes/{slug}"
    path_format_arguments = {
        "slug": _SERIALIZER.url("slug", slug, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_list_regions_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/regions"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_validate_app_spec_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/propose"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_list_alerts_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/alerts"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_assign_alert_destinations_request(  # pylint: disable=name-too-long
    app_id: str, alert_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/alerts/{alert_id}/destinations"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "alert_id": _SERIALIZER.url("alert_id", alert_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_create_rollback_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/rollback"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_validate_rollback_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/rollback/validate"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_commit_rollback_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/rollback/commit"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_revert_rollback_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/rollback/revert"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_get_metrics_bandwidth_daily_request(  # pylint: disable=name-too-long
    app_id: str, *, date: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/metrics/bandwidth_daily"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if date is not None:
        _params["date"] = _SERIALIZER.query("date", date, "iso-8601")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_list_metrics_bandwidth_daily_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/metrics/bandwidth_daily"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_cdn_list_endpoints_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_cdn_create_endpoint_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_cdn_get_endpoint_request(cdn_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints/{cdn_id}"
    path_format_arguments = {
        "cdn_id": _SERIALIZER.url("cdn_id", cdn_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_cdn_update_endpoints_request(cdn_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints/{cdn_id}"
    path_format_arguments = {
        "cdn_id": _SERIALIZER.url("cdn_id", cdn_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_cdn_delete_endpoint_request(cdn_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints/{cdn_id}"
    path_format_arguments = {
        "cdn_id": _SERIALIZER.url("cdn_id", cdn_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_cdn_purge_cache_request(cdn_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints/{cdn_id}/cache"
    path_format_arguments = {
        "cdn_id": _SERIALIZER.url("cdn_id", cdn_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_certificates_list_request(
    *, per_page: int = 20, page: int = 1, name: str = "", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/certificates"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_certificates_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/certificates"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_certificates_get_request(certificate_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/certificates/{certificate_id}"
    path_format_arguments = {
        "certificate_id": _SERIALIZER.url("certificate_id", certificate_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_certificates_delete_request(
    certificate_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/certificates/{certificate_id}"
    path_format_arguments = {
        "certificate_id": _SERIALIZER.url("certificate_id", certificate_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_balance_get_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/balance"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_billing_history_list_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/billing_history"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_invoices_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_invoices_get_by_uuid_request(
    invoice_uuid: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices/{invoice_uuid}"
    path_format_arguments = {
        "invoice_uuid": _SERIALIZER.url("invoice_uuid", invoice_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_invoices_get_csv_by_uuid_request(
    invoice_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "text/csv, application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices/{invoice_uuid}/csv"
    path_format_arguments = {
        "invoice_uuid": _SERIALIZER.url("invoice_uuid", invoice_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_invoices_get_pdf_by_uuid_request(
    invoice_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/pdf, application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices/{invoice_uuid}/pdf"
    path_format_arguments = {
        "invoice_uuid": _SERIALIZER.url("invoice_uuid", invoice_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_invoices_get_summary_by_uuid_request(  # pylint: disable=name-too-long
    invoice_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices/{invoice_uuid}/summary"
    path_format_arguments = {
        "invoice_uuid": _SERIALIZER.url("invoice_uuid", invoice_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_list_options_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/options"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_list_clusters_request(
    *, tag_name: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases"

    # Construct parameters
    if tag_name is not None:
        _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_databases_create_cluster_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_cluster_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_destroy_cluster_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_get_config_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/config"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_patch_config_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/config"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_databases_get_ca_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/ca"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_get_migration_status_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/online-migration"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_online_migration_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/online-migration"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_delete_online_migration_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, migration_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/online-migration/{migration_id}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "migration_id": _SERIALIZER.url("migration_id", migration_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_update_region_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/migrate"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_update_cluster_size_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/resize"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_list_firewall_rules_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/firewall"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_firewall_rules_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/firewall"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_update_maintenance_window_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/maintenance"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_install_update_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/install_update"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_list_backups_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/backups"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_list_replicas_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_create_replica_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_list_events_logs_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/events"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_get_replica_request(
    database_cluster_uuid: str, replica_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas/{replica_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "replica_name": _SERIALIZER.url("replica_name", replica_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_destroy_replica_request(
    database_cluster_uuid: str, replica_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas/{replica_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "replica_name": _SERIALIZER.url("replica_name", replica_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_promote_replica_request(
    database_cluster_uuid: str, replica_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas/{replica_name}/promote"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "replica_name": _SERIALIZER.url("replica_name", replica_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_list_users_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_add_user_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_user_request(
    database_cluster_uuid: str, username: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users/{username}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "username": _SERIALIZER.url("username", username, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_delete_user_request(
    database_cluster_uuid: str, username: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users/{username}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "username": _SERIALIZER.url("username", username, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_update_user_request(
    database_cluster_uuid: str, username: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users/{username}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "username": _SERIALIZER.url("username", username, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_reset_auth_request(
    database_cluster_uuid: str, username: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users/{username}/reset_auth"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "username": _SERIALIZER.url("username", username, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_list_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/dbs"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_add_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/dbs"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_request(
    database_cluster_uuid: str, database_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/dbs/{database_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "database_name": _SERIALIZER.url("database_name", database_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_delete_request(
    database_cluster_uuid: str, database_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/dbs/{database_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "database_name": _SERIALIZER.url("database_name", database_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_list_connection_pools_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_add_connection_pool_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_connection_pool_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, pool_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools/{pool_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "pool_name": _SERIALIZER.url("pool_name", pool_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_connection_pool_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, pool_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools/{pool_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "pool_name": _SERIALIZER.url("pool_name", pool_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_delete_connection_pool_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, pool_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools/{pool_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "pool_name": _SERIALIZER.url("pool_name", pool_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_get_eviction_policy_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/eviction_policy"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_eviction_policy_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/eviction_policy"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_get_sql_mode_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/sql_mode"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_sql_mode_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/sql_mode"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_update_major_version_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/upgrade"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_list_kafka_topics_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/topics"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_create_kafka_topic_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/topics"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_kafka_topic_request(
    database_cluster_uuid: str, topic_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/topics/{topic_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "topic_name": _SERIALIZER.url("topic_name", topic_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_kafka_topic_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, topic_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/topics/{topic_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "topic_name": _SERIALIZER.url("topic_name", topic_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_delete_kafka_topic_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, topic_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/topics/{topic_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "topic_name": _SERIALIZER.url("topic_name", topic_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_list_logsink_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/logsink"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_create_logsink_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/logsink"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_logsink_request(
    database_cluster_uuid: str, logsink_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/logsink/{logsink_id}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "logsink_id": _SERIALIZER.url("logsink_id", logsink_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_logsink_request(
    database_cluster_uuid: str, logsink_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/logsink/{logsink_id}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "logsink_id": _SERIALIZER.url("logsink_id", logsink_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_delete_logsink_request(
    database_cluster_uuid: str, logsink_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/logsink/{logsink_id}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "logsink_id": _SERIALIZER.url("logsink_id", logsink_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_get_cluster_metrics_credentials_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/metrics/credentials"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_cluster_metrics_credentials_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/metrics/credentials"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_list_opeasearch_indexes_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/indexes"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_delete_opensearch_index_request(  # pylint: disable=name-too-long
    database_cluster_uuid: str, index_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/indexes/{index_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "index_name": _SERIALIZER.url("index_name", index_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_domains_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_domains_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_domains_get_request(domain_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_domains_delete_request(domain_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_domains_list_records_request(
    domain_name: str,
    *,
    name: Optional[str] = None,
    type: Optional[str] = None,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if type is not None:
        _params["type"] = _SERIALIZER.query("type", type, "str")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_domains_create_record_request(domain_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_domains_get_record_request(
    domain_name: str, domain_record_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records/{domain_record_id}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
        "domain_record_id": _SERIALIZER.url(
            "domain_record_id", domain_record_id, "int"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_domains_patch_record_request(
    domain_name: str, domain_record_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records/{domain_record_id}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
        "domain_record_id": _SERIALIZER.url(
            "domain_record_id", domain_record_id, "int"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_domains_update_record_request(
    domain_name: str, domain_record_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records/{domain_record_id}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
        "domain_record_id": _SERIALIZER.url(
            "domain_record_id", domain_record_id, "int"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_domains_delete_record_request(
    domain_name: str, domain_record_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records/{domain_record_id}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
        "domain_record_id": _SERIALIZER.url(
            "domain_record_id", domain_record_id, "int"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_droplets_list_request(
    *,
    per_page: int = 20,
    page: int = 1,
    tag_name: Optional[str] = None,
    name: Optional[str] = None,
    type: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if tag_name is not None:
        _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if type is not None:
        _params["type"] = _SERIALIZER.query("type", type, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_by_tag_request(
    *, tag_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets"

    # Construct parameters
    _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="DELETE", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_get_request(droplet_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_request(droplet_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_droplets_list_backups_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/backups"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_get_backup_policy_request(
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/backups/policy"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_list_backup_policies_request(  # pylint: disable=name-too-long
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/backups/policies"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_list_supported_backup_policies_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/backups/supported_policies"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_list_snapshots_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/snapshots"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_list_kernels_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/kernels"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_list_firewalls_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/firewalls"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_list_neighbors_request(
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/neighbors"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_list_associated_resources_request(  # pylint: disable=name-too-long
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_with_associated_resources_selective_request(  # pylint: disable=name-too-long
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources/selective"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_with_associated_resources_dangerous_request(  # pylint: disable=name-too-long
    droplet_id: int, *, x_dangerous: bool, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources/dangerous"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["X-Dangerous"] = _SERIALIZER.header("x_dangerous", x_dangerous, "bool")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_droplets_get_destroy_associated_resources_status_request(  # pylint: disable=name-too-long
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources/status"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_retry_with_associated_resources_request(  # pylint: disable=name-too-long
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources/retry"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_droplets_list_neighbors_ids_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reports/droplet_neighbors_ids"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplet_actions_list_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/actions"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplet_actions_post_request(droplet_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/actions"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_droplet_actions_post_by_tag_request(  # pylint: disable=name-too-long
    *, tag_name: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/actions"

    # Construct parameters
    if tag_name is not None:
        _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="POST", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplet_actions_get_request(
    droplet_id: int, action_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/actions/{action_id}"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_autoscalepools_list_request(
    *, per_page: int = 20, page: int = 1, name: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/autoscale"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_autoscalepools_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/autoscale"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_autoscalepools_get_request(
    autoscale_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/autoscale/{autoscale_pool_id}"
    path_format_arguments = {
        "autoscale_pool_id": _SERIALIZER.url(
            "autoscale_pool_id", autoscale_pool_id, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_autoscalepools_update_request(
    autoscale_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/autoscale/{autoscale_pool_id}"
    path_format_arguments = {
        "autoscale_pool_id": _SERIALIZER.url(
            "autoscale_pool_id", autoscale_pool_id, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_autoscalepools_delete_request(
    autoscale_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/autoscale/{autoscale_pool_id}"
    path_format_arguments = {
        "autoscale_pool_id": _SERIALIZER.url(
            "autoscale_pool_id", autoscale_pool_id, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_autoscalepools_delete_dangerous_request(  # pylint: disable=name-too-long
    autoscale_pool_id: str, *, x_dangerous: bool, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/autoscale/{autoscale_pool_id}/dangerous"
    path_format_arguments = {
        "autoscale_pool_id": _SERIALIZER.url(
            "autoscale_pool_id", autoscale_pool_id, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["X-Dangerous"] = _SERIALIZER.header("x_dangerous", x_dangerous, "bool")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_autoscalepools_list_members_request(  # pylint: disable=name-too-long
    autoscale_pool_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/autoscale/{autoscale_pool_id}/members"
    path_format_arguments = {
        "autoscale_pool_id": _SERIALIZER.url(
            "autoscale_pool_id", autoscale_pool_id, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_autoscalepools_list_history_request(  # pylint: disable=name-too-long
    autoscale_pool_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/autoscale/{autoscale_pool_id}/history"
    path_format_arguments = {
        "autoscale_pool_id": _SERIALIZER.url(
            "autoscale_pool_id", autoscale_pool_id, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_firewalls_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_firewalls_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_firewalls_get_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_firewalls_update_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_firewalls_delete_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_firewalls_assign_droplets_request(
    firewall_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/droplets"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_firewalls_delete_droplets_request(
    firewall_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/droplets"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_firewalls_add_tags_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/tags"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_firewalls_delete_tags_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/tags"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_firewalls_add_rules_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/rules"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_firewalls_delete_rules_request(
    firewall_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/rules"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_functions_list_namespaces_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_functions_create_namespace_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_functions_get_namespace_request(
    namespace_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_functions_delete_namespace_request(
    namespace_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_functions_list_triggers_request(
    namespace_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}/triggers"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_functions_create_trigger_request(
    namespace_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}/triggers"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_functions_get_trigger_request(
    namespace_id: str, trigger_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}/triggers/{trigger_name}"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
        "trigger_name": _SERIALIZER.url("trigger_name", trigger_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_functions_update_trigger_request(
    namespace_id: str, trigger_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}/triggers/{trigger_name}"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
        "trigger_name": _SERIALIZER.url("trigger_name", trigger_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_functions_delete_trigger_request(
    namespace_id: str, trigger_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}/triggers/{trigger_name}"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
        "trigger_name": _SERIALIZER.url("trigger_name", trigger_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_images_list_request(
    *,
    type: Optional[str] = None,
    private: Optional[bool] = None,
    tag_name: Optional[str] = None,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images"

    # Construct parameters
    if type is not None:
        _params["type"] = _SERIALIZER.query("type", type, "str")
    if private is not None:
        _params["private"] = _SERIALIZER.query("private", private, "bool")
    if tag_name is not None:
        _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_images_create_custom_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_images_get_request(image_id: JSON, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "object"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_images_update_request(image_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_images_delete_request(image_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_image_actions_list_request(image_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}/actions"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_image_actions_post_request(image_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}/actions"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_image_actions_get_request(
    image_id: int, action_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}/actions/{action_id}"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_list_clusters_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_create_cluster_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_cluster_request(cluster_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_update_cluster_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_kubernetes_delete_cluster_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_kubernetes_list_associated_resources_request(  # pylint: disable=name-too-long
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/destroy_with_associated_resources"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_destroy_associated_resources_selective_request(  # pylint: disable=name-too-long
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/destroy_with_associated_resources/selective"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_kubernetes_destroy_associated_resources_dangerous_request(  # pylint: disable=name-too-long
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/destroy_with_associated_resources/dangerous"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_kubeconfig_request(
    cluster_id: str, *, expiry_seconds: int = 0, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/kubeconfig"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if expiry_seconds is not None:
        _params["expiry_seconds"] = _SERIALIZER.query(
            "expiry_seconds", expiry_seconds, "int", minimum=0
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_get_credentials_request(
    cluster_id: str, *, expiry_seconds: int = 0, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/credentials"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if expiry_seconds is not None:
        _params["expiry_seconds"] = _SERIALIZER.query(
            "expiry_seconds", expiry_seconds, "int", minimum=0
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_get_available_upgrades_request(  # pylint: disable=name-too-long
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/upgrades"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_upgrade_cluster_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/upgrade"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_list_node_pools_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_add_node_pool_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_node_pool_request(
    cluster_id: str, node_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_update_node_pool_request(  # pylint: disable=name-too-long
    cluster_id: str, node_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_kubernetes_delete_node_pool_request(  # pylint: disable=name-too-long
    cluster_id: str, node_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_kubernetes_delete_node_request(
    cluster_id: str,
    node_pool_id: str,
    node_id: str,
    *,
    skip_drain: int = 0,
    replace: int = 0,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = (
        "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}/nodes/{node_id}"
    )
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
        "node_id": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if skip_drain is not None:
        _params["skip_drain"] = _SERIALIZER.query(
            "skip_drain", skip_drain, "int", maximum=1, minimum=0
        )
    if replace is not None:
        _params["replace"] = _SERIALIZER.query(
            "replace", replace, "int", maximum=1, minimum=0
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="DELETE", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_recycle_node_pool_request(  # pylint: disable=name-too-long
    cluster_id: str, node_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}/recycle"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_cluster_user_request(  # pylint: disable=name-too-long
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/user"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_list_options_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/options"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_run_cluster_lint_request(  # pylint: disable=name-too-long
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/clusterlint"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_cluster_lint_results_request(  # pylint: disable=name-too-long
    cluster_id: str, *, run_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/clusterlint"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if run_id is not None:
        _params["run_id"] = _SERIALIZER.query("run_id", run_id, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_add_registry_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/registry"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_remove_registry_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/registry"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_load_balancers_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_load_balancers_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_load_balancers_get_request(lb_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_load_balancers_update_request(lb_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_load_balancers_delete_request(lb_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_load_balancers_delete_cache_request(  # pylint: disable=name-too-long
    lb_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/cache"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_load_balancers_add_droplets_request(  # pylint: disable=name-too-long
    lb_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/droplets"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_load_balancers_remove_droplets_request(  # pylint: disable=name-too-long
    lb_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/droplets"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_load_balancers_add_forwarding_rules_request(  # pylint: disable=name-too-long
    lb_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/forwarding_rules"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_load_balancers_remove_forwarding_rules_request(  # pylint: disable=name-too-long
    lb_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/forwarding_rules"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_monitoring_list_alert_policy_request(  # pylint: disable=name-too-long
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_create_alert_policy_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_monitoring_get_alert_policy_request(  # pylint: disable=name-too-long
    alert_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts/{alert_uuid}"
    path_format_arguments = {
        "alert_uuid": _SERIALIZER.url("alert_uuid", alert_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_monitoring_update_alert_policy_request(  # pylint: disable=name-too-long
    alert_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts/{alert_uuid}"
    path_format_arguments = {
        "alert_uuid": _SERIALIZER.url("alert_uuid", alert_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_monitoring_delete_alert_policy_request(  # pylint: disable=name-too-long
    alert_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts/{alert_uuid}"
    path_format_arguments = {
        "alert_uuid": _SERIALIZER.url("alert_uuid", alert_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_monitoring_get_droplet_bandwidth_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, interface: str, direction: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/bandwidth"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["interface"] = _SERIALIZER.query("interface", interface, "str")
    _params["direction"] = _SERIALIZER.query("direction", direction, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_cpu_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/cpu"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_filesystem_free_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/filesystem_free"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_filesystem_size_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/filesystem_size"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_load1_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/load_1"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_load5_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/load_5"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_load15_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/load_15"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_memory_cached_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/memory_cached"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_memory_free_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/memory_free"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_memory_total_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/memory_total"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_memory_available_metrics_request(  # pylint: disable=name-too-long
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/memory_available"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_app_memory_percentage_metrics_request(  # pylint: disable=name-too-long
    *,
    app_id: str,
    start: str,
    end: str,
    app_component: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/apps/memory_percentage"

    # Construct parameters
    _params["app_id"] = _SERIALIZER.query("app_id", app_id, "str")
    if app_component is not None:
        _params["app_component"] = _SERIALIZER.query(
            "app_component", app_component, "str"
        )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_app_cpu_percentage_metrics_request(  # pylint: disable=name-too-long
    *,
    app_id: str,
    start: str,
    end: str,
    app_component: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/apps/cpu_percentage"

    # Construct parameters
    _params["app_id"] = _SERIALIZER.query("app_id", app_id, "str")
    if app_component is not None:
        _params["app_component"] = _SERIALIZER.query(
            "app_component", app_component, "str"
        )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_app_restart_count_metrics_yml_request(  # pylint: disable=name-too-long
    *,
    app_id: str,
    start: str,
    end: str,
    app_component: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/apps/restart_count"

    # Construct parameters
    _params["app_id"] = _SERIALIZER.query("app_id", app_id, "str")
    if app_component is not None:
        _params["app_component"] = _SERIALIZER.query(
            "app_component", app_component, "str"
        )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_connections_current_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_connections_current"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_connections_limit_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_connections_limit"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_cpu_utilization_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_cpu_utilization"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_firewall_dropped_bytes_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_firewall_dropped_bytes"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_firewall_dropped_packets_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_firewall_dropped_packets"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_http_responses_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_http_responses"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_http_requests_per_second_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_http_requests_per_second"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_network_throughput_http_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_network_throughput_http"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_network_throughput_udp_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_network_throughput_udp"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_network_throughput_tcp_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_network_throughput_tcp"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_nlb_tcp_network_throughput_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_nlb_tcp_network_throughput"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_nlb_udp_network_throughput_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_nlb_udp_network_throughput"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_tls_connections_current_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_tls_connections_current"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_tls_connections_limit_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_tls_connections_limit"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_frontend_tls_connections_exceeding_rate_limit_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/frontend_tls_connections_exceeding_rate_limit"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_http_session_duration_avg_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_http_session_duration_avg"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_http_session_duration50_p_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_http_session_duration_50p"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_http_session_duration95_p_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_http_session_duration_95p"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_http_response_time_avg_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_http_response_time_avg"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_http_response_time50_p_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_http_response_time_50p"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_http_response_time95_p_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_http_response_time_95p"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_http_response_time99_p_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_http_response_time_99p"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_queue_size_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_queue_size"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_http_responses_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_http_responses"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_connections_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_connections"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_health_checks_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_health_checks"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_lb_droplets_downtime_request(  # pylint: disable=name-too-long
    *, lb_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/load_balancer/droplets_downtime"

    # Construct parameters
    _params["lb_id"] = _SERIALIZER.query("lb_id", lb_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_autoscale_current_instances_request(  # pylint: disable=name-too-long
    *, autoscale_pool_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet_autoscale/current_instances"

    # Construct parameters
    _params["autoscale_pool_id"] = _SERIALIZER.query(
        "autoscale_pool_id", autoscale_pool_id, "str"
    )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_autoscale_target_instances_request(  # pylint: disable=name-too-long
    *, autoscale_pool_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet_autoscale/target_instances"

    # Construct parameters
    _params["autoscale_pool_id"] = _SERIALIZER.query(
        "autoscale_pool_id", autoscale_pool_id, "str"
    )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_autoscale_current_cpu_utilization_yml_request(  # pylint: disable=name-too-long
    *, autoscale_pool_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet_autoscale/current_cpu_utilization"

    # Construct parameters
    _params["autoscale_pool_id"] = _SERIALIZER.query(
        "autoscale_pool_id", autoscale_pool_id, "str"
    )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_autoscale_target_cpu_utilization_request(  # pylint: disable=name-too-long
    *, autoscale_pool_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet_autoscale/target_cpu_utilization"

    # Construct parameters
    _params["autoscale_pool_id"] = _SERIALIZER.query(
        "autoscale_pool_id", autoscale_pool_id, "str"
    )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_autoscale_current_memory_utilization_request(  # pylint: disable=name-too-long
    *, autoscale_pool_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet_autoscale/current_memory_utilization"

    # Construct parameters
    _params["autoscale_pool_id"] = _SERIALIZER.query(
        "autoscale_pool_id", autoscale_pool_id, "str"
    )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_autoscale_target_memory_utilization_request(  # pylint: disable=name-too-long
    *, autoscale_pool_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet_autoscale/target_memory_utilization"

    # Construct parameters
    _params["autoscale_pool_id"] = _SERIALIZER.query(
        "autoscale_pool_id", autoscale_pool_id, "str"
    )
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_create_destination_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks/destinations"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_monitoring_list_destinations_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks/destinations"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_monitoring_get_destination_request(
    destination_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks/destinations/{destination_uuid}"
    path_format_arguments = {
        "destination_uuid": _SERIALIZER.url(
            "destination_uuid", destination_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_monitoring_update_destination_request(  # pylint: disable=name-too-long
    destination_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks/destinations/{destination_uuid}"
    path_format_arguments = {
        "destination_uuid": _SERIALIZER.url(
            "destination_uuid", destination_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_monitoring_delete_destination_request(  # pylint: disable=name-too-long
    destination_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks/destinations/{destination_uuid}"
    path_format_arguments = {
        "destination_uuid": _SERIALIZER.url(
            "destination_uuid", destination_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_monitoring_create_sink_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_monitoring_list_sinks_request(
    *, resource_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks"

    # Construct parameters
    if resource_id is not None:
        _params["resource_id"] = _SERIALIZER.query(
            "resource_id",
            resource_id,
            "str",
            pattern=r"^do:(dbaas|domain|droplet|floatingip|loadbalancer|space|volume|kubernetes|vpc):.*",
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_sink_request(sink_uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks/{sink_uuid}"
    path_format_arguments = {
        "sink_uuid": _SERIALIZER.url("sink_uuid", sink_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_monitoring_delete_sink_request(sink_uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/sinks/{sink_uuid}"
    path_format_arguments = {
        "sink_uuid": _SERIALIZER.url("sink_uuid", sink_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_projects_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_projects_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_projects_get_default_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_projects_update_default_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_projects_patch_default_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_projects_get_request(project_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_projects_update_request(project_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_projects_patch_request(project_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_projects_delete_request(project_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_projects_list_resources_request(
    project_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}/resources"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_projects_assign_resources_request(
    project_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}/resources"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_projects_list_resources_default_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default/resources"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_projects_assign_resources_default_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default/resources"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_regions_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/regions"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_get_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_registry_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_registry_delete_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_registry_get_subscription_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/subscription"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_registry_update_subscription_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/subscription"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_registry_get_docker_credentials_request(  # pylint: disable=name-too-long
    *, expiry_seconds: int = 0, read_write: bool = False, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/docker-credentials"

    # Construct parameters
    if expiry_seconds is not None:
        _params["expiry_seconds"] = _SERIALIZER.query(
            "expiry_seconds", expiry_seconds, "int", minimum=0
        )
    if read_write is not None:
        _params["read_write"] = _SERIALIZER.query("read_write", read_write, "bool")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_validate_name_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/validate-name"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_registry_list_repositories_request(
    registry_name: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/repositories"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_list_repositories_v2_request(  # pylint: disable=name-too-long
    registry_name: str,
    *,
    per_page: int = 20,
    page: int = 1,
    page_token: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/repositoriesV2"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if page_token is not None:
        _params["page_token"] = _SERIALIZER.query("page_token", page_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_list_repository_tags_request(  # pylint: disable=name-too-long
    registry_name: str,
    repository_name: str,
    *,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/repositories/{repository_name}/tags"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "repository_name": _SERIALIZER.url("repository_name", repository_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_delete_repository_tag_request(  # pylint: disable=name-too-long
    registry_name: str, repository_name: str, repository_tag: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/repositories/{repository_name}/tags/{repository_tag}"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "repository_name": _SERIALIZER.url("repository_name", repository_name, "str"),
        "repository_tag": _SERIALIZER.url("repository_tag", repository_tag, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_registry_list_repository_manifests_request(  # pylint: disable=name-too-long
    registry_name: str,
    repository_name: str,
    *,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/repositories/{repository_name}/digests"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "repository_name": _SERIALIZER.url("repository_name", repository_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_delete_repository_manifest_request(  # pylint: disable=name-too-long
    registry_name: str, repository_name: str, manifest_digest: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/repositories/{repository_name}/digests/{manifest_digest}"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "repository_name": _SERIALIZER.url("repository_name", repository_name, "str"),
        "manifest_digest": _SERIALIZER.url("manifest_digest", manifest_digest, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_registry_run_garbage_collection_request(  # pylint: disable=name-too-long
    registry_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/garbage-collection"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_registry_get_garbage_collection_request(  # pylint: disable=name-too-long
    registry_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/garbage-collection"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_registry_list_garbage_collections_request(  # pylint: disable=name-too-long
    registry_name: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/garbage-collections"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_update_garbage_collection_request(  # pylint: disable=name-too-long
    registry_name: str, garbage_collection_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/garbage-collection/{garbage_collection_uuid}"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "garbage_collection_uuid": _SERIALIZER.url(
            "garbage_collection_uuid", garbage_collection_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_registry_get_options_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/options"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_reserved_ips_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_get_request(reserved_ip: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_delete_request(reserved_ip: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_actions_list_request(
    reserved_ip: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}/actions"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_actions_post_request(
    reserved_ip: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}/actions"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_actions_get_request(
    reserved_ip: str, action_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}/actions/{action_id}"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ipv6_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ipv6"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_reserved_ipv6_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ipv6"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_reserved_ipv6_get_request(reserved_ipv6: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ipv6/{reserved_ipv6}"
    path_format_arguments = {
        "reserved_ipv6": _SERIALIZER.url("reserved_ipv6", reserved_ipv6, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ipv6_delete_request(
    reserved_ipv6: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ipv6/{reserved_ipv6}"
    path_format_arguments = {
        "reserved_ipv6": _SERIALIZER.url("reserved_ipv6", reserved_ipv6, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_reserved_ipv6_actions_post_request(
    reserved_ipv6: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ipv6/{reserved_ipv6}/actions"
    path_format_arguments = {
        "reserved_ipv6": _SERIALIZER.url("reserved_ipv6", reserved_ipv6, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_sizes_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/sizes"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_snapshots_list_request(
    *,
    per_page: int = 20,
    page: int = 1,
    resource_type: Optional[str] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/snapshots"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if resource_type is not None:
        _params["resource_type"] = _SERIALIZER.query(
            "resource_type", resource_type, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_snapshots_get_request(snapshot_id: JSON, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/snapshots/{snapshot_id}"
    path_format_arguments = {
        "snapshot_id": _SERIALIZER.url("snapshot_id", snapshot_id, "object"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_snapshots_delete_request(snapshot_id: JSON, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/snapshots/{snapshot_id}"
    path_format_arguments = {
        "snapshot_id": _SERIALIZER.url("snapshot_id", snapshot_id, "object"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_tags_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_tags_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_tags_get_request(tag_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags/{tag_id}"
    path_format_arguments = {
        "tag_id": _SERIALIZER.url(
            "tag_id", tag_id, "str", max_length=255, pattern=r"^[a-zA-Z0-9_\-\:]+$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_tags_delete_request(tag_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags/{tag_id}"
    path_format_arguments = {
        "tag_id": _SERIALIZER.url(
            "tag_id", tag_id, "str", max_length=255, pattern=r"^[a-zA-Z0-9_\-\:]+$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_tags_assign_resources_request(tag_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags/{tag_id}/resources"
    path_format_arguments = {
        "tag_id": _SERIALIZER.url(
            "tag_id", tag_id, "str", max_length=255, pattern=r"^[a-zA-Z0-9_\-\:]+$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_tags_unassign_resources_request(tag_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags/{tag_id}/resources"
    path_format_arguments = {
        "tag_id": _SERIALIZER.url(
            "tag_id", tag_id, "str", max_length=255, pattern=r"^[a-zA-Z0-9_\-\:]+$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_volumes_list_request(
    *,
    name: Optional[str] = None,
    region: Optional[str] = None,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes"

    # Construct parameters
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if region is not None:
        _params["region"] = _SERIALIZER.query("region", region, "str")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volumes_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_volumes_delete_by_name_request(
    *, name: Optional[str] = None, region: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes"

    # Construct parameters
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if region is not None:
        _params["region"] = _SERIALIZER.query("region", region, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="DELETE", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volumes_get_request(volume_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_volumes_delete_request(volume_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_volume_actions_post_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/actions"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="POST", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_actions_list_request(
    volume_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/actions"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_actions_post_by_id_request(
    volume_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/actions"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="POST", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_actions_get_request(
    volume_id: str, action_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/actions/{action_id}"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_snapshots_get_by_id_request(
    snapshot_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/snapshots/{snapshot_id}"
    path_format_arguments = {
        "snapshot_id": _SERIALIZER.url("snapshot_id", snapshot_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_volume_snapshots_delete_by_id_request(  # pylint: disable=name-too-long
    snapshot_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/snapshots/{snapshot_id}"
    path_format_arguments = {
        "snapshot_id": _SERIALIZER.url("snapshot_id", snapshot_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_volume_snapshots_list_request(
    volume_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/snapshots"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_snapshots_create_request(volume_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/snapshots"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_vpcs_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_vpcs_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_vpcs_get_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_vpcs_update_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_vpcs_patch_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_vpcs_delete_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_vpcs_list_members_request(
    vpc_id: str,
    *,
    resource_type: Optional[str] = None,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}/members"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if resource_type is not None:
        _params["resource_type"] = _SERIALIZER.query(
            "resource_type", resource_type, "str"
        )
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_vpcs_list_peerings_request(
    vpc_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}/peerings"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_vpcs_create_peerings_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}/peerings"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_vpcs_patch_peerings_request(
    vpc_id: str, vpc_peering_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}/peerings/{vpc_peering_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
        "vpc_peering_id": _SERIALIZER.url("vpc_peering_id", vpc_peering_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_vpc_peerings_list_request(
    *, per_page: int = 20, page: int = 1, region: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpc_peerings"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if region is not None:
        _params["region"] = _SERIALIZER.query("region", region, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_vpc_peerings_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpc_peerings"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_vpc_peerings_get_request(vpc_peering_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpc_peerings/{vpc_peering_id}"
    path_format_arguments = {
        "vpc_peering_id": _SERIALIZER.url("vpc_peering_id", vpc_peering_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_vpc_peerings_patch_request(vpc_peering_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpc_peerings/{vpc_peering_id}"
    path_format_arguments = {
        "vpc_peering_id": _SERIALIZER.url("vpc_peering_id", vpc_peering_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_vpc_peerings_delete_request(
    vpc_peering_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpc_peerings/{vpc_peering_id}"
    path_format_arguments = {
        "vpc_peering_id": _SERIALIZER.url("vpc_peering_id", vpc_peering_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_uptime_list_checks_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_uptime_create_check_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_uptime_get_check_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_uptime_update_check_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_uptime_delete_check_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_uptime_get_check_state_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/state"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_uptime_list_alerts_request(
    check_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_uptime_create_alert_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_uptime_get_alert_request(
    check_id: str, alert_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts/{alert_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
        "alert_id": _SERIALIZER.url("alert_id", alert_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_uptime_update_alert_request(
    check_id: str, alert_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts/{alert_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
        "alert_id": _SERIALIZER.url("alert_id", alert_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_uptime_delete_alert_request(
    check_id: str, alert_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts/{alert_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
        "alert_id": _SERIALIZER.url("alert_id", alert_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_create_agent_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_list_agents_request(
    *,
    only_deployed: Optional[bool] = None,
    page: Optional[int] = None,
    per_page: Optional[int] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents"

    # Construct parameters
    if only_deployed is not None:
        _params["only_deployed"] = _SERIALIZER.query(
            "only_deployed", only_deployed, "bool"
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_genai_list_agent_api_keys_request(
    agent_uuid: str,
    *,
    page: Optional[int] = None,
    per_page: Optional[int] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/api_keys"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_genai_create_agent_api_key_request(
    agent_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/api_keys"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_delete_agent_api_key_request(
    agent_uuid: str, api_key_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/api_keys/{api_key_uuid}"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
        "api_key_uuid": _SERIALIZER.url("api_key_uuid", api_key_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_update_agent_api_key_request(
    agent_uuid: str, api_key_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/api_keys/{api_key_uuid}"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
        "api_key_uuid": _SERIALIZER.url("api_key_uuid", api_key_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_regenerate_agent_api_key_request(  # pylint: disable=name-too-long
    agent_uuid: str, api_key_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/api_keys/{api_key_uuid}/regenerate"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
        "api_key_uuid": _SERIALIZER.url("api_key_uuid", api_key_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_attach_agent_function_request(  # pylint: disable=name-too-long
    agent_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/functions"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_update_agent_function_request(  # pylint: disable=name-too-long
    agent_uuid: str, function_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/functions/{function_uuid}"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
        "function_uuid": _SERIALIZER.url("function_uuid", function_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_detach_agent_function_request(  # pylint: disable=name-too-long
    agent_uuid: str, function_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/functions/{function_uuid}"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
        "function_uuid": _SERIALIZER.url("function_uuid", function_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_detach_knowledge_base_request(  # pylint: disable=name-too-long
    agent_uuid: str, knowledge_base_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/knowledge_bases/{knowledge_base_uuid}"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
        "knowledge_base_uuid": _SERIALIZER.url(
            "knowledge_base_uuid", knowledge_base_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_attach_knowledge_base_request(  # pylint: disable=name-too-long
    agent_uuid: str, knowledge_base_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{agent_uuid}/knowledge_bases/{knowledge_base_uuid}"
    path_format_arguments = {
        "agent_uuid": _SERIALIZER.url("agent_uuid", agent_uuid, "str"),
        "knowledge_base_uuid": _SERIALIZER.url(
            "knowledge_base_uuid", knowledge_base_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_detach_agent_request(
    parent_agent_uuid: str, child_agent_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{parent_agent_uuid}/child_agents/{child_agent_uuid}"
    path_format_arguments = {
        "parent_agent_uuid": _SERIALIZER.url(
            "parent_agent_uuid", parent_agent_uuid, "str"
        ),
        "child_agent_uuid": _SERIALIZER.url(
            "child_agent_uuid", child_agent_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_attach_agent_request(
    parent_agent_uuid: str, child_agent_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{parent_agent_uuid}/child_agents/{child_agent_uuid}"
    path_format_arguments = {
        "parent_agent_uuid": _SERIALIZER.url(
            "parent_agent_uuid", parent_agent_uuid, "str"
        ),
        "child_agent_uuid": _SERIALIZER.url(
            "child_agent_uuid", child_agent_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_update_attached_agent_request(  # pylint: disable=name-too-long
    parent_agent_uuid: str, child_agent_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{parent_agent_uuid}/child_agents/{child_agent_uuid}"
    path_format_arguments = {
        "parent_agent_uuid": _SERIALIZER.url(
            "parent_agent_uuid", parent_agent_uuid, "str"
        ),
        "child_agent_uuid": _SERIALIZER.url(
            "child_agent_uuid", child_agent_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_delete_agent_request(uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{uuid}"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_get_agent_request(uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{uuid}"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_genai_update_agent_request(uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{uuid}"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_get_agent_children_request(uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{uuid}/child_agents"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_genai_update_agent_deployment_visibility_request(  # pylint: disable=name-too-long
    uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/agents/{uuid}/deployment_visibility"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_list_anthropic_api_keys_request(  # pylint: disable=name-too-long
    *, page: Optional[int] = None, per_page: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/anthropic/keys"

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_genai_create_anthropic_api_key_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/anthropic/keys"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_delete_anthropic_api_key_request(  # pylint: disable=name-too-long
    api_key_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/anthropic/keys/{api_key_uuid}"
    path_format_arguments = {
        "api_key_uuid": _SERIALIZER.url("api_key_uuid", api_key_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_get_anthropic_api_key_request(  # pylint: disable=name-too-long
    api_key_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/anthropic/keys/{api_key_uuid}"
    path_format_arguments = {
        "api_key_uuid": _SERIALIZER.url("api_key_uuid", api_key_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_genai_update_anthropic_api_key_request(  # pylint: disable=name-too-long
    api_key_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/anthropic/keys/{api_key_uuid}"
    path_format_arguments = {
        "api_key_uuid": _SERIALIZER.url("api_key_uuid", api_key_uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_list_agents_by_anthropic_key_request(  # pylint: disable=name-too-long
    uuid: str,
    *,
    page: Optional[int] = None,
    per_page: Optional[int] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/anthropic/keys/{uuid}/agents"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_genai_list_indexing_jobs_request(
    *, page: Optional[int] = None, per_page: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/indexing_jobs"

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_genai_create_indexing_job_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/indexing_jobs"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_list_indexing_job_data_sources_request(  # pylint: disable=name-too-long
    indexing_job_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/indexing_jobs/{indexing_job_uuid}/data_sources"
    path_format_arguments = {
        "indexing_job_uuid": _SERIALIZER.url(
            "indexing_job_uuid", indexing_job_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_genai_get_indexing_job_request(uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/indexing_jobs/{uuid}"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_genai_cancel_indexing_job_request(uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/indexing_jobs/{uuid}/cancel"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_list_knowledge_bases_request(
    *, page: Optional[int] = None, per_page: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/knowledge_bases"

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_genai_create_knowledge_base_request(
    **kwargs: Any,
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/knowledge_bases"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_list_knowledge_base_data_sources_request(  # pylint: disable=name-too-long
    knowledge_base_uuid: str,
    *,
    page: Optional[int] = None,
    per_page: Optional[int] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/knowledge_bases/{knowledge_base_uuid}/data_sources"
    path_format_arguments = {
        "knowledge_base_uuid": _SERIALIZER.url(
            "knowledge_base_uuid", knowledge_base_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_genai_create_knowledge_base_data_source_request(  # pylint: disable=name-too-long
    knowledge_base_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/knowledge_bases/{knowledge_base_uuid}/data_sources"
    path_format_arguments = {
        "knowledge_base_uuid": _SERIALIZER.url(
            "knowledge_base_uuid", knowledge_base_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_genai_delete_knowledge_base_data_source_request(  # pylint: disable=name-too-long
    knowledge_base_uuid: str, data_source_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/knowledge_bases/{knowledge_base_uuid}/data_sources/{data_source_uuid}"
    path_format_arguments = {
        "knowledge_base_uuid": _SERIALIZER.url(
            "knowledge_base_uuid", knowledge_base_uuid, "str"
        ),
        "data_source_uuid": _SERIALIZER.url(
            "data_source_uuid", data_source_uuid, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_update_knowledge_base_request(
    uuid: str, **kwargs: Any
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/knowledge_bases/{uuid}"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_genai_delete_knowledge_base_request(
    uuid: str, **kwargs: Any
) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/knowledge_bases/{uuid}"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_genai_get_knowledge_base_request(uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/knowledge_bases/{uuid}"
    path_format_arguments = {
        "uuid": _SERIALIZER.url("uuid", uuid, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_genai_list_models_request(
    *,
    usecases: Optional[List[str]] = None,
    public_only: Optional[bool] = None,
    page: Optional[int] = None,
    per_page: Optional[int] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/models"

    # Construct parameters
    if usecases is not None:
        _params["usecases"] = _SERIALIZER.query("usecases", usecases, "[str]")
    if public_only is not None:
        _params["public_only"] = _SERIALIZER.query("public_only", public_only, "bool")
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query("per_page", per_page, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_genai_list_datacenter_regions_request(  # pylint: disable=name-too-long
    *,
    serves_inference: Optional[bool] = None,
    serves_batch: Optional[bool] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/gen-ai/regions"

    # Construct parameters
    if serves_inference is not None:
        _params["serves_inference"] = _SERIALIZER.query(
            "serves_inference", serves_inference, "bool"
        )
    if serves_batch is not None:
        _params["serves_batch"] = _SERIALIZER.query(
            "serves_batch", serves_batch, "bool"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


class OneClicksOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`one_clicks` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def list(self, *, type: Optional[str] = None, **kwargs: Any) -> JSON:
        """List 1-Click Applications.

        To list all available 1-Click applications, send a GET request to ``/v2/1-clicks``. The
        ``type`` may
        be provided as query paramater in order to restrict results to a certain type of 1-Click, for
        example: ``/v2/1-clicks?type=droplet``. Current supported types are ``kubernetes`` and
        ``droplet``.

        The response will be a JSON object with a key called ``1_clicks``. This will be set to an array
        of
        1-Click application data, each of which will contain the the slug and type for the 1-Click.

        :keyword type: Restrict results to a certain type of 1-Click. Known values are: "droplet" and
         "kubernetes". Default value is None.
        :paramtype type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "1_clicks": [
                        {
                            "slug": "str",  # The slug identifier for the 1-Click
                              application. Required.
                            "type": "str"  # The type of the 1-Click application.
                              Required.
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_one_clicks_list_request(
            type=type,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ratelimit-limit"] = self._deserialize(
            "int", response.headers.get("ratelimit-limit")
        )
        response_headers["ratelimit-remaining"] = self._deserialize(
            "int", response.headers.get("ratelimit-remaining")
        )
        response_headers["ratelimit-reset"] = self._deserialize(
            "int", response.headers.get("ratelimit-reset")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def install_kubernetes(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Install Kubernetes 1-Click Applications.

        To install a Kubernetes 1-Click application on a cluster, send a POST request to
        ``/v2/1-clicks/kubernetes``. The ``addon_slugs`` and ``cluster_uuid`` must be provided as body
        parameter in order to specify which 1-Click application(s) to install. To list all available
        1-Click Kubernetes applications, send a request to ``/v2/1-clicks?type=kubernetes``.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "addon_slugs": [
                        "str"  # An array of 1-Click Application slugs to be installed to the
                          Kubernetes cluster. Required.
                    ],
                    "cluster_uuid": "str"  # A unique ID for the Kubernetes cluster to which the
                      1-Click Applications will be installed. Required.
                }

                # response body for status code(s): 200
                response == {
                    "message": "str"  # Optional. A message about the result of the request.
                }
        """

    @overload
    def install_kubernetes(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Install Kubernetes 1-Click Applications.

        To install a Kubernetes 1-Click application on a cluster, send a POST request to
        ``/v2/1-clicks/kubernetes``. The ``addon_slugs`` and ``cluster_uuid`` must be provided as body
        parameter in order to specify which 1-Click application(s) to install. To list all available
        1-Click Kubernetes applications, send a request to ``/v2/1-clicks?type=kubernetes``.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "message": "str"  # Optional. A message about the result of the request.
                }
        """

    @distributed_trace
    def install_kubernetes(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Install Kubernetes 1-Click Applications.

        To install a Kubernetes 1-Click application on a cluster, send a POST request to
        ``/v2/1-clicks/kubernetes``. The ``addon_slugs`` and ``cluster_uuid`` must be provided as body
        parameter in order to specify which 1-Click application(s) to install. To list all available
        1-Click Kubernetes applications, send a request to ``/v2/1-clicks?type=kubernetes``.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "addon_slugs": [
                        "str"  # An array of 1-Click Application slugs to be installed to the
                          Kubernetes cluster. Required.
                    ],
                    "cluster_uuid": "str"  # A unique ID for the Kubernetes cluster to which the
                      1-Click Applications will be installed. Required.
                }

                # response body for status code(s): 200
                response == {
                    "message": "str"  # Optional. A message about the result of the request.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_one_clicks_install_kubernetes_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ratelimit-limit"] = self._deserialize(
            "int", response.headers.get("ratelimit-limit")
        )
        response_headers["ratelimit-remaining"] = self._deserialize(
            "int", response.headers.get("ratelimit-remaining")
        )
        response_headers["ratelimit-reset"] = self._deserialize(
            "int", response.headers.get("ratelimit-reset")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class AccountOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`account` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def get(self, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Get User Information.

        To show information about the current user account, send a GET request to ``/v2/account``.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": {
                        "droplet_limit": 0,  # The total number of Droplets current user or
                          team may have active at one time. Required.
                        "email": "str",  # The email address used by the current user to
                          register for DigitalOcean. Required.
                        "email_verified": False,  # Default value is False. If true, the user
                          has verified their account via email. False otherwise. Required.
                        "floating_ip_limit": 0,  # The total number of Floating IPs the
                          current user or team may have. Required.
                        "status": "active",  # Default value is "active". This value is one
                          of "active", "warning" or "locked". Known values are: "active", "warning",
                          and "locked".
                        "status_message": "str",  # A human-readable message giving more
                          details about the status of the account. Required.
                        "uuid": "str",  # The unique universal identifier for the current
                          user. Required.
                        "name": "str",  # Optional. The display name for the current user.
                        "team": {
                            "name": "str",  # Optional. The name for the current team.
                            "uuid": "str"  # Optional. The unique universal identifier
                              for the current team.
                        }
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_account_get_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ratelimit-limit"] = self._deserialize(
            "int", response.headers.get("ratelimit-limit")
        )
        response_headers["ratelimit-remaining"] = self._deserialize(
            "int", response.headers.get("ratelimit-remaining")
        )
        response_headers["ratelimit-reset"] = self._deserialize(
            "int", response.headers.get("ratelimit-reset")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class SshKeysOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`ssh_keys` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def list(self, *, per_page: int = 20, page: int = 1, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """List All SSH Keys.

        To list all of the keys in your account, send a GET request to ``/v2/account/keys``. The
        response will be a JSON object with a key set to ``ssh_keys``. The value of this will be an
        array of ssh_key objects, each of which contains the standard ssh_key attributes.

        :keyword per_page: Number of items returned per page. Default value is 20.
        :paramtype per_page: int
        :keyword page: Which 'page' of paginated results to return. Default value is 1.
        :paramtype page: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "meta": {
                        "total": 0  # Optional. Number of objects returned by the request.
                    },
                    "links": {
                        "pages": {}
                    },
                    "ssh_keys": [
                        {
                            "name": "str",  # A human-readable display name for this key,
                              used to easily identify the SSH keys when they are displayed. Required.
                            "public_key": "str",  # The entire public key string that was
                              uploaded. Embedded into the root user's ``authorized_keys`` file if you
                              include this key during Droplet creation. Required.
                            "fingerprint": "str",  # Optional. A unique identifier that
                              differentiates this key from other keys using  a format that SSH
                              recognizes. The fingerprint is created when the key is added to your
                              account.
                            "id": 0  # Optional. A unique identification number for this
                              key. Can be used to embed a  specific SSH key into a Droplet.
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_ssh_keys_list_request(
            per_page=per_page,
            page=page,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ratelimit-limit"] = self._deserialize(
            "int", response.headers.get("ratelimit-limit")
        )
        response_headers["ratelimit-remaining"] = self._deserialize(
            "int", response.headers.get("ratelimit-remaining")
        )
        response_headers["ratelimit-reset"] = self._deserialize(
            "int", response.headers.get("ratelimit-reset")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create a New SSH Key.

        To add a new SSH public key to your DigitalOcean account, send a POST request to
        ``/v2/account/keys``. Set the ``name`` attribute to the name you wish to use and the
        ``public_key`` attribute to the full public key you are adding.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # A human-readable display name for this key, used to easily
                      identify the SSH keys when they are displayed. Required.
                    "public_key": "str",  # The entire public key string that was uploaded.
                      Embedded into the root user's ``authorized_keys`` file if you include this key
                      during Droplet creation. Required.
                    "fingerprint": "str",  # Optional. A unique identifier that differentiates
                      this key from other keys using  a format that SSH recognizes. The fingerprint is
                      created when the key is added to your account.
                    "id": 0  # Optional. A unique identification number for this key. Can be used
                      to embed a  specific SSH key into a Droplet.
                }

                # response body for status code(s): 201
                response == {
                    "ssh_key": {
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str",  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0  # Optional. A unique identification number for this key. Can
                          be used to embed a  specific SSH key into a Droplet.
                    }
                }
        """

    @overload
    def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Create a New SSH Key.

        To add a new SSH public key to your DigitalOcean account, send a POST request to
        ``/v2/account/keys``. Set the ``name`` attribute to the name you wish to use and the
        ``public_key`` attribute to the full public key you are adding.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201
                response == {
                    "ssh_key": {
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str",  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0  # Optional. A unique identification number for this key. Can
                          be used to embed a  specific SSH key into a Droplet.
                    }
                }
        """

    @distributed_trace
    def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Create a New SSH Key.

        To add a new SSH public key to your DigitalOcean account, send a POST request to
        ``/v2/account/keys``. Set the ``name`` attribute to the name you wish to use and the
        ``public_key`` attribute to the full public key you are adding.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str",  # A human-readable display name for this key, used to easily
                      identify the SSH keys when they are displayed. Required.
                    "public_key": "str",  # The entire public key string that was uploaded.
                      Embedded into the root user's ``authorized_keys`` file if you include this key
                      during Droplet creation. Required.
                    "fingerprint": "str",  # Optional. A unique identifier that differentiates
                      this key from other keys using  a format that SSH recognizes. The fingerprint is
                      created when the key is added to your account.
                    "id": 0  # Optional. A unique identification number for this key. Can be used
                      to embed a  specific SSH key into a Droplet.
                }

                # response body for status code(s): 201
                response == {
                    "ssh_key": {
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str",  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0  # Optional. A unique identification number for this key. Can
                          be used to embed a  specific SSH key into a Droplet.
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_ssh_keys_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ratelimit-limit"] = self._deserialize(
            "int", response.headers.get("ratelimit-limit")
        )
        response_headers["ratelimit-remaining"] = self._deserialize(
            "int", response.headers.get("ratelimit-remaining")
        )
        response_headers["ratelimit-reset"] = self._deserialize(
            "int", response.headers.get("ratelimit-reset")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get(self, ssh_key_identifier: JSON, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Retrieve an Existing SSH Key.

        To get information about a key, send a GET request to ``/v2/account/keys/$KEY_ID`` or
        ``/v2/account/keys/$KEY_FINGERPRINT``.
        The response will be a JSON object with the key ``ssh_key`` and value an ssh_key object which
        contains the standard ssh_key attributes.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ssh_key": {
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str",  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0  # Optional. A unique identification number for this key. Can
                          be used to embed a  specific SSH key into a Droplet.
                    }
                }
                # response body for status code(s): 404
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_ssh_keys_get_request(
            ssh_key_identifier=ssh_key_identifier,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 404:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def update(
        self,
        ssh_key_identifier: JSON,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        # pylint: disable=line-too-long
        """Update an SSH Key's Name.

        To update the name of an SSH key, send a PUT request to either ``/v2/account/keys/$SSH_KEY_ID``
        or ``/v2/account/keys/$SSH_KEY_FINGERPRINT``. Set the ``name`` attribute to the new name you
        want to use.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :param body: Set the ``name`` attribute to the new name you want to use. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str"  # Optional. A human-readable display name for this key, used
                      to easily identify the SSH keys when they are displayed.
                }

                # response body for status code(s): 200
                response == {
                    "ssh_key": {
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str",  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0  # Optional. A unique identification number for this key. Can
                          be used to embed a  specific SSH key into a Droplet.
                    }
                }
                # response body for status code(s): 404
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @overload
    def update(
        self,
        ssh_key_identifier: JSON,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        # pylint: disable=line-too-long
        """Update an SSH Key's Name.

        To update the name of an SSH key, send a PUT request to either ``/v2/account/keys/$SSH_KEY_ID``
        or ``/v2/account/keys/$SSH_KEY_FINGERPRINT``. Set the ``name`` attribute to the new name you
        want to use.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :param body: Set the ``name`` attribute to the new name you want to use. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ssh_key": {
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str",  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0  # Optional. A unique identification number for this key. Can
                          be used to embed a  specific SSH key into a Droplet.
                    }
                }
                # response body for status code(s): 404
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @distributed_trace
    def update(
        self, ssh_key_identifier: JSON, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Update an SSH Key's Name.

        To update the name of an SSH key, send a PUT request to either ``/v2/account/keys/$SSH_KEY_ID``
        or ``/v2/account/keys/$SSH_KEY_FINGERPRINT``. Set the ``name`` attribute to the new name you
        want to use.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :param body: Set the ``name`` attribute to the new name you want to use. Is either a JSON type
         or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str"  # Optional. A human-readable display name for this key, used
                      to easily identify the SSH keys when they are displayed.
                }

                # response body for status code(s): 200
                response == {
                    "ssh_key": {
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str",  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0  # Optional. A unique identification number for this key. Can
                          be used to embed a  specific SSH key into a Droplet.
                    }
                }
                # response body for status code(s): 404
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_ssh_keys_update_request(
            ssh_key_identifier=ssh_key_identifier,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 404:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def delete(self, ssh_key_identifier: JSON, **kwargs: Any) -> Optional[JSON]:
        # pylint: disable=line-too-long
        """Delete an SSH Key.

        To destroy a public SSH key that you have in your account, send a DELETE request to
        ``/v2/account/keys/$KEY_ID`` or ``/v2/account/keys/$KEY_FINGERPRINT``.
        A 204 status will be returned, indicating that the action was successful and that the response
        body is empty.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :return: JSON object or None
        :rtype: JSON or None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 404
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        _request = build_ssh_keys_delete_request(
            ssh_key_identifier=ssh_key_identifier,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 204:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

        if response.status_code == 404:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore


class ActionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`actions` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def list(self, *, per_page: int = 20, page: int = 1, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """List All Actions.

        This will be the entire list of actions taken on your account, so it will be quite large. As
        with any large collection returned by the API, the results will be paginated with only 20 on
        each page by default.

        :keyword per_page: Number of items returned per page. Default value is 20.
        :paramtype per_page: int
        :keyword page: Which 'page' of paginated results to return. Default value is 1.
        :paramtype page: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "meta": {
                        "total": 0  # Optional. Number of objects returned by the request.
                    },
                    "actions": [
                        {
                            "completed_at": "2020-02-20 00:00:00",  # Optional. A time
                              value given in ISO8601 combined date and time format that represents when
                              the action was completed.
                            "id": 0,  # Optional. A unique numeric ID that can be used to
                              identify and reference an action.
                            "region": {
                                "available": bool,  # This is a boolean value that
                                  represents whether new Droplets can be created in this region.
                                  Required.
                                "features": {},  # This attribute is set to an array
                                  which contains features available in this region. Required.
                                "name": "str",  # The display name of the region.
                                  This will be a full name that is used in the control panel and other
                                  interfaces. Required.
                                "sizes": {},  # This attribute is set to an array
                                  which contains the identifying slugs for the sizes available in this
                                  region. Required.
                                "slug": "str"  # A human-readable string that is used
                                  as a unique identifier for each region. Required.
                            },
                            "region_slug": "str",  # Optional. A human-readable string
                              that is used as a unique identifier for each region.
                            "resource_id": 0,  # Optional. A unique identifier for the
                              resource that the action is associated with.
                            "resource_type": "str",  # Optional. The type of resource
                              that the action is associated with.
                            "started_at": "2020-02-20 00:00:00",  # Optional. A time
                              value given in ISO8601 combined date and time format that represents when
                              the action was initiated.
                            "status": "in-progress",  # Optional. Default value is
                              "in-progress". The current status of the action. This can be
                              "in-progress", "completed", or "errored". Known values are:
                              "in-progress", "completed", and "errored".
                            "type": "str"  # Optional. This is the type of action that
                              the object represents. For example, this could be "transfer" to represent
                              the state of an image transfer action.
                        }
                    ],
                    "links": {
                        "pages": {}
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_actions_list_request(
            per_page=per_page,
            page=page,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ratelimit-limit"] = self._deserialize(
            "int", response.headers.get("ratelimit-limit")
        )
        response_headers["ratelimit-remaining"] = self._deserialize(
            "int", response.headers.get("ratelimit-remaining")
        )
        response_headers["ratelimit-reset"] = self._deserialize(
            "int", response.headers.get("ratelimit-reset")
        )

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get(self, action_id: int, **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Retrieve an Existing Action.

        To retrieve a specific action object, send a GET request to ``/v2/actions/$ACTION_ID``.

        :param action_id: A unique numeric ID that can be used to identify and reference an action.
         Required.
        :type action_id: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "action": {
                        "completed_at": "2020-02-20 00:00:00",  # Optional. A time value
                          given in ISO8601 combined date and time format that represents when the
                          action was completed.
                        "id": 0,  # Optional. A unique numeric ID that can be used to
                          identify and reference an action.
                        "region": {
                            "available": bool,  # This is a boolean value that represents
                              whether new Droplets can be created in this region. Required.
                            "features": {},  # This attribute is set to an array which
                              contains features available in this region. Required.
                            "name": "str",  # The display name of the region.  This will
                              be a full name that is used in the control panel and other interfaces.
                              Required.
                            "sizes": {},  # This attribute is set to an array which
                              contains the identifying slugs for the sizes available in this region.
                              Required.
                            "slug": "str"  # A human-readable string that is used as a
                              unique identifier for each region. Required.
                        },
                        "region_slug": "str",  # Optional. A human-readable string that is
                          used as a unique identifier for each region.
                        "resource_id": 0,  # Optional. A unique identifier for the resource
                          that the action is associated with.
                        "resource_type": "str",  # Optional. The type of resource that the
                          action is associated with.
                        "started_at": "2020-02-20 00:00:00",  # Optional. A time value given
                          in ISO8601 combined date and time format that represents when the action was
                          initiated.
                        "status": "in-progress",  # Optional. Default value is "in-progress".
                          The current status of the action. This can be "in-progress", "completed", or
                          "errored". Known values are: "in-progress", "completed", and "errored".
                        "type": "str"  # Optional. This is the type of action that the object
                          represents. For example, this could be "transfer" to represent the state of
                          an image transfer action.
                    }
                }
                # response body for status code(s): 404
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: cast(
                Type[HttpResponseError],
                lambda response: ClientAuthenticationError(response=response),
            ),
            429: HttpResponseError,
            500: HttpResponseError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_actions_get_request(
            action_id=action_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 404:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class AppsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`apps` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def list(
        self,
        *,
        page: int = 1,
        per_page: int = 20,
        with_projects: Optional[bool] = None,
        **kwargs: Any,
    ) -> JSON:
        # pylint: disable=line-too-long
        """List All Apps.

        List all apps on your account. Information about the current active deployment as well as any
        in progress ones will also be included for each app.

        :keyword page: Which 'page' of paginated results to return. Default value is 1.
        :paramtype page: int
        :keyword per_page: Number of items returned per page. Default value is 20.
        :paramtype per_page: int
        :keyword with_projects: Whether the project_id of listed apps should be fetched and included.
         Default value is None.
        :paramtype with_projects: bool
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "meta": {
                        "total": 0  # Optional. Number of objects returned by the request.
                    },
                    "apps": [
                        {
                            "spec": {
                                "name": "str",  # The name of the app. Must be unique
                                  across all apps in the same account. Required.
                                "databases": [
                                    {
                                        "name": "str",  # The database's
                                          name. The name must be unique across all components within
                                          the same app and cannot use capital letters. Required.
                                        "cluster_name": "str",  # Optional.
                                          The name of the underlying DigitalOcean DBaaS cluster. This
                                          is required for production databases. For dev databases, if
                                          cluster_name is not set, a new cluster will be provisioned.
                                        "db_name": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL database to configure.
                                        "db_user": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL user to configure.
                                        "engine": "UNSET",  # Optional.
                                          Default value is "UNSET". * MYSQL: MySQL * PG: PostgreSQL *
                                          REDIS: Redis * MONGODB: MongoDB * KAFKA: Kafka * OPENSEARCH:
                                          OpenSearch. Known values are: "UNSET", "MYSQL", "PG",
                                          "REDIS", "MONGODB", "KAFKA", and "OPENSEARCH".
                                        "production": bool,  # Optional.
                                          Whether this is a production or dev database.
                                        "version": "str"  # Optional. The
                                          version of the database engine.
                                    }
                                ],
                                "domains": [
                                    {
                                        "domain": "str",  # The hostname for
                                          the domain. Required.
                                        "minimum_tls_version": "str",  #
                                          Optional. The minimum version of TLS a client application can
                                          use to access resources for the domain.  Must be one of the
                                          following values wrapped within quotations: ``"1.2"`` or
                                          ``"1.3"``. Known values are: "1.2" and "1.3".
                                        "type": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * DEFAULT: The default
                                          ``.ondigitalocean.app`` domain assigned to this app *
                                          PRIMARY: The primary domain for this app that is displayed as
                                          the default in the control panel, used in bindable
                                          environment variables, and any other places that reference an
                                          app's live URL. Only one domain may be set as primary. *
                                          ALIAS: A non-primary domain. Known values are: "UNSPECIFIED",
                                          "DEFAULT", "PRIMARY", and "ALIAS".
                                        "wildcard": bool,  # Optional.
                                          Indicates whether the domain includes all sub-domains, in
                                          addition to the given domain.
                                        "zone": "str"  # Optional. Optional.
                                          If the domain uses DigitalOcean DNS and you would like App
                                          Platform to automatically manage it for you, set this to the
                                          name of the domain on your account.  For example, If the
                                          domain you are adding is ``app.domain.com``"" , the zone
                                          could be ``domain.com``.
                                    }
                                ],
                                "egress": {
                                    "type": "AUTOASSIGN"  # Optional. Default
                                      value is "AUTOASSIGN". The app egress type. Known values are:
                                      "AUTOASSIGN" and "DEDICATED_IP".
                                },
                                "functions": [
                                    {
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "alerts": [
                                            {
                                                "disabled": bool,  #
                                                  Optional. Is the alert disabled?.
                                                "operator":
                                                  "UNSPECIFIED_OPERATOR",  # Optional. Default value is
                                                  "UNSPECIFIED_OPERATOR". Known values are:
                                                  "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                  "LESS_THAN".
                                                "rule":
                                                  "UNSPECIFIED_RULE",  # Optional. Default value is
                                                  "UNSPECIFIED_RULE". Known values are:
                                                  "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                  "MEM_UTILIZATION", "RESTART_COUNT",
                                                  "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                  "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                  "FUNCTIONS_ACTIVATION_COUNT",
                                                  "FUNCTIONS_AVERAGE_DURATION_MS",
                                                  "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                  "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                  "FUNCTIONS_ERROR_COUNT", and
                                                  "FUNCTIONS_GB_RATE_PER_SECOND".
                                                "value": 0.0,  #
                                                  Optional. Threshold value for alert.
                                                "window":
                                                  "UNSPECIFIED_WINDOW"  # Optional. Default value is
                                                  "UNSPECIFIED_WINDOW". Known values are:
                                                  "UNSPECIFIED_WINDOW", "FIVE_MINUTES", "TEN_MINUTES",
                                                  "THIRTY_MINUTES", and "ONE_HOUR".
                                            }
                                        ],
                                        "bitbucket": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time * BUILD_TIME: Made available only at
                                                  build-time * RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable * SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "log_destinations": [
                                            {
                                                "name": "str",  #
                                                  Required.
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "open_search": {
                                                    "basic_auth":
                                                      {
                "password": {},  # Optional. Password for
                                                          user defined in User. Is required when
                                                          ``endpoint`` is set. Cannot be set if using a
                                                          DigitalOcean DBaaS OpenSearch cluster.
                "user": "str"  # Optional. Username to
                                                          authenticate with. Only required when
                                                          ``endpoint`` is set. Defaults to ``doadmin``
                                                          when ``cluster_name`` is set.
                                                    },
                "cluster_name": "str",  # Optional. The name of a
                                                      DigitalOcean DBaaS OpenSearch cluster to use as a
                                                      log forwarding destination. Cannot be specified
                                                      if ``endpoint`` is also specified.
                                                    "endpoint":
                                                      "str",  # Optional. OpenSearch API Endpoint. Only
                                                      HTTPS is supported. Format:
                                                      https://:code:`<host>`::code:`<port>`. Cannot be
                                                      specified if ``cluster_name`` is also specified.
                                                    "index_name":
                                                      "logs"  # Optional. Default value is "logs". The
                                                      index name to use for the logs. If not set, the
                                                      default index name is "logs".
                                                },
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            }
                                        ],
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. (Deprecated - Use Ingress Rules instead).
                                                  An HTTP path prefix. Paths must start with / and must
                                                  be unique across all components within an app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "ingress": {
                                    "rules": [
                                        {
                                            "component": {
                                                "name": "str",  # The
                                                  name of the component to route to. Required.
                "preserve_path_prefix": "str",  # Optional. An
                                                  optional flag to preserve the path that is forwarded
                                                  to the backend service. By default, the HTTP request
                                                  path will be trimmed from the left when forwarded to
                                                  the component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``. Note: this is not
                                                  applicable for Functions Components and is mutually
                                                  exclusive with ``rewrite``.
                                                "rewrite": "str"  #
                                                  Optional. An optional field that will rewrite the
                                                  path of the component to be what is specified here.
                                                  By default, the HTTP request path will be trimmed
                                                  from the left when forwarded to the component. For
                                                  example, a component with ``path=/api`` will have
                                                  requests to ``/api/list`` trimmed to ``/list``. If
                                                  you specified the rewrite to be ``/v1/``"" , requests
                                                  to ``/api/list`` would be rewritten to ``/v1/list``.
                                                  Note: this is mutually exclusive with
                                                  ``preserve_path_prefix``.
                                            },
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "match": {
                                                "path": {
                                                    "prefix":
                                                      "str"  # Prefix-based match. For example,
                                                      ``/api`` will match ``/api``"" , ``/api/``"" ,
                                                      and any nested paths such as
                                                      ``/api/v1/endpoint``. Required.
                                                }
                                            },
                                            "redirect": {
                                                "authority": "str",
                                                  # Optional. The authority/host to redirect to. This
                                                  can be a hostname or IP address. Note: use ``port``
                                                  to set the port.
                                                "port": 0,  #
                                                  Optional. The port to redirect to.
                                                "redirect_code": 0,
                                                  # Optional. The redirect code to use. Defaults to
                                                  ``302``. Supported values are 300, 301, 302, 303,
                                                  304, 307, 308.
                                                "scheme": "str",  #
                                                  Optional. The scheme to redirect to. Supported values
                                                  are ``http`` or ``https``. Default: ``https``.
                                                "uri": "str"  #
                                                  Optional. An optional URI path to redirect to. Note:
                                                  if this is specified the whole URI of the original
                                                  request will be overwritten to this value,
                                                  irrespective of the original request URI being
                                                  matched.
                                            }
                                        }
                                    ]
                                },
                                "jobs": [
                                    {
                                        "autoscaling": {
                                            "max_instance_count": 0,  #
                                              Optional. The maximum amount of instances for this
                                              component. Must be more than min_instance_count.
                                            "metrics": {
                                                "cpu": {
                                                    "percent": 80
                                                      # Optional. Default value is 80. The average
                                                      target CPU utilization for the component.
                                                }
                                            },
                                            "min_instance_count": 0  #
                                              Optional. The minimum amount of instances for this
                                              component. Must be less than max_instance_count.
                                        },
                                        "bitbucket": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://docs.digitalocean.com/products/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time * BUILD_TIME: Made available only at
                                                  build-time * RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable * SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "deploy_on_push": {
                                                "enabled": bool  #
                                                  Optional. Whether to automatically deploy new images.
                                                  Can only be used for images hosted in DOCR and can
                                                  only be used with an image tag, not a specific
                                                  digest.
                                            },
                                            "digest": "str",  # Optional.
                                              The image digest. Cannot be specified if tag is provided.
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_credentials":
                                              "str",  # Optional. The credentials to be able to pull
                                              the image. The value will be encrypted on first
                                              submission. On following submissions, the encrypted value
                                              should be used.   * "$username:$access_token" for
                                              registries of type ``DOCKER_HUB``. *
                                              "$username:$access_token" for registries of type
                                              ``GHCR``.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type. * DOCR: The DigitalOcean container registry type. *
                                              GHCR: The Github container registry type. Known values
                                              are: "DOCKER_HUB", "DOCR", and "GHCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided and no digest is provided.
                                              Cannot be specified if digest is provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1. Must not be set if
                                          autoscaling is used.
                                        "instance_size_slug": {},
                                        "kind": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * UNSPECIFIED: Default job
                                          type, will auto-complete to POST_DEPLOY kind. * PRE_DEPLOY:
                                          Indicates a job that runs before an app deployment. *
                                          POST_DEPLOY: Indicates a job that runs after an app
                                          deployment. * FAILED_DEPLOY: Indicates a job that runs after
                                          a component fails to deploy. Known values are: "UNSPECIFIED",
                                          "PRE_DEPLOY", "POST_DEPLOY", and "FAILED_DEPLOY".
                                        "log_destinations": [
                                            {
                                                "name": "str",  #
                                                  Required.
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "open_search": {
                                                    "basic_auth":
                                                      {
                "password": {},  # Optional. Password for
                                                          user defined in User. Is required when
                                                          ``endpoint`` is set. Cannot be set if using a
                                                          DigitalOcean DBaaS OpenSearch cluster.
                "user": "str"  # Optional. Username to
                                                          authenticate with. Only required when
                                                          ``endpoint`` is set. Defaults to ``doadmin``
                                                          when ``cluster_name`` is set.
                                                    },
                "cluster_name": "str",  # Optional. The name of a
                                                      DigitalOcean DBaaS OpenSearch cluster to use as a
                                                      log forwarding destination. Cannot be specified
                                                      if ``endpoint`` is also specified.
                                                    "endpoint":
                                                      "str",  # Optional. OpenSearch API Endpoint. Only
                                                      HTTPS is supported. Format:
                                                      https://:code:`<host>`::code:`<port>`. Cannot be
                                                      specified if ``cluster_name`` is also specified.
                                                    "index_name":
                                                      "logs"  # Optional. Default value is "logs". The
                                                      index name to use for the logs. If not set, the
                                                      default index name is "logs".
                                                },
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            }
                                        ],
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str",  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                        "termination": {
                                            "grace_period_seconds": 0  #
                                              Optional. The number of seconds to wait between sending a
                                              TERM signal to a container and issuing a KILL which
                                              causes immediate shutdown. (Default 120).
                                        }
                                    }
                                ],
                                "maintenance": {
                                    "archive": bool,  # Optional. Indicates
                                      whether the app should be archived. Setting this to true implies
                                      that enabled is set to true. Note that this feature is currently
                                      in closed beta.
                                    "enabled": bool,  # Optional. Indicates
                                      whether maintenance mode should be enabled for the app.
                                    "offline_page_url": "str"  # Optional. A
                                      custom offline page to display when maintenance mode is enabled
                                      or the app is archived.
                                },
                                "region": "str",  # Optional. The slug form of the
                                  geographical origin of the app. Default: ``nearest available``. Known
                                  values are: "ams", "nyc", "fra", "sfo", "sgp", "blr", "tor", "lon",
                                  and "syd".
                                "services": [
                                    {
                                        "autoscaling": {
                                            "max_instance_count": 0,  #
                                              Optional. The maximum amount of instances for this
                                              component. Must be more than min_instance_count.
                                            "metrics": {
                                                "cpu": {
                                                    "percent": 80
                                                      # Optional. Default value is 80. The average
                                                      target CPU utilization for the component.
                                                }
                                            },
                                            "min_instance_count": 0  #
                                              Optional. The minimum amount of instances for this
                                              component. Must be less than max_instance_count.
                                        },
                                        "bitbucket": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://docs.digitalocean.com/products/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time * BUILD_TIME: Made available only at
                                                  build-time * RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable * SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "health_check": {
                                            "failure_threshold": 0,  #
                                              Optional. The number of failed health checks before
                                              considered unhealthy.
                                            "http_path": "str",  #
                                              Optional. The route path used for the HTTP health check
                                              ping. If not set, the HTTP health check will be disabled
                                              and a TCP health check used instead.
                                            "initial_delay_seconds": 0,
                                              # Optional. The number of seconds to wait before
                                              beginning health checks.
                                            "period_seconds": 0,  #
                                              Optional. The number of seconds to wait between health
                                              checks.
                                            "port": 0,  # Optional. The
                                              port on which the health check will be performed. If not
                                              set, the health check will be performed on the
                                              component's http_port.
                                            "success_threshold": 0,  #
                                              Optional. The number of successful health checks before
                                              considered healthy.
                                            "timeout_seconds": 0  #
                                              Optional. The number of seconds after which the check
                                              times out.
                                        },
                                        "http_port": 0,  # Optional. The
                                          internal port on which this service's run command will
                                          listen. Default: 8080 If there is not an environment variable
                                          with the name ``PORT``"" , one will be automatically added
                                          with its value set to the value of this field.
                                        "image": {
                                            "deploy_on_push": {
                                                "enabled": bool  #
                                                  Optional. Whether to automatically deploy new images.
                                                  Can only be used for images hosted in DOCR and can
                                                  only be used with an image tag, not a specific
                                                  digest.
                                            },
                                            "digest": "str",  # Optional.
                                              The image digest. Cannot be specified if tag is provided.
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_credentials":
                                              "str",  # Optional. The credentials to be able to pull
                                              the image. The value will be encrypted on first
                                              submission. On following submissions, the encrypted value
                                              should be used.   * "$username:$access_token" for
                                              registries of type ``DOCKER_HUB``. *
                                              "$username:$access_token" for registries of type
                                              ``GHCR``.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type. * DOCR: The DigitalOcean container registry type. *
                                              GHCR: The Github container registry type. Known values
                                              are: "DOCKER_HUB", "DOCR", and "GHCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided and no digest is provided.
                                              Cannot be specified if digest is provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1. Must not be set if
                                          autoscaling is used.
                                        "instance_size_slug": {},
                                        "internal_ports": [
                                            0  # Optional. The ports on
                                              which this service will listen for internal traffic.
                                        ],
                                        "log_destinations": [
                                            {
                                                "name": "str",  #
                                                  Required.
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "open_search": {
                                                    "basic_auth":
                                                      {
                "password": {},  # Optional. Password for
                                                          user defined in User. Is required when
                                                          ``endpoint`` is set. Cannot be set if using a
                                                          DigitalOcean DBaaS OpenSearch cluster.
                "user": "str"  # Optional. Username to
                                                          authenticate with. Only required when
                                                          ``endpoint`` is set. Defaults to ``doadmin``
                                                          when ``cluster_name`` is set.
                                                    },
                "cluster_name": "str",  # Optional. The name of a
                                                      DigitalOcean DBaaS OpenSearch cluster to use as a
                                                      log forwarding destination. Cannot be specified
                                                      if ``endpoint`` is also specified.
                                                    "endpoint":
                                                      "str",  # Optional. OpenSearch API Endpoint. Only
                                                      HTTPS is supported. Format:
                                                      https://:code:`<host>`::code:`<port>`. Cannot be
                                                      specified if ``cluster_name`` is also specified.
                                                    "index_name":
                                                      "logs"  # Optional. Default value is "logs". The
                                                      index name to use for the logs. If not set, the
                                                      default index name is "logs".
                                                },
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            }
                                        ],
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "protocol": "str",  # Optional. The
                                          protocol which the service uses to serve traffic on the
                                          http_port.   * ``HTTP``"" : The app is serving the HTTP
                                          protocol. Default. * ``HTTP2``"" : The app is serving the
                                          HTTP/2 protocol. Currently, this needs to be implemented in
                                          the service by serving HTTP/2 cleartext (h2c). Known values
                                          are: "HTTP" and "HTTP2".
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. (Deprecated - Use Ingress Rules instead).
                                                  An HTTP path prefix. Paths must start with / and must
                                                  be unique across all components within an app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str",  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                        "termination": {
                                            "drain_seconds": 0,  #
                                              Optional. The number of seconds to wait between selecting
                                              a container instance for termination and issuing the TERM
                                              signal. Selecting a container instance for termination
                                              begins an asynchronous drain of new requests on upstream
                                              load-balancers. (Default 15).
                                            "grace_period_seconds": 0  #
                                              Optional. The number of seconds to wait between sending a
                                              TERM signal to a container and issuing a KILL which
                                              causes immediate shutdown. (Default 120).
                                        }
                                    }
                                ],
                                "static_sites": [
                                    {
                                        "bitbucket": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "catchall_document": "str",  #
                                          Optional. The name of the document to use as the fallback for
                                          any requests to documents that are not found when serving
                                          this static site. Only 1 of ``catchall_document`` or
                                          ``error_document`` can be set.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://docs.digitalocean.com/products/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time * BUILD_TIME: Made available only at
                                                  build-time * RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable * SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "error_document": "404.html",  #
                                          Optional. Default value is "404.html". The name of the error
                                          document to use when serving this static site. Default:
                                          404.html. If no such file exists within the built assets, App
                                          Platform will supply one.
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "deploy_on_push": {
                                                "enabled": bool  #
                                                  Optional. Whether to automatically deploy new images.
                                                  Can only be used for images hosted in DOCR and can
                                                  only be used with an image tag, not a specific
                                                  digest.
                                            },
                                            "digest": "str",  # Optional.
                                              The image digest. Cannot be specified if tag is provided.
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_credentials":
                                              "str",  # Optional. The credentials to be able to pull
                                              the image. The value will be encrypted on first
                                              submission. On following submissions, the encrypted value
                                              should be used.   * "$username:$access_token" for
                                              registries of type ``DOCKER_HUB``. *
                                              "$username:$access_token" for registries of type
                                              ``GHCR``.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type. * DOCR: The DigitalOcean container registry type. *
                                              GHCR: The Github container registry type. Known values
                                              are: "DOCKER_HUB", "DOCR", and "GHCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided and no digest is provided.
                                              Cannot be specified if digest is provided.
                                        },
                                        "index_document": "index.html",  #
                                          Optional. Default value is "index.html". The name of the
                                          index document to use when serving this static site. Default:
                                          index.html.
                                        "log_destinations": [
                                            {
                                                "name": "str",  #
                                                  Required.
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "open_search": {
                                                    "basic_auth":
                                                      {
                "password": {},  # Optional. Password for
                                                          user defined in User. Is required when
                                                          ``endpoint`` is set. Cannot be set if using a
                                                          DigitalOcean DBaaS OpenSearch cluster.
                "user": "str"  # Optional. Username to
                                                          authenticate with. Only required when
                                                          ``endpoint`` is set. Defaults to ``doadmin``
                                                          when ``cluster_name`` is set.
                                                    },
                "cluster_name": "str",  # Optional. The name of a
                                                      DigitalOcean DBaaS OpenSearch cluster to use as a
                                                      log forwarding destination. Cannot be specified
                                                      if ``endpoint`` is also specified.
                                                    "endpoint":
                                                      "str",  # Optional. OpenSearch API Endpoint. Only
                                                      HTTPS is supported. Format:
                                                      https://:code:`<host>`::code:`<port>`. Cannot be
                                                      specified if ``cluster_name`` is also specified.
                                                    "index_name":
                                                      "logs"  # Optional. Default value is "logs". The
                                                      index name to use for the logs. If not set, the
                                                      default index name is "logs".
                                                },
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            }
                                        ],
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "output_dir": "str",  # Optional. An
                                          optional path to where the built assets will be located,
                                          relative to the build context. If not set, App Platform will
                                          automatically scan for these directory names: ``_static``"" ,
                                          ``dist``"" , ``public``"" , ``build``.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. (Deprecated - Use Ingress Rules instead).
                                                  An HTTP path prefix. Paths must start with / and must
                                                  be unique across all components within an app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "workers": [
                                    {
                                        "autoscaling": {
                                            "max_instance_count": 0,  #
                                              Optional. The maximum amount of instances for this
                                              component. Must be more than min_instance_count.
                                            "metrics": {
                                                "cpu": {
                                                    "percent": 80
                                                      # Optional. Default value is 80. The average
                                                      target CPU utilization for the component.
                                                }
                                            },
                                            "min_instance_count": 0  #
                                              Optional. The minimum amount of instances for this
                                              component. Must be less than max_instance_count.
                                        },
                                        "bitbucket": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://docs.digitalocean.com/products/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time * BUILD_TIME: Made available only at
                                                  build-time * RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable * SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "deploy_on_push": {
                                                "enabled": bool  #
                                                  Optional. Whether to automatically deploy new images.
                                                  Can only be used for images hosted in DOCR and can
                                                  only be used with an image tag, not a specific
                                                  digest.
                                            },
                                            "digest": "str",  # Optional.
                                              The image digest. Cannot be specified if tag is provided.
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_credentials":
                                              "str",  # Optional. The credentials to be able to pull
                                              the image. The value will be encrypted on first
                                              submission. On following submissions, the encrypted value
                                              should be used.   * "$username:$access_token" for
                                              registries of type ``DOCKER_HUB``. *
                                              "$username:$access_token" for registries of type
                                              ``GHCR``.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type. * DOCR: The DigitalOcean container registry type. *
                                              GHCR: The Github container registry type. Known values
                                              are: "DOCKER_HUB", "DOCR", and "GHCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided and no digest is provided.
                                              Cannot be specified if digest is provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1. Must not be set if
                                          autoscaling is used.
                                        "instance_size_slug": {},
                                        "log_destinations": [
                                            {
                                                "name": "str",  #
                                                  Required.
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "open_search": {
                                                    "basic_auth":
                                                      {
                "password": {},  # Optional. Password for
                                                          user defined in User. Is required when
                                                          ``endpoint`` is set. Cannot be set if using a
                                                          DigitalOcean DBaaS OpenSearch cluster.
                "user": "str"  # Optional. Username to
                                                          authenticate with. Only required when
                                                          ``endpoint`` is set. Defaults to ``doadmin``
                                                          when ``cluster_name`` is set.
                                                    },
                "cluster_name": "str",  # Optional. The name of a
                                                      DigitalOcean DBaaS OpenSearch cluster to use as a
                                                      log forwarding destination. Cannot be specified
                                                      if ``endpoint`` is also specified.
                                                    "endpoint":
                                                      "str",  # Optional. OpenSearch API Endpoint. Only
                                                      HTTPS is supported. Format:
                                                      https://:code:`<host>`::code:`<port>`. Cannot be
                                                      specified if ``cluster_name`` is also specified.
                                                    "index_name":
                                                      "logs"  # Optional. Default value is "logs". The
                                                      index name to use for the logs. If not set, the
                                                      default index name is "logs".
                                                },
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            }
                                        ],
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str",  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                        "termination": {
                                            "grace_period_seconds": 0  #
                                              Optional. The number of seconds to wait between sending a
                                              TERM signal to a container and issuing a KILL which
                                              causes immediate shutdown. (Default 120).
                                        }
                                    }
                                ]
                            },
                            "active_deployment": {
                                "cause": "str",  # Optional. What caused this
                                  deployment to be created.
                                "cloned_from": "str",  # Optional. The ID of a
                                  previous deployment that this deployment was cloned from.
                                "created_at": "2020-02-20 00:00:00",  # Optional. The
                                  creation time of the deployment.
                                "functions": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this functions component.
                                        "namespace": "str",  # Optional. The
                                          namespace where the functions are deployed.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this functions component.
                                    }
                                ],
                                "id": "str",  # Optional. The ID of the deployment.
                                "jobs": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this job.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this job.
                                    }
                                ],
                                "phase": "UNKNOWN",  # Optional. Default value is
                                  "UNKNOWN". Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                                  "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                                  "CANCELED".
                                "phase_last_updated_at": "2020-02-20 00:00:00",  #
                                  Optional. When the deployment phase was last updated.
                                "progress": {
                                    "error_steps": 0,  # Optional. Number of
                                      unsuccessful steps.
                                    "pending_steps": 0,  # Optional. Number of
                                      pending steps.
                                    "running_steps": 0,  # Optional. Number of
                                      currently running steps.
                                    "steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:  ``message_base`` = "Building
                                              service" ``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "success_steps": 0,  # Optional. Number of
                                      successful steps.
                                    "summary_steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:  ``message_base`` = "Building
                                              service" ``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "total_steps": 0  # Optional. Total number of
                                      steps.
                                },
                                "services": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this service.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this service.
                                    }
                                ],
                                "spec": {
                                    "name": "str",  # The name of the app. Must
                                      be unique across all apps in the same account. Required.
                                    "databases": [
                                        {
                                            "name": "str",  # The
                                              database's name. The name must be unique across all
                                              components within the same app and cannot use capital
                                              letters. Required.
                                            "cluster_name": "str",  #
                                              Optional. The name of the underlying DigitalOcean DBaaS
                                              cluster. This is required for production databases. For
                                              dev databases, if cluster_name is not set, a new cluster
                                              will be provisioned.
                                            "db_name": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL database to
                                              configure.
                                            "db_user": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL user to
                                              configure.
                                            "engine": "UNSET",  #
                                              Optional. Default value is "UNSET". * MYSQL: MySQL * PG:
                                              PostgreSQL * REDIS: Redis * MONGODB: MongoDB * KAFKA:
                                              Kafka * OPENSEARCH: OpenSearch. Known values are:
                                              "UNSET", "MYSQL", "PG", "REDIS", "MONGODB", "KAFKA", and
                                              "OPENSEARCH".
                                            "production": bool,  #
                                              Optional. Whether this is a production or dev database.
                                            "version": "str"  # Optional.
                                              The version of the database engine.
                                        }
                                    ],
                                    "domains": [
                                        {
                                            "domain": "str",  # The
                                              hostname for the domain. Required.
                                            "minimum_tls_version": "str",
                                              # Optional. The minimum version of TLS a client
                                              application can use to access resources for the domain.
                                              Must be one of the following values wrapped within
                                              quotations: ``"1.2"`` or ``"1.3"``. Known values are:
                                              "1.2" and "1.3".
                                            "type": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * DEFAULT: The
                                              default ``.ondigitalocean.app`` domain assigned to this
                                              app * PRIMARY: The primary domain for this app that is
                                              displayed as the default in the control panel, used in
                                              bindable environment variables, and any other places that
                                              reference an app's live URL. Only one domain may be set
                                              as primary. * ALIAS: A non-primary domain. Known values
                                              are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and "ALIAS".
                                            "wildcard": bool,  #
                                              Optional. Indicates whether the domain includes all
                                              sub-domains, in addition to the given domain.
                                            "zone": "str"  # Optional.
                                              Optional. If the domain uses DigitalOcean DNS and you
                                              would like App Platform to automatically manage it for
                                              you, set this to the name of the domain on your account.
                                              For example, If the domain you are adding is
                                              ``app.domain.com``"" , the zone could be ``domain.com``.
                                        }
                                    ],
                                    "egress": {
                                        "type": "AUTOASSIGN"  # Optional.
                                          Default value is "AUTOASSIGN". The app egress type. Known
                                          values are: "AUTOASSIGN" and "DEDICATED_IP".
                                    },
                                    "functions": [
                                        {
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "alerts": [
                                                {
                                                    "disabled":
                                                      bool,  # Optional. Is the alert disabled?.
                                                    "operator":
                                                      "UNSPECIFIED_OPERATOR",  # Optional. Default
                                                      value is "UNSPECIFIED_OPERATOR". Known values
                                                      are: "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                      "LESS_THAN".
                                                    "rule":
                                                      "UNSPECIFIED_RULE",  # Optional. Default value is
                                                      "UNSPECIFIED_RULE". Known values are:
                                                      "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                      "MEM_UTILIZATION", "RESTART_COUNT",
                                                      "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                      "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                      "FUNCTIONS_ACTIVATION_COUNT",
                                                      "FUNCTIONS_AVERAGE_DURATION_MS",
                                                      "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                      "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                      "FUNCTIONS_ERROR_COUNT", and
                                                      "FUNCTIONS_GB_RATE_PER_SECOND".
                                                    "value": 0.0,
                                                      # Optional. Threshold value for alert.
                                                    "window":
                                                      "UNSPECIFIED_WINDOW"  # Optional. Default value
                                                      is "UNSPECIFIED_WINDOW". Known values are:
                                                      "UNSPECIFIED_WINDOW", "FIVE_MINUTES",
                                                      "TEN_MINUTES", "THIRTY_MINUTES", and "ONE_HOUR".
                                                }
                                            ],
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "ingress": {
                                        "rules": [
                                            {
                                                "component": {
                                                    "name":
                                                      "str",  # The name of the component to route to.
                                                      Required.
                "preserve_path_prefix": "str",  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``. Note: this is not applicable for
                                                      Functions Components and is mutually exclusive
                                                      with ``rewrite``.
                                                    "rewrite":
                                                      "str"  # Optional. An optional field that will
                                                      rewrite the path of the component to be what is
                                                      specified here. By default, the HTTP request path
                                                      will be trimmed from the left when forwarded to
                                                      the component. For example, a component with
                                                      ``path=/api`` will have requests to ``/api/list``
                                                      trimmed to ``/list``. If you specified the
                                                      rewrite to be ``/v1/``"" , requests to
                                                      ``/api/list`` would be rewritten to ``/v1/list``.
                                                      Note: this is mutually exclusive with
                                                      ``preserve_path_prefix``.
                                                },
                                                "cors": {
                "allow_credentials": bool,  # Optional. Whether
                                                      browsers should expose the response to the
                                                      client-side JavaScript code when the
                                                      request"u2019s credentials mode is include. This
                                                      configures the
                                                      ``Access-Control-Allow-Credentials`` header.
                "allow_headers": [
                                                        "str"
                                                          # Optional. The set of allowed HTTP request
                                                          headers. This configures the
                                                          ``Access-Control-Allow-Headers`` header.
                                                    ],
                "allow_methods": [
                                                        "str"
                                                          # Optional. The set of allowed HTTP methods.
                                                          This configures the
                                                          ``Access-Control-Allow-Methods`` header.
                                                    ],
                "allow_origins": [
                                                        {
                "exact": "str",  # Optional. Exact string
                                                              match. Only 1 of ``exact``"" ,
                                                              ``prefix``"" , or ``regex`` must be set.
                "prefix": "str",  # Optional.
                                                              Prefix-based match. Only 1 of ``exact``""
                                                              , ``prefix``"" , or ``regex`` must be
                                                              set.
                "regex": "str"  # Optional. RE2 style
                                                              regex-based match. Only 1 of ``exact``""
                                                              , ``prefix``"" , or ``regex`` must be
                                                              set. For more information about RE2
                                                              syntax, see:
                                                              https://github.com/google/re2/wiki/Syntax.
                                                        }
                                                    ],
                "expose_headers": [
                                                        "str"
                                                          # Optional. The set of HTTP response headers
                                                          that browsers are allowed to access. This
                                                          configures the
                                                          ``Access-Control-Expose-Headers`` header.
                                                    ],
                                                    "max_age":
                                                      "str"  # Optional. An optional duration
                                                      specifying how long browsers can cache the
                                                      results of a preflight request. This configures
                                                      the ``Access-Control-Max-Age`` header.
                                                },
                                                "match": {
                                                    "path": {
                "prefix": "str"  # Prefix-based match. For
                                                          example, ``/api`` will match ``/api``"" ,
                                                          ``/api/``"" , and any nested paths such as
                                                          ``/api/v1/endpoint``. Required.
                                                    }
                                                },
                                                "redirect": {
                                                    "authority":
                                                      "str",  # Optional. The authority/host to
                                                      redirect to. This can be a hostname or IP
                                                      address. Note: use ``port`` to set the port.
                                                    "port": 0,  #
                                                      Optional. The port to redirect to.
                "redirect_code": 0,  # Optional. The redirect
                                                      code to use. Defaults to ``302``. Supported
                                                      values are 300, 301, 302, 303, 304, 307, 308.
                                                    "scheme":
                                                      "str",  # Optional. The scheme to redirect to.
                                                      Supported values are ``http`` or ``https``.
                                                      Default: ``https``.
                                                    "uri": "str"
                                                      # Optional. An optional URI path to redirect to.
                                                      Note: if this is specified the whole URI of the
                                                      original request will be overwritten to this
                                                      value, irrespective of the original request URI
                                                      being matched.
                                                }
                                            }
                                        ]
                                    },
                                    "jobs": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "kind": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * UNSPECIFIED:
                                              Default job type, will auto-complete to POST_DEPLOY kind.
                                              * PRE_DEPLOY: Indicates a job that runs before an app
                                              deployment. * POST_DEPLOY: Indicates a job that runs
                                              after an app deployment. * FAILED_DEPLOY: Indicates a job
                                              that runs after a component fails to deploy. Known values
                                              are: "UNSPECIFIED", "PRE_DEPLOY", "POST_DEPLOY", and
                                              "FAILED_DEPLOY".
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ],
                                    "maintenance": {
                                        "archive": bool,  # Optional.
                                          Indicates whether the app should be archived. Setting this to
                                          true implies that enabled is set to true. Note that this
                                          feature is currently in closed beta.
                                        "enabled": bool,  # Optional.
                                          Indicates whether maintenance mode should be enabled for the
                                          app.
                                        "offline_page_url": "str"  #
                                          Optional. A custom offline page to display when maintenance
                                          mode is enabled or the app is archived.
                                    },
                                    "region": "str",  # Optional. The slug form
                                      of the geographical origin of the app. Default: ``nearest
                                      available``. Known values are: "ams", "nyc", "fra", "sfo", "sgp",
                                      "blr", "tor", "lon", and "syd".
                                    "services": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "health_check": {
                                                "failure_threshold":
                                                  0,  # Optional. The number of failed health checks
                                                  before considered unhealthy.
                                                "http_path": "str",
                                                  # Optional. The route path used for the HTTP health
                                                  check ping. If not set, the HTTP health check will be
                                                  disabled and a TCP health check used instead.
                "initial_delay_seconds": 0,  # Optional. The number
                                                  of seconds to wait before beginning health checks.
                                                "period_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  health checks.
                                                "port": 0,  #
                                                  Optional. The port on which the health check will be
                                                  performed. If not set, the health check will be
                                                  performed on the component's http_port.
                                                "success_threshold":
                                                  0,  # Optional. The number of successful health
                                                  checks before considered healthy.
                                                "timeout_seconds": 0
                                                  # Optional. The number of seconds after which the
                                                  check times out.
                                            },
                                            "http_port": 0,  # Optional.
                                              The internal port on which this service's run command
                                              will listen. Default: 8080 If there is not an environment
                                              variable with the name ``PORT``"" , one will be
                                              automatically added with its value set to the value of
                                              this field.
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "internal_ports": [
                                                0  # Optional. The
                                                  ports on which this service will listen for internal
                                                  traffic.
                                            ],
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "protocol": "str",  #
                                              Optional. The protocol which the service uses to serve
                                              traffic on the http_port.   * ``HTTP``"" : The app is
                                              serving the HTTP protocol. Default. * ``HTTP2``"" : The
                                              app is serving the HTTP/2 protocol. Currently, this needs
                                              to be implemented in the service by serving HTTP/2
                                              cleartext (h2c). Known values are: "HTTP" and "HTTP2".
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                                                "drain_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  selecting a container instance for termination and
                                                  issuing the TERM signal. Selecting a container
                                                  instance for termination begins an asynchronous drain
                                                  of new requests on upstream load-balancers. (Default
                                                  15).
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ],
                                    "static_sites": [
                                        {
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "catchall_document": "str",
                                              # Optional. The name of the document to use as the
                                              fallback for any requests to documents that are not found
                                              when serving this static site. Only 1 of
                                              ``catchall_document`` or ``error_document`` can be set.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "error_document": "404.html",
                                              # Optional. Default value is "404.html". The name of the
                                              error document to use when serving this static site.
                                              Default: 404.html. If no such file exists within the
                                              built assets, App Platform will supply one.
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "index_document":
                                              "index.html",  # Optional. Default value is "index.html".
                                              The name of the index document to use when serving this
                                              static site. Default: index.html.
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "output_dir": "str",  #
                                              Optional. An optional path to where the built assets will
                                              be located, relative to the build context. If not set,
                                              App Platform will automatically scan for these directory
                                              names: ``_static``"" , ``dist``"" , ``public``"" ,
                                              ``build``.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "workers": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ]
                                },
                                "static_sites": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this static site.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this static site.
                                    }
                                ],
                                "tier_slug": "str",  # Optional. The current pricing
                                  tier slug of the deployment.
                                "updated_at": "2020-02-20 00:00:00",  # Optional.
                                  When the deployment was last updated.
                                "workers": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this worker.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this worker.
                                    }
                                ]
                            },
                            "created_at": "2020-02-20 00:00:00",  # Optional. The
                              creation time of the app.
                            "dedicated_ips": [
                                {
                                    "id": "str",  # Optional. The ID of the
                                      dedicated egress IP.
                                    "ip": "str",  # Optional. The IP address of
                                      the dedicated egress IP.
                                    "status": "UNKNOWN"  # Optional. Default
                                      value is "UNKNOWN". The status of the dedicated egress IP. Known
                                      values are: "UNKNOWN", "ASSIGNING", "ASSIGNED", and "REMOVED".
                                }
                            ],
                            "default_ingress": "str",  # Optional. The default hostname
                              on which the app is accessible.
                            "domains": [
                                {
                                    "certificate_expires_at": "2020-02-20
                                      00:00:00",  # Optional. Current SSL certificate expiration time.
                                    "id": "str",  # Optional. The ID of the
                                      domain.
                                    "phase": "UNKNOWN",  # Optional. Default
                                      value is "UNKNOWN". Known values are: "UNKNOWN", "PENDING",
                                      "CONFIGURING", "ACTIVE", and "ERROR".
                                    "progress": {
                                        "steps": [
                                            {}  # Optional. The steps of
                                              the domain's progress.
                                        ]
                                    },
                                    "rotate_validation_records": bool,  #
                                      Optional. Validation values have changed and require manual
                                      intervention.
                                    "spec": {
                                        "domain": "str",  # The hostname for
                                          the domain. Required.
                                        "minimum_tls_version": "str",  #
                                          Optional. The minimum version of TLS a client application can
                                          use to access resources for the domain.  Must be one of the
                                          following values wrapped within quotations: ``"1.2"`` or
                                          ``"1.3"``. Known values are: "1.2" and "1.3".
                                        "type": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * DEFAULT: The default
                                          ``.ondigitalocean.app`` domain assigned to this app *
                                          PRIMARY: The primary domain for this app that is displayed as
                                          the default in the control panel, used in bindable
                                          environment variables, and any other places that reference an
                                          app's live URL. Only one domain may be set as primary. *
                                          ALIAS: A non-primary domain. Known values are: "UNSPECIFIED",
                                          "DEFAULT", "PRIMARY", and "ALIAS".
                                        "wildcard": bool,  # Optional.
                                          Indicates whether the domain includes all sub-domains, in
                                          addition to the given domain.
                                        "zone": "str"  # Optional. Optional.
                                          If the domain uses DigitalOcean DNS and you would like App
                                          Platform to automatically manage it for you, set this to the
                                          name of the domain on your account.  For example, If the
                                          domain you are adding is ``app.domain.com``"" , the zone
                                          could be ``domain.com``.
                                    },
                                    "validations": [
                                        {
                                            "txt_name": "str",  #
                                              Optional. TXT record name.
                                            "txt_value": "str"  #
                                              Optional. TXT record value.
                                        }
                                    ]
                                }
                            ],
                            "id": "str",  # Optional. The ID of the application.
                            "in_progress_deployment": {
                                "cause": "str",  # Optional. What caused this
                                  deployment to be created.
                                "cloned_from": "str",  # Optional. The ID of a
                                  previous deployment that this deployment was cloned from.
                                "created_at": "2020-02-20 00:00:00",  # Optional. The
                                  creation time of the deployment.
                                "functions": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this functions component.
                                        "namespace": "str",  # Optional. The
                                          namespace where the functions are deployed.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this functions component.
                                    }
                                ],
                                "id": "str",  # Optional. The ID of the deployment.
                                "jobs": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this job.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this job.
                                    }
                                ],
                                "phase": "UNKNOWN",  # Optional. Default value is
                                  "UNKNOWN". Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                                  "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                                  "CANCELED".
                                "phase_last_updated_at": "2020-02-20 00:00:00",  #
                                  Optional. When the deployment phase was last updated.
                                "progress": {
                                    "error_steps": 0,  # Optional. Number of
                                      unsuccessful steps.
                                    "pending_steps": 0,  # Optional. Number of
                                      pending steps.
                                    "running_steps": 0,  # Optional. Number of
                                      currently running steps.
                                    "steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:  ``message_base`` = "Building
                                              service" ``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "success_steps": 0,  # Optional. Number of
                                      successful steps.
                                    "summary_steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:  ``message_base`` = "Building
                                              service" ``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "total_steps": 0  # Optional. Total number of
                                      steps.
                                },
                                "services": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this service.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this service.
                                    }
                                ],
                                "spec": {
                                    "name": "str",  # The name of the app. Must
                                      be unique across all apps in the same account. Required.
                                    "databases": [
                                        {
                                            "name": "str",  # The
                                              database's name. The name must be unique across all
                                              components within the same app and cannot use capital
                                              letters. Required.
                                            "cluster_name": "str",  #
                                              Optional. The name of the underlying DigitalOcean DBaaS
                                              cluster. This is required for production databases. For
                                              dev databases, if cluster_name is not set, a new cluster
                                              will be provisioned.
                                            "db_name": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL database to
                                              configure.
                                            "db_user": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL user to
                                              configure.
                                            "engine": "UNSET",  #
                                              Optional. Default value is "UNSET". * MYSQL: MySQL * PG:
                                              PostgreSQL * REDIS: Redis * MONGODB: MongoDB * KAFKA:
                                              Kafka * OPENSEARCH: OpenSearch. Known values are:
                                              "UNSET", "MYSQL", "PG", "REDIS", "MONGODB", "KAFKA", and
                                              "OPENSEARCH".
                                            "production": bool,  #
                                              Optional. Whether this is a production or dev database.
                                            "version": "str"  # Optional.
                                              The version of the database engine.
                                        }
                                    ],
                                    "domains": [
                                        {
                                            "domain": "str",  # The
                                              hostname for the domain. Required.
                                            "minimum_tls_version": "str",
                                              # Optional. The minimum version of TLS a client
                                              application can use to access resources for the domain.
                                              Must be one of the following values wrapped within
                                              quotations: ``"1.2"`` or ``"1.3"``. Known values are:
                                              "1.2" and "1.3".
                                            "type": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * DEFAULT: The
                                              default ``.ondigitalocean.app`` domain assigned to this
                                              app * PRIMARY: The primary domain for this app that is
                                              displayed as the default in the control panel, used in
                                              bindable environment variables, and any other places that
                                              reference an app's live URL. Only one domain may be set
                                              as primary. * ALIAS: A non-primary domain. Known values
                                              are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and "ALIAS".
                                            "wildcard": bool,  #
                                              Optional. Indicates whether the domain includes all
                                              sub-domains, in addition to the given domain.
                                            "zone": "str"  # Optional.
                                              Optional. If the domain uses DigitalOcean DNS and you
                                              would like App Platform to automatically manage it for
                                              you, set this to the name of the domain on your account.
                                              For example, If the domain you are adding is
                                              ``app.domain.com``"" , the zone could be ``domain.com``.
                                        }
                                    ],
                                    "egress": {
                                        "type": "AUTOASSIGN"  # Optional.
                                          Default value is "AUTOASSIGN". The app egress type. Known
                                          values are: "AUTOASSIGN" and "DEDICATED_IP".
                                    },
                                    "functions": [
                                        {
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "alerts": [
                                                {
                                                    "disabled":
                                                      bool,  # Optional. Is the alert disabled?.
                                                    "operator":
                                                      "UNSPECIFIED_OPERATOR",  # Optional. Default
                                                      value is "UNSPECIFIED_OPERATOR". Known values
                                                      are: "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                      "LESS_THAN".
                                                    "rule":
                                                      "UNSPECIFIED_RULE",  # Optional. Default value is
                                                      "UNSPECIFIED_RULE". Known values are:
                                                      "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                      "MEM_UTILIZATION", "RESTART_COUNT",
                                                      "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                      "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                      "FUNCTIONS_ACTIVATION_COUNT",
                                                      "FUNCTIONS_AVERAGE_DURATION_MS",
                                                      "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                      "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                      "FUNCTIONS_ERROR_COUNT", and
                                                      "FUNCTIONS_GB_RATE_PER_SECOND".
                                                    "value": 0.0,
                                                      # Optional. Threshold value for alert.
                                                    "window":
                                                      "UNSPECIFIED_WINDOW"  # Optional. Default value
                                                      is "UNSPECIFIED_WINDOW". Known values are:
                                                      "UNSPECIFIED_WINDOW", "FIVE_MINUTES",
                                                      "TEN_MINUTES", "THIRTY_MINUTES", and "ONE_HOUR".
                                                }
                                            ],
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "ingress": {
                                        "rules": [
                                            {
                                                "component": {
                                                    "name":
                                                      "str",  # The name of the component to route to.
                                                      Required.
                "preserve_path_prefix": "str",  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``. Note: this is not applicable for
                                                      Functions Components and is mutually exclusive
                                                      with ``rewrite``.
                                                    "rewrite":
                                                      "str"  # Optional. An optional field that will
                                                      rewrite the path of the component to be what is
                                                      specified here. By default, the HTTP request path
                                                      will be trimmed from the left when forwarded to
                                                      the component. For example, a component with
                                                      ``path=/api`` will have requests to ``/api/list``
                                                      trimmed to ``/list``. If you specified the
                                                      rewrite to be ``/v1/``"" , requests to
                                                      ``/api/list`` would be rewritten to ``/v1/list``.
                                                      Note: this is mutually exclusive with
                                                      ``preserve_path_prefix``.
                                                },
                                                "cors": {
                "allow_credentials": bool,  # Optional. Whether
                                                      browsers should expose the response to the
                                                      client-side JavaScript code when the
                                                      request"u2019s credentials mode is include. This
                                                      configures the
                                                      ``Access-Control-Allow-Credentials`` header.
                "allow_headers": [
                                                        "str"
                                                          # Optional. The set of allowed HTTP request
                                                          headers. This configures the
                                                          ``Access-Control-Allow-Headers`` header.
                                                    ],
                "allow_methods": [
                                                        "str"
                                                          # Optional. The set of allowed HTTP methods.
                                                          This configures the
                                                          ``Access-Control-Allow-Methods`` header.
                                                    ],
                "allow_origins": [
                                                        {
                "exact": "str",  # Optional. Exact string
                                                              match. Only 1 of ``exact``"" ,
                                                              ``prefix``"" , or ``regex`` must be set.
                "prefix": "str",  # Optional.
                                                              Prefix-based match. Only 1 of ``exact``""
                                                              , ``prefix``"" , or ``regex`` must be
                                                              set.
                "regex": "str"  # Optional. RE2 style
                                                              regex-based match. Only 1 of ``exact``""
                                                              , ``prefix``"" , or ``regex`` must be
                                                              set. For more information about RE2
                                                              syntax, see:
                                                              https://github.com/google/re2/wiki/Syntax.
                                                        }
                                                    ],
                "expose_headers": [
                                                        "str"
                                                          # Optional. The set of HTTP response headers
                                                          that browsers are allowed to access. This
                                                          configures the
                                                          ``Access-Control-Expose-Headers`` header.
                                                    ],
                                                    "max_age":
                                                      "str"  # Optional. An optional duration
                                                      specifying how long browsers can cache the
                                                      results of a preflight request. This configures
                                                      the ``Access-Control-Max-Age`` header.
                                                },
                                                "match": {
                                                    "path": {
                "prefix": "str"  # Prefix-based match. For
                                                          example, ``/api`` will match ``/api``"" ,
                                                          ``/api/``"" , and any nested paths such as
                                                          ``/api/v1/endpoint``. Required.
                                                    }
                                                },
                                                "redirect": {
                                                    "authority":
                                                      "str",  # Optional. The authority/host to
                                                      redirect to. This can be a hostname or IP
                                                      address. Note: use ``port`` to set the port.
                                                    "port": 0,  #
                                                      Optional. The port to redirect to.
                "redirect_code": 0,  # Optional. The redirect
                                                      code to use. Defaults to ``302``. Supported
                                                      values are 300, 301, 302, 303, 304, 307, 308.
                                                    "scheme":
                                                      "str",  # Optional. The scheme to redirect to.
                                                      Supported values are ``http`` or ``https``.
                                                      Default: ``https``.
                                                    "uri": "str"
                                                      # Optional. An optional URI path to redirect to.
                                                      Note: if this is specified the whole URI of the
                                                      original request will be overwritten to this
                                                      value, irrespective of the original request URI
                                                      being matched.
                                                }
                                            }
                                        ]
                                    },
                                    "jobs": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "kind": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * UNSPECIFIED:
                                              Default job type, will auto-complete to POST_DEPLOY kind.
                                              * PRE_DEPLOY: Indicates a job that runs before an app
                                              deployment. * POST_DEPLOY: Indicates a job that runs
                                              after an app deployment. * FAILED_DEPLOY: Indicates a job
                                              that runs after a component fails to deploy. Known values
                                              are: "UNSPECIFIED", "PRE_DEPLOY", "POST_DEPLOY", and
                                              "FAILED_DEPLOY".
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ],
                                    "maintenance": {
                                        "archive": bool,  # Optional.
                                          Indicates whether the app should be archived. Setting this to
                                          true implies that enabled is set to true. Note that this
                                          feature is currently in closed beta.
                                        "enabled": bool,  # Optional.
                                          Indicates whether maintenance mode should be enabled for the
                                          app.
                                        "offline_page_url": "str"  #
                                          Optional. A custom offline page to display when maintenance
                                          mode is enabled or the app is archived.
                                    },
                                    "region": "str",  # Optional. The slug form
                                      of the geographical origin of the app. Default: ``nearest
                                      available``. Known values are: "ams", "nyc", "fra", "sfo", "sgp",
                                      "blr", "tor", "lon", and "syd".
                                    "services": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "health_check": {
                                                "failure_threshold":
                                                  0,  # Optional. The number of failed health checks
                                                  before considered unhealthy.
                                                "http_path": "str",
                                                  # Optional. The route path used for the HTTP health
                                                  check ping. If not set, the HTTP health check will be
                                                  disabled and a TCP health check used instead.
                "initial_delay_seconds": 0,  # Optional. The number
                                                  of seconds to wait before beginning health checks.
                                                "period_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  health checks.
                                                "port": 0,  #
                                                  Optional. The port on which the health check will be
                                                  performed. If not set, the health check will be
                                                  performed on the component's http_port.
                                                "success_threshold":
                                                  0,  # Optional. The number of successful health
                                                  checks before considered healthy.
                                                "timeout_seconds": 0
                                                  # Optional. The number of seconds after which the
                                                  check times out.
                                            },
                                            "http_port": 0,  # Optional.
                                              The internal port on which this service's run command
                                              will listen. Default: 8080 If there is not an environment
                                              variable with the name ``PORT``"" , one will be
                                              automatically added with its value set to the value of
                                              this field.
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "internal_ports": [
                                                0  # Optional. The
                                                  ports on which this service will listen for internal
                                                  traffic.
                                            ],
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "protocol": "str",  #
                                              Optional. The protocol which the service uses to serve
                                              traffic on the http_port.   * ``HTTP``"" : The app is
                                              serving the HTTP protocol. Default. * ``HTTP2``"" : The
                                              app is serving the HTTP/2 protocol. Currently, this needs
                                              to be implemented in the service by serving HTTP/2
                                              cleartext (h2c). Known values are: "HTTP" and "HTTP2".
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                                                "drain_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  selecting a container instance for termination and
                                                  issuing the TERM signal. Selecting a container
                                                  instance for termination begins an asynchronous drain
                                                  of new requests on upstream load-balancers. (Default
                                                  15).
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ],
                                    "static_sites": [
                                        {
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "catchall_document": "str",
                                              # Optional. The name of the document to use as the
                                              fallback for any requests to documents that are not found
                                              when serving this static site. Only 1 of
                                              ``catchall_document`` or ``error_document`` can be set.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "error_document": "404.html",
                                              # Optional. Default value is "404.html". The name of the
                                              error document to use when serving this static site.
                                              Default: 404.html. If no such file exists within the
                                              built assets, App Platform will supply one.
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "index_document":
                                              "index.html",  # Optional. Default value is "index.html".
                                              The name of the index document to use when serving this
                                              static site. Default: index.html.
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "output_dir": "str",  #
                                              Optional. An optional path to where the built assets will
                                              be located, relative to the build context. If not set,
                                              App Platform will automatically scan for these directory
                                              names: ``_static``"" , ``dist``"" , ``public``"" ,
                                              ``build``.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "workers": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ]
                                },
                                "static_sites": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this static site.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this static site.
                                    }
                                ],
                                "tier_slug": "str",  # Optional. The current pricing
                                  tier slug of the deployment.
                                "updated_at": "2020-02-20 00:00:00",  # Optional.
                                  When the deployment was last updated.
                                "workers": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this worker.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this worker.
                                    }
                                ]
                            },
                            "last_deployment_created_at": "2020-02-20 00:00:00",  #
                              Optional. The creation time of the last deployment.
                            "live_domain": "str",  # Optional. The live domain of the
                              app.
                            "live_url": "str",  # Optional. The live URL of the app.
                            "live_url_base": "str",  # Optional. The live URL base of the
                              app, the URL excluding the path.
                            "owner_uuid": "str",  # Optional. The ID of the account to
                              which the application belongs.
                            "pending_deployment": {
                                "cause": "str",  # Optional. What caused this
                                  deployment to be created.
                                "cloned_from": "str",  # Optional. The ID of a
                                  previous deployment that this deployment was cloned from.
                                "created_at": "2020-02-20 00:00:00",  # Optional. The
                                  creation time of the deployment.
                                "functions": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this functions component.
                                        "namespace": "str",  # Optional. The
                                          namespace where the functions are deployed.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this functions component.
                                    }
                                ],
                                "id": "str",  # Optional. The ID of the deployment.
                                "jobs": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this job.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this job.
                                    }
                                ],
                                "phase": "UNKNOWN",  # Optional. Default value is
                                  "UNKNOWN". Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                                  "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                                  "CANCELED".
                                "phase_last_updated_at": "2020-02-20 00:00:00",  #
                                  Optional. When the deployment phase was last updated.
                                "progress": {
                                    "error_steps": 0,  # Optional. Number of
                                      unsuccessful steps.
                                    "pending_steps": 0,  # Optional. Number of
                                      pending steps.
                                    "running_steps": 0,  # Optional. Number of
                                      currently running steps.
                                    "steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:  ``message_base`` = "Building
                                              service" ``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "success_steps": 0,  # Optional. Number of
                                      successful steps.
                                    "summary_steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:  ``message_base`` = "Building
                                              service" ``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "total_steps": 0  # Optional. Total number of
                                      steps.
                                },
                                "services": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this service.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this service.
                                    }
                                ],
                                "spec": {
                                    "name": "str",  # The name of the app. Must
                                      be unique across all apps in the same account. Required.
                                    "databases": [
                                        {
                                            "name": "str",  # The
                                              database's name. The name must be unique across all
                                              components within the same app and cannot use capital
                                              letters. Required.
                                            "cluster_name": "str",  #
                                              Optional. The name of the underlying DigitalOcean DBaaS
                                              cluster. This is required for production databases. For
                                              dev databases, if cluster_name is not set, a new cluster
                                              will be provisioned.
                                            "db_name": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL database to
                                              configure.
                                            "db_user": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL user to
                                              configure.
                                            "engine": "UNSET",  #
                                              Optional. Default value is "UNSET". * MYSQL: MySQL * PG:
                                              PostgreSQL * REDIS: Redis * MONGODB: MongoDB * KAFKA:
                                              Kafka * OPENSEARCH: OpenSearch. Known values are:
                                              "UNSET", "MYSQL", "PG", "REDIS", "MONGODB", "KAFKA", and
                                              "OPENSEARCH".
                                            "production": bool,  #
                                              Optional. Whether this is a production or dev database.
                                            "version": "str"  # Optional.
                                              The version of the database engine.
                                        }
                                    ],
                                    "domains": [
                                        {
                                            "domain": "str",  # The
                                              hostname for the domain. Required.
                                            "minimum_tls_version": "str",
                                              # Optional. The minimum version of TLS a client
                                              application can use to access resources for the domain.
                                              Must be one of the following values wrapped within
                                              quotations: ``"1.2"`` or ``"1.3"``. Known values are:
                                              "1.2" and "1.3".
                                            "type": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * DEFAULT: The
                                              default ``.ondigitalocean.app`` domain assigned to this
                                              app * PRIMARY: The primary domain for this app that is
                                              displayed as the default in the control panel, used in
                                              bindable environment variables, and any other places that
                                              reference an app's live URL. Only one domain may be set
                                              as primary. * ALIAS: A non-primary domain. Known values
                                              are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and "ALIAS".
                                            "wildcard": bool,  #
                                              Optional. Indicates whether the domain includes all
                                              sub-domains, in addition to the given domain.
                                            "zone": "str"  # Optional.
                                              Optional. If the domain uses DigitalOcean DNS and you
                                              would like App Platform to automatically manage it for
                                              you, set this to the name of the domain on your account.
                                              For example, If the domain you are adding is
                                              ``app.domain.com``"" , the zone could be ``domain.com``.
                                        }
                                    ],
                                    "egress": {
                                        "type": "AUTOASSIGN"  # Optional.
                                          Default value is "AUTOASSIGN". The app egress type. Known
                                          values are: "AUTOASSIGN" and "DEDICATED_IP".
                                    },
                                    "functions": [
                                        {
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "alerts": [
                                                {
                                                    "disabled":
                                                      bool,  # Optional. Is the alert disabled?.
                                                    "operator":
                                                      "UNSPECIFIED_OPERATOR",  # Optional. Default
                                                      value is "UNSPECIFIED_OPERATOR". Known values
                                                      are: "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                      "LESS_THAN".
                                                    "rule":
                                                      "UNSPECIFIED_RULE",  # Optional. Default value is
                                                      "UNSPECIFIED_RULE". Known values are:
                                                      "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                      "MEM_UTILIZATION", "RESTART_COUNT",
                                                      "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                      "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                      "FUNCTIONS_ACTIVATION_COUNT",
                                                      "FUNCTIONS_AVERAGE_DURATION_MS",
                                                      "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                      "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                      "FUNCTIONS_ERROR_COUNT", and
                                                      "FUNCTIONS_GB_RATE_PER_SECOND".
                                                    "value": 0.0,
                                                      # Optional. Threshold value for alert.
                                                    "window":
                                                      "UNSPECIFIED_WINDOW"  # Optional. Default value
                                                      is "UNSPECIFIED_WINDOW". Known values are:
                                                      "UNSPECIFIED_WINDOW", "FIVE_MINUTES",
                                                      "TEN_MINUTES", "THIRTY_MINUTES", and "ONE_HOUR".
                                                }
                                            ],
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "ingress": {
                                        "rules": [
                                            {
                                                "component": {
                                                    "name":
                                                      "str",  # The name of the component to route to.
                                                      Required.
                "preserve_path_prefix": "str",  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``. Note: this is not applicable for
                                                      Functions Components and is mutually exclusive
                                                      with ``rewrite``.
                                                    "rewrite":
                                                      "str"  # Optional. An optional field that will
                                                      rewrite the path of the component to be what is
                                                      specified here. By default, the HTTP request path
                                                      will be trimmed from the left when forwarded to
                                                      the component. For example, a component with
                                                      ``path=/api`` will have requests to ``/api/list``
                                                      trimmed to ``/list``. If you specified the
                                                      rewrite to be ``/v1/``"" , requests to
                                                      ``/api/list`` would be rewritten to ``/v1/list``.
                                                      Note: this is mutually exclusive with
                                                      ``preserve_path_prefix``.
                                                },
                                                "cors": {
                "allow_credentials": bool,  # Optional. Whether
                                                      browsers should expose the response to the
                                                      client-side JavaScript code when the
                                                      request"u2019s credentials mode is include. This
                                                      configures the
                                                      ``Access-Control-Allow-Credentials`` header.
                "allow_headers": [
                                                        "str"
                                                          # Optional. The set of allowed HTTP request
                                                          headers. This configures the
                                                          ``Access-Control-Allow-Headers`` header.
                                                    ],
                "allow_methods": [
                                                        "str"
                                                          # Optional. The set of allowed HTTP methods.
                                                          This configures the
                                                          ``Access-Control-Allow-Methods`` header.
                                                    ],
                "allow_origins": [
                                                        {
                "exact": "str",  # Optional. Exact string
                                                              match. Only 1 of ``exact``"" ,
                                                              ``prefix``"" , or ``regex`` must be set.
                "prefix": "str",  # Optional.
                                                              Prefix-based match. Only 1 of ``exact``""
                                                              , ``prefix``"" , or ``regex`` must be
                                                              set.
                "regex": "str"  # Optional. RE2 style
                                                              regex-based match. Only 1 of ``exact``""
                                                              , ``prefix``"" , or ``regex`` must be
                                                              set. For more information about RE2
                                                              syntax, see:
                                                              https://github.com/google/re2/wiki/Syntax.
                                                        }
                                                    ],
                "expose_headers": [
                                                        "str"
                                                          # Optional. The set of HTTP response headers
                                                          that browsers are allowed to access. This
                                                          configures the
                                                          ``Access-Control-Expose-Headers`` header.
                                                    ],
                                                    "max_age":
                                                      "str"  # Optional. An optional duration
                                                      specifying how long browsers can cache the
                                                      results of a preflight request. This configures
                                                      the ``Access-Control-Max-Age`` header.
                                                },
                                                "match": {
                                                    "path": {
                "prefix": "str"  # Prefix-based match. For
                                                          example, ``/api`` will match ``/api``"" ,
                                                          ``/api/``"" , and any nested paths such as
                                                          ``/api/v1/endpoint``. Required.
                                                    }
                                                },
                                                "redirect": {
                                                    "authority":
                                                      "str",  # Optional. The authority/host to
                                                      redirect to. This can be a hostname or IP
                                                      address. Note: use ``port`` to set the port.
                                                    "port": 0,  #
                                                      Optional. The port to redirect to.
                "redirect_code": 0,  # Optional. The redirect
                                                      code to use. Defaults to ``302``. Supported
                                                      values are 300, 301, 302, 303, 304, 307, 308.
                                                    "scheme":
                                                      "str",  # Optional. The scheme to redirect to.
                                                      Supported values are ``http`` or ``https``.
                                                      Default: ``https``.
                                                    "uri": "str"
                                                      # Optional. An optional URI path to redirect to.
                                                      Note: if this is specified the whole URI of the
                                                      original request will be overwritten to this
                                                      value, irrespective of the original request URI
                                                      being matched.
                                                }
                                            }
                                        ]
                                    },
                                    "jobs": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "kind": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * UNSPECIFIED:
                                              Default job type, will auto-complete to POST_DEPLOY kind.
                                              * PRE_DEPLOY: Indicates a job that runs before an app
                                              deployment. * POST_DEPLOY: Indicates a job that runs
                                              after an app deployment. * FAILED_DEPLOY: Indicates a job
                                              that runs after a component fails to deploy. Known values
                                              are: "UNSPECIFIED", "PRE_DEPLOY", "POST_DEPLOY", and
                                              "FAILED_DEPLOY".
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ],
                                    "maintenance": {
                                        "archive": bool,  # Optional.
                                          Indicates whether the app should be archived. Setting this to
                                          true implies that enabled is set to true. Note that this
                                          feature is currently in closed beta.
                                        "enabled": bool,  # Optional.
                                          Indicates whether maintenance mode should be enabled for the
                                          app.
                                        "offline_page_url": "str"  #
                                          Optional. A custom offline page to display when maintenance
                                          mode is enabled or the app is archived.
                                    },
                                    "region": "str",  # Optional. The slug form
                                      of the geographical origin of the app. Default: ``nearest
                                      available``. Known values are: "ams", "nyc", "fra", "sfo", "sgp",
                                      "blr", "tor", "lon", and "syd".
                                    "services": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "health_check": {
                                                "failure_threshold":
                                                  0,  # Optional. The number of failed health checks
                                                  before considered unhealthy.
                                                "http_path": "str",
                                                  # Optional. The route path used for the HTTP health
                                                  check ping. If not set, the HTTP health check will be
                                                  disabled and a TCP health check used instead.
                "initial_delay_seconds": 0,  # Optional. The number
                                                  of seconds to wait before beginning health checks.
                                                "period_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  health checks.
                                                "port": 0,  #
                                                  Optional. The port on which the health check will be
                                                  performed. If not set, the health check will be
                                                  performed on the component's http_port.
                                                "success_threshold":
                                                  0,  # Optional. The number of successful health
                                                  checks before considered healthy.
                                                "timeout_seconds": 0
                                                  # Optional. The number of seconds after which the
                                                  check times out.
                                            },
                                            "http_port": 0,  # Optional.
                                              The internal port on which this service's run command
                                              will listen. Default: 8080 If there is not an environment
                                              variable with the name ``PORT``"" , one will be
                                              automatically added with its value set to the value of
                                              this field.
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "internal_ports": [
                                                0  # Optional. The
                                                  ports on which this service will listen for internal
                                                  traffic.
                                            ],
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "protocol": "str",  #
                                              Optional. The protocol which the service uses to serve
                                              traffic on the http_port.   * ``HTTP``"" : The app is
                                              serving the HTTP protocol. Default. * ``HTTP2``"" : The
                                              app is serving the HTTP/2 protocol. Currently, this needs
                                              to be implemented in the service by serving HTTP/2
                                              cleartext (h2c). Known values are: "HTTP" and "HTTP2".
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                                                "drain_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  selecting a container instance for termination and
                                                  issuing the TERM signal. Selecting a container
                                                  instance for termination begins an asynchronous drain
                                                  of new requests on upstream load-balancers. (Default
                                                  15).
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ],
                                    "static_sites": [
                                        {
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "catchall_document": "str",
                                              # Optional. The name of the document to use as the
                                              fallback for any requests to documents that are not found
                                              when serving this static site. Only 1 of
                                              ``catchall_document`` or ``error_document`` can be set.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "error_document": "404.html",
                                              # Optional. Default value is "404.html". The name of the
                                              error document to use when serving this static site.
                                              Default: 404.html. If no such file exists within the
                                              built assets, App Platform will supply one.
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "index_document":
                                              "index.html",  # Optional. Default value is "index.html".
                                              The name of the index document to use when serving this
                                              static site. Default: index.html.
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "output_dir": "str",  #
                                              Optional. An optional path to where the built assets will
                                              be located, relative to the build context. If not set,
                                              App Platform will automatically scan for these directory
                                              names: ``_static``"" , ``dist``"" , ``public``"" ,
                                              ``build``.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "workers": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ]
                                },
                                "static_sites": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this static site.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this static site.
                                    }
                                ],
                                "tier_slug": "str",  # Optional. The current pricing
                                  tier slug of the deployment.
                                "updated_at": "2020-02-20 00:00:00",  # Optional.
                                  When the deployment was last updated.
                                "workers": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this worker.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this worker.
                                    }
                                ]
                            },
                            "pinned_deployment": {
                                "cause": "str",  # Optional. What caused this
                                  deployment to be created.
                                "cloned_from": "str",  # Optional. The ID of a
                                  previous deployment that this deployment was cloned from.
                                "created_at": "2020-02-20 00:00:00",  # Optional. The
                                  creation time of the deployment.
                                "functions": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this functions component.
                                        "namespace": "str",  # Optional. The
                                          namespace where the functions are deployed.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this functions component.
                                    }
                                ],
                                "id": "str",  # Optional. The ID of the deployment.
                                "jobs": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this job.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this job.
                                    }
                                ],
                                "phase": "UNKNOWN",  # Optional. Default value is
                                  "UNKNOWN". Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                                  "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                                  "CANCELED".
                                "phase_last_updated_at": "2020-02-20 00:00:00",  #
                                  Optional. When the deployment phase was last updated.
                                "progress": {
                                    "error_steps": 0,  # Optional. Number of
                                      unsuccessful steps.
                                    "pending_steps": 0,  # Optional. Number of
                                      pending steps.
                                    "running_steps": 0,  # Optional. Number of
                                      currently running steps.
                                    "steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:  ``message_base`` = "Building
                                              service" ``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "success_steps": 0,  # Optional. Number of
                                      successful steps.
                                    "summary_steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:  ``message_base`` = "Building
                                              service" ``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "total_steps": 0  # Optional. Total number of
                                      steps.
                                },
                                "services": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this service.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this service.
                                    }
                                ],
                                "spec": {
                                    "name": "str",  # The name of the app. Must
                                      be unique across all apps in the same account. Required.
                                    "databases": [
                                        {
                                            "name": "str",  # The
                                              database's name. The name must be unique across all
                                              components within the same app and cannot use capital
                                              letters. Required.
                                            "cluster_name": "str",  #
                                              Optional. The name of the underlying DigitalOcean DBaaS
                                              cluster. This is required for production databases. For
                                              dev databases, if cluster_name is not set, a new cluster
                                              will be provisioned.
                                            "db_name": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL database to
                                              configure.
                                            "db_user": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL user to
                                              configure.
                                            "engine": "UNSET",  #
                                              Optional. Default value is "UNSET". * MYSQL: MySQL * PG:
                                              PostgreSQL * REDIS: Redis * MONGODB: MongoDB * KAFKA:
                                              Kafka * OPENSEARCH: OpenSearch. Known values are:
                                              "UNSET", "MYSQL", "PG", "REDIS", "MONGODB", "KAFKA", and
                                              "OPENSEARCH".
                                            "production": bool,  #
                                              Optional. Whether this is a production or dev database.
                                            "version": "str"  # Optional.
                                              The version of the database engine.
                                        }
                                    ],
                                    "domains": [
                                        {
                                            "domain": "str",  # The
                                              hostname for the domain. Required.
                                            "minimum_tls_version": "str",
                                              # Optional. The minimum version of TLS a client
                                              application can use to access resources for the domain.
                                              Must be one of the following values wrapped within
                                              quotations: ``"1.2"`` or ``"1.3"``. Known values are:
                                              "1.2" and "1.3".
                                            "type": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * DEFAULT: The
                                              default ``.ondigitalocean.app`` domain assigned to this
                                              app * PRIMARY: The primary domain for this app that is
                                              displayed as the default in the control panel, used in
                                              bindable environment variables, and any other places that
                                              reference an app's live URL. Only one domain may be set
                                              as primary. * ALIAS: A non-primary domain. Known values
                                              are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and "ALIAS".
                                            "wildcard": bool,  #
                                              Optional. Indicates whether the domain includes all
                                              sub-domains, in addition to the given domain.
                                            "zone": "str"  # Optional.
                                              Optional. If the domain uses DigitalOcean DNS and you
                                              would like App Platform to automatically manage it for
                                              you, set this to the name of the domain on your account.
                                              For example, If the domain you are adding is
                                              ``app.domain.com``"" , the zone could be ``domain.com``.
                                        }
                                    ],
                                    "egress": {
                                        "type": "AUTOASSIGN"  # Optional.
                                          Default value is "AUTOASSIGN". The app egress type. Known
                                          values are: "AUTOASSIGN" and "DEDICATED_IP".
                                    },
                                    "functions": [
                                        {
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "alerts": [
                                                {
                                                    "disabled":
                                                      bool,  # Optional. Is the alert disabled?.
                                                    "operator":
                                                      "UNSPECIFIED_OPERATOR",  # Optional. Default
                                                      value is "UNSPECIFIED_OPERATOR". Known values
                                                      are: "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                      "LESS_THAN".
                                                    "rule":
                                                      "UNSPECIFIED_RULE",  # Optional. Default value is
                                                      "UNSPECIFIED_RULE". Known values are:
                                                      "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                      "MEM_UTILIZATION", "RESTART_COUNT",
                                                      "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                      "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                      "FUNCTIONS_ACTIVATION_COUNT",
                                                      "FUNCTIONS_AVERAGE_DURATION_MS",
                                                      "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                      "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                      "FUNCTIONS_ERROR_COUNT", and
                                                      "FUNCTIONS_GB_RATE_PER_SECOND".
                                                    "value": 0.0,
                                                      # Optional. Threshold value for alert.
                                                    "window":
                                                      "UNSPECIFIED_WINDOW"  # Optional. Default value
                                                      is "UNSPECIFIED_WINDOW". Known values are:
                                                      "UNSPECIFIED_WINDOW", "FIVE_MINUTES",
                                                      "TEN_MINUTES", "THIRTY_MINUTES", and "ONE_HOUR".
                                                }
                                            ],
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "ingress": {
                                        "rules": [
                                            {
                                                "component": {
                                                    "name":
                                                      "str",  # The name of the component to route to.
                                                      Required.
                "preserve_path_prefix": "str",  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``. Note: this is not applicable for
                                                      Functions Components and is mutually exclusive
                                                      with ``rewrite``.
                                                    "rewrite":
                                                      "str"  # Optional. An optional field that will
                                                      rewrite the path of the component to be what is
                                                      specified here. By default, the HTTP request path
                                                      will be trimmed from the left when forwarded to
                                                      the component. For example, a component with
                                                      ``path=/api`` will have requests to ``/api/list``
                                                      trimmed to ``/list``. If you specified the
                                                      rewrite to be ``/v1/``"" , requests to
                                                      ``/api/list`` would be rewritten to ``/v1/list``.
                                                      Note: this is mutually exclusive with
                                                      ``preserve_path_prefix``.
                                                },
                                                "cors": {
                "allow_credentials": bool,  # Optional. Whether
                                                      browsers should expose the response to the
                                                      client-side JavaScript code when the
                                                      request"u2019s credentials mode is include. This
                                                      configures the
                                                      ``Access-Control-Allow-Credentials`` header.
                "allow_headers": [
                                                        "str"
                                                          # Optional. The set of allowed HTTP request
                                                          headers. This configures the
                                                          ``Access-Control-Allow-Headers`` header.
                                                    ],
                "allow_methods": [
                                                        "str"
                                                          # Optional. The set of allowed HTTP methods.
                                                          This configures the
                                                          ``Access-Control-Allow-Methods`` header.
                                                    ],
                "allow_origins": [
                                                        {
                "exact": "str",  # Optional. Exact string
                                                              match. Only 1 of ``exact``"" ,
                                                              ``prefix``"" , or ``regex`` must be set.
                "prefix": "str",  # Optional.
                                                              Prefix-based match. Only 1 of ``exact``""
                                                              , ``prefix``"" , or ``regex`` must be
                                                              set.
                "regex": "str"  # Optional. RE2 style
                                                              regex-based match. Only 1 of ``exact``""
                                                              , ``prefix``"" , or ``regex`` must be
                                                              set. For more information about RE2
                                                              syntax, see:
                                                              https://github.com/google/re2/wiki/Syntax.
                                                        }
                                                    ],
                "expose_headers": [
                                                        "str"
                                                          # Optional. The set of HTTP response headers
                                                          that browsers are allowed to access. This
                                                          configures the
                                                          ``Access-Control-Expose-Headers`` header.
                                                    ],
                                                    "max_age":
                                                      "str"  # Optional. An optional duration
                                                      specifying how long browsers can cache the
                                                      results of a preflight request. This configures
                                                      the ``Access-Control-Max-Age`` header.
                                                },
                                                "match": {
                                                    "path": {
                "prefix": "str"  # Prefix-based match. For
                                                          example, ``/api`` will match ``/api``"" ,
                                                          ``/api/``"" , and any nested paths such as
                                                          ``/api/v1/endpoint``. Required.
                                                    }
                                                },
                                                "redirect": {
                                                    "authority":
                                                      "str",  # Optional. The authority/host to
                                                      redirect to. This can be a hostname or IP
                                                      address. Note: use ``port`` to set the port.
                                                    "port": 0,  #
                                                      Optional. The port to redirect to.
                "redirect_code": 0,  # Optional. The redirect
                                                      code to use. Defaults to ``302``. Supported
                                                      values are 300, 301, 302, 303, 304, 307, 308.
                                                    "scheme":
                                                      "str",  # Optional. The scheme to redirect to.
                                                      Supported values are ``http`` or ``https``.
                                                      Default: ``https``.
                                                    "uri": "str"
                                                      # Optional. An optional URI path to redirect to.
                                                      Note: if this is specified the whole URI of the
                                                      original request will be overwritten to this
                                                      value, irrespective of the original request URI
                                                      being matched.
                                                }
                                            }
                                        ]
                                    },
                                    "jobs": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "kind": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * UNSPECIFIED:
                                              Default job type, will auto-complete to POST_DEPLOY kind.
                                              * PRE_DEPLOY: Indicates a job that runs before an app
                                              deployment. * POST_DEPLOY: Indicates a job that runs
                                              after an app deployment. * FAILED_DEPLOY: Indicates a job
                                              that runs after a component fails to deploy. Known values
                                              are: "UNSPECIFIED", "PRE_DEPLOY", "POST_DEPLOY", and
                                              "FAILED_DEPLOY".
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ],
                                    "maintenance": {
                                        "archive": bool,  # Optional.
                                          Indicates whether the app should be archived. Setting this to
                                          true implies that enabled is set to true. Note that this
                                          feature is currently in closed beta.
                                        "enabled": bool,  # Optional.
                                          Indicates whether maintenance mode should be enabled for the
                                          app.
                                        "offline_page_url": "str"  #
                                          Optional. A custom offline page to display when maintenance
                                          mode is enabled or the app is archived.
                                    },
                                    "region": "str",  # Optional. The slug form
                                      of the geographical origin of the app. Default: ``nearest
                                      available``. Known values are: "ams", "nyc", "fra", "sfo", "sgp",
                                      "blr", "tor", "lon", and "syd".
                                    "services": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "health_check": {
                                                "failure_threshold":
                                                  0,  # Optional. The number of failed health checks
                                                  before considered unhealthy.
                                                "http_path": "str",
                                                  # Optional. The route path used for the HTTP health
                                                  check ping. If not set, the HTTP health check will be
                                                  disabled and a TCP health check used instead.
                "initial_delay_seconds": 0,  # Optional. The number
                                                  of seconds to wait before beginning health checks.
                                                "period_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  health checks.
                                                "port": 0,  #
                                                  Optional. The port on which the health check will be
                                                  performed. If not set, the health check will be
                                                  performed on the component's http_port.
                                                "success_threshold":
                                                  0,  # Optional. The number of successful health
                                                  checks before considered healthy.
                                                "timeout_seconds": 0
                                                  # Optional. The number of seconds after which the
                                                  check times out.
                                            },
                                            "http_port": 0,  # Optional.
                                              The internal port on which this service's run command
                                              will listen. Default: 8080 If there is not an environment
                                              variable with the name ``PORT``"" , one will be
                                              automatically added with its value set to the value of
                                              this field.
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "internal_ports": [
                                                0  # Optional. The
                                                  ports on which this service will listen for internal
                                                  traffic.
                                            ],
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "protocol": "str",  #
                                              Optional. The protocol which the service uses to serve
                                              traffic on the http_port.   * ``HTTP``"" : The app is
                                              serving the HTTP protocol. Default. * ``HTTP2``"" : The
                                              app is serving the HTTP/2 protocol. Currently, this needs
                                              to be implemented in the service by serving HTTP/2
                                              cleartext (h2c). Known values are: "HTTP" and "HTTP2".
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                                                "drain_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  selecting a container instance for termination and
                                                  issuing the TERM signal. Selecting a container
                                                  instance for termination begins an asynchronous drain
                                                  of new requests on upstream load-balancers. (Default
                                                  15).
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ],
                                    "static_sites": [
                                        {
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "catchall_document": "str",
                                              # Optional. The name of the document to use as the
                                              fallback for any requests to documents that are not found
                                              when serving this static site. Only 1 of
                                              ``catchall_document`` or ``error_document`` can be set.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "error_document": "404.html",
                                              # Optional. Default value is "404.html". The name of the
                                              error document to use when serving this static site.
                                              Default: 404.html. If no such file exists within the
                                              built assets, App Platform will supply one.
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "index_document":
                                              "index.html",  # Optional. Default value is "index.html".
                                              The name of the index document to use when serving this
                                              static site. Default: index.html.
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "output_dir": "str",  #
                                              Optional. An optional path to where the built assets will
                                              be located, relative to the build context. If not set,
                                              App Platform will automatically scan for these directory
                                              names: ``_static``"" , ``dist``"" , ``public``"" ,
                                              ``build``.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. (Deprecated - Use Ingress
                                                      Rules instead). An HTTP path prefix. Paths must
                                                      start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "workers": [
                                        {
                                            "autoscaling": {
                                                "max_instance_count":
                                                  0,  # Optional. The maximum amount of instances for
                                                  this component. Must be more than min_instance_count.
                                                "metrics": {
                                                    "cpu": {
                "percent": 80  # Optional. Default value is
                                                          80. The average target CPU utilization for
                                                          the component.
                                                    }
                                                },
                                                "min_instance_count":
                                                  0  # Optional. The minimum amount of instances for
                                                  this component. Must be less than max_instance_count.
                                            },
                                            "bitbucket": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://docs.digitalocean.com/products/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time * BUILD_TIME: Made
                                                      available only at build-time *
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable * SECRET: A secret encrypted environment
                                                      variable. Known values are: "GENERAL" and
                                                      "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "deploy_on_push": {
                                                    "enabled":
                                                      bool  # Optional. Whether to automatically deploy
                                                      new images. Can only be used for images hosted in
                                                      DOCR and can only be used with an image tag, not
                                                      a specific digest.
                                                },
                                                "digest": "str",  #
                                                  Optional. The image digest. Cannot be specified if
                                                  tag is provided.
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                "registry_credentials": "str",  # Optional. The
                                                  credentials to be able to pull the image. The value
                                                  will be encrypted on first submission. On following
                                                  submissions, the encrypted value should be used.   *
                                                  "$username:$access_token" for registries of type
                                                  ``DOCKER_HUB``. * "$username:$access_token" for
                                                  registries of type ``GHCR``.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type. * DOCR: The DigitalOcean
                                                  container registry type. * GHCR: The Github container
                                                  registry type. Known values are: "DOCKER_HUB",
                                                  "DOCR", and "GHCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided and no
                                                  digest is provided. Cannot be specified if digest is
                                                  provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1. Must
                                              not be set if autoscaling is used.
                                            "instance_size_slug": {},
                                            "log_destinations": [
                                                {
                                                    "name":
                                                      "str",  # Required.
                                                    "datadog": {
                "api_key": "str",  # Datadog API key.
                                                          Required.
                "endpoint": "str"  # Optional. Datadog HTTP
                                                          log intake endpoint.
                                                    },
                                                    "logtail": {
                "token": "str"  # Optional. Logtail token.
                                                    },
                "open_search": {
                "basic_auth": {
                "password": {},  # Optional. Password for
                                                              user defined in User. Is required when
                                                              ``endpoint`` is set. Cannot be set if
                                                              using a DigitalOcean DBaaS OpenSearch
                                                              cluster.
                "user": "str"  # Optional. Username to
                                                              authenticate with. Only required when
                                                              ``endpoint`` is set. Defaults to
                                                              ``doadmin`` when ``cluster_name`` is set.
                                                        },
                "cluster_name": "str",  # Optional. The name
                                                          of a DigitalOcean DBaaS OpenSearch cluster to
                                                          use as a log forwarding destination. Cannot
                                                          be specified if ``endpoint`` is also
                                                          specified.
                "endpoint": "str",  # Optional. OpenSearch
                                                          API Endpoint. Only HTTPS is supported.
                                                          Format:
                                                          https://:code:`<host>`::code:`<port>`. Cannot
                                                          be specified if ``cluster_name`` is also
                                                          specified.
                "index_name": "logs"  # Optional. Default
                                                          value is "logs". The index name to use for
                                                          the logs. If not set, the default index name
                                                          is "logs".
                                                    },
                                                    "papertrail":
                                                      {
                "endpoint": "str"  # Papertrail syslog
                                                          endpoint. Required.
                                                    }
                                                }
                                            ],
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str",  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                            "termination": {
                "grace_period_seconds": 0  # Optional. The number of
                                                  seconds to wait between sending a TERM signal to a
                                                  container and issuing a KILL which causes immediate
                                                  shutdown. (Default 120).
                                            }
                                        }
                                    ]
                                },
                                "static_sites": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this static site.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this static site.
                                    }
                                ],
                                "tier_slug": "str",  # Optional. The current pricing
                                  tier slug of the deployment.
                                "updated_at": "2020-02-20 00:00:00",  # Optional.
                                  When the deployment was last updated.
                                "workers": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this worker.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this worker.
             