# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtQuick, except for defaults which are replaced by "...".
"""

# Module PySide2.QtQuick
import PySide2
import typing

import shiboken2 as Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtQml
import PySide2.QtQuick


class QQuickAsyncImageProvider(PySide2.QtQuick.QQuickImageProvider):

    def __init__(self) -> None: ...

    def requestImageResponse(self, id:str, requestedSize:PySide2.QtCore.QSize) -> PySide2.QtQuick.QQuickImageResponse: ...


class QQuickFramebufferObject(PySide2.QtQuick.QQuickItem):

    mirrorVerticallyChanged: PySide2.QtCore.Signal
    textureFollowsItemSizeChanged: PySide2.QtCore.Signal


    class Renderer(Shiboken.Object):

        def __init__(self) -> None: ...

        def createFramebufferObject(self, size:PySide2.QtCore.QSize) -> PySide2.QtGui.QOpenGLFramebufferObject: ...
        def framebufferObject(self) -> PySide2.QtGui.QOpenGLFramebufferObject: ...
        def invalidateFramebufferObject(self) -> None: ...
        def render(self) -> None: ...
        def synchronize(self, arg__1:PySide2.QtQuick.QQuickFramebufferObject) -> None: ...
        def update(self) -> None: ...

    def __init__(self, parent:typing.Optional[PySide2.QtQuick.QQuickItem]=...) -> None: ...

    def createRenderer(self) -> PySide2.QtQuick.QQuickFramebufferObject.Renderer: ...
    def geometryChanged(self, newGeometry:PySide2.QtCore.QRectF, oldGeometry:PySide2.QtCore.QRectF) -> None: ...
    def isTextureProvider(self) -> bool: ...
    def mirrorVertically(self) -> bool: ...
    def releaseResources(self) -> None: ...
    def setMirrorVertically(self, enable:bool) -> None: ...
    def setTextureFollowsItemSize(self, follows:bool) -> None: ...
    def textureFollowsItemSize(self) -> bool: ...
    def textureProvider(self) -> PySide2.QtQuick.QSGTextureProvider: ...
    def updatePaintNode(self, arg__1:PySide2.QtQuick.QSGNode, arg__2:PySide2.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide2.QtQuick.QSGNode: ...


class QQuickImageProvider(PySide2.QtQml.QQmlImageProviderBase):

    def __init__(self, type:PySide2.QtQml.QQmlImageProviderBase.ImageType, flags:PySide2.QtQml.QQmlImageProviderBase.Flags=...) -> None: ...

    def flags(self) -> PySide2.QtQml.QQmlImageProviderBase.Flags: ...
    def imageType(self) -> PySide2.QtQml.QQmlImageProviderBase.ImageType: ...
    def requestImage(self, id:str, size:PySide2.QtCore.QSize, requestedSize:PySide2.QtCore.QSize) -> PySide2.QtGui.QImage: ...
    def requestPixmap(self, id:str, size:PySide2.QtCore.QSize, requestedSize:PySide2.QtCore.QSize) -> PySide2.QtGui.QPixmap: ...
    def requestTexture(self, id:str, size:PySide2.QtCore.QSize, requestedSize:PySide2.QtCore.QSize) -> PySide2.QtQuick.QQuickTextureFactory: ...


class QQuickImageResponse(PySide2.QtCore.QObject):

    finished: PySide2.QtCore.Signal


    def __init__(self) -> None: ...

    def cancel(self) -> None: ...
    def errorString(self) -> str: ...
    def textureFactory(self) -> PySide2.QtQuick.QQuickTextureFactory: ...


class QQuickItem(PySide2.QtCore.QObject, PySide2.QtQml.QQmlParserStatus):

    activeFocusChanged: PySide2.QtCore.Signal
    activeFocusOnTabChanged: PySide2.QtCore.Signal
    antialiasingChanged: PySide2.QtCore.Signal
    baselineOffsetChanged: PySide2.QtCore.Signal
    childrenChanged: PySide2.QtCore.Signal
    childrenRectChanged: PySide2.QtCore.Signal
    clipChanged: PySide2.QtCore.Signal
    containmentMaskChanged: PySide2.QtCore.Signal
    enabledChanged: PySide2.QtCore.Signal
    focusChanged: PySide2.QtCore.Signal
    heightChanged: PySide2.QtCore.Signal
    implicitHeightChanged: PySide2.QtCore.Signal
    implicitWidthChanged: PySide2.QtCore.Signal
    opacityChanged: PySide2.QtCore.Signal
    parentChanged: PySide2.QtCore.Signal
    rotationChanged: PySide2.QtCore.Signal
    scaleChanged: PySide2.QtCore.Signal
    smoothChanged: PySide2.QtCore.Signal
    stateChanged: PySide2.QtCore.Signal
    transformOriginChanged: PySide2.QtCore.Signal
    visibleChanged: PySide2.QtCore.Signal
    visibleChildrenChanged: PySide2.QtCore.Signal
    widthChanged: PySide2.QtCore.Signal
    windowChanged: PySide2.QtCore.Signal
    xChanged: PySide2.QtCore.Signal
    yChanged: PySide2.QtCore.Signal
    zChanged: PySide2.QtCore.Signal

    ItemChildAddedChange     : QQuickItem.ItemChange = ... # 0x0
    TopLeft                  : QQuickItem.TransformOrigin = ... # 0x0
    ItemChildRemovedChange   : QQuickItem.ItemChange = ... # 0x1
    ItemClipsChildrenToShape : QQuickItem.Flag = ... # 0x1
    Top                      : QQuickItem.TransformOrigin = ... # 0x1
    ItemAcceptsInputMethod   : QQuickItem.Flag = ... # 0x2
    ItemSceneChange          : QQuickItem.ItemChange = ... # 0x2
    TopRight                 : QQuickItem.TransformOrigin = ... # 0x2
    ItemVisibleHasChanged    : QQuickItem.ItemChange = ... # 0x3
    Left                     : QQuickItem.TransformOrigin = ... # 0x3
    Center                   : QQuickItem.TransformOrigin = ... # 0x4
    ItemIsFocusScope         : QQuickItem.Flag = ... # 0x4
    ItemParentHasChanged     : QQuickItem.ItemChange = ... # 0x4
    ItemOpacityHasChanged    : QQuickItem.ItemChange = ... # 0x5
    Right                    : QQuickItem.TransformOrigin = ... # 0x5
    BottomLeft               : QQuickItem.TransformOrigin = ... # 0x6
    ItemActiveFocusHasChanged: QQuickItem.ItemChange = ... # 0x6
    Bottom                   : QQuickItem.TransformOrigin = ... # 0x7
    ItemRotationHasChanged   : QQuickItem.ItemChange = ... # 0x7
    BottomRight              : QQuickItem.TransformOrigin = ... # 0x8
    ItemAntialiasingHasChanged: QQuickItem.ItemChange = ... # 0x8
    ItemHasContents          : QQuickItem.Flag = ... # 0x8
    ItemDevicePixelRatioHasChanged: QQuickItem.ItemChange = ... # 0x9
    ItemEnabledHasChanged    : QQuickItem.ItemChange = ... # 0xa
    ItemAcceptsDrops         : QQuickItem.Flag = ... # 0x10

    class Flag(object):
        ItemClipsChildrenToShape : QQuickItem.Flag = ... # 0x1
        ItemAcceptsInputMethod   : QQuickItem.Flag = ... # 0x2
        ItemIsFocusScope         : QQuickItem.Flag = ... # 0x4
        ItemHasContents          : QQuickItem.Flag = ... # 0x8
        ItemAcceptsDrops         : QQuickItem.Flag = ... # 0x10
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, Flag] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __and__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __xor__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __ror__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __rand__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __rxor__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __ior__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __iand__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __ixor__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __invert__(self) -> Flags: ...

    class Flags(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, Flag, Flags] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __and__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __xor__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __ror__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __rand__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __rxor__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __ior__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __iand__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __ixor__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __invert__(self) -> Flags: ...

    class ItemChange(object):
        ItemChildAddedChange     : QQuickItem.ItemChange = ... # 0x0
        ItemChildRemovedChange   : QQuickItem.ItemChange = ... # 0x1
        ItemSceneChange          : QQuickItem.ItemChange = ... # 0x2
        ItemVisibleHasChanged    : QQuickItem.ItemChange = ... # 0x3
        ItemParentHasChanged     : QQuickItem.ItemChange = ... # 0x4
        ItemOpacityHasChanged    : QQuickItem.ItemChange = ... # 0x5
        ItemActiveFocusHasChanged: QQuickItem.ItemChange = ... # 0x6
        ItemRotationHasChanged   : QQuickItem.ItemChange = ... # 0x7
        ItemAntialiasingHasChanged: QQuickItem.ItemChange = ... # 0x8
        ItemDevicePixelRatioHasChanged: QQuickItem.ItemChange = ... # 0x9
        ItemEnabledHasChanged    : QQuickItem.ItemChange = ... # 0xa

    class TransformOrigin(object):
        TopLeft                  : QQuickItem.TransformOrigin = ... # 0x0
        Top                      : QQuickItem.TransformOrigin = ... # 0x1
        TopRight                 : QQuickItem.TransformOrigin = ... # 0x2
        Left                     : QQuickItem.TransformOrigin = ... # 0x3
        Center                   : QQuickItem.TransformOrigin = ... # 0x4
        Right                    : QQuickItem.TransformOrigin = ... # 0x5
        BottomLeft               : QQuickItem.TransformOrigin = ... # 0x6
        Bottom                   : QQuickItem.TransformOrigin = ... # 0x7
        BottomRight              : QQuickItem.TransformOrigin = ... # 0x8

    class UpdatePaintNodeData(Shiboken.Object):
        @staticmethod
        def __copy__() -> None: ...

    def __init__(self, parent:typing.Optional[PySide2.QtQuick.QQuickItem]=...) -> None: ...

    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def activeFocusOnTab(self) -> bool: ...
    def antialiasing(self) -> bool: ...
    def baselineOffset(self) -> float: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def childAt(self, x:float, y:float) -> PySide2.QtQuick.QQuickItem: ...
    def childItems(self) -> typing.List: ...
    def childMouseEventFilter(self, arg__1:PySide2.QtQuick.QQuickItem, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def childrenRect(self) -> PySide2.QtCore.QRectF: ...
    def classBegin(self) -> None: ...
    def clip(self) -> bool: ...
    def clipRect(self) -> PySide2.QtCore.QRectF: ...
    def componentComplete(self) -> None: ...
    def containmentMask(self) -> PySide2.QtCore.QObject: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def dragEnterEvent(self, arg__1:PySide2.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, arg__1:PySide2.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, arg__1:PySide2.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1:PySide2.QtGui.QDropEvent) -> None: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def filtersChildMouseEvents(self) -> bool: ...
    def flags(self) -> PySide2.QtQuick.QQuickItem.Flags: ...
    def focusInEvent(self, arg__1:PySide2.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1:PySide2.QtGui.QFocusEvent) -> None: ...
    @typing.overload
    def forceActiveFocus(self) -> None: ...
    @typing.overload
    def forceActiveFocus(self, reason:PySide2.QtCore.Qt.FocusReason) -> None: ...
    def geometryChanged(self, newGeometry:PySide2.QtCore.QRectF, oldGeometry:PySide2.QtCore.QRectF) -> None: ...
    def grabMouse(self) -> None: ...
    @typing.overload
    def grabToImage(self, callback:PySide2.QtQml.QJSValue, targetSize:PySide2.QtCore.QSize=...) -> bool: ...
    @typing.overload
    def grabToImage(self, targetSize:PySide2.QtCore.QSize=...) -> typing.Tuple: ...
    def grabTouchPoints(self, ids:typing.List) -> None: ...
    def hasActiveFocus(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def heightValid(self) -> bool: ...
    def hoverEnterEvent(self, event:PySide2.QtGui.QHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event:PySide2.QtGui.QHoverEvent) -> None: ...
    def hoverMoveEvent(self, event:PySide2.QtGui.QHoverEvent) -> None: ...
    def implicitHeight(self) -> float: ...
    def implicitWidth(self) -> float: ...
    def inputMethodEvent(self, arg__1:PySide2.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isAncestorOf(self, child:PySide2.QtQuick.QQuickItem) -> bool: ...
    def isComponentComplete(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isFocusScope(self) -> bool: ...
    def isTextureProvider(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def itemTransform(self, arg__1:PySide2.QtQuick.QQuickItem) -> typing.Tuple: ...
    def keepMouseGrab(self) -> bool: ...
    def keepTouchGrab(self) -> bool: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event:PySide2.QtGui.QKeyEvent) -> None: ...
    def mapFromGlobal(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapFromItem(self, item:PySide2.QtQuick.QQuickItem, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapFromScene(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapRectFromItem(self, item:PySide2.QtQuick.QQuickItem, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapRectFromScene(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapRectToItem(self, item:PySide2.QtQuick.QQuickItem, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapRectToScene(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapToGlobal(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapToItem(self, item:PySide2.QtQuick.QQuickItem, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mapToScene(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def mouseDoubleClickEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseUngrabEvent(self) -> None: ...
    def nextItemInFocusChain(self, forward:bool=...) -> PySide2.QtQuick.QQuickItem: ...
    def opacity(self) -> float: ...
    def parentItem(self) -> PySide2.QtQuick.QQuickItem: ...
    def polish(self) -> None: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def releaseResources(self) -> None: ...
    def resetAntialiasing(self) -> None: ...
    def resetHeight(self) -> None: ...
    def resetWidth(self) -> None: ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scopedFocusItem(self) -> PySide2.QtQuick.QQuickItem: ...
    def setAcceptHoverEvents(self, enabled:bool) -> None: ...
    def setAcceptTouchEvents(self, accept:bool) -> None: ...
    def setAcceptedMouseButtons(self, buttons:PySide2.QtCore.Qt.MouseButtons) -> None: ...
    def setActiveFocusOnTab(self, arg__1:bool) -> None: ...
    def setAntialiasing(self, arg__1:bool) -> None: ...
    def setBaselineOffset(self, arg__1:float) -> None: ...
    def setClip(self, arg__1:bool) -> None: ...
    def setContainmentMask(self, mask:PySide2.QtCore.QObject) -> None: ...
    def setCursor(self, cursor:typing.Union[PySide2.QtGui.QCursor, PySide2.QtCore.Qt.CursorShape]) -> None: ...
    def setEnabled(self, arg__1:bool) -> None: ...
    def setFiltersChildMouseEvents(self, filter:bool) -> None: ...
    def setFlag(self, flag:PySide2.QtQuick.QQuickItem.Flag, enabled:bool=...) -> None: ...
    def setFlags(self, flags:PySide2.QtQuick.QQuickItem.Flags) -> None: ...
    @typing.overload
    def setFocus(self, arg__1:bool) -> None: ...
    @typing.overload
    def setFocus(self, focus:bool, reason:PySide2.QtCore.Qt.FocusReason) -> None: ...
    def setHeight(self, arg__1:float) -> None: ...
    def setImplicitHeight(self, arg__1:float) -> None: ...
    def setImplicitSize(self, arg__1:float, arg__2:float) -> None: ...
    def setImplicitWidth(self, arg__1:float) -> None: ...
    def setKeepMouseGrab(self, arg__1:bool) -> None: ...
    def setKeepTouchGrab(self, arg__1:bool) -> None: ...
    def setOpacity(self, arg__1:float) -> None: ...
    def setParentItem(self, parent:PySide2.QtQuick.QQuickItem) -> None: ...
    def setPosition(self, arg__1:PySide2.QtCore.QPointF) -> None: ...
    def setRotation(self, arg__1:float) -> None: ...
    def setScale(self, arg__1:float) -> None: ...
    def setSize(self, size:PySide2.QtCore.QSizeF) -> None: ...
    def setSmooth(self, arg__1:bool) -> None: ...
    def setState(self, arg__1:str) -> None: ...
    def setTransformOrigin(self, arg__1:PySide2.QtQuick.QQuickItem.TransformOrigin) -> None: ...
    def setTransformOriginPoint(self, arg__1:PySide2.QtCore.QPointF) -> None: ...
    def setVisible(self, arg__1:bool) -> None: ...
    def setWidth(self, arg__1:float) -> None: ...
    def setX(self, arg__1:float) -> None: ...
    def setY(self, arg__1:float) -> None: ...
    def setZ(self, arg__1:float) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def smooth(self) -> bool: ...
    def stackAfter(self, arg__1:PySide2.QtQuick.QQuickItem) -> None: ...
    def stackBefore(self, arg__1:PySide2.QtQuick.QQuickItem) -> None: ...
    def state(self) -> str: ...
    def textureProvider(self) -> PySide2.QtQuick.QSGTextureProvider: ...
    def touchEvent(self, event:PySide2.QtGui.QTouchEvent) -> None: ...
    def touchUngrabEvent(self) -> None: ...
    def transformOrigin(self) -> PySide2.QtQuick.QQuickItem.TransformOrigin: ...
    def transformOriginPoint(self) -> PySide2.QtCore.QPointF: ...
    def ungrabMouse(self) -> None: ...
    def ungrabTouchPoints(self) -> None: ...
    def unsetCursor(self) -> None: ...
    def update(self) -> None: ...
    def updateInputMethod(self, queries:PySide2.QtCore.Qt.InputMethodQueries=...) -> None: ...
    def updatePaintNode(self, arg__1:PySide2.QtQuick.QSGNode, arg__2:PySide2.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide2.QtQuick.QSGNode: ...
    def updatePolish(self) -> None: ...
    def wheelEvent(self, event:PySide2.QtGui.QWheelEvent) -> None: ...
    def width(self) -> float: ...
    def widthValid(self) -> bool: ...
    def window(self) -> PySide2.QtQuick.QQuickWindow: ...
    def windowDeactivateEvent(self) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QQuickItemGrabResult(PySide2.QtCore.QObject):

    ready: PySide2.QtCore.Signal

    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def image(self) -> PySide2.QtGui.QImage: ...
    def saveToFile(self, fileName:str) -> bool: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QQuickPaintedItem(PySide2.QtQuick.QQuickItem):

    contentsScaleChanged: PySide2.QtCore.Signal
    contentsSizeChanged: PySide2.QtCore.Signal
    fillColorChanged: PySide2.QtCore.Signal
    renderTargetChanged: PySide2.QtCore.Signal
    textureSizeChanged: PySide2.QtCore.Signal

    Image                    : QQuickPaintedItem.RenderTarget = ... # 0x0
    FastFBOResizing          : QQuickPaintedItem.PerformanceHint = ... # 0x1
    FramebufferObject        : QQuickPaintedItem.RenderTarget = ... # 0x1
    InvertedYFramebufferObject: QQuickPaintedItem.RenderTarget = ... # 0x2

    class PerformanceHint(object):
        FastFBOResizing          : QQuickPaintedItem.PerformanceHint = ... # 0x1
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, PerformanceHint] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __and__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __xor__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __ror__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __rand__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __rxor__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __ior__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __iand__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __ixor__(self, other: typing.Union[int, PerformanceHint]) -> PerformanceHints: ...
        def __invert__(self) -> PerformanceHints: ...

    class PerformanceHints(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, PerformanceHint, PerformanceHints] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __and__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __xor__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __ror__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __rand__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __rxor__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __ior__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __iand__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __ixor__(self, other: typing.Union[int, PerformanceHint, PerformanceHints]) -> PerformanceHints: ...
        def __invert__(self) -> PerformanceHints: ...

    class RenderTarget(object):
        Image                    : QQuickPaintedItem.RenderTarget = ... # 0x0
        FramebufferObject        : QQuickPaintedItem.RenderTarget = ... # 0x1
        InvertedYFramebufferObject: QQuickPaintedItem.RenderTarget = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtQuick.QQuickItem]=...) -> None: ...

    def antialiasing(self) -> bool: ...
    def contentsBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contentsScale(self) -> float: ...
    def contentsSize(self) -> PySide2.QtCore.QSize: ...
    def fillColor(self) -> PySide2.QtGui.QColor: ...
    def isTextureProvider(self) -> bool: ...
    def mipmap(self) -> bool: ...
    def opaquePainting(self) -> bool: ...
    def paint(self, painter:PySide2.QtGui.QPainter) -> None: ...
    def performanceHints(self) -> PySide2.QtQuick.QQuickPaintedItem.PerformanceHints: ...
    def releaseResources(self) -> None: ...
    def renderTarget(self) -> PySide2.QtQuick.QQuickPaintedItem.RenderTarget: ...
    def resetContentsSize(self) -> None: ...
    def setAntialiasing(self, enable:bool) -> None: ...
    def setContentsScale(self, arg__1:float) -> None: ...
    def setContentsSize(self, arg__1:PySide2.QtCore.QSize) -> None: ...
    def setFillColor(self, arg__1: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setMipmap(self, enable:bool) -> None: ...
    def setOpaquePainting(self, opaque:bool) -> None: ...
    def setPerformanceHint(self, hint:PySide2.QtQuick.QQuickPaintedItem.PerformanceHint, enabled:bool=...) -> None: ...
    def setPerformanceHints(self, hints:PySide2.QtQuick.QQuickPaintedItem.PerformanceHints) -> None: ...
    def setRenderTarget(self, target:PySide2.QtQuick.QQuickPaintedItem.RenderTarget) -> None: ...
    def setTextureSize(self, size:PySide2.QtCore.QSize) -> None: ...
    def textureProvider(self) -> PySide2.QtQuick.QSGTextureProvider: ...
    def textureSize(self) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, rect:PySide2.QtCore.QRect=...) -> None: ...
    def updatePaintNode(self, arg__1:PySide2.QtQuick.QSGNode, arg__2:PySide2.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide2.QtQuick.QSGNode: ...


class QQuickRenderControl(PySide2.QtCore.QObject):

    renderRequested: PySide2.QtCore.Signal
    sceneChanged: PySide2.QtCore.Signal


    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def grab(self) -> PySide2.QtGui.QImage: ...
    def initialize(self, gl:PySide2.QtGui.QOpenGLContext) -> None: ...
    def invalidate(self) -> None: ...
    def polishItems(self) -> None: ...
    def prepareThread(self, targetThread:PySide2.QtCore.QThread) -> None: ...
    def render(self) -> None: ...
    def renderWindow(self, offset:PySide2.QtCore.QPoint) -> PySide2.QtGui.QWindow: ...
    @staticmethod
    def renderWindowFor(win:PySide2.QtQuick.QQuickWindow, offset:typing.Optional[PySide2.QtCore.QPoint]=...) -> PySide2.QtGui.QWindow: ...
    def sync(self) -> bool: ...


class QQuickTextDocument(PySide2.QtCore.QObject):

    def __init__(self, parent:PySide2.QtQuick.QQuickItem) -> None: ...

    def textDocument(self) -> PySide2.QtGui.QTextDocument: ...


class QQuickTextureFactory(PySide2.QtCore.QObject):

    def __init__(self) -> None: ...

    def createTexture(self, window:PySide2.QtQuick.QQuickWindow) -> PySide2.QtQuick.QSGTexture: ...
    def image(self) -> PySide2.QtGui.QImage: ...
    def textureByteCount(self) -> int: ...
    @staticmethod
    def textureFactoryForImage(image:PySide2.QtGui.QImage) -> PySide2.QtQuick.QQuickTextureFactory: ...
    def textureSize(self) -> PySide2.QtCore.QSize: ...


class QQuickTransform(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def appendToItem(self, arg__1:PySide2.QtQuick.QQuickItem) -> None: ...
    def applyTo(self, matrix:PySide2.QtGui.QMatrix4x4) -> None: ...
    def prependToItem(self, arg__1:PySide2.QtQuick.QQuickItem) -> None: ...
    def update(self) -> None: ...


class QQuickView(PySide2.QtQuick.QQuickWindow):

    statusChanged: PySide2.QtCore.Signal

    Null                     : QQuickView.Status = ... # 0x0
    SizeViewToRootObject     : QQuickView.ResizeMode = ... # 0x0
    Ready                    : QQuickView.Status = ... # 0x1
    SizeRootObjectToView     : QQuickView.ResizeMode = ... # 0x1
    Loading                  : QQuickView.Status = ... # 0x2
    Error                    : QQuickView.Status = ... # 0x3

    class ResizeMode(object):
        SizeViewToRootObject     : QQuickView.ResizeMode = ... # 0x0
        SizeRootObjectToView     : QQuickView.ResizeMode = ... # 0x1

    class Status(object):
        Null                     : QQuickView.Status = ... # 0x0
        Ready                    : QQuickView.Status = ... # 0x1
        Loading                  : QQuickView.Status = ... # 0x2
        Error                    : QQuickView.Status = ... # 0x3

    @typing.overload
    def __init__(self, engine:PySide2.QtQml.QQmlEngine, parent:PySide2.QtGui.QWindow) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...
    @typing.overload
    def __init__(self, source:PySide2.QtCore.QUrl, parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...
    @typing.overload
    def __init__(self, source:PySide2.QtCore.QUrl, renderControl:PySide2.QtQuick.QQuickRenderControl) -> None: ...

    def engine(self) -> PySide2.QtQml.QQmlEngine: ...
    def errors(self) -> typing.List: ...
    def initialSize(self) -> PySide2.QtCore.QSize: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1:PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeMode(self) -> PySide2.QtQuick.QQuickView.ResizeMode: ...
    def rootContext(self) -> PySide2.QtQml.QQmlContext: ...
    def rootObject(self) -> PySide2.QtQuick.QQuickItem: ...
    def setContent(self, url:PySide2.QtCore.QUrl, component:PySide2.QtQml.QQmlComponent, item:PySide2.QtCore.QObject) -> None: ...
    def setInitialProperties(self, initialProperties:typing.Dict) -> None: ...
    def setResizeMode(self, arg__1:PySide2.QtQuick.QQuickView.ResizeMode) -> None: ...
    def setSource(self, arg__1:PySide2.QtCore.QUrl) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def source(self) -> PySide2.QtCore.QUrl: ...
    def status(self) -> PySide2.QtQuick.QQuickView.Status: ...
    def timerEvent(self, arg__1:PySide2.QtCore.QTimerEvent) -> None: ...


class QQuickWindow(PySide2.QtGui.QWindow):

    activeFocusItemChanged: PySide2.QtCore.Signal
    afterAnimating: PySide2.QtCore.Signal
    afterRenderPassRecording: PySide2.QtCore.Signal
    afterRendering: PySide2.QtCore.Signal
    afterSynchronizing: PySide2.QtCore.Signal
    beforeRenderPassRecording: PySide2.QtCore.Signal
    beforeRendering: PySide2.QtCore.Signal
    beforeSynchronizing: PySide2.QtCore.Signal
    closing: PySide2.QtCore.Signal
    colorChanged: PySide2.QtCore.Signal
    frameSwapped: PySide2.QtCore.Signal
    openglContextCreated: PySide2.QtCore.Signal
    sceneGraphAboutToStop: PySide2.QtCore.Signal
    sceneGraphError: PySide2.QtCore.Signal
    sceneGraphInitialized: PySide2.QtCore.Signal
    sceneGraphInvalidated: PySide2.QtCore.Signal

    BeforeSynchronizingStage : QQuickWindow.RenderStage = ... # 0x0
    NativeObjectTexture      : QQuickWindow.NativeObjectType = ... # 0x0
    QtTextRendering          : QQuickWindow.TextRenderType = ... # 0x0
    AfterSynchronizingStage  : QQuickWindow.RenderStage = ... # 0x1
    ContextNotAvailable      : QQuickWindow.SceneGraphError = ... # 0x1
    NativeTextRendering      : QQuickWindow.TextRenderType = ... # 0x1
    TextureHasAlphaChannel   : QQuickWindow.CreateTextureOption = ... # 0x1
    BeforeRenderingStage     : QQuickWindow.RenderStage = ... # 0x2
    TextureHasMipmaps        : QQuickWindow.CreateTextureOption = ... # 0x2
    AfterRenderingStage      : QQuickWindow.RenderStage = ... # 0x3
    AfterSwapStage           : QQuickWindow.RenderStage = ... # 0x4
    TextureOwnsGLTexture     : QQuickWindow.CreateTextureOption = ... # 0x4
    NoStage                  : QQuickWindow.RenderStage = ... # 0x5
    TextureCanUseAtlas       : QQuickWindow.CreateTextureOption = ... # 0x8
    TextureIsOpaque          : QQuickWindow.CreateTextureOption = ... # 0x10

    class CreateTextureOption(object):
        TextureHasAlphaChannel   : QQuickWindow.CreateTextureOption = ... # 0x1
        TextureHasMipmaps        : QQuickWindow.CreateTextureOption = ... # 0x2
        TextureOwnsGLTexture     : QQuickWindow.CreateTextureOption = ... # 0x4
        TextureCanUseAtlas       : QQuickWindow.CreateTextureOption = ... # 0x8
        TextureIsOpaque          : QQuickWindow.CreateTextureOption = ... # 0x10
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, CreateTextureOption] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __and__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __xor__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __ror__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __rand__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __rxor__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __ior__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __iand__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __ixor__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __invert__(self) -> CreateTextureOptions: ...

    class CreateTextureOptions(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, CreateTextureOption, CreateTextureOptions] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __and__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __xor__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __ror__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __rand__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __rxor__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __ior__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __iand__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __ixor__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __invert__(self) -> CreateTextureOptions: ...

    class NativeObjectType(object):
        NativeObjectTexture      : QQuickWindow.NativeObjectType = ... # 0x0

    class RenderStage(object):
        BeforeSynchronizingStage : QQuickWindow.RenderStage = ... # 0x0
        AfterSynchronizingStage  : QQuickWindow.RenderStage = ... # 0x1
        BeforeRenderingStage     : QQuickWindow.RenderStage = ... # 0x2
        AfterRenderingStage      : QQuickWindow.RenderStage = ... # 0x3
        AfterSwapStage           : QQuickWindow.RenderStage = ... # 0x4
        NoStage                  : QQuickWindow.RenderStage = ... # 0x5

    class SceneGraphError(object):
        ContextNotAvailable      : QQuickWindow.SceneGraphError = ... # 0x1

    class TextRenderType(object):
        QtTextRendering          : QQuickWindow.TextRenderType = ... # 0x0
        NativeTextRendering      : QQuickWindow.TextRenderType = ... # 0x1

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...
    @typing.overload
    def __init__(self, renderControl:PySide2.QtQuick.QQuickRenderControl) -> None: ...

    def accessibleRoot(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def activeFocusItem(self) -> PySide2.QtQuick.QQuickItem: ...
    def beginExternalCommands(self) -> None: ...
    def clearBeforeRendering(self) -> bool: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def contentItem(self) -> PySide2.QtQuick.QQuickItem: ...
    def createTextureFromId(self, id:int, size:PySide2.QtCore.QSize, options:PySide2.QtQuick.QQuickWindow.CreateTextureOptions=...) -> PySide2.QtQuick.QSGTexture: ...
    @typing.overload
    def createTextureFromImage(self, image:PySide2.QtGui.QImage) -> PySide2.QtQuick.QSGTexture: ...
    @typing.overload
    def createTextureFromImage(self, image:PySide2.QtGui.QImage, options:PySide2.QtQuick.QQuickWindow.CreateTextureOptions) -> PySide2.QtQuick.QSGTexture: ...
    def createTextureFromNativeObject(self, type:PySide2.QtQuick.QQuickWindow.NativeObjectType, nativeObjectPtr:int, nativeLayout:int, size:PySide2.QtCore.QSize, options:PySide2.QtQuick.QQuickWindow.CreateTextureOptions=...) -> PySide2.QtQuick.QSGTexture: ...
    def effectiveDevicePixelRatio(self) -> float: ...
    def endExternalCommands(self) -> None: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1:PySide2.QtGui.QExposeEvent) -> None: ...
    def focusInEvent(self, arg__1:PySide2.QtGui.QFocusEvent) -> None: ...
    def focusObject(self) -> PySide2.QtCore.QObject: ...
    def focusOutEvent(self, arg__1:PySide2.QtGui.QFocusEvent) -> None: ...
    def grabWindow(self) -> PySide2.QtGui.QImage: ...
    @staticmethod
    def hasDefaultAlphaBuffer() -> bool: ...
    def hideEvent(self, arg__1:PySide2.QtGui.QHideEvent) -> None: ...
    def incubationController(self) -> PySide2.QtQml.QQmlIncubationController: ...
    def isPersistentOpenGLContext(self) -> bool: ...
    def isPersistentSceneGraph(self) -> bool: ...
    def isSceneGraphInitialized(self) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1:PySide2.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseGrabberItem(self) -> PySide2.QtQuick.QQuickItem: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def openglContext(self) -> PySide2.QtGui.QOpenGLContext: ...
    def releaseResources(self) -> None: ...
    def renderTarget(self) -> PySide2.QtGui.QOpenGLFramebufferObject: ...
    def renderTargetId(self) -> int: ...
    def renderTargetSize(self) -> PySide2.QtCore.QSize: ...
    def resetOpenGLState(self) -> None: ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent) -> None: ...
    @staticmethod
    def sceneGraphBackend() -> str: ...
    def scheduleRenderJob(self, job:PySide2.QtCore.QRunnable, schedule:PySide2.QtQuick.QQuickWindow.RenderStage) -> None: ...
    def sendEvent(self, arg__1:PySide2.QtQuick.QQuickItem, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def setClearBeforeRendering(self, enabled:bool) -> None: ...
    def setColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @staticmethod
    def setDefaultAlphaBuffer(useAlpha:bool) -> None: ...
    def setPersistentOpenGLContext(self, persistent:bool) -> None: ...
    def setPersistentSceneGraph(self, persistent:bool) -> None: ...
    @typing.overload
    def setRenderTarget(self, fbo:PySide2.QtGui.QOpenGLFramebufferObject) -> None: ...
    @typing.overload
    def setRenderTarget(self, fboId:int, size:PySide2.QtCore.QSize) -> None: ...
    @staticmethod
    def setSceneGraphBackend(backend:str) -> None: ...
    @staticmethod
    def setTextRenderType(renderType:PySide2.QtQuick.QQuickWindow.TextRenderType) -> None: ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent) -> None: ...
    def tabletEvent(self, arg__1:PySide2.QtGui.QTabletEvent) -> None: ...
    @staticmethod
    def textRenderType() -> PySide2.QtQuick.QQuickWindow.TextRenderType: ...
    def update(self) -> None: ...
    def wheelEvent(self, arg__1:PySide2.QtGui.QWheelEvent) -> None: ...


class QSGAbstractRenderer(PySide2.QtCore.QObject):

    sceneGraphChanged: PySide2.QtCore.Signal

    ClearColorBuffer         : QSGAbstractRenderer.ClearModeBit = ... # 0x1
    MatrixTransformFlipY     : QSGAbstractRenderer.MatrixTransformFlag = ... # 0x1
    ClearDepthBuffer         : QSGAbstractRenderer.ClearModeBit = ... # 0x2
    ClearStencilBuffer       : QSGAbstractRenderer.ClearModeBit = ... # 0x4

    class ClearMode(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, ClearModeBit, ClearMode] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __and__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __xor__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __ror__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __rand__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __rxor__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __ior__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __iand__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __ixor__(self, other: typing.Union[int, ClearModeBit, ClearMode]) -> ClearMode: ...
        def __invert__(self) -> ClearMode: ...

    class ClearModeBit(object):
        ClearColorBuffer         : QSGAbstractRenderer.ClearModeBit = ... # 0x1
        ClearDepthBuffer         : QSGAbstractRenderer.ClearModeBit = ... # 0x2
        ClearStencilBuffer       : QSGAbstractRenderer.ClearModeBit = ... # 0x4
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, ClearModeBit] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __and__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __xor__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __ror__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __rand__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __rxor__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __ior__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __iand__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __ixor__(self, other: typing.Union[int, ClearModeBit]) -> ClearMode: ...
        def __invert__(self) -> ClearMode: ...

    class MatrixTransformFlag(object):
        MatrixTransformFlipY     : QSGAbstractRenderer.MatrixTransformFlag = ... # 0x1
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, MatrixTransformFlag] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __and__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __xor__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __ror__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __rand__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __rxor__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __ior__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __iand__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __ixor__(self, other: typing.Union[int, MatrixTransformFlag]) -> MatrixTransformFlags: ...
        def __invert__(self) -> MatrixTransformFlags: ...

    class MatrixTransformFlags(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __and__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __xor__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __ror__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __rand__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __rxor__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __ior__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __iand__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __ixor__(self, other: typing.Union[int, MatrixTransformFlag, MatrixTransformFlags]) -> MatrixTransformFlags: ...
        def __invert__(self) -> MatrixTransformFlags: ...

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def clearColor(self) -> PySide2.QtGui.QColor: ...
    def clearMode(self) -> PySide2.QtQuick.QSGAbstractRenderer.ClearMode: ...
    def deviceRect(self) -> PySide2.QtCore.QRect: ...
    def nodeChanged(self, node:PySide2.QtQuick.QSGNode, state:PySide2.QtQuick.QSGNode.DirtyState) -> None: ...
    def projectionMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    def projectionMatrixWithNativeNDC(self) -> PySide2.QtGui.QMatrix4x4: ...
    def renderScene(self, fboId:int=...) -> None: ...
    def setClearColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setClearMode(self, mode:PySide2.QtQuick.QSGAbstractRenderer.ClearMode) -> None: ...
    @typing.overload
    def setDeviceRect(self, rect:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def setDeviceRect(self, size:PySide2.QtCore.QSize) -> None: ...
    def setProjectionMatrix(self, matrix:PySide2.QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setProjectionMatrixToRect(self, rect:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setProjectionMatrixToRect(self, rect:PySide2.QtCore.QRectF, flags:PySide2.QtQuick.QSGAbstractRenderer.MatrixTransformFlags) -> None: ...
    def setProjectionMatrixWithNativeNDC(self, matrix:PySide2.QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setViewportRect(self, rect:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def setViewportRect(self, size:PySide2.QtCore.QSize) -> None: ...
    def viewportRect(self) -> PySide2.QtCore.QRect: ...


class QSGBasicGeometryNode(PySide2.QtQuick.QSGNode):

    def __init__(self, type:PySide2.QtQuick.QSGNode.NodeType) -> None: ...

    def clipList(self) -> PySide2.QtQuick.QSGClipNode: ...
    def geometry(self) -> PySide2.QtQuick.QSGGeometry: ...
    def matrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    def setGeometry(self, geometry:PySide2.QtQuick.QSGGeometry) -> None: ...
    def setRendererClipList(self, c:PySide2.QtQuick.QSGClipNode) -> None: ...
    def setRendererMatrix(self, m:PySide2.QtGui.QMatrix4x4) -> None: ...


class QSGClipNode(PySide2.QtQuick.QSGBasicGeometryNode):

    def __init__(self) -> None: ...

    def clipRect(self) -> PySide2.QtCore.QRectF: ...
    def isRectangular(self) -> bool: ...
    def setClipRect(self, arg__1:PySide2.QtCore.QRectF) -> None: ...
    def setIsRectangular(self, rectHint:bool) -> None: ...


class QSGDynamicTexture(PySide2.QtQuick.QSGTexture):

    def __init__(self) -> None: ...

    def updateTexture(self) -> bool: ...


class QSGEngine(PySide2.QtCore.QObject):
    TextureHasAlphaChannel   : QSGEngine.CreateTextureOption = ... # 0x1
    TextureOwnsGLTexture     : QSGEngine.CreateTextureOption = ... # 0x4
    TextureCanUseAtlas       : QSGEngine.CreateTextureOption = ... # 0x8
    TextureIsOpaque          : QSGEngine.CreateTextureOption = ... # 0x10

    class CreateTextureOption(object):
        TextureHasAlphaChannel   : QSGEngine.CreateTextureOption = ... # 0x1
        TextureOwnsGLTexture     : QSGEngine.CreateTextureOption = ... # 0x4
        TextureCanUseAtlas       : QSGEngine.CreateTextureOption = ... # 0x8
        TextureIsOpaque          : QSGEngine.CreateTextureOption = ... # 0x10
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, CreateTextureOption] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __and__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __xor__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __ror__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __rand__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __rxor__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __ior__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __iand__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __ixor__(self, other: typing.Union[int, CreateTextureOption]) -> CreateTextureOptions: ...
        def __invert__(self) -> CreateTextureOptions: ...

    class CreateTextureOptions(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, CreateTextureOption, CreateTextureOptions] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __and__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __xor__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __ror__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __rand__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __rxor__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __ior__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __iand__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __ixor__(self, other: typing.Union[int, CreateTextureOption, CreateTextureOptions]) -> CreateTextureOptions: ...
        def __invert__(self) -> CreateTextureOptions: ...

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def createRenderer(self) -> PySide2.QtQuick.QSGAbstractRenderer: ...
    def createTextureFromId(self, id:int, size:PySide2.QtCore.QSize, options:PySide2.QtQuick.QSGEngine.CreateTextureOptions=...) -> PySide2.QtQuick.QSGTexture: ...
    def createTextureFromImage(self, image:PySide2.QtGui.QImage, options:PySide2.QtQuick.QSGEngine.CreateTextureOptions=...) -> PySide2.QtQuick.QSGTexture: ...
    def initialize(self, context:PySide2.QtGui.QOpenGLContext) -> None: ...
    def invalidate(self) -> None: ...


class QSGGeometry(Shiboken.Object):
    AlwaysUploadPattern      : QSGGeometry.DataPattern = ... # 0x0
    DrawPoints               : QSGGeometry.DrawingMode = ... # 0x0
    UnknownAttribute         : QSGGeometry.AttributeType = ... # 0x0
    DrawLines                : QSGGeometry.DrawingMode = ... # 0x1
    PositionAttribute        : QSGGeometry.AttributeType = ... # 0x1
    StreamPattern            : QSGGeometry.DataPattern = ... # 0x1
    ColorAttribute           : QSGGeometry.AttributeType = ... # 0x2
    DrawLineLoop             : QSGGeometry.DrawingMode = ... # 0x2
    DynamicPattern           : QSGGeometry.DataPattern = ... # 0x2
    DrawLineStrip            : QSGGeometry.DrawingMode = ... # 0x3
    StaticPattern            : QSGGeometry.DataPattern = ... # 0x3
    TexCoordAttribute        : QSGGeometry.AttributeType = ... # 0x3
    DrawTriangles            : QSGGeometry.DrawingMode = ... # 0x4
    TexCoord1Attribute       : QSGGeometry.AttributeType = ... # 0x4
    DrawTriangleStrip        : QSGGeometry.DrawingMode = ... # 0x5
    TexCoord2Attribute       : QSGGeometry.AttributeType = ... # 0x5
    DrawTriangleFan          : QSGGeometry.DrawingMode = ... # 0x6
    ByteType                 : QSGGeometry.Type = ... # 0x1400
    UnsignedByteType         : QSGGeometry.Type = ... # 0x1401
    ShortType                : QSGGeometry.Type = ... # 0x1402
    UnsignedShortType        : QSGGeometry.Type = ... # 0x1403
    IntType                  : QSGGeometry.Type = ... # 0x1404
    UnsignedIntType          : QSGGeometry.Type = ... # 0x1405
    FloatType                : QSGGeometry.Type = ... # 0x1406
    Bytes2Type               : QSGGeometry.Type = ... # 0x1407
    Bytes3Type               : QSGGeometry.Type = ... # 0x1408
    Bytes4Type               : QSGGeometry.Type = ... # 0x1409
    DoubleType               : QSGGeometry.Type = ... # 0x140a

    class Attribute(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Attribute:PySide2.QtQuick.QSGGeometry.Attribute) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        @staticmethod
        def create(pos:int, tupleSize:int, primitiveType:int, isPosition:bool=...) -> PySide2.QtQuick.QSGGeometry.Attribute: ...
        @staticmethod
        def createWithAttributeType(pos:int, tupleSize:int, primitiveType:int, attributeType:PySide2.QtQuick.QSGGeometry.AttributeType) -> PySide2.QtQuick.QSGGeometry.Attribute: ...

    class AttributeSet(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, AttributeSet:PySide2.QtQuick.QSGGeometry.AttributeSet) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class AttributeType(object):
        UnknownAttribute         : QSGGeometry.AttributeType = ... # 0x0
        PositionAttribute        : QSGGeometry.AttributeType = ... # 0x1
        ColorAttribute           : QSGGeometry.AttributeType = ... # 0x2
        TexCoordAttribute        : QSGGeometry.AttributeType = ... # 0x3
        TexCoord1Attribute       : QSGGeometry.AttributeType = ... # 0x4
        TexCoord2Attribute       : QSGGeometry.AttributeType = ... # 0x5

    class ColoredPoint2D(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, ColoredPoint2D:PySide2.QtQuick.QSGGeometry.ColoredPoint2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx:float, ny:float, nr:int, ng:int, nb:int, na:int) -> None: ...

    class DataPattern(object):
        AlwaysUploadPattern      : QSGGeometry.DataPattern = ... # 0x0
        StreamPattern            : QSGGeometry.DataPattern = ... # 0x1
        DynamicPattern           : QSGGeometry.DataPattern = ... # 0x2
        StaticPattern            : QSGGeometry.DataPattern = ... # 0x3

    class DrawingMode(object):
        DrawPoints               : QSGGeometry.DrawingMode = ... # 0x0
        DrawLines                : QSGGeometry.DrawingMode = ... # 0x1
        DrawLineLoop             : QSGGeometry.DrawingMode = ... # 0x2
        DrawLineStrip            : QSGGeometry.DrawingMode = ... # 0x3
        DrawTriangles            : QSGGeometry.DrawingMode = ... # 0x4
        DrawTriangleStrip        : QSGGeometry.DrawingMode = ... # 0x5
        DrawTriangleFan          : QSGGeometry.DrawingMode = ... # 0x6

    class Point2D(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Point2D:PySide2.QtQuick.QSGGeometry.Point2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx:float, ny:float) -> None: ...

    class TexturedPoint2D(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, TexturedPoint2D:PySide2.QtQuick.QSGGeometry.TexturedPoint2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx:float, ny:float, ntx:float, nty:float) -> None: ...

    class Type(object):
        ByteType                 : QSGGeometry.Type = ... # 0x1400
        UnsignedByteType         : QSGGeometry.Type = ... # 0x1401
        ShortType                : QSGGeometry.Type = ... # 0x1402
        UnsignedShortType        : QSGGeometry.Type = ... # 0x1403
        IntType                  : QSGGeometry.Type = ... # 0x1404
        UnsignedIntType          : QSGGeometry.Type = ... # 0x1405
        FloatType                : QSGGeometry.Type = ... # 0x1406
        Bytes2Type               : QSGGeometry.Type = ... # 0x1407
        Bytes3Type               : QSGGeometry.Type = ... # 0x1408
        Bytes4Type               : QSGGeometry.Type = ... # 0x1409
        DoubleType               : QSGGeometry.Type = ... # 0x140a

    def __init__(self, attribs:PySide2.QtQuick.QSGGeometry.AttributeSet, vertexCount:int, indexCount:int=..., indexType:int=...) -> None: ...

    def allocate(self, vertexCount:int, indexCount:int=...) -> None: ...
    def attributeCount(self) -> int: ...
    def attributes(self) -> PySide2.QtQuick.QSGGeometry.Attribute: ...
    @staticmethod
    def defaultAttributes_ColoredPoint2D() -> PySide2.QtQuick.QSGGeometry.AttributeSet: ...
    @staticmethod
    def defaultAttributes_Point2D() -> PySide2.QtQuick.QSGGeometry.AttributeSet: ...
    @staticmethod
    def defaultAttributes_TexturedPoint2D() -> PySide2.QtQuick.QSGGeometry.AttributeSet: ...
    def drawingMode(self) -> int: ...
    def indexCount(self) -> int: ...
    def indexData(self) -> int: ...
    def indexDataAsUInt(self) -> typing.List: ...
    def indexDataAsUShort(self) -> typing.List: ...
    def indexDataPattern(self) -> PySide2.QtQuick.QSGGeometry.DataPattern: ...
    def indexType(self) -> int: ...
    def lineWidth(self) -> float: ...
    def markIndexDataDirty(self) -> None: ...
    def markVertexDataDirty(self) -> None: ...
    def setDrawingMode(self, mode:int) -> None: ...
    def setIndexDataPattern(self, p:PySide2.QtQuick.QSGGeometry.DataPattern) -> None: ...
    def setLineWidth(self, w:float) -> None: ...
    def setVertexDataPattern(self, p:PySide2.QtQuick.QSGGeometry.DataPattern) -> None: ...
    def sizeOfIndex(self) -> int: ...
    def sizeOfVertex(self) -> int: ...
    @staticmethod
    def updateColoredRectGeometry(g:PySide2.QtQuick.QSGGeometry, rect:PySide2.QtCore.QRectF) -> None: ...
    @staticmethod
    def updateRectGeometry(g:PySide2.QtQuick.QSGGeometry, rect:PySide2.QtCore.QRectF) -> None: ...
    @staticmethod
    def updateTexturedRectGeometry(g:PySide2.QtQuick.QSGGeometry, rect:PySide2.QtCore.QRectF, sourceRect:PySide2.QtCore.QRectF) -> None: ...
    def vertexCount(self) -> int: ...
    def vertexData(self) -> int: ...
    def vertexDataAsColoredPoint2D(self) -> PySide2.QtQuick.QSGGeometry.ColoredPoint2D: ...
    def vertexDataAsPoint2D(self) -> PySide2.QtQuick.QSGGeometry.Point2D: ...
    def vertexDataAsTexturedPoint2D(self) -> PySide2.QtQuick.QSGGeometry.TexturedPoint2D: ...
    def vertexDataPattern(self) -> PySide2.QtQuick.QSGGeometry.DataPattern: ...


class QSGGeometryNode(PySide2.QtQuick.QSGBasicGeometryNode):

    def __init__(self) -> None: ...

    def inheritedOpacity(self) -> float: ...
    def renderOrder(self) -> int: ...
    def setInheritedOpacity(self, opacity:float) -> None: ...
    def setRenderOrder(self, order:int) -> None: ...


class QSGMaterialType(Shiboken.Object):

    def __init__(self) -> None: ...


class QSGNode(Shiboken.Object):
    BasicNodeType            : QSGNode.NodeType = ... # 0x0
    GeometryNodeType         : QSGNode.NodeType = ... # 0x1
    OwnedByParent            : QSGNode.Flag = ... # 0x1
    DirtyUsePreprocess       : QSGNode.DirtyStateBit = ... # 0x2
    TransformNodeType        : QSGNode.NodeType = ... # 0x2
    UsePreprocess            : QSGNode.Flag = ... # 0x2
    ClipNodeType             : QSGNode.NodeType = ... # 0x3
    OpacityNodeType          : QSGNode.NodeType = ... # 0x4
    RootNodeType             : QSGNode.NodeType = ... # 0x5
    RenderNodeType           : QSGNode.NodeType = ... # 0x6
    DirtySubtreeBlocked      : QSGNode.DirtyStateBit = ... # 0x80
    DirtyMatrix              : QSGNode.DirtyStateBit = ... # 0x100
    DirtyNodeAdded           : QSGNode.DirtyStateBit = ... # 0x400
    DirtyNodeRemoved         : QSGNode.DirtyStateBit = ... # 0x800
    DirtyGeometry            : QSGNode.DirtyStateBit = ... # 0x1000
    DirtyMaterial            : QSGNode.DirtyStateBit = ... # 0x2000
    DirtyOpacity             : QSGNode.DirtyStateBit = ... # 0x4000
    DirtyForceUpdate         : QSGNode.DirtyStateBit = ... # 0x8000
    DirtyPropagationMask     : QSGNode.DirtyStateBit = ... # 0xc500
    OwnsGeometry             : QSGNode.Flag = ... # 0x10000
    OwnsMaterial             : QSGNode.Flag = ... # 0x20000
    OwnsOpaqueMaterial       : QSGNode.Flag = ... # 0x40000
    IsVisitableNode          : QSGNode.Flag = ... # 0x1000000

    class DirtyState(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, DirtyStateBit, DirtyState] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __and__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __xor__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __ror__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __rand__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __rxor__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __ior__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __iand__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __ixor__(self, other: typing.Union[int, DirtyStateBit, DirtyState]) -> DirtyState: ...
        def __invert__(self) -> DirtyState: ...

    class DirtyStateBit(object):
        DirtyUsePreprocess       : QSGNode.DirtyStateBit = ... # 0x2
        DirtySubtreeBlocked      : QSGNode.DirtyStateBit = ... # 0x80
        DirtyMatrix              : QSGNode.DirtyStateBit = ... # 0x100
        DirtyNodeAdded           : QSGNode.DirtyStateBit = ... # 0x400
        DirtyNodeRemoved         : QSGNode.DirtyStateBit = ... # 0x800
        DirtyGeometry            : QSGNode.DirtyStateBit = ... # 0x1000
        DirtyMaterial            : QSGNode.DirtyStateBit = ... # 0x2000
        DirtyOpacity             : QSGNode.DirtyStateBit = ... # 0x4000
        DirtyForceUpdate         : QSGNode.DirtyStateBit = ... # 0x8000
        DirtyPropagationMask     : QSGNode.DirtyStateBit = ... # 0xc500
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, DirtyStateBit] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __and__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __xor__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __ror__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __rand__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __rxor__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __ior__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __iand__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __ixor__(self, other: typing.Union[int, DirtyStateBit]) -> DirtyState: ...
        def __invert__(self) -> DirtyState: ...

    class Flag(object):
        OwnedByParent            : QSGNode.Flag = ... # 0x1
        UsePreprocess            : QSGNode.Flag = ... # 0x2
        OwnsGeometry             : QSGNode.Flag = ... # 0x10000
        OwnsMaterial             : QSGNode.Flag = ... # 0x20000
        OwnsOpaqueMaterial       : QSGNode.Flag = ... # 0x40000
        IsVisitableNode          : QSGNode.Flag = ... # 0x1000000
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, Flag] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __and__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __xor__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __ror__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __rand__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __rxor__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __ior__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __iand__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __ixor__(self, other: typing.Union[int, Flag]) -> Flags: ...
        def __invert__(self) -> Flags: ...

    class Flags(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, Flag, Flags] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __and__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __xor__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __ror__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __rand__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __rxor__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __ior__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __iand__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __ixor__(self, other: typing.Union[int, Flag, Flags]) -> Flags: ...
        def __invert__(self) -> Flags: ...

    class NodeType(object):
        BasicNodeType            : QSGNode.NodeType = ... # 0x0
        GeometryNodeType         : QSGNode.NodeType = ... # 0x1
        TransformNodeType        : QSGNode.NodeType = ... # 0x2
        ClipNodeType             : QSGNode.NodeType = ... # 0x3
        OpacityNodeType          : QSGNode.NodeType = ... # 0x4
        RootNodeType             : QSGNode.NodeType = ... # 0x5
        RenderNodeType           : QSGNode.NodeType = ... # 0x6

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtQuick.QSGNode.NodeType) -> None: ...

    def appendChildNode(self, node:PySide2.QtQuick.QSGNode) -> None: ...
    def childAtIndex(self, i:int) -> PySide2.QtQuick.QSGNode: ...
    def childCount(self) -> int: ...
    def clearDirty(self) -> None: ...
    def dirtyState(self) -> PySide2.QtQuick.QSGNode.DirtyState: ...
    def firstChild(self) -> PySide2.QtQuick.QSGNode: ...
    def flags(self) -> PySide2.QtQuick.QSGNode.Flags: ...
    def insertChildNodeAfter(self, node:PySide2.QtQuick.QSGNode, after:PySide2.QtQuick.QSGNode) -> None: ...
    def insertChildNodeBefore(self, node:PySide2.QtQuick.QSGNode, before:PySide2.QtQuick.QSGNode) -> None: ...
    def isSubtreeBlocked(self) -> bool: ...
    def lastChild(self) -> PySide2.QtQuick.QSGNode: ...
    def markDirty(self, bits:PySide2.QtQuick.QSGNode.DirtyState) -> None: ...
    def nextSibling(self) -> PySide2.QtQuick.QSGNode: ...
    def parent(self) -> PySide2.QtQuick.QSGNode: ...
    def prependChildNode(self, node:PySide2.QtQuick.QSGNode) -> None: ...
    def preprocess(self) -> None: ...
    def previousSibling(self) -> PySide2.QtQuick.QSGNode: ...
    def removeAllChildNodes(self) -> None: ...
    def removeChildNode(self, node:PySide2.QtQuick.QSGNode) -> None: ...
    def reparentChildNodesTo(self, newParent:PySide2.QtQuick.QSGNode) -> None: ...
    def setFlag(self, arg__1:PySide2.QtQuick.QSGNode.Flag, arg__2:bool=...) -> None: ...
    def setFlags(self, arg__1:PySide2.QtQuick.QSGNode.Flags, arg__2:bool=...) -> None: ...
    def type(self) -> PySide2.QtQuick.QSGNode.NodeType: ...


class QSGOpacityNode(PySide2.QtQuick.QSGNode):

    def __init__(self) -> None: ...

    def combinedOpacity(self) -> float: ...
    def isSubtreeBlocked(self) -> bool: ...
    def opacity(self) -> float: ...
    def setCombinedOpacity(self, opacity:float) -> None: ...
    def setOpacity(self, opacity:float) -> None: ...


class QSGSimpleRectNode(PySide2.QtQuick.QSGGeometryNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, rect:PySide2.QtCore.QRectF, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...

    def color(self) -> PySide2.QtGui.QColor: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @typing.overload
    def setRect(self, rect:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, x:float, y:float, w:float, h:float) -> None: ...


class QSGSimpleTextureNode(PySide2.QtQuick.QSGGeometryNode):
    NoTransform              : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x0
    MirrorHorizontally       : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x1
    MirrorVertically         : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x2

    class TextureCoordinatesTransformFlag(object):
        NoTransform              : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x0
        MirrorHorizontally       : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x1
        MirrorVertically         : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x2
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, TextureCoordinatesTransformFlag] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __and__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __xor__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __ror__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __rand__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __rxor__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __ior__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __iand__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __ixor__(self, other: typing.Union[int, TextureCoordinatesTransformFlag]) -> TextureCoordinatesTransformMode: ...
        def __invert__(self) -> TextureCoordinatesTransformMode: ...

    class TextureCoordinatesTransformMode(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __and__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __xor__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __ror__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __rand__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __rxor__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __ior__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __iand__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __ixor__(self, other: typing.Union[int, TextureCoordinatesTransformFlag, TextureCoordinatesTransformMode]) -> TextureCoordinatesTransformMode: ...
        def __invert__(self) -> TextureCoordinatesTransformMode: ...

    def __init__(self) -> None: ...

    def filtering(self) -> PySide2.QtQuick.QSGTexture.Filtering: ...
    def ownsTexture(self) -> bool: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setFiltering(self, filtering:PySide2.QtQuick.QSGTexture.Filtering) -> None: ...
    def setOwnsTexture(self, owns:bool) -> None: ...
    @typing.overload
    def setRect(self, rect:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, x:float, y:float, w:float, h:float) -> None: ...
    @typing.overload
    def setSourceRect(self, r:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def setSourceRect(self, x:float, y:float, w:float, h:float) -> None: ...
    def setTexture(self, texture:PySide2.QtQuick.QSGTexture) -> None: ...
    def setTextureCoordinatesTransform(self, mode:PySide2.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode) -> None: ...
    def sourceRect(self) -> PySide2.QtCore.QRectF: ...
    def texture(self) -> PySide2.QtQuick.QSGTexture: ...
    def textureCoordinatesTransform(self) -> PySide2.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode: ...


class QSGTexture(PySide2.QtCore.QObject):
    AnisotropyNone           : QSGTexture.AnisotropyLevel = ... # 0x0
    None_                    : QSGTexture.Filtering = ... # 0x0
    Repeat                   : QSGTexture.WrapMode = ... # 0x0
    Anisotropy2x             : QSGTexture.AnisotropyLevel = ... # 0x1
    ClampToEdge              : QSGTexture.WrapMode = ... # 0x1
    Nearest                  : QSGTexture.Filtering = ... # 0x1
    Anisotropy4x             : QSGTexture.AnisotropyLevel = ... # 0x2
    Linear                   : QSGTexture.Filtering = ... # 0x2
    MirroredRepeat           : QSGTexture.WrapMode = ... # 0x2
    Anisotropy8x             : QSGTexture.AnisotropyLevel = ... # 0x3
    Anisotropy16x            : QSGTexture.AnisotropyLevel = ... # 0x4

    class AnisotropyLevel(object):
        AnisotropyNone           : QSGTexture.AnisotropyLevel = ... # 0x0
        Anisotropy2x             : QSGTexture.AnisotropyLevel = ... # 0x1
        Anisotropy4x             : QSGTexture.AnisotropyLevel = ... # 0x2
        Anisotropy8x             : QSGTexture.AnisotropyLevel = ... # 0x3
        Anisotropy16x            : QSGTexture.AnisotropyLevel = ... # 0x4

    class Filtering(object):
        None_                    : QSGTexture.Filtering = ... # 0x0
        Nearest                  : QSGTexture.Filtering = ... # 0x1
        Linear                   : QSGTexture.Filtering = ... # 0x2

    class WrapMode(object):
        Repeat                   : QSGTexture.WrapMode = ... # 0x0
        ClampToEdge              : QSGTexture.WrapMode = ... # 0x1
        MirroredRepeat           : QSGTexture.WrapMode = ... # 0x2

    def __init__(self) -> None: ...

    def anisotropyLevel(self) -> PySide2.QtQuick.QSGTexture.AnisotropyLevel: ...
    def bind(self) -> None: ...
    def comparisonKey(self) -> int: ...
    def convertToNormalizedSourceRect(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def filtering(self) -> PySide2.QtQuick.QSGTexture.Filtering: ...
    def hasAlphaChannel(self) -> bool: ...
    def hasMipmaps(self) -> bool: ...
    def horizontalWrapMode(self) -> PySide2.QtQuick.QSGTexture.WrapMode: ...
    def isAtlasTexture(self) -> bool: ...
    def mipmapFiltering(self) -> PySide2.QtQuick.QSGTexture.Filtering: ...
    def normalizedTextureSubRect(self) -> PySide2.QtCore.QRectF: ...
    def removedFromAtlas(self) -> PySide2.QtQuick.QSGTexture: ...
    def setAnisotropyLevel(self, level:PySide2.QtQuick.QSGTexture.AnisotropyLevel) -> None: ...
    def setFiltering(self, filter:PySide2.QtQuick.QSGTexture.Filtering) -> None: ...
    def setHorizontalWrapMode(self, hwrap:PySide2.QtQuick.QSGTexture.WrapMode) -> None: ...
    def setMipmapFiltering(self, filter:PySide2.QtQuick.QSGTexture.Filtering) -> None: ...
    def setVerticalWrapMode(self, vwrap:PySide2.QtQuick.QSGTexture.WrapMode) -> None: ...
    def textureId(self) -> int: ...
    def textureSize(self) -> PySide2.QtCore.QSize: ...
    def updateBindOptions(self, force:bool=...) -> None: ...
    def verticalWrapMode(self) -> PySide2.QtQuick.QSGTexture.WrapMode: ...


class QSGTextureProvider(PySide2.QtCore.QObject):

    textureChanged: PySide2.QtCore.Signal


    def __init__(self) -> None: ...

    def texture(self) -> PySide2.QtQuick.QSGTexture: ...


class QSGTransformNode(PySide2.QtQuick.QSGNode):

    def __init__(self) -> None: ...

    def combinedMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    def matrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    def setCombinedMatrix(self, matrix:PySide2.QtGui.QMatrix4x4) -> None: ...
    def setMatrix(self, matrix:PySide2.QtGui.QMatrix4x4) -> None: ...

# eof
