# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtMultimediaWidgets, except for defaults which are replaced by "...".
"""

import sys

# Module PySide2.QtMultimediaWidgets
import PySide2
import typing

import shiboken2 as Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import PySide2.QtMultimedia
import PySide2.QtMultimediaWidgets


class QCameraViewfinder(PySide2.QtMultimediaWidgets.QVideoWidget):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> None: ...

    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def setMediaObject(self, object:PySide2.QtMultimedia.QMediaObject) -> bool: ...


class QGraphicsVideoItem(PySide2.QtWidgets.QGraphicsObject, PySide2.QtMultimedia.QMediaBindableInterface):

    nativeSizeChanged: PySide2.QtCore.Signal


    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...) -> None: ...

    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def itemChange(self, change:PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value:typing.Any) -> typing.Any: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def nativeSize(self) -> PySide2.QtCore.QSizeF: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> None: ...
    def setAspectRatioMode(self, mode:PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setMediaObject(self, object:PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def setOffset(self, offset:PySide2.QtCore.QPointF) -> None: ...
    def setSize(self, size:PySide2.QtCore.QSizeF) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def timerEvent(self, event:PySide2.QtCore.QTimerEvent) -> None: ...
    def videoSurface(self) -> PySide2.QtMultimedia.QAbstractVideoSurface: ...


class QVideoWidget(PySide2.QtWidgets.QWidget, PySide2.QtMultimedia.QMediaBindableInterface):

    brightnessChanged: PySide2.QtCore.Signal
    contrastChanged: PySide2.QtCore.Signal
    fullScreenChanged: PySide2.QtCore.Signal
    hueChanged: PySide2.QtCore.Signal
    saturationChanged: PySide2.QtCore.Signal


    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> None: ...

    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def brightness(self) -> int: ...
    def contrast(self) -> int: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, event:PySide2.QtGui.QHideEvent) -> None: ...
    def hue(self) -> int: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def moveEvent(self, event:PySide2.QtGui.QMoveEvent) -> None: ...
    if sys.platform() == 'win32':
        def nativeEvent(self, eventType:PySide2.QtCore.QByteArray, message:int) -> typing.Tuple: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent) -> None: ...
    def saturation(self) -> int: ...
    def setAspectRatioMode(self, mode:PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setBrightness(self, brightness:int) -> None: ...
    def setContrast(self, contrast:int) -> None: ...
    def setFullScreen(self, fullScreen:bool) -> None: ...
    def setHue(self, hue:int) -> None: ...
    def setMediaObject(self, object:PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def setSaturation(self, saturation:int) -> None: ...
    def showEvent(self, event:PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def videoSurface(self) -> PySide2.QtMultimedia.QAbstractVideoSurface: ...


class QVideoWidgetControl(PySide2.QtMultimedia.QMediaControl):

    brightnessChanged: PySide2.QtCore.Signal
    contrastChanged: PySide2.QtCore.Signal
    fullScreenChanged: PySide2.QtCore.Signal
    hueChanged: PySide2.QtCore.Signal
    saturationChanged: PySide2.QtCore.Signal


    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def brightness(self) -> int: ...
    def contrast(self) -> int: ...
    def hue(self) -> int: ...
    def isFullScreen(self) -> bool: ...
    def saturation(self) -> int: ...
    def setAspectRatioMode(self, mode:PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setBrightness(self, brightness:int) -> None: ...
    def setContrast(self, contrast:int) -> None: ...
    def setFullScreen(self, fullScreen:bool) -> None: ...
    def setHue(self, hue:int) -> None: ...
    def setSaturation(self, saturation:int) -> None: ...
    def videoWidget(self) -> PySide2.QtWidgets.QWidget: ...

# eof
