# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtDataVisualization, except for defaults which are replaced by "...".
"""

# Module PySide2.QtDataVisualization
import PySide2
import typing

import shiboken2 as Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtDataVisualization


class QtDataVisualization(Shiboken.Object):

    class Q3DBars(PySide2.QtDataVisualization.QAbstract3DGraph):

        barSpacingChanged: PySide2.QtCore.Signal
        barSpacingRelativeChanged: PySide2.QtCore.Signal
        barThicknessChanged: PySide2.QtCore.Signal
        columnAxisChanged: PySide2.QtCore.Signal
        floorLevelChanged: PySide2.QtCore.Signal
        multiSeriesUniformChanged: PySide2.QtCore.Signal
        primarySeriesChanged: PySide2.QtCore.Signal
        rowAxisChanged: PySide2.QtCore.Signal
        selectedSeriesChanged: PySide2.QtCore.Signal
        valueAxisChanged: PySide2.QtCore.Signal


        def __init__(self, format:typing.Optional[PySide2.QtGui.QSurfaceFormat]=..., parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...

        def addAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis) -> None: ...
        def addSeries(self, series:PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries) -> None: ...
        def axes(self) -> typing.List: ...
        def barSpacing(self) -> PySide2.QtCore.QSizeF: ...
        def barThickness(self) -> float: ...
        def columnAxis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QCategory3DAxis: ...
        def floorLevel(self) -> float: ...
        def insertSeries(self, index:int, series:PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries) -> None: ...
        def isBarSpacingRelative(self) -> bool: ...
        def isMultiSeriesUniform(self) -> bool: ...
        def primarySeries(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries: ...
        def releaseAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis) -> None: ...
        def removeSeries(self, series:PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries) -> None: ...
        def rowAxis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QCategory3DAxis: ...
        def selectedSeries(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries: ...
        def seriesList(self) -> typing.List: ...
        def setBarSpacing(self, spacing:PySide2.QtCore.QSizeF) -> None: ...
        def setBarSpacingRelative(self, relative:bool) -> None: ...
        def setBarThickness(self, thicknessRatio:float) -> None: ...
        def setColumnAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QCategory3DAxis) -> None: ...
        def setFloorLevel(self, level:float) -> None: ...
        def setMultiSeriesUniform(self, uniform:bool) -> None: ...
        def setPrimarySeries(self, series:PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries) -> None: ...
        def setRowAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QCategory3DAxis) -> None: ...
        def setValueAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def valueAxis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...

    class Q3DCamera(PySide2.QtDataVisualization.Q3DObject):

        cameraPresetChanged: PySide2.QtCore.Signal
        maxZoomLevelChanged: PySide2.QtCore.Signal
        minZoomLevelChanged: PySide2.QtCore.Signal
        targetChanged: PySide2.QtCore.Signal
        wrapXRotationChanged: PySide2.QtCore.Signal
        wrapYRotationChanged: PySide2.QtCore.Signal
        xRotationChanged: PySide2.QtCore.Signal
        yRotationChanged: PySide2.QtCore.Signal
        zoomLevelChanged: PySide2.QtCore.Signal

        CameraPresetNone         : QtDataVisualization.Q3DCamera.CameraPreset = ... # -0x1
        CameraPresetFrontLow     : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x0
        CameraPresetFront        : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x1
        CameraPresetFrontHigh    : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x2
        CameraPresetLeftLow      : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x3
        CameraPresetLeft         : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x4
        CameraPresetLeftHigh     : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x5
        CameraPresetRightLow     : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x6
        CameraPresetRight        : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x7
        CameraPresetRightHigh    : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x8
        CameraPresetBehindLow    : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x9
        CameraPresetBehind       : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xa
        CameraPresetBehindHigh   : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xb
        CameraPresetIsometricLeft: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xc
        CameraPresetIsometricLeftHigh: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xd
        CameraPresetIsometricRight: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xe
        CameraPresetIsometricRightHigh: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xf
        CameraPresetDirectlyAbove: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x10
        CameraPresetDirectlyAboveCW45: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x11
        CameraPresetDirectlyAboveCCW45: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x12
        CameraPresetFrontBelow   : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x13
        CameraPresetLeftBelow    : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x14
        CameraPresetRightBelow   : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x15
        CameraPresetBehindBelow  : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x16
        CameraPresetDirectlyBelow: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x17

        class CameraPreset(object):
            CameraPresetNone         : QtDataVisualization.Q3DCamera.CameraPreset = ... # -0x1
            CameraPresetFrontLow     : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x0
            CameraPresetFront        : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x1
            CameraPresetFrontHigh    : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x2
            CameraPresetLeftLow      : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x3
            CameraPresetLeft         : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x4
            CameraPresetLeftHigh     : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x5
            CameraPresetRightLow     : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x6
            CameraPresetRight        : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x7
            CameraPresetRightHigh    : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x8
            CameraPresetBehindLow    : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x9
            CameraPresetBehind       : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xa
            CameraPresetBehindHigh   : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xb
            CameraPresetIsometricLeft: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xc
            CameraPresetIsometricLeftHigh: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xd
            CameraPresetIsometricRight: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xe
            CameraPresetIsometricRightHigh: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0xf
            CameraPresetDirectlyAbove: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x10
            CameraPresetDirectlyAboveCW45: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x11
            CameraPresetDirectlyAboveCCW45: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x12
            CameraPresetFrontBelow   : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x13
            CameraPresetLeftBelow    : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x14
            CameraPresetRightBelow   : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x15
            CameraPresetBehindBelow  : QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x16
            CameraPresetDirectlyBelow: QtDataVisualization.Q3DCamera.CameraPreset = ... # 0x17

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def cameraPreset(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.CameraPreset: ...
        def copyValuesFrom(self, source:PySide2.QtDataVisualization.QtDataVisualization.Q3DObject) -> None: ...
        def maxZoomLevel(self) -> float: ...
        def minZoomLevel(self) -> float: ...
        def setCameraPosition(self, horizontal:float, vertical:float, zoom:float=...) -> None: ...
        def setCameraPreset(self, preset:PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera.CameraPreset) -> None: ...
        def setMaxZoomLevel(self, zoomLevel:float) -> None: ...
        def setMinZoomLevel(self, zoomLevel:float) -> None: ...
        def setTarget(self, target:PySide2.QtGui.QVector3D) -> None: ...
        def setWrapXRotation(self, isEnabled:bool) -> None: ...
        def setWrapYRotation(self, isEnabled:bool) -> None: ...
        def setXRotation(self, rotation:float) -> None: ...
        def setYRotation(self, rotation:float) -> None: ...
        def setZoomLevel(self, zoomLevel:float) -> None: ...
        def target(self) -> PySide2.QtGui.QVector3D: ...
        def wrapXRotation(self) -> bool: ...
        def wrapYRotation(self) -> bool: ...
        def xRotation(self) -> float: ...
        def yRotation(self) -> float: ...
        def zoomLevel(self) -> float: ...

    class Q3DInputHandler(PySide2.QtDataVisualization.QAbstract3DInputHandler):

        rotationEnabledChanged: PySide2.QtCore.Signal
        selectionEnabledChanged: PySide2.QtCore.Signal
        zoomAtTargetEnabledChanged: PySide2.QtCore.Signal
        zoomEnabledChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def isRotationEnabled(self) -> bool: ...
        def isSelectionEnabled(self) -> bool: ...
        def isZoomAtTargetEnabled(self) -> bool: ...
        def isZoomEnabled(self) -> bool: ...
        def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent, mousePos:PySide2.QtCore.QPoint) -> None: ...
        def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent, mousePos:PySide2.QtCore.QPoint) -> None: ...
        def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent, mousePos:PySide2.QtCore.QPoint) -> None: ...
        def setRotationEnabled(self, enable:bool) -> None: ...
        def setSelectionEnabled(self, enable:bool) -> None: ...
        def setZoomAtTargetEnabled(self, enable:bool) -> None: ...
        def setZoomEnabled(self, enable:bool) -> None: ...
        def wheelEvent(self, event:PySide2.QtGui.QWheelEvent) -> None: ...

    class Q3DLight(PySide2.QtDataVisualization.Q3DObject):

        autoPositionChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def isAutoPosition(self) -> bool: ...
        def setAutoPosition(self, enabled:bool) -> None: ...

    class Q3DObject(PySide2.QtCore.QObject):

        positionChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def copyValuesFrom(self, source:PySide2.QtDataVisualization.QtDataVisualization.Q3DObject) -> None: ...
        def isDirty(self) -> bool: ...
        def parentScene(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DScene: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def setDirty(self, dirty:bool) -> None: ...
        def setPosition(self, position:PySide2.QtGui.QVector3D) -> None: ...

    class Q3DScatter(PySide2.QtDataVisualization.QAbstract3DGraph):

        axisXChanged: PySide2.QtCore.Signal
        axisYChanged: PySide2.QtCore.Signal
        axisZChanged: PySide2.QtCore.Signal
        selectedSeriesChanged: PySide2.QtCore.Signal


        def __init__(self, format:typing.Optional[PySide2.QtGui.QSurfaceFormat]=..., parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...

        def addAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def addSeries(self, series:PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries) -> None: ...
        def axes(self) -> typing.List: ...
        def axisX(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisY(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisZ(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def releaseAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def removeSeries(self, series:PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries) -> None: ...
        def selectedSeries(self) -> PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries: ...
        def seriesList(self) -> typing.List: ...
        def setAxisX(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def setAxisY(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def setAxisZ(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...

    class Q3DScene(PySide2.QtCore.QObject):

        activeCameraChanged: PySide2.QtCore.Signal
        activeLightChanged: PySide2.QtCore.Signal
        devicePixelRatioChanged: PySide2.QtCore.Signal
        graphPositionQueryChanged: PySide2.QtCore.Signal
        primarySubViewportChanged: PySide2.QtCore.Signal
        secondarySubViewportChanged: PySide2.QtCore.Signal
        secondarySubviewOnTopChanged: PySide2.QtCore.Signal
        selectionQueryPositionChanged: PySide2.QtCore.Signal
        slicingActiveChanged: PySide2.QtCore.Signal
        viewportChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def activeCamera(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera: ...
        def activeLight(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DLight: ...
        def devicePixelRatio(self) -> float: ...
        def graphPositionQuery(self) -> PySide2.QtCore.QPoint: ...
        @staticmethod
        def invalidSelectionPoint() -> PySide2.QtCore.QPoint: ...
        def isPointInPrimarySubView(self, point:PySide2.QtCore.QPoint) -> bool: ...
        def isPointInSecondarySubView(self, point:PySide2.QtCore.QPoint) -> bool: ...
        def isSecondarySubviewOnTop(self) -> bool: ...
        def isSlicingActive(self) -> bool: ...
        def primarySubViewport(self) -> PySide2.QtCore.QRect: ...
        def secondarySubViewport(self) -> PySide2.QtCore.QRect: ...
        def selectionQueryPosition(self) -> PySide2.QtCore.QPoint: ...
        def setActiveCamera(self, camera:PySide2.QtDataVisualization.QtDataVisualization.Q3DCamera) -> None: ...
        def setActiveLight(self, light:PySide2.QtDataVisualization.QtDataVisualization.Q3DLight) -> None: ...
        def setDevicePixelRatio(self, pixelRatio:float) -> None: ...
        def setGraphPositionQuery(self, point:PySide2.QtCore.QPoint) -> None: ...
        def setPrimarySubViewport(self, primarySubViewport:PySide2.QtCore.QRect) -> None: ...
        def setSecondarySubViewport(self, secondarySubViewport:PySide2.QtCore.QRect) -> None: ...
        def setSecondarySubviewOnTop(self, isSecondaryOnTop:bool) -> None: ...
        def setSelectionQueryPosition(self, point:PySide2.QtCore.QPoint) -> None: ...
        def setSlicingActive(self, isSlicing:bool) -> None: ...
        def viewport(self) -> PySide2.QtCore.QRect: ...

    class Q3DSurface(PySide2.QtDataVisualization.QAbstract3DGraph):

        axisXChanged: PySide2.QtCore.Signal
        axisYChanged: PySide2.QtCore.Signal
        axisZChanged: PySide2.QtCore.Signal
        flipHorizontalGridChanged: PySide2.QtCore.Signal
        selectedSeriesChanged: PySide2.QtCore.Signal


        def __init__(self, format:typing.Optional[PySide2.QtGui.QSurfaceFormat]=..., parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...

        def addAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def addSeries(self, series:PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries) -> None: ...
        def axes(self) -> typing.List: ...
        def axisX(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisY(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def axisZ(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def flipHorizontalGrid(self) -> bool: ...
        def releaseAxis(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def removeSeries(self, series:PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries) -> None: ...
        def selectedSeries(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries: ...
        def seriesList(self) -> typing.List: ...
        def setAxisX(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def setAxisY(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def setAxisZ(self, axis:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis) -> None: ...
        def setFlipHorizontalGrid(self, flip:bool) -> None: ...

    class Q3DTheme(PySide2.QtCore.QObject):

        ambientLightStrengthChanged: PySide2.QtCore.Signal
        backgroundColorChanged: PySide2.QtCore.Signal
        backgroundEnabledChanged: PySide2.QtCore.Signal
        baseColorsChanged: PySide2.QtCore.Signal
        baseGradientsChanged: PySide2.QtCore.Signal
        colorStyleChanged: PySide2.QtCore.Signal
        fontChanged: PySide2.QtCore.Signal
        gridEnabledChanged: PySide2.QtCore.Signal
        gridLineColorChanged: PySide2.QtCore.Signal
        highlightLightStrengthChanged: PySide2.QtCore.Signal
        labelBackgroundColorChanged: PySide2.QtCore.Signal
        labelBackgroundEnabledChanged: PySide2.QtCore.Signal
        labelBorderEnabledChanged: PySide2.QtCore.Signal
        labelTextColorChanged: PySide2.QtCore.Signal
        lightColorChanged: PySide2.QtCore.Signal
        lightStrengthChanged: PySide2.QtCore.Signal
        multiHighlightColorChanged: PySide2.QtCore.Signal
        multiHighlightGradientChanged: PySide2.QtCore.Signal
        singleHighlightColorChanged: PySide2.QtCore.Signal
        singleHighlightGradientChanged: PySide2.QtCore.Signal
        typeChanged: PySide2.QtCore.Signal
        windowColorChanged: PySide2.QtCore.Signal

        ColorStyleUniform        : QtDataVisualization.Q3DTheme.ColorStyle = ... # 0x0
        ThemeQt                  : QtDataVisualization.Q3DTheme.Theme = ... # 0x0
        ColorStyleObjectGradient : QtDataVisualization.Q3DTheme.ColorStyle = ... # 0x1
        ThemePrimaryColors       : QtDataVisualization.Q3DTheme.Theme = ... # 0x1
        ColorStyleRangeGradient  : QtDataVisualization.Q3DTheme.ColorStyle = ... # 0x2
        ThemeDigia               : QtDataVisualization.Q3DTheme.Theme = ... # 0x2
        ThemeStoneMoss           : QtDataVisualization.Q3DTheme.Theme = ... # 0x3
        ThemeArmyBlue            : QtDataVisualization.Q3DTheme.Theme = ... # 0x4
        ThemeRetro               : QtDataVisualization.Q3DTheme.Theme = ... # 0x5
        ThemeEbony               : QtDataVisualization.Q3DTheme.Theme = ... # 0x6
        ThemeIsabelle            : QtDataVisualization.Q3DTheme.Theme = ... # 0x7
        ThemeUserDefined         : QtDataVisualization.Q3DTheme.Theme = ... # 0x8

        class ColorStyle(object):
            ColorStyleUniform        : QtDataVisualization.Q3DTheme.ColorStyle = ... # 0x0
            ColorStyleObjectGradient : QtDataVisualization.Q3DTheme.ColorStyle = ... # 0x1
            ColorStyleRangeGradient  : QtDataVisualization.Q3DTheme.ColorStyle = ... # 0x2

        class Theme(object):
            ThemeQt                  : QtDataVisualization.Q3DTheme.Theme = ... # 0x0
            ThemePrimaryColors       : QtDataVisualization.Q3DTheme.Theme = ... # 0x1
            ThemeDigia               : QtDataVisualization.Q3DTheme.Theme = ... # 0x2
            ThemeStoneMoss           : QtDataVisualization.Q3DTheme.Theme = ... # 0x3
            ThemeArmyBlue            : QtDataVisualization.Q3DTheme.Theme = ... # 0x4
            ThemeRetro               : QtDataVisualization.Q3DTheme.Theme = ... # 0x5
            ThemeEbony               : QtDataVisualization.Q3DTheme.Theme = ... # 0x6
            ThemeIsabelle            : QtDataVisualization.Q3DTheme.Theme = ... # 0x7
            ThemeUserDefined         : QtDataVisualization.Q3DTheme.Theme = ... # 0x8

        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, themeType:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def ambientLightStrength(self) -> float: ...
        def backgroundColor(self) -> PySide2.QtGui.QColor: ...
        def baseColors(self) -> typing.List: ...
        def baseGradients(self) -> typing.List: ...
        def colorStyle(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def gridLineColor(self) -> PySide2.QtGui.QColor: ...
        def highlightLightStrength(self) -> float: ...
        def isBackgroundEnabled(self) -> bool: ...
        def isGridEnabled(self) -> bool: ...
        def isLabelBackgroundEnabled(self) -> bool: ...
        def isLabelBorderEnabled(self) -> bool: ...
        def labelBackgroundColor(self) -> PySide2.QtGui.QColor: ...
        def labelTextColor(self) -> PySide2.QtGui.QColor: ...
        def lightColor(self) -> PySide2.QtGui.QColor: ...
        def lightStrength(self) -> float: ...
        def multiHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def multiHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def setAmbientLightStrength(self, strength:float) -> None: ...
        def setBackgroundColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setBackgroundEnabled(self, enabled:bool) -> None: ...
        def setBaseColors(self, colors:typing.Sequence) -> None: ...
        def setBaseGradients(self, gradients:typing.Sequence) -> None: ...
        def setColorStyle(self, style:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle) -> None: ...
        def setFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setGridEnabled(self, enabled:bool) -> None: ...
        def setGridLineColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setHighlightLightStrength(self, strength:float) -> None: ...
        def setLabelBackgroundColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLabelBackgroundEnabled(self, enabled:bool) -> None: ...
        def setLabelBorderEnabled(self, enabled:bool) -> None: ...
        def setLabelTextColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLightColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLightStrength(self, strength:float) -> None: ...
        def setMultiHighlightColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setMultiHighlightGradient(self, gradient:PySide2.QtGui.QLinearGradient) -> None: ...
        def setSingleHighlightColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setSingleHighlightGradient(self, gradient:PySide2.QtGui.QLinearGradient) -> None: ...
        def setType(self, themeType:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme) -> None: ...
        def setWindowColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def singleHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def singleHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def type(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.Theme: ...
        def windowColor(self) -> PySide2.QtGui.QColor: ...

    class QAbstract3DAxis(PySide2.QtCore.QObject):

        autoAdjustRangeChanged: PySide2.QtCore.Signal
        labelAutoRotationChanged: PySide2.QtCore.Signal
        labelsChanged: PySide2.QtCore.Signal
        maxChanged: PySide2.QtCore.Signal
        minChanged: PySide2.QtCore.Signal
        orientationChanged: PySide2.QtCore.Signal
        rangeChanged: PySide2.QtCore.Signal
        titleChanged: PySide2.QtCore.Signal
        titleFixedChanged: PySide2.QtCore.Signal
        titleVisibilityChanged: PySide2.QtCore.Signal

        AxisOrientationNone      : QtDataVisualization.QAbstract3DAxis.AxisOrientation = ... # 0x0
        AxisTypeNone             : QtDataVisualization.QAbstract3DAxis.AxisType = ... # 0x0
        AxisOrientationX         : QtDataVisualization.QAbstract3DAxis.AxisOrientation = ... # 0x1
        AxisTypeCategory         : QtDataVisualization.QAbstract3DAxis.AxisType = ... # 0x1
        AxisOrientationY         : QtDataVisualization.QAbstract3DAxis.AxisOrientation = ... # 0x2
        AxisTypeValue            : QtDataVisualization.QAbstract3DAxis.AxisType = ... # 0x2
        AxisOrientationZ         : QtDataVisualization.QAbstract3DAxis.AxisOrientation = ... # 0x4

        class AxisOrientation(object):
            AxisOrientationNone      : QtDataVisualization.QAbstract3DAxis.AxisOrientation = ... # 0x0
            AxisOrientationX         : QtDataVisualization.QAbstract3DAxis.AxisOrientation = ... # 0x1
            AxisOrientationY         : QtDataVisualization.QAbstract3DAxis.AxisOrientation = ... # 0x2
            AxisOrientationZ         : QtDataVisualization.QAbstract3DAxis.AxisOrientation = ... # 0x4

        class AxisType(object):
            AxisTypeNone             : QtDataVisualization.QAbstract3DAxis.AxisType = ... # 0x0
            AxisTypeCategory         : QtDataVisualization.QAbstract3DAxis.AxisType = ... # 0x1
            AxisTypeValue            : QtDataVisualization.QAbstract3DAxis.AxisType = ... # 0x2
        def isAutoAdjustRange(self) -> bool: ...
        def isTitleFixed(self) -> bool: ...
        def isTitleVisible(self) -> bool: ...
        def labelAutoRotation(self) -> float: ...
        def labels(self) -> typing.List: ...
        def max(self) -> float: ...
        def min(self) -> float: ...
        def orientation(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.AxisOrientation: ...
        def setAutoAdjustRange(self, autoAdjust:bool) -> None: ...
        def setLabelAutoRotation(self, angle:float) -> None: ...
        def setLabels(self, labels:typing.Sequence) -> None: ...
        def setMax(self, max:float) -> None: ...
        def setMin(self, min:float) -> None: ...
        def setRange(self, min:float, max:float) -> None: ...
        def setTitle(self, title:str) -> None: ...
        def setTitleFixed(self, fixed:bool) -> None: ...
        def setTitleVisible(self, visible:bool) -> None: ...
        def title(self) -> str: ...
        def type(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis.AxisType: ...

    class QAbstract3DGraph(PySide2.QtGui.QWindow):

        activeInputHandlerChanged: PySide2.QtCore.Signal
        activeThemeChanged: PySide2.QtCore.Signal
        aspectRatioChanged: PySide2.QtCore.Signal
        currentFpsChanged: PySide2.QtCore.Signal
        horizontalAspectRatioChanged: PySide2.QtCore.Signal
        localeChanged: PySide2.QtCore.Signal
        marginChanged: PySide2.QtCore.Signal
        measureFpsChanged: PySide2.QtCore.Signal
        optimizationHintsChanged: PySide2.QtCore.Signal
        orthoProjectionChanged: PySide2.QtCore.Signal
        polarChanged: PySide2.QtCore.Signal
        queriedGraphPositionChanged: PySide2.QtCore.Signal
        radialLabelOffsetChanged: PySide2.QtCore.Signal
        reflectionChanged: PySide2.QtCore.Signal
        reflectivityChanged: PySide2.QtCore.Signal
        selectedElementChanged: PySide2.QtCore.Signal
        selectionModeChanged: PySide2.QtCore.Signal
        shadowQualityChanged: PySide2.QtCore.Signal

        ElementNone              : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x0
        OptimizationDefault      : QtDataVisualization.QAbstract3DGraph.OptimizationHint = ... # 0x0
        SelectionNone            : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x0
        ShadowQualityNone        : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x0
        ElementSeries            : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x1
        OptimizationStatic       : QtDataVisualization.QAbstract3DGraph.OptimizationHint = ... # 0x1
        SelectionItem            : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x1
        ShadowQualityLow         : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x1
        ElementAxisXLabel        : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x2
        SelectionRow             : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x2
        ShadowQualityMedium      : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x2
        ElementAxisYLabel        : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x3
        SelectionItemAndRow      : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x3
        ShadowQualityHigh        : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x3
        ElementAxisZLabel        : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x4
        SelectionColumn          : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x4
        ShadowQualitySoftLow     : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x4
        ElementCustomItem        : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x5
        SelectionItemAndColumn   : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x5
        ShadowQualitySoftMedium  : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x5
        SelectionRowAndColumn    : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x6
        ShadowQualitySoftHigh    : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x6
        SelectionItemRowAndColumn: QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x7
        SelectionSlice           : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x8
        SelectionMultiSeries     : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x10

        class ElementType(object):
            ElementNone              : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x0
            ElementSeries            : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x1
            ElementAxisXLabel        : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x2
            ElementAxisYLabel        : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x3
            ElementAxisZLabel        : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x4
            ElementCustomItem        : QtDataVisualization.QAbstract3DGraph.ElementType = ... # 0x5

        class OptimizationHint(object):
            OptimizationDefault      : QtDataVisualization.QAbstract3DGraph.OptimizationHint = ... # 0x0
            OptimizationStatic       : QtDataVisualization.QAbstract3DGraph.OptimizationHint = ... # 0x1
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, OptimizationHint] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __and__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __xor__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __ror__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __rand__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __rxor__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __ior__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __iand__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __ixor__(self, other: typing.Union[int, OptimizationHint]) -> OptimizationHints: ...
            def __invert__(self) -> OptimizationHints: ...

        class OptimizationHints(object):
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, OptimizationHint, OptimizationHints] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __and__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __xor__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __ror__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __rand__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __rxor__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __ior__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __iand__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __ixor__(self, other: typing.Union[int, OptimizationHint, OptimizationHints]) -> OptimizationHints: ...
            def __invert__(self) -> OptimizationHints: ...

        class SelectionFlag(object):
            SelectionNone            : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x0
            SelectionItem            : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x1
            SelectionRow             : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x2
            SelectionItemAndRow      : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x3
            SelectionColumn          : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x4
            SelectionItemAndColumn   : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x5
            SelectionRowAndColumn    : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x6
            SelectionItemRowAndColumn: QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x7
            SelectionSlice           : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x8
            SelectionMultiSeries     : QtDataVisualization.QAbstract3DGraph.SelectionFlag = ... # 0x10
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, SelectionFlag] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __and__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __xor__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __ror__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __rand__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __rxor__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __ior__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __iand__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __ixor__(self, other: typing.Union[int, SelectionFlag]) -> SelectionFlags: ...
            def __invert__(self) -> SelectionFlags: ...

        class SelectionFlags(object):
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, SelectionFlag, SelectionFlags] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __and__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __xor__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __ror__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __rand__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __rxor__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __ior__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __iand__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __ixor__(self, other: typing.Union[int, SelectionFlag, SelectionFlags]) -> SelectionFlags: ...
            def __invert__(self) -> SelectionFlags: ...

        class ShadowQuality(object):
            ShadowQualityNone        : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x0
            ShadowQualityLow         : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x1
            ShadowQualityMedium      : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x2
            ShadowQualityHigh        : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x3
            ShadowQualitySoftLow     : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x4
            ShadowQualitySoftMedium  : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x5
            ShadowQualitySoftHigh    : QtDataVisualization.QAbstract3DGraph.ShadowQuality = ... # 0x6
        def activeInputHandler(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler: ...
        def activeTheme(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme: ...
        def addCustomItem(self, item:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem) -> int: ...
        def addInputHandler(self, inputHandler:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler) -> None: ...
        def addTheme(self, theme:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme) -> None: ...
        def aspectRatio(self) -> float: ...
        def clearSelection(self) -> None: ...
        def currentFps(self) -> float: ...
        def customItems(self) -> typing.List: ...
        def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
        def exposeEvent(self, event:PySide2.QtGui.QExposeEvent) -> None: ...
        def hasContext(self) -> bool: ...
        def horizontalAspectRatio(self) -> float: ...
        def inputHandlers(self) -> typing.List: ...
        def isOrthoProjection(self) -> bool: ...
        def isPolar(self) -> bool: ...
        def isReflection(self) -> bool: ...
        def locale(self) -> PySide2.QtCore.QLocale: ...
        def margin(self) -> float: ...
        def measureFps(self) -> bool: ...
        def mouseDoubleClickEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
        def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
        def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
        def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
        def optimizationHints(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.OptimizationHints: ...
        def queriedGraphPosition(self) -> PySide2.QtGui.QVector3D: ...
        def radialLabelOffset(self) -> float: ...
        def reflectivity(self) -> float: ...
        def releaseCustomItem(self, item:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem) -> None: ...
        def releaseInputHandler(self, inputHandler:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler) -> None: ...
        def releaseTheme(self, theme:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme) -> None: ...
        def removeCustomItem(self, item:PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem) -> None: ...
        def removeCustomItemAt(self, position:PySide2.QtGui.QVector3D) -> None: ...
        def removeCustomItems(self) -> None: ...
        def renderToImage(self, msaaSamples:int=..., imageSize:PySide2.QtCore.QSize=...) -> PySide2.QtGui.QImage: ...
        def resizeEvent(self, event:PySide2.QtGui.QResizeEvent) -> None: ...
        def scene(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DScene: ...
        def selectedAxis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DAxis: ...
        def selectedCustomItem(self) -> PySide2.QtDataVisualization.QtDataVisualization.QCustom3DItem: ...
        def selectedCustomItemIndex(self) -> int: ...
        def selectedElement(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ElementType: ...
        def selectedLabelIndex(self) -> int: ...
        def selectionMode(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.SelectionFlags: ...
        def setActiveInputHandler(self, inputHandler:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler) -> None: ...
        def setActiveTheme(self, theme:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme) -> None: ...
        def setAspectRatio(self, ratio:float) -> None: ...
        def setHorizontalAspectRatio(self, ratio:float) -> None: ...
        def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...
        def setMargin(self, margin:float) -> None: ...
        def setMeasureFps(self, enable:bool) -> None: ...
        def setOptimizationHints(self, hints:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.OptimizationHints) -> None: ...
        def setOrthoProjection(self, enable:bool) -> None: ...
        def setPolar(self, enable:bool) -> None: ...
        def setRadialLabelOffset(self, offset:float) -> None: ...
        def setReflection(self, enable:bool) -> None: ...
        def setReflectivity(self, reflectivity:float) -> None: ...
        def setSelectionMode(self, mode:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.SelectionFlags) -> None: ...
        def setShadowQuality(self, quality:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ShadowQuality) -> None: ...
        def shadowQuality(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DGraph.ShadowQuality: ...
        def shadowsSupported(self) -> bool: ...
        def themes(self) -> typing.List: ...
        def touchEvent(self, event:PySide2.QtGui.QTouchEvent) -> None: ...
        def wheelEvent(self, event:PySide2.QtGui.QWheelEvent) -> None: ...

    class QAbstract3DInputHandler(PySide2.QtCore.QObject):

        inputViewChanged: PySide2.QtCore.Signal
        positionChanged: PySide2.QtCore.Signal
        sceneChanged: PySide2.QtCore.Signal

        InputViewNone            : QtDataVisualization.QAbstract3DInputHandler.InputView = ... # 0x0
        InputViewOnPrimary       : QtDataVisualization.QAbstract3DInputHandler.InputView = ... # 0x1
        InputViewOnSecondary     : QtDataVisualization.QAbstract3DInputHandler.InputView = ... # 0x2

        class InputView(object):
            InputViewNone            : QtDataVisualization.QAbstract3DInputHandler.InputView = ... # 0x0
            InputViewOnPrimary       : QtDataVisualization.QAbstract3DInputHandler.InputView = ... # 0x1
            InputViewOnSecondary     : QtDataVisualization.QAbstract3DInputHandler.InputView = ... # 0x2

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def inputPosition(self) -> PySide2.QtCore.QPoint: ...
        def inputView(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler.InputView: ...
        def mouseDoubleClickEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
        def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent, mousePos:PySide2.QtCore.QPoint) -> None: ...
        def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent, mousePos:PySide2.QtCore.QPoint) -> None: ...
        def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent, mousePos:PySide2.QtCore.QPoint) -> None: ...
        def prevDistance(self) -> int: ...
        def previousInputPos(self) -> PySide2.QtCore.QPoint: ...
        def scene(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DScene: ...
        def setInputPosition(self, position:PySide2.QtCore.QPoint) -> None: ...
        def setInputView(self, inputView:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DInputHandler.InputView) -> None: ...
        def setPrevDistance(self, distance:int) -> None: ...
        def setPreviousInputPos(self, position:PySide2.QtCore.QPoint) -> None: ...
        def setScene(self, scene:PySide2.QtDataVisualization.QtDataVisualization.Q3DScene) -> None: ...
        def touchEvent(self, event:PySide2.QtGui.QTouchEvent) -> None: ...
        def wheelEvent(self, event:PySide2.QtGui.QWheelEvent) -> None: ...

    class QAbstract3DSeries(PySide2.QtCore.QObject):

        baseColorChanged: PySide2.QtCore.Signal
        baseGradientChanged: PySide2.QtCore.Signal
        colorStyleChanged: PySide2.QtCore.Signal
        itemLabelChanged: PySide2.QtCore.Signal
        itemLabelFormatChanged: PySide2.QtCore.Signal
        itemLabelVisibilityChanged: PySide2.QtCore.Signal
        meshChanged: PySide2.QtCore.Signal
        meshRotationChanged: PySide2.QtCore.Signal
        meshSmoothChanged: PySide2.QtCore.Signal
        multiHighlightColorChanged: PySide2.QtCore.Signal
        multiHighlightGradientChanged: PySide2.QtCore.Signal
        nameChanged: PySide2.QtCore.Signal
        singleHighlightColorChanged: PySide2.QtCore.Signal
        singleHighlightGradientChanged: PySide2.QtCore.Signal
        userDefinedMeshChanged: PySide2.QtCore.Signal
        visibilityChanged: PySide2.QtCore.Signal

        MeshUserDefined          : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x0
        SeriesTypeNone           : QtDataVisualization.QAbstract3DSeries.SeriesType = ... # 0x0
        MeshBar                  : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x1
        SeriesTypeBar            : QtDataVisualization.QAbstract3DSeries.SeriesType = ... # 0x1
        MeshCube                 : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x2
        SeriesTypeScatter        : QtDataVisualization.QAbstract3DSeries.SeriesType = ... # 0x2
        MeshPyramid              : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x3
        MeshCone                 : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x4
        SeriesTypeSurface        : QtDataVisualization.QAbstract3DSeries.SeriesType = ... # 0x4
        MeshCylinder             : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x5
        MeshBevelBar             : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x6
        MeshBevelCube            : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x7
        MeshSphere               : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x8
        MeshMinimal              : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x9
        MeshArrow                : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0xa
        MeshPoint                : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0xb

        class Mesh(object):
            MeshUserDefined          : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x0
            MeshBar                  : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x1
            MeshCube                 : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x2
            MeshPyramid              : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x3
            MeshCone                 : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x4
            MeshCylinder             : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x5
            MeshBevelBar             : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x6
            MeshBevelCube            : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x7
            MeshSphere               : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x8
            MeshMinimal              : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0x9
            MeshArrow                : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0xa
            MeshPoint                : QtDataVisualization.QAbstract3DSeries.Mesh = ... # 0xb

        class SeriesType(object):
            SeriesTypeNone           : QtDataVisualization.QAbstract3DSeries.SeriesType = ... # 0x0
            SeriesTypeBar            : QtDataVisualization.QAbstract3DSeries.SeriesType = ... # 0x1
            SeriesTypeScatter        : QtDataVisualization.QAbstract3DSeries.SeriesType = ... # 0x2
            SeriesTypeSurface        : QtDataVisualization.QAbstract3DSeries.SeriesType = ... # 0x4
        def baseColor(self) -> PySide2.QtGui.QColor: ...
        def baseGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def colorStyle(self) -> PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle: ...
        def isItemLabelVisible(self) -> bool: ...
        def isMeshSmooth(self) -> bool: ...
        def isVisible(self) -> bool: ...
        def itemLabel(self) -> str: ...
        def itemLabelFormat(self) -> str: ...
        def mesh(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.Mesh: ...
        def meshRotation(self) -> PySide2.QtGui.QQuaternion: ...
        def multiHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def multiHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def name(self) -> str: ...
        def setBaseColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setBaseGradient(self, gradient:PySide2.QtGui.QLinearGradient) -> None: ...
        def setColorStyle(self, style:PySide2.QtDataVisualization.QtDataVisualization.Q3DTheme.ColorStyle) -> None: ...
        def setItemLabelFormat(self, format:str) -> None: ...
        def setItemLabelVisible(self, visible:bool) -> None: ...
        def setMesh(self, mesh:PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.Mesh) -> None: ...
        def setMeshAxisAndAngle(self, axis:PySide2.QtGui.QVector3D, angle:float) -> None: ...
        def setMeshRotation(self, rotation:PySide2.QtGui.QQuaternion) -> None: ...
        def setMeshSmooth(self, enable:bool) -> None: ...
        def setMultiHighlightColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setMultiHighlightGradient(self, gradient:PySide2.QtGui.QLinearGradient) -> None: ...
        def setName(self, name:str) -> None: ...
        def setSingleHighlightColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setSingleHighlightGradient(self, gradient:PySide2.QtGui.QLinearGradient) -> None: ...
        def setUserDefinedMesh(self, fileName:str) -> None: ...
        def setVisible(self, visible:bool) -> None: ...
        def singleHighlightColor(self) -> PySide2.QtGui.QColor: ...
        def singleHighlightGradient(self) -> PySide2.QtGui.QLinearGradient: ...
        def type(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstract3DSeries.SeriesType: ...
        def userDefinedMesh(self) -> str: ...

    class QAbstractDataProxy(PySide2.QtCore.QObject):
        DataTypeNone             : QtDataVisualization.QAbstractDataProxy.DataType = ... # 0x0
        DataTypeBar              : QtDataVisualization.QAbstractDataProxy.DataType = ... # 0x1
        DataTypeScatter          : QtDataVisualization.QAbstractDataProxy.DataType = ... # 0x2
        DataTypeSurface          : QtDataVisualization.QAbstractDataProxy.DataType = ... # 0x4

        class DataType(object):
            DataTypeNone             : QtDataVisualization.QAbstractDataProxy.DataType = ... # 0x0
            DataTypeBar              : QtDataVisualization.QAbstractDataProxy.DataType = ... # 0x1
            DataTypeScatter          : QtDataVisualization.QAbstractDataProxy.DataType = ... # 0x2
            DataTypeSurface          : QtDataVisualization.QAbstractDataProxy.DataType = ... # 0x4
        def type(self) -> PySide2.QtDataVisualization.QtDataVisualization.QAbstractDataProxy.DataType: ...

    class QBar3DSeries(PySide2.QtDataVisualization.QAbstract3DSeries):

        dataProxyChanged: PySide2.QtCore.Signal
        meshAngleChanged: PySide2.QtCore.Signal
        selectedBarChanged: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, dataProxy:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def dataProxy(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy: ...
        @staticmethod
        def invalidSelectionPosition() -> PySide2.QtCore.QPoint: ...
        def meshAngle(self) -> float: ...
        def selectedBar(self) -> PySide2.QtCore.QPoint: ...
        def setDataProxy(self, proxy:PySide2.QtDataVisualization.QtDataVisualization.QBarDataProxy) -> None: ...
        def setMeshAngle(self, angle:float) -> None: ...
        def setSelectedBar(self, position:PySide2.QtCore.QPoint) -> None: ...

    class QBarDataItem(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem) -> None: ...
        @typing.overload
        def __init__(self, value:float) -> None: ...
        @typing.overload
        def __init__(self, value:float, angle:float) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def createExtraData(self) -> None: ...
        def rotation(self) -> float: ...
        def setRotation(self, angle:float) -> None: ...
        def setValue(self, val:float) -> None: ...
        def value(self) -> float: ...

    class QBarDataProxy(PySide2.QtDataVisualization.QAbstractDataProxy):

        arrayReset: PySide2.QtCore.Signal
        columnLabelsChanged: PySide2.QtCore.Signal
        itemChanged: PySide2.QtCore.Signal
        rowCountChanged: PySide2.QtCore.Signal
        rowLabelsChanged: PySide2.QtCore.Signal
        rowsAdded: PySide2.QtCore.Signal
        rowsChanged: PySide2.QtCore.Signal
        rowsInserted: PySide2.QtCore.Signal
        rowsRemoved: PySide2.QtCore.Signal
        seriesChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        @typing.overload
        def addRow(self, row:typing.List) -> int: ...
        @typing.overload
        def addRow(self, row:typing.List, label:str) -> int: ...
        @typing.overload
        def addRows(self, rows:typing.List) -> int: ...
        @typing.overload
        def addRows(self, rows:typing.List, labels:typing.Sequence) -> int: ...
        def array(self) -> typing.List: ...
        def columnLabels(self) -> typing.List: ...
        @typing.overload
        def insertRow(self, rowIndex:int, row:typing.List) -> None: ...
        @typing.overload
        def insertRow(self, rowIndex:int, row:typing.List, label:str) -> None: ...
        @typing.overload
        def insertRows(self, rowIndex:int, rows:typing.List) -> None: ...
        @typing.overload
        def insertRows(self, rowIndex:int, rows:typing.List, labels:typing.Sequence) -> None: ...
        @typing.overload
        def itemAt(self, position:PySide2.QtCore.QPoint) -> PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem: ...
        @typing.overload
        def itemAt(self, rowIndex:int, columnIndex:int) -> PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem: ...
        def removeRows(self, rowIndex:int, removeCount:int, removeLabels:bool=...) -> None: ...
        @typing.overload
        def resetArray(self) -> None: ...
        @typing.overload
        def resetArray(self, newArray:typing.List) -> None: ...
        @typing.overload
        def resetArray(self, newArray:typing.List, rowLabels:typing.Sequence, columnLabels:typing.Sequence) -> None: ...
        def rowAt(self, rowIndex:int) -> typing.List: ...
        def rowCount(self) -> int: ...
        def rowLabels(self) -> typing.List: ...
        def series(self) -> PySide2.QtDataVisualization.QtDataVisualization.QBar3DSeries: ...
        def setColumnLabels(self, labels:typing.Sequence) -> None: ...
        @typing.overload
        def setItem(self, position:PySide2.QtCore.QPoint, item:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem) -> None: ...
        @typing.overload
        def setItem(self, rowIndex:int, columnIndex:int, item:PySide2.QtDataVisualization.QtDataVisualization.QBarDataItem) -> None: ...
        @typing.overload
        def setRow(self, rowIndex:int, row:typing.List) -> None: ...
        @typing.overload
        def setRow(self, rowIndex:int, row:typing.List, label:str) -> None: ...
        def setRowLabels(self, labels:typing.Sequence) -> None: ...
        @typing.overload
        def setRows(self, rowIndex:int, rows:typing.List) -> None: ...
        @typing.overload
        def setRows(self, rowIndex:int, rows:typing.List, labels:typing.Sequence) -> None: ...

    class QCategory3DAxis(PySide2.QtDataVisualization.QAbstract3DAxis):

        labelsChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def labels(self) -> typing.List: ...
        def setLabels(self, labels:typing.Sequence) -> None: ...

    class QCustom3DItem(PySide2.QtCore.QObject):

        meshFileChanged: PySide2.QtCore.Signal
        positionAbsoluteChanged: PySide2.QtCore.Signal
        positionChanged: PySide2.QtCore.Signal
        rotationChanged: PySide2.QtCore.Signal
        scalingAbsoluteChanged: PySide2.QtCore.Signal
        scalingChanged: PySide2.QtCore.Signal
        shadowCastingChanged: PySide2.QtCore.Signal
        textureFileChanged: PySide2.QtCore.Signal
        visibleChanged: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, meshFile:str, position:PySide2.QtGui.QVector3D, scaling:PySide2.QtGui.QVector3D, rotation:PySide2.QtGui.QQuaternion, texture:PySide2.QtGui.QImage, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def isPositionAbsolute(self) -> bool: ...
        def isScalingAbsolute(self) -> bool: ...
        def isShadowCasting(self) -> bool: ...
        def isVisible(self) -> bool: ...
        def meshFile(self) -> str: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def rotation(self) -> PySide2.QtGui.QQuaternion: ...
        def scaling(self) -> PySide2.QtGui.QVector3D: ...
        def setMeshFile(self, meshFile:str) -> None: ...
        def setPosition(self, position:PySide2.QtGui.QVector3D) -> None: ...
        def setPositionAbsolute(self, positionAbsolute:bool) -> None: ...
        def setRotation(self, rotation:PySide2.QtGui.QQuaternion) -> None: ...
        def setRotationAxisAndAngle(self, axis:PySide2.QtGui.QVector3D, angle:float) -> None: ...
        def setScaling(self, scaling:PySide2.QtGui.QVector3D) -> None: ...
        def setScalingAbsolute(self, scalingAbsolute:bool) -> None: ...
        def setShadowCasting(self, enabled:bool) -> None: ...
        def setTextureFile(self, textureFile:str) -> None: ...
        def setTextureImage(self, textureImage:PySide2.QtGui.QImage) -> None: ...
        def setVisible(self, visible:bool) -> None: ...
        def textureFile(self) -> str: ...

    class QCustom3DLabel(PySide2.QtDataVisualization.QCustom3DItem):

        backgroundColorChanged: PySide2.QtCore.Signal
        backgroundEnabledChanged: PySide2.QtCore.Signal
        borderEnabledChanged: PySide2.QtCore.Signal
        facingCameraChanged: PySide2.QtCore.Signal
        fontChanged: PySide2.QtCore.Signal
        textChanged: PySide2.QtCore.Signal
        textColorChanged: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, text:str, font:PySide2.QtGui.QFont, position:PySide2.QtGui.QVector3D, scaling:PySide2.QtGui.QVector3D, rotation:PySide2.QtGui.QQuaternion, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def backgroundColor(self) -> PySide2.QtGui.QColor: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def isBackgroundEnabled(self) -> bool: ...
        def isBorderEnabled(self) -> bool: ...
        def isFacingCamera(self) -> bool: ...
        def setBackgroundColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setBackgroundEnabled(self, enabled:bool) -> None: ...
        def setBorderEnabled(self, enabled:bool) -> None: ...
        def setFacingCamera(self, enabled:bool) -> None: ...
        def setFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setText(self, text:str) -> None: ...
        def setTextColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def text(self) -> str: ...
        def textColor(self) -> PySide2.QtGui.QColor: ...

    class QCustom3DVolume(PySide2.QtDataVisualization.QCustom3DItem):

        alphaMultiplierChanged: PySide2.QtCore.Signal
        colorTableChanged: PySide2.QtCore.Signal
        drawSliceFramesChanged: PySide2.QtCore.Signal
        drawSlicesChanged: PySide2.QtCore.Signal
        preserveOpacityChanged: PySide2.QtCore.Signal
        sliceFrameColorChanged: PySide2.QtCore.Signal
        sliceFrameGapsChanged: PySide2.QtCore.Signal
        sliceFrameThicknessesChanged: PySide2.QtCore.Signal
        sliceFrameWidthsChanged: PySide2.QtCore.Signal
        sliceIndexXChanged: PySide2.QtCore.Signal
        sliceIndexYChanged: PySide2.QtCore.Signal
        sliceIndexZChanged: PySide2.QtCore.Signal
        textureDataChanged: PySide2.QtCore.Signal
        textureDepthChanged: PySide2.QtCore.Signal
        textureFormatChanged: PySide2.QtCore.Signal
        textureHeightChanged: PySide2.QtCore.Signal
        textureWidthChanged: PySide2.QtCore.Signal
        useHighDefShaderChanged: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, position:PySide2.QtGui.QVector3D, scaling:PySide2.QtGui.QVector3D, rotation:PySide2.QtGui.QQuaternion, textureWidth:int, textureHeight:int, textureDepth:int, textureData:typing.List, textureFormat:PySide2.QtGui.QImage.Format, colorTable:typing.List, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def alphaMultiplier(self) -> float: ...
        def colorTable(self) -> typing.List: ...
        def createTextureData(self, images:typing.List) -> typing.List: ...
        def drawSliceFrames(self) -> bool: ...
        def drawSlices(self) -> bool: ...
        def preserveOpacity(self) -> bool: ...
        def renderSlice(self, axis:PySide2.QtCore.Qt.Axis, index:int) -> PySide2.QtGui.QImage: ...
        def setAlphaMultiplier(self, mult:float) -> None: ...
        def setColorTable(self, colors:typing.List) -> None: ...
        def setDrawSliceFrames(self, enable:bool) -> None: ...
        def setDrawSlices(self, enable:bool) -> None: ...
        def setPreserveOpacity(self, enable:bool) -> None: ...
        def setSliceFrameColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setSliceFrameGaps(self, values:PySide2.QtGui.QVector3D) -> None: ...
        def setSliceFrameThicknesses(self, values:PySide2.QtGui.QVector3D) -> None: ...
        def setSliceFrameWidths(self, values:PySide2.QtGui.QVector3D) -> None: ...
        def setSliceIndexX(self, value:int) -> None: ...
        def setSliceIndexY(self, value:int) -> None: ...
        def setSliceIndexZ(self, value:int) -> None: ...
        def setSliceIndices(self, x:int, y:int, z:int) -> None: ...
        @typing.overload
        def setSubTextureData(self, axis:PySide2.QtCore.Qt.Axis, index:int, data:bytes) -> None: ...
        @typing.overload
        def setSubTextureData(self, axis:PySide2.QtCore.Qt.Axis, index:int, image:PySide2.QtGui.QImage) -> None: ...
        def setTextureData(self, data:typing.List) -> None: ...
        def setTextureDepth(self, value:int) -> None: ...
        def setTextureDimensions(self, width:int, height:int, depth:int) -> None: ...
        def setTextureFormat(self, format:PySide2.QtGui.QImage.Format) -> None: ...
        def setTextureHeight(self, value:int) -> None: ...
        def setTextureWidth(self, value:int) -> None: ...
        def setUseHighDefShader(self, enable:bool) -> None: ...
        def sliceFrameColor(self) -> PySide2.QtGui.QColor: ...
        def sliceFrameGaps(self) -> PySide2.QtGui.QVector3D: ...
        def sliceFrameThicknesses(self) -> PySide2.QtGui.QVector3D: ...
        def sliceFrameWidths(self) -> PySide2.QtGui.QVector3D: ...
        def sliceIndexX(self) -> int: ...
        def sliceIndexY(self) -> int: ...
        def sliceIndexZ(self) -> int: ...
        def textureData(self) -> typing.List: ...
        def textureDataWidth(self) -> int: ...
        def textureDepth(self) -> int: ...
        def textureFormat(self) -> PySide2.QtGui.QImage.Format: ...
        def textureHeight(self) -> int: ...
        def textureWidth(self) -> int: ...
        def useHighDefShader(self) -> bool: ...

    class QHeightMapSurfaceDataProxy(PySide2.QtDataVisualization.QSurfaceDataProxy):

        heightMapChanged: PySide2.QtCore.Signal
        heightMapFileChanged: PySide2.QtCore.Signal
        maxXValueChanged: PySide2.QtCore.Signal
        maxZValueChanged: PySide2.QtCore.Signal
        minXValueChanged: PySide2.QtCore.Signal
        minZValueChanged: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, filename:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, image:PySide2.QtGui.QImage, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def heightMap(self) -> PySide2.QtGui.QImage: ...
        def heightMapFile(self) -> str: ...
        def maxXValue(self) -> float: ...
        def maxZValue(self) -> float: ...
        def minXValue(self) -> float: ...
        def minZValue(self) -> float: ...
        def setHeightMap(self, image:PySide2.QtGui.QImage) -> None: ...
        def setHeightMapFile(self, filename:str) -> None: ...
        def setMaxXValue(self, max:float) -> None: ...
        def setMaxZValue(self, max:float) -> None: ...
        def setMinXValue(self, min:float) -> None: ...
        def setMinZValue(self, min:float) -> None: ...
        def setValueRanges(self, minX:float, maxX:float, minZ:float, maxZ:float) -> None: ...

    class QItemModelBarDataProxy(PySide2.QtDataVisualization.QBarDataProxy):

        autoColumnCategoriesChanged: PySide2.QtCore.Signal
        autoRowCategoriesChanged: PySide2.QtCore.Signal
        columnCategoriesChanged: PySide2.QtCore.Signal
        columnRoleChanged: PySide2.QtCore.Signal
        columnRolePatternChanged: PySide2.QtCore.Signal
        columnRoleReplaceChanged: PySide2.QtCore.Signal
        itemModelChanged: PySide2.QtCore.Signal
        multiMatchBehaviorChanged: PySide2.QtCore.Signal
        rotationRoleChanged: PySide2.QtCore.Signal
        rotationRolePatternChanged: PySide2.QtCore.Signal
        rotationRoleReplaceChanged: PySide2.QtCore.Signal
        rowCategoriesChanged: PySide2.QtCore.Signal
        rowRoleChanged: PySide2.QtCore.Signal
        rowRolePatternChanged: PySide2.QtCore.Signal
        rowRoleReplaceChanged: PySide2.QtCore.Signal
        useModelCategoriesChanged: PySide2.QtCore.Signal
        valueRoleChanged: PySide2.QtCore.Signal
        valueRolePatternChanged: PySide2.QtCore.Signal
        valueRoleReplaceChanged: PySide2.QtCore.Signal

        MMBFirst                 : QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x0
        MMBLast                  : QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x1
        MMBAverage               : QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x2
        MMBCumulative            : QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x3

        class MultiMatchBehavior(object):
            MMBFirst                 : QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x0
            MMBLast                  : QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x1
            MMBAverage               : QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x2
            MMBCumulative            : QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior = ... # 0x3

        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, rowRole:str, columnRole:str, valueRole:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, rowRole:str, columnRole:str, valueRole:str, rotationRole:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, rowRole:str, columnRole:str, valueRole:str, rotationRole:str, rowCategories:typing.Sequence, columnCategories:typing.Sequence, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, rowRole:str, columnRole:str, valueRole:str, rowCategories:typing.Sequence, columnCategories:typing.Sequence, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, valueRole:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def autoColumnCategories(self) -> bool: ...
        def autoRowCategories(self) -> bool: ...
        def columnCategories(self) -> typing.List: ...
        def columnCategoryIndex(self, category:str) -> int: ...
        def columnRole(self) -> str: ...
        def columnRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def columnRoleReplace(self) -> str: ...
        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def multiMatchBehavior(self) -> PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior: ...
        def remap(self, rowRole:str, columnRole:str, valueRole:str, rotationRole:str, rowCategories:typing.Sequence, columnCategories:typing.Sequence) -> None: ...
        def rotationRole(self) -> str: ...
        def rotationRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rotationRoleReplace(self) -> str: ...
        def rowCategories(self) -> typing.List: ...
        def rowCategoryIndex(self, category:str) -> int: ...
        def rowRole(self) -> str: ...
        def rowRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rowRoleReplace(self) -> str: ...
        def setAutoColumnCategories(self, enable:bool) -> None: ...
        def setAutoRowCategories(self, enable:bool) -> None: ...
        def setColumnCategories(self, categories:typing.Sequence) -> None: ...
        def setColumnRole(self, role:str) -> None: ...
        def setColumnRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setColumnRoleReplace(self, replace:str) -> None: ...
        def setItemModel(self, itemModel:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setMultiMatchBehavior(self, behavior:PySide2.QtDataVisualization.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior) -> None: ...
        def setRotationRole(self, role:str) -> None: ...
        def setRotationRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setRotationRoleReplace(self, replace:str) -> None: ...
        def setRowCategories(self, categories:typing.Sequence) -> None: ...
        def setRowRole(self, role:str) -> None: ...
        def setRowRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setRowRoleReplace(self, replace:str) -> None: ...
        def setUseModelCategories(self, enable:bool) -> None: ...
        def setValueRole(self, role:str) -> None: ...
        def setValueRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setValueRoleReplace(self, replace:str) -> None: ...
        def useModelCategories(self) -> bool: ...
        def valueRole(self) -> str: ...
        def valueRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def valueRoleReplace(self) -> str: ...

    class QItemModelScatterDataProxy(PySide2.QtDataVisualization.QScatterDataProxy):

        itemModelChanged: PySide2.QtCore.Signal
        rotationRoleChanged: PySide2.QtCore.Signal
        rotationRolePatternChanged: PySide2.QtCore.Signal
        rotationRoleReplaceChanged: PySide2.QtCore.Signal
        xPosRoleChanged: PySide2.QtCore.Signal
        xPosRolePatternChanged: PySide2.QtCore.Signal
        xPosRoleReplaceChanged: PySide2.QtCore.Signal
        yPosRoleChanged: PySide2.QtCore.Signal
        yPosRolePatternChanged: PySide2.QtCore.Signal
        yPosRoleReplaceChanged: PySide2.QtCore.Signal
        zPosRoleChanged: PySide2.QtCore.Signal
        zPosRolePatternChanged: PySide2.QtCore.Signal
        zPosRoleReplaceChanged: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, xPosRole:str, yPosRole:str, zPosRole:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, xPosRole:str, yPosRole:str, zPosRole:str, rotationRole:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def remap(self, xPosRole:str, yPosRole:str, zPosRole:str, rotationRole:str) -> None: ...
        def rotationRole(self) -> str: ...
        def rotationRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rotationRoleReplace(self) -> str: ...
        def setItemModel(self, itemModel:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setRotationRole(self, role:str) -> None: ...
        def setRotationRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setRotationRoleReplace(self, replace:str) -> None: ...
        def setXPosRole(self, role:str) -> None: ...
        def setXPosRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setXPosRoleReplace(self, replace:str) -> None: ...
        def setYPosRole(self, role:str) -> None: ...
        def setYPosRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setYPosRoleReplace(self, replace:str) -> None: ...
        def setZPosRole(self, role:str) -> None: ...
        def setZPosRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setZPosRoleReplace(self, replace:str) -> None: ...
        def xPosRole(self) -> str: ...
        def xPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def xPosRoleReplace(self) -> str: ...
        def yPosRole(self) -> str: ...
        def yPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def yPosRoleReplace(self) -> str: ...
        def zPosRole(self) -> str: ...
        def zPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def zPosRoleReplace(self) -> str: ...

    class QItemModelSurfaceDataProxy(PySide2.QtDataVisualization.QSurfaceDataProxy):

        autoColumnCategoriesChanged: PySide2.QtCore.Signal
        autoRowCategoriesChanged: PySide2.QtCore.Signal
        columnCategoriesChanged: PySide2.QtCore.Signal
        columnRoleChanged: PySide2.QtCore.Signal
        columnRolePatternChanged: PySide2.QtCore.Signal
        columnRoleReplaceChanged: PySide2.QtCore.Signal
        itemModelChanged: PySide2.QtCore.Signal
        multiMatchBehaviorChanged: PySide2.QtCore.Signal
        rowCategoriesChanged: PySide2.QtCore.Signal
        rowRoleChanged: PySide2.QtCore.Signal
        rowRolePatternChanged: PySide2.QtCore.Signal
        rowRoleReplaceChanged: PySide2.QtCore.Signal
        useModelCategoriesChanged: PySide2.QtCore.Signal
        xPosRoleChanged: PySide2.QtCore.Signal
        xPosRolePatternChanged: PySide2.QtCore.Signal
        xPosRoleReplaceChanged: PySide2.QtCore.Signal
        yPosRoleChanged: PySide2.QtCore.Signal
        yPosRolePatternChanged: PySide2.QtCore.Signal
        yPosRoleReplaceChanged: PySide2.QtCore.Signal
        zPosRoleChanged: PySide2.QtCore.Signal
        zPosRolePatternChanged: PySide2.QtCore.Signal
        zPosRoleReplaceChanged: PySide2.QtCore.Signal

        MMBFirst                 : QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x0
        MMBLast                  : QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x1
        MMBAverage               : QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x2
        MMBCumulativeY           : QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x3

        class MultiMatchBehavior(object):
            MMBFirst                 : QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x0
            MMBLast                  : QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x1
            MMBAverage               : QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x2
            MMBCumulativeY           : QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior = ... # 0x3

        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, rowRole:str, columnRole:str, xPosRole:str, yPosRole:str, zPosRole:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, rowRole:str, columnRole:str, xPosRole:str, yPosRole:str, zPosRole:str, rowCategories:typing.Sequence, columnCategories:typing.Sequence, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, rowRole:str, columnRole:str, yPosRole:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, rowRole:str, columnRole:str, yPosRole:str, rowCategories:typing.Sequence, columnCategories:typing.Sequence, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, itemModel:PySide2.QtCore.QAbstractItemModel, yPosRole:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def autoColumnCategories(self) -> bool: ...
        def autoRowCategories(self) -> bool: ...
        def columnCategories(self) -> typing.List: ...
        def columnCategoryIndex(self, category:str) -> int: ...
        def columnRole(self) -> str: ...
        def columnRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def columnRoleReplace(self) -> str: ...
        def itemModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def multiMatchBehavior(self) -> PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior: ...
        def remap(self, rowRole:str, columnRole:str, xPosRole:str, yPosRole:str, zPosRole:str, rowCategories:typing.Sequence, columnCategories:typing.Sequence) -> None: ...
        def rowCategories(self) -> typing.List: ...
        def rowCategoryIndex(self, category:str) -> int: ...
        def rowRole(self) -> str: ...
        def rowRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def rowRoleReplace(self) -> str: ...
        def setAutoColumnCategories(self, enable:bool) -> None: ...
        def setAutoRowCategories(self, enable:bool) -> None: ...
        def setColumnCategories(self, categories:typing.Sequence) -> None: ...
        def setColumnRole(self, role:str) -> None: ...
        def setColumnRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setColumnRoleReplace(self, replace:str) -> None: ...
        def setItemModel(self, itemModel:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setMultiMatchBehavior(self, behavior:PySide2.QtDataVisualization.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior) -> None: ...
        def setRowCategories(self, categories:typing.Sequence) -> None: ...
        def setRowRole(self, role:str) -> None: ...
        def setRowRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setRowRoleReplace(self, replace:str) -> None: ...
        def setUseModelCategories(self, enable:bool) -> None: ...
        def setXPosRole(self, role:str) -> None: ...
        def setXPosRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setXPosRoleReplace(self, replace:str) -> None: ...
        def setYPosRole(self, role:str) -> None: ...
        def setYPosRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setYPosRoleReplace(self, replace:str) -> None: ...
        def setZPosRole(self, role:str) -> None: ...
        def setZPosRolePattern(self, pattern:PySide2.QtCore.QRegExp) -> None: ...
        def setZPosRoleReplace(self, replace:str) -> None: ...
        def useModelCategories(self) -> bool: ...
        def xPosRole(self) -> str: ...
        def xPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def xPosRoleReplace(self) -> str: ...
        def yPosRole(self) -> str: ...
        def yPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def yPosRoleReplace(self) -> str: ...
        def zPosRole(self) -> str: ...
        def zPosRolePattern(self) -> PySide2.QtCore.QRegExp: ...
        def zPosRoleReplace(self) -> str: ...

    class QLogValue3DAxisFormatter(PySide2.QtDataVisualization.QValue3DAxisFormatter):

        autoSubGridChanged: PySide2.QtCore.Signal
        baseChanged: PySide2.QtCore.Signal
        showEdgeLabelsChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def autoSubGrid(self) -> bool: ...
        def base(self) -> float: ...
        def createNewInstance(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter: ...
        def populateCopy(self, copy:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter) -> None: ...
        def positionAt(self, value:float) -> float: ...
        def recalculate(self) -> None: ...
        def setAutoSubGrid(self, enabled:bool) -> None: ...
        def setBase(self, base:float) -> None: ...
        def setShowEdgeLabels(self, enabled:bool) -> None: ...
        def showEdgeLabels(self) -> bool: ...
        def valueAt(self, position:float) -> float: ...

    class QScatter3DSeries(PySide2.QtDataVisualization.QAbstract3DSeries):

        dataProxyChanged: PySide2.QtCore.Signal
        itemSizeChanged: PySide2.QtCore.Signal
        selectedItemChanged: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, dataProxy:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def dataProxy(self) -> PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy: ...
        @staticmethod
        def invalidSelectionIndex() -> int: ...
        def itemSize(self) -> float: ...
        def selectedItem(self) -> int: ...
        def setDataProxy(self, proxy:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataProxy) -> None: ...
        def setItemSize(self, size:float) -> None: ...
        def setSelectedItem(self, index:int) -> None: ...

    class QScatterDataItem(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem) -> None: ...
        @typing.overload
        def __init__(self, position:PySide2.QtGui.QVector3D) -> None: ...
        @typing.overload
        def __init__(self, position:PySide2.QtGui.QVector3D, rotation:PySide2.QtGui.QQuaternion) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def createExtraData(self) -> None: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def rotation(self) -> PySide2.QtGui.QQuaternion: ...
        def setPosition(self, pos:PySide2.QtGui.QVector3D) -> None: ...
        def setRotation(self, rot:PySide2.QtGui.QQuaternion) -> None: ...
        def setX(self, value:float) -> None: ...
        def setY(self, value:float) -> None: ...
        def setZ(self, value:float) -> None: ...
        def x(self) -> float: ...
        def y(self) -> float: ...
        def z(self) -> float: ...

    class QScatterDataProxy(PySide2.QtDataVisualization.QAbstractDataProxy):

        arrayReset: PySide2.QtCore.Signal
        itemCountChanged: PySide2.QtCore.Signal
        itemsAdded: PySide2.QtCore.Signal
        itemsChanged: PySide2.QtCore.Signal
        itemsInserted: PySide2.QtCore.Signal
        itemsRemoved: PySide2.QtCore.Signal
        seriesChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def addItem(self, item:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem) -> int: ...
        def addItems(self, items:typing.List) -> int: ...
        def array(self) -> typing.List: ...
        def insertItem(self, index:int, item:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem) -> None: ...
        def insertItems(self, index:int, items:typing.List) -> None: ...
        def itemAt(self, index:int) -> PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem: ...
        def itemCount(self) -> int: ...
        def removeItems(self, index:int, removeCount:int) -> None: ...
        def resetArray(self, newArray:typing.List) -> None: ...
        def series(self) -> PySide2.QtDataVisualization.QtDataVisualization.QScatter3DSeries: ...
        def setItem(self, index:int, item:PySide2.QtDataVisualization.QtDataVisualization.QScatterDataItem) -> None: ...
        def setItems(self, index:int, items:typing.List) -> None: ...

    class QSurface3DSeries(PySide2.QtDataVisualization.QAbstract3DSeries):

        dataProxyChanged: PySide2.QtCore.Signal
        drawModeChanged: PySide2.QtCore.Signal
        flatShadingEnabledChanged: PySide2.QtCore.Signal
        flatShadingSupportedChanged: PySide2.QtCore.Signal
        selectedPointChanged: PySide2.QtCore.Signal
        textureChanged: PySide2.QtCore.Signal
        textureFileChanged: PySide2.QtCore.Signal

        DrawWireframe            : QtDataVisualization.QSurface3DSeries.DrawFlag = ... # 0x1
        DrawSurface              : QtDataVisualization.QSurface3DSeries.DrawFlag = ... # 0x2
        DrawSurfaceAndWireframe  : QtDataVisualization.QSurface3DSeries.DrawFlag = ... # 0x3

        class DrawFlag(object):
            DrawWireframe            : QtDataVisualization.QSurface3DSeries.DrawFlag = ... # 0x1
            DrawSurface              : QtDataVisualization.QSurface3DSeries.DrawFlag = ... # 0x2
            DrawSurfaceAndWireframe  : QtDataVisualization.QSurface3DSeries.DrawFlag = ... # 0x3
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, DrawFlag] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __and__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __xor__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __ror__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __rand__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __rxor__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __ior__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __iand__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __ixor__(self, other: typing.Union[int, DrawFlag]) -> DrawFlags: ...
            def __invert__(self) -> DrawFlags: ...

        class DrawFlags(object):
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, DrawFlag, DrawFlags] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __and__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __xor__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __ror__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __rand__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __rxor__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __ior__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __iand__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __ixor__(self, other: typing.Union[int, DrawFlag, DrawFlags]) -> DrawFlags: ...
            def __invert__(self) -> DrawFlags: ...

        @typing.overload
        def __init__(self, dataProxy:PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataProxy, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def dataProxy(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataProxy: ...
        def drawMode(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries.DrawFlags: ...
        @staticmethod
        def invalidSelectionPosition() -> PySide2.QtCore.QPoint: ...
        def isFlatShadingEnabled(self) -> bool: ...
        def isFlatShadingSupported(self) -> bool: ...
        def selectedPoint(self) -> PySide2.QtCore.QPoint: ...
        def setDataProxy(self, proxy:PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataProxy) -> None: ...
        def setDrawMode(self, mode:PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries.DrawFlags) -> None: ...
        def setFlatShadingEnabled(self, enabled:bool) -> None: ...
        def setSelectedPoint(self, position:PySide2.QtCore.QPoint) -> None: ...
        def setTexture(self, texture:PySide2.QtGui.QImage) -> None: ...
        def setTextureFile(self, filename:str) -> None: ...
        def texture(self) -> PySide2.QtGui.QImage: ...
        def textureFile(self) -> str: ...

    class QSurfaceDataItem(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other:PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem) -> None: ...
        @typing.overload
        def __init__(self, position:PySide2.QtGui.QVector3D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def createExtraData(self) -> None: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def setPosition(self, pos:PySide2.QtGui.QVector3D) -> None: ...
        def setX(self, value:float) -> None: ...
        def setY(self, value:float) -> None: ...
        def setZ(self, value:float) -> None: ...
        def x(self) -> float: ...
        def y(self) -> float: ...
        def z(self) -> float: ...

    class QSurfaceDataProxy(PySide2.QtDataVisualization.QAbstractDataProxy):

        arrayReset: PySide2.QtCore.Signal
        columnCountChanged: PySide2.QtCore.Signal
        itemChanged: PySide2.QtCore.Signal
        rowCountChanged: PySide2.QtCore.Signal
        rowsAdded: PySide2.QtCore.Signal
        rowsChanged: PySide2.QtCore.Signal
        rowsInserted: PySide2.QtCore.Signal
        rowsRemoved: PySide2.QtCore.Signal
        seriesChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def addRow(self, row:typing.List) -> int: ...
        def addRows(self, rows:typing.List) -> int: ...
        def array(self) -> typing.List: ...
        def columnCount(self) -> int: ...
        def insertRow(self, rowIndex:int, row:typing.List) -> None: ...
        def insertRows(self, rowIndex:int, rows:typing.List) -> None: ...
        @typing.overload
        def itemAt(self, position:PySide2.QtCore.QPoint) -> PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem: ...
        @typing.overload
        def itemAt(self, rowIndex:int, columnIndex:int) -> PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem: ...
        def removeRows(self, rowIndex:int, removeCount:int) -> None: ...
        def resetArray(self, newArray:typing.List) -> None: ...
        def rowCount(self) -> int: ...
        def series(self) -> PySide2.QtDataVisualization.QtDataVisualization.QSurface3DSeries: ...
        @typing.overload
        def setItem(self, position:PySide2.QtCore.QPoint, item:PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem) -> None: ...
        @typing.overload
        def setItem(self, rowIndex:int, columnIndex:int, item:PySide2.QtDataVisualization.QtDataVisualization.QSurfaceDataItem) -> None: ...
        def setRow(self, rowIndex:int, row:typing.List) -> None: ...
        def setRows(self, rowIndex:int, rows:typing.List) -> None: ...

    class QTouch3DInputHandler(PySide2.QtDataVisualization.Q3DInputHandler):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def touchEvent(self, event:PySide2.QtGui.QTouchEvent) -> None: ...

    class QValue3DAxis(PySide2.QtDataVisualization.QAbstract3DAxis):

        formatterChanged: PySide2.QtCore.Signal
        labelFormatChanged: PySide2.QtCore.Signal
        reversedChanged: PySide2.QtCore.Signal
        segmentCountChanged: PySide2.QtCore.Signal
        subSegmentCountChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def formatter(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter: ...
        def labelFormat(self) -> str: ...
        def reversed(self) -> bool: ...
        def segmentCount(self) -> int: ...
        def setFormatter(self, formatter:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter) -> None: ...
        def setLabelFormat(self, format:str) -> None: ...
        def setReversed(self, enable:bool) -> None: ...
        def setSegmentCount(self, count:int) -> None: ...
        def setSubSegmentCount(self, count:int) -> None: ...
        def subSegmentCount(self) -> int: ...

    class QValue3DAxisFormatter(PySide2.QtCore.QObject):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def allowNegatives(self) -> bool: ...
        def allowZero(self) -> bool: ...
        def axis(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxis: ...
        def createNewInstance(self) -> PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter: ...
        def gridPositions(self) -> typing.List: ...
        def labelPositions(self) -> typing.List: ...
        def labelStrings(self) -> typing.List: ...
        def locale(self) -> PySide2.QtCore.QLocale: ...
        def markDirty(self, labelsChange:bool=...) -> None: ...
        def populateCopy(self, copy:PySide2.QtDataVisualization.QtDataVisualization.QValue3DAxisFormatter) -> None: ...
        def positionAt(self, value:float) -> float: ...
        def recalculate(self) -> None: ...
        def setAllowNegatives(self, allow:bool) -> None: ...
        def setAllowZero(self, allow:bool) -> None: ...
        def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...
        def stringForValue(self, value:float, format:str) -> str: ...
        def subGridPositions(self) -> typing.List: ...
        def valueAt(self, position:float) -> float: ...
    @typing.overload
    @staticmethod
    def qDefaultSurfaceFormat(antialias:bool) -> PySide2.QtGui.QSurfaceFormat: ...
    @typing.overload
    @staticmethod
    def qDefaultSurfaceFormat(antialias:bool=...) -> PySide2.QtGui.QSurfaceFormat: ...

# eof
