# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtCharts, except for defaults which are replaced by "...".
"""

import sys

# Module PySide2.QtCharts
import PySide2
import typing

import shiboken2 as Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import PySide2.QtCharts


class QtCharts(Shiboken.Object):

    class QAbstractAxis(PySide2.QtCore.QObject):

        colorChanged: PySide2.QtCore.Signal
        gridLineColorChanged: PySide2.QtCore.Signal
        gridLinePenChanged: PySide2.QtCore.Signal
        gridVisibleChanged: PySide2.QtCore.Signal
        labelsAngleChanged: PySide2.QtCore.Signal
        labelsBrushChanged: PySide2.QtCore.Signal
        labelsColorChanged: PySide2.QtCore.Signal
        labelsEditableChanged: PySide2.QtCore.Signal
        labelsFontChanged: PySide2.QtCore.Signal
        labelsVisibleChanged: PySide2.QtCore.Signal
        linePenChanged: PySide2.QtCore.Signal
        lineVisibleChanged: PySide2.QtCore.Signal
        minorGridLineColorChanged: PySide2.QtCore.Signal
        minorGridLinePenChanged: PySide2.QtCore.Signal
        minorGridVisibleChanged: PySide2.QtCore.Signal
        reverseChanged: PySide2.QtCore.Signal
        shadesBorderColorChanged: PySide2.QtCore.Signal
        shadesBrushChanged: PySide2.QtCore.Signal
        shadesColorChanged: PySide2.QtCore.Signal
        shadesPenChanged: PySide2.QtCore.Signal
        shadesVisibleChanged: PySide2.QtCore.Signal
        titleBrushChanged: PySide2.QtCore.Signal
        titleFontChanged: PySide2.QtCore.Signal
        titleTextChanged: PySide2.QtCore.Signal
        titleVisibleChanged: PySide2.QtCore.Signal
        visibleChanged: PySide2.QtCore.Signal

        AxisTypeNoAxis           : QtCharts.QAbstractAxis.AxisType = ... # 0x0
        AxisTypeValue            : QtCharts.QAbstractAxis.AxisType = ... # 0x1
        AxisTypeBarCategory      : QtCharts.QAbstractAxis.AxisType = ... # 0x2
        AxisTypeCategory         : QtCharts.QAbstractAxis.AxisType = ... # 0x4
        AxisTypeDateTime         : QtCharts.QAbstractAxis.AxisType = ... # 0x8
        AxisTypeLogValue         : QtCharts.QAbstractAxis.AxisType = ... # 0x10

        class AxisType(object):
            AxisTypeNoAxis           : QtCharts.QAbstractAxis.AxisType = ... # 0x0
            AxisTypeValue            : QtCharts.QAbstractAxis.AxisType = ... # 0x1
            AxisTypeBarCategory      : QtCharts.QAbstractAxis.AxisType = ... # 0x2
            AxisTypeCategory         : QtCharts.QAbstractAxis.AxisType = ... # 0x4
            AxisTypeDateTime         : QtCharts.QAbstractAxis.AxisType = ... # 0x8
            AxisTypeLogValue         : QtCharts.QAbstractAxis.AxisType = ... # 0x10
        def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
        def gridLineColor(self) -> PySide2.QtGui.QColor: ...
        def gridLinePen(self) -> PySide2.QtGui.QPen: ...
        def hide(self) -> None: ...
        def isGridLineVisible(self) -> bool: ...
        def isLineVisible(self) -> bool: ...
        def isMinorGridLineVisible(self) -> bool: ...
        def isReverse(self) -> bool: ...
        def isTitleVisible(self) -> bool: ...
        def isVisible(self) -> bool: ...
        def labelsAngle(self) -> int: ...
        def labelsBrush(self) -> PySide2.QtGui.QBrush: ...
        def labelsColor(self) -> PySide2.QtGui.QColor: ...
        def labelsEditable(self) -> bool: ...
        def labelsFont(self) -> PySide2.QtGui.QFont: ...
        def labelsVisible(self) -> bool: ...
        def linePen(self) -> PySide2.QtGui.QPen: ...
        def linePenColor(self) -> PySide2.QtGui.QColor: ...
        def minorGridLineColor(self) -> PySide2.QtGui.QColor: ...
        def minorGridLinePen(self) -> PySide2.QtGui.QPen: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def setGridLineColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setGridLinePen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setGridLineVisible(self, visible:bool=...) -> None: ...
        def setLabelsAngle(self, angle:int) -> None: ...
        def setLabelsBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setLabelsColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLabelsEditable(self, editable:bool=...) -> None: ...
        def setLabelsFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setLabelsVisible(self, visible:bool=...) -> None: ...
        def setLinePen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setLinePenColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLineVisible(self, visible:bool=...) -> None: ...
        def setMax(self, max:typing.Any) -> None: ...
        def setMin(self, min:typing.Any) -> None: ...
        def setMinorGridLineColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setMinorGridLinePen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setMinorGridLineVisible(self, visible:bool=...) -> None: ...
        def setRange(self, min:typing.Any, max:typing.Any) -> None: ...
        def setReverse(self, reverse:bool=...) -> None: ...
        def setShadesBorderColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setShadesBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setShadesColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setShadesPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setShadesVisible(self, visible:bool=...) -> None: ...
        def setTitleBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setTitleFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setTitleText(self, title:str) -> None: ...
        def setTitleVisible(self, visible:bool=...) -> None: ...
        def setVisible(self, visible:bool=...) -> None: ...
        def shadesBorderColor(self) -> PySide2.QtGui.QColor: ...
        def shadesBrush(self) -> PySide2.QtGui.QBrush: ...
        def shadesColor(self) -> PySide2.QtGui.QColor: ...
        def shadesPen(self) -> PySide2.QtGui.QPen: ...
        def shadesVisible(self) -> bool: ...
        def show(self) -> None: ...
        def titleBrush(self) -> PySide2.QtGui.QBrush: ...
        def titleFont(self) -> PySide2.QtGui.QFont: ...
        def titleText(self) -> str: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractAxis.AxisType: ...

    class QAbstractBarSeries(PySide2.QtCharts.QAbstractSeries):

        barsetsAdded: PySide2.QtCore.Signal
        barsetsRemoved: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        countChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        labelsAngleChanged: PySide2.QtCore.Signal
        labelsFormatChanged: PySide2.QtCore.Signal
        labelsPositionChanged: PySide2.QtCore.Signal
        labelsPrecisionChanged: PySide2.QtCore.Signal
        labelsVisibleChanged: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal

        LabelsCenter             : QtCharts.QAbstractBarSeries.LabelsPosition = ... # 0x0
        LabelsInsideEnd          : QtCharts.QAbstractBarSeries.LabelsPosition = ... # 0x1
        LabelsInsideBase         : QtCharts.QAbstractBarSeries.LabelsPosition = ... # 0x2
        LabelsOutsideEnd         : QtCharts.QAbstractBarSeries.LabelsPosition = ... # 0x3

        class LabelsPosition(object):
            LabelsCenter             : QtCharts.QAbstractBarSeries.LabelsPosition = ... # 0x0
            LabelsInsideEnd          : QtCharts.QAbstractBarSeries.LabelsPosition = ... # 0x1
            LabelsInsideBase         : QtCharts.QAbstractBarSeries.LabelsPosition = ... # 0x2
            LabelsOutsideEnd         : QtCharts.QAbstractBarSeries.LabelsPosition = ... # 0x3
        @typing.overload
        def append(self, set:PySide2.QtCharts.QtCharts.QBarSet) -> bool: ...
        @typing.overload
        def append(self, sets:typing.Sequence) -> bool: ...
        def barSets(self) -> typing.List: ...
        def barWidth(self) -> float: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def insert(self, index:int, set:PySide2.QtCharts.QtCharts.QBarSet) -> bool: ...
        def isLabelsVisible(self) -> bool: ...
        def labelsAngle(self) -> float: ...
        def labelsFormat(self) -> str: ...
        def labelsPosition(self) -> PySide2.QtCharts.QtCharts.QAbstractBarSeries.LabelsPosition: ...
        def labelsPrecision(self) -> int: ...
        def remove(self, set:PySide2.QtCharts.QtCharts.QBarSet) -> bool: ...
        def setBarWidth(self, width:float) -> None: ...
        def setLabelsAngle(self, angle:float) -> None: ...
        def setLabelsFormat(self, format:str) -> None: ...
        def setLabelsPosition(self, position:PySide2.QtCharts.QtCharts.QAbstractBarSeries.LabelsPosition) -> None: ...
        def setLabelsPrecision(self, precision:int) -> None: ...
        def setLabelsVisible(self, visible:bool=...) -> None: ...
        def take(self, set:PySide2.QtCharts.QtCharts.QBarSet) -> bool: ...

    class QAbstractSeries(PySide2.QtCore.QObject):

        nameChanged: PySide2.QtCore.Signal
        opacityChanged: PySide2.QtCore.Signal
        useOpenGLChanged: PySide2.QtCore.Signal
        visibleChanged: PySide2.QtCore.Signal

        SeriesTypeLine           : QtCharts.QAbstractSeries.SeriesType = ... # 0x0
        SeriesTypeArea           : QtCharts.QAbstractSeries.SeriesType = ... # 0x1
        SeriesTypeBar            : QtCharts.QAbstractSeries.SeriesType = ... # 0x2
        SeriesTypeStackedBar     : QtCharts.QAbstractSeries.SeriesType = ... # 0x3
        SeriesTypePercentBar     : QtCharts.QAbstractSeries.SeriesType = ... # 0x4
        SeriesTypePie            : QtCharts.QAbstractSeries.SeriesType = ... # 0x5
        SeriesTypeScatter        : QtCharts.QAbstractSeries.SeriesType = ... # 0x6
        SeriesTypeSpline         : QtCharts.QAbstractSeries.SeriesType = ... # 0x7
        SeriesTypeHorizontalBar  : QtCharts.QAbstractSeries.SeriesType = ... # 0x8
        SeriesTypeHorizontalStackedBar: QtCharts.QAbstractSeries.SeriesType = ... # 0x9
        SeriesTypeHorizontalPercentBar: QtCharts.QAbstractSeries.SeriesType = ... # 0xa
        SeriesTypeBoxPlot        : QtCharts.QAbstractSeries.SeriesType = ... # 0xb
        SeriesTypeCandlestick    : QtCharts.QAbstractSeries.SeriesType = ... # 0xc

        class SeriesType(object):
            SeriesTypeLine           : QtCharts.QAbstractSeries.SeriesType = ... # 0x0
            SeriesTypeArea           : QtCharts.QAbstractSeries.SeriesType = ... # 0x1
            SeriesTypeBar            : QtCharts.QAbstractSeries.SeriesType = ... # 0x2
            SeriesTypeStackedBar     : QtCharts.QAbstractSeries.SeriesType = ... # 0x3
            SeriesTypePercentBar     : QtCharts.QAbstractSeries.SeriesType = ... # 0x4
            SeriesTypePie            : QtCharts.QAbstractSeries.SeriesType = ... # 0x5
            SeriesTypeScatter        : QtCharts.QAbstractSeries.SeriesType = ... # 0x6
            SeriesTypeSpline         : QtCharts.QAbstractSeries.SeriesType = ... # 0x7
            SeriesTypeHorizontalBar  : QtCharts.QAbstractSeries.SeriesType = ... # 0x8
            SeriesTypeHorizontalStackedBar: QtCharts.QAbstractSeries.SeriesType = ... # 0x9
            SeriesTypeHorizontalPercentBar: QtCharts.QAbstractSeries.SeriesType = ... # 0xa
            SeriesTypeBoxPlot        : QtCharts.QAbstractSeries.SeriesType = ... # 0xb
            SeriesTypeCandlestick    : QtCharts.QAbstractSeries.SeriesType = ... # 0xc
        def attachAxis(self, axis:PySide2.QtCharts.QtCharts.QAbstractAxis) -> bool: ...
        def attachedAxes(self) -> typing.List: ...
        def chart(self) -> PySide2.QtCharts.QtCharts.QChart: ...
        def detachAxis(self, axis:PySide2.QtCharts.QtCharts.QAbstractAxis) -> bool: ...
        def hide(self) -> None: ...
        def isVisible(self) -> bool: ...
        def name(self) -> str: ...
        def opacity(self) -> float: ...
        def setName(self, name:str) -> None: ...
        def setOpacity(self, opacity:float) -> None: ...
        def setUseOpenGL(self, enable:bool=...) -> None: ...
        def setVisible(self, visible:bool=...) -> None: ...
        def show(self) -> None: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...
        def useOpenGL(self) -> bool: ...

    class QAreaLegendMarker(PySide2.QtCharts.QLegendMarker):

        def __init__(self, series:PySide2.QtCharts.QtCharts.QAreaSeries, legend:PySide2.QtCharts.QtCharts.QLegend, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def series(self) -> PySide2.QtCharts.QtCharts.QAreaSeries: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QLegendMarker.LegendMarkerType: ...

    class QAreaSeries(PySide2.QtCharts.QAbstractSeries):

        borderColorChanged: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        colorChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        pointLabelsClippingChanged: PySide2.QtCore.Signal
        pointLabelsColorChanged: PySide2.QtCore.Signal
        pointLabelsFontChanged: PySide2.QtCore.Signal
        pointLabelsFormatChanged: PySide2.QtCore.Signal
        pointLabelsVisibilityChanged: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal
        selected: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, upperSeries:PySide2.QtCharts.QtCharts.QLineSeries, lowerSeries:typing.Optional[PySide2.QtCharts.QtCharts.QLineSeries]=...) -> None: ...

        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def lowerSeries(self) -> PySide2.QtCharts.QtCharts.QLineSeries: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def pointLabelsClipping(self) -> bool: ...
        def pointLabelsColor(self) -> PySide2.QtGui.QColor: ...
        def pointLabelsFont(self) -> PySide2.QtGui.QFont: ...
        def pointLabelsFormat(self) -> str: ...
        def pointLabelsVisible(self) -> bool: ...
        def pointsVisible(self) -> bool: ...
        def setBorderColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLowerSeries(self, series:PySide2.QtCharts.QtCharts.QLineSeries) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setPointLabelsClipping(self, enabled:bool=...) -> None: ...
        def setPointLabelsColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setPointLabelsFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setPointLabelsFormat(self, format:str) -> None: ...
        def setPointLabelsVisible(self, visible:bool=...) -> None: ...
        def setPointsVisible(self, visible:bool=...) -> None: ...
        def setUpperSeries(self, series:PySide2.QtCharts.QtCharts.QLineSeries) -> None: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...
        def upperSeries(self) -> PySide2.QtCharts.QtCharts.QLineSeries: ...

    class QBarCategoryAxis(PySide2.QtCharts.QAbstractAxis):

        categoriesChanged: PySide2.QtCore.Signal
        countChanged: PySide2.QtCore.Signal
        maxChanged: PySide2.QtCore.Signal
        minChanged: PySide2.QtCore.Signal
        rangeChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        @typing.overload
        def append(self, categories:typing.Sequence) -> None: ...
        @typing.overload
        def append(self, category:str) -> None: ...
        def at(self, index:int) -> str: ...
        def categories(self) -> typing.List: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def insert(self, index:int, category:str) -> None: ...
        def max(self) -> str: ...
        def min(self) -> str: ...
        def remove(self, category:str) -> None: ...
        def replace(self, oldCategory:str, newCategory:str) -> None: ...
        def setCategories(self, categories:typing.Sequence) -> None: ...
        @typing.overload
        def setMax(self, max:typing.Any) -> None: ...
        @typing.overload
        def setMax(self, maxCategory:str) -> None: ...
        @typing.overload
        def setMin(self, min:typing.Any) -> None: ...
        @typing.overload
        def setMin(self, minCategory:str) -> None: ...
        @typing.overload
        def setRange(self, min:typing.Any, max:typing.Any) -> None: ...
        @typing.overload
        def setRange(self, minCategory:str, maxCategory:str) -> None: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractAxis.AxisType: ...

    class QBarLegendMarker(PySide2.QtCharts.QLegendMarker):

        def __init__(self, series:PySide2.QtCharts.QtCharts.QAbstractBarSeries, barset:PySide2.QtCharts.QtCharts.QBarSet, legend:PySide2.QtCharts.QtCharts.QLegend, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def barset(self) -> PySide2.QtCharts.QtCharts.QBarSet: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QAbstractBarSeries: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QLegendMarker.LegendMarkerType: ...

    class QBarModelMapper(PySide2.QtCore.QObject):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def count(self) -> int: ...
        def first(self) -> int: ...
        def firstBarSetSection(self) -> int: ...
        def lastBarSetSection(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QAbstractBarSeries: ...
        def setCount(self, count:int) -> None: ...
        def setFirst(self, first:int) -> None: ...
        def setFirstBarSetSection(self, firstBarSetSection:int) -> None: ...
        def setLastBarSetSection(self, lastBarSetSection:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QAbstractBarSeries) -> None: ...

    class QBarSeries(PySide2.QtCharts.QAbstractBarSeries):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QBarSet(PySide2.QtCore.QObject):

        borderColorChanged: PySide2.QtCore.Signal
        brushChanged: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        colorChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        labelBrushChanged: PySide2.QtCore.Signal
        labelChanged: PySide2.QtCore.Signal
        labelColorChanged: PySide2.QtCore.Signal
        labelFontChanged: PySide2.QtCore.Signal
        penChanged: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal
        valueChanged: PySide2.QtCore.Signal
        valuesAdded: PySide2.QtCore.Signal
        valuesRemoved: PySide2.QtCore.Signal


        def __init__(self, label:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def __lshift__(self, value:float) -> PySide2.QtCharts.QtCharts.QBarSet: ...
        @typing.overload
        def append(self, value:float) -> None: ...
        @typing.overload
        def append(self, values:typing.Sequence) -> None: ...
        def at(self, index:int) -> float: ...
        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def count(self) -> int: ...
        def insert(self, index:int, value:float) -> None: ...
        def label(self) -> str: ...
        def labelBrush(self) -> PySide2.QtGui.QBrush: ...
        def labelColor(self) -> PySide2.QtGui.QColor: ...
        def labelFont(self) -> PySide2.QtGui.QFont: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def remove(self, index:int, count:int=...) -> None: ...
        def replace(self, index:int, value:float) -> None: ...
        def setBorderColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLabel(self, label:str) -> None: ...
        def setLabelBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setLabelColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLabelFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def sum(self) -> float: ...

    class QBoxPlotLegendMarker(PySide2.QtCharts.QLegendMarker):

        def __init__(self, series:PySide2.QtCharts.QtCharts.QBoxPlotSeries, legend:PySide2.QtCharts.QtCharts.QLegend, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def series(self) -> PySide2.QtCharts.QtCharts.QBoxPlotSeries: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QLegendMarker.LegendMarkerType: ...

    class QBoxPlotModelMapper(PySide2.QtCore.QObject):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def count(self) -> int: ...
        def first(self) -> int: ...
        def firstBoxSetSection(self) -> int: ...
        def lastBoxSetSection(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QBoxPlotSeries: ...
        def setCount(self, count:int) -> None: ...
        def setFirst(self, first:int) -> None: ...
        def setFirstBoxSetSection(self, firstBoxSetSection:int) -> None: ...
        def setLastBoxSetSection(self, lastBoxSetSection:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QBoxPlotSeries) -> None: ...

    class QBoxPlotSeries(PySide2.QtCharts.QAbstractSeries):

        boxOutlineVisibilityChanged: PySide2.QtCore.Signal
        boxWidthChanged: PySide2.QtCore.Signal
        boxsetsAdded: PySide2.QtCore.Signal
        boxsetsRemoved: PySide2.QtCore.Signal
        brushChanged: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        countChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        penChanged: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        @typing.overload
        def append(self, box:PySide2.QtCharts.QtCharts.QBoxSet) -> bool: ...
        @typing.overload
        def append(self, boxes:typing.Sequence) -> bool: ...
        def boxOutlineVisible(self) -> bool: ...
        def boxSets(self) -> typing.List: ...
        def boxWidth(self) -> float: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def insert(self, index:int, box:PySide2.QtCharts.QtCharts.QBoxSet) -> bool: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def remove(self, box:PySide2.QtCharts.QtCharts.QBoxSet) -> bool: ...
        def setBoxOutlineVisible(self, visible:bool) -> None: ...
        def setBoxWidth(self, width:float) -> None: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def take(self, box:PySide2.QtCharts.QtCharts.QBoxSet) -> bool: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QBoxSet(PySide2.QtCore.QObject):

        brushChanged: PySide2.QtCore.Signal
        cleared: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        penChanged: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal
        valueChanged: PySide2.QtCore.Signal
        valuesChanged: PySide2.QtCore.Signal

        LowerExtreme             : QtCharts.QBoxSet.ValuePositions = ... # 0x0
        LowerQuartile            : QtCharts.QBoxSet.ValuePositions = ... # 0x1
        Median                   : QtCharts.QBoxSet.ValuePositions = ... # 0x2
        UpperQuartile            : QtCharts.QBoxSet.ValuePositions = ... # 0x3
        UpperExtreme             : QtCharts.QBoxSet.ValuePositions = ... # 0x4

        class ValuePositions(object):
            LowerExtreme             : QtCharts.QBoxSet.ValuePositions = ... # 0x0
            LowerQuartile            : QtCharts.QBoxSet.ValuePositions = ... # 0x1
            Median                   : QtCharts.QBoxSet.ValuePositions = ... # 0x2
            UpperQuartile            : QtCharts.QBoxSet.ValuePositions = ... # 0x3
            UpperExtreme             : QtCharts.QBoxSet.ValuePositions = ... # 0x4

        @typing.overload
        def __init__(self, label:str=..., parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, le:float, lq:float, m:float, uq:float, ue:float, label:str=..., parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def __lshift__(self, value:float) -> PySide2.QtCharts.QtCharts.QBoxSet: ...
        @typing.overload
        def append(self, value:float) -> None: ...
        @typing.overload
        def append(self, values:typing.Sequence) -> None: ...
        def at(self, index:int) -> float: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def label(self) -> str: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setLabel(self, label:str) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setValue(self, index:int, value:float) -> None: ...

    class QCandlestickLegendMarker(PySide2.QtCharts.QLegendMarker):

        def __init__(self, series:PySide2.QtCharts.QtCharts.QCandlestickSeries, legend:PySide2.QtCharts.QtCharts.QLegend, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def series(self) -> PySide2.QtCharts.QtCharts.QCandlestickSeries: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QLegendMarker.LegendMarkerType: ...

    class QCandlestickModelMapper(PySide2.QtCore.QObject):

        modelReplaced: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def close(self) -> int: ...
        def firstSetSection(self) -> int: ...
        def high(self) -> int: ...
        def lastSetSection(self) -> int: ...
        def low(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def open(self) -> int: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QCandlestickSeries: ...
        def setClose(self, close:int) -> None: ...
        def setFirstSetSection(self, firstSetSection:int) -> None: ...
        def setHigh(self, high:int) -> None: ...
        def setLastSetSection(self, lastSetSection:int) -> None: ...
        def setLow(self, low:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setOpen(self, open:int) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QCandlestickSeries) -> None: ...
        def setTimestamp(self, timestamp:int) -> None: ...
        def timestamp(self) -> int: ...

    class QCandlestickSeries(PySide2.QtCharts.QAbstractSeries):

        bodyOutlineVisibilityChanged: PySide2.QtCore.Signal
        bodyWidthChanged: PySide2.QtCore.Signal
        brushChanged: PySide2.QtCore.Signal
        candlestickSetsAdded: PySide2.QtCore.Signal
        candlestickSetsRemoved: PySide2.QtCore.Signal
        capsVisibilityChanged: PySide2.QtCore.Signal
        capsWidthChanged: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        countChanged: PySide2.QtCore.Signal
        decreasingColorChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        increasingColorChanged: PySide2.QtCore.Signal
        maximumColumnWidthChanged: PySide2.QtCore.Signal
        minimumColumnWidthChanged: PySide2.QtCore.Signal
        penChanged: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        @typing.overload
        def append(self, set:PySide2.QtCharts.QtCharts.QCandlestickSet) -> bool: ...
        @typing.overload
        def append(self, sets:typing.Sequence) -> bool: ...
        def bodyOutlineVisible(self) -> bool: ...
        def bodyWidth(self) -> float: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def capsVisible(self) -> bool: ...
        def capsWidth(self) -> float: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def decreasingColor(self) -> PySide2.QtGui.QColor: ...
        def increasingColor(self) -> PySide2.QtGui.QColor: ...
        def insert(self, index:int, set:PySide2.QtCharts.QtCharts.QCandlestickSet) -> bool: ...
        def maximumColumnWidth(self) -> float: ...
        def minimumColumnWidth(self) -> float: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        @typing.overload
        def remove(self, set:PySide2.QtCharts.QtCharts.QCandlestickSet) -> bool: ...
        @typing.overload
        def remove(self, sets:typing.Sequence) -> bool: ...
        def setBodyOutlineVisible(self, bodyOutlineVisible:bool) -> None: ...
        def setBodyWidth(self, bodyWidth:float) -> None: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setCapsVisible(self, capsVisible:bool) -> None: ...
        def setCapsWidth(self, capsWidth:float) -> None: ...
        def setDecreasingColor(self, decreasingColor: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setIncreasingColor(self, increasingColor: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setMaximumColumnWidth(self, maximumColumnWidth:float) -> None: ...
        def setMinimumColumnWidth(self, minimumColumnWidth:float) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def sets(self) -> typing.List: ...
        def take(self, set:PySide2.QtCharts.QtCharts.QCandlestickSet) -> bool: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QCandlestickSet(PySide2.QtCore.QObject):

        brushChanged: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        closeChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        highChanged: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        lowChanged: PySide2.QtCore.Signal
        openChanged: PySide2.QtCore.Signal
        penChanged: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal
        timestampChanged: PySide2.QtCore.Signal


        @typing.overload
        def __init__(self, open:float, high:float, low:float, close:float, timestamp:float=..., parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, timestamp:float=..., parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def brush(self) -> PySide2.QtGui.QBrush: ...
        def close(self) -> float: ...
        def high(self) -> float: ...
        def low(self) -> float: ...
        def open(self) -> float: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setClose(self, close:float) -> None: ...
        def setHigh(self, high:float) -> None: ...
        def setLow(self, low:float) -> None: ...
        def setOpen(self, open:float) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setTimestamp(self, timestamp:float) -> None: ...
        def timestamp(self) -> float: ...

    class QCategoryAxis(PySide2.QtCharts.QValueAxis):

        categoriesChanged: PySide2.QtCore.Signal
        labelsPositionChanged: PySide2.QtCore.Signal

        AxisLabelsPositionCenter : QtCharts.QCategoryAxis.AxisLabelsPosition = ... # 0x0
        AxisLabelsPositionOnValue: QtCharts.QCategoryAxis.AxisLabelsPosition = ... # 0x1

        class AxisLabelsPosition(object):
            AxisLabelsPositionCenter : QtCharts.QCategoryAxis.AxisLabelsPosition = ... # 0x0
            AxisLabelsPositionOnValue: QtCharts.QCategoryAxis.AxisLabelsPosition = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def append(self, label:str, categoryEndValue:float) -> None: ...
        def categoriesLabels(self) -> typing.List: ...
        def count(self) -> int: ...
        def endValue(self, categoryLabel:str) -> float: ...
        def labelsPosition(self) -> PySide2.QtCharts.QtCharts.QCategoryAxis.AxisLabelsPosition: ...
        def remove(self, label:str) -> None: ...
        def replaceLabel(self, oldLabel:str, newLabel:str) -> None: ...
        def setLabelsPosition(self, position:PySide2.QtCharts.QtCharts.QCategoryAxis.AxisLabelsPosition) -> None: ...
        def setStartValue(self, min:float) -> None: ...
        def startValue(self, categoryLabel:str=...) -> float: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractAxis.AxisType: ...

    class QChart(PySide2.QtWidgets.QGraphicsWidget):

        plotAreaChanged: PySide2.QtCore.Signal

        ChartThemeLight          : QtCharts.QChart.ChartTheme = ... # 0x0
        ChartTypeUndefined       : QtCharts.QChart.ChartType = ... # 0x0
        NoAnimation              : QtCharts.QChart.AnimationOption = ... # 0x0
        ChartThemeBlueCerulean   : QtCharts.QChart.ChartTheme = ... # 0x1
        ChartTypeCartesian       : QtCharts.QChart.ChartType = ... # 0x1
        GridAxisAnimations       : QtCharts.QChart.AnimationOption = ... # 0x1
        ChartThemeDark           : QtCharts.QChart.ChartTheme = ... # 0x2
        ChartTypePolar           : QtCharts.QChart.ChartType = ... # 0x2
        SeriesAnimations         : QtCharts.QChart.AnimationOption = ... # 0x2
        AllAnimations            : QtCharts.QChart.AnimationOption = ... # 0x3
        ChartThemeBrownSand      : QtCharts.QChart.ChartTheme = ... # 0x3
        ChartThemeBlueNcs        : QtCharts.QChart.ChartTheme = ... # 0x4
        ChartThemeHighContrast   : QtCharts.QChart.ChartTheme = ... # 0x5
        ChartThemeBlueIcy        : QtCharts.QChart.ChartTheme = ... # 0x6
        ChartThemeQt             : QtCharts.QChart.ChartTheme = ... # 0x7

        class AnimationOption(object):
            NoAnimation              : QtCharts.QChart.AnimationOption = ... # 0x0
            GridAxisAnimations       : QtCharts.QChart.AnimationOption = ... # 0x1
            SeriesAnimations         : QtCharts.QChart.AnimationOption = ... # 0x2
            AllAnimations            : QtCharts.QChart.AnimationOption = ... # 0x3
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, AnimationOption] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __and__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __xor__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __ror__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __rand__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __rxor__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __ior__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __iand__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __ixor__(self, other: typing.Union[int, AnimationOption]) -> AnimationOptions: ...
            def __invert__(self) -> AnimationOptions: ...

        class AnimationOptions(object):
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, AnimationOption, AnimationOptions] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __and__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __xor__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __ror__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __rand__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __rxor__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __ior__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __iand__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __ixor__(self, other: typing.Union[int, AnimationOption, AnimationOptions]) -> AnimationOptions: ...
            def __invert__(self) -> AnimationOptions: ...

        class ChartTheme(object):
            ChartThemeLight          : QtCharts.QChart.ChartTheme = ... # 0x0
            ChartThemeBlueCerulean   : QtCharts.QChart.ChartTheme = ... # 0x1
            ChartThemeDark           : QtCharts.QChart.ChartTheme = ... # 0x2
            ChartThemeBrownSand      : QtCharts.QChart.ChartTheme = ... # 0x3
            ChartThemeBlueNcs        : QtCharts.QChart.ChartTheme = ... # 0x4
            ChartThemeHighContrast   : QtCharts.QChart.ChartTheme = ... # 0x5
            ChartThemeBlueIcy        : QtCharts.QChart.ChartTheme = ... # 0x6
            ChartThemeQt             : QtCharts.QChart.ChartTheme = ... # 0x7

        class ChartType(object):
            ChartTypeUndefined       : QtCharts.QChart.ChartType = ... # 0x0
            ChartTypeCartesian       : QtCharts.QChart.ChartType = ... # 0x1
            ChartTypePolar           : QtCharts.QChart.ChartType = ... # 0x2

        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=..., wFlags:PySide2.QtCore.Qt.WindowFlags=...) -> None: ...
        @typing.overload
        def __init__(self, type:PySide2.QtCharts.QtCharts.QChart.ChartType, parent:PySide2.QtWidgets.QGraphicsItem, wFlags:PySide2.QtCore.Qt.WindowFlags) -> None: ...

        def addAxis(self, axis:PySide2.QtCharts.QtCharts.QAbstractAxis, alignment:PySide2.QtCore.Qt.Alignment) -> None: ...
        def addSeries(self, series:PySide2.QtCharts.QtCharts.QAbstractSeries) -> None: ...
        def animationDuration(self) -> int: ...
        def animationEasingCurve(self) -> PySide2.QtCore.QEasingCurve: ...
        def animationOptions(self) -> PySide2.QtCharts.QtCharts.QChart.AnimationOptions: ...
        def axes(self, orientation:PySide2.QtCore.Qt.Orientations=..., series:typing.Optional[PySide2.QtCharts.QtCharts.QAbstractSeries]=...) -> typing.List: ...
        def axisX(self, series:typing.Optional[PySide2.QtCharts.QtCharts.QAbstractSeries]=...) -> PySide2.QtCharts.QtCharts.QAbstractAxis: ...
        def axisY(self, series:typing.Optional[PySide2.QtCharts.QtCharts.QAbstractSeries]=...) -> PySide2.QtCharts.QtCharts.QAbstractAxis: ...
        def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
        def backgroundPen(self) -> PySide2.QtGui.QPen: ...
        def backgroundRoundness(self) -> float: ...
        def chartType(self) -> PySide2.QtCharts.QtCharts.QChart.ChartType: ...
        def createDefaultAxes(self) -> None: ...
        def isBackgroundVisible(self) -> bool: ...
        def isDropShadowEnabled(self) -> bool: ...
        def isPlotAreaBackgroundVisible(self) -> bool: ...
        def isZoomed(self) -> bool: ...
        def legend(self) -> PySide2.QtCharts.QtCharts.QLegend: ...
        def locale(self) -> PySide2.QtCore.QLocale: ...
        def localizeNumbers(self) -> bool: ...
        def mapToPosition(self, value:PySide2.QtCore.QPointF, series:typing.Optional[PySide2.QtCharts.QtCharts.QAbstractSeries]=...) -> PySide2.QtCore.QPointF: ...
        def mapToValue(self, position:PySide2.QtCore.QPointF, series:typing.Optional[PySide2.QtCharts.QtCharts.QAbstractSeries]=...) -> PySide2.QtCore.QPointF: ...
        def margins(self) -> PySide2.QtCore.QMargins: ...
        def plotArea(self) -> PySide2.QtCore.QRectF: ...
        def plotAreaBackgroundBrush(self) -> PySide2.QtGui.QBrush: ...
        def plotAreaBackgroundPen(self) -> PySide2.QtGui.QPen: ...
        def removeAllSeries(self) -> None: ...
        def removeAxis(self, axis:PySide2.QtCharts.QtCharts.QAbstractAxis) -> None: ...
        def removeSeries(self, series:PySide2.QtCharts.QtCharts.QAbstractSeries) -> None: ...
        def scroll(self, dx:float, dy:float) -> None: ...
        def series(self) -> typing.List: ...
        def setAnimationDuration(self, msecs:int) -> None: ...
        def setAnimationEasingCurve(self, curve:PySide2.QtCore.QEasingCurve) -> None: ...
        def setAnimationOptions(self, options:PySide2.QtCharts.QtCharts.QChart.AnimationOptions) -> None: ...
        def setAxisX(self, axis:PySide2.QtCharts.QtCharts.QAbstractAxis, series:typing.Optional[PySide2.QtCharts.QtCharts.QAbstractSeries]=...) -> None: ...
        def setAxisY(self, axis:PySide2.QtCharts.QtCharts.QAbstractAxis, series:typing.Optional[PySide2.QtCharts.QtCharts.QAbstractSeries]=...) -> None: ...
        def setBackgroundBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setBackgroundPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setBackgroundRoundness(self, diameter:float) -> None: ...
        def setBackgroundVisible(self, visible:bool=...) -> None: ...
        def setDropShadowEnabled(self, enabled:bool=...) -> None: ...
        def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...
        def setLocalizeNumbers(self, localize:bool) -> None: ...
        def setMargins(self, margins:PySide2.QtCore.QMargins) -> None: ...
        def setPlotArea(self, rect:PySide2.QtCore.QRectF) -> None: ...
        def setPlotAreaBackgroundBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setPlotAreaBackgroundPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setPlotAreaBackgroundVisible(self, visible:bool=...) -> None: ...
        def setTheme(self, theme:PySide2.QtCharts.QtCharts.QChart.ChartTheme) -> None: ...
        def setTitle(self, title:str) -> None: ...
        def setTitleBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setTitleFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def theme(self) -> PySide2.QtCharts.QtCharts.QChart.ChartTheme: ...
        def title(self) -> str: ...
        def titleBrush(self) -> PySide2.QtGui.QBrush: ...
        def titleFont(self) -> PySide2.QtGui.QFont: ...
        def zoom(self, factor:float) -> None: ...
        @typing.overload
        def zoomIn(self) -> None: ...
        @typing.overload
        def zoomIn(self, rect:PySide2.QtCore.QRectF) -> None: ...
        def zoomOut(self) -> None: ...
        def zoomReset(self) -> None: ...

    class QChartView(PySide2.QtWidgets.QGraphicsView):
        NoRubberBand             : QtCharts.QChartView.RubberBand = ... # 0x0
        VerticalRubberBand       : QtCharts.QChartView.RubberBand = ... # 0x1
        HorizontalRubberBand     : QtCharts.QChartView.RubberBand = ... # 0x2
        RectangleRubberBand      : QtCharts.QChartView.RubberBand = ... # 0x3

        class RubberBand(object):
            NoRubberBand             : QtCharts.QChartView.RubberBand = ... # 0x0
            VerticalRubberBand       : QtCharts.QChartView.RubberBand = ... # 0x1
            HorizontalRubberBand     : QtCharts.QChartView.RubberBand = ... # 0x2
            RectangleRubberBand      : QtCharts.QChartView.RubberBand = ... # 0x3
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, RubberBand] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __and__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __xor__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __ror__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __rand__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __rxor__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __ior__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __iand__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __ixor__(self, other: typing.Union[int, RubberBand]) -> RubberBands: ...
            def __invert__(self) -> RubberBands: ...

        class RubberBands(object):
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, RubberBand, RubberBands] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __and__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __xor__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __ror__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __rand__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __rxor__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __ior__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __iand__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __ixor__(self, other: typing.Union[int, RubberBand, RubberBands]) -> RubberBands: ...
            def __invert__(self) -> RubberBands: ...

        @typing.overload
        def __init__(self, chart:PySide2.QtCharts.QtCharts.QChart, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> None: ...

        def chart(self) -> PySide2.QtCharts.QtCharts.QChart: ...
        def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
        def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
        def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent) -> None: ...
        def resizeEvent(self, event:PySide2.QtGui.QResizeEvent) -> None: ...
        def rubberBand(self) -> PySide2.QtCharts.QtCharts.QChartView.RubberBands: ...
        def setChart(self, chart:PySide2.QtCharts.QtCharts.QChart) -> None: ...
        def setRubberBand(self, rubberBands:PySide2.QtCharts.QtCharts.QChartView.RubberBands) -> None: ...
        if sys.platform() == 'darwin':
            def wheelEvent(self, event:PySide2.QtGui.QWheelEvent) -> None: ...

    class QDateTimeAxis(PySide2.QtCharts.QAbstractAxis):

        formatChanged: PySide2.QtCore.Signal
        maxChanged: PySide2.QtCore.Signal
        minChanged: PySide2.QtCore.Signal
        rangeChanged: PySide2.QtCore.Signal
        tickCountChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def format(self) -> str: ...
        def max(self) -> PySide2.QtCore.QDateTime: ...
        def min(self) -> PySide2.QtCore.QDateTime: ...
        def setFormat(self, format:str) -> None: ...
        @typing.overload
        def setMax(self, max:PySide2.QtCore.QDateTime) -> None: ...
        @typing.overload
        def setMax(self, max:typing.Any) -> None: ...
        @typing.overload
        def setMin(self, min:PySide2.QtCore.QDateTime) -> None: ...
        @typing.overload
        def setMin(self, min:typing.Any) -> None: ...
        @typing.overload
        def setRange(self, min:PySide2.QtCore.QDateTime, max:PySide2.QtCore.QDateTime) -> None: ...
        @typing.overload
        def setRange(self, min:typing.Any, max:typing.Any) -> None: ...
        def setTickCount(self, count:int) -> None: ...
        def tickCount(self) -> int: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractAxis.AxisType: ...

    class QHBarModelMapper(PySide2.QtCharts.QBarModelMapper):

        columnCountChanged: PySide2.QtCore.Signal
        firstBarSetRowChanged: PySide2.QtCore.Signal
        firstColumnChanged: PySide2.QtCore.Signal
        lastBarSetRowChanged: PySide2.QtCore.Signal
        modelReplaced: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def columnCount(self) -> int: ...
        def firstBarSetRow(self) -> int: ...
        def firstColumn(self) -> int: ...
        def lastBarSetRow(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QAbstractBarSeries: ...
        def setColumnCount(self, columnCount:int) -> None: ...
        def setFirstBarSetRow(self, firstBarSetRow:int) -> None: ...
        def setFirstColumn(self, firstColumn:int) -> None: ...
        def setLastBarSetRow(self, lastBarSetRow:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QAbstractBarSeries) -> None: ...

    class QHBoxPlotModelMapper(PySide2.QtCharts.QBoxPlotModelMapper):

        columnCountChanged: PySide2.QtCore.Signal
        firstBoxSetRowChanged: PySide2.QtCore.Signal
        firstColumnChanged: PySide2.QtCore.Signal
        lastBoxSetRowChanged: PySide2.QtCore.Signal
        modelReplaced: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def columnCount(self) -> int: ...
        def firstBoxSetRow(self) -> int: ...
        def firstColumn(self) -> int: ...
        def lastBoxSetRow(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QBoxPlotSeries: ...
        def setColumnCount(self, rowCount:int) -> None: ...
        def setFirstBoxSetRow(self, firstBoxSetRow:int) -> None: ...
        def setFirstColumn(self, firstColumn:int) -> None: ...
        def setLastBoxSetRow(self, lastBoxSetRow:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QBoxPlotSeries) -> None: ...

    class QHCandlestickModelMapper(PySide2.QtCharts.QCandlestickModelMapper):

        closeColumnChanged: PySide2.QtCore.Signal
        firstSetRowChanged: PySide2.QtCore.Signal
        highColumnChanged: PySide2.QtCore.Signal
        lastSetRowChanged: PySide2.QtCore.Signal
        lowColumnChanged: PySide2.QtCore.Signal
        openColumnChanged: PySide2.QtCore.Signal
        timestampColumnChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def closeColumn(self) -> int: ...
        def firstSetRow(self) -> int: ...
        def highColumn(self) -> int: ...
        def lastSetRow(self) -> int: ...
        def lowColumn(self) -> int: ...
        def openColumn(self) -> int: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def setCloseColumn(self, closeColumn:int) -> None: ...
        def setFirstSetRow(self, firstSetRow:int) -> None: ...
        def setHighColumn(self, highColumn:int) -> None: ...
        def setLastSetRow(self, lastSetRow:int) -> None: ...
        def setLowColumn(self, lowColumn:int) -> None: ...
        def setOpenColumn(self, openColumn:int) -> None: ...
        def setTimestampColumn(self, timestampColumn:int) -> None: ...
        def timestampColumn(self) -> int: ...

    class QHPieModelMapper(PySide2.QtCharts.QPieModelMapper):

        columnCountChanged: PySide2.QtCore.Signal
        firstColumnChanged: PySide2.QtCore.Signal
        labelsRowChanged: PySide2.QtCore.Signal
        modelReplaced: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal
        valuesRowChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def columnCount(self) -> int: ...
        def firstColumn(self) -> int: ...
        def labelsRow(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QPieSeries: ...
        def setColumnCount(self, columnCount:int) -> None: ...
        def setFirstColumn(self, firstColumn:int) -> None: ...
        def setLabelsRow(self, labelsRow:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QPieSeries) -> None: ...
        def setValuesRow(self, valuesRow:int) -> None: ...
        def valuesRow(self) -> int: ...

    class QHXYModelMapper(PySide2.QtCharts.QXYModelMapper):

        columnCountChanged: PySide2.QtCore.Signal
        firstColumnChanged: PySide2.QtCore.Signal
        modelReplaced: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal
        xRowChanged: PySide2.QtCore.Signal
        yRowChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def columnCount(self) -> int: ...
        def firstColumn(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QXYSeries: ...
        def setColumnCount(self, columnCount:int) -> None: ...
        def setFirstColumn(self, firstColumn:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QXYSeries) -> None: ...
        def setXRow(self, xRow:int) -> None: ...
        def setYRow(self, yRow:int) -> None: ...
        def xRow(self) -> int: ...
        def yRow(self) -> int: ...

    class QHorizontalBarSeries(PySide2.QtCharts.QAbstractBarSeries):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QHorizontalPercentBarSeries(PySide2.QtCharts.QAbstractBarSeries):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QHorizontalStackedBarSeries(PySide2.QtCharts.QAbstractBarSeries):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QLegend(PySide2.QtWidgets.QGraphicsWidget):

        backgroundVisibleChanged: PySide2.QtCore.Signal
        borderColorChanged: PySide2.QtCore.Signal
        colorChanged: PySide2.QtCore.Signal
        fontChanged: PySide2.QtCore.Signal
        labelColorChanged: PySide2.QtCore.Signal
        markerShapeChanged: PySide2.QtCore.Signal
        reverseMarkersChanged: PySide2.QtCore.Signal
        showToolTipsChanged: PySide2.QtCore.Signal

        MarkerShapeDefault       : QtCharts.QLegend.MarkerShape = ... # 0x0
        MarkerShapeRectangle     : QtCharts.QLegend.MarkerShape = ... # 0x1
        MarkerShapeCircle        : QtCharts.QLegend.MarkerShape = ... # 0x2
        MarkerShapeFromSeries    : QtCharts.QLegend.MarkerShape = ... # 0x3

        class MarkerShape(object):
            MarkerShapeDefault       : QtCharts.QLegend.MarkerShape = ... # 0x0
            MarkerShapeRectangle     : QtCharts.QLegend.MarkerShape = ... # 0x1
            MarkerShapeCircle        : QtCharts.QLegend.MarkerShape = ... # 0x2
            MarkerShapeFromSeries    : QtCharts.QLegend.MarkerShape = ... # 0x3
        def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
        def attachToChart(self) -> None: ...
        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def detachFromChart(self) -> None: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def hideEvent(self, event:PySide2.QtGui.QHideEvent) -> None: ...
        def isAttachedToChart(self) -> bool: ...
        def isBackgroundVisible(self) -> bool: ...
        def labelBrush(self) -> PySide2.QtGui.QBrush: ...
        def labelColor(self) -> PySide2.QtGui.QColor: ...
        def markerShape(self) -> PySide2.QtCharts.QtCharts.QLegend.MarkerShape: ...
        def markers(self, series:typing.Optional[PySide2.QtCharts.QtCharts.QAbstractSeries]=...) -> typing.List: ...
        def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> None: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def reverseMarkers(self) -> bool: ...
        def setAlignment(self, alignment:PySide2.QtCore.Qt.Alignment) -> None: ...
        def setBackgroundVisible(self, visible:bool=...) -> None: ...
        def setBorderColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setLabelBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setLabelColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setMarkerShape(self, shape:PySide2.QtCharts.QtCharts.QLegend.MarkerShape) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setReverseMarkers(self, reverseMarkers:bool=...) -> None: ...
        def setShowToolTips(self, show:bool) -> None: ...
        def showEvent(self, event:PySide2.QtGui.QShowEvent) -> None: ...
        def showToolTips(self) -> bool: ...

    class QLegendMarker(PySide2.QtCore.QObject):

        brushChanged: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        fontChanged: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        labelBrushChanged: PySide2.QtCore.Signal
        labelChanged: PySide2.QtCore.Signal
        penChanged: PySide2.QtCore.Signal
        shapeChanged: PySide2.QtCore.Signal
        visibleChanged: PySide2.QtCore.Signal

        LegendMarkerTypeArea     : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x0
        LegendMarkerTypeBar      : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x1
        LegendMarkerTypePie      : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x2
        LegendMarkerTypeXY       : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x3
        LegendMarkerTypeBoxPlot  : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x4
        LegendMarkerTypeCandlestick: QtCharts.QLegendMarker.LegendMarkerType = ... # 0x5

        class LegendMarkerType(object):
            LegendMarkerTypeArea     : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x0
            LegendMarkerTypeBar      : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x1
            LegendMarkerTypePie      : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x2
            LegendMarkerTypeXY       : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x3
            LegendMarkerTypeBoxPlot  : QtCharts.QLegendMarker.LegendMarkerType = ... # 0x4
            LegendMarkerTypeCandlestick: QtCharts.QLegendMarker.LegendMarkerType = ... # 0x5
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def font(self) -> PySide2.QtGui.QFont: ...
        def isVisible(self) -> bool: ...
        def label(self) -> str: ...
        def labelBrush(self) -> PySide2.QtGui.QBrush: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setLabel(self, label:str) -> None: ...
        def setLabelBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setShape(self, shape:PySide2.QtCharts.QtCharts.QLegend.MarkerShape) -> None: ...
        def setVisible(self, visible:bool) -> None: ...
        def shape(self) -> PySide2.QtCharts.QtCharts.QLegend.MarkerShape: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QLegendMarker.LegendMarkerType: ...

    class QLineSeries(PySide2.QtCharts.QXYSeries):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QLogValueAxis(PySide2.QtCharts.QAbstractAxis):

        baseChanged: PySide2.QtCore.Signal
        labelFormatChanged: PySide2.QtCore.Signal
        maxChanged: PySide2.QtCore.Signal
        minChanged: PySide2.QtCore.Signal
        minorTickCountChanged: PySide2.QtCore.Signal
        rangeChanged: PySide2.QtCore.Signal
        tickCountChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def base(self) -> float: ...
        def labelFormat(self) -> str: ...
        def max(self) -> float: ...
        def min(self) -> float: ...
        def minorTickCount(self) -> int: ...
        def setBase(self, base:float) -> None: ...
        def setLabelFormat(self, format:str) -> None: ...
        @typing.overload
        def setMax(self, max:typing.Any) -> None: ...
        @typing.overload
        def setMax(self, max:float) -> None: ...
        @typing.overload
        def setMin(self, min:typing.Any) -> None: ...
        @typing.overload
        def setMin(self, min:float) -> None: ...
        def setMinorTickCount(self, minorTickCount:int) -> None: ...
        @typing.overload
        def setRange(self, min:typing.Any, max:typing.Any) -> None: ...
        @typing.overload
        def setRange(self, min:float, max:float) -> None: ...
        def tickCount(self) -> int: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractAxis.AxisType: ...

    class QPercentBarSeries(PySide2.QtCharts.QAbstractBarSeries):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QPieLegendMarker(PySide2.QtCharts.QLegendMarker):

        def __init__(self, series:PySide2.QtCharts.QtCharts.QPieSeries, slice:PySide2.QtCharts.QtCharts.QPieSlice, legend:PySide2.QtCharts.QtCharts.QLegend, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def series(self) -> PySide2.QtCharts.QtCharts.QPieSeries: ...
        def slice(self) -> PySide2.QtCharts.QtCharts.QPieSlice: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QLegendMarker.LegendMarkerType: ...

    class QPieModelMapper(PySide2.QtCore.QObject):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def count(self) -> int: ...
        def first(self) -> int: ...
        def labelsSection(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QPieSeries: ...
        def setCount(self, count:int) -> None: ...
        def setFirst(self, first:int) -> None: ...
        def setLabelsSection(self, labelsSection:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QPieSeries) -> None: ...
        def setValuesSection(self, valuesSection:int) -> None: ...
        def valuesSection(self) -> int: ...

    class QPieSeries(PySide2.QtCharts.QAbstractSeries):

        added: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        countChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal
        removed: PySide2.QtCore.Signal
        sumChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def __lshift__(self, slice:PySide2.QtCharts.QtCharts.QPieSlice) -> PySide2.QtCharts.QtCharts.QPieSeries: ...
        @typing.overload
        def append(self, label:str, value:float) -> PySide2.QtCharts.QtCharts.QPieSlice: ...
        @typing.overload
        def append(self, slice:PySide2.QtCharts.QtCharts.QPieSlice) -> bool: ...
        @typing.overload
        def append(self, slices:typing.Sequence) -> bool: ...
        def clear(self) -> None: ...
        def count(self) -> int: ...
        def holeSize(self) -> float: ...
        def horizontalPosition(self) -> float: ...
        def insert(self, index:int, slice:PySide2.QtCharts.QtCharts.QPieSlice) -> bool: ...
        def isEmpty(self) -> bool: ...
        def pieEndAngle(self) -> float: ...
        def pieSize(self) -> float: ...
        def pieStartAngle(self) -> float: ...
        def remove(self, slice:PySide2.QtCharts.QtCharts.QPieSlice) -> bool: ...
        def setHoleSize(self, holeSize:float) -> None: ...
        def setHorizontalPosition(self, relativePosition:float) -> None: ...
        def setLabelsPosition(self, position:PySide2.QtCharts.QtCharts.QPieSlice.LabelPosition) -> None: ...
        def setLabelsVisible(self, visible:bool=...) -> None: ...
        def setPieEndAngle(self, endAngle:float) -> None: ...
        def setPieSize(self, relativeSize:float) -> None: ...
        def setPieStartAngle(self, startAngle:float) -> None: ...
        def setVerticalPosition(self, relativePosition:float) -> None: ...
        def slices(self) -> typing.List: ...
        def sum(self) -> float: ...
        def take(self, slice:PySide2.QtCharts.QtCharts.QPieSlice) -> bool: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...
        def verticalPosition(self) -> float: ...

    class QPieSlice(PySide2.QtCore.QObject):

        angleSpanChanged: PySide2.QtCore.Signal
        borderColorChanged: PySide2.QtCore.Signal
        borderWidthChanged: PySide2.QtCore.Signal
        brushChanged: PySide2.QtCore.Signal
        clicked: PySide2.QtCore.Signal
        colorChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        labelBrushChanged: PySide2.QtCore.Signal
        labelChanged: PySide2.QtCore.Signal
        labelColorChanged: PySide2.QtCore.Signal
        labelFontChanged: PySide2.QtCore.Signal
        labelVisibleChanged: PySide2.QtCore.Signal
        penChanged: PySide2.QtCore.Signal
        percentageChanged: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal
        startAngleChanged: PySide2.QtCore.Signal
        valueChanged: PySide2.QtCore.Signal

        LabelOutside             : QtCharts.QPieSlice.LabelPosition = ... # 0x0
        LabelInsideHorizontal    : QtCharts.QPieSlice.LabelPosition = ... # 0x1
        LabelInsideTangential    : QtCharts.QPieSlice.LabelPosition = ... # 0x2
        LabelInsideNormal        : QtCharts.QPieSlice.LabelPosition = ... # 0x3

        class LabelPosition(object):
            LabelOutside             : QtCharts.QPieSlice.LabelPosition = ... # 0x0
            LabelInsideHorizontal    : QtCharts.QPieSlice.LabelPosition = ... # 0x1
            LabelInsideTangential    : QtCharts.QPieSlice.LabelPosition = ... # 0x2
            LabelInsideNormal        : QtCharts.QPieSlice.LabelPosition = ... # 0x3

        @typing.overload
        def __init__(self, label:str, value:float, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def angleSpan(self) -> float: ...
        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def borderWidth(self) -> int: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def explodeDistanceFactor(self) -> float: ...
        def isExploded(self) -> bool: ...
        def isLabelVisible(self) -> bool: ...
        def label(self) -> str: ...
        def labelArmLengthFactor(self) -> float: ...
        def labelBrush(self) -> PySide2.QtGui.QBrush: ...
        def labelColor(self) -> PySide2.QtGui.QColor: ...
        def labelFont(self) -> PySide2.QtGui.QFont: ...
        def labelPosition(self) -> PySide2.QtCharts.QtCharts.QPieSlice.LabelPosition: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def percentage(self) -> float: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QPieSeries: ...
        def setBorderColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setBorderWidth(self, width:int) -> None: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setExplodeDistanceFactor(self, factor:float) -> None: ...
        def setExploded(self, exploded:bool=...) -> None: ...
        def setLabel(self, label:str) -> None: ...
        def setLabelArmLengthFactor(self, factor:float) -> None: ...
        def setLabelBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setLabelColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setLabelFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setLabelPosition(self, position:PySide2.QtCharts.QtCharts.QPieSlice.LabelPosition) -> None: ...
        def setLabelVisible(self, visible:bool=...) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setValue(self, value:float) -> None: ...
        def startAngle(self) -> float: ...
        def value(self) -> float: ...

    class QPolarChart(PySide2.QtCharts.QChart):
        PolarOrientationRadial   : QtCharts.QPolarChart.PolarOrientation = ... # 0x1
        PolarOrientationAngular  : QtCharts.QPolarChart.PolarOrientation = ... # 0x2

        class PolarOrientation(object):
            PolarOrientationRadial   : QtCharts.QPolarChart.PolarOrientation = ... # 0x1
            PolarOrientationAngular  : QtCharts.QPolarChart.PolarOrientation = ... # 0x2
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, PolarOrientation] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __and__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __xor__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __ror__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __rand__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __rxor__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __ior__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __iand__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __ixor__(self, other: typing.Union[int, PolarOrientation]) -> PolarOrientations: ...
            def __invert__(self) -> PolarOrientations: ...

        class PolarOrientations(object):
            
            def __index__(self) -> int: ...
            def __init__(self, value: typing.Union[int, PolarOrientation, PolarOrientations] = ...) -> None: ...
            def __or__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __and__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __xor__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __ror__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __rand__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __rxor__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __ior__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __iand__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __ixor__(self, other: typing.Union[int, PolarOrientation, PolarOrientations]) -> PolarOrientations: ...
            def __invert__(self) -> PolarOrientations: ...

        def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=..., wFlags:PySide2.QtCore.Qt.WindowFlags=...) -> None: ...

        @typing.overload
        def addAxis(self, axis:PySide2.QtCharts.QtCharts.QAbstractAxis, alignment:PySide2.QtCore.Qt.Alignment) -> None: ...
        @typing.overload
        def addAxis(self, axis:PySide2.QtCharts.QtCharts.QAbstractAxis, polarOrientation:PySide2.QtCharts.QtCharts.QPolarChart.PolarOrientation) -> None: ...
        @staticmethod
        def axisPolarOrientation(axis:PySide2.QtCharts.QtCharts.QAbstractAxis) -> PySide2.QtCharts.QtCharts.QPolarChart.PolarOrientation: ...

    class QScatterSeries(PySide2.QtCharts.QXYSeries):

        borderColorChanged: PySide2.QtCore.Signal
        colorChanged: PySide2.QtCore.Signal
        markerShapeChanged: PySide2.QtCore.Signal
        markerSizeChanged: PySide2.QtCore.Signal

        MarkerShapeCircle        : QtCharts.QScatterSeries.MarkerShape = ... # 0x0
        MarkerShapeRectangle     : QtCharts.QScatterSeries.MarkerShape = ... # 0x1

        class MarkerShape(object):
            MarkerShapeCircle        : QtCharts.QScatterSeries.MarkerShape = ... # 0x0
            MarkerShapeRectangle     : QtCharts.QScatterSeries.MarkerShape = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def borderColor(self) -> PySide2.QtGui.QColor: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def markerShape(self) -> PySide2.QtCharts.QtCharts.QScatterSeries.MarkerShape: ...
        def markerSize(self) -> float: ...
        def setBorderColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setMarkerShape(self, shape:PySide2.QtCharts.QtCharts.QScatterSeries.MarkerShape) -> None: ...
        def setMarkerSize(self, size:float) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QSplineSeries(PySide2.QtCharts.QLineSeries):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QStackedBarSeries(PySide2.QtCharts.QAbstractBarSeries):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType: ...

    class QVBarModelMapper(PySide2.QtCharts.QBarModelMapper):

        firstBarSetColumnChanged: PySide2.QtCore.Signal
        firstRowChanged: PySide2.QtCore.Signal
        lastBarSetColumnChanged: PySide2.QtCore.Signal
        modelReplaced: PySide2.QtCore.Signal
        rowCountChanged: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def firstBarSetColumn(self) -> int: ...
        def firstRow(self) -> int: ...
        def lastBarSetColumn(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def rowCount(self) -> int: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QAbstractBarSeries: ...
        def setFirstBarSetColumn(self, firstBarSetColumn:int) -> None: ...
        def setFirstRow(self, firstRow:int) -> None: ...
        def setLastBarSetColumn(self, lastBarSetColumn:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setRowCount(self, rowCount:int) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QAbstractBarSeries) -> None: ...

    class QVBoxPlotModelMapper(PySide2.QtCharts.QBoxPlotModelMapper):

        firstBoxSetColumnChanged: PySide2.QtCore.Signal
        firstRowChanged: PySide2.QtCore.Signal
        lastBoxSetColumnChanged: PySide2.QtCore.Signal
        modelReplaced: PySide2.QtCore.Signal
        rowCountChanged: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def firstBoxSetColumn(self) -> int: ...
        def firstRow(self) -> int: ...
        def lastBoxSetColumn(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def rowCount(self) -> int: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QBoxPlotSeries: ...
        def setFirstBoxSetColumn(self, firstBoxSetColumn:int) -> None: ...
        def setFirstRow(self, firstRow:int) -> None: ...
        def setLastBoxSetColumn(self, lastBoxSetColumn:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setRowCount(self, rowCount:int) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QBoxPlotSeries) -> None: ...

    class QVCandlestickModelMapper(PySide2.QtCharts.QCandlestickModelMapper):

        closeRowChanged: PySide2.QtCore.Signal
        firstSetColumnChanged: PySide2.QtCore.Signal
        highRowChanged: PySide2.QtCore.Signal
        lastSetColumnChanged: PySide2.QtCore.Signal
        lowRowChanged: PySide2.QtCore.Signal
        openRowChanged: PySide2.QtCore.Signal
        timestampRowChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def closeRow(self) -> int: ...
        def firstSetColumn(self) -> int: ...
        def highRow(self) -> int: ...
        def lastSetColumn(self) -> int: ...
        def lowRow(self) -> int: ...
        def openRow(self) -> int: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def setCloseRow(self, closeRow:int) -> None: ...
        def setFirstSetColumn(self, firstSetColumn:int) -> None: ...
        def setHighRow(self, highRow:int) -> None: ...
        def setLastSetColumn(self, lastSetColumn:int) -> None: ...
        def setLowRow(self, lowRow:int) -> None: ...
        def setOpenRow(self, openRow:int) -> None: ...
        def setTimestampRow(self, timestampRow:int) -> None: ...
        def timestampRow(self) -> int: ...

    class QVPieModelMapper(PySide2.QtCharts.QPieModelMapper):

        firstRowChanged: PySide2.QtCore.Signal
        labelsColumnChanged: PySide2.QtCore.Signal
        modelReplaced: PySide2.QtCore.Signal
        rowCountChanged: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal
        valuesColumnChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def firstRow(self) -> int: ...
        def labelsColumn(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def rowCount(self) -> int: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QPieSeries: ...
        def setFirstRow(self, firstRow:int) -> None: ...
        def setLabelsColumn(self, labelsColumn:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setRowCount(self, rowCount:int) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QPieSeries) -> None: ...
        def setValuesColumn(self, valuesColumn:int) -> None: ...
        def valuesColumn(self) -> int: ...

    class QVXYModelMapper(PySide2.QtCharts.QXYModelMapper):

        firstRowChanged: PySide2.QtCore.Signal
        modelReplaced: PySide2.QtCore.Signal
        rowCountChanged: PySide2.QtCore.Signal
        seriesReplaced: PySide2.QtCore.Signal
        xColumnChanged: PySide2.QtCore.Signal
        yColumnChanged: PySide2.QtCore.Signal


        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def firstRow(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def rowCount(self) -> int: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QXYSeries: ...
        def setFirstRow(self, firstRow:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setRowCount(self, rowCount:int) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QXYSeries) -> None: ...
        def setXColumn(self, xColumn:int) -> None: ...
        def setYColumn(self, yColumn:int) -> None: ...
        def xColumn(self) -> int: ...
        def yColumn(self) -> int: ...

    class QValueAxis(PySide2.QtCharts.QAbstractAxis):

        labelFormatChanged: PySide2.QtCore.Signal
        maxChanged: PySide2.QtCore.Signal
        minChanged: PySide2.QtCore.Signal
        minorTickCountChanged: PySide2.QtCore.Signal
        rangeChanged: PySide2.QtCore.Signal
        tickAnchorChanged: PySide2.QtCore.Signal
        tickCountChanged: PySide2.QtCore.Signal
        tickIntervalChanged: PySide2.QtCore.Signal
        tickTypeChanged: PySide2.QtCore.Signal

        TicksDynamic             : QtCharts.QValueAxis.TickType = ... # 0x0
        TicksFixed               : QtCharts.QValueAxis.TickType = ... # 0x1

        class TickType(object):
            TicksDynamic             : QtCharts.QValueAxis.TickType = ... # 0x0
            TicksFixed               : QtCharts.QValueAxis.TickType = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def applyNiceNumbers(self) -> None: ...
        def labelFormat(self) -> str: ...
        def max(self) -> float: ...
        def min(self) -> float: ...
        def minorTickCount(self) -> int: ...
        def setLabelFormat(self, format:str) -> None: ...
        @typing.overload
        def setMax(self, max:typing.Any) -> None: ...
        @typing.overload
        def setMax(self, max:float) -> None: ...
        @typing.overload
        def setMin(self, min:typing.Any) -> None: ...
        @typing.overload
        def setMin(self, min:float) -> None: ...
        def setMinorTickCount(self, count:int) -> None: ...
        @typing.overload
        def setRange(self, min:typing.Any, max:typing.Any) -> None: ...
        @typing.overload
        def setRange(self, min:float, max:float) -> None: ...
        def setTickAnchor(self, anchor:float) -> None: ...
        def setTickCount(self, count:int) -> None: ...
        def setTickInterval(self, insterval:float) -> None: ...
        def setTickType(self, type:PySide2.QtCharts.QtCharts.QValueAxis.TickType) -> None: ...
        def tickAnchor(self) -> float: ...
        def tickCount(self) -> int: ...
        def tickInterval(self) -> float: ...
        def tickType(self) -> PySide2.QtCharts.QtCharts.QValueAxis.TickType: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QAbstractAxis.AxisType: ...

    class QXYLegendMarker(PySide2.QtCharts.QLegendMarker):

        def __init__(self, series:PySide2.QtCharts.QtCharts.QXYSeries, legend:PySide2.QtCharts.QtCharts.QLegend, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def series(self) -> PySide2.QtCharts.QtCharts.QXYSeries: ...
        def type(self) -> PySide2.QtCharts.QtCharts.QLegendMarker.LegendMarkerType: ...

    class QXYModelMapper(PySide2.QtCore.QObject):

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

        def count(self) -> int: ...
        def first(self) -> int: ...
        def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
        def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
        def series(self) -> PySide2.QtCharts.QtCharts.QXYSeries: ...
        def setCount(self, count:int) -> None: ...
        def setFirst(self, first:int) -> None: ...
        def setModel(self, model:PySide2.QtCore.QAbstractItemModel) -> None: ...
        def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation) -> None: ...
        def setSeries(self, series:PySide2.QtCharts.QtCharts.QXYSeries) -> None: ...
        def setXSection(self, xSection:int) -> None: ...
        def setYSection(self, ySection:int) -> None: ...
        def xSection(self) -> int: ...
        def ySection(self) -> int: ...

    class QXYSeries(PySide2.QtCharts.QAbstractSeries):

        clicked: PySide2.QtCore.Signal
        colorChanged: PySide2.QtCore.Signal
        doubleClicked: PySide2.QtCore.Signal
        hovered: PySide2.QtCore.Signal
        penChanged: PySide2.QtCore.Signal
        pointAdded: PySide2.QtCore.Signal
        pointLabelsClippingChanged: PySide2.QtCore.Signal
        pointLabelsColorChanged: PySide2.QtCore.Signal
        pointLabelsFontChanged: PySide2.QtCore.Signal
        pointLabelsFormatChanged: PySide2.QtCore.Signal
        pointLabelsVisibilityChanged: PySide2.QtCore.Signal
        pointRemoved: PySide2.QtCore.Signal
        pointReplaced: PySide2.QtCore.Signal
        pointsRemoved: PySide2.QtCore.Signal
        pointsReplaced: PySide2.QtCore.Signal
        pressed: PySide2.QtCore.Signal
        released: PySide2.QtCore.Signal

        @typing.overload
        def __lshift__(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCharts.QtCharts.QXYSeries: ...
        @typing.overload
        def __lshift__(self, points:typing.Sequence) -> PySide2.QtCharts.QtCharts.QXYSeries: ...
        @typing.overload
        def append(self, point:PySide2.QtCore.QPointF) -> None: ...
        @typing.overload
        def append(self, points:typing.Sequence) -> None: ...
        @typing.overload
        def append(self, x:float, y:float) -> None: ...
        def at(self, index:int) -> PySide2.QtCore.QPointF: ...
        def brush(self) -> PySide2.QtGui.QBrush: ...
        def clear(self) -> None: ...
        def color(self) -> PySide2.QtGui.QColor: ...
        def count(self) -> int: ...
        def insert(self, index:int, point:PySide2.QtCore.QPointF) -> None: ...
        def pen(self) -> PySide2.QtGui.QPen: ...
        def pointLabelsClipping(self) -> bool: ...
        def pointLabelsColor(self) -> PySide2.QtGui.QColor: ...
        def pointLabelsFont(self) -> PySide2.QtGui.QFont: ...
        def pointLabelsFormat(self) -> str: ...
        def pointLabelsVisible(self) -> bool: ...
        def points(self) -> typing.List: ...
        def pointsVector(self) -> typing.List: ...
        def pointsVisible(self) -> bool: ...
        @typing.overload
        def remove(self, index:int) -> None: ...
        @typing.overload
        def remove(self, point:PySide2.QtCore.QPointF) -> None: ...
        @typing.overload
        def remove(self, x:float, y:float) -> None: ...
        def removePoints(self, index:int, count:int) -> None: ...
        @typing.overload
        def replace(self, index:int, newPoint:PySide2.QtCore.QPointF) -> None: ...
        @typing.overload
        def replace(self, index:int, newX:float, newY:float) -> None: ...
        @typing.overload
        def replace(self, oldPoint:PySide2.QtCore.QPointF, newPoint:PySide2.QtCore.QPointF) -> None: ...
        @typing.overload
        def replace(self, oldX:float, oldY:float, newX:float, newY:float) -> None: ...
        @typing.overload
        def replace(self, points:typing.Sequence) -> None: ...
        @typing.overload
        def replace(self, points:typing.List) -> None: ...
        def setBrush(self, brush: Union[PySide2.QtGui.QBrush, PySide2.QtGui.QColor]) -> None: ...
        def setColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
        def setPointLabelsClipping(self, enabled:bool=...) -> None: ...
        def setPointLabelsColor(self, color: Union[PySide2.QtGui.QColor, PySide2.QtCore.Qt.GlobalColor, str, int]) -> None: ...
        def setPointLabelsFont(self, font:PySide2.QtGui.QFont) -> None: ...
        def setPointLabelsFormat(self, format:str) -> None: ...
        def setPointLabelsVisible(self, visible:bool=...) -> None: ...
        def setPointsVisible(self, visible:bool=...) -> None: ...

# eof
