# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs-dev/00_core.ipynb.

# %% auto 0
__all__ = ['TextFileBaseIterator']

# %% ../nbs-dev/00_core.ipynb 4
import json
import re
from ecutilities.core import validate_path, validate_type
from pathlib import Path
from typing import Any, Optional

# %% ../nbs-dev/00_core.ipynb 6
class TextFileBaseIterator:
    """Iterator going through a text file by chunks of `nlines` lines"""
    def __init__(
        self, 
        path:str|Path,  # path to the file to read 
        nlines:int=1, # number of text lines in each text chunk 
    ):
        validate_path(path, raise_error=True)
        self.path = path
        self.fp = open(path, 'r')
        self.nlines = nlines

    def __iter__(self):
        return self

    def _safe_readline(self):
        """Read a new line and handle end of file tasks"""
        line = self.fp.readline()
        if line == '':
            self.fp.close()
            raise StopIteration()
        return line

    def __next__(self):
        """Return one chunk at the time"""
        lines = []
        for i in range(self.nlines):
            lines.append(self._safe_readline())
        return ''.join(lines)
    
    def print_first_chuncks(
        self, 
        nchunks:int=3,  # number of chuncks to print
    ):
        """Print the first `nchunck chuncks of text from the file"""
        for i, chunk in enumerate(self.__iter__()):
            if i > nchunks-1: break
            print(f"{self.nlines}-line chunk {i+1}")
            print(chunk)
        
