"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePermissions = exports.Resource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
/**
 * Base class for all Kubernetes objects in stdk8s. Represents a single
 * resource.
 */
class Resource extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.permissions = new ResourcePermissions(this);
    }
    get metadata() {
        return this.apiObject.metadata;
    }
    /**
     * The name of this API object.
     */
    get name() {
        return this.apiObject.name;
    }
    /**
     * The object's API version (e.g. "authorization.k8s.io/v1")
     */
    get apiVersion() {
        return this.apiObject.apiVersion;
    }
    /**
     * The group portion of the API version (e.g. "authorization.k8s.io").
     */
    get apiGroup() {
        return this.apiObject.apiGroup;
    }
    /**
     * The object kind (e.g. "Deployment").
     */
    get kind() {
        return this.apiObject.kind;
    }
    get resourceName() {
        return this.name;
    }
    asApiResource() {
        return this;
    }
    asNonApiResource() {
        return undefined;
    }
}
exports.Resource = Resource;
_a = JSII_RTTI_SYMBOL_1;
Resource[_a] = { fqn: "cdk8s-plus-28.Resource", version: "2.5.1" };
/**
 * Controls permissions for operations on resources.
 */
class ResourcePermissions {
    constructor(instance) {
        this.instance = instance;
    }
    /**
     * Grants the list of subjects permissions to read this resource.
     */
    grantRead(...subjects) {
        const subjectsAddress = utils_1.address(...subjects);
        const role = new r.Role(this.instance, `Role${subjectsAddress}`, {
            metadata: { namespace: this.instance.metadata.namespace },
        });
        role.allowRead(this.instance);
        return role.bind(...subjects);
    }
    /**
     * Grants the list of subjects permissions to read and write this resource.
     */
    grantReadWrite(...subjects) {
        const subjectsAddress = utils_1.address(...subjects);
        const role = new r.Role(this.instance, `Role${subjectsAddress}`, {
            metadata: { namespace: this.instance.metadata.namespace },
        });
        role.allowReadWrite(this.instance);
        return role.bind(...subjects);
    }
}
exports.ResourcePermissions = ResourcePermissions;
_b = JSII_RTTI_SYMBOL_1;
ResourcePermissions[_b] = { fqn: "cdk8s-plus-28.ResourcePermissions", version: "2.5.1" };
// meh, avoiding errors due to circular imports...
const r = require("./role");
const utils_1 = require("./utils");
//# sourceMappingURL=data:application/json;base64,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