from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdk8s as _cdk8s_d3d9af27
import constructs as _constructs_77d1e7e8


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.Affinity",
    jsii_struct_bases=[],
    name_mapping={
        "node_affinity": "nodeAffinity",
        "pod_affinity": "podAffinity",
        "pod_anti_affinity": "podAntiAffinity",
    },
)
class Affinity:
    def __init__(
        self,
        *,
        node_affinity: typing.Optional[typing.Union["NodeAffinity", typing.Dict[builtins.str, typing.Any]]] = None,
        pod_affinity: typing.Optional[typing.Union["PodAffinity", typing.Dict[builtins.str, typing.Any]]] = None,
        pod_anti_affinity: typing.Optional[typing.Union["PodAntiAffinity", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Affinity is a group of affinity scheduling rules.

        :param node_affinity: Describes node affinity scheduling rules for the pod.
        :param pod_affinity: Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        :param pod_anti_affinity: Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).

        :schema: io.k8s.api.core.v1.Affinity
        '''
        if isinstance(node_affinity, dict):
            node_affinity = NodeAffinity(**node_affinity)
        if isinstance(pod_affinity, dict):
            pod_affinity = PodAffinity(**pod_affinity)
        if isinstance(pod_anti_affinity, dict):
            pod_anti_affinity = PodAntiAffinity(**pod_anti_affinity)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__98a5325133c002afdc7688b7d639acd18d4dcd30af9af812a75f63274cf3d9ba)
            check_type(argname="argument node_affinity", value=node_affinity, expected_type=type_hints["node_affinity"])
            check_type(argname="argument pod_affinity", value=pod_affinity, expected_type=type_hints["pod_affinity"])
            check_type(argname="argument pod_anti_affinity", value=pod_anti_affinity, expected_type=type_hints["pod_anti_affinity"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if node_affinity is not None:
            self._values["node_affinity"] = node_affinity
        if pod_affinity is not None:
            self._values["pod_affinity"] = pod_affinity
        if pod_anti_affinity is not None:
            self._values["pod_anti_affinity"] = pod_anti_affinity

    @builtins.property
    def node_affinity(self) -> typing.Optional["NodeAffinity"]:
        '''Describes node affinity scheduling rules for the pod.

        :schema: io.k8s.api.core.v1.Affinity#nodeAffinity
        '''
        result = self._values.get("node_affinity")
        return typing.cast(typing.Optional["NodeAffinity"], result)

    @builtins.property
    def pod_affinity(self) -> typing.Optional["PodAffinity"]:
        '''Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).

        :schema: io.k8s.api.core.v1.Affinity#podAffinity
        '''
        result = self._values.get("pod_affinity")
        return typing.cast(typing.Optional["PodAffinity"], result)

    @builtins.property
    def pod_anti_affinity(self) -> typing.Optional["PodAntiAffinity"]:
        '''Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).

        :schema: io.k8s.api.core.v1.Affinity#podAntiAffinity
        '''
        result = self._values.get("pod_anti_affinity")
        return typing.cast(typing.Optional["PodAntiAffinity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Affinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.AggregationRule",
    jsii_struct_bases=[],
    name_mapping={"cluster_role_selectors": "clusterRoleSelectors"},
)
class AggregationRule:
    def __init__(
        self,
        *,
        cluster_role_selectors: typing.Optional[typing.Sequence[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole.

        :param cluster_role_selectors: ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules. If any of the selectors match, then the ClusterRole's permissions will be added

        :schema: io.k8s.api.rbac.v1.AggregationRule
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__855e741b294ded8576d13f6a6fe17c1202e56ad802f6869e016f9e6df4abb8d2)
            check_type(argname="argument cluster_role_selectors", value=cluster_role_selectors, expected_type=type_hints["cluster_role_selectors"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if cluster_role_selectors is not None:
            self._values["cluster_role_selectors"] = cluster_role_selectors

    @builtins.property
    def cluster_role_selectors(self) -> typing.Optional[typing.List["LabelSelector"]]:
        '''ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules.

        If any of the selectors match, then the ClusterRole's permissions will be added

        :schema: io.k8s.api.rbac.v1.AggregationRule#clusterRoleSelectors
        '''
        result = self._values.get("cluster_role_selectors")
        return typing.cast(typing.Optional[typing.List["LabelSelector"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AggregationRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ApiServiceSpec",
    jsii_struct_bases=[],
    name_mapping={
        "group_priority_minimum": "groupPriorityMinimum",
        "version_priority": "versionPriority",
        "ca_bundle": "caBundle",
        "group": "group",
        "insecure_skip_tls_verify": "insecureSkipTlsVerify",
        "service": "service",
        "version": "version",
    },
)
class ApiServiceSpec:
    def __init__(
        self,
        *,
        group_priority_minimum: jsii.Number,
        version_priority: jsii.Number,
        ca_bundle: typing.Optional[builtins.str] = None,
        group: typing.Optional[builtins.str] = None,
        insecure_skip_tls_verify: typing.Optional[builtins.bool] = None,
        service: typing.Optional[typing.Union["ServiceReference", typing.Dict[builtins.str, typing.Any]]] = None,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''APIServiceSpec contains information for locating and communicating with a server.

        Only https is supported, though you are able to disable certificate verification.

        :param group_priority_minimum: GroupPriorityMininum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object. (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s
        :param version_priority: VersionPriority controls the ordering of this API version inside of its group. Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        :param ca_bundle: CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.
        :param group: Group is the API group name this server hosts.
        :param insecure_skip_tls_verify: InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged. You should use the CABundle instead.
        :param service: Service is a reference to the service for this API server. It must communicate on port 443. If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.
        :param version: Version is the API version this server hosts. For example, "v1"

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec
        '''
        if isinstance(service, dict):
            service = ServiceReference(**service)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c4a845dd7ea03bd43736154d775e8456d917c2c6708a1f0d7ff3b0bf786cb5d)
            check_type(argname="argument group_priority_minimum", value=group_priority_minimum, expected_type=type_hints["group_priority_minimum"])
            check_type(argname="argument version_priority", value=version_priority, expected_type=type_hints["version_priority"])
            check_type(argname="argument ca_bundle", value=ca_bundle, expected_type=type_hints["ca_bundle"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument insecure_skip_tls_verify", value=insecure_skip_tls_verify, expected_type=type_hints["insecure_skip_tls_verify"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
            check_type(argname="argument version", value=version, expected_type=type_hints["version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "group_priority_minimum": group_priority_minimum,
            "version_priority": version_priority,
        }
        if ca_bundle is not None:
            self._values["ca_bundle"] = ca_bundle
        if group is not None:
            self._values["group"] = group
        if insecure_skip_tls_verify is not None:
            self._values["insecure_skip_tls_verify"] = insecure_skip_tls_verify
        if service is not None:
            self._values["service"] = service
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def group_priority_minimum(self) -> jsii.Number:
        '''GroupPriorityMininum is the priority this group should have at least.

        Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#groupPriorityMinimum
        '''
        result = self._values.get("group_priority_minimum")
        assert result is not None, "Required property 'group_priority_minimum' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def version_priority(self) -> jsii.Number:
        '''VersionPriority controls the ordering of this API version inside of its group.

        Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#versionPriority
        '''
        result = self._values.get("version_priority")
        assert result is not None, "Required property 'version_priority' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def ca_bundle(self) -> typing.Optional[builtins.str]:
        '''CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate.

        If unspecified, system trust roots on the apiserver are used.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#caBundle
        '''
        result = self._values.get("ca_bundle")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def group(self) -> typing.Optional[builtins.str]:
        '''Group is the API group name this server hosts.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#group
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def insecure_skip_tls_verify(self) -> typing.Optional[builtins.bool]:
        '''InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server.

        This is strongly discouraged.  You should use the CABundle instead.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#insecureSkipTLSVerify
        '''
        result = self._values.get("insecure_skip_tls_verify")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def service(self) -> typing.Optional["ServiceReference"]:
        '''Service is a reference to the service for this API server.

        It must communicate on port 443. If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#service
        '''
        result = self._values.get("service")
        return typing.cast(typing.Optional["ServiceReference"], result)

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        '''Version is the API version this server hosts.

        For example, "v1"

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#version
        '''
        result = self._values.get("version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiServiceSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.AuditAnnotationV1Alpha1",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value_expression": "valueExpression"},
)
class AuditAnnotationV1Alpha1:
    def __init__(self, *, key: builtins.str, value_expression: builtins.str) -> None:
        '''AuditAnnotation describes how to produce an audit annotation for an API request.

        :param key: key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length. The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}". If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded. Required.
        :param value_expression: valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb. If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list. Required.

        :schema: io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1dd0c1667c0f104be2642fad2fe83453e84dee656f2934d83cd63847b2560eb)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value_expression", value=value_expression, expected_type=type_hints["value_expression"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "value_expression": value_expression,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''key specifies the audit annotation key.

        The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.

        The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".

        If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.

        Required.

        :schema: io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value_expression(self) -> builtins.str:
        '''valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value.

        The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.

        If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.

        Required.

        :schema: io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation#valueExpression
        '''
        result = self._values.get("value_expression")
        assert result is not None, "Required property 'value_expression' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AuditAnnotationV1Alpha1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.AuditAnnotationV1Beta1",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value_expression": "valueExpression"},
)
class AuditAnnotationV1Beta1:
    def __init__(self, *, key: builtins.str, value_expression: builtins.str) -> None:
        '''AuditAnnotation describes how to produce an audit annotation for an API request.

        :param key: key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length. The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}". If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded. Required.
        :param value_expression: valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb. If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list. Required.

        :schema: io.k8s.api.admissionregistration.v1beta1.AuditAnnotation
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b62884bcf32bfb2019ddd3a820dbbcc689a3f8a1804a483cc8a159955cfad3bd)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value_expression", value=value_expression, expected_type=type_hints["value_expression"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "value_expression": value_expression,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''key specifies the audit annotation key.

        The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.

        The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: "{ValidatingAdmissionPolicy name}/{key}".

        If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.

        Required.

        :schema: io.k8s.api.admissionregistration.v1beta1.AuditAnnotation#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value_expression(self) -> builtins.str:
        '''valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value.

        The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.

        If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.

        Required.

        :schema: io.k8s.api.admissionregistration.v1beta1.AuditAnnotation#valueExpression
        '''
        result = self._values.get("value_expression")
        assert result is not None, "Required property 'value_expression' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AuditAnnotationV1Beta1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.AwsElasticBlockStoreVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStoreVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Represents a Persistent Disk resource in AWS.

        An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.

        :param volume_id: volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param partition: partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        :param read_only: readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58b8cec47a9247ed74091cd3edf303911b45e409f76e81a651afec722afc5e9b)
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume).

        More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''partition is the partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#partition
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly value true will force the readOnly setting in VolumeMounts.

        More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStoreVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.AzureDiskVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "disk_name": "diskName",
        "disk_uri": "diskUri",
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "read_only": "readOnly",
    },
)
class AzureDiskVolumeSource:
    def __init__(
        self,
        *,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[builtins.str] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.

        :param disk_name: diskName is the Name of the data disk in the blob storage.
        :param disk_uri: diskURI is the URI of data disk in the blob storage.
        :param caching_mode: cachingMode is the Host Caching mode: None, Read Only, Read Write.
        :param fs_type: fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param kind: kind expected values are Shared: multiple blob disks per storage account Dedicated: single blob disk per storage account Managed: azure managed data disk (only in managed availability set). defaults to shared
        :param read_only: readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c39b95077157105a72becf7a007747a6dec0b024d0cfc6a76a5e3c3a86b7ff96)
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "disk_name": disk_name,
            "disk_uri": disk_uri,
        }
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def disk_name(self) -> builtins.str:
        '''diskName is the Name of the data disk in the blob storage.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#diskName
        '''
        result = self._values.get("disk_name")
        assert result is not None, "Required property 'disk_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def disk_uri(self) -> builtins.str:
        '''diskURI is the URI of data disk in the blob storage.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#diskURI
        '''
        result = self._values.get("disk_uri")
        assert result is not None, "Required property 'disk_uri' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def caching_mode(self) -> typing.Optional[builtins.str]:
        '''cachingMode is the Host Caching mode: None, Read Only, Read Write.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#cachingMode
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        '''kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set).

        defaults to shared

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.AzureFilePersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "secret_name": "secretName",
        "share_name": "shareName",
        "read_only": "readOnly",
        "secret_namespace": "secretNamespace",
    },
)
class AzureFilePersistentVolumeSource:
    def __init__(
        self,
        *,
        secret_name: builtins.str,
        share_name: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
        secret_namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''AzureFile represents an Azure File Service mount on the host and bind mount to the pod.

        :param secret_name: secretName is the name of secret that contains Azure Storage Account Name and Key.
        :param share_name: shareName is the azure Share Name.
        :param read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_namespace: secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e63b12346b35d3703b25e5a1734b0e5bd120ced9b1cdda0d9498afecf4c76737)
            check_type(argname="argument secret_name", value=secret_name, expected_type=type_hints["secret_name"])
            check_type(argname="argument share_name", value=share_name, expected_type=type_hints["share_name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_namespace", value=secret_namespace, expected_type=type_hints["secret_namespace"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "secret_name": secret_name,
            "share_name": share_name,
        }
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_namespace is not None:
            self._values["secret_namespace"] = secret_namespace

    @builtins.property
    def secret_name(self) -> builtins.str:
        '''secretName is the name of secret that contains Azure Storage Account Name and Key.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#secretName
        '''
        result = self._values.get("secret_name")
        assert result is not None, "Required property 'secret_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def share_name(self) -> builtins.str:
        '''shareName is the azure Share Name.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#shareName
        '''
        result = self._values.get("share_name")
        assert result is not None, "Required property 'share_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_namespace(self) -> typing.Optional[builtins.str]:
        '''secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod.

        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#secretNamespace
        '''
        result = self._values.get("secret_namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureFilePersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.AzureFileVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "secret_name": "secretName",
        "share_name": "shareName",
        "read_only": "readOnly",
    },
)
class AzureFileVolumeSource:
    def __init__(
        self,
        *,
        secret_name: builtins.str,
        share_name: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''AzureFile represents an Azure File Service mount on the host and bind mount to the pod.

        :param secret_name: secretName is the name of secret that contains Azure Storage Account Name and Key.
        :param share_name: shareName is the azure share Name.
        :param read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureFileVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a28886bf4f8142922162bcf9231cd3d0364a0ba902b2c7dde260db6a90956d1)
            check_type(argname="argument secret_name", value=secret_name, expected_type=type_hints["secret_name"])
            check_type(argname="argument share_name", value=share_name, expected_type=type_hints["share_name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "secret_name": secret_name,
            "share_name": share_name,
        }
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def secret_name(self) -> builtins.str:
        '''secretName is the  name of secret that contains Azure Storage Account Name and Key.

        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#secretName
        '''
        result = self._values.get("secret_name")
        assert result is not None, "Required property 'secret_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def share_name(self) -> builtins.str:
        '''shareName is the azure share Name.

        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#shareName
        '''
        result = self._values.get("share_name")
        assert result is not None, "Required property 'share_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureFileVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.BoundObjectReference",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "kind": "kind",
        "name": "name",
        "uid": "uid",
    },
)
class BoundObjectReference:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        kind: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        uid: typing.Optional[builtins.str] = None,
    ) -> None:
        '''BoundObjectReference is a reference to an object that a token is bound to.

        :param api_version: API version of the referent.
        :param kind: Kind of the referent. Valid kinds are 'Pod' and 'Secret'.
        :param name: Name of the referent.
        :param uid: UID of the referent.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__490f977d7cbd72af578647e36c1397ab9e696e802a13d07d2881537d6dc7a0c0)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if kind is not None:
            self._values["kind"] = kind
        if name is not None:
            self._values["name"] = name
        if uid is not None:
            self._values["uid"] = uid

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''API version of the referent.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        '''Kind of the referent.

        Valid kinds are 'Pod' and 'Secret'.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def uid(self) -> typing.Optional[builtins.str]:
        '''UID of the referent.

        :schema: io.k8s.api.authentication.v1.BoundObjectReference#uid
        '''
        result = self._values.get("uid")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BoundObjectReference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.Capabilities",
    jsii_struct_bases=[],
    name_mapping={"add": "add", "drop": "drop"},
)
class Capabilities:
    def __init__(
        self,
        *,
        add: typing.Optional[typing.Sequence[builtins.str]] = None,
        drop: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Adds and removes POSIX capabilities from running containers.

        :param add: Added capabilities.
        :param drop: Removed capabilities.

        :schema: io.k8s.api.core.v1.Capabilities
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3f0c7792478a7ce4b2c0776cd623889009c8d148d5474bfc72d8bc492285c95c)
            check_type(argname="argument add", value=add, expected_type=type_hints["add"])
            check_type(argname="argument drop", value=drop, expected_type=type_hints["drop"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if add is not None:
            self._values["add"] = add
        if drop is not None:
            self._values["drop"] = drop

    @builtins.property
    def add(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Added capabilities.

        :schema: io.k8s.api.core.v1.Capabilities#add
        '''
        result = self._values.get("add")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def drop(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Removed capabilities.

        :schema: io.k8s.api.core.v1.Capabilities#drop
        '''
        result = self._values.get("drop")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Capabilities(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CephFsPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "monitors": "monitors",
        "path": "path",
        "read_only": "readOnly",
        "secret_file": "secretFile",
        "secret_ref": "secretRef",
        "user": "user",
    },
)
class CephFsPersistentVolumeSource:
    def __init__(
        self,
        *,
        monitors: typing.Sequence[builtins.str],
        path: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_file: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.

        :param monitors: monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
        :param path: path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /.
        :param read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param secret_file: secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
        :param secret_ref: secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param user: user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ebe89666d8428e8956c4e0e7b845ba4217defe795e88295dc4f9d09c8690fff)
            check_type(argname="argument monitors", value=monitors, expected_type=type_hints["monitors"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_file", value=secret_file, expected_type=type_hints["secret_file"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "monitors": monitors,
        }
        if path is not None:
            self._values["path"] = path
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_file is not None:
            self._values["secret_file"] = secret_file
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def monitors(self) -> typing.List[builtins.str]:
        '''monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#monitors
        '''
        result = self._values.get("monitors")
        assert result is not None, "Required property 'monitors' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_file(self) -> typing.Optional[builtins.str]:
        '''secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#secretFile
        '''
        result = self._values.get("secret_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty.

        More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CephFsPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CephFsVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "monitors": "monitors",
        "path": "path",
        "read_only": "readOnly",
        "secret_file": "secretFile",
        "secret_ref": "secretRef",
        "user": "user",
    },
)
class CephFsVolumeSource:
    def __init__(
        self,
        *,
        monitors: typing.Sequence[builtins.str],
        path: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_file: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.

        :param monitors: monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
        :param path: path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /.
        :param read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param secret_file: secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
        :param secret_ref: secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param user: user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59d86721b5dc6bbcaa4e6cf386e9bef60ab51ef1c7642170ee7470fad810cb00)
            check_type(argname="argument monitors", value=monitors, expected_type=type_hints["monitors"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_file", value=secret_file, expected_type=type_hints["secret_file"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "monitors": monitors,
        }
        if path is not None:
            self._values["path"] = path
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_file is not None:
            self._values["secret_file"] = secret_file
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def monitors(self) -> typing.List[builtins.str]:
        '''monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#monitors
        '''
        result = self._values.get("monitors")
        assert result is not None, "Required property 'monitors' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_file(self) -> typing.Optional[builtins.str]:
        '''secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#secretFile
        '''
        result = self._values.get("secret_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty.

        More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.

        :schema: io.k8s.api.core.v1.CephFSVolumeSource#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CephFsVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CertificateSigningRequestSpec",
    jsii_struct_bases=[],
    name_mapping={
        "request": "request",
        "signer_name": "signerName",
        "expiration_seconds": "expirationSeconds",
        "extra": "extra",
        "groups": "groups",
        "uid": "uid",
        "usages": "usages",
        "username": "username",
    },
)
class CertificateSigningRequestSpec:
    def __init__(
        self,
        *,
        request: builtins.str,
        signer_name: builtins.str,
        expiration_seconds: typing.Optional[jsii.Number] = None,
        extra: typing.Optional[typing.Mapping[builtins.str, typing.Sequence[builtins.str]]] = None,
        groups: typing.Optional[typing.Sequence[builtins.str]] = None,
        uid: typing.Optional[builtins.str] = None,
        usages: typing.Optional[typing.Sequence[builtins.str]] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CertificateSigningRequestSpec contains the certificate request.

        :param request: request contains an x509 certificate signing request encoded in a "CERTIFICATE REQUEST" PEM block. When serialized as JSON or YAML, the data is additionally base64-encoded.
        :param signer_name: signerName indicates the requested signer, and is a qualified name. List/watch requests for CertificateSigningRequests can filter on this field using a "spec.signerName=NAME" fieldSelector. Well-known Kubernetes signers are: 1. "kubernetes.io/kube-apiserver-client": issues client certificates that can be used to authenticate to kube-apiserver. Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the "csrsigning" controller in kube-controller-manager. 2. "kubernetes.io/kube-apiserver-client-kubelet": issues client certificates that kubelets use to authenticate to kube-apiserver. Requests for this signer can be auto-approved by the "csrapproving" controller in kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager. 3. "kubernetes.io/kubelet-serving" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely. Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager. More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers Custom signerNames can also be specified. The signer defines: 1. Trust distribution: how trust (CA bundles) are distributed. 2. Permitted subjects: and behavior when a disallowed subject is requested. 3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested. 4. Required, permitted, or forbidden key usages / extended key usages. 5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin. 6. Whether or not requests for CA certificates are allowed.
        :param expiration_seconds: expirationSeconds is the requested duration of validity of the issued certificate. The certificate signer may issue a certificate with a different validity duration so a client must check the delta between the notBefore and and notAfter fields in the issued certificate to determine the actual duration. The v1.22+ in-tree implementations of the well-known Kubernetes signers will honor this field as long as the requested duration is not greater than the maximum duration they will honor per the --cluster-signing-duration CLI flag to the Kubernetes controller manager. Certificate signers may not honor this field for various reasons: 1. Old signer that is unaware of the field (such as the in-tree implementations prior to v1.22) 2. Signer whose configured maximum is shorter than the requested duration 3. Signer whose configured minimum is longer than the requested duration The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.
        :param extra: extra contains extra attributes of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
        :param groups: groups contains group membership of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
        :param uid: uid contains the uid of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.
        :param usages: usages specifies a set of key usages requested in the issued certificate. Requests for TLS client certificates typically request: "digital signature", "key encipherment", "client auth". Requests for TLS serving certificates typically request: "key encipherment", "digital signature", "server auth". Valid values are: "signing", "digital signature", "content commitment", "key encipherment", "key agreement", "data encipherment", "cert sign", "crl sign", "encipher only", "decipher only", "any", "server auth", "client auth", "code signing", "email protection", "s/mime", "ipsec end system", "ipsec tunnel", "ipsec user", "timestamping", "ocsp signing", "microsoft sgc", "netscape sgc"
        :param username: username contains the name of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__929229a83de215ebaa5cb794da695adc47e7c12ea06895fb134e2002e4819e4a)
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
            check_type(argname="argument signer_name", value=signer_name, expected_type=type_hints["signer_name"])
            check_type(argname="argument expiration_seconds", value=expiration_seconds, expected_type=type_hints["expiration_seconds"])
            check_type(argname="argument extra", value=extra, expected_type=type_hints["extra"])
            check_type(argname="argument groups", value=groups, expected_type=type_hints["groups"])
            check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
            check_type(argname="argument usages", value=usages, expected_type=type_hints["usages"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "request": request,
            "signer_name": signer_name,
        }
        if expiration_seconds is not None:
            self._values["expiration_seconds"] = expiration_seconds
        if extra is not None:
            self._values["extra"] = extra
        if groups is not None:
            self._values["groups"] = groups
        if uid is not None:
            self._values["uid"] = uid
        if usages is not None:
            self._values["usages"] = usages
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def request(self) -> builtins.str:
        '''request contains an x509 certificate signing request encoded in a "CERTIFICATE REQUEST" PEM block.

        When serialized as JSON or YAML, the data is additionally base64-encoded.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#request
        '''
        result = self._values.get("request")
        assert result is not None, "Required property 'request' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def signer_name(self) -> builtins.str:
        '''signerName indicates the requested signer, and is a qualified name.

        List/watch requests for CertificateSigningRequests can filter on this field using a "spec.signerName=NAME" fieldSelector.

        Well-known Kubernetes signers are:

        1. "kubernetes.io/kube-apiserver-client": issues client certificates that can be used to authenticate to kube-apiserver.
           Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the "csrsigning" controller in kube-controller-manager.
        2. "kubernetes.io/kube-apiserver-client-kubelet": issues client certificates that kubelets use to authenticate to kube-apiserver.
           Requests for this signer can be auto-approved by the "csrapproving" controller in kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.
        3. "kubernetes.io/kubelet-serving" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.
           Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.

        More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers

        Custom signerNames can also be specified. The signer defines:

        1. Trust distribution: how trust (CA bundles) are distributed.
        2. Permitted subjects: and behavior when a disallowed subject is requested.
        3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.
        4. Required, permitted, or forbidden key usages / extended key usages.
        5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.
        6. Whether or not requests for CA certificates are allowed.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#signerName
        '''
        result = self._values.get("signer_name")
        assert result is not None, "Required property 'signer_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def expiration_seconds(self) -> typing.Optional[jsii.Number]:
        '''expirationSeconds is the requested duration of validity of the issued certificate.

        The certificate signer may issue a certificate with a different validity duration so a client must check the delta between the notBefore and and notAfter fields in the issued certificate to determine the actual duration.

        The v1.22+ in-tree implementations of the well-known Kubernetes signers will honor this field as long as the requested duration is not greater than the maximum duration they will honor per the --cluster-signing-duration CLI flag to the Kubernetes controller manager.

        Certificate signers may not honor this field for various reasons:

        1. Old signer that is unaware of the field (such as the in-tree
           implementations prior to v1.22)
        2. Signer whose configured maximum is shorter than the requested duration
        3. Signer whose configured minimum is longer than the requested duration

        The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#expirationSeconds
        '''
        result = self._values.get("expiration_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def extra(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.List[builtins.str]]]:
        '''extra contains extra attributes of the user that created the CertificateSigningRequest.

        Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#extra
        '''
        result = self._values.get("extra")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.List[builtins.str]]], result)

    @builtins.property
    def groups(self) -> typing.Optional[typing.List[builtins.str]]:
        '''groups contains group membership of the user that created the CertificateSigningRequest.

        Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#groups
        '''
        result = self._values.get("groups")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def uid(self) -> typing.Optional[builtins.str]:
        '''uid contains the uid of the user that created the CertificateSigningRequest.

        Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#uid
        '''
        result = self._values.get("uid")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def usages(self) -> typing.Optional[typing.List[builtins.str]]:
        '''usages specifies a set of key usages requested in the issued certificate.

        Requests for TLS client certificates typically request: "digital signature", "key encipherment", "client auth".

        Requests for TLS serving certificates typically request: "key encipherment", "digital signature", "server auth".

        Valid values are:
        "signing", "digital signature", "content commitment",
        "key encipherment", "key agreement", "data encipherment",
        "cert sign", "crl sign", "encipher only", "decipher only", "any",
        "server auth", "client auth",
        "code signing", "email protection", "s/mime",
        "ipsec end system", "ipsec tunnel", "ipsec user",
        "timestamping", "ocsp signing", "microsoft sgc", "netscape sgc"

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#usages
        '''
        result = self._values.get("usages")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''username contains the name of the user that created the CertificateSigningRequest.

        Populated by the API server on creation and immutable.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestSpec#username
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CertificateSigningRequestSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CinderPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class CinderPersistentVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Represents a cinder volume resource in Openstack.

        A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.

        :param volume_id: volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param fs_type: fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param secret_ref: secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5a27e9cb2637e2a47c760b95775415a1d5a23905fb079b844020822e35e0e86)
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''volumeID used to identify the volume in cinder.

        More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.

        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CinderPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CinderVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class CinderVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Represents a cinder volume resource in Openstack.

        A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.

        :param volume_id: volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param secret_ref: secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.

        :schema: io.k8s.api.core.v1.CinderVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6cb8f1a6fcc05feae5ce36735b58d393ef1b0c3ac07acf8b73b35427d21e048b)
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''volumeID used to identify the volume in cinder.

        More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md

        :schema: io.k8s.api.core.v1.CinderVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.

        :schema: io.k8s.api.core.v1.CinderVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CinderVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ClaimSource",
    jsii_struct_bases=[],
    name_mapping={
        "resource_claim_name": "resourceClaimName",
        "resource_claim_template_name": "resourceClaimTemplateName",
    },
)
class ClaimSource:
    def __init__(
        self,
        *,
        resource_claim_name: typing.Optional[builtins.str] = None,
        resource_claim_template_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''ClaimSource describes a reference to a ResourceClaim.

        Exactly one of these fields should be set.  Consumers of this type must treat an empty object as if it has an unknown value.

        :param resource_claim_name: ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
        :param resource_claim_template_name: ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod. The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses. This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.

        :schema: io.k8s.api.core.v1.ClaimSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60c037dfa94456b9d49ce4e9b3e305dd632426cbbda41464c4845a61cd75bd4d)
            check_type(argname="argument resource_claim_name", value=resource_claim_name, expected_type=type_hints["resource_claim_name"])
            check_type(argname="argument resource_claim_template_name", value=resource_claim_template_name, expected_type=type_hints["resource_claim_template_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if resource_claim_name is not None:
            self._values["resource_claim_name"] = resource_claim_name
        if resource_claim_template_name is not None:
            self._values["resource_claim_template_name"] = resource_claim_template_name

    @builtins.property
    def resource_claim_name(self) -> typing.Optional[builtins.str]:
        '''ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.

        :schema: io.k8s.api.core.v1.ClaimSource#resourceClaimName
        '''
        result = self._values.get("resource_claim_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def resource_claim_template_name(self) -> typing.Optional[builtins.str]:
        '''ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.

        The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.

        This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.

        :schema: io.k8s.api.core.v1.ClaimSource#resourceClaimTemplateName
        '''
        result = self._values.get("resource_claim_template_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClaimSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ClientIpConfig",
    jsii_struct_bases=[],
    name_mapping={"timeout_seconds": "timeoutSeconds"},
)
class ClientIpConfig:
    def __init__(self, *, timeout_seconds: typing.Optional[jsii.Number] = None) -> None:
        '''ClientIPConfig represents the configurations of Client IP based session affinity.

        :param timeout_seconds: timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).

        :schema: io.k8s.api.core.v1.ClientIPConfig
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b469872498df5c93ae9c2491849c58a0cd770a84e449755505c075905c868d9)
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[jsii.Number]:
        '''timeoutSeconds specifies the seconds of ClientIP type session sticky time.

        The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).

        :schema: io.k8s.api.core.v1.ClientIPConfig#timeoutSeconds
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClientIpConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ClusterCidrSpecV1Alpha1",
    jsii_struct_bases=[],
    name_mapping={
        "per_node_host_bits": "perNodeHostBits",
        "ipv4": "ipv4",
        "ipv6": "ipv6",
        "node_selector": "nodeSelector",
    },
)
class ClusterCidrSpecV1Alpha1:
    def __init__(
        self,
        *,
        per_node_host_bits: jsii.Number,
        ipv4: typing.Optional[builtins.str] = None,
        ipv6: typing.Optional[builtins.str] = None,
        node_selector: typing.Optional[typing.Union["NodeSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterCIDRSpec defines the desired state of ClusterCIDR.

        :param per_node_host_bits: perNodeHostBits defines the number of host bits to be configured per node. A subnet mask determines how much of the address is used for network bits and host bits. For example an IPv4 address of 192.168.0.0/24, splits the address into 24 bits for the network portion and 8 bits for the host portion. To allocate 256 IPs, set this field to 8 (a /24 mask for IPv4 or a /120 for IPv6). Minimum value is 4 (16 IPs). This field is immutable.
        :param ipv4: ipv4 defines an IPv4 IP block in CIDR notation(e.g. "10.0.0.0/8"). At least one of ipv4 and ipv6 must be specified. This field is immutable.
        :param ipv6: ipv6 defines an IPv6 IP block in CIDR notation(e.g. "2001:db8::/64"). At least one of ipv4 and ipv6 must be specified. This field is immutable.
        :param node_selector: nodeSelector defines which nodes the config is applicable to. An empty or nil nodeSelector selects all nodes. This field is immutable.

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec
        '''
        if isinstance(node_selector, dict):
            node_selector = NodeSelector(**node_selector)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41681efe228135cb3904d30d3abec7f6c6e60a74a00c0af10529a030a168eb39)
            check_type(argname="argument per_node_host_bits", value=per_node_host_bits, expected_type=type_hints["per_node_host_bits"])
            check_type(argname="argument ipv4", value=ipv4, expected_type=type_hints["ipv4"])
            check_type(argname="argument ipv6", value=ipv6, expected_type=type_hints["ipv6"])
            check_type(argname="argument node_selector", value=node_selector, expected_type=type_hints["node_selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "per_node_host_bits": per_node_host_bits,
        }
        if ipv4 is not None:
            self._values["ipv4"] = ipv4
        if ipv6 is not None:
            self._values["ipv6"] = ipv6
        if node_selector is not None:
            self._values["node_selector"] = node_selector

    @builtins.property
    def per_node_host_bits(self) -> jsii.Number:
        '''perNodeHostBits defines the number of host bits to be configured per node.

        A subnet mask determines how much of the address is used for network bits and host bits. For example an IPv4 address of 192.168.0.0/24, splits the address into 24 bits for the network portion and 8 bits for the host portion. To allocate 256 IPs, set this field to 8 (a /24 mask for IPv4 or a /120 for IPv6). Minimum value is 4 (16 IPs). This field is immutable.

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec#perNodeHostBits
        '''
        result = self._values.get("per_node_host_bits")
        assert result is not None, "Required property 'per_node_host_bits' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def ipv4(self) -> typing.Optional[builtins.str]:
        '''ipv4 defines an IPv4 IP block in CIDR notation(e.g. "10.0.0.0/8"). At least one of ipv4 and ipv6 must be specified. This field is immutable.

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec#ipv4
        '''
        result = self._values.get("ipv4")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ipv6(self) -> typing.Optional[builtins.str]:
        '''ipv6 defines an IPv6 IP block in CIDR notation(e.g. "2001:db8::/64"). At least one of ipv4 and ipv6 must be specified. This field is immutable.

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec#ipv6
        '''
        result = self._values.get("ipv6")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_selector(self) -> typing.Optional["NodeSelector"]:
        '''nodeSelector defines which nodes the config is applicable to.

        An empty or nil nodeSelector selects all nodes. This field is immutable.

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec#nodeSelector
        '''
        result = self._values.get("node_selector")
        return typing.cast(typing.Optional["NodeSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterCidrSpecV1Alpha1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ClusterTrustBundleSpecV1Alpha1",
    jsii_struct_bases=[],
    name_mapping={"trust_bundle": "trustBundle", "signer_name": "signerName"},
)
class ClusterTrustBundleSpecV1Alpha1:
    def __init__(
        self,
        *,
        trust_bundle: builtins.str,
        signer_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''ClusterTrustBundleSpec contains the signer and trust anchors.

        :param trust_bundle: trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates. The data must consist only of PEM certificate blocks that parse as valid X.509 certificates. Each certificate must include a basic constraints extension with the CA bit set. The API server will reject objects that contain duplicate certificates, or that use PEM block headers. Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        :param signer_name: signerName indicates the associated signer, if any. In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName= verb=attest. If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name ``example.com/foo``, valid ClusterTrustBundle object names include ``example.com:foo:abc`` and ``example.com:foo:v1``. If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix. List/watch requests for ClusterTrustBundles can filter on this field using a ``spec.signerName=NAME`` field selector.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b9b8d6631cd5384ab683184cd81c4e9ab11f91a0352e0470bfb32a123e3eb24)
            check_type(argname="argument trust_bundle", value=trust_bundle, expected_type=type_hints["trust_bundle"])
            check_type(argname="argument signer_name", value=signer_name, expected_type=type_hints["signer_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "trust_bundle": trust_bundle,
        }
        if signer_name is not None:
            self._values["signer_name"] = signer_name

    @builtins.property
    def trust_bundle(self) -> builtins.str:
        '''trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.

        The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.

        Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec#trustBundle
        '''
        result = self._values.get("trust_bundle")
        assert result is not None, "Required property 'trust_bundle' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def signer_name(self) -> typing.Optional[builtins.str]:
        '''signerName indicates the associated signer, if any.

        In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName= verb=attest.

        If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name ``example.com/foo``, valid ClusterTrustBundle object names include ``example.com:foo:abc`` and ``example.com:foo:v1``.

        If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.

        List/watch requests for ClusterTrustBundles can filter on this field using a ``spec.signerName=NAME`` field selector.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec#signerName
        '''
        result = self._values.get("signer_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterTrustBundleSpecV1Alpha1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ComponentCondition",
    jsii_struct_bases=[],
    name_mapping={
        "status": "status",
        "type": "type",
        "error": "error",
        "message": "message",
    },
)
class ComponentCondition:
    def __init__(
        self,
        *,
        status: builtins.str,
        type: builtins.str,
        error: typing.Optional[builtins.str] = None,
        message: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Information about the condition of a component.

        :param status: Status of the condition for a component. Valid values for "Healthy": "True", "False", or "Unknown".
        :param type: Type of condition for a component. Valid value: "Healthy"
        :param error: Condition error code for a component. For example, a health check error code.
        :param message: Message about the condition for a component. For example, information about a health check.

        :schema: io.k8s.api.core.v1.ComponentCondition
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f05ebd434dae89bff3cbc6ec7b1dd14f30d782541c114b065c158c92469f409c)
            check_type(argname="argument status", value=status, expected_type=type_hints["status"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument error", value=error, expected_type=type_hints["error"])
            check_type(argname="argument message", value=message, expected_type=type_hints["message"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "status": status,
            "type": type,
        }
        if error is not None:
            self._values["error"] = error
        if message is not None:
            self._values["message"] = message

    @builtins.property
    def status(self) -> builtins.str:
        '''Status of the condition for a component.

        Valid values for "Healthy": "True", "False", or "Unknown".

        :schema: io.k8s.api.core.v1.ComponentCondition#status
        '''
        result = self._values.get("status")
        assert result is not None, "Required property 'status' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''Type of condition for a component.

        Valid value: "Healthy"

        :schema: io.k8s.api.core.v1.ComponentCondition#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def error(self) -> typing.Optional[builtins.str]:
        '''Condition error code for a component.

        For example, a health check error code.

        :schema: io.k8s.api.core.v1.ComponentCondition#error
        '''
        result = self._values.get("error")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def message(self) -> typing.Optional[builtins.str]:
        '''Message about the condition for a component.

        For example, information about a health check.

        :schema: io.k8s.api.core.v1.ComponentCondition#message
        '''
        result = self._values.get("message")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ComponentCondition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ConfigMapEnvSource",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "optional": "optional"},
)
class ConfigMapEnvSource:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.

        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: Specify whether the ConfigMap must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapEnvSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20fe6fcb43972704625f52f6df9a3ab57bb76552180ba90f57553517866440c9)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.core.v1.ConfigMapEnvSource#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapEnvSource#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapEnvSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ConfigMapKeySelector",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "name": "name", "optional": "optional"},
)
class ConfigMapKeySelector:
    def __init__(
        self,
        *,
        key: builtins.str,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Selects a key from a ConfigMap.

        :param key: The key to select.
        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: Specify whether the ConfigMap or its key must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapKeySelector
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ed7b6d36e94ba69d2182029277d87a12af8911f3ba9b766b90022f8b11a2e2a)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
        }
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def key(self) -> builtins.str:
        '''The key to select.

        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap or its key must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapKeySelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ConfigMapNodeConfigSource",
    jsii_struct_bases=[],
    name_mapping={
        "kubelet_config_key": "kubeletConfigKey",
        "name": "name",
        "namespace": "namespace",
        "resource_version": "resourceVersion",
        "uid": "uid",
    },
)
class ConfigMapNodeConfigSource:
    def __init__(
        self,
        *,
        kubelet_config_key: builtins.str,
        name: builtins.str,
        namespace: builtins.str,
        resource_version: typing.Optional[builtins.str] = None,
        uid: typing.Optional[builtins.str] = None,
    ) -> None:
        '''ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.

        This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration

        :param kubelet_config_key: KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        :param name: Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        :param namespace: Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        :param resource_version: ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        :param uid: UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__086cfe1a86b21170c77a74d982a1d6b0b9d7bfd99ab50e679ded81b7f81abe0b)
            check_type(argname="argument kubelet_config_key", value=kubelet_config_key, expected_type=type_hints["kubelet_config_key"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument resource_version", value=resource_version, expected_type=type_hints["resource_version"])
            check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kubelet_config_key": kubelet_config_key,
            "name": name,
            "namespace": namespace,
        }
        if resource_version is not None:
            self._values["resource_version"] = resource_version
        if uid is not None:
            self._values["uid"] = uid

    @builtins.property
    def kubelet_config_key(self) -> builtins.str:
        '''KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#kubeletConfigKey
        '''
        result = self._values.get("kubelet_config_key")
        assert result is not None, "Required property 'kubelet_config_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#namespace
        '''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_version(self) -> typing.Optional[builtins.str]:
        '''ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#resourceVersion
        '''
        result = self._values.get("resource_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def uid(self) -> typing.Optional[builtins.str]:
        '''UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#uid
        '''
        result = self._values.get("uid")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapNodeConfigSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ConfigMapProjection",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "name": "name", "optional": "optional"},
)
class ConfigMapProjection:
    def __init__(
        self,
        *,
        items: typing.Optional[typing.Sequence[typing.Union["KeyToPath", typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Adapts a ConfigMap into a projected volume.

        The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.

        :param items: items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: optional specify whether the ConfigMap or its keys must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapProjection
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f4a44f810591999366c95f023e0831c55c8f25b0a5c9c0fd3c51f004fa13c99)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def items(self) -> typing.Optional[typing.List["KeyToPath"]]:
        '''items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.

        :schema: io.k8s.api.core.v1.ConfigMapProjection#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["KeyToPath"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.core.v1.ConfigMapProjection#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''optional specify whether the ConfigMap or its keys must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapProjection#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapProjection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ConfigMapVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class ConfigMapVolumeSource:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Sequence[typing.Union["KeyToPath", typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Adapts a ConfigMap into a volume.

        The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.

        :param default_mode: defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: optional specify whether the ConfigMap or its keys must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b32c4966315670224d268435ad429067534697727807a4de6f85b6cd3a50802)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''defaultMode is optional: mode bits used to set permissions on created files by default.

        Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#defaultMode
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.List["KeyToPath"]]:
        '''items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["KeyToPath"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''optional specify whether the ConfigMap or its keys must be defined.

        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.Container",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "args": "args",
        "command": "command",
        "env": "env",
        "env_from": "envFrom",
        "image": "image",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness_probe": "livenessProbe",
        "ports": "ports",
        "readiness_probe": "readinessProbe",
        "resize_policy": "resizePolicy",
        "resources": "resources",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "startup_probe": "startupProbe",
        "stdin": "stdin",
        "stdin_once": "stdinOnce",
        "termination_message_path": "terminationMessagePath",
        "termination_message_policy": "terminationMessagePolicy",
        "tty": "tty",
        "volume_devices": "volumeDevices",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class Container:
    def __init__(
        self,
        *,
        name: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env: typing.Optional[typing.Sequence[typing.Union["EnvVar", typing.Dict[builtins.str, typing.Any]]]] = None,
        env_from: typing.Optional[typing.Sequence[typing.Union["EnvFromSource", typing.Dict[builtins.str, typing.Any]]]] = None,
        image: typing.Optional[builtins.str] = None,
        image_pull_policy: typing.Optional[builtins.str] = None,
        lifecycle: typing.Optional[typing.Union["Lifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        liveness_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ContainerPort", typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        resize_policy: typing.Optional[typing.Sequence[typing.Union["ContainerResizePolicy", typing.Dict[builtins.str, typing.Any]]]] = None,
        resources: typing.Optional[typing.Union["ResourceRequirements", typing.Dict[builtins.str, typing.Any]]] = None,
        restart_policy: typing.Optional[builtins.str] = None,
        security_context: typing.Optional[typing.Union["SecurityContext", typing.Dict[builtins.str, typing.Any]]] = None,
        startup_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        stdin: typing.Optional[builtins.bool] = None,
        stdin_once: typing.Optional[builtins.bool] = None,
        termination_message_path: typing.Optional[builtins.str] = None,
        termination_message_policy: typing.Optional[builtins.str] = None,
        tty: typing.Optional[builtins.bool] = None,
        volume_devices: typing.Optional[typing.Sequence[typing.Union["VolumeDevice", typing.Dict[builtins.str, typing.Any]]]] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''A single application container that you want to run within a pod.

        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        :param args: Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param command: Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param env: List of environment variables to set in the container. Cannot be updated.
        :param env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param image: Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        :param image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images Default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param lifecycle: Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        :param liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param ports: List of ports to expose from the container. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.
        :param readiness_probe: Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param resize_policy: Resources resize policy for the container.
        :param resources: Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        :param restart_policy: RestartPolicy defines the restart behavior of individual containers in a pod. This field may only be set for init containers, and the only allowed value is "Always". For non-init containers or when this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Setting the RestartPolicy as "Always" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy "Always" will be shut down. This lifecycle differs from normal init containers and is often referred to as a "sidecar" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        :param startup_probe: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. Default: false.
        :param stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false Default: false
        :param termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. Default: dev/termination-log. Cannot be updated.
        :param termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. Default: File. Cannot be updated.
        :param tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. Default: false.
        :param volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container
        '''
        if isinstance(lifecycle, dict):
            lifecycle = Lifecycle(**lifecycle)
        if isinstance(liveness_probe, dict):
            liveness_probe = Probe(**liveness_probe)
        if isinstance(readiness_probe, dict):
            readiness_probe = Probe(**readiness_probe)
        if isinstance(resources, dict):
            resources = ResourceRequirements(**resources)
        if isinstance(security_context, dict):
            security_context = SecurityContext(**security_context)
        if isinstance(startup_probe, dict):
            startup_probe = Probe(**startup_probe)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__10e677cf7b1109580843c114822e64cc3f92eb97075167cf73be4bffae9250ad)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness_probe", value=liveness_probe, expected_type=type_hints["liveness_probe"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness_probe", value=readiness_probe, expected_type=type_hints["readiness_probe"])
            check_type(argname="argument resize_policy", value=resize_policy, expected_type=type_hints["resize_policy"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup_probe", value=startup_probe, expected_type=type_hints["startup_probe"])
            check_type(argname="argument stdin", value=stdin, expected_type=type_hints["stdin"])
            check_type(argname="argument stdin_once", value=stdin_once, expected_type=type_hints["stdin_once"])
            check_type(argname="argument termination_message_path", value=termination_message_path, expected_type=type_hints["termination_message_path"])
            check_type(argname="argument termination_message_policy", value=termination_message_policy, expected_type=type_hints["termination_message_policy"])
            check_type(argname="argument tty", value=tty, expected_type=type_hints["tty"])
            check_type(argname="argument volume_devices", value=volume_devices, expected_type=type_hints["volume_devices"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env is not None:
            self._values["env"] = env
        if env_from is not None:
            self._values["env_from"] = env_from
        if image is not None:
            self._values["image"] = image
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness_probe is not None:
            self._values["liveness_probe"] = liveness_probe
        if ports is not None:
            self._values["ports"] = ports
        if readiness_probe is not None:
            self._values["readiness_probe"] = readiness_probe
        if resize_policy is not None:
            self._values["resize_policy"] = resize_policy
        if resources is not None:
            self._values["resources"] = resources
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup_probe is not None:
            self._values["startup_probe"] = startup_probe
        if stdin is not None:
            self._values["stdin"] = stdin
        if stdin_once is not None:
            self._values["stdin_once"] = stdin_once
        if termination_message_path is not None:
            self._values["termination_message_path"] = termination_message_path
        if termination_message_policy is not None:
            self._values["termination_message_policy"] = termination_message_policy
        if tty is not None:
            self._values["tty"] = tty
        if volume_devices is not None:
            self._values["volume_devices"] = volume_devices
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the container specified as a DNS_LABEL.

        Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint.

        The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :schema: io.k8s.api.core.v1.Container#args
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :schema: io.k8s.api.core.v1.Container#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env(self) -> typing.Optional[typing.List["EnvVar"]]:
        '''List of environment variables to set in the container.

        Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#env
        '''
        result = self._values.get("env")
        return typing.cast(typing.Optional[typing.List["EnvVar"]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["EnvFromSource"]]:
        '''List of sources to populate environment variables in the container.

        The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#envFrom
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["EnvFromSource"]], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''Container image name.

        More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.

        :schema: io.k8s.api.core.v1.Container#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional[builtins.str]:
        '''Image pull policy.

        One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :schema: io.k8s.api.core.v1.Container#imagePullPolicy
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional["Lifecycle"]:
        '''Actions that the management system should take in response to container lifecycle events.

        Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#lifecycle
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional["Lifecycle"], result)

    @builtins.property
    def liveness_probe(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container liveness.

        Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes

        :schema: io.k8s.api.core.v1.Container#livenessProbe
        '''
        result = self._values.get("liveness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["ContainerPort"]]:
        '''List of ports to expose from the container.

        Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["ContainerPort"]], result)

    @builtins.property
    def readiness_probe(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container service readiness.

        Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes

        :schema: io.k8s.api.core.v1.Container#readinessProbe
        '''
        result = self._values.get("readiness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resize_policy(self) -> typing.Optional[typing.List["ContainerResizePolicy"]]:
        '''Resources resize policy for the container.

        :schema: io.k8s.api.core.v1.Container#resizePolicy
        '''
        result = self._values.get("resize_policy")
        return typing.cast(typing.Optional[typing.List["ContainerResizePolicy"]], result)

    @builtins.property
    def resources(self) -> typing.Optional["ResourceRequirements"]:
        '''Compute Resources required by this container.

        Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/

        :schema: io.k8s.api.core.v1.Container#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ResourceRequirements"], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[builtins.str]:
        '''RestartPolicy defines the restart behavior of individual containers in a pod.

        This field may only be set for init containers, and the only allowed value is "Always". For non-init containers or when this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Setting the RestartPolicy as "Always" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy "Always" will be shut down. This lifecycle differs from normal init containers and is often referred to as a "sidecar" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.

        :schema: io.k8s.api.core.v1.Container#restartPolicy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def security_context(self) -> typing.Optional["SecurityContext"]:
        '''SecurityContext defines the security options the container should be run with.

        If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/

        :schema: io.k8s.api.core.v1.Container#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["SecurityContext"], result)

    @builtins.property
    def startup_probe(self) -> typing.Optional["Probe"]:
        '''StartupProbe indicates that the Pod has successfully initialized.

        If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes

        :schema: io.k8s.api.core.v1.Container#startupProbe
        '''
        result = self._values.get("startup_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def stdin(self) -> typing.Optional[builtins.bool]:
        '''Whether this container should allocate a buffer for stdin in the container runtime.

        If this is not set, reads from stdin in the container will always result in EOF. Default is false.

        :default: false.

        :schema: io.k8s.api.core.v1.Container#stdin
        '''
        result = self._values.get("stdin")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def stdin_once(self) -> typing.Optional[builtins.bool]:
        '''Whether the container runtime should close the stdin channel after it has been opened by a single attach.

        When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false

        :default: false

        :schema: io.k8s.api.core.v1.Container#stdinOnce
        '''
        result = self._values.get("stdin_once")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def termination_message_path(self) -> typing.Optional[builtins.str]:
        '''Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem.

        Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.

        :default: dev/termination-log. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#terminationMessagePath
        '''
        result = self._values.get("termination_message_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def termination_message_policy(self) -> typing.Optional[builtins.str]:
        '''Indicate how the termination message should be populated.

        File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.

        :default: File. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#terminationMessagePolicy
        '''
        result = self._values.get("termination_message_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tty(self) -> typing.Optional[builtins.bool]:
        '''Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.

        Default is false.

        :default: false.

        :schema: io.k8s.api.core.v1.Container#tty
        '''
        result = self._values.get("tty")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_devices(self) -> typing.Optional[typing.List["VolumeDevice"]]:
        '''volumeDevices is the list of block devices to be used by the container.

        :schema: io.k8s.api.core.v1.Container#volumeDevices
        '''
        result = self._values.get("volume_devices")
        return typing.cast(typing.Optional[typing.List["VolumeDevice"]], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#volumeMounts
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :schema: io.k8s.api.core.v1.Container#workingDir
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Container(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ContainerPort",
    jsii_struct_bases=[],
    name_mapping={
        "container_port": "containerPort",
        "host_ip": "hostIp",
        "host_port": "hostPort",
        "name": "name",
        "protocol": "protocol",
    },
)
class ContainerPort:
    def __init__(
        self,
        *,
        container_port: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional[builtins.str] = None,
    ) -> None:
        '''ContainerPort represents a network port in a single container.

        :param container_port: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: What host IP to bind the external port to.
        :param host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        :param name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        :param protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: TCP".

        :schema: io.k8s.api.core.v1.ContainerPort
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__44076f5a646c5114557ddf1959842d1f74d999d69d7afb4d7acfdb1f58aa5bc6)
            check_type(argname="argument container_port", value=container_port, expected_type=type_hints["container_port"])
            check_type(argname="argument host_ip", value=host_ip, expected_type=type_hints["host_ip"])
            check_type(argname="argument host_port", value=host_port, expected_type=type_hints["host_port"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container_port": container_port,
        }
        if host_ip is not None:
            self._values["host_ip"] = host_ip
        if host_port is not None:
            self._values["host_port"] = host_port
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def container_port(self) -> jsii.Number:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.

        :schema: io.k8s.api.core.v1.ContainerPort#containerPort
        '''
        result = self._values.get("container_port")
        assert result is not None, "Required property 'container_port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def host_ip(self) -> typing.Optional[builtins.str]:
        '''What host IP to bind the external port to.

        :schema: io.k8s.api.core.v1.ContainerPort#hostIP
        '''
        result = self._values.get("host_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host_port(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the host.

        If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.

        :schema: io.k8s.api.core.v1.ContainerPort#hostPort
        '''
        result = self._values.get("host_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''If specified, this must be an IANA_SVC_NAME and unique within the pod.

        Each named port in a pod must have a unique name. Name for the port that can be referred to by services.

        :schema: io.k8s.api.core.v1.ContainerPort#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional[builtins.str]:
        '''Protocol for port.

        Must be UDP, TCP, or SCTP. Defaults to "TCP".

        :default: TCP".

        :schema: io.k8s.api.core.v1.ContainerPort#protocol
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ContainerResizePolicy",
    jsii_struct_bases=[],
    name_mapping={"resource_name": "resourceName", "restart_policy": "restartPolicy"},
)
class ContainerResizePolicy:
    def __init__(
        self,
        *,
        resource_name: builtins.str,
        restart_policy: builtins.str,
    ) -> None:
        '''ContainerResizePolicy represents resource resize policy for the container.

        :param resource_name: Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
        :param restart_policy: Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.

        :schema: io.k8s.api.core.v1.ContainerResizePolicy
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a20071b550054a8c325f7961b3b3dad6c4696c65723da481dd7283fb0657c9f)
            check_type(argname="argument resource_name", value=resource_name, expected_type=type_hints["resource_name"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "resource_name": resource_name,
            "restart_policy": restart_policy,
        }

    @builtins.property
    def resource_name(self) -> builtins.str:
        '''Name of the resource to which this resource resize policy applies.

        Supported values: cpu, memory.

        :schema: io.k8s.api.core.v1.ContainerResizePolicy#resourceName
        '''
        result = self._values.get("resource_name")
        assert result is not None, "Required property 'resource_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def restart_policy(self) -> builtins.str:
        '''Restart policy to apply when specified resource is resized.

        If not specified, it defaults to NotRequired.

        :schema: io.k8s.api.core.v1.ContainerResizePolicy#restartPolicy
        '''
        result = self._values.get("restart_policy")
        assert result is not None, "Required property 'restart_policy' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerResizePolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ContainerResourceMetricSourceV2",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "name": "name", "target": "target"},
)
class ContainerResourceMetricSourceV2:
    def __init__(
        self,
        *,
        container: builtins.str,
        name: builtins.str,
        target: typing.Union["MetricTargetV2", typing.Dict[builtins.str, typing.Any]],
    ) -> None:
        '''ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.

        :param container: container is the name of the container in the pods of the scaling target.
        :param name: name is the name of the resource in question.
        :param target: target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource
        '''
        if isinstance(target, dict):
            target = MetricTargetV2(**target)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99e1dbb836fc8328768db5714575cedad5695fd7d1097dc1aa638902eb87e438)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
            "name": name,
            "target": target,
        }

    @builtins.property
    def container(self) -> builtins.str:
        '''container is the name of the container in the pods of the scaling target.

        :schema: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource#container
        '''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the name of the resource in question.

        :schema: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> "MetricTargetV2":
        '''target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTargetV2", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerResourceMetricSourceV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CronJobSpec",
    jsii_struct_bases=[],
    name_mapping={
        "job_template": "jobTemplate",
        "schedule": "schedule",
        "concurrency_policy": "concurrencyPolicy",
        "failed_jobs_history_limit": "failedJobsHistoryLimit",
        "starting_deadline_seconds": "startingDeadlineSeconds",
        "successful_jobs_history_limit": "successfulJobsHistoryLimit",
        "suspend": "suspend",
        "time_zone": "timeZone",
    },
)
class CronJobSpec:
    def __init__(
        self,
        *,
        job_template: typing.Union["JobTemplateSpec", typing.Dict[builtins.str, typing.Any]],
        schedule: builtins.str,
        concurrency_policy: typing.Optional[builtins.str] = None,
        failed_jobs_history_limit: typing.Optional[jsii.Number] = None,
        starting_deadline_seconds: typing.Optional[jsii.Number] = None,
        successful_jobs_history_limit: typing.Optional[jsii.Number] = None,
        suspend: typing.Optional[builtins.bool] = None,
        time_zone: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CronJobSpec describes how the job execution will look like and when it will actually run.

        :param job_template: Specifies the job that will be created when executing a CronJob.
        :param schedule: The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
        :param concurrency_policy: Specifies how to treat concurrent executions of a Job. Valid values are:. - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
        :param failed_jobs_history_limit: The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1. Default: 1.
        :param starting_deadline_seconds: Optional deadline in seconds for starting the job if it misses scheduled time for any reason. Missed jobs executions will be counted as failed ones.
        :param successful_jobs_history_limit: The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3. Default: 3.
        :param suspend: This flag tells the controller to suspend subsequent executions, it does not apply to already started executions. Defaults to false. Default: false.
        :param time_zone: The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones.

        :schema: io.k8s.api.batch.v1.CronJobSpec
        '''
        if isinstance(job_template, dict):
            job_template = JobTemplateSpec(**job_template)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58f07a41268f4e6b6c6c6e9ff93633db6a5f7bf5079c2c0996367662cd071a5b)
            check_type(argname="argument job_template", value=job_template, expected_type=type_hints["job_template"])
            check_type(argname="argument schedule", value=schedule, expected_type=type_hints["schedule"])
            check_type(argname="argument concurrency_policy", value=concurrency_policy, expected_type=type_hints["concurrency_policy"])
            check_type(argname="argument failed_jobs_history_limit", value=failed_jobs_history_limit, expected_type=type_hints["failed_jobs_history_limit"])
            check_type(argname="argument starting_deadline_seconds", value=starting_deadline_seconds, expected_type=type_hints["starting_deadline_seconds"])
            check_type(argname="argument successful_jobs_history_limit", value=successful_jobs_history_limit, expected_type=type_hints["successful_jobs_history_limit"])
            check_type(argname="argument suspend", value=suspend, expected_type=type_hints["suspend"])
            check_type(argname="argument time_zone", value=time_zone, expected_type=type_hints["time_zone"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "job_template": job_template,
            "schedule": schedule,
        }
        if concurrency_policy is not None:
            self._values["concurrency_policy"] = concurrency_policy
        if failed_jobs_history_limit is not None:
            self._values["failed_jobs_history_limit"] = failed_jobs_history_limit
        if starting_deadline_seconds is not None:
            self._values["starting_deadline_seconds"] = starting_deadline_seconds
        if successful_jobs_history_limit is not None:
            self._values["successful_jobs_history_limit"] = successful_jobs_history_limit
        if suspend is not None:
            self._values["suspend"] = suspend
        if time_zone is not None:
            self._values["time_zone"] = time_zone

    @builtins.property
    def job_template(self) -> "JobTemplateSpec":
        '''Specifies the job that will be created when executing a CronJob.

        :schema: io.k8s.api.batch.v1.CronJobSpec#jobTemplate
        '''
        result = self._values.get("job_template")
        assert result is not None, "Required property 'job_template' is missing"
        return typing.cast("JobTemplateSpec", result)

    @builtins.property
    def schedule(self) -> builtins.str:
        '''The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.

        :schema: io.k8s.api.batch.v1.CronJobSpec#schedule
        '''
        result = self._values.get("schedule")
        assert result is not None, "Required property 'schedule' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def concurrency_policy(self) -> typing.Optional[builtins.str]:
        '''Specifies how to treat concurrent executions of a Job. Valid values are:.

        - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one

        :schema: io.k8s.api.batch.v1.CronJobSpec#concurrencyPolicy
        '''
        result = self._values.get("concurrency_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def failed_jobs_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of failed finished jobs to retain.

        Value must be non-negative integer. Defaults to 1.

        :default: 1.

        :schema: io.k8s.api.batch.v1.CronJobSpec#failedJobsHistoryLimit
        '''
        result = self._values.get("failed_jobs_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def starting_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''Optional deadline in seconds for starting the job if it misses scheduled time for any reason.

        Missed jobs executions will be counted as failed ones.

        :schema: io.k8s.api.batch.v1.CronJobSpec#startingDeadlineSeconds
        '''
        result = self._values.get("starting_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def successful_jobs_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of successful finished jobs to retain.

        Value must be non-negative integer. Defaults to 3.

        :default: 3.

        :schema: io.k8s.api.batch.v1.CronJobSpec#successfulJobsHistoryLimit
        '''
        result = self._values.get("successful_jobs_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def suspend(self) -> typing.Optional[builtins.bool]:
        '''This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.

        Defaults to false.

        :default: false.

        :schema: io.k8s.api.batch.v1.CronJobSpec#suspend
        '''
        result = self._values.get("suspend")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def time_zone(self) -> typing.Optional[builtins.str]:
        '''The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones.

        :schema: io.k8s.api.batch.v1.CronJobSpec#timeZone
        '''
        result = self._values.get("time_zone")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CronJobSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CrossVersionObjectReference",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_version": "apiVersion"},
)
class CrossVersionObjectReference:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CrossVersionObjectReference contains enough information to let you identify the referred resource.

        :param kind: kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param name: name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param api_version: apiVersion is the API version of the referent.

        :schema: io.k8s.api.autoscaling.v1.CrossVersionObjectReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__617e96c8f57f05bb296deb863be690ff50e954c2801fcd0a4c8da6a6125573ed)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def kind(self) -> builtins.str:
        '''kind is the kind of the referent;

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.autoscaling.v1.CrossVersionObjectReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the name of the referent;

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.autoscaling.v1.CrossVersionObjectReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''apiVersion is the API version of the referent.

        :schema: io.k8s.api.autoscaling.v1.CrossVersionObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CrossVersionObjectReference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CrossVersionObjectReferenceV2",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_version": "apiVersion"},
)
class CrossVersionObjectReferenceV2:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CrossVersionObjectReference contains enough information to let you identify the referred resource.

        :param kind: kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param name: name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param api_version: apiVersion is the API version of the referent.

        :schema: io.k8s.api.autoscaling.v2.CrossVersionObjectReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__625369a71b365fb0f404d6a91cb174a72a1f09939bbb47598c27b02e603738a9)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def kind(self) -> builtins.str:
        '''kind is the kind of the referent;

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.autoscaling.v2.CrossVersionObjectReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the name of the referent;

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :schema: io.k8s.api.autoscaling.v2.CrossVersionObjectReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''apiVersion is the API version of the referent.

        :schema: io.k8s.api.autoscaling.v2.CrossVersionObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CrossVersionObjectReferenceV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CsiDriverSpec",
    jsii_struct_bases=[],
    name_mapping={
        "attach_required": "attachRequired",
        "fs_group_policy": "fsGroupPolicy",
        "pod_info_on_mount": "podInfoOnMount",
        "requires_republish": "requiresRepublish",
        "se_linux_mount": "seLinuxMount",
        "storage_capacity": "storageCapacity",
        "token_requests": "tokenRequests",
        "volume_lifecycle_modes": "volumeLifecycleModes",
    },
)
class CsiDriverSpec:
    def __init__(
        self,
        *,
        attach_required: typing.Optional[builtins.bool] = None,
        fs_group_policy: typing.Optional[builtins.str] = None,
        pod_info_on_mount: typing.Optional[builtins.bool] = None,
        requires_republish: typing.Optional[builtins.bool] = None,
        se_linux_mount: typing.Optional[builtins.bool] = None,
        storage_capacity: typing.Optional[builtins.bool] = None,
        token_requests: typing.Optional[typing.Sequence[typing.Union["TokenRequest", typing.Dict[builtins.str, typing.Any]]]] = None,
        volume_lifecycle_modes: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''CSIDriverSpec is the specification of a CSIDriver.

        :param attach_required: attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called. This field is immutable.
        :param fs_group_policy: fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details. This field is immutable. Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce. Default: ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
        :param pod_info_on_mount: podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume defined by a CSIVolumeSource, otherwise "false" "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver. This field is immutable. Default: false.
        :param requires_republish: requiresRepublish indicates the CSI driver wants ``NodePublishVolume`` being periodically called to reflect any possible change in the mounted volume. This field defaults to false. Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
        :param se_linux_mount: seLinuxMount specifies if the CSI driver supports "-o context" mount option. When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different ``-o context`` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context. When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem. Default is "false". Default: false".
        :param storage_capacity: storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true. The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object. Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published. This field was immutable in Kubernetes <= 1.22 and now is mutable.
        :param token_requests: tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": { "": { "token": , "expirationTimestamp": , }, ... } Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
        :param volume_lifecycle_modes: volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism. The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume. For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future. This field is beta. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b08a772faf7ca409e3529750ca659dbfe61b0bf234c8921f30cc042ec2e0f52)
            check_type(argname="argument attach_required", value=attach_required, expected_type=type_hints["attach_required"])
            check_type(argname="argument fs_group_policy", value=fs_group_policy, expected_type=type_hints["fs_group_policy"])
            check_type(argname="argument pod_info_on_mount", value=pod_info_on_mount, expected_type=type_hints["pod_info_on_mount"])
            check_type(argname="argument requires_republish", value=requires_republish, expected_type=type_hints["requires_republish"])
            check_type(argname="argument se_linux_mount", value=se_linux_mount, expected_type=type_hints["se_linux_mount"])
            check_type(argname="argument storage_capacity", value=storage_capacity, expected_type=type_hints["storage_capacity"])
            check_type(argname="argument token_requests", value=token_requests, expected_type=type_hints["token_requests"])
            check_type(argname="argument volume_lifecycle_modes", value=volume_lifecycle_modes, expected_type=type_hints["volume_lifecycle_modes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if attach_required is not None:
            self._values["attach_required"] = attach_required
        if fs_group_policy is not None:
            self._values["fs_group_policy"] = fs_group_policy
        if pod_info_on_mount is not None:
            self._values["pod_info_on_mount"] = pod_info_on_mount
        if requires_republish is not None:
            self._values["requires_republish"] = requires_republish
        if se_linux_mount is not None:
            self._values["se_linux_mount"] = se_linux_mount
        if storage_capacity is not None:
            self._values["storage_capacity"] = storage_capacity
        if token_requests is not None:
            self._values["token_requests"] = token_requests
        if volume_lifecycle_modes is not None:
            self._values["volume_lifecycle_modes"] = volume_lifecycle_modes

    @builtins.property
    def attach_required(self) -> typing.Optional[builtins.bool]:
        '''attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting.

        The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

        This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#attachRequired
        '''
        result = self._values.get("attach_required")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_group_policy(self) -> typing.Optional[builtins.str]:
        '''fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted.

        Refer to the specific FSGroupPolicy values for additional details.

        This field is immutable.

        Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.

        :default: ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#fsGroupPolicy
        '''
        result = self._values.get("fs_group_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def pod_info_on_mount(self) -> typing.Optional[builtins.bool]:
        '''podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.

        The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.

        The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
        defined by a CSIVolumeSource, otherwise "false"

        "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.

        This field is immutable.

        :default: false.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#podInfoOnMount
        '''
        result = self._values.get("pod_info_on_mount")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def requires_republish(self) -> typing.Optional[builtins.bool]:
        '''requiresRepublish indicates the CSI driver wants ``NodePublishVolume`` being periodically called to reflect any possible change in the mounted volume.

        This field defaults to false.

        Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#requiresRepublish
        '''
        result = self._values.get("requires_republish")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def se_linux_mount(self) -> typing.Optional[builtins.bool]:
        '''seLinuxMount specifies if the CSI driver supports "-o context" mount option.

        When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different ``-o context`` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.

        When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.

        Default is "false".

        :default: false".

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#seLinuxMount
        '''
        result = self._values.get("se_linux_mount")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def storage_capacity(self) -> typing.Optional[builtins.bool]:
        '''storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.

        The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.

        Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.

        This field was immutable in Kubernetes <= 1.22 and now is mutable.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#storageCapacity
        '''
        result = self._values.get("storage_capacity")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def token_requests(self) -> typing.Optional[typing.List["TokenRequest"]]:
        '''tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication.

        Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
        "": {
        "token": ,
        "expirationTimestamp": ,
        },
        ...
        }

        Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#tokenRequests
        '''
        result = self._values.get("token_requests")
        return typing.cast(typing.Optional[typing.List["TokenRequest"]], result)

    @builtins.property
    def volume_lifecycle_modes(self) -> typing.Optional[typing.List[builtins.str]]:
        '''volumeLifecycleModes defines what kind of volumes this CSI volume driver supports.

        The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.

        The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.

        For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.

        This field is beta. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIDriverSpec#volumeLifecycleModes
        '''
        result = self._values.get("volume_lifecycle_modes")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiDriverSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CsiNodeDriver",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "node_id": "nodeId",
        "allocatable": "allocatable",
        "topology_keys": "topologyKeys",
    },
)
class CsiNodeDriver:
    def __init__(
        self,
        *,
        name: builtins.str,
        node_id: builtins.str,
        allocatable: typing.Optional[typing.Union["VolumeNodeResources", typing.Dict[builtins.str, typing.Any]]] = None,
        topology_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''CSINodeDriver holds information about the specification of one CSI driver installed on a node.

        :param name: name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        :param node_id: nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        :param allocatable: allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
        :param topology_keys: topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.

        :schema: io.k8s.api.storage.v1.CSINodeDriver
        '''
        if isinstance(allocatable, dict):
            allocatable = VolumeNodeResources(**allocatable)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e934780fa3fba8cb1c36c1e7b5d28629a257efe6c9e4fc6d1c25e6a6c4fee571)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_id", value=node_id, expected_type=type_hints["node_id"])
            check_type(argname="argument allocatable", value=allocatable, expected_type=type_hints["allocatable"])
            check_type(argname="argument topology_keys", value=topology_keys, expected_type=type_hints["topology_keys"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "node_id": node_id,
        }
        if allocatable is not None:
            self._values["allocatable"] = allocatable
        if topology_keys is not None:
            self._values["topology_keys"] = topology_keys

    @builtins.property
    def name(self) -> builtins.str:
        '''name represents the name of the CSI driver that this object refers to.

        This MUST be the same name returned by the CSI GetPluginName() call for that driver.

        :schema: io.k8s.api.storage.v1.CSINodeDriver#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def node_id(self) -> builtins.str:
        '''nodeID of the node from the driver point of view.

        This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.

        :schema: io.k8s.api.storage.v1.CSINodeDriver#nodeID
        '''
        result = self._values.get("node_id")
        assert result is not None, "Required property 'node_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def allocatable(self) -> typing.Optional["VolumeNodeResources"]:
        '''allocatable represents the volume resources of a node that are available for scheduling.

        This field is beta.

        :schema: io.k8s.api.storage.v1.CSINodeDriver#allocatable
        '''
        result = self._values.get("allocatable")
        return typing.cast(typing.Optional["VolumeNodeResources"], result)

    @builtins.property
    def topology_keys(self) -> typing.Optional[typing.List[builtins.str]]:
        '''topologyKeys is the list of keys supported by the driver.

        When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.

        :schema: io.k8s.api.storage.v1.CSINodeDriver#topologyKeys
        '''
        result = self._values.get("topology_keys")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiNodeDriver(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CsiNodeSpec",
    jsii_struct_bases=[],
    name_mapping={"drivers": "drivers"},
)
class CsiNodeSpec:
    def __init__(
        self,
        *,
        drivers: typing.Sequence[typing.Union[CsiNodeDriver, typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''CSINodeSpec holds information about the specification of all CSI drivers installed on a node.

        :param drivers: drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.

        :schema: io.k8s.api.storage.v1.CSINodeSpec
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f584b63280953a5c390e14948ddfc44ab612871967a606fe282415bb4d4a2853)
            check_type(argname="argument drivers", value=drivers, expected_type=type_hints["drivers"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "drivers": drivers,
        }

    @builtins.property
    def drivers(self) -> typing.List[CsiNodeDriver]:
        '''drivers is a list of information of all CSI Drivers existing on a node.

        If all drivers in the list are uninstalled, this can become empty.

        :schema: io.k8s.api.storage.v1.CSINodeSpec#drivers
        '''
        result = self._values.get("drivers")
        assert result is not None, "Required property 'drivers' is missing"
        return typing.cast(typing.List[CsiNodeDriver], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiNodeSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CsiPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "volume_handle": "volumeHandle",
        "controller_expand_secret_ref": "controllerExpandSecretRef",
        "controller_publish_secret_ref": "controllerPublishSecretRef",
        "fs_type": "fsType",
        "node_expand_secret_ref": "nodeExpandSecretRef",
        "node_publish_secret_ref": "nodePublishSecretRef",
        "node_stage_secret_ref": "nodeStageSecretRef",
        "read_only": "readOnly",
        "volume_attributes": "volumeAttributes",
    },
)
class CsiPersistentVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        volume_handle: builtins.str,
        controller_expand_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        controller_publish_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        fs_type: typing.Optional[builtins.str] = None,
        node_expand_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        node_publish_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        node_stage_secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        volume_attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''Represents storage that is managed by an external CSI volume driver (Beta feature).

        :param driver: driver is the name of the driver to use for this volume. Required.
        :param volume_handle: volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        :param controller_expand_secret_ref: controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param controller_publish_secret_ref: controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param fs_type: fsType to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        :param node_expand_secret_ref: nodeExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeExpandVolume call. This is a beta field which is enabled default by CSINodeExpandSecret feature gate. This field is optional, may be omitted if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param node_publish_secret_ref: nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param node_stage_secret_ref: nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param read_only: readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write). Default: false (read/write).
        :param volume_attributes: volumeAttributes of the volume to publish.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource
        '''
        if isinstance(controller_expand_secret_ref, dict):
            controller_expand_secret_ref = SecretReference(**controller_expand_secret_ref)
        if isinstance(controller_publish_secret_ref, dict):
            controller_publish_secret_ref = SecretReference(**controller_publish_secret_ref)
        if isinstance(node_expand_secret_ref, dict):
            node_expand_secret_ref = SecretReference(**node_expand_secret_ref)
        if isinstance(node_publish_secret_ref, dict):
            node_publish_secret_ref = SecretReference(**node_publish_secret_ref)
        if isinstance(node_stage_secret_ref, dict):
            node_stage_secret_ref = SecretReference(**node_stage_secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ed4ced56a1465a0f1d68ae12c0410684a9ea98c41e4423d480d9198fdc3817e)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument volume_handle", value=volume_handle, expected_type=type_hints["volume_handle"])
            check_type(argname="argument controller_expand_secret_ref", value=controller_expand_secret_ref, expected_type=type_hints["controller_expand_secret_ref"])
            check_type(argname="argument controller_publish_secret_ref", value=controller_publish_secret_ref, expected_type=type_hints["controller_publish_secret_ref"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument node_expand_secret_ref", value=node_expand_secret_ref, expected_type=type_hints["node_expand_secret_ref"])
            check_type(argname="argument node_publish_secret_ref", value=node_publish_secret_ref, expected_type=type_hints["node_publish_secret_ref"])
            check_type(argname="argument node_stage_secret_ref", value=node_stage_secret_ref, expected_type=type_hints["node_stage_secret_ref"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument volume_attributes", value=volume_attributes, expected_type=type_hints["volume_attributes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
            "volume_handle": volume_handle,
        }
        if controller_expand_secret_ref is not None:
            self._values["controller_expand_secret_ref"] = controller_expand_secret_ref
        if controller_publish_secret_ref is not None:
            self._values["controller_publish_secret_ref"] = controller_publish_secret_ref
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if node_expand_secret_ref is not None:
            self._values["node_expand_secret_ref"] = node_expand_secret_ref
        if node_publish_secret_ref is not None:
            self._values["node_publish_secret_ref"] = node_publish_secret_ref
        if node_stage_secret_ref is not None:
            self._values["node_stage_secret_ref"] = node_stage_secret_ref
        if read_only is not None:
            self._values["read_only"] = read_only
        if volume_attributes is not None:
            self._values["volume_attributes"] = volume_attributes

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the driver to use for this volume.

        Required.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def volume_handle(self) -> builtins.str:
        '''volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls.

        Required.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#volumeHandle
        '''
        result = self._values.get("volume_handle")
        assert result is not None, "Required property 'volume_handle' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def controller_expand_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#controllerExpandSecretRef
        '''
        result = self._values.get("controller_expand_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def controller_publish_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#controllerPublishSecretRef
        '''
        result = self._values.get("controller_publish_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_expand_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''nodeExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeExpandVolume call.

        This is a beta field which is enabled default by CSINodeExpandSecret feature gate. This field is optional, may be omitted if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#nodeExpandSecretRef
        '''
        result = self._values.get("node_expand_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def node_publish_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#nodePublishSecretRef
        '''
        result = self._values.get("node_publish_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def node_stage_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#nodeStageSecretRef
        '''
        result = self._values.get("node_stage_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly value to pass to ControllerPublishVolumeRequest.

        Defaults to false (read/write).

        :default: false (read/write).

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_attributes(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''volumeAttributes of the volume to publish.

        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#volumeAttributes
        '''
        result = self._values.get("volume_attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CsiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "node_publish_secret_ref": "nodePublishSecretRef",
        "read_only": "readOnly",
        "volume_attributes": "volumeAttributes",
    },
)
class CsiVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        node_publish_secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        volume_attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''Represents a source location of a volume to mount, managed by an external CSI driver.

        :param driver: driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        :param fs_type: fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        :param node_publish_secret_ref: nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        :param read_only: readOnly specifies a read-only configuration for the volume. Defaults to false (read/write). Default: false (read/write).
        :param volume_attributes: volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.

        :schema: io.k8s.api.core.v1.CSIVolumeSource
        '''
        if isinstance(node_publish_secret_ref, dict):
            node_publish_secret_ref = LocalObjectReference(**node_publish_secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4cc8dcd90d722724e711280a31071471f74d9ce1b3bb37d0967b5bdf4f172549)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument node_publish_secret_ref", value=node_publish_secret_ref, expected_type=type_hints["node_publish_secret_ref"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument volume_attributes", value=volume_attributes, expected_type=type_hints["volume_attributes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if node_publish_secret_ref is not None:
            self._values["node_publish_secret_ref"] = node_publish_secret_ref
        if read_only is not None:
            self._values["read_only"] = read_only
        if volume_attributes is not None:
            self._values["volume_attributes"] = volume_attributes

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the CSI driver that handles this volume.

        Consult with your admin for the correct name as registered in the cluster.

        :schema: io.k8s.api.core.v1.CSIVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType to mount.

        Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.

        :schema: io.k8s.api.core.v1.CSIVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_publish_secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.

        This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.

        :schema: io.k8s.api.core.v1.CSIVolumeSource#nodePublishSecretRef
        '''
        result = self._values.get("node_publish_secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly specifies a read-only configuration for the volume.

        Defaults to false (read/write).

        :default: false (read/write).

        :schema: io.k8s.api.core.v1.CSIVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_attributes(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''volumeAttributes stores driver-specific properties that are passed to the CSI driver.

        Consult your driver's documentation for supported values.

        :schema: io.k8s.api.core.v1.CSIVolumeSource#volumeAttributes
        '''
        result = self._values.get("volume_attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CustomResourceColumnDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "json_path": "jsonPath",
        "name": "name",
        "type": "type",
        "description": "description",
        "format": "format",
        "priority": "priority",
    },
)
class CustomResourceColumnDefinition:
    def __init__(
        self,
        *,
        json_path: builtins.str,
        name: builtins.str,
        type: builtins.str,
        description: typing.Optional[builtins.str] = None,
        format: typing.Optional[builtins.str] = None,
        priority: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''CustomResourceColumnDefinition specifies a column for server side printing.

        :param json_path: jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        :param name: name is a human readable name for the column.
        :param type: type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param description: description is a human readable description of this column.
        :param format: format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param priority: priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4aa3884f8d09f78694d0ee022a902a07cb4b5ed6ab317dff83459367048cf78c)
            check_type(argname="argument json_path", value=json_path, expected_type=type_hints["json_path"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument format", value=format, expected_type=type_hints["format"])
            check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "json_path": json_path,
            "name": name,
            "type": type,
        }
        if description is not None:
            self._values["description"] = description
        if format is not None:
            self._values["format"] = format
        if priority is not None:
            self._values["priority"] = priority

    @builtins.property
    def json_path(self) -> builtins.str:
        '''jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#jsonPath
        '''
        result = self._values.get("json_path")
        assert result is not None, "Required property 'json_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is a human readable name for the column.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''type is an OpenAPI type definition for this column.

        See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''description is a human readable description of this column.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def format(self) -> typing.Optional[builtins.str]:
        '''format is an optional OpenAPI type definition for this column.

        The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#format
        '''
        result = self._values.get("format")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        '''priority is an integer defining the relative importance of this column compared to others.

        Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition#priority
        '''
        result = self._values.get("priority")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceColumnDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CustomResourceConversion",
    jsii_struct_bases=[],
    name_mapping={"strategy": "strategy", "webhook": "webhook"},
)
class CustomResourceConversion:
    def __init__(
        self,
        *,
        strategy: builtins.str,
        webhook: typing.Optional[typing.Union["WebhookConversion", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceConversion describes how to convert different versions of a CR.

        :param strategy: strategy specifies how custom resources are converted between versions. Allowed values are: - ``"None"``: The converter only change the apiVersion and would not touch any other field in the custom resource. - ``"Webhook"``: API Server will call to an external webhook to do the conversion. Additional information is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
        :param webhook: webhook describes how to call the conversion webhook. Required when ``strategy`` is set to ``"Webhook"``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion
        '''
        if isinstance(webhook, dict):
            webhook = WebhookConversion(**webhook)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa602aaea30650e569941432ce89386cdde0191fb20a5d98b41872785dfe3adb)
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
            check_type(argname="argument webhook", value=webhook, expected_type=type_hints["webhook"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "strategy": strategy,
        }
        if webhook is not None:
            self._values["webhook"] = webhook

    @builtins.property
    def strategy(self) -> builtins.str:
        '''strategy specifies how custom resources are converted between versions.

        Allowed values are: - ``"None"``: The converter only change the apiVersion and would not touch any other field in the custom resource. - ``"Webhook"``: API Server will call to an external webhook to do the conversion. Additional information
        is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion#strategy
        '''
        result = self._values.get("strategy")
        assert result is not None, "Required property 'strategy' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def webhook(self) -> typing.Optional["WebhookConversion"]:
        '''webhook describes how to call the conversion webhook.

        Required when ``strategy`` is set to ``"Webhook"``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion#webhook
        '''
        result = self._values.get("webhook")
        return typing.cast(typing.Optional["WebhookConversion"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceConversion(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CustomResourceDefinitionNames",
    jsii_struct_bases=[],
    name_mapping={
        "kind": "kind",
        "plural": "plural",
        "categories": "categories",
        "list_kind": "listKind",
        "short_names": "shortNames",
        "singular": "singular",
    },
)
class CustomResourceDefinitionNames:
    def __init__(
        self,
        *,
        kind: builtins.str,
        plural: builtins.str,
        categories: typing.Optional[typing.Sequence[builtins.str]] = None,
        list_kind: typing.Optional[builtins.str] = None,
        short_names: typing.Optional[typing.Sequence[builtins.str]] = None,
        singular: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition.

        :param kind: kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the ``kind`` attribute in API calls.
        :param plural: plural is the plural name of the resource to serve. The custom resources are served under ``/apis/<group>/<version>/.../<plural>``. Must match the name of the CustomResourceDefinition (in the form ``<names.plural>.<group>``). Must be all lowercase.
        :param categories: categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like ``kubectl get all``.
        :param list_kind: listKind is the serialized kind of the list for this resource. Defaults to "``kind``List". Default: kind`List".
        :param short_names: shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like ``kubectl get <shortname>``. It must be all lowercase.
        :param singular: singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased ``kind``. Default: lowercased ``kind``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__69b4cc6c6258db1d023d3903eab62002c47e7a4c44366e7fa3ced911d778bdbb)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument plural", value=plural, expected_type=type_hints["plural"])
            check_type(argname="argument categories", value=categories, expected_type=type_hints["categories"])
            check_type(argname="argument list_kind", value=list_kind, expected_type=type_hints["list_kind"])
            check_type(argname="argument short_names", value=short_names, expected_type=type_hints["short_names"])
            check_type(argname="argument singular", value=singular, expected_type=type_hints["singular"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "plural": plural,
        }
        if categories is not None:
            self._values["categories"] = categories
        if list_kind is not None:
            self._values["list_kind"] = list_kind
        if short_names is not None:
            self._values["short_names"] = short_names
        if singular is not None:
            self._values["singular"] = singular

    @builtins.property
    def kind(self) -> builtins.str:
        '''kind is the serialized kind of the resource.

        It is normally CamelCase and singular. Custom resource instances will use this value as the ``kind`` attribute in API calls.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def plural(self) -> builtins.str:
        '''plural is the plural name of the resource to serve.

        The custom resources are served under ``/apis/<group>/<version>/.../<plural>``. Must match the name of the CustomResourceDefinition (in the form ``<names.plural>.<group>``). Must be all lowercase.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#plural
        '''
        result = self._values.get("plural")
        assert result is not None, "Required property 'plural' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def categories(self) -> typing.Optional[typing.List[builtins.str]]:
        '''categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like ``kubectl get all``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#categories
        '''
        result = self._values.get("categories")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def list_kind(self) -> typing.Optional[builtins.str]:
        '''listKind is the serialized kind of the list for this resource.

        Defaults to "``kind``List".

        :default: kind`List".

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#listKind
        '''
        result = self._values.get("list_kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def short_names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like ``kubectl get <shortname>``.

        It must be all lowercase.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#shortNames
        '''
        result = self._values.get("short_names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def singular(self) -> typing.Optional[builtins.str]:
        '''singular is the singular name of the resource.

        It must be all lowercase. Defaults to lowercased ``kind``.

        :default: lowercased ``kind``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#singular
        '''
        result = self._values.get("singular")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionNames(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CustomResourceDefinitionSpec",
    jsii_struct_bases=[],
    name_mapping={
        "group": "group",
        "names": "names",
        "scope": "scope",
        "versions": "versions",
        "conversion": "conversion",
        "preserve_unknown_fields": "preserveUnknownFields",
    },
)
class CustomResourceDefinitionSpec:
    def __init__(
        self,
        *,
        group: builtins.str,
        names: typing.Union[CustomResourceDefinitionNames, typing.Dict[builtins.str, typing.Any]],
        scope: builtins.str,
        versions: typing.Sequence[typing.Union["CustomResourceDefinitionVersion", typing.Dict[builtins.str, typing.Any]]],
        conversion: typing.Optional[typing.Union[CustomResourceConversion, typing.Dict[builtins.str, typing.Any]]] = None,
        preserve_unknown_fields: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''CustomResourceDefinitionSpec describes how a user wants their resource to appear.

        :param group: group is the API group of the defined custom resource. The custom resources are served under ``/apis/<group>/...``. Must match the name of the CustomResourceDefinition (in the form ``<names.plural>.<group>``).
        :param names: names specify the resource and kind names for the custom resource.
        :param scope: scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are ``Cluster`` and ``Namespaced``.
        :param versions: versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        :param conversion: conversion defines conversion settings for the CRD.
        :param preserve_unknown_fields: preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting ``x-preserve-unknown-fields`` to true in ``spec.versions[*].schema.openAPIV3Schema``. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec
        '''
        if isinstance(names, dict):
            names = CustomResourceDefinitionNames(**names)
        if isinstance(conversion, dict):
            conversion = CustomResourceConversion(**conversion)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c8ddf376eae1471ad7f37900cdd3e089cb628e5fb25a5bb3ba9cf47431ab12b)
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument versions", value=versions, expected_type=type_hints["versions"])
            check_type(argname="argument conversion", value=conversion, expected_type=type_hints["conversion"])
            check_type(argname="argument preserve_unknown_fields", value=preserve_unknown_fields, expected_type=type_hints["preserve_unknown_fields"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "group": group,
            "names": names,
            "scope": scope,
            "versions": versions,
        }
        if conversion is not None:
            self._values["conversion"] = conversion
        if preserve_unknown_fields is not None:
            self._values["preserve_unknown_fields"] = preserve_unknown_fields

    @builtins.property
    def group(self) -> builtins.str:
        '''group is the API group of the defined custom resource.

        The custom resources are served under ``/apis/<group>/...``. Must match the name of the CustomResourceDefinition (in the form ``<names.plural>.<group>``).

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#group
        '''
        result = self._values.get("group")
        assert result is not None, "Required property 'group' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def names(self) -> CustomResourceDefinitionNames:
        '''names specify the resource and kind names for the custom resource.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#names
        '''
        result = self._values.get("names")
        assert result is not None, "Required property 'names' is missing"
        return typing.cast(CustomResourceDefinitionNames, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''scope indicates whether the defined custom resource is cluster- or namespace-scoped.

        Allowed values are ``Cluster`` and ``Namespaced``.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def versions(self) -> typing.List["CustomResourceDefinitionVersion"]:
        '''versions is the list of all API versions of the defined custom resource.

        Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#versions
        '''
        result = self._values.get("versions")
        assert result is not None, "Required property 'versions' is missing"
        return typing.cast(typing.List["CustomResourceDefinitionVersion"], result)

    @builtins.property
    def conversion(self) -> typing.Optional[CustomResourceConversion]:
        '''conversion defines conversion settings for the CRD.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#conversion
        '''
        result = self._values.get("conversion")
        return typing.cast(typing.Optional[CustomResourceConversion], result)

    @builtins.property
    def preserve_unknown_fields(self) -> typing.Optional[builtins.bool]:
        '''preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage.

        apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting ``x-preserve-unknown-fields`` to true in ``spec.versions[*].schema.openAPIV3Schema``. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#preserveUnknownFields
        '''
        result = self._values.get("preserve_unknown_fields")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CustomResourceDefinitionVersion",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "served": "served",
        "storage": "storage",
        "additional_printer_columns": "additionalPrinterColumns",
        "deprecated": "deprecated",
        "deprecation_warning": "deprecationWarning",
        "schema": "schema",
        "subresources": "subresources",
    },
)
class CustomResourceDefinitionVersion:
    def __init__(
        self,
        *,
        name: builtins.str,
        served: builtins.bool,
        storage: builtins.bool,
        additional_printer_columns: typing.Optional[typing.Sequence[typing.Union[CustomResourceColumnDefinition, typing.Dict[builtins.str, typing.Any]]]] = None,
        deprecated: typing.Optional[builtins.bool] = None,
        deprecation_warning: typing.Optional[builtins.str] = None,
        schema: typing.Optional[typing.Union["CustomResourceValidation", typing.Dict[builtins.str, typing.Any]]] = None,
        subresources: typing.Optional[typing.Union["CustomResourceSubresources", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceDefinitionVersion describes a version for CRD.

        :param name: name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at ``/apis/<group>/<version>/...`` if ``served`` is true.
        :param served: served is a flag enabling/disabling this version from being served via REST APIs.
        :param storage: storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        :param additional_printer_columns: additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
        :param deprecated: deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false. Default: false.
        :param deprecation_warning: deprecationWarning overrides the default warning returned to API clients. May only be set when ``deprecated`` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        :param schema: schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
        :param subresources: subresources specify what subresources this version of the defined custom resource have.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion
        '''
        if isinstance(schema, dict):
            schema = CustomResourceValidation(**schema)
        if isinstance(subresources, dict):
            subresources = CustomResourceSubresources(**subresources)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef600640998d609d1671707f42e302ea025c68e8eeacaa0fa00a30aadaa03773)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument served", value=served, expected_type=type_hints["served"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument additional_printer_columns", value=additional_printer_columns, expected_type=type_hints["additional_printer_columns"])
            check_type(argname="argument deprecated", value=deprecated, expected_type=type_hints["deprecated"])
            check_type(argname="argument deprecation_warning", value=deprecation_warning, expected_type=type_hints["deprecation_warning"])
            check_type(argname="argument schema", value=schema, expected_type=type_hints["schema"])
            check_type(argname="argument subresources", value=subresources, expected_type=type_hints["subresources"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "served": served,
            "storage": storage,
        }
        if additional_printer_columns is not None:
            self._values["additional_printer_columns"] = additional_printer_columns
        if deprecated is not None:
            self._values["deprecated"] = deprecated
        if deprecation_warning is not None:
            self._values["deprecation_warning"] = deprecation_warning
        if schema is not None:
            self._values["schema"] = schema
        if subresources is not None:
            self._values["subresources"] = subresources

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at ``/apis/<group>/<version>/...`` if ``served`` is true.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def served(self) -> builtins.bool:
        '''served is a flag enabling/disabling this version from being served via REST APIs.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#served
        '''
        result = self._values.get("served")
        assert result is not None, "Required property 'served' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def storage(self) -> builtins.bool:
        '''storage indicates this version should be used when persisting custom resources to storage.

        There must be exactly one version with storage=true.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#storage
        '''
        result = self._values.get("storage")
        assert result is not None, "Required property 'storage' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def additional_printer_columns(
        self,
    ) -> typing.Optional[typing.List[CustomResourceColumnDefinition]]:
        '''additionalPrinterColumns specifies additional columns returned in Table output.

        See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#additionalPrinterColumns
        '''
        result = self._values.get("additional_printer_columns")
        return typing.cast(typing.Optional[typing.List[CustomResourceColumnDefinition]], result)

    @builtins.property
    def deprecated(self) -> typing.Optional[builtins.bool]:
        '''deprecated indicates this version of the custom resource API is deprecated.

        When set to true, API requests to this version receive a warning header in the server response. Defaults to false.

        :default: false.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#deprecated
        '''
        result = self._values.get("deprecated")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def deprecation_warning(self) -> typing.Optional[builtins.str]:
        '''deprecationWarning overrides the default warning returned to API clients.

        May only be set when ``deprecated`` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#deprecationWarning
        '''
        result = self._values.get("deprecation_warning")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def schema(self) -> typing.Optional["CustomResourceValidation"]:
        '''schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#schema
        '''
        result = self._values.get("schema")
        return typing.cast(typing.Optional["CustomResourceValidation"], result)

    @builtins.property
    def subresources(self) -> typing.Optional["CustomResourceSubresources"]:
        '''subresources specify what subresources this version of the defined custom resource have.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#subresources
        '''
        result = self._values.get("subresources")
        return typing.cast(typing.Optional["CustomResourceSubresources"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionVersion(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CustomResourceSubresourceScale",
    jsii_struct_bases=[],
    name_mapping={
        "spec_replicas_path": "specReplicasPath",
        "status_replicas_path": "statusReplicasPath",
        "label_selector_path": "labelSelectorPath",
    },
)
class CustomResourceSubresourceScale:
    def __init__(
        self,
        *,
        spec_replicas_path: builtins.str,
        status_replicas_path: builtins.str,
        label_selector_path: typing.Optional[builtins.str] = None,
    ) -> None:
        '''CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.

        :param spec_replicas_path: specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale ``spec.replicas``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.spec``. If there is no value under the given path in the custom resource, the ``/scale`` subresource will return an error on GET.
        :param status_replicas_path: statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale ``status.replicas``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.status``. If there is no value under the given path in the custom resource, the ``status.replicas`` value in the ``/scale`` subresource will default to 0.
        :param label_selector_path: labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale ``status.selector``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.status`` or ``.spec``. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the ``status.selector`` value in the ``/scale`` subresource will default to the empty string.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b662f3457e1d3ae02007b4c253812c7d6499d43eb404469c42bdc0b88c4f3cf6)
            check_type(argname="argument spec_replicas_path", value=spec_replicas_path, expected_type=type_hints["spec_replicas_path"])
            check_type(argname="argument status_replicas_path", value=status_replicas_path, expected_type=type_hints["status_replicas_path"])
            check_type(argname="argument label_selector_path", value=label_selector_path, expected_type=type_hints["label_selector_path"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec_replicas_path": spec_replicas_path,
            "status_replicas_path": status_replicas_path,
        }
        if label_selector_path is not None:
            self._values["label_selector_path"] = label_selector_path

    @builtins.property
    def spec_replicas_path(self) -> builtins.str:
        '''specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale ``spec.replicas``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.spec``. If there is no value under the given path in the custom resource, the ``/scale`` subresource will return an error on GET.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale#specReplicasPath
        '''
        result = self._values.get("spec_replicas_path")
        assert result is not None, "Required property 'spec_replicas_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def status_replicas_path(self) -> builtins.str:
        '''statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale ``status.replicas``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.status``. If there is no value under the given path in the custom resource, the ``status.replicas`` value in the ``/scale`` subresource will default to 0.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale#statusReplicasPath
        '''
        result = self._values.get("status_replicas_path")
        assert result is not None, "Required property 'status_replicas_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector_path(self) -> typing.Optional[builtins.str]:
        '''labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale ``status.selector``. Only JSON paths without the array notation are allowed. Must be a JSON Path under ``.status`` or ``.spec``. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the ``status.selector`` value in the ``/scale`` subresource will default to the empty string.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale#labelSelectorPath
        '''
        result = self._values.get("label_selector_path")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceSubresourceScale(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CustomResourceSubresources",
    jsii_struct_bases=[],
    name_mapping={"scale": "scale", "status": "status"},
)
class CustomResourceSubresources:
    def __init__(
        self,
        *,
        scale: typing.Optional[typing.Union[CustomResourceSubresourceScale, typing.Dict[builtins.str, typing.Any]]] = None,
        status: typing.Any = None,
    ) -> None:
        '''CustomResourceSubresources defines the status and scale subresources for CustomResources.

        :param scale: scale indicates the custom resource should serve a ``/scale`` subresource that returns an ``autoscaling/v1`` Scale object.
        :param status: status indicates the custom resource should serve a ``/status`` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the ``status`` stanza of the object. 2. requests to the custom resource ``/status`` subresource ignore changes to anything other than the ``status`` stanza of the object.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources
        '''
        if isinstance(scale, dict):
            scale = CustomResourceSubresourceScale(**scale)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76af00a59a7a9433f960ac1901fd1e96c9f734e498016f212714ed1acb7a0d8a)
            check_type(argname="argument scale", value=scale, expected_type=type_hints["scale"])
            check_type(argname="argument status", value=status, expected_type=type_hints["status"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if scale is not None:
            self._values["scale"] = scale
        if status is not None:
            self._values["status"] = status

    @builtins.property
    def scale(self) -> typing.Optional[CustomResourceSubresourceScale]:
        '''scale indicates the custom resource should serve a ``/scale`` subresource that returns an ``autoscaling/v1`` Scale object.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources#scale
        '''
        result = self._values.get("scale")
        return typing.cast(typing.Optional[CustomResourceSubresourceScale], result)

    @builtins.property
    def status(self) -> typing.Any:
        '''status indicates the custom resource should serve a ``/status`` subresource.

        When enabled: 1. requests to the custom resource primary endpoint ignore changes to the ``status`` stanza of the object. 2. requests to the custom resource ``/status`` subresource ignore changes to anything other than the ``status`` stanza of the object.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources#status
        '''
        result = self._values.get("status")
        return typing.cast(typing.Any, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceSubresources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.CustomResourceValidation",
    jsii_struct_bases=[],
    name_mapping={"open_apiv3_schema": "openApiv3Schema"},
)
class CustomResourceValidation:
    def __init__(
        self,
        *,
        open_apiv3_schema: typing.Optional[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceValidation is a list of validation methods for CustomResources.

        :param open_apiv3_schema: openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation
        '''
        if isinstance(open_apiv3_schema, dict):
            open_apiv3_schema = JsonSchemaProps(**open_apiv3_schema)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71dceb636bd67eb61c0ee5a69198a43ab6db8030f16cd6332229bc3b8ad15349)
            check_type(argname="argument open_apiv3_schema", value=open_apiv3_schema, expected_type=type_hints["open_apiv3_schema"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if open_apiv3_schema is not None:
            self._values["open_apiv3_schema"] = open_apiv3_schema

    @builtins.property
    def open_apiv3_schema(self) -> typing.Optional["JsonSchemaProps"]:
        '''openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation#openAPIV3Schema
        '''
        result = self._values.get("open_apiv3_schema")
        return typing.cast(typing.Optional["JsonSchemaProps"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceValidation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.DaemonSetSpec",
    jsii_struct_bases=[],
    name_mapping={
        "selector": "selector",
        "template": "template",
        "min_ready_seconds": "minReadySeconds",
        "revision_history_limit": "revisionHistoryLimit",
        "update_strategy": "updateStrategy",
    },
)
class DaemonSetSpec:
    def __init__(
        self,
        *,
        selector: typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]],
        template: typing.Union["PodTemplateSpec", typing.Dict[builtins.str, typing.Any]],
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        revision_history_limit: typing.Optional[jsii.Number] = None,
        update_strategy: typing.Optional[typing.Union["DaemonSetUpdateStrategy", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DaemonSetSpec is the specification of a daemon set.

        :param selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready). Default: 0 (pod will be considered available as soon as it is ready).
        :param revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10. Default: 10.
        :param update_strategy: An update strategy to replace existing DaemonSet pods with new pods.

        :schema: io.k8s.api.apps.v1.DaemonSetSpec
        '''
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(update_strategy, dict):
            update_strategy = DaemonSetUpdateStrategy(**update_strategy)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ecb820e09763adfbc9e0418f557aa6199986d92bb030a26ac92a12c92154828)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument template", value=template, expected_type=type_hints["template"])
            check_type(argname="argument min_ready_seconds", value=min_ready_seconds, expected_type=type_hints["min_ready_seconds"])
            check_type(argname="argument revision_history_limit", value=revision_history_limit, expected_type=type_hints["revision_history_limit"])
            check_type(argname="argument update_strategy", value=update_strategy, expected_type=type_hints["update_strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "selector": selector,
            "template": template,
        }
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds
        if revision_history_limit is not None:
            self._values["revision_history_limit"] = revision_history_limit
        if update_strategy is not None:
            self._values["update_strategy"] = update_strategy

    @builtins.property
    def selector(self) -> "LabelSelector":
        '''A label query over pods that are managed by the daemon set.

        Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#selector
        '''
        result = self._values.get("selector")
        assert result is not None, "Required property 'selector' is missing"
        return typing.cast("LabelSelector", result)

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''An object that describes the pod that will be created.

        The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available.

        Defaults to 0 (pod will be considered available as soon as it is ready).

        :default: 0 (pod will be considered available as soon as it is ready).

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#minReadySeconds
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def revision_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of old history to retain to allow rollback.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.

        :default: 10.

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#revisionHistoryLimit
        '''
        result = self._values.get("revision_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def update_strategy(self) -> typing.Optional["DaemonSetUpdateStrategy"]:
        '''An update strategy to replace existing DaemonSet pods with new pods.

        :schema: io.k8s.api.apps.v1.DaemonSetSpec#updateStrategy
        '''
        result = self._values.get("update_strategy")
        return typing.cast(typing.Optional["DaemonSetUpdateStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.DaemonSetUpdateStrategy",
    jsii_struct_bases=[],
    name_mapping={"rolling_update": "rollingUpdate", "type": "type"},
)
class DaemonSetUpdateStrategy:
    def __init__(
        self,
        *,
        rolling_update: typing.Optional[typing.Union["RollingUpdateDaemonSet", typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.

        :param rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate. Default: RollingUpdate.

        :schema: io.k8s.api.apps.v1.DaemonSetUpdateStrategy
        '''
        if isinstance(rolling_update, dict):
            rolling_update = RollingUpdateDaemonSet(**rolling_update)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__739a17876dff00352360194fb35684a8601ad34cc66ea02d10ae67e653e1853c)
            check_type(argname="argument rolling_update", value=rolling_update, expected_type=type_hints["rolling_update"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if rolling_update is not None:
            self._values["rolling_update"] = rolling_update
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def rolling_update(self) -> typing.Optional["RollingUpdateDaemonSet"]:
        '''Rolling update config params.

        Present only if type = "RollingUpdate".

        :schema: io.k8s.api.apps.v1.DaemonSetUpdateStrategy#rollingUpdate
        '''
        result = self._values.get("rolling_update")
        return typing.cast(typing.Optional["RollingUpdateDaemonSet"], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''Type of daemon set update.

        Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.

        :default: RollingUpdate.

        :schema: io.k8s.api.apps.v1.DaemonSetUpdateStrategy#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetUpdateStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.DeleteOptions",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "dry_run": "dryRun",
        "grace_period_seconds": "gracePeriodSeconds",
        "kind": "kind",
        "orphan_dependents": "orphanDependents",
        "preconditions": "preconditions",
        "propagation_policy": "propagationPolicy",
    },
)
class DeleteOptions:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        dry_run: typing.Optional[typing.Sequence[builtins.str]] = None,
        grace_period_seconds: typing.Optional[jsii.Number] = None,
        kind: typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"] = None,
        orphan_dependents: typing.Optional[builtins.bool] = None,
        preconditions: typing.Optional[typing.Union["Preconditions", typing.Dict[builtins.str, typing.Any]]] = None,
        propagation_policy: typing.Optional[builtins.str] = None,
    ) -> None:
        '''DeleteOptions may be provided when deleting an API object.

        :param api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param dry_run: When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
        :param grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately. Default: a per object value if not specified. zero means delete immediately.
        :param kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param preconditions: Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.
        :param propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions
        '''
        if isinstance(preconditions, dict):
            preconditions = Preconditions(**preconditions)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__702ed86356b48fa93bdbcfca7ba98b9375f07af67b591ae3b2b2c6ac91c11c75)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument dry_run", value=dry_run, expected_type=type_hints["dry_run"])
            check_type(argname="argument grace_period_seconds", value=grace_period_seconds, expected_type=type_hints["grace_period_seconds"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument orphan_dependents", value=orphan_dependents, expected_type=type_hints["orphan_dependents"])
            check_type(argname="argument preconditions", value=preconditions, expected_type=type_hints["preconditions"])
            check_type(argname="argument propagation_policy", value=propagation_policy, expected_type=type_hints["propagation_policy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if dry_run is not None:
            self._values["dry_run"] = dry_run
        if grace_period_seconds is not None:
            self._values["grace_period_seconds"] = grace_period_seconds
        if kind is not None:
            self._values["kind"] = kind
        if orphan_dependents is not None:
            self._values["orphan_dependents"] = orphan_dependents
        if preconditions is not None:
            self._values["preconditions"] = preconditions
        if propagation_policy is not None:
            self._values["propagation_policy"] = propagation_policy

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''APIVersion defines the versioned schema of this representation of an object.

        Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dry_run(self) -> typing.Optional[typing.List[builtins.str]]:
        '''When present, indicates that modifications should not be persisted.

        An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#dryRun
        '''
        result = self._values.get("dry_run")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def grace_period_seconds(self) -> typing.Optional[jsii.Number]:
        '''The duration in seconds before the object should be deleted.

        Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.

        :default: a per object value if not specified. zero means delete immediately.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#gracePeriodSeconds
        '''
        result = self._values.get("grace_period_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def kind(
        self,
    ) -> typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"]:
        '''Kind is a string value representing the REST resource this object represents.

        Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"], result)

    @builtins.property
    def orphan_dependents(self) -> typing.Optional[builtins.bool]:
        '''Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#orphanDependents
        '''
        result = self._values.get("orphan_dependents")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def preconditions(self) -> typing.Optional["Preconditions"]:
        '''Must be fulfilled before a deletion is carried out.

        If not possible, a 409 Conflict status will be returned.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#preconditions
        '''
        result = self._values.get("preconditions")
        return typing.cast(typing.Optional["Preconditions"], result)

    @builtins.property
    def propagation_policy(self) -> typing.Optional[builtins.str]:
        '''Whether and how garbage collection will be performed.

        Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.

        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#propagationPolicy
        '''
        result = self._values.get("propagation_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeleteOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.DeploymentSpec",
    jsii_struct_bases=[],
    name_mapping={
        "selector": "selector",
        "template": "template",
        "min_ready_seconds": "minReadySeconds",
        "paused": "paused",
        "progress_deadline_seconds": "progressDeadlineSeconds",
        "replicas": "replicas",
        "revision_history_limit": "revisionHistoryLimit",
        "strategy": "strategy",
    },
)
class DeploymentSpec:
    def __init__(
        self,
        *,
        selector: typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]],
        template: typing.Union["PodTemplateSpec", typing.Dict[builtins.str, typing.Any]],
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        paused: typing.Optional[builtins.bool] = None,
        progress_deadline_seconds: typing.Optional[jsii.Number] = None,
        replicas: typing.Optional[jsii.Number] = None,
        revision_history_limit: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[typing.Union["DeploymentStrategy", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DeploymentSpec is the specification of the desired behavior of the Deployment.

        :param selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        :param template: Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        :param min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready) Default: 0 (pod will be considered available as soon as it is ready)
        :param paused: Indicates that the deployment is paused.
        :param progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s. Default: 600s.
        :param replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1. Default: 1.
        :param revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10. Default: 10.
        :param strategy: The deployment strategy to use to replace existing pods with new ones.

        :schema: io.k8s.api.apps.v1.DeploymentSpec
        '''
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(strategy, dict):
            strategy = DeploymentStrategy(**strategy)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__504d997f29b1747d3d6f6c0a4347d39976a6b642b908c89e24105d44a896e181)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument template", value=template, expected_type=type_hints["template"])
            check_type(argname="argument min_ready_seconds", value=min_ready_seconds, expected_type=type_hints["min_ready_seconds"])
            check_type(argname="argument paused", value=paused, expected_type=type_hints["paused"])
            check_type(argname="argument progress_deadline_seconds", value=progress_deadline_seconds, expected_type=type_hints["progress_deadline_seconds"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument revision_history_limit", value=revision_history_limit, expected_type=type_hints["revision_history_limit"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "selector": selector,
            "template": template,
        }
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds
        if paused is not None:
            self._values["paused"] = paused
        if progress_deadline_seconds is not None:
            self._values["progress_deadline_seconds"] = progress_deadline_seconds
        if replicas is not None:
            self._values["replicas"] = replicas
        if revision_history_limit is not None:
            self._values["revision_history_limit"] = revision_history_limit
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def selector(self) -> "LabelSelector":
        '''Label selector for pods.

        Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#selector
        '''
        result = self._values.get("selector")
        assert result is not None, "Required property 'selector' is missing"
        return typing.cast("LabelSelector", result)

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''Template describes the pods that will be created.

        The only allowed template.spec.restartPolicy value is "Always".

        :schema: io.k8s.api.apps.v1.DeploymentSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        Defaults to 0 (pod will be considered available as soon as it is ready)

        :default: 0 (pod will be considered available as soon as it is ready)

        :schema: io.k8s.api.apps.v1.DeploymentSpec#minReadySeconds
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def paused(self) -> typing.Optional[builtins.bool]:
        '''Indicates that the deployment is paused.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#paused
        '''
        result = self._values.get("paused")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def progress_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''The maximum time in seconds for a deployment to make progress before it is considered to be failed.

        The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.

        :default: 600s.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#progressDeadlineSeconds
        '''
        result = self._values.get("progress_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.

        :default: 1.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#replicas
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def revision_history_limit(self) -> typing.Optional[jsii.Number]:
        '''The number of old ReplicaSets to retain to allow rollback.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.

        :default: 10.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#revisionHistoryLimit
        '''
        result = self._values.get("revision_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def strategy(self) -> typing.Optional["DeploymentStrategy"]:
        '''The deployment strategy to use to replace existing pods with new ones.

        :schema: io.k8s.api.apps.v1.DeploymentSpec#strategy
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional["DeploymentStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.DeploymentStrategy",
    jsii_struct_bases=[],
    name_mapping={"rolling_update": "rollingUpdate", "type": "type"},
)
class DeploymentStrategy:
    def __init__(
        self,
        *,
        rolling_update: typing.Optional[typing.Union["RollingUpdateDeployment", typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''DeploymentStrategy describes how to replace existing pods with new ones.

        :param rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate. Default: RollingUpdate.

        :schema: io.k8s.api.apps.v1.DeploymentStrategy
        '''
        if isinstance(rolling_update, dict):
            rolling_update = RollingUpdateDeployment(**rolling_update)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8bb30f2e88fcb41a5af1089babe60e65a4d1f5750a960de106fc3445fc9aecf8)
            check_type(argname="argument rolling_update", value=rolling_update, expected_type=type_hints["rolling_update"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if rolling_update is not None:
            self._values["rolling_update"] = rolling_update
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def rolling_update(self) -> typing.Optional["RollingUpdateDeployment"]:
        '''Rolling update config params.

        Present only if DeploymentStrategyType = RollingUpdate.

        :schema: io.k8s.api.apps.v1.DeploymentStrategy#rollingUpdate
        '''
        result = self._values.get("rolling_update")
        return typing.cast(typing.Optional["RollingUpdateDeployment"], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''Type of deployment.

        Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.

        :default: RollingUpdate.

        :schema: io.k8s.api.apps.v1.DeploymentStrategy#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.DownwardApiProjection",
    jsii_struct_bases=[],
    name_mapping={"items": "items"},
)
class DownwardApiProjection:
    def __init__(
        self,
        *,
        items: typing.Optional[typing.Sequence[typing.Union["DownwardApiVolumeFile", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Represents downward API info for projecting into a projected volume.

        Note that this is identical to a downwardAPI volume source without the default mode.

        :param items: Items is a list of DownwardAPIVolume file.

        :schema: io.k8s.api.core.v1.DownwardAPIProjection
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__192cbebabd78fc1b5ca42c277155dbf129351490f98c79166ad741390b0720b8)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if items is not None:
            self._values["items"] = items

    @builtins.property
    def items(self) -> typing.Optional[typing.List["DownwardApiVolumeFile"]]:
        '''Items is a list of DownwardAPIVolume file.

        :schema: io.k8s.api.core.v1.DownwardAPIProjection#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["DownwardApiVolumeFile"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiProjection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.DownwardApiVolumeFile",
    jsii_struct_bases=[],
    name_mapping={
        "path": "path",
        "field_ref": "fieldRef",
        "mode": "mode",
        "resource_field_ref": "resourceFieldRef",
    },
)
class DownwardApiVolumeFile:
    def __init__(
        self,
        *,
        path: builtins.str,
        field_ref: typing.Optional[typing.Union["ObjectFieldSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        mode: typing.Optional[jsii.Number] = None,
        resource_field_ref: typing.Optional[typing.Union["ResourceFieldSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DownwardAPIVolumeFile represents information to create the file containing the pod field.

        :param path: Required: Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        :param field_ref: Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
        :param mode: Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile
        '''
        if isinstance(field_ref, dict):
            field_ref = ObjectFieldSelector(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = ResourceFieldSelector(**resource_field_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bededcd13335ff575617338cc6afb0919988c40e72587f0e45a60f200c5d5ec5)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument field_ref", value=field_ref, expected_type=type_hints["field_ref"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
            check_type(argname="argument resource_field_ref", value=resource_field_ref, expected_type=type_hints["resource_field_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if mode is not None:
            self._values["mode"] = mode
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref

    @builtins.property
    def path(self) -> builtins.str:
        '''Required: Path is  the relative path name of the file to be created.

        Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def field_ref(self) -> typing.Optional["ObjectFieldSelector"]:
        '''Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["ObjectFieldSelector"], result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511.

        YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#mode
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def resource_field_ref(self) -> typing.Optional["ResourceFieldSelector"]:
        '''Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["ResourceFieldSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiVolumeFile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.DownwardApiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"default_mode": "defaultMode", "items": "items"},
)
class DownwardApiVolumeSource:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Sequence[typing.Union[DownwardApiVolumeFile, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''DownwardAPIVolumeSource represents a volume containing downward API info.

        Downward API volumes support ownership management and SELinux relabeling.

        :param default_mode: Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: Items is a list of downward API volume file.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__241211f70735845c114208744818be93cd6d895f565f74fc5420c5487777acfc)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''Optional: mode bits to use on created files by default.

        Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource#defaultMode
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.List[DownwardApiVolumeFile]]:
        '''Items is a list of downward API volume file.

        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List[DownwardApiVolumeFile]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EmptyDirVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"medium": "medium", "size_limit": "sizeLimit"},
)
class EmptyDirVolumeSource:
    def __init__(
        self,
        *,
        medium: typing.Optional[builtins.str] = None,
        size_limit: typing.Optional["Quantity"] = None,
    ) -> None:
        '''Represents an empty directory for a pod.

        Empty directory volumes support ownership management and SELinux relabeling.

        :param medium: medium represents what type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        :param size_limit: sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir

        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7bb09c3065048f609be720fc09b7c16883ce3bd98fdf4f088320db527cbb9b19)
            check_type(argname="argument medium", value=medium, expected_type=type_hints["medium"])
            check_type(argname="argument size_limit", value=size_limit, expected_type=type_hints["size_limit"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if medium is not None:
            self._values["medium"] = medium
        if size_limit is not None:
            self._values["size_limit"] = size_limit

    @builtins.property
    def medium(self) -> typing.Optional[builtins.str]:
        '''medium represents what type of storage medium should back this directory.

        The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir

        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource#medium
        '''
        result = self._values.get("medium")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def size_limit(self) -> typing.Optional["Quantity"]:
        '''sizeLimit is the total amount of local storage required for this EmptyDir volume.

        The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir

        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource#sizeLimit
        '''
        result = self._values.get("size_limit")
        return typing.cast(typing.Optional["Quantity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EmptyDirVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.Endpoint",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "conditions": "conditions",
        "deprecated_topology": "deprecatedTopology",
        "hints": "hints",
        "hostname": "hostname",
        "node_name": "nodeName",
        "target_ref": "targetRef",
        "zone": "zone",
    },
)
class Endpoint:
    def __init__(
        self,
        *,
        addresses: typing.Sequence[builtins.str],
        conditions: typing.Optional[typing.Union["EndpointConditions", typing.Dict[builtins.str, typing.Any]]] = None,
        deprecated_topology: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        hints: typing.Optional[typing.Union["EndpointHints", typing.Dict[builtins.str, typing.Any]]] = None,
        hostname: typing.Optional[builtins.str] = None,
        node_name: typing.Optional[builtins.str] = None,
        target_ref: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        zone: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Endpoint represents a single logical "backend" implementing a service.

        :param addresses: addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100. These are all assumed to be fungible and clients may choose to only use the first element. Refer to: https://issue.k8s.io/106267
        :param conditions: conditions contains information about the current status of the endpoint.
        :param deprecated_topology: deprecatedTopology contains topology information part of the v1beta1 API. This field is deprecated, and will be removed when the v1beta1 API is removed (no sooner than kubernetes v1.24). While this field can hold values, it is not writable through the v1 API, and any attempts to write to it will be silently ignored. Topology information can be found in the zone and nodeName fields instead.
        :param hints: hints contains information associated with how an endpoint should be consumed.
        :param hostname: hostname of this endpoint. This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.
        :param node_name: nodeName represents the name of the Node hosting this endpoint. This can be used to determine endpoints local to a Node.
        :param target_ref: targetRef is a reference to a Kubernetes object that represents this endpoint.
        :param zone: zone is the name of the Zone this endpoint exists in.

        :schema: io.k8s.api.discovery.v1.Endpoint
        '''
        if isinstance(conditions, dict):
            conditions = EndpointConditions(**conditions)
        if isinstance(hints, dict):
            hints = EndpointHints(**hints)
        if isinstance(target_ref, dict):
            target_ref = ObjectReference(**target_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7901e346d46284ee6bfebc53f5330f0cedc8acd3f3c719e7229e6c20b2a95a5f)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
            check_type(argname="argument deprecated_topology", value=deprecated_topology, expected_type=type_hints["deprecated_topology"])
            check_type(argname="argument hints", value=hints, expected_type=type_hints["hints"])
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument node_name", value=node_name, expected_type=type_hints["node_name"])
            check_type(argname="argument target_ref", value=target_ref, expected_type=type_hints["target_ref"])
            check_type(argname="argument zone", value=zone, expected_type=type_hints["zone"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "addresses": addresses,
        }
        if conditions is not None:
            self._values["conditions"] = conditions
        if deprecated_topology is not None:
            self._values["deprecated_topology"] = deprecated_topology
        if hints is not None:
            self._values["hints"] = hints
        if hostname is not None:
            self._values["hostname"] = hostname
        if node_name is not None:
            self._values["node_name"] = node_name
        if target_ref is not None:
            self._values["target_ref"] = target_ref
        if zone is not None:
            self._values["zone"] = zone

    @builtins.property
    def addresses(self) -> typing.List[builtins.str]:
        '''addresses of this endpoint.

        The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100. These are all assumed to be fungible and clients may choose to only use the first element. Refer to: https://issue.k8s.io/106267

        :schema: io.k8s.api.discovery.v1.Endpoint#addresses
        '''
        result = self._values.get("addresses")
        assert result is not None, "Required property 'addresses' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def conditions(self) -> typing.Optional["EndpointConditions"]:
        '''conditions contains information about the current status of the endpoint.

        :schema: io.k8s.api.discovery.v1.Endpoint#conditions
        '''
        result = self._values.get("conditions")
        return typing.cast(typing.Optional["EndpointConditions"], result)

    @builtins.property
    def deprecated_topology(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''deprecatedTopology contains topology information part of the v1beta1 API.

        This field is deprecated, and will be removed when the v1beta1 API is removed (no sooner than kubernetes v1.24).  While this field can hold values, it is not writable through the v1 API, and any attempts to write to it will be silently ignored. Topology information can be found in the zone and nodeName fields instead.

        :schema: io.k8s.api.discovery.v1.Endpoint#deprecatedTopology
        '''
        result = self._values.get("deprecated_topology")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def hints(self) -> typing.Optional["EndpointHints"]:
        '''hints contains information associated with how an endpoint should be consumed.

        :schema: io.k8s.api.discovery.v1.Endpoint#hints
        '''
        result = self._values.get("hints")
        return typing.cast(typing.Optional["EndpointHints"], result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''hostname of this endpoint.

        This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.

        :schema: io.k8s.api.discovery.v1.Endpoint#hostname
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_name(self) -> typing.Optional[builtins.str]:
        '''nodeName represents the name of the Node hosting this endpoint.

        This can be used to determine endpoints local to a Node.

        :schema: io.k8s.api.discovery.v1.Endpoint#nodeName
        '''
        result = self._values.get("node_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_ref(self) -> typing.Optional["ObjectReference"]:
        '''targetRef is a reference to a Kubernetes object that represents this endpoint.

        :schema: io.k8s.api.discovery.v1.Endpoint#targetRef
        '''
        result = self._values.get("target_ref")
        return typing.cast(typing.Optional["ObjectReference"], result)

    @builtins.property
    def zone(self) -> typing.Optional[builtins.str]:
        '''zone is the name of the Zone this endpoint exists in.

        :schema: io.k8s.api.discovery.v1.Endpoint#zone
        '''
        result = self._values.get("zone")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Endpoint(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EndpointAddress",
    jsii_struct_bases=[],
    name_mapping={
        "ip": "ip",
        "hostname": "hostname",
        "node_name": "nodeName",
        "target_ref": "targetRef",
    },
)
class EndpointAddress:
    def __init__(
        self,
        *,
        ip: builtins.str,
        hostname: typing.Optional[builtins.str] = None,
        node_name: typing.Optional[builtins.str] = None,
        target_ref: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EndpointAddress is a tuple that describes single IP address.

        :param ip: The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).
        :param hostname: The Hostname of this endpoint.
        :param node_name: Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        :param target_ref: Reference to object providing the endpoint.

        :schema: io.k8s.api.core.v1.EndpointAddress
        '''
        if isinstance(target_ref, dict):
            target_ref = ObjectReference(**target_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3152a304931af627183dad377b76801a2dc38f1c279a7681fd591033d9c68952)
            check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument node_name", value=node_name, expected_type=type_hints["node_name"])
            check_type(argname="argument target_ref", value=target_ref, expected_type=type_hints["target_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "ip": ip,
        }
        if hostname is not None:
            self._values["hostname"] = hostname
        if node_name is not None:
            self._values["node_name"] = node_name
        if target_ref is not None:
            self._values["target_ref"] = target_ref

    @builtins.property
    def ip(self) -> builtins.str:
        '''The IP of this endpoint.

        May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).

        :schema: io.k8s.api.core.v1.EndpointAddress#ip
        '''
        result = self._values.get("ip")
        assert result is not None, "Required property 'ip' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''The Hostname of this endpoint.

        :schema: io.k8s.api.core.v1.EndpointAddress#hostname
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_name(self) -> typing.Optional[builtins.str]:
        '''Optional: Node hosting this endpoint.

        This can be used to determine endpoints local to a node.

        :schema: io.k8s.api.core.v1.EndpointAddress#nodeName
        '''
        result = self._values.get("node_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_ref(self) -> typing.Optional["ObjectReference"]:
        '''Reference to object providing the endpoint.

        :schema: io.k8s.api.core.v1.EndpointAddress#targetRef
        '''
        result = self._values.get("target_ref")
        return typing.cast(typing.Optional["ObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointAddress(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EndpointConditions",
    jsii_struct_bases=[],
    name_mapping={
        "ready": "ready",
        "serving": "serving",
        "terminating": "terminating",
    },
)
class EndpointConditions:
    def __init__(
        self,
        *,
        ready: typing.Optional[builtins.bool] = None,
        serving: typing.Optional[builtins.bool] = None,
        terminating: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''EndpointConditions represents the current condition of an endpoint.

        :param ready: ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be "true" for terminating endpoints, except when the normal readiness behavior is being explicitly overridden, for example when the associated Service has set the publishNotReadyAddresses flag.
        :param serving: serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition.
        :param terminating: terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating.

        :schema: io.k8s.api.discovery.v1.EndpointConditions
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83a8d39afdb528af399d7a5554a7b47b0b6718d67f380991cc3841dbe375ed08)
            check_type(argname="argument ready", value=ready, expected_type=type_hints["ready"])
            check_type(argname="argument serving", value=serving, expected_type=type_hints["serving"])
            check_type(argname="argument terminating", value=terminating, expected_type=type_hints["terminating"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ready is not None:
            self._values["ready"] = ready
        if serving is not None:
            self._values["serving"] = serving
        if terminating is not None:
            self._values["terminating"] = terminating

    @builtins.property
    def ready(self) -> typing.Optional[builtins.bool]:
        '''ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint.

        A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be "true" for terminating endpoints, except when the normal readiness behavior is being explicitly overridden, for example when the associated Service has set the publishNotReadyAddresses flag.

        :schema: io.k8s.api.discovery.v1.EndpointConditions#ready
        '''
        result = self._values.get("ready")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def serving(self) -> typing.Optional[builtins.bool]:
        '''serving is identical to ready except that it is set regardless of the terminating state of endpoints.

        This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition.

        :schema: io.k8s.api.discovery.v1.EndpointConditions#serving
        '''
        result = self._values.get("serving")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def terminating(self) -> typing.Optional[builtins.bool]:
        '''terminating indicates that this endpoint is terminating.

        A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating.

        :schema: io.k8s.api.discovery.v1.EndpointConditions#terminating
        '''
        result = self._values.get("terminating")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointConditions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EndpointHints",
    jsii_struct_bases=[],
    name_mapping={"for_zones": "forZones"},
)
class EndpointHints:
    def __init__(
        self,
        *,
        for_zones: typing.Optional[typing.Sequence[typing.Union["ForZone", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''EndpointHints provides hints describing how an endpoint should be consumed.

        :param for_zones: forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing.

        :schema: io.k8s.api.discovery.v1.EndpointHints
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45292e209e7a01a821bc48ed448334deced31eb296ef5a20ac12198272eae695)
            check_type(argname="argument for_zones", value=for_zones, expected_type=type_hints["for_zones"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if for_zones is not None:
            self._values["for_zones"] = for_zones

    @builtins.property
    def for_zones(self) -> typing.Optional[typing.List["ForZone"]]:
        '''forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing.

        :schema: io.k8s.api.discovery.v1.EndpointHints#forZones
        '''
        result = self._values.get("for_zones")
        return typing.cast(typing.Optional[typing.List["ForZone"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointHints(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EndpointPort",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "app_protocol": "appProtocol",
        "name": "name",
        "protocol": "protocol",
    },
)
class EndpointPort:
    def __init__(
        self,
        *,
        port: jsii.Number,
        app_protocol: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional[builtins.str] = None,
    ) -> None:
        '''EndpointPort is a tuple that describes a single port.

        :param port: The port number of the endpoint.
        :param app_protocol: The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either: - Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names). - Kubernetes-defined prefixed names: - 'kubernetes.io/h2c' - HTTP/2 over cleartext as described in https://www.rfc-editor.org/rfc/rfc7540 - 'kubernetes.io/ws' - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455 - 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455 - Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
        :param name: The name of this port. This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
        :param protocol: The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP. Default: TCP.

        :schema: io.k8s.api.core.v1.EndpointPort
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb9ba36c5763e4b2cf992172244d2aaf4b4e9863bf79fdebadc5b19db0d57c47)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument app_protocol", value=app_protocol, expected_type=type_hints["app_protocol"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if app_protocol is not None:
            self._values["app_protocol"] = app_protocol
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def port(self) -> jsii.Number:
        '''The port number of the endpoint.

        :schema: io.k8s.api.core.v1.EndpointPort#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def app_protocol(self) -> typing.Optional[builtins.str]:
        '''The application protocol for this port.

        This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:

        - Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).
        - Kubernetes-defined prefixed names:
        - 'kubernetes.io/h2c' - HTTP/2 over cleartext as described in https://www.rfc-editor.org/rfc/rfc7540
        - 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
        - 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455
        - Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.

        :schema: io.k8s.api.core.v1.EndpointPort#appProtocol
        '''
        result = self._values.get("app_protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port.

        This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.

        :schema: io.k8s.api.core.v1.EndpointPort#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional[builtins.str]:
        '''The IP protocol for this port.

        Must be UDP, TCP, or SCTP. Default is TCP.

        :default: TCP.

        :schema: io.k8s.api.core.v1.EndpointPort#protocol
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EndpointSubset",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "not_ready_addresses": "notReadyAddresses",
        "ports": "ports",
    },
)
class EndpointSubset:
    def __init__(
        self,
        *,
        addresses: typing.Optional[typing.Sequence[typing.Union[EndpointAddress, typing.Dict[builtins.str, typing.Any]]]] = None,
        not_ready_addresses: typing.Optional[typing.Sequence[typing.Union[EndpointAddress, typing.Dict[builtins.str, typing.Any]]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPort, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''EndpointSubset is a group of addresses with a common set of ports.

        The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:

        {
        Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        }

        The resulting set of endpoints can be viewed as:

        a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
        b: [ 10.10.1.1:309, 10.10.2.2:309 ]

        :param addresses: IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        :param not_ready_addresses: IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        :param ports: Port numbers available on the related IP addresses.

        :schema: io.k8s.api.core.v1.EndpointSubset
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f6a8137a7e15fca4e80e949cdad7daa17d00596f0ea2c4d9248fa8d0f5f53e9)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument not_ready_addresses", value=not_ready_addresses, expected_type=type_hints["not_ready_addresses"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if addresses is not None:
            self._values["addresses"] = addresses
        if not_ready_addresses is not None:
            self._values["not_ready_addresses"] = not_ready_addresses
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def addresses(self) -> typing.Optional[typing.List[EndpointAddress]]:
        '''IP addresses which offer the related ports that are marked as ready.

        These endpoints should be considered safe for load balancers and clients to utilize.

        :schema: io.k8s.api.core.v1.EndpointSubset#addresses
        '''
        result = self._values.get("addresses")
        return typing.cast(typing.Optional[typing.List[EndpointAddress]], result)

    @builtins.property
    def not_ready_addresses(self) -> typing.Optional[typing.List[EndpointAddress]]:
        '''IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.

        :schema: io.k8s.api.core.v1.EndpointSubset#notReadyAddresses
        '''
        result = self._values.get("not_ready_addresses")
        return typing.cast(typing.Optional[typing.List[EndpointAddress]], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[EndpointPort]]:
        '''Port numbers available on the related IP addresses.

        :schema: io.k8s.api.core.v1.EndpointSubset#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[EndpointPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointSubset(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EnvFromSource",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_ref": "configMapRef",
        "prefix": "prefix",
        "secret_ref": "secretRef",
    },
)
class EnvFromSource:
    def __init__(
        self,
        *,
        config_map_ref: typing.Optional[typing.Union[ConfigMapEnvSource, typing.Dict[builtins.str, typing.Any]]] = None,
        prefix: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional[typing.Union["SecretEnvSource", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EnvFromSource represents the source of a set of ConfigMaps.

        :param config_map_ref: The ConfigMap to select from.
        :param prefix: An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        :param secret_ref: The Secret to select from.

        :schema: io.k8s.api.core.v1.EnvFromSource
        '''
        if isinstance(config_map_ref, dict):
            config_map_ref = ConfigMapEnvSource(**config_map_ref)
        if isinstance(secret_ref, dict):
            secret_ref = SecretEnvSource(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8873d87c9a3ae5362feee1fe2fe552a991e1f61c17983a18a5452685fe87e57)
            check_type(argname="argument config_map_ref", value=config_map_ref, expected_type=type_hints["config_map_ref"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if config_map_ref is not None:
            self._values["config_map_ref"] = config_map_ref
        if prefix is not None:
            self._values["prefix"] = prefix
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def config_map_ref(self) -> typing.Optional[ConfigMapEnvSource]:
        '''The ConfigMap to select from.

        :schema: io.k8s.api.core.v1.EnvFromSource#configMapRef
        '''
        result = self._values.get("config_map_ref")
        return typing.cast(typing.Optional[ConfigMapEnvSource], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''An optional identifier to prepend to each key in the ConfigMap.

        Must be a C_IDENTIFIER.

        :schema: io.k8s.api.core.v1.EnvFromSource#prefix
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretEnvSource"]:
        '''The Secret to select from.

        :schema: io.k8s.api.core.v1.EnvFromSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretEnvSource"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvFromSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EnvVar",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value", "value_from": "valueFrom"},
)
class EnvVar:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
        value_from: typing.Optional[typing.Union["EnvVarSource", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EnvVar represents an environment variable present in a Container.

        :param name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param value: Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". Default: .
        :param value_from: Source for the environment variable's value. Cannot be used if value is not empty.

        :schema: io.k8s.api.core.v1.EnvVar
        '''
        if isinstance(value_from, dict):
            value_from = EnvVarSource(**value_from)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c80963661c0575706a17d0cbcddbf343dd89054076a4dc2330adf12e37cc1b55)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument value_from", value=value_from, expected_type=type_hints["value_from"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value
        if value_from is not None:
            self._values["value_from"] = value_from

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the environment variable.

        Must be a C_IDENTIFIER.

        :schema: io.k8s.api.core.v1.EnvVar#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables.

        If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".

        :default: .

        :schema: io.k8s.api.core.v1.EnvVar#value
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value_from(self) -> typing.Optional["EnvVarSource"]:
        '''Source for the environment variable's value.

        Cannot be used if value is not empty.

        :schema: io.k8s.api.core.v1.EnvVar#valueFrom
        '''
        result = self._values.get("value_from")
        return typing.cast(typing.Optional["EnvVarSource"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvVar(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EnvVarSource",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_key_ref": "configMapKeyRef",
        "field_ref": "fieldRef",
        "resource_field_ref": "resourceFieldRef",
        "secret_key_ref": "secretKeyRef",
    },
)
class EnvVarSource:
    def __init__(
        self,
        *,
        config_map_key_ref: typing.Optional[typing.Union[ConfigMapKeySelector, typing.Dict[builtins.str, typing.Any]]] = None,
        field_ref: typing.Optional[typing.Union["ObjectFieldSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        resource_field_ref: typing.Optional[typing.Union["ResourceFieldSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        secret_key_ref: typing.Optional[typing.Union["SecretKeySelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EnvVarSource represents a source for the value of an EnvVar.

        :param config_map_key_ref: Selects a key of a ConfigMap.
        :param field_ref: Selects a field of the pod: supports metadata.name, metadata.namespace, ``metadata.labels['<KEY>']``, ``metadata.annotations['<KEY>']``, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
        :param resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        :param secret_key_ref: Selects a key of a secret in the pod's namespace.

        :schema: io.k8s.api.core.v1.EnvVarSource
        '''
        if isinstance(config_map_key_ref, dict):
            config_map_key_ref = ConfigMapKeySelector(**config_map_key_ref)
        if isinstance(field_ref, dict):
            field_ref = ObjectFieldSelector(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = ResourceFieldSelector(**resource_field_ref)
        if isinstance(secret_key_ref, dict):
            secret_key_ref = SecretKeySelector(**secret_key_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8fdc9eadd8cdb6518e41ff4504d18257cad1add1d5536d35f4fbdb88febe061)
            check_type(argname="argument config_map_key_ref", value=config_map_key_ref, expected_type=type_hints["config_map_key_ref"])
            check_type(argname="argument field_ref", value=field_ref, expected_type=type_hints["field_ref"])
            check_type(argname="argument resource_field_ref", value=resource_field_ref, expected_type=type_hints["resource_field_ref"])
            check_type(argname="argument secret_key_ref", value=secret_key_ref, expected_type=type_hints["secret_key_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if config_map_key_ref is not None:
            self._values["config_map_key_ref"] = config_map_key_ref
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref
        if secret_key_ref is not None:
            self._values["secret_key_ref"] = secret_key_ref

    @builtins.property
    def config_map_key_ref(self) -> typing.Optional[ConfigMapKeySelector]:
        '''Selects a key of a ConfigMap.

        :schema: io.k8s.api.core.v1.EnvVarSource#configMapKeyRef
        '''
        result = self._values.get("config_map_key_ref")
        return typing.cast(typing.Optional[ConfigMapKeySelector], result)

    @builtins.property
    def field_ref(self) -> typing.Optional["ObjectFieldSelector"]:
        '''Selects a field of the pod: supports metadata.name, metadata.namespace, ``metadata.labels['<KEY>']``, ``metadata.annotations['<KEY>']``, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.

        :schema: io.k8s.api.core.v1.EnvVarSource#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["ObjectFieldSelector"], result)

    @builtins.property
    def resource_field_ref(self) -> typing.Optional["ResourceFieldSelector"]:
        '''Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.

        :schema: io.k8s.api.core.v1.EnvVarSource#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["ResourceFieldSelector"], result)

    @builtins.property
    def secret_key_ref(self) -> typing.Optional["SecretKeySelector"]:
        '''Selects a key of a secret in the pod's namespace.

        :schema: io.k8s.api.core.v1.EnvVarSource#secretKeyRef
        '''
        result = self._values.get("secret_key_ref")
        return typing.cast(typing.Optional["SecretKeySelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvVarSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EphemeralContainer",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "args": "args",
        "command": "command",
        "env": "env",
        "env_from": "envFrom",
        "image": "image",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness_probe": "livenessProbe",
        "ports": "ports",
        "readiness_probe": "readinessProbe",
        "resize_policy": "resizePolicy",
        "resources": "resources",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "startup_probe": "startupProbe",
        "stdin": "stdin",
        "stdin_once": "stdinOnce",
        "target_container_name": "targetContainerName",
        "termination_message_path": "terminationMessagePath",
        "termination_message_policy": "terminationMessagePolicy",
        "tty": "tty",
        "volume_devices": "volumeDevices",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class EphemeralContainer:
    def __init__(
        self,
        *,
        name: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env: typing.Optional[typing.Sequence[typing.Union[EnvVar, typing.Dict[builtins.str, typing.Any]]]] = None,
        env_from: typing.Optional[typing.Sequence[typing.Union[EnvFromSource, typing.Dict[builtins.str, typing.Any]]]] = None,
        image: typing.Optional[builtins.str] = None,
        image_pull_policy: typing.Optional[builtins.str] = None,
        lifecycle: typing.Optional[typing.Union["Lifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        liveness_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        resize_policy: typing.Optional[typing.Sequence[typing.Union[ContainerResizePolicy, typing.Dict[builtins.str, typing.Any]]]] = None,
        resources: typing.Optional[typing.Union["ResourceRequirements", typing.Dict[builtins.str, typing.Any]]] = None,
        restart_policy: typing.Optional[builtins.str] = None,
        security_context: typing.Optional[typing.Union["SecurityContext", typing.Dict[builtins.str, typing.Any]]] = None,
        startup_probe: typing.Optional[typing.Union["Probe", typing.Dict[builtins.str, typing.Any]]] = None,
        stdin: typing.Optional[builtins.bool] = None,
        stdin_once: typing.Optional[builtins.bool] = None,
        target_container_name: typing.Optional[builtins.str] = None,
        termination_message_path: typing.Optional[builtins.str] = None,
        termination_message_policy: typing.Optional[builtins.str] = None,
        tty: typing.Optional[builtins.bool] = None,
        volume_devices: typing.Optional[typing.Sequence[typing.Union["VolumeDevice", typing.Dict[builtins.str, typing.Any]]]] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''An EphemeralContainer is a temporary container that you may add to an existing Pod for user-initiated activities such as debugging.

        Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a Pod is removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the Pod to exceed its resource allocation.

        To add an ephemeral container, use the ephemeralcontainers subresource of an existing Pod. Ephemeral containers may not be removed or restarted.

        :param name: Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.
        :param args: Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param command: Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param env: List of environment variables to set in the container. Cannot be updated.
        :param env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param image: Container image name. More info: https://kubernetes.io/docs/concepts/containers/images
        :param image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images Default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param lifecycle: Lifecycle is not allowed for ephemeral containers.
        :param liveness_probe: Probes are not allowed for ephemeral containers.
        :param ports: Ports are not allowed for ephemeral containers.
        :param readiness_probe: Probes are not allowed for ephemeral containers.
        :param resize_policy: Resources resize policy for the container.
        :param resources: Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.
        :param restart_policy: Restart policy for the container to manage the restart behavior of each container within a pod. This may only be set for init containers. You cannot set this field on ephemeral containers.
        :param security_context: Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.
        :param startup_probe: Probes are not allowed for ephemeral containers.
        :param stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. Default: false.
        :param stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false Default: false
        :param target_container_name: If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec. The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.
        :param termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. Default: dev/termination-log. Cannot be updated.
        :param termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. Default: File. Cannot be updated.
        :param tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. Default: false.
        :param volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer
        '''
        if isinstance(lifecycle, dict):
            lifecycle = Lifecycle(**lifecycle)
        if isinstance(liveness_probe, dict):
            liveness_probe = Probe(**liveness_probe)
        if isinstance(readiness_probe, dict):
            readiness_probe = Probe(**readiness_probe)
        if isinstance(resources, dict):
            resources = ResourceRequirements(**resources)
        if isinstance(security_context, dict):
            security_context = SecurityContext(**security_context)
        if isinstance(startup_probe, dict):
            startup_probe = Probe(**startup_probe)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__850ac5161aff92a19c97b67456deba3901a5b0366d337572055f9c4f6a6d7f99)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env", value=env, expected_type=type_hints["env"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness_probe", value=liveness_probe, expected_type=type_hints["liveness_probe"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness_probe", value=readiness_probe, expected_type=type_hints["readiness_probe"])
            check_type(argname="argument resize_policy", value=resize_policy, expected_type=type_hints["resize_policy"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup_probe", value=startup_probe, expected_type=type_hints["startup_probe"])
            check_type(argname="argument stdin", value=stdin, expected_type=type_hints["stdin"])
            check_type(argname="argument stdin_once", value=stdin_once, expected_type=type_hints["stdin_once"])
            check_type(argname="argument target_container_name", value=target_container_name, expected_type=type_hints["target_container_name"])
            check_type(argname="argument termination_message_path", value=termination_message_path, expected_type=type_hints["termination_message_path"])
            check_type(argname="argument termination_message_policy", value=termination_message_policy, expected_type=type_hints["termination_message_policy"])
            check_type(argname="argument tty", value=tty, expected_type=type_hints["tty"])
            check_type(argname="argument volume_devices", value=volume_devices, expected_type=type_hints["volume_devices"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env is not None:
            self._values["env"] = env
        if env_from is not None:
            self._values["env_from"] = env_from
        if image is not None:
            self._values["image"] = image
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness_probe is not None:
            self._values["liveness_probe"] = liveness_probe
        if ports is not None:
            self._values["ports"] = ports
        if readiness_probe is not None:
            self._values["readiness_probe"] = readiness_probe
        if resize_policy is not None:
            self._values["resize_policy"] = resize_policy
        if resources is not None:
            self._values["resources"] = resources
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup_probe is not None:
            self._values["startup_probe"] = startup_probe
        if stdin is not None:
            self._values["stdin"] = stdin
        if stdin_once is not None:
            self._values["stdin_once"] = stdin_once
        if target_container_name is not None:
            self._values["target_container_name"] = target_container_name
        if termination_message_path is not None:
            self._values["termination_message_path"] = termination_message_path
        if termination_message_policy is not None:
            self._values["termination_message_policy"] = termination_message_policy
        if tty is not None:
            self._values["tty"] = tty
        if volume_devices is not None:
            self._values["volume_devices"] = volume_devices
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the ephemeral container specified as a DNS_LABEL.

        This name must be unique among all containers, init containers and ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint.

        The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :schema: io.k8s.api.core.v1.EphemeralContainer#args
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :schema: io.k8s.api.core.v1.EphemeralContainer#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env(self) -> typing.Optional[typing.List[EnvVar]]:
        '''List of environment variables to set in the container.

        Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#env
        '''
        result = self._values.get("env")
        return typing.cast(typing.Optional[typing.List[EnvVar]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List[EnvFromSource]]:
        '''List of sources to populate environment variables in the container.

        The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#envFrom
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List[EnvFromSource]], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''Container image name.

        More info: https://kubernetes.io/docs/concepts/containers/images

        :schema: io.k8s.api.core.v1.EphemeralContainer#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional[builtins.str]:
        '''Image pull policy.

        One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :schema: io.k8s.api.core.v1.EphemeralContainer#imagePullPolicy
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional["Lifecycle"]:
        '''Lifecycle is not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#lifecycle
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional["Lifecycle"], result)

    @builtins.property
    def liveness_probe(self) -> typing.Optional["Probe"]:
        '''Probes are not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#livenessProbe
        '''
        result = self._values.get("liveness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ContainerPort]]:
        '''Ports are not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ContainerPort]], result)

    @builtins.property
    def readiness_probe(self) -> typing.Optional["Probe"]:
        '''Probes are not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#readinessProbe
        '''
        result = self._values.get("readiness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resize_policy(self) -> typing.Optional[typing.List[ContainerResizePolicy]]:
        '''Resources resize policy for the container.

        :schema: io.k8s.api.core.v1.EphemeralContainer#resizePolicy
        '''
        result = self._values.get("resize_policy")
        return typing.cast(typing.Optional[typing.List[ContainerResizePolicy]], result)

    @builtins.property
    def resources(self) -> typing.Optional["ResourceRequirements"]:
        '''Resources are not allowed for ephemeral containers.

        Ephemeral containers use spare resources already allocated to the pod.

        :schema: io.k8s.api.core.v1.EphemeralContainer#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ResourceRequirements"], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[builtins.str]:
        '''Restart policy for the container to manage the restart behavior of each container within a pod.

        This may only be set for init containers. You cannot set this field on ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#restartPolicy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def security_context(self) -> typing.Optional["SecurityContext"]:
        '''Optional: SecurityContext defines the security options the ephemeral container should be run with.

        If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.

        :schema: io.k8s.api.core.v1.EphemeralContainer#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["SecurityContext"], result)

    @builtins.property
    def startup_probe(self) -> typing.Optional["Probe"]:
        '''Probes are not allowed for ephemeral containers.

        :schema: io.k8s.api.core.v1.EphemeralContainer#startupProbe
        '''
        result = self._values.get("startup_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def stdin(self) -> typing.Optional[builtins.bool]:
        '''Whether this container should allocate a buffer for stdin in the container runtime.

        If this is not set, reads from stdin in the container will always result in EOF. Default is false.

        :default: false.

        :schema: io.k8s.api.core.v1.EphemeralContainer#stdin
        '''
        result = self._values.get("stdin")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def stdin_once(self) -> typing.Optional[builtins.bool]:
        '''Whether the container runtime should close the stdin channel after it has been opened by a single attach.

        When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false

        :default: false

        :schema: io.k8s.api.core.v1.EphemeralContainer#stdinOnce
        '''
        result = self._values.get("stdin_once")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def target_container_name(self) -> typing.Optional[builtins.str]:
        '''If set, the name of the container from PodSpec that this ephemeral container targets.

        The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec.

        The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.

        :schema: io.k8s.api.core.v1.EphemeralContainer#targetContainerName
        '''
        result = self._values.get("target_container_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def termination_message_path(self) -> typing.Optional[builtins.str]:
        '''Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem.

        Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.

        :default: dev/termination-log. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#terminationMessagePath
        '''
        result = self._values.get("termination_message_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def termination_message_policy(self) -> typing.Optional[builtins.str]:
        '''Indicate how the termination message should be populated.

        File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.

        :default: File. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#terminationMessagePolicy
        '''
        result = self._values.get("termination_message_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tty(self) -> typing.Optional[builtins.bool]:
        '''Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.

        Default is false.

        :default: false.

        :schema: io.k8s.api.core.v1.EphemeralContainer#tty
        '''
        result = self._values.get("tty")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_devices(self) -> typing.Optional[typing.List["VolumeDevice"]]:
        '''volumeDevices is the list of block devices to be used by the container.

        :schema: io.k8s.api.core.v1.EphemeralContainer#volumeDevices
        '''
        result = self._values.get("volume_devices")
        return typing.cast(typing.Optional[typing.List["VolumeDevice"]], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Subpath mounts are not allowed for ephemeral containers. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#volumeMounts
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :schema: io.k8s.api.core.v1.EphemeralContainer#workingDir
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EphemeralContainer(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EphemeralVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"volume_claim_template": "volumeClaimTemplate"},
)
class EphemeralVolumeSource:
    def __init__(
        self,
        *,
        volume_claim_template: typing.Optional[typing.Union["PersistentVolumeClaimTemplate", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Represents an ephemeral volume that is handled by a normal storage driver.

        :param volume_claim_template: Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod. The name of the PVC will be ``<pod name>-<volume name>`` where ``<volume name>`` is the name from the ``PodSpec.Volumes`` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long). An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster. This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created. Required, must not be nil.

        :schema: io.k8s.api.core.v1.EphemeralVolumeSource
        '''
        if isinstance(volume_claim_template, dict):
            volume_claim_template = PersistentVolumeClaimTemplate(**volume_claim_template)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bc39cfb1980149fff31f4c177e0379dd4edf673d5de9c5c9494b2c1f02799a03)
            check_type(argname="argument volume_claim_template", value=volume_claim_template, expected_type=type_hints["volume_claim_template"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if volume_claim_template is not None:
            self._values["volume_claim_template"] = volume_claim_template

    @builtins.property
    def volume_claim_template(self) -> typing.Optional["PersistentVolumeClaimTemplate"]:
        '''Will be used to create a stand-alone PVC to provision the volume.

        The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be ``<pod name>-<volume name>`` where ``<volume name>`` is the name from the ``PodSpec.Volumes`` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).

        An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.

        This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.

        Required, must not be nil.

        :schema: io.k8s.api.core.v1.EphemeralVolumeSource#volumeClaimTemplate
        '''
        result = self._values.get("volume_claim_template")
        return typing.cast(typing.Optional["PersistentVolumeClaimTemplate"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EphemeralVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EventSeries",
    jsii_struct_bases=[],
    name_mapping={"count": "count", "last_observed_time": "lastObservedTime"},
)
class EventSeries:
    def __init__(
        self,
        *,
        count: jsii.Number,
        last_observed_time: datetime.datetime,
    ) -> None:
        '''EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. How often to update the EventSeries is up to the event reporters. The default event reporter in "k8s.io/client-go/tools/events/event_broadcaster.go" shows how this struct is updated on heartbeats and can guide customized reporter implementations.

        :param count: count is the number of occurrences in this series up to the last heartbeat time.
        :param last_observed_time: lastObservedTime is the time when last Event from the series was seen before last heartbeat.

        :schema: io.k8s.api.events.v1.EventSeries
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a261ef5d6eedcd74c1c03a658875c5acd8269fe7ac4e022ed2f7317259241f7)
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument last_observed_time", value=last_observed_time, expected_type=type_hints["last_observed_time"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "count": count,
            "last_observed_time": last_observed_time,
        }

    @builtins.property
    def count(self) -> jsii.Number:
        '''count is the number of occurrences in this series up to the last heartbeat time.

        :schema: io.k8s.api.events.v1.EventSeries#count
        '''
        result = self._values.get("count")
        assert result is not None, "Required property 'count' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def last_observed_time(self) -> datetime.datetime:
        '''lastObservedTime is the time when last Event from the series was seen before last heartbeat.

        :schema: io.k8s.api.events.v1.EventSeries#lastObservedTime
        '''
        result = self._values.get("last_observed_time")
        assert result is not None, "Required property 'last_observed_time' is missing"
        return typing.cast(datetime.datetime, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EventSeries(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.EventSource",
    jsii_struct_bases=[],
    name_mapping={"component": "component", "host": "host"},
)
class EventSource:
    def __init__(
        self,
        *,
        component: typing.Optional[builtins.str] = None,
        host: typing.Optional[builtins.str] = None,
    ) -> None:
        '''EventSource contains information for an event.

        :param component: Component from which the event is generated.
        :param host: Node name on which the event is generated.

        :schema: io.k8s.api.core.v1.EventSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53ff9d260066ecb254f26de3461e3f46defa2be36a0ca3089966ca0a78bc243d)
            check_type(argname="argument component", value=component, expected_type=type_hints["component"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if component is not None:
            self._values["component"] = component
        if host is not None:
            self._values["host"] = host

    @builtins.property
    def component(self) -> typing.Optional[builtins.str]:
        '''Component from which the event is generated.

        :schema: io.k8s.api.core.v1.EventSource#component
        '''
        result = self._values.get("component")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''Node name on which the event is generated.

        :schema: io.k8s.api.core.v1.EventSource#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EventSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ExecAction",
    jsii_struct_bases=[],
    name_mapping={"command": "command"},
)
class ExecAction:
    def __init__(
        self,
        *,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''ExecAction describes a "run in container" action.

        :param command: Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.

        :schema: io.k8s.api.core.v1.ExecAction
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc73e53efd152a7b5c8faed2d5c01333152a886cbe3c3106edc7c0bd2e45aea6)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if command is not None:
            self._values["command"] = command

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem.

        The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.

        :schema: io.k8s.api.core.v1.ExecAction#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExecAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ExemptPriorityLevelConfigurationV1Beta2",
    jsii_struct_bases=[],
    name_mapping={
        "lendable_percent": "lendablePercent",
        "nominal_concurrency_shares": "nominalConcurrencyShares",
    },
)
class ExemptPriorityLevelConfigurationV1Beta2:
    def __init__(
        self,
        *,
        lendable_percent: typing.Optional[jsii.Number] = None,
        nominal_concurrency_shares: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests.

        In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the ``spec``.

        :param lendable_percent: ``lendablePercent`` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows. LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param nominal_concurrency_shares: ``nominalConcurrencyShares`` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values: NominalCL(i) = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k) Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.

        :schema: io.k8s.api.flowcontrol.v1beta2.ExemptPriorityLevelConfiguration
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e79d126edd00ccc2b2586675cfdfe30f93d20bce11628cf4d05863fb6c05671)
            check_type(argname="argument lendable_percent", value=lendable_percent, expected_type=type_hints["lendable_percent"])
            check_type(argname="argument nominal_concurrency_shares", value=nominal_concurrency_shares, expected_type=type_hints["nominal_concurrency_shares"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if lendable_percent is not None:
            self._values["lendable_percent"] = lendable_percent
        if nominal_concurrency_shares is not None:
            self._values["nominal_concurrency_shares"] = nominal_concurrency_shares

    @builtins.property
    def lendable_percent(self) -> typing.Optional[jsii.Number]:
        '''``lendablePercent`` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.

        This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )

        :schema: io.k8s.api.flowcontrol.v1beta2.ExemptPriorityLevelConfiguration#lendablePercent
        '''
        result = self._values.get("lendable_percent")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def nominal_concurrency_shares(self) -> typing.Optional[jsii.Number]:
        '''``nominalConcurrencyShares`` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level.

        This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.

        :schema: io.k8s.api.flowcontrol.v1beta2.ExemptPriorityLevelConfiguration#nominalConcurrencyShares
        '''
        result = self._values.get("nominal_concurrency_shares")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExemptPriorityLevelConfigurationV1Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ExemptPriorityLevelConfigurationV1Beta3",
    jsii_struct_bases=[],
    name_mapping={
        "lendable_percent": "lendablePercent",
        "nominal_concurrency_shares": "nominalConcurrencyShares",
    },
)
class ExemptPriorityLevelConfigurationV1Beta3:
    def __init__(
        self,
        *,
        lendable_percent: typing.Optional[jsii.Number] = None,
        nominal_concurrency_shares: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests.

        In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the ``spec``.

        :param lendable_percent: ``lendablePercent`` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows. LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param nominal_concurrency_shares: ``nominalConcurrencyShares`` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values: NominalCL(i) = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k) Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.

        :schema: io.k8s.api.flowcontrol.v1beta3.ExemptPriorityLevelConfiguration
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb3a2574e5c4beb3a3eeeef16eedfbe620147b3e80d6cd1ecb866b00d8fa0d1a)
            check_type(argname="argument lendable_percent", value=lendable_percent, expected_type=type_hints["lendable_percent"])
            check_type(argname="argument nominal_concurrency_shares", value=nominal_concurrency_shares, expected_type=type_hints["nominal_concurrency_shares"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if lendable_percent is not None:
            self._values["lendable_percent"] = lendable_percent
        if nominal_concurrency_shares is not None:
            self._values["nominal_concurrency_shares"] = nominal_concurrency_shares

    @builtins.property
    def lendable_percent(self) -> typing.Optional[jsii.Number]:
        '''``lendablePercent`` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.

        This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )

        :schema: io.k8s.api.flowcontrol.v1beta3.ExemptPriorityLevelConfiguration#lendablePercent
        '''
        result = self._values.get("lendable_percent")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def nominal_concurrency_shares(self) -> typing.Optional[jsii.Number]:
        '''``nominalConcurrencyShares`` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level.

        This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.

        :schema: io.k8s.api.flowcontrol.v1beta3.ExemptPriorityLevelConfiguration#nominalConcurrencyShares
        '''
        result = self._values.get("nominal_concurrency_shares")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExemptPriorityLevelConfigurationV1Beta3(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ExternalDocumentation",
    jsii_struct_bases=[],
    name_mapping={"description": "description", "url": "url"},
)
class ExternalDocumentation:
    def __init__(
        self,
        *,
        description: typing.Optional[builtins.str] = None,
        url: typing.Optional[builtins.str] = None,
    ) -> None:
        '''ExternalDocumentation allows referencing an external resource for extended documentation.

        :param description: 
        :param url: 

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d3cc09c2c06eb584688e166da4f901d63a8240a05ee771f1dbeba0c47870b6c)
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if description is not None:
            self._values["description"] = description
        if url is not None:
            self._values["url"] = url

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def url(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation#url
        '''
        result = self._values.get("url")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExternalDocumentation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ExternalMetricSourceV2",
    jsii_struct_bases=[],
    name_mapping={"metric": "metric", "target": "target"},
)
class ExternalMetricSourceV2:
    def __init__(
        self,
        *,
        metric: typing.Union["MetricIdentifierV2", typing.Dict[builtins.str, typing.Any]],
        target: typing.Union["MetricTargetV2", typing.Dict[builtins.str, typing.Any]],
    ) -> None:
        '''ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).

        :param metric: metric identifies the target metric by name and selector.
        :param target: target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2.ExternalMetricSource
        '''
        if isinstance(metric, dict):
            metric = MetricIdentifierV2(**metric)
        if isinstance(target, dict):
            target = MetricTargetV2(**target)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6344e9c61465a65e10b7833c7653db017a06647aeec2e72d025be9be253dce93)
            check_type(argname="argument metric", value=metric, expected_type=type_hints["metric"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "metric": metric,
            "target": target,
        }

    @builtins.property
    def metric(self) -> "MetricIdentifierV2":
        '''metric identifies the target metric by name and selector.

        :schema: io.k8s.api.autoscaling.v2.ExternalMetricSource#metric
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast("MetricIdentifierV2", result)

    @builtins.property
    def target(self) -> "MetricTargetV2":
        '''target specifies the target value for the given metric.

        :schema: io.k8s.api.autoscaling.v2.ExternalMetricSource#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTargetV2", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExternalMetricSourceV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.FcVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "lun": "lun",
        "read_only": "readOnly",
        "target_ww_ns": "targetWwNs",
        "wwids": "wwids",
    },
)
class FcVolumeSource:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        lun: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        target_ww_ns: typing.Optional[typing.Sequence[builtins.str]] = None,
        wwids: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Represents a Fibre Channel volume.

        Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.

        :param fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param lun: lun is Optional: FC target lun number.
        :param read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param target_ww_ns: targetWWNs is Optional: FC target worldwide names (WWNs).
        :param wwids: wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.

        :schema: io.k8s.api.core.v1.FCVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__118559d8b457c74d1c601718181ca783f0d183f6e01f17d7a4969699cc10b171)
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument lun", value=lun, expected_type=type_hints["lun"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument target_ww_ns", value=target_ww_ns, expected_type=type_hints["target_ww_ns"])
            check_type(argname="argument wwids", value=wwids, expected_type=type_hints["wwids"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if lun is not None:
            self._values["lun"] = lun
        if read_only is not None:
            self._values["read_only"] = read_only
        if target_ww_ns is not None:
            self._values["target_ww_ns"] = target_ww_ns
        if wwids is not None:
            self._values["wwids"] = wwids

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.

        :schema: io.k8s.api.core.v1.FCVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lun(self) -> typing.Optional[jsii.Number]:
        '''lun is Optional: FC target lun number.

        :schema: io.k8s.api.core.v1.FCVolumeSource#lun
        '''
        result = self._values.get("lun")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.FCVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def target_ww_ns(self) -> typing.Optional[typing.List[builtins.str]]:
        '''targetWWNs is Optional: FC target worldwide names (WWNs).

        :schema: io.k8s.api.core.v1.FCVolumeSource#targetWWNs
        '''
        result = self._values.get("target_ww_ns")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def wwids(self) -> typing.Optional[typing.List[builtins.str]]:
        '''wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.

        :schema: io.k8s.api.core.v1.FCVolumeSource#wwids
        '''
        result = self._values.get("wwids")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FcVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.FlexPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "options": "options",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class FlexPersistentVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        options: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.

        :param driver: driver is the name of the driver to use for this volume.
        :param fs_type: fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param options: options is Optional: this field holds extra command options if any.
        :param read_only: readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_ref: secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79d21a28929e1f1598b87095a2fb31a66c49ab22337e475d245e8ab308db2e97)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument options", value=options, expected_type=type_hints["options"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if options is not None:
            self._values["options"] = options
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the driver to use for this volume.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''options is Optional: this field holds extra command options if any.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#options
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.

        This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlexPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.FlexVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "options": "options",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class FlexVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        options: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.

        :param driver: driver is the name of the driver to use for this volume.
        :param fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param options: options is Optional: this field holds extra command options if any.
        :param read_only: readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_ref: secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :schema: io.k8s.api.core.v1.FlexVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6babf38c2703ac9daabe537f5ae10171af3880a43a03105d167d2deb49a9a054)
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument options", value=options, expected_type=type_hints["options"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if options is not None:
            self._values["options"] = options
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def driver(self) -> builtins.str:
        '''driver is the name of the driver to use for this volume.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''options is Optional: this field holds extra command options if any.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#options
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly is Optional: defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.

        This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :schema: io.k8s.api.core.v1.FlexVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlexVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.FlockerVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"dataset_name": "datasetName", "dataset_uuid": "datasetUuid"},
)
class FlockerVolumeSource:
    def __init__(
        self,
        *,
        dataset_name: typing.Optional[builtins.str] = None,
        dataset_uuid: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a Flocker volume mounted by the Flocker agent.

        One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.

        :param dataset_name: datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated.
        :param dataset_uuid: datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset

        :schema: io.k8s.api.core.v1.FlockerVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ede146499922de45f3fdecac3ee2a23aa468cdf3f2d1f7b7038ecffc4d6188a)
            check_type(argname="argument dataset_name", value=dataset_name, expected_type=type_hints["dataset_name"])
            check_type(argname="argument dataset_uuid", value=dataset_uuid, expected_type=type_hints["dataset_uuid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if dataset_name is not None:
            self._values["dataset_name"] = dataset_name
        if dataset_uuid is not None:
            self._values["dataset_uuid"] = dataset_uuid

    @builtins.property
    def dataset_name(self) -> typing.Optional[builtins.str]:
        '''datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated.

        :schema: io.k8s.api.core.v1.FlockerVolumeSource#datasetName
        '''
        result = self._values.get("dataset_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dataset_uuid(self) -> typing.Optional[builtins.str]:
        '''datasetUUID is the UUID of the dataset.

        This is unique identifier of a Flocker dataset

        :schema: io.k8s.api.core.v1.FlockerVolumeSource#datasetUUID
        '''
        result = self._values.get("dataset_uuid")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlockerVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.FlowDistinguisherMethodV1Beta2",
    jsii_struct_bases=[],
    name_mapping={"type": "type"},
)
class FlowDistinguisherMethodV1Beta2:
    def __init__(self, *, type: builtins.str) -> None:
        '''FlowDistinguisherMethod specifies the method of a flow distinguisher.

        :param type: ``type`` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4aac119fd213f564a195b1aab1395895f15e8281b7fcf9d4a0ccd03c5eafa3d)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "type": type,
        }

    @builtins.property
    def type(self) -> builtins.str:
        '''``type`` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace".

        Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlowDistinguisherMethodV1Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.FlowDistinguisherMethodV1Beta3",
    jsii_struct_bases=[],
    name_mapping={"type": "type"},
)
class FlowDistinguisherMethodV1Beta3:
    def __init__(self, *, type: builtins.str) -> None:
        '''FlowDistinguisherMethod specifies the method of a flow distinguisher.

        :param type: ``type`` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowDistinguisherMethod
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ac04f7b564cfc7144d1e62a1fdf7258b2b2d9d0bb572ff852125f1d8df12c670)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "type": type,
        }

    @builtins.property
    def type(self) -> builtins.str:
        '''``type`` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace".

        Required.

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowDistinguisherMethod#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlowDistinguisherMethodV1Beta3(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.FlowSchemaSpecV1Beta2",
    jsii_struct_bases=[],
    name_mapping={
        "priority_level_configuration": "priorityLevelConfiguration",
        "distinguisher_method": "distinguisherMethod",
        "matching_precedence": "matchingPrecedence",
        "rules": "rules",
    },
)
class FlowSchemaSpecV1Beta2:
    def __init__(
        self,
        *,
        priority_level_configuration: typing.Union["PriorityLevelConfigurationReferenceV1Beta2", typing.Dict[builtins.str, typing.Any]],
        distinguisher_method: typing.Optional[typing.Union[FlowDistinguisherMethodV1Beta2, typing.Dict[builtins.str, typing.Any]]] = None,
        matching_precedence: typing.Optional[jsii.Number] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRulesWithSubjectsV1Beta2", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''FlowSchemaSpec describes how the FlowSchema's specification looks like.

        :param priority_level_configuration: ``priorityLevelConfiguration`` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        :param distinguisher_method: ``distinguisherMethod`` defines how to compute the flow distinguisher for requests that match this schema. ``nil`` specifies that the distinguisher is disabled and thus will always be the empty string.
        :param matching_precedence: ``matchingPrecedence`` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence. Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        :param rules: ``rules`` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec
        '''
        if isinstance(priority_level_configuration, dict):
            priority_level_configuration = PriorityLevelConfigurationReferenceV1Beta2(**priority_level_configuration)
        if isinstance(distinguisher_method, dict):
            distinguisher_method = FlowDistinguisherMethodV1Beta2(**distinguisher_method)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5f5f05ecf0a607ed1c48480b9260a2b0f05c703608f226677902fcb42ea88a88)
            check_type(argname="argument priority_level_configuration", value=priority_level_configuration, expected_type=type_hints["priority_level_configuration"])
            check_type(argname="argument distinguisher_method", value=distinguisher_method, expected_type=type_hints["distinguisher_method"])
            check_type(argname="argument matching_precedence", value=matching_precedence, expected_type=type_hints["matching_precedence"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "priority_level_configuration": priority_level_configuration,
        }
        if distinguisher_method is not None:
            self._values["distinguisher_method"] = distinguisher_method
        if matching_precedence is not None:
            self._values["matching_precedence"] = matching_precedence
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def priority_level_configuration(
        self,
    ) -> "PriorityLevelConfigurationReferenceV1Beta2":
        '''``priorityLevelConfiguration`` should reference a PriorityLevelConfiguration in the cluster.

        If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec#priorityLevelConfiguration
        '''
        result = self._values.get("priority_level_configuration")
        assert result is not None, "Required property 'priority_level_configuration' is missing"
        return typing.cast("PriorityLevelConfigurationReferenceV1Beta2", result)

    @builtins.property
    def distinguisher_method(self) -> typing.Optional[FlowDistinguisherMethodV1Beta2]:
        '''``distinguisherMethod`` defines how to compute the flow distinguisher for requests that match this schema.

        ``nil`` specifies that the distinguisher is disabled and thus will always be the empty string.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec#distinguisherMethod
        '''
        result = self._values.get("distinguisher_method")
        return typing.cast(typing.Optional[FlowDistinguisherMethodV1Beta2], result)

    @builtins.property
    def matching_precedence(self) -> typing.Optional[jsii.Number]:
        '''``matchingPrecedence`` is used to choose among the FlowSchemas that match a given request.

        The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec#matchingPrecedence
        '''
        result = self._values.get("matching_precedence")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRulesWithSubjectsV1Beta2"]]:
        '''``rules`` describes which requests will match this flow schema.

        This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRulesWithSubjectsV1Beta2"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlowSchemaSpecV1Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.FlowSchemaSpecV1Beta3",
    jsii_struct_bases=[],
    name_mapping={
        "priority_level_configuration": "priorityLevelConfiguration",
        "distinguisher_method": "distinguisherMethod",
        "matching_precedence": "matchingPrecedence",
        "rules": "rules",
    },
)
class FlowSchemaSpecV1Beta3:
    def __init__(
        self,
        *,
        priority_level_configuration: typing.Union["PriorityLevelConfigurationReferenceV1Beta3", typing.Dict[builtins.str, typing.Any]],
        distinguisher_method: typing.Optional[typing.Union[FlowDistinguisherMethodV1Beta3, typing.Dict[builtins.str, typing.Any]]] = None,
        matching_precedence: typing.Optional[jsii.Number] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRulesWithSubjectsV1Beta3", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''FlowSchemaSpec describes how the FlowSchema's specification looks like.

        :param priority_level_configuration: ``priorityLevelConfiguration`` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        :param distinguisher_method: ``distinguisherMethod`` defines how to compute the flow distinguisher for requests that match this schema. ``nil`` specifies that the distinguisher is disabled and thus will always be the empty string.
        :param matching_precedence: ``matchingPrecedence`` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence. Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        :param rules: ``rules`` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaSpec
        '''
        if isinstance(priority_level_configuration, dict):
            priority_level_configuration = PriorityLevelConfigurationReferenceV1Beta3(**priority_level_configuration)
        if isinstance(distinguisher_method, dict):
            distinguisher_method = FlowDistinguisherMethodV1Beta3(**distinguisher_method)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49b5a47d66a35757a485553fba38c8ce4da0245af12d480b2cdd1945c75c3b56)
            check_type(argname="argument priority_level_configuration", value=priority_level_configuration, expected_type=type_hints["priority_level_configuration"])
            check_type(argname="argument distinguisher_method", value=distinguisher_method, expected_type=type_hints["distinguisher_method"])
            check_type(argname="argument matching_precedence", value=matching_precedence, expected_type=type_hints["matching_precedence"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "priority_level_configuration": priority_level_configuration,
        }
        if distinguisher_method is not None:
            self._values["distinguisher_method"] = distinguisher_method
        if matching_precedence is not None:
            self._values["matching_precedence"] = matching_precedence
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def priority_level_configuration(
        self,
    ) -> "PriorityLevelConfigurationReferenceV1Beta3":
        '''``priorityLevelConfiguration`` should reference a PriorityLevelConfiguration in the cluster.

        If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaSpec#priorityLevelConfiguration
        '''
        result = self._values.get("priority_level_configuration")
        assert result is not None, "Required property 'priority_level_configuration' is missing"
        return typing.cast("PriorityLevelConfigurationReferenceV1Beta3", result)

    @builtins.property
    def distinguisher_method(self) -> typing.Optional[FlowDistinguisherMethodV1Beta3]:
        '''``distinguisherMethod`` defines how to compute the flow distinguisher for requests that match this schema.

        ``nil`` specifies that the distinguisher is disabled and thus will always be the empty string.

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaSpec#distinguisherMethod
        '''
        result = self._values.get("distinguisher_method")
        return typing.cast(typing.Optional[FlowDistinguisherMethodV1Beta3], result)

    @builtins.property
    def matching_precedence(self) -> typing.Optional[jsii.Number]:
        '''``matchingPrecedence`` is used to choose among the FlowSchemas that match a given request.

        The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaSpec#matchingPrecedence
        '''
        result = self._values.get("matching_precedence")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRulesWithSubjectsV1Beta3"]]:
        '''``rules`` describes which requests will match this flow schema.

        This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaSpec#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRulesWithSubjectsV1Beta3"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlowSchemaSpecV1Beta3(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.ForZone",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class ForZone:
    def __init__(self, *, name: builtins.str) -> None:
        '''ForZone provides information about which zones should consume this endpoint.

        :param name: name represents the name of the zone.

        :schema: io.k8s.api.discovery.v1.ForZone
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f105c39a4613fb5855e8fd891d96fedd10dd043d0017a26757953fec2c3acf9)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''name represents the name of the zone.

        :schema: io.k8s.api.discovery.v1.ForZone#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ForZone(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.GcePersistentDiskVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "pd_name": "pdName",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GcePersistentDiskVolumeSource:
    def __init__(
        self,
        *,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Represents a Persistent Disk resource in Google Compute Engine.

        A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.

        :param pd_name: pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param fs_type: fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param partition: partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk Default: false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__856737a009d7c3f98fb5d1d8281e32e2c72aa8f5cbf33409319fa7a0886bdea0)
            check_type(argname="argument pd_name", value=pd_name, expected_type=type_hints["pd_name"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "pd_name": pd_name,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def pd_name(self) -> builtins.str:
        '''pdName is unique name of the PD resource in GCE.

        Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#pdName
        '''
        result = self._values.get("pd_name")
        assert result is not None, "Required property 'pd_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''partition is the partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#partition
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :default: false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GcePersistentDiskVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.GitRepoVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "repository": "repository",
        "directory": "directory",
        "revision": "revision",
    },
)
class GitRepoVolumeSource:
    def __init__(
        self,
        *,
        repository: builtins.str,
        directory: typing.Optional[builtins.str] = None,
        revision: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a volume that is populated with the contents of a git repository.

        Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

        DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.

        :param repository: repository is the URL.
        :param directory: directory is the target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        :param revision: revision is the commit hash for the specified revision.

        :schema: io.k8s.api.core.v1.GitRepoVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__65ca46ff119f2a8b8cc83a5fcf9bde7d04293f685e5e2a67f04054756ca2951e)
            check_type(argname="argument repository", value=repository, expected_type=type_hints["repository"])
            check_type(argname="argument directory", value=directory, expected_type=type_hints["directory"])
            check_type(argname="argument revision", value=revision, expected_type=type_hints["revision"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "repository": repository,
        }
        if directory is not None:
            self._values["directory"] = directory
        if revision is not None:
            self._values["revision"] = revision

    @builtins.property
    def repository(self) -> builtins.str:
        '''repository is the URL.

        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#repository
        '''
        result = self._values.get("repository")
        assert result is not None, "Required property 'repository' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def directory(self) -> typing.Optional[builtins.str]:
        '''directory is the target directory name.

        Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.

        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#directory
        '''
        result = self._values.get("directory")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def revision(self) -> typing.Optional[builtins.str]:
        '''revision is the commit hash for the specified revision.

        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#revision
        '''
        result = self._values.get("revision")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GitRepoVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.GlusterfsPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "endpoints": "endpoints",
        "path": "path",
        "endpoints_namespace": "endpointsNamespace",
        "read_only": "readOnly",
    },
)
class GlusterfsPersistentVolumeSource:
    def __init__(
        self,
        *,
        endpoints: builtins.str,
        path: builtins.str,
        endpoints_namespace: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Represents a Glusterfs mount that lasts the lifetime of a pod.

        Glusterfs volumes do not support ownership management or SELinux relabeling.

        :param endpoints: endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param path: path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param endpoints_namespace: endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param read_only: readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod Default: false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb1ae879b2a4f99997ea4047d19c8212f9d42063e12fe0786e8d49c0fe5b433a)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument endpoints_namespace", value=endpoints_namespace, expected_type=type_hints["endpoints_namespace"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "path": path,
        }
        if endpoints_namespace is not None:
            self._values["endpoints_namespace"] = endpoints_namespace
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def endpoints(self) -> builtins.str:
        '''endpoints is the endpoint name that details Glusterfs topology.

        More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''path is the Glusterfs volume path.

        More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoints_namespace(self) -> typing.Optional[builtins.str]:
        '''endpointsNamespace is the namespace that contains Glusterfs endpoint.

        If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#endpointsNamespace
        '''
        result = self._values.get("endpoints_namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the Glusterfs volume to be mounted with read-only permissions.

        Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :default: false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GlusterfsPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.GlusterfsVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"endpoints": "endpoints", "path": "path", "read_only": "readOnly"},
)
class GlusterfsVolumeSource:
    def __init__(
        self,
        *,
        endpoints: builtins.str,
        path: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Represents a Glusterfs mount that lasts the lifetime of a pod.

        Glusterfs volumes do not support ownership management or SELinux relabeling.

        :param endpoints: endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param path: path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param read_only: readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod Default: false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c9e5a18a6ace55ac3793238fdd20cea98e9caed10e13d613198883b445aaecd8)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "path": path,
        }
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def endpoints(self) -> builtins.str:
        '''endpoints is the endpoint name that details Glusterfs topology.

        More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''path is the Glusterfs volume path.

        More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the Glusterfs volume to be mounted with read-only permissions.

        Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :default: false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod

        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GlusterfsVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.GroupSubjectV1Beta2",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class GroupSubjectV1Beta2:
    def __init__(self, *, name: builtins.str) -> None:
        '''GroupSubject holds detailed information for group-kind subject.

        :param name: name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.GroupSubject
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0391eb45d71b6bfeaeb7fe47f9fca657551c200388b286863380b1b26bb871b5)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the user group that matches, or "*" to match all user groups.

        See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.

        :schema: io.k8s.api.flowcontrol.v1beta2.GroupSubject#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GroupSubjectV1Beta2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.GroupSubjectV1Beta3",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class GroupSubjectV1Beta3:
    def __init__(self, *, name: builtins.str) -> None:
        '''GroupSubject holds detailed information for group-kind subject.

        :param name: name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.

        :schema: io.k8s.api.flowcontrol.v1beta3.GroupSubject
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c21da2b0be61bf2f45e47e815aadb8a86c510587954ea6addb51837ad8acf02a)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the user group that matches, or "*" to match all user groups.

        See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.

        :schema: io.k8s.api.flowcontrol.v1beta3.GroupSubject#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GroupSubjectV1Beta3(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.GrpcAction",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "service": "service"},
)
class GrpcAction:
    def __init__(
        self,
        *,
        port: jsii.Number,
        service: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param port: Port number of the gRPC service. Number must be in the range 1 to 65535.
        :param service: Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.

        :schema: io.k8s.api.core.v1.GRPCAction
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9827d8cff52ccd6b215fac138ff23eaaffdea5bc831e3dca24996be8b260192b)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if service is not None:
            self._values["service"] = service

    @builtins.property
    def port(self) -> jsii.Number:
        '''Port number of the gRPC service.

        Number must be in the range 1 to 65535.

        :schema: io.k8s.api.core.v1.GRPCAction#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def service(self) -> typing.Optional[builtins.str]:
        '''Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).

        If this is not specified, the default behavior is defined by gRPC.

        :schema: io.k8s.api.core.v1.GRPCAction#service
        '''
        result = self._values.get("service")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GrpcAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HorizontalPodAutoscalerBehaviorV2",
    jsii_struct_bases=[],
    name_mapping={"scale_down": "scaleDown", "scale_up": "scaleUp"},
)
class HorizontalPodAutoscalerBehaviorV2:
    def __init__(
        self,
        *,
        scale_down: typing.Optional[typing.Union["HpaScalingRulesV2", typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union["HpaScalingRulesV2", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).

        :param scale_down: scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        :param scale_up: scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of: - increase no more than 4 pods per 60 seconds - double the number of pods per 60 seconds No stabilization is used.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior
        '''
        if isinstance(scale_down, dict):
            scale_down = HpaScalingRulesV2(**scale_down)
        if isinstance(scale_up, dict):
            scale_up = HpaScalingRulesV2(**scale_up)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8e93ebcdec50cba72df414a0f3ddcf125c1cffde7ae04c47522b7c8f5cd0019f)
            check_type(argname="argument scale_down", value=scale_down, expected_type=type_hints["scale_down"])
            check_type(argname="argument scale_up", value=scale_up, expected_type=type_hints["scale_up"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if scale_down is not None:
            self._values["scale_down"] = scale_down
        if scale_up is not None:
            self._values["scale_up"] = scale_up

    @builtins.property
    def scale_down(self) -> typing.Optional["HpaScalingRulesV2"]:
        '''scaleDown is scaling policy for scaling Down.

        If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior#scaleDown
        '''
        result = self._values.get("scale_down")
        return typing.cast(typing.Optional["HpaScalingRulesV2"], result)

    @builtins.property
    def scale_up(self) -> typing.Optional["HpaScalingRulesV2"]:
        '''scaleUp is scaling policy for scaling Up.

        If not set, the default value is the higher of:

        - increase no more than 4 pods per 60 seconds
        - double the number of pods per 60 seconds
          No stabilization is used.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior#scaleUp
        '''
        result = self._values.get("scale_up")
        return typing.cast(typing.Optional["HpaScalingRulesV2"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerBehaviorV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HorizontalPodAutoscalerSpec",
    jsii_struct_bases=[],
    name_mapping={
        "max_replicas": "maxReplicas",
        "scale_target_ref": "scaleTargetRef",
        "min_replicas": "minReplicas",
        "target_cpu_utilization_percentage": "targetCpuUtilizationPercentage",
    },
)
class HorizontalPodAutoscalerSpec:
    def __init__(
        self,
        *,
        max_replicas: jsii.Number,
        scale_target_ref: typing.Union[CrossVersionObjectReference, typing.Dict[builtins.str, typing.Any]],
        min_replicas: typing.Optional[jsii.Number] = None,
        target_cpu_utilization_percentage: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''specification of a horizontal pod autoscaler.

        :param max_replicas: maxReplicas is the upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.
        :param scale_target_ref: reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.
        :param min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod. minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured. Scaling is active as long as at least one metric value is available.
        :param target_cpu_utilization_percentage: targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec
        '''
        if isinstance(scale_target_ref, dict):
            scale_target_ref = CrossVersionObjectReference(**scale_target_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9761a7d25bfb2d83db897b7aa919863f276487ee79f6e7fe86ac13374f4d91de)
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument scale_target_ref", value=scale_target_ref, expected_type=type_hints["scale_target_ref"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
            check_type(argname="argument target_cpu_utilization_percentage", value=target_cpu_utilization_percentage, expected_type=type_hints["target_cpu_utilization_percentage"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "scale_target_ref": scale_target_ref,
        }
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas
        if target_cpu_utilization_percentage is not None:
            self._values["target_cpu_utilization_percentage"] = target_cpu_utilization_percentage

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''maxReplicas is the upper limit for the number of pods that can be set by the autoscaler;

        cannot be smaller than MinReplicas.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#maxReplicas
        '''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scale_target_ref(self) -> CrossVersionObjectReference:
        '''reference to scaled resource;

        horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#scaleTargetRef
        '''
        result = self._values.get("scale_target_ref")
        assert result is not None, "Required property 'scale_target_ref' is missing"
        return typing.cast(CrossVersionObjectReference, result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.

        It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#minReplicas
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def target_cpu_utilization_percentage(self) -> typing.Optional[jsii.Number]:
        '''targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods;

        if not specified the default autoscaling policy will be used.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#targetCPUUtilizationPercentage
        '''
        result = self._values.get("target_cpu_utilization_percentage")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HorizontalPodAutoscalerSpecV2",
    jsii_struct_bases=[],
    name_mapping={
        "max_replicas": "maxReplicas",
        "scale_target_ref": "scaleTargetRef",
        "behavior": "behavior",
        "metrics": "metrics",
        "min_replicas": "minReplicas",
    },
)
class HorizontalPodAutoscalerSpecV2:
    def __init__(
        self,
        *,
        max_replicas: jsii.Number,
        scale_target_ref: typing.Union[CrossVersionObjectReferenceV2, typing.Dict[builtins.str, typing.Any]],
        behavior: typing.Optional[typing.Union[HorizontalPodAutoscalerBehaviorV2, typing.Dict[builtins.str, typing.Any]]] = None,
        metrics: typing.Optional[typing.Sequence[typing.Union["MetricSpecV2", typing.Dict[builtins.str, typing.Any]]]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.

        :param max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param behavior: behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        :param metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used). The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods. Ergo, metrics used must decrease as the pod count is increased, and vice-versa. See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod. minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured. Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec
        '''
        if isinstance(scale_target_ref, dict):
            scale_target_ref = CrossVersionObjectReferenceV2(**scale_target_ref)
        if isinstance(behavior, dict):
            behavior = HorizontalPodAutoscalerBehaviorV2(**behavior)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e0d23b91efe97a015c7aba9a5267c2e8afbd168c1ed3dee0d1942f110531d03)
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument scale_target_ref", value=scale_target_ref, expected_type=type_hints["scale_target_ref"])
            check_type(argname="argument behavior", value=behavior, expected_type=type_hints["behavior"])
            check_type(argname="argument metrics", value=metrics, expected_type=type_hints["metrics"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "scale_target_ref": scale_target_ref,
        }
        if behavior is not None:
            self._values["behavior"] = behavior
        if metrics is not None:
            self._values["metrics"] = metrics
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up.

        It cannot be less that minReplicas.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#maxReplicas
        '''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scale_target_ref(self) -> CrossVersionObjectReferenceV2:
        '''scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#scaleTargetRef
        '''
        result = self._values.get("scale_target_ref")
        assert result is not None, "Required property 'scale_target_ref' is missing"
        return typing.cast(CrossVersionObjectReferenceV2, result)

    @builtins.property
    def behavior(self) -> typing.Optional[HorizontalPodAutoscalerBehaviorV2]:
        '''behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).

        If not set, the default HPAScalingRules for scale up and scale down are used.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#behavior
        '''
        result = self._values.get("behavior")
        return typing.cast(typing.Optional[HorizontalPodAutoscalerBehaviorV2], result)

    @builtins.property
    def metrics(self) -> typing.Optional[typing.List["MetricSpecV2"]]:
        '''metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).

        The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#metrics
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.List["MetricSpecV2"]], result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.

        It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec#minReplicas
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerSpecV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HostAlias",
    jsii_struct_bases=[],
    name_mapping={"hostnames": "hostnames", "ip": "ip"},
)
class HostAlias:
    def __init__(
        self,
        *,
        hostnames: typing.Optional[typing.Sequence[builtins.str]] = None,
        ip: typing.Optional[builtins.str] = None,
    ) -> None:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :param hostnames: Hostnames for the above IP address.
        :param ip: IP address of the host file entry.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8b36eea5f07e2adfbe6d72736ef64adfc3d84420c63d2560f4b8200e5c460f17)
            check_type(argname="argument hostnames", value=hostnames, expected_type=type_hints["hostnames"])
            check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hostnames is not None:
            self._values["hostnames"] = hostnames
        if ip is not None:
            self._values["ip"] = ip

    @builtins.property
    def hostnames(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Hostnames for the above IP address.

        :schema: io.k8s.api.core.v1.HostAlias#hostnames
        '''
        result = self._values.get("hostnames")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def ip(self) -> typing.Optional[builtins.str]:
        '''IP address of the host file entry.

        :schema: io.k8s.api.core.v1.HostAlias#ip
        '''
        result = self._values.get("ip")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostAlias(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HostPathVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "type": "type"},
)
class HostPathVolumeSource:
    def __init__(
        self,
        *,
        path: builtins.str,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Represents a host path mapped into a pod.

        Host path volumes do not support ownership management or SELinux relabeling.

        :param path: path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param type: type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath. Default: More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :schema: io.k8s.api.core.v1.HostPathVolumeSource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88fe97b5012cf87fe84e0bf8cab0968859e81ac86f9d63161a8f297e52f1c14c)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def path(self) -> builtins.str:
        '''path of the directory on the host.

        If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :schema: io.k8s.api.core.v1.HostPathVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath.

        :default: More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :schema: io.k8s.api.core.v1.HostPathVolumeSource#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostPathVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HpaScalingPolicyV2",
    jsii_struct_bases=[],
    name_mapping={"period_seconds": "periodSeconds", "type": "type", "value": "value"},
)
class HpaScalingPolicyV2:
    def __init__(
        self,
        *,
        period_seconds: jsii.Number,
        type: builtins.str,
        value: jsii.Number,
    ) -> None:
        '''HPAScalingPolicy is a single policy which must hold true for a specified past interval.

        :param period_seconds: periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        :param type: type is used to specify the scaling policy.
        :param value: value contains the amount of change which is permitted by the policy. It must be greater than zero

        :schema: io.k8s.api.autoscaling.v2.HPAScalingPolicy
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__11fa2b6e9da2f2ee0a19df27099bb5bc9561c88418540fd10228aaec7b9ac20c)
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "period_seconds": period_seconds,
            "type": type,
            "value": value,
        }

    @builtins.property
    def period_seconds(self) -> jsii.Number:
        '''periodSeconds specifies the window of time for which the policy should hold true.

        PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).

        :schema: io.k8s.api.autoscaling.v2.HPAScalingPolicy#periodSeconds
        '''
        result = self._values.get("period_seconds")
        assert result is not None, "Required property 'period_seconds' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''type is used to specify the scaling policy.

        :schema: io.k8s.api.autoscaling.v2.HPAScalingPolicy#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> jsii.Number:
        '''value contains the amount of change which is permitted by the policy.

        It must be greater than zero

        :schema: io.k8s.api.autoscaling.v2.HPAScalingPolicy#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HpaScalingPolicyV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HpaScalingRulesV2",
    jsii_struct_bases=[],
    name_mapping={
        "policies": "policies",
        "select_policy": "selectPolicy",
        "stabilization_window_seconds": "stabilizationWindowSeconds",
    },
)
class HpaScalingRulesV2:
    def __init__(
        self,
        *,
        policies: typing.Optional[typing.Sequence[typing.Union[HpaScalingPolicyV2, typing.Dict[builtins.str, typing.Any]]]] = None,
        select_policy: typing.Optional[builtins.str] = None,
        stabilization_window_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''HPAScalingRules configures the scaling behavior for one direction.

        These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.

        :param policies: policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        :param select_policy: selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        :param stabilization_window_seconds: stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).

        :schema: io.k8s.api.autoscaling.v2.HPAScalingRules
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__277ff4a4c7b5bc010213535b0066701629d383354cc7f925970701eef8a2b8ac)
            check_type(argname="argument policies", value=policies, expected_type=type_hints["policies"])
            check_type(argname="argument select_policy", value=select_policy, expected_type=type_hints["select_policy"])
            check_type(argname="argument stabilization_window_seconds", value=stabilization_window_seconds, expected_type=type_hints["stabilization_window_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if policies is not None:
            self._values["policies"] = policies
        if select_policy is not None:
            self._values["select_policy"] = select_policy
        if stabilization_window_seconds is not None:
            self._values["stabilization_window_seconds"] = stabilization_window_seconds

    @builtins.property
    def policies(self) -> typing.Optional[typing.List[HpaScalingPolicyV2]]:
        '''policies is a list of potential scaling polices which can be used during scaling.

        At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid

        :schema: io.k8s.api.autoscaling.v2.HPAScalingRules#policies
        '''
        result = self._values.get("policies")
        return typing.cast(typing.Optional[typing.List[HpaScalingPolicyV2]], result)

    @builtins.property
    def select_policy(self) -> typing.Optional[builtins.str]:
        '''selectPolicy is used to specify which policy should be used.

        If not set, the default value Max is used.

        :schema: io.k8s.api.autoscaling.v2.HPAScalingRules#selectPolicy
        '''
        result = self._values.get("select_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def stabilization_window_seconds(self) -> typing.Optional[jsii.Number]:
        '''stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down.

        StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).

        :schema: io.k8s.api.autoscaling.v2.HPAScalingRules#stabilizationWindowSeconds
        '''
        result = self._values.get("stabilization_window_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HpaScalingRulesV2(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HttpGetAction",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "host": "host",
        "http_headers": "httpHeaders",
        "path": "path",
        "scheme": "scheme",
    },
)
class HttpGetAction:
    def __init__(
        self,
        *,
        port: "IntOrString",
        host: typing.Optional[builtins.str] = None,
        http_headers: typing.Optional[typing.Sequence[typing.Union["HttpHeader", typing.Dict[builtins.str, typing.Any]]]] = None,
        path: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''HTTPGetAction describes an action based on HTTP Get requests.

        :param port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param path: Path to access on the HTTP server.
        :param scheme: Scheme to use for connecting to the host. Defaults to HTTP. Default: HTTP.

        :schema: io.k8s.api.core.v1.HTTPGetAction
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e75d92378aab33e6aa86f06a87dbb7ed1449899e64d15839da2d88343e51d40)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http_headers", value=http_headers, expected_type=type_hints["http_headers"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host
        if http_headers is not None:
            self._values["http_headers"] = http_headers
        if path is not None:
            self._values["path"] = path
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def port(self) -> "IntOrString":
        '''Name or number of the port to access on the container.

        Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.

        :schema: io.k8s.api.core.v1.HTTPGetAction#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("IntOrString", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''Host name to connect to, defaults to the pod IP.

        You probably want to set "Host" in httpHeaders instead.

        :schema: io.k8s.api.core.v1.HTTPGetAction#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_headers(self) -> typing.Optional[typing.List["HttpHeader"]]:
        '''Custom headers to set in the request.

        HTTP allows repeated headers.

        :schema: io.k8s.api.core.v1.HTTPGetAction#httpHeaders
        '''
        result = self._values.get("http_headers")
        return typing.cast(typing.Optional[typing.List["HttpHeader"]], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''Path to access on the HTTP server.

        :schema: io.k8s.api.core.v1.HTTPGetAction#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''Scheme to use for connecting to the host.

        Defaults to HTTP.

        :default: HTTP.

        :schema: io.k8s.api.core.v1.HTTPGetAction#scheme
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpGetAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HttpHeader",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class HttpHeader:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''HTTPHeader describes a custom header to be used in HTTP probes.

        :param name: The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.
        :param value: The header field value.

        :schema: io.k8s.api.core.v1.HTTPHeader
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6fe9b800d4dd3c24926b84ffd5e6de2391a31af3f440b0ef54d6f7037c814c5)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''The header field name.

        This will be canonicalized upon output, so case-variant names will be understood as the same header.

        :schema: io.k8s.api.core.v1.HTTPHeader#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''The header field value.

        :schema: io.k8s.api.core.v1.HTTPHeader#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpHeader(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HttpIngressPath",
    jsii_struct_bases=[],
    name_mapping={"backend": "backend", "path_type": "pathType", "path": "path"},
)
class HttpIngressPath:
    def __init__(
        self,
        *,
        backend: typing.Union["IngressBackend", typing.Dict[builtins.str, typing.Any]],
        path_type: builtins.str,
        path: typing.Optional[builtins.str] = None,
    ) -> None:
        '''HTTPIngressPath associates a path with a backend.

        Incoming urls matching the path are forwarded to the backend.

        :param backend: backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param path_type: pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is done on a path element by element basis. A path element refers is the list of labels in the path split by the '/' separator. A request is a match for path p if every p is an element-wise prefix of p of the request path. Note that if the last element of the path is a substring of the last element in request path, it is not a match (e.g. /foo/bar matches /foo/bar/baz, but does not match /foo/barbaz). - ImplementationSpecific: Interpretation of the Path matching is up to the IngressClass. Implementations can treat this as a separate PathType or treat it identically to Prefix or Exact path types. Implementations are required to support all path types.
        :param path: path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".

        :schema: io.k8s.api.networking.v1.HTTPIngressPath
        '''
        if isinstance(backend, dict):
            backend = IngressBackend(**backend)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b35b9b152cbe03922193f69a09c1ac3b6b8d7d3e7243ddf1a00483fea135aca)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "backend": backend,
            "path_type": path_type,
        }
        if path is not None:
            self._values["path"] = path

    @builtins.property
    def backend(self) -> "IngressBackend":
        '''backend defines the referenced service endpoint to which the traffic will be forwarded to.

        :schema: io.k8s.api.networking.v1.HTTPIngressPath#backend
        '''
        result = self._values.get("backend")
        assert result is not None, "Required property 'backend' is missing"
        return typing.cast("IngressBackend", result)

    @builtins.property
    def path_type(self) -> builtins.str:
        '''pathType determines the interpretation of the path matching.

        PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
        done on a path element by element basis. A path element refers is the
        list of labels in the path split by the '/' separator. A request is a
        match for path p if every p is an element-wise prefix of p of the
        request path. Note that if the last element of the path is a substring
        of the last element in request path, it is not a match (e.g. /foo/bar
        matches /foo/bar/baz, but does not match /foo/barbaz).

        - ImplementationSpecific: Interpretation of the Path matching is up to
          the IngressClass. Implementations can treat this as a separate PathType
          or treat it identically to Prefix or Exact path types.
          Implementations are required to support all path types.

        :schema: io.k8s.api.networking.v1.HTTPIngressPath#pathType
        '''
        result = self._values.get("path_type")
        assert result is not None, "Required property 'path_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''path is matched against the path of an incoming request.

        Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".

        :schema: io.k8s.api.networking.v1.HTTPIngressPath#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpIngressPath(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.HttpIngressRuleValue",
    jsii_struct_bases=[],
    name_mapping={"paths": "paths"},
)
class HttpIngressRuleValue:
    def __init__(
        self,
        *,
        paths: typing.Sequence[typing.Union[HttpIngressPath, typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''HTTPIngressRuleValue is a list of http selectors pointing to backends.

        In the example: http:///? -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.

        :param paths: paths is a collection of paths that map requests to backends.

        :schema: io.k8s.api.networking.v1.HTTPIngressRuleValue
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__34add93d9cf377540efc3c59736ae5b93a14643d5e27e01dd33db1701c0f332d)
            check_type(argname="argument paths", value=paths, expected_type=type_hints["paths"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "paths": paths,
        }

    @builtins.property
    def paths(self) -> typing.List[HttpIngressPath]:
        '''paths is a collection of paths that map requests to backends.

        :schema: io.k8s.api.networking.v1.HTTPIngressRuleValue#paths
        '''
        result = self._values.get("paths")
        assert result is not None, "Required property 'paths' is missing"
        return typing.cast(typing.List[HttpIngressPath], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpIngressRuleValue(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IngressBackend",
    jsii_struct_bases=[],
    name_mapping={"resource": "resource", "service": "service"},
)
class IngressBackend:
    def __init__(
        self,
        *,
        resource: typing.Optional[typing.Union["TypedLocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        service: typing.Optional[typing.Union["IngressServiceBackend", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IngressBackend describes all endpoints for a given service and port.

        :param resource: resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        :param service: service references a service as a backend. This is a mutually exclusive setting with "Resource".

        :schema: io.k8s.api.networking.v1.IngressBackend
        '''
        if isinstance(resource, dict):
            resource = TypedLocalObjectReference(**resource)
        if isinstance(service, dict):
            service = IngressServiceBackend(**service)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__65c5239b8ad6b7227681ba9f91537c07e1f6a82dada79f7bbb5f382ad905965b)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if resource is not None:
            self._values["resource"] = resource
        if service is not None:
            self._values["service"] = service

    @builtins.property
    def resource(self) -> typing.Optional["TypedLocalObjectReference"]:
        '''resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object.

        If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".

        :schema: io.k8s.api.networking.v1.IngressBackend#resource
        '''
        result = self._values.get("resource")
        return typing.cast(typing.Optional["TypedLocalObjectReference"], result)

    @builtins.property
    def service(self) -> typing.Optional["IngressServiceBackend"]:
        '''service references a service as a backend.

        This is a mutually exclusive setting with "Resource".

        :schema: io.k8s.api.networking.v1.IngressBackend#service
        '''
        result = self._values.get("service")
        return typing.cast(typing.Optional["IngressServiceBackend"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressBackend(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IngressClassParametersReference",
    jsii_struct_bases=[],
    name_mapping={
        "kind": "kind",
        "name": "name",
        "api_group": "apiGroup",
        "namespace": "namespace",
        "scope": "scope",
    },
)
class IngressClassParametersReference:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_group: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
        scope: typing.Optional[builtins.str] = None,
    ) -> None:
        '''IngressClassParametersReference identifies an API object.

        This can be used to specify a cluster or namespace-scoped resource.

        :param kind: kind is the type of resource being referenced.
        :param name: name is the name of resource being referenced.
        :param api_group: apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        :param namespace: namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        :param scope: scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__87b0f3e43db5a67cf4fd5efd37f39dae5c59de02f60640944ed9af5edbb844cb)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_group is not None:
            self._values["api_group"] = api_group
        if namespace is not None:
            self._values["namespace"] = namespace
        if scope is not None:
            self._values["scope"] = scope

    @builtins.property
    def kind(self) -> builtins.str:
        '''kind is the type of resource being referenced.

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the name of resource being referenced.

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_group(self) -> typing.Optional[builtins.str]:
        '''apiGroup is the group for the resource being referenced.

        If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#apiGroup
        '''
        result = self._values.get("api_group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''namespace is the namespace of the resource being referenced.

        This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#namespace
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scope(self) -> typing.Optional[builtins.str]:
        '''scope represents if this refers to a cluster or namespace scoped resource.

        This may be set to "Cluster" (default) or "Namespace".

        :schema: io.k8s.api.networking.v1.IngressClassParametersReference#scope
        '''
        result = self._values.get("scope")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressClassParametersReference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IngressClassSpec",
    jsii_struct_bases=[],
    name_mapping={"controller": "controller", "parameters": "parameters"},
)
class IngressClassSpec:
    def __init__(
        self,
        *,
        controller: typing.Optional[builtins.str] = None,
        parameters: typing.Optional[typing.Union[IngressClassParametersReference, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IngressClassSpec provides information about the class of an Ingress.

        :param controller: controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        :param parameters: parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.

        :schema: io.k8s.api.networking.v1.IngressClassSpec
        '''
        if isinstance(parameters, dict):
            parameters = IngressClassParametersReference(**parameters)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efdd43f70269f3070807c83b3b5d77d2ef80c5c4ffae3f9fa7e47c6d0d09bb58)
            check_type(argname="argument controller", value=controller, expected_type=type_hints["controller"])
            check_type(argname="argument parameters", value=parameters, expected_type=type_hints["parameters"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if controller is not None:
            self._values["controller"] = controller
        if parameters is not None:
            self._values["parameters"] = parameters

    @builtins.property
    def controller(self) -> typing.Optional[builtins.str]:
        '''controller refers to the name of the controller that should handle this class.

        This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.

        :schema: io.k8s.api.networking.v1.IngressClassSpec#controller
        '''
        result = self._values.get("controller")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def parameters(self) -> typing.Optional[IngressClassParametersReference]:
        '''parameters is a link to a custom resource containing additional configuration for the controller.

        This is optional if the controller does not require extra parameters.

        :schema: io.k8s.api.networking.v1.IngressClassSpec#parameters
        '''
        result = self._values.get("parameters")
        return typing.cast(typing.Optional[IngressClassParametersReference], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressClassSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IngressRule",
    jsii_struct_bases=[],
    name_mapping={"host": "host", "http": "http"},
)
class IngressRule:
    def __init__(
        self,
        *,
        host: typing.Optional[builtins.str] = None,
        http: typing.Optional[typing.Union[HttpIngressRuleValue, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IngressRule represents the rules mapping the paths under a specified host to the related backend services.

        Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.

        :param host: host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the IP in the Spec of the parent Ingress. 2. The ``:`` delimiter is not respected because ports are not allowed. Currently the port of an Ingress is implicitly :80 for http and :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue. host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        :param http: 

        :schema: io.k8s.api.networking.v1.IngressRule
        '''
        if isinstance(http, dict):
            http = HttpIngressRuleValue(**http)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bbbf01ea6d66bbff894bae2779d893fb60dc88c5b51575aee3d617c9d0a6448a)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument http", value=http, expected_type=type_hints["http"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if host is not None:
            self._values["host"] = host
        if http is not None:
            self._values["http"] = http

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''host is the fully qualified domain name of a network host, as defined by RFC 3986.

        Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
        the IP in the Spec of the parent Ingress.
        2. The ``:`` delimiter is not respected because ports are not allowed.
        Currently the port of an Ingress is implicitly :80 for http and
        :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

        host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.

        :schema: io.k8s.api.networking.v1.IngressRule#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http(self) -> typing.Optional[HttpIngressRuleValue]:
        '''
        :schema: io.k8s.api.networking.v1.IngressRule#http
        '''
        result = self._values.get("http")
        return typing.cast(typing.Optional[HttpIngressRuleValue], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IngressServiceBackend",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "port": "port"},
)
class IngressServiceBackend:
    def __init__(
        self,
        *,
        name: builtins.str,
        port: typing.Optional[typing.Union["ServiceBackendPort", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IngressServiceBackend references a Kubernetes Service as a Backend.

        :param name: name is the referenced service. The service must exist in the same namespace as the Ingress object.
        :param port: port of the referenced service. A port name or port number is required for a IngressServiceBackend.

        :schema: io.k8s.api.networking.v1.IngressServiceBackend
        '''
        if isinstance(port, dict):
            port = ServiceBackendPort(**port)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fe19636674275a48ee27b59a523daa283298a58525d829608507caf1d47b3b28)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def name(self) -> builtins.str:
        '''name is the referenced service.

        The service must exist in the same namespace as the Ingress object.

        :schema: io.k8s.api.networking.v1.IngressServiceBackend#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def port(self) -> typing.Optional["ServiceBackendPort"]:
        '''port of the referenced service.

        A port name or port number is required for a IngressServiceBackend.

        :schema: io.k8s.api.networking.v1.IngressServiceBackend#port
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional["ServiceBackendPort"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressServiceBackend(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IngressSpec",
    jsii_struct_bases=[],
    name_mapping={
        "default_backend": "defaultBackend",
        "ingress_class_name": "ingressClassName",
        "rules": "rules",
        "tls": "tls",
    },
)
class IngressSpec:
    def __init__(
        self,
        *,
        default_backend: typing.Optional[typing.Union[IngressBackend, typing.Dict[builtins.str, typing.Any]]] = None,
        ingress_class_name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[IngressRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        tls: typing.Optional[typing.Sequence[typing.Union["IngressTls", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''IngressSpec describes the Ingress the user wishes to exist.

        :param default_backend: defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        :param ingress_class_name: ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the ``kubernetes.io/ingress.class`` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        :param rules: rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param tls: tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.

        :schema: io.k8s.api.networking.v1.IngressSpec
        '''
        if isinstance(default_backend, dict):
            default_backend = IngressBackend(**default_backend)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5aa4aaa06a638cf899963aed6e182a5f5f6c172479dee3738bde3144abeb0259)
            check_type(argname="argument default_backend", value=default_backend, expected_type=type_hints["default_backend"])
            check_type(argname="argument ingress_class_name", value=ingress_class_name, expected_type=type_hints["ingress_class_name"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
            check_type(argname="argument tls", value=tls, expected_type=type_hints["tls"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_backend is not None:
            self._values["default_backend"] = default_backend
        if ingress_class_name is not None:
            self._values["ingress_class_name"] = ingress_class_name
        if rules is not None:
            self._values["rules"] = rules
        if tls is not None:
            self._values["tls"] = tls

    @builtins.property
    def default_backend(self) -> typing.Optional[IngressBackend]:
        '''defaultBackend is the backend that should handle requests that don't match any rule.

        If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.

        :schema: io.k8s.api.networking.v1.IngressSpec#defaultBackend
        '''
        result = self._values.get("default_backend")
        return typing.cast(typing.Optional[IngressBackend], result)

    @builtins.property
    def ingress_class_name(self) -> typing.Optional[builtins.str]:
        '''ingressClassName is the name of an IngressClass cluster resource.

        Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the ``kubernetes.io/ingress.class`` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.

        :schema: io.k8s.api.networking.v1.IngressSpec#ingressClassName
        '''
        result = self._values.get("ingress_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[IngressRule]]:
        '''rules is a list of host rules used to configure the Ingress.

        If unspecified, or no rule matches, all traffic is sent to the default backend.

        :schema: io.k8s.api.networking.v1.IngressSpec#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[IngressRule]], result)

    @builtins.property
    def tls(self) -> typing.Optional[typing.List["IngressTls"]]:
        '''tls represents the TLS configuration.

        Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.

        :schema: io.k8s.api.networking.v1.IngressSpec#tls
        '''
        result = self._values.get("tls")
        return typing.cast(typing.Optional[typing.List["IngressTls"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IngressTls",
    jsii_struct_bases=[],
    name_mapping={"hosts": "hosts", "secret_name": "secretName"},
)
class IngressTls:
    def __init__(
        self,
        *,
        hosts: typing.Optional[typing.Sequence[builtins.str]] = None,
        secret_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''IngressTLS describes the transport layer security associated with an ingress.

        :param hosts: hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified. Default: the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param secret_name: secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.

        :schema: io.k8s.api.networking.v1.IngressTLS
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20d003ccb60ea10e343089f6a554a0c9b4a02ee395f2f9d198cbae938408d4ce)
            check_type(argname="argument hosts", value=hosts, expected_type=type_hints["hosts"])
            check_type(argname="argument secret_name", value=secret_name, expected_type=type_hints["secret_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hosts is not None:
            self._values["hosts"] = hosts
        if secret_name is not None:
            self._values["secret_name"] = secret_name

    @builtins.property
    def hosts(self) -> typing.Optional[typing.List[builtins.str]]:
        '''hosts is a list of hosts included in the TLS certificate.

        The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.

        :default: the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.

        :schema: io.k8s.api.networking.v1.IngressTLS#hosts
        '''
        result = self._values.get("hosts")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def secret_name(self) -> typing.Optional[builtins.str]:
        '''secretName is the name of the secret used to terminate TLS traffic on port 443.

        Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.

        :schema: io.k8s.api.networking.v1.IngressTLS#secretName
        '''
        result = self._values.get("secret_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressTls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class IntOrString(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.k8s.IntOrString"):
    '''
    :schema: io.k8s.apimachinery.pkg.util.intstr.IntOrString
    '''

    @jsii.member(jsii_name="fromNumber")
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "IntOrString":
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc9bc3e670f6f02f574458eac345b2bccfda2a3b35568c8a3952b3187f5a527c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("IntOrString", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString")
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "IntOrString":
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08fce70454e1fc43d1d684e2a4ac6e8cd8f2fc723376411981e630afb5a4ec2e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("IntOrString", jsii.sinvoke(cls, "fromString", [value]))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Union[builtins.str, jsii.Number]:
        return typing.cast(typing.Union[builtins.str, jsii.Number], jsii.get(self, "value"))


@jsii.enum(
    jsii_type="cdk8s-plus-28.k8s.IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"
)
class IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind(enum.Enum):
    '''Kind is a string value representing the REST resource this object represents.

    Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

    :schema: IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind
    '''

    DELETE_OPTIONS = "DELETE_OPTIONS"
    '''DeleteOptions.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IpAddressSpecV1Alpha1",
    jsii_struct_bases=[],
    name_mapping={"parent_ref": "parentRef"},
)
class IpAddressSpecV1Alpha1:
    def __init__(
        self,
        *,
        parent_ref: typing.Optional[typing.Union["ParentReferenceV1Alpha1", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''IPAddressSpec describe the attributes in an IP Address.

        :param parent_ref: ParentRef references the resource that an IPAddress is attached to. An IPAddress must reference a parent object.

        :schema: io.k8s.api.networking.v1alpha1.IPAddressSpec
        '''
        if isinstance(parent_ref, dict):
            parent_ref = ParentReferenceV1Alpha1(**parent_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__57d6f4b6944a23e0794081e27a6aad93a3a001fc13ea103975574930a70081d4)
            check_type(argname="argument parent_ref", value=parent_ref, expected_type=type_hints["parent_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if parent_ref is not None:
            self._values["parent_ref"] = parent_ref

    @builtins.property
    def parent_ref(self) -> typing.Optional["ParentReferenceV1Alpha1"]:
        '''ParentRef references the resource that an IPAddress is attached to.

        An IPAddress must reference a parent object.

        :schema: io.k8s.api.networking.v1alpha1.IPAddressSpec#parentRef
        '''
        result = self._values.get("parent_ref")
        return typing.cast(typing.Optional["ParentReferenceV1Alpha1"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IpAddressSpecV1Alpha1(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IpBlock",
    jsii_struct_bases=[],
    name_mapping={"cidr": "cidr", "except_": "except"},
)
class IpBlock:
    def __init__(
        self,
        *,
        cidr: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''IPBlock describes a particular CIDR (Ex.

        "192.168.1.0/24","2001:db8::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.

        :param cidr: cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64".
        :param except_: except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range.

        :schema: io.k8s.api.networking.v1.IPBlock
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71c20730d5ccdd06a5b21c893059aaef59f636482520740da7388e191f115104)
            check_type(argname="argument cidr", value=cidr, expected_type=type_hints["cidr"])
            check_type(argname="argument except_", value=except_, expected_type=type_hints["except_"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "cidr": cidr,
        }
        if except_ is not None:
            self._values["except_"] = except_

    @builtins.property
    def cidr(self) -> builtins.str:
        '''cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64".

        :schema: io.k8s.api.networking.v1.IPBlock#cidr
        '''
        result = self._values.get("cidr")
        assert result is not None, "Required property 'cidr' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def except_(self) -> typing.Optional[typing.List[builtins.str]]:
        '''except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range.

        :schema: io.k8s.api.networking.v1.IPBlock#except
        '''
        result = self._values.get("except_")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IpBlock(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IscsiPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "iqn": "iqn",
        "lun": "lun",
        "target_portal": "targetPortal",
        "chap_auth_discovery": "chapAuthDiscovery",
        "chap_auth_session": "chapAuthSession",
        "fs_type": "fsType",
        "initiator_name": "initiatorName",
        "iscsi_interface": "iscsiInterface",
        "portals": "portals",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class IscsiPersistentVolumeSource:
    def __init__(
        self,
        *,
        iqn: builtins.str,
        lun: jsii.Number,
        target_portal: builtins.str,
        chap_auth_discovery: typing.Optional[builtins.bool] = None,
        chap_auth_session: typing.Optional[builtins.bool] = None,
        fs_type: typing.Optional[builtins.str] = None,
        initiator_name: typing.Optional[builtins.str] = None,
        iscsi_interface: typing.Optional[builtins.str] = None,
        portals: typing.Optional[typing.Sequence[builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["SecretReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ISCSIPersistentVolumeSource represents an ISCSI disk.

        ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.

        :param iqn: iqn is Target iSCSI Qualified Name.
        :param lun: lun is iSCSI Target Lun number.
        :param target_portal: targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param chap_auth_discovery: chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication.
        :param chap_auth_session: chapAuthSession defines whether support iSCSI Session CHAP authentication.
        :param fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param initiator_name: initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.
        :param iscsi_interface: iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp). Default: default' (tcp).
        :param portals: portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. Default: false.
        :param secret_ref: secretRef is the CHAP Secret for iSCSI target and initiator authentication.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7678fbac3338875bdde4517c34bb9be013977af3641cbb92447b848dc4ca6702)
            check_type(argname="argument iqn", value=iqn, expected_type=type_hints["iqn"])
            check_type(argname="argument lun", value=lun, expected_type=type_hints["lun"])
            check_type(argname="argument target_portal", value=target_portal, expected_type=type_hints["target_portal"])
            check_type(argname="argument chap_auth_discovery", value=chap_auth_discovery, expected_type=type_hints["chap_auth_discovery"])
            check_type(argname="argument chap_auth_session", value=chap_auth_session, expected_type=type_hints["chap_auth_session"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument initiator_name", value=initiator_name, expected_type=type_hints["initiator_name"])
            check_type(argname="argument iscsi_interface", value=iscsi_interface, expected_type=type_hints["iscsi_interface"])
            check_type(argname="argument portals", value=portals, expected_type=type_hints["portals"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "iqn": iqn,
            "lun": lun,
            "target_portal": target_portal,
        }
        if chap_auth_discovery is not None:
            self._values["chap_auth_discovery"] = chap_auth_discovery
        if chap_auth_session is not None:
            self._values["chap_auth_session"] = chap_auth_session
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if initiator_name is not None:
            self._values["initiator_name"] = initiator_name
        if iscsi_interface is not None:
            self._values["iscsi_interface"] = iscsi_interface
        if portals is not None:
            self._values["portals"] = portals
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def iqn(self) -> builtins.str:
        '''iqn is Target iSCSI Qualified Name.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#iqn
        '''
        result = self._values.get("iqn")
        assert result is not None, "Required property 'iqn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def lun(self) -> jsii.Number:
        '''lun is iSCSI Target Lun number.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#lun
        '''
        result = self._values.get("lun")
        assert result is not None, "Required property 'lun' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target_portal(self) -> builtins.str:
        '''targetPortal is iSCSI Target Portal.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#targetPortal
        '''
        result = self._values.get("target_portal")
        assert result is not None, "Required property 'target_portal' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def chap_auth_discovery(self) -> typing.Optional[builtins.bool]:
        '''chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#chapAuthDiscovery
        '''
        result = self._values.get("chap_auth_discovery")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def chap_auth_session(self) -> typing.Optional[builtins.bool]:
        '''chapAuthSession defines whether support iSCSI Session CHAP authentication.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#chapAuthSession
        '''
        result = self._values.get("chap_auth_session")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def initiator_name(self) -> typing.Optional[builtins.str]:
        '''initiatorName is the custom iSCSI Initiator Name.

        If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#initiatorName
        '''
        result = self._values.get("initiator_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def iscsi_interface(self) -> typing.Optional[builtins.str]:
        '''iscsiInterface is the interface Name that uses an iSCSI transport.

        Defaults to 'default' (tcp).

        :default: default' (tcp).

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#iscsiInterface
        '''
        result = self._values.get("iscsi_interface")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def portals(self) -> typing.Optional[typing.List[builtins.str]]:
        '''portals is the iSCSI Target Portal List.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#portals
        '''
        result = self._values.get("portals")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false.

        :default: false.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''secretRef is the CHAP Secret for iSCSI target and initiator authentication.

        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IscsiPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.IscsiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "iqn": "iqn",
        "lun": "lun",
        "target_portal": "targetPortal",
        "chap_auth_discovery": "chapAuthDiscovery",
        "chap_auth_session": "chapAuthSession",
        "fs_type": "fsType",
        "initiator_name": "initiatorName",
        "iscsi_interface": "iscsiInterface",
        "portals": "portals",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class IscsiVolumeSource:
    def __init__(
        self,
        *,
        iqn: builtins.str,
        lun: jsii.Number,
        target_portal: builtins.str,
        chap_auth_discovery: typing.Optional[builtins.bool] = None,
        chap_auth_session: typing.Optional[builtins.bool] = None,
        fs_type: typing.Optional[builtins.str] = None,
        initiator_name: typing.Optional[builtins.str] = None,
        iscsi_interface: typing.Optional[builtins.str] = None,
        portals: typing.Optional[typing.Sequence[builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional[typing.Union["LocalObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Represents an ISCSI disk.

        ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.

        :param iqn: iqn is the target iSCSI Qualified Name.
        :param lun: lun represents iSCSI Target Lun number.
        :param target_portal: targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param chap_auth_discovery: chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication.
        :param chap_auth_session: chapAuthSession defines whether support iSCSI Session CHAP authentication.
        :param fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param initiator_name: initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.
        :param iscsi_interface: iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp). Default: default' (tcp).
        :param portals: portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. Default: false.
        :param secret_ref: secretRef is the CHAP Secret for iSCSI target and initiator authentication.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__258d64405b0e7755af56f11855bca97a9af060db4254b5334b64b658f1b931bc)
            check_type(argname="argument iqn", value=iqn, expected_type=type_hints["iqn"])
            check_type(argname="argument lun", value=lun, expected_type=type_hints["lun"])
            check_type(argname="argument target_portal", value=target_portal, expected_type=type_hints["target_portal"])
            check_type(argname="argument chap_auth_discovery", value=chap_auth_discovery, expected_type=type_hints["chap_auth_discovery"])
            check_type(argname="argument chap_auth_session", value=chap_auth_session, expected_type=type_hints["chap_auth_session"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument initiator_name", value=initiator_name, expected_type=type_hints["initiator_name"])
            check_type(argname="argument iscsi_interface", value=iscsi_interface, expected_type=type_hints["iscsi_interface"])
            check_type(argname="argument portals", value=portals, expected_type=type_hints["portals"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument secret_ref", value=secret_ref, expected_type=type_hints["secret_ref"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "iqn": iqn,
            "lun": lun,
            "target_portal": target_portal,
        }
        if chap_auth_discovery is not None:
            self._values["chap_auth_discovery"] = chap_auth_discovery
        if chap_auth_session is not None:
            self._values["chap_auth_session"] = chap_auth_session
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if initiator_name is not None:
            self._values["initiator_name"] = initiator_name
        if iscsi_interface is not None:
            self._values["iscsi_interface"] = iscsi_interface
        if portals is not None:
            self._values["portals"] = portals
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def iqn(self) -> builtins.str:
        '''iqn is the target iSCSI Qualified Name.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#iqn
        '''
        result = self._values.get("iqn")
        assert result is not None, "Required property 'iqn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def lun(self) -> jsii.Number:
        '''lun represents iSCSI Target Lun number.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#lun
        '''
        result = self._values.get("lun")
        assert result is not None, "Required property 'lun' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target_portal(self) -> builtins.str:
        '''targetPortal is iSCSI Target Portal.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#targetPortal
        '''
        result = self._values.get("target_portal")
        assert result is not None, "Required property 'target_portal' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def chap_auth_discovery(self) -> typing.Optional[builtins.bool]:
        '''chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#chapAuthDiscovery
        '''
        result = self._values.get("chap_auth_discovery")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def chap_auth_session(self) -> typing.Optional[builtins.bool]:
        '''chapAuthSession defines whether support iSCSI Session CHAP authentication.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#chapAuthSession
        '''
        result = self._values.get("chap_auth_session")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''fsType is the filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def initiator_name(self) -> typing.Optional[builtins.str]:
        '''initiatorName is the custom iSCSI Initiator Name.

        If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#initiatorName
        '''
        result = self._values.get("initiator_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def iscsi_interface(self) -> typing.Optional[builtins.str]:
        '''iscsiInterface is the interface Name that uses an iSCSI transport.

        Defaults to 'default' (tcp).

        :default: default' (tcp).

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#iscsiInterface
        '''
        result = self._values.get("iscsi_interface")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def portals(self) -> typing.Optional[typing.List[builtins.str]]:
        '''portals is the iSCSI Target Portal List.

        The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#portals
        '''
        result = self._values.get("portals")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''readOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false.

        :default: false.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''secretRef is the CHAP Secret for iSCSI target and initiator authentication.

        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IscsiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.JobSpec",
    jsii_struct_bases=[],
    name_mapping={
        "template": "template",
        "active_deadline_seconds": "activeDeadlineSeconds",
        "backoff_limit": "backoffLimit",
        "backoff_limit_per_index": "backoffLimitPerIndex",
        "completion_mode": "completionMode",
        "completions": "completions",
        "manual_selector": "manualSelector",
        "max_failed_indexes": "maxFailedIndexes",
        "parallelism": "parallelism",
        "pod_failure_policy": "podFailurePolicy",
        "pod_replacement_policy": "podReplacementPolicy",
        "selector": "selector",
        "suspend": "suspend",
        "ttl_seconds_after_finished": "ttlSecondsAfterFinished",
    },
)
class JobSpec:
    def __init__(
        self,
        *,
        template: typing.Union["PodTemplateSpec", typing.Dict[builtins.str, typing.Any]],
        active_deadline_seconds: typing.Optional[jsii.Number] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        backoff_limit_per_index: typing.Optional[jsii.Number] = None,
        completion_mode: typing.Optional[builtins.str] = None,
        completions: typing.Optional[jsii.Number] = None,
        manual_selector: typing.Optional[builtins.bool] = None,
        max_failed_indexes: typing.Optional[jsii.Number] = None,
        parallelism: typing.Optional[jsii.Number] = None,
        pod_failure_policy: typing.Optional[typing.Union["PodFailurePolicy", typing.Dict[builtins.str, typing.Any]]] = None,
        pod_replacement_policy: typing.Optional[builtins.str] = None,
        selector: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
        suspend: typing.Optional[builtins.bool] = None,
        ttl_seconds_after_finished: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''JobSpec describes how the job execution will look like.

        :param template: Describes the pod that will be created when executing a job. The only allowed template.spec.restartPolicy values are "Never" or "OnFailure". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param active_deadline_seconds: Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Defaults to 6 Default: 6
        :param backoff_limit_per_index: Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable. This field is alpha-level. It can be used when the ``JobBackoffLimitPerIndex`` feature gate is enabled (disabled by default).
        :param completion_mode: completionMode specifies how Pod completions are tracked. It can be ``NonIndexed`` (default) or ``Indexed``. ``NonIndexed`` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other. ``Indexed`` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is ``Indexed``, .spec.completions must be specified and ``.spec.parallelism`` must be less than or equal to 10^5. In addition, The Pod name takes the form ``$(job-name)-$(index)-$(random-string)``, the Pod hostname takes the form ``$(job-name)-$(index)``. More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.
        :param completions: Specifies the desired number of successfully finished pods the job should be run with. Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value. Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param manual_selector: manualSelector controls generation of pod labels and pod selectors. Leave ``manualSelector`` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template. When true, the user is responsible for picking unique labels and specifying the selector. Failure to pick a unique label may cause this and other jobs to not function correctly. However, You may see ``manualSelector=true`` in jobs that were created with the old ``extensions/v1beta1`` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
        :param max_failed_indexes: Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the ``Complete`` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5. This field is alpha-level. It can be used when the ``JobBackoffLimitPerIndex`` feature gate is enabled (disabled by default).
        :param parallelism: Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param pod_failure_policy: Specifies the policy of handling failed pods. In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure. This field is beta-level. It can be used when the ``JobPodFailurePolicy`` feature gate is enabled (enabled by default).
        :param pod_replacement_policy: podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods when they are terminating (has a metadata.deletionTimestamp) or failed. - Failed means to wait until a previously created Pod is fully terminated (has phase Failed or Succeeded) before creating a replacement Pod. When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an alpha field. Enable JobPodReplacementPolicy to be able to use this field.
        :param selector: A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param suspend: suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false. Default: false.
        :param ttl_seconds_after_finished: ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.

        :schema: io.k8s.api.batch.v1.JobSpec
        '''
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(pod_failure_policy, dict):
            pod_failure_policy = PodFailurePolicy(**pod_failure_policy)
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df0260977316b272d456b5d85a4bb97d97bef96bb64188913c60380e25c5b305)
            check_type(argname="argument template", value=template, expected_type=type_hints["template"])
            check_type(argname="argument active_deadline_seconds", value=active_deadline_seconds, expected_type=type_hints["active_deadline_seconds"])
            check_type(argname="argument backoff_limit", value=backoff_limit, expected_type=type_hints["backoff_limit"])
            check_type(argname="argument backoff_limit_per_index", value=backoff_limit_per_index, expected_type=type_hints["backoff_limit_per_index"])
            check_type(argname="argument completion_mode", value=completion_mode, expected_type=type_hints["completion_mode"])
            check_type(argname="argument completions", value=completions, expected_type=type_hints["completions"])
            check_type(argname="argument manual_selector", value=manual_selector, expected_type=type_hints["manual_selector"])
            check_type(argname="argument max_failed_indexes", value=max_failed_indexes, expected_type=type_hints["max_failed_indexes"])
            check_type(argname="argument parallelism", value=parallelism, expected_type=type_hints["parallelism"])
            check_type(argname="argument pod_failure_policy", value=pod_failure_policy, expected_type=type_hints["pod_failure_policy"])
            check_type(argname="argument pod_replacement_policy", value=pod_replacement_policy, expected_type=type_hints["pod_replacement_policy"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument suspend", value=suspend, expected_type=type_hints["suspend"])
            check_type(argname="argument ttl_seconds_after_finished", value=ttl_seconds_after_finished, expected_type=type_hints["ttl_seconds_after_finished"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "template": template,
        }
        if active_deadline_seconds is not None:
            self._values["active_deadline_seconds"] = active_deadline_seconds
        if backoff_limit is not None:
            self._values["backoff_limit"] = backoff_limit
        if backoff_limit_per_index is not None:
            self._values["backoff_limit_per_index"] = backoff_limit_per_index
        if completion_mode is not None:
            self._values["completion_mode"] = completion_mode
        if completions is not None:
            self._values["completions"] = completions
        if manual_selector is not None:
            self._values["manual_selector"] = manual_selector
        if max_failed_indexes is not None:
            self._values["max_failed_indexes"] = max_failed_indexes
        if parallelism is not None:
            self._values["parallelism"] = parallelism
        if pod_failure_policy is not None:
            self._values["pod_failure_policy"] = pod_failure_policy
        if pod_replacement_policy is not None:
            self._values["pod_replacement_policy"] = pod_replacement_policy
        if selector is not None:
            self._values["selector"] = selector
        if suspend is not None:
            self._values["suspend"] = suspend
        if ttl_seconds_after_finished is not None:
            self._values["ttl_seconds_after_finished"] = ttl_seconds_after_finished

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''Describes the pod that will be created when executing a job.

        The only allowed template.spec.restartPolicy values are "Never" or "OnFailure". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :schema: io.k8s.api.batch.v1.JobSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def active_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it;

        value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.

        :schema: io.k8s.api.batch.v1.JobSpec#activeDeadlineSeconds
        '''
        result = self._values.get("active_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Specifies the number of retries before marking this job failed.

        Defaults to 6

        :default: 6

        :schema: io.k8s.api.batch.v1.JobSpec#backoffLimit
        '''
        result = self._values.get("backoff_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def backoff_limit_per_index(self) -> typing.Optional[jsii.Number]:
        '''Specifies the limit for the number of retries within an index before marking this index as failed.

        When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable. This field is alpha-level. It can be used when the ``JobBackoffLimitPerIndex`` feature gate is enabled (disabled by default).

        :schema: io.k8s.api.batch.v1.JobSpec#backoffLimitPerIndex
        '''
        result = self._values.get("backoff_limit_per_index")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def completion_mode(self) -> typing.Optional[builtins.str]:
        '''completionMode specifies how Pod completions are tracked. It can be ``NonIndexed`` (default) or ``Indexed``.

        ``NonIndexed`` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.

        ``Indexed`` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is ``Indexed``, .spec.completions must be specified and ``.spec.parallelism`` must be less than or equal to 10^5. In addition, The Pod name takes the form ``$(job-name)-$(index)-$(random-string)``, the Pod hostname takes the form ``$(job-name)-$(index)``.

        More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.

        :schema: io.k8s.api.batch.v1.JobSpec#completionMode
        '''
        result = self._values.get("completion_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def completions(self) -> typing.Optional[jsii.Number]:
        '''Specifies the desired number of successfully finished pods the job should be run with.

        Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :schema: io.k8s.api.batch.v1.JobSpec#completions
        '''
        result = self._values.get("completions")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def manual_selector(self) -> typing.Optional[builtins.bool]:
        '''manualSelector controls generation of pod labels and pod selectors.

        Leave ``manualSelector`` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see ``manualSelector=true`` in jobs that were created with the old ``extensions/v1beta1`` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector

        :schema: io.k8s.api.batch.v1.JobSpec#manualSelector
        '''
        result = self._values.get("manual_selector")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def max_failed_indexes(self) -> typing.Optional[jsii.Number]:
        '''Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set.

        Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the ``Complete`` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5. This field is alpha-level. It can be used when the ``JobBackoffLimitPerIndex`` feature gate is enabled (disabled by default).

        :schema: io.k8s.api.batch.v1.JobSpec#maxFailedIndexes
        '''
        result = self._values.get("max_failed_indexes")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def parallelism(self) -> typing.Optional[jsii.Number]:
        '''Specifies the maximum desired number of pods the job should run at any given time.

        The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :schema: io.k8s.api.batch.v1.JobSpec#parallelism
        '''
        result = self._values.get("parallelism")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def pod_failure_policy(self) -> typing.Optional["PodFailurePolicy"]:
        '''Specifies the policy of handling failed pods.

        In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure.

        This field is beta-level. It can be used when the ``JobPodFailurePolicy`` feature gate is enabled (enabled by default).

        :schema: io.k8s.api.batch.v1.JobSpec#podFailurePolicy
        '''
        result = self._values.get("pod_failure_policy")
        return typing.cast(typing.Optional["PodFailurePolicy"], result)

    @builtins.property
    def pod_replacement_policy(self) -> typing.Optional[builtins.str]:
        '''podReplacementPolicy specifies when to create replacement Pods.

        Possible values are: - TerminatingOrFailed means that we recreate pods
        when they are terminating (has a metadata.deletionTimestamp) or failed.

        - Failed means to wait until a previously created Pod is fully terminated (has phase
          Failed or Succeeded) before creating a replacement Pod.

        When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an alpha field. Enable JobPodReplacementPolicy to be able to use this field.

        :schema: io.k8s.api.batch.v1.JobSpec#podReplacementPolicy
        '''
        result = self._values.get("pod_replacement_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def selector(self) -> typing.Optional["LabelSelector"]:
        '''A label query over pods that should match the pod count.

        Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors

        :schema: io.k8s.api.batch.v1.JobSpec#selector
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional["LabelSelector"], result)

    @builtins.property
    def suspend(self) -> typing.Optional[builtins.bool]:
        '''suspend specifies whether the Job controller should create Pods or not.

        If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.

        :default: false.

        :schema: io.k8s.api.batch.v1.JobSpec#suspend
        '''
        result = self._values.get("suspend")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def ttl_seconds_after_finished(self) -> typing.Optional[jsii.Number]:
        '''ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed).

        If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.

        :schema: io.k8s.api.batch.v1.JobSpec#ttlSecondsAfterFinished
        '''
        result = self._values.get("ttl_seconds_after_finished")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.JobTemplateSpec",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class JobTemplateSpec:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[JobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''JobTemplateSpec describes the data a Job should have when created from a template.

        :param metadata: Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1.JobTemplateSpec
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = JobSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__febefbf508e80fabc85d8fd18203f0adb3805a7bf75078b6c3119598372e5cbf)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata of the jobs created from this template.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1.JobTemplateSpec#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[JobSpec]:
        '''Specification of the desired behavior of the job.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1.JobTemplateSpec#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[JobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobTemplateSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.JsonSchemaProps",
    jsii_struct_bases=[],
    name_mapping={
        "additional_items": "additionalItems",
        "additional_properties": "additionalProperties",
        "all_of": "allOf",
        "any_of": "anyOf",
        "default": "default",
        "definitions": "definitions",
        "dependencies": "dependencies",
        "description": "description",
        "enum": "enum",
        "example": "example",
        "exclusive_maximum": "exclusiveMaximum",
        "exclusive_minimum": "exclusiveMinimum",
        "external_docs": "externalDocs",
        "format": "format",
        "id": "id",
        "items": "items",
        "maximum": "maximum",
        "max_items": "maxItems",
        "max_length": "maxLength",
        "max_properties": "maxProperties",
        "minimum": "minimum",
        "min_items": "minItems",
        "min_length": "minLength",
        "min_properties": "minProperties",
        "multiple_of": "multipleOf",
        "not_": "not",
        "nullable": "nullable",
        "one_of": "oneOf",
        "pattern": "pattern",
        "pattern_properties": "patternProperties",
        "properties": "properties",
        "ref": "ref",
        "required": "required",
        "schema": "schema",
        "title": "title",
        "type": "type",
        "unique_items": "uniqueItems",
        "x_kubernetes_embedded_resource": "xKubernetesEmbeddedResource",
        "x_kubernetes_int_or_string": "xKubernetesIntOrString",
        "x_kubernetes_list_map_keys": "xKubernetesListMapKeys",
        "x_kubernetes_list_type": "xKubernetesListType",
        "x_kubernetes_map_type": "xKubernetesMapType",
        "x_kubernetes_preserve_unknown_fields": "xKubernetesPreserveUnknownFields",
        "x_kubernetes_validations": "xKubernetesValidations",
    },
)
class JsonSchemaProps:
    def __init__(
        self,
        *,
        additional_items: typing.Any = None,
        additional_properties: typing.Any = None,
        all_of: typing.Optional[typing.Sequence[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        any_of: typing.Optional[typing.Sequence[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        default: typing.Any = None,
        definitions: typing.Optional[typing.Mapping[builtins.str, typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        dependencies: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        description: typing.Optional[builtins.str] = None,
        enum: typing.Optional[typing.Sequence[typing.Any]] = None,
        example: typing.Any = None,
        exclusive_maximum: typing.Optional[builtins.bool] = None,
        exclusive_minimum: typing.Optional[builtins.bool] = None,
        external_docs: typing.Optional[typing.Union[ExternalDocumentation, typing.Dict[builtins.str, typing.Any]]] = None,
        format: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        items: typing.Any = None,
        maximum: typing.Optional[jsii.Number] = None,
        max_items: typing.Optional[jsii.Number] = None,
        max_length: typing.Optional[jsii.Number] = None,
        max_properties: typing.Optional[jsii.Number] = None,
        minimum: typing.Optional[jsii.Number] = None,
        min_items: typing.Optional[jsii.Number] = None,
        min_length: typing.Optional[jsii.Number] = None,
        min_properties: typing.Optional[jsii.Number] = None,
        multiple_of: typing.Optional[jsii.Number] = None,
        not_: typing.Optional[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]] = None,
        nullable: typing.Optional[builtins.bool] = None,
        one_of: typing.Optional[typing.Sequence[typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        pattern: typing.Optional[builtins.str] = None,
        pattern_properties: typing.Optional[typing.Mapping[builtins.str, typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        properties: typing.Optional[typing.Mapping[builtins.str, typing.Union["JsonSchemaProps", typing.Dict[builtins.str, typing.Any]]]] = None,
        ref: typing.Optional[builtins.str] = None,
        required: typing.Optional[typing.Sequence[builtins.str]] = None,
        schema: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        unique_items: typing.Optional[builtins.bool] = None,
        x_kubernetes_embedded_resource: typing.Optional[builtins.bool] = None,
        x_kubernetes_int_or_string: typing.Optional[builtins.bool] = None,
        x_kubernetes_list_map_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
        x_kubernetes_list_type: typing.Optional[builtins.str] = None,
        x_kubernetes_map_type: typing.Optional[builtins.str] = None,
        x_kubernetes_preserve_unknown_fields: typing.Optional[builtins.bool] = None,
        x_kubernetes_validations: typing.Optional[typing.Sequence[typing.Union["ValidationRule", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).

        :param additional_items: 
        :param additional_properties: 
        :param all_of: 
        :param any_of: 
        :param default: default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
        :param definitions: 
        :param dependencies: 
        :param description: 
        :param enum: 
        :param example: 
        :param exclusive_maximum: 
        :param exclusive_minimum: 
        :param external_docs: 
        :param format: format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:. - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        :param id: 
        :param items: 
        :param maximum: 
        :param max_items: 
        :param max_length: 
        :param max_properties: 
        :param minimum: 
        :param min_items: 
        :param min_length: 
        :param min_properties: 
        :param multiple_of: 
        :param not_: 
        :param nullable: 
        :param one_of: 
        :param pattern: 
        :param pattern_properties: 
        :param properties: 
        :param ref: 
        :param required: 
        :param schema: 
        :param title: 
        :param type: 
        :param unique_items: 
        :param x_kubernetes_embedded_resource: x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        :param x_kubernetes_int_or_string: x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns: 1. anyOf: - type: integer - type: string 2. allOf: - anyOf: - type: integer - type: string - ... zero or more
        :param x_kubernetes_list_map_keys: x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type ``map`` by specifying the keys used as the index of the map. This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported). The properties specified must either be required or have a default value, to ensure those properties are present for all list items.
        :param x_kubernetes_list_type: x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values: 1. ``atomic``: the list is treated as a single entity, like a scalar. Atomic lists will be entirely replaced when updated. This extension may be used on any type of list (struct, scalar, ...). 2. ``set``: Sets are lists that must not have multiple items with the same value. Each value must be a scalar, an object with x-kubernetes-map-type ``atomic`` or an array with x-kubernetes-list-type ``atomic``. 3. ``map``: These lists are like maps in that their elements have a non-index key used to identify them. Order is preserved upon merge. The map tag must only be used on a list with elements of type object. Defaults to atomic for arrays. Default: atomic for arrays.
        :param x_kubernetes_map_type: x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values: 1. ``granular``: These maps are actual maps (key-value pairs) and each fields are independent from each other (they can each be manipulated by separate actors). This is the default behaviour for all maps. 2. ``atomic``: the list is treated as a single entity, like a scalar. Atomic maps will be entirely replaced when updated.
        :param x_kubernetes_preserve_unknown_fields: x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        :param x_kubernetes_validations: x-kubernetes-validations describes a list of validation rules written in the CEL expression language. This field is an alpha-level. Using this field requires the feature gate ``CustomResourceValidationExpressions`` to be enabled.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps
        '''
        if isinstance(external_docs, dict):
            external_docs = ExternalDocumentation(**external_docs)
        if isinstance(not_, dict):
            not_ = JsonSchemaProps(**not_)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5e023987703fb6134f89933401fe35223c015cf2d8ae516f37e3d6e36919df1d)
            check_type(argname="argument additional_items", value=additional_items, expected_type=type_hints["additional_items"])
            check_type(argname="argument additional_properties", value=additional_properties, expected_type=type_hints["additional_properties"])
            check_type(argname="argument all_of", value=all_of, expected_type=type_hints["all_of"])
            check_type(argname="argument any_of", value=any_of, expected_type=type_hints["any_of"])
            check_type(argname="argument default", value=default, expected_type=type_hints["default"])
            check_type(argname="argument definitions", value=definitions, expected_type=type_hints["definitions"])
            check_type(argname="argument dependencies", value=dependencies, expected_type=type_hints["dependencies"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument enum", value=enum, expected_type=type_hints["enum"])
            check_type(argname="argument example", value=example, expected_type=type_hints["example"])
            check_type(argname="argument exclusive_maximum", value=exclusive_maximum, expected_type=type_hints["exclusive_maximum"])
            check_type(argname="argument exclusive_minimum", value=exclusive_minimum, expected_type=type_hints["exclusive_minimum"])
            check_type(argname="argument external_docs", value=external_docs, expected_type=type_hints["external_docs"])
            check_type(argname="argument format", value=format, expected_type=type_hints["format"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument maximum", value=maximum, expected_type=type_hints["maximum"])
            check_type(argname="argument max_items", value=max_items, expected_type=type_hints["max_items"])
            check_type(argname="argument max_length", value=max_length, expected_type=type_hints["max_length"])
            check_type(argname="argument max_properties", value=max_properties, expected_type=type_hints["max_properties"])
            check_type(argname="argument minimum", value=minimum, expected_type=type_hints["minimum"])
            check_type(argname="argument min_items", value=min_items, expected_type=type_hints["min_items"])
            check_type(argname="argument min_length", value=min_length, expected_type=type_hints["min_length"])
            check_type(argname="argument min_properties", value=min_properties, expected_type=type_hints["min_properties"])
            check_type(argname="argument multiple_of", value=multiple_of, expected_type=type_hints["multiple_of"])
            check_type(argname="argument not_", value=not_, expected_type=type_hints["not_"])
            check_type(argname="argument nullable", value=nullable, expected_type=type_hints["nullable"])
            check_type(argname="argument one_of", value=one_of, expected_type=type_hints["one_of"])
            check_type(argname="argument pattern", value=pattern, expected_type=type_hints["pattern"])
            check_type(argname="argument pattern_properties", value=pattern_properties, expected_type=type_hints["pattern_properties"])
            check_type(argname="argument properties", value=properties, expected_type=type_hints["properties"])
            check_type(argname="argument ref", value=ref, expected_type=type_hints["ref"])
            check_type(argname="argument required", value=required, expected_type=type_hints["required"])
            check_type(argname="argument schema", value=schema, expected_type=type_hints["schema"])
            check_type(argname="argument title", value=title, expected_type=type_hints["title"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument unique_items", value=unique_items, expected_type=type_hints["unique_items"])
            check_type(argname="argument x_kubernetes_embedded_resource", value=x_kubernetes_embedded_resource, expected_type=type_hints["x_kubernetes_embedded_resource"])
            check_type(argname="argument x_kubernetes_int_or_string", value=x_kubernetes_int_or_string, expected_type=type_hints["x_kubernetes_int_or_string"])
            check_type(argname="argument x_kubernetes_list_map_keys", value=x_kubernetes_list_map_keys, expected_type=type_hints["x_kubernetes_list_map_keys"])
            check_type(argname="argument x_kubernetes_list_type", value=x_kubernetes_list_type, expected_type=type_hints["x_kubernetes_list_type"])
            check_type(argname="argument x_kubernetes_map_type", value=x_kubernetes_map_type, expected_type=type_hints["x_kubernetes_map_type"])
            check_type(argname="argument x_kubernetes_preserve_unknown_fields", value=x_kubernetes_preserve_unknown_fields, expected_type=type_hints["x_kubernetes_preserve_unknown_fields"])
            check_type(argname="argument x_kubernetes_validations", value=x_kubernetes_validations, expected_type=type_hints["x_kubernetes_validations"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if additional_items is not None:
            self._values["additional_items"] = additional_items
        if additional_properties is not None:
            self._values["additional_properties"] = additional_properties
        if all_of is not None:
            self._values["all_of"] = all_of
        if any_of is not None:
            self._values["any_of"] = any_of
        if default is not None:
            self._values["default"] = default
        if definitions is not None:
            self._values["definitions"] = definitions
        if dependencies is not None:
            self._values["dependencies"] = dependencies
        if description is not None:
            self._values["description"] = description
        if enum is not None:
            self._values["enum"] = enum
        if example is not None:
            self._values["example"] = example
        if exclusive_maximum is not None:
            self._values["exclusive_maximum"] = exclusive_maximum
        if exclusive_minimum is not None:
            self._values["exclusive_minimum"] = exclusive_minimum
        if external_docs is not None:
            self._values["external_docs"] = external_docs
        if format is not None:
            self._values["format"] = format
        if id is not None:
            self._values["id"] = id
        if items is not None:
            self._values["items"] = items
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_items is not None:
            self._values["max_items"] = max_items
        if max_length is not None:
            self._values["max_length"] = max_length
        if max_properties is not None:
            self._values["max_properties"] = max_properties
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_items is not None:
            self._values["min_items"] = min_items
        if min_length is not None:
            self._values["min_length"] = min_length
        if min_properties is not None:
            self._values["min_properties"] = min_properties
        if multiple_of is not None:
            self._values["multiple_of"] = multiple_of
        if not_ is not None:
            self._values["not_"] = not_
        if nullable is not None:
            self._values["nullable"] = nullable
        if one_of is not None:
            self._values["one_of"] = one_of
        if pattern is not None:
            self._values["pattern"] = pattern
        if pattern_properties is not None:
            self._values["pattern_properties"] = pattern_properties
        if properties is not None:
            self._values["properties"] = properties
        if ref is not None:
            self._values["ref"] = ref
        if required is not None:
            self._values["required"] = required
        if schema is not None:
            self._values["schema"] = schema
        if title is not None:
            self._values["title"] = title
        if type is not None:
            self._values["type"] = type
        if unique_items is not None:
            self._values["unique_items"] = unique_items
        if x_kubernetes_embedded_resource is not None:
            self._values["x_kubernetes_embedded_resource"] = x_kubernetes_embedded_resource
        if x_kubernetes_int_or_string is not None:
            self._values["x_kubernetes_int_or_string"] = x_kubernetes_int_or_string
        if x_kubernetes_list_map_keys is not None:
            self._values["x_kubernetes_list_map_keys"] = x_kubernetes_list_map_keys
        if x_kubernetes_list_type is not None:
            self._values["x_kubernetes_list_type"] = x_kubernetes_list_type
        if x_kubernetes_map_type is not None:
            self._values["x_kubernetes_map_type"] = x_kubernetes_map_type
        if x_kubernetes_preserve_unknown_fields is not None:
            self._values["x_kubernetes_preserve_unknown_fields"] = x_kubernetes_preserve_unknown_fields
        if x_kubernetes_validations is not None:
            self._values["x_kubernetes_validations"] = x_kubernetes_validations

    @builtins.property
    def additional_items(self) -> typing.Any:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#additionalItems
        '''
        result = self._values.get("additional_items")
        return typing.cast(typing.Any, result)

    @builtins.property
    def additional_properties(self) -> typing.Any:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#additionalProperties
        '''
        result = self._values.get("additional_properties")
        return typing.cast(typing.Any, result)

    @builtins.property
    def all_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#allOf
        '''
        result = self._values.get("all_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def any_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#anyOf
        '''
        result = self._values.get("any_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def default(self) -> typing.Any:
        '''default is a default value for undefined object fields.

        Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#default
        '''
        result = self._values.get("default")
        return typing.cast(typing.Any, result)

    @builtins.property
    def definitions(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#definitions
        '''
        result = self._values.get("definitions")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def dependencies(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#dependencies
        '''
        result = self._values.get("dependencies")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def enum(self) -> typing.Optional[typing.List[typing.Any]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#enum
        '''
        result = self._values.get("enum")
        return typing.cast(typing.Optional[typing.List[typing.Any]], result)

    @builtins.property
    def example(self) -> typing.Any:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#example
        '''
        result = self._values.get("example")
        return typing.cast(typing.Any, result)

    @builtins.property
    def exclusive_maximum(self) -> typing.Optional[builtins.bool]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#exclusiveMaximum
        '''
        result = self._values.get("exclusive_maximum")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def exclusive_minimum(self) -> typing.Optional[builtins.bool]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#exclusiveMinimum
        '''
        result = self._values.get("exclusive_minimum")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def external_docs(self) -> typing.Optional[ExternalDocumentation]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#externalDocs
        '''
        result = self._values.get("external_docs")
        return typing.cast(typing.Optional[ExternalDocumentation], result)

    @builtins.property
    def format(self) -> typing.Optional[builtins.str]:
        '''format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:.

        - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#format
        '''
        result = self._values.get("format")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#id
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def items(self) -> typing.Any:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Any, result)

    @builtins.property
    def maximum(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#maximum
        '''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_items(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#maxItems
        '''
        result = self._values.get("max_items")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_length(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#maxLength
        '''
        result = self._values.get("max_length")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_properties(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#maxProperties
        '''
        result = self._values.get("max_properties")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def minimum(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#minimum
        '''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_items(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#minItems
        '''
        result = self._values.get("min_items")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_length(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#minLength
        '''
        result = self._values.get("min_length")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_properties(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#minProperties
        '''
        result = self._values.get("min_properties")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def multiple_of(self) -> typing.Optional[jsii.Number]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#multipleOf
        '''
        result = self._values.get("multiple_of")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def not_(self) -> typing.Optional["JsonSchemaProps"]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#not
        '''
        result = self._values.get("not_")
        return typing.cast(typing.Optional["JsonSchemaProps"], result)

    @builtins.property
    def nullable(self) -> typing.Optional[builtins.bool]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#nullable
        '''
        result = self._values.get("nullable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def one_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#oneOf
        '''
        result = self._values.get("one_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def pattern(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#pattern
        '''
        result = self._values.get("pattern")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def pattern_properties(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#patternProperties
        '''
        result = self._values.get("pattern_properties")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def properties(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#properties
        '''
        result = self._values.get("properties")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def ref(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#$ref
        '''
        result = self._values.get("ref")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def required(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#required
        '''
        result = self._values.get("required")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def schema(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#$schema
        '''
        result = self._values.get("schema")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#title
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unique_items(self) -> typing.Optional[builtins.bool]:
        '''
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#uniqueItems
        '''
        result = self._values.get("unique_items")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def x_kubernetes_embedded_resource(self) -> typing.Optional[builtins.bool]:
        '''x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-embedded-resource
        '''
        result = self._values.get("x_kubernetes_embedded_resource")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def x_kubernetes_int_or_string(self) -> typing.Optional[builtins.bool]:
        '''x-kubernetes-int-or-string specifies that this value is either an integer or a string.

        If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:

        1. anyOf:

        - type: integer
        - type: string

        1. allOf:

        - anyOf:
        - type: integer
        - type: string
        - ... zero or more

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-int-or-string
        '''
        result = self._values.get("x_kubernetes_int_or_string")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def x_kubernetes_list_map_keys(self) -> typing.Optional[typing.List[builtins.str]]:
        '''x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type ``map`` by specifying the keys used as the index of the map.

        This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).

        The properties specified must either be required or have a default value, to ensure those properties are present for all list items.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-list-map-keys
        '''
        result = self._values.get("x_kubernetes_list_map_keys")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def x_kubernetes_list_type(self) -> typing.Optional[builtins.str]:
        '''x-kubernetes-list-type annotates an array to further describe its topology.

        This extension must only be used on lists and may have 3 possible values:

        1. ``atomic``: the list is treated as a single entity, like a scalar.
           Atomic lists will be entirely replaced when updated. This extension
           may be used on any type of list (struct, scalar, ...).
        2. ``set``:
           Sets are lists that must not have multiple items with the same value. Each
           value must be a scalar, an object with x-kubernetes-map-type ``atomic`` or an
           array with x-kubernetes-list-type ``atomic``.
        3. ``map``:
           These lists are like maps in that their elements have a non-index key
           used to identify them. Order is preserved upon merge. The map tag
           must only be used on a list with elements of type object.
           Defaults to atomic for arrays.

        :default: atomic for arrays.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-list-type
        '''
        result = self._values.get("x_kubernetes_list_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def x_kubernetes_map_type(self) -> typing.Optional[builtins.str]:
        '''x-kubernetes-map-type annotates an object to further describe its topology.

        This extension must only be used when type is object and may have 2 possible values:

        1. ``granular``:
           These maps are actual maps (key-value pairs) and each fields are independent
           from each other (they can each be manipulated by separate actors). This is
           the default behaviour for all maps.
        2. ``atomic``: the list is treated as a single entity, like a scalar.
           Atomic maps will be entirely replaced when updated.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-map-type
        '''
        result = self._values.get("x_kubernetes_map_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def x_kubernetes_preserve_unknown_fields(self) -> typing.Optional[builtins.bool]:
        '''x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema.

        This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-preserve-unknown-fields
        '''
        result = self._values.get("x_kubernetes_preserve_unknown_fields")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def x_kubernetes_validations(
        self,
    ) -> typing.Optional[typing.List["ValidationRule"]]:
        '''x-kubernetes-validations describes a list of validation rules written in the CEL expression language.

        This field is an alpha-level. Using this field requires the feature gate ``CustomResourceValidationExpressions`` to be enabled.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps#x-kubernetes-validations
        '''
        result = self._values.get("x_kubernetes_validations")
        return typing.cast(typing.Optional[typing.List["ValidationRule"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JsonSchemaProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KeyToPath",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "path": "path", "mode": "mode"},
)
class KeyToPath:
    def __init__(
        self,
        *,
        key: builtins.str,
        path: builtins.str,
        mode: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Maps a string key to a path within a volume.

        :param key: key is the key to project.
        :param path: path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        :param mode: mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.KeyToPath
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8783e9fa9ff78c09421ac3464c90a75cf638528f9c7d06acc6a4a96d9fcf40e7)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "path": path,
        }
        if mode is not None:
            self._values["mode"] = mode

    @builtins.property
    def key(self) -> builtins.str:
        '''key is the key to project.

        :schema: io.k8s.api.core.v1.KeyToPath#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''path is the relative path of the file to map the key to.

        May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.

        :schema: io.k8s.api.core.v1.KeyToPath#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''mode is Optional: mode bits used to set permissions on this file.

        Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :schema: io.k8s.api.core.v1.KeyToPath#mode
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KeyToPath(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeApiService(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeApiService",
):
    '''APIService represents a server for a particular GroupVersion.

    Name must be "version.group".

    :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ApiServiceSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Spec contains information for locating and communicating with a server.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__51193ee9483b345e608843870bb0a74d7902e7399a2d524892ccd3349009601e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeApiServiceProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ApiServiceSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Spec contains information for locating and communicating with a server.
        '''
        props = KubeApiServiceProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeApiServiceList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeApiServiceList",
):
    '''APIServiceList is a list of APIService objects.

    :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeApiServiceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of APIService.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f1dd3d94919682c7aa7174d5d02c9449cda8f577d43edccafeb8c66dc0230c0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeApiServiceListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeApiServiceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of APIService.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeApiServiceListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeApiServiceListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeApiServiceListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeApiServiceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''APIServiceList is a list of APIService objects.

        :param items: Items is the list of APIService.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e02dff1b7a511a773fdb30ed56bd0f9032f1a93e3256eb8269590fbe87ed193)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeApiServiceProps"]:
        '''Items is the list of APIService.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeApiServiceProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeApiServiceListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeApiServiceProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeApiServiceProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ApiServiceSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''APIService represents a server for a particular GroupVersion.

        Name must be "version.group".

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Spec contains information for locating and communicating with a server.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = ApiServiceSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8beea7276877d49ec863fa1383b8e6c95f88a65b274e24e693ac5b48b2bd74eb)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[ApiServiceSpec]:
        '''Spec contains information for locating and communicating with a server.

        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[ApiServiceSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeApiServiceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeBinding(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeBinding",
):
    '''Binding ties one object to another;

    for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.

    :schema: io.k8s.api.core.v1.Binding
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        target: typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.Binding" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param target: The target object that you want to bind to the standard object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9385be053f08e071755836fc3d360ec07c71e53e273d6fbbccef2b724eef7c0b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeBindingProps(target=target, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        target: typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.Binding".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param target: The target object that you want to bind to the standard object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeBindingProps(target=target, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.Binding".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeBindingProps",
    jsii_struct_bases=[],
    name_mapping={"target": "target", "metadata": "metadata"},
)
class KubeBindingProps:
    def __init__(
        self,
        *,
        target: typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Binding ties one object to another;

        for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.

        :param target: The target object that you want to bind to the standard object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.Binding
        '''
        if isinstance(target, dict):
            target = ObjectReference(**target)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__adbdb713fb4626ce3226a51e2558b073ce4c4aa10294241825f47247be35ddc6)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "target": target,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def target(self) -> "ObjectReference":
        '''The target object that you want to bind to the standard object.

        :schema: io.k8s.api.core.v1.Binding#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("ObjectReference", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.Binding#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCertificateSigningRequest(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCertificateSigningRequest",
):
    '''CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.

    Kubelets use this API to obtain:

    1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
    2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).

    This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers.

    :schema: io.k8s.api.certificates.v1.CertificateSigningRequest
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[CertificateSigningRequestSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.certificates.v1.CertificateSigningRequest" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: spec contains the certificate request, and is immutable after creation. Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
        :param metadata: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bc6bbdb0643439301a7cae33e4cc485ee815791728d977c57dd46ccb14c435e5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCertificateSigningRequestProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[CertificateSigningRequestSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequest".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: spec contains the certificate request, and is immutable after creation. Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
        :param metadata: 
        '''
        props = KubeCertificateSigningRequestProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequest".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCertificateSigningRequestList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCertificateSigningRequestList",
):
    '''CertificateSigningRequestList is a collection of CertificateSigningRequest objects.

    :schema: io.k8s.api.certificates.v1.CertificateSigningRequestList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCertificateSigningRequestProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.certificates.v1.CertificateSigningRequestList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is a collection of CertificateSigningRequest objects.
        :param metadata: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a60068c66407b694bd29b5e99e1c896b85e0bae2640540d51346e021db2e5d10)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCertificateSigningRequestListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCertificateSigningRequestProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequestList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is a collection of CertificateSigningRequest objects.
        :param metadata: 
        '''
        props = KubeCertificateSigningRequestListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequestList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCertificateSigningRequestListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCertificateSigningRequestListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCertificateSigningRequestProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CertificateSigningRequestList is a collection of CertificateSigningRequest objects.

        :param items: items is a collection of CertificateSigningRequest objects.
        :param metadata: 

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e5c5fc346dcb41d713e9da187eba747c288e69a204c521c3964a44ece28fa90)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCertificateSigningRequestProps"]:
        '''items is a collection of CertificateSigningRequest objects.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCertificateSigningRequestProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''
        :schema: io.k8s.api.certificates.v1.CertificateSigningRequestList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCertificateSigningRequestListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCertificateSigningRequestProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCertificateSigningRequestProps:
    def __init__(
        self,
        *,
        spec: typing.Union[CertificateSigningRequestSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.

        Kubelets use this API to obtain:

        1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
        2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).

        This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers.

        :param spec: spec contains the certificate request, and is immutable after creation. Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
        :param metadata: 

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequest
        '''
        if isinstance(spec, dict):
            spec = CertificateSigningRequestSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bcf5bd82c3a5530b0adce40c59415a8f9c27823d42b5a1c42ccfa2057a968b07)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CertificateSigningRequestSpec:
        '''spec contains the certificate request, and is immutable after creation.

        Only the request, signerName, expirationSeconds, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.

        :schema: io.k8s.api.certificates.v1.CertificateSigningRequest#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CertificateSigningRequestSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :schema: io.k8s.api.certificates.v1.CertificateSigningRequest#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCertificateSigningRequestProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterCidrListV1Alpha1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeClusterCidrListV1Alpha1",
):
    '''ClusterCIDRList contains a list of ClusterCIDR.

    :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeClusterCidrv1Alpha1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.networking.v1alpha1.ClusterCIDRList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of ClusterCIDRs.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22208de8d6f038229980910fdc9f8e974c65f37b93caf7ffc971bc0c6361dab9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterCidrListV1Alpha1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeClusterCidrv1Alpha1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.networking.v1alpha1.ClusterCIDRList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of ClusterCIDRs.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeClusterCidrListV1Alpha1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.networking.v1alpha1.ClusterCIDRList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeClusterCidrListV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterCidrListV1Alpha1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeClusterCidrv1Alpha1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterCIDRList contains a list of ClusterCIDR.

        :param items: items is the list of ClusterCIDRs.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8bbb24660bb6b4cae9e2cf7106e51ef8b0cc17b52cdf96f83a486f3442f8b6d0)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterCidrv1Alpha1Props"]:
        '''items is the list of ClusterCIDRs.

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterCidrv1Alpha1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDRList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterCidrListV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterCidrv1Alpha1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeClusterCidrv1Alpha1",
):
    '''ClusterCIDR represents a single configuration for per-Node Pod CIDR allocations when the MultiCIDRRangeAllocator is enabled (see the config for kube-controller-manager).

    A cluster may have any number of ClusterCIDR resources, all of which will be considered when allocating a CIDR for a Node.  A ClusterCIDR is eligible to be used for a given Node when the node selector matches the node in question and has free CIDRs to allocate.  In case of multiple matching ClusterCIDR resources, the allocator will attempt to break ties using internal heuristics, but any ClusterCIDR whose node selector matches the Node may be used.

    :schema: io.k8s.api.networking.v1alpha1.ClusterCIDR
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ClusterCidrSpecV1Alpha1, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.networking.v1alpha1.ClusterCIDR" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: spec is the desired state of the ClusterCIDR. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02f3207aec9b0ec4dd41eadcad2fcea2d26c15c8110459f7ce104845bf326e82)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterCidrv1Alpha1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ClusterCidrSpecV1Alpha1, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.networking.v1alpha1.ClusterCIDR".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: spec is the desired state of the ClusterCIDR. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        props = KubeClusterCidrv1Alpha1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.networking.v1alpha1.ClusterCIDR".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeClusterCidrv1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeClusterCidrv1Alpha1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[ClusterCidrSpecV1Alpha1, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterCIDR represents a single configuration for per-Node Pod CIDR allocations when the MultiCIDRRangeAllocator is enabled (see the config for kube-controller-manager).

        A cluster may have any number of ClusterCIDR resources, all of which will be considered when allocating a CIDR for a Node.  A ClusterCIDR is eligible to be used for a given Node when the node selector matches the node in question and has free CIDRs to allocate.  In case of multiple matching ClusterCIDR resources, the allocator will attempt to break ties using internal heuristics, but any ClusterCIDR whose node selector matches the Node may be used.

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: spec is the desired state of the ClusterCIDR. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDR
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = ClusterCidrSpecV1Alpha1(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b5814619b25e1c9f11807d214c1531d40532ba0306a7331685a5a0035f7a19f)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDR#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[ClusterCidrSpecV1Alpha1]:
        '''spec is the desired state of the ClusterCIDR.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.networking.v1alpha1.ClusterCIDR#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[ClusterCidrSpecV1Alpha1], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterCidrv1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRole(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeClusterRole",
):
    '''ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

    :schema: io.k8s.api.rbac.v1.ClusterRole
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        aggregation_rule: typing.Optional[typing.Union[AggregationRule, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.rbac.v1.ClusterRole" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param aggregation_rule: AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: Standard object's metadata.
        :param rules: Rules holds all the PolicyRules for this ClusterRole.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d83d20324c475471008386fc55241fc93b1b69b851dd7bfd483c3ecf3dd50ece)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterRoleProps(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        aggregation_rule: typing.Optional[typing.Union[AggregationRule, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRole".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param aggregation_rule: AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: Standard object's metadata.
        :param rules: Rules holds all the PolicyRules for this ClusterRole.
        '''
        props = KubeClusterRoleProps(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRole".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeClusterRoleBinding(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeClusterRoleBinding",
):
    '''ClusterRoleBinding references a ClusterRole, but not contain it.

    It can reference a ClusterRole in the global namespace, and adds who information via Subject.

    :schema: io.k8s.api.rbac.v1.ClusterRoleBinding
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        role_ref: typing.Union["RoleRef", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subjects: typing.Optional[typing.Sequence[typing.Union["Subject", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.rbac.v1.ClusterRoleBinding" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param role_ref: RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. This field is immutable.
        :param metadata: Standard object's metadata.
        :param subjects: Subjects holds references to the objects the role applies to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e20d3afcf112c8bb9e322edae03e226fbf946934450f27ef92f9e57b866648f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterRoleBindingProps(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        role_ref: typing.Union["RoleRef", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subjects: typing.Optional[typing.Sequence[typing.Union["Subject", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBinding".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param role_ref: RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. This field is immutable.
        :param metadata: Standard object's metadata.
        :param subjects: Subjects holds references to the objects the role applies to.
        '''
        props = KubeClusterRoleBindingProps(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBinding".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeClusterRoleBindingList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeClusterRoleBindingList",
):
    '''ClusterRoleBindingList is a collection of ClusterRoleBindings.

    :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleBindingProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.rbac.v1.ClusterRoleBindingList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is a list of ClusterRoleBindings.
        :param metadata: Standard object's metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f587d40e8f316ae90deba35dea38da1db40fe714011242581e88a51524db0f80)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterRoleBindingListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleBindingProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBindingList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is a list of ClusterRoleBindings.
        :param metadata: Standard object's metadata.
        '''
        props = KubeClusterRoleBindingListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBindingList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeClusterRoleBindingListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleBindingListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleBindingProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterRoleBindingList is a collection of ClusterRoleBindings.

        :param items: Items is a list of ClusterRoleBindings.
        :param metadata: Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a1ad5a19ced996c2ac7c049e882e880843fbad397fb1acc68f0738ba251803d5)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleBindingProps"]:
        '''Items is a list of ClusterRoleBindings.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleBindingProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeClusterRoleBindingProps",
    jsii_struct_bases=[],
    name_mapping={
        "role_ref": "roleRef",
        "metadata": "metadata",
        "subjects": "subjects",
    },
)
class KubeClusterRoleBindingProps:
    def __init__(
        self,
        *,
        role_ref: typing.Union["RoleRef", typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subjects: typing.Optional[typing.Sequence[typing.Union["Subject", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''ClusterRoleBinding references a ClusterRole, but not contain it.

        It can reference a ClusterRole in the global namespace, and adds who information via Subject.

        :param role_ref: RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error. This field is immutable.
        :param metadata: Standard object's metadata.
        :param subjects: Subjects holds references to the objects the role applies to.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding
        '''
        if isinstance(role_ref, dict):
            role_ref = RoleRef(**role_ref)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f1fab33f859a2bc2434c09f86644916d427e6a4c4995a64484c1c44bc0b9e186)
            check_type(argname="argument role_ref", value=role_ref, expected_type=type_hints["role_ref"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument subjects", value=subjects, expected_type=type_hints["subjects"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role_ref": role_ref,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if subjects is not None:
            self._values["subjects"] = subjects

    @builtins.property
    def role_ref(self) -> "RoleRef":
        '''RoleRef can only reference a ClusterRole in the global namespace.

        If the RoleRef cannot be resolved, the Authorizer must return an error. This field is immutable.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#roleRef
        '''
        result = self._values.get("role_ref")
        assert result is not None, "Required property 'role_ref' is missing"
        return typing.cast("RoleRef", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def subjects(self) -> typing.Optional[typing.List["Subject"]]:
        '''Subjects holds references to the objects the role applies to.

        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#subjects
        '''
        result = self._values.get("subjects")
        return typing.cast(typing.Optional[typing.List["Subject"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeClusterRoleList",
):
    '''ClusterRoleList is a collection of ClusterRoles.

    :schema: io.k8s.api.rbac.v1.ClusterRoleList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.rbac.v1.ClusterRoleList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is a list of ClusterRoles.
        :param metadata: Standard object's metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__332067fa7646dfe0c733208e3f4759b5aaf35429eb58f3c526d086028c1bba4b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterRoleListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is a list of ClusterRoles.
        :param metadata: Standard object's metadata.
        '''
        props = KubeClusterRoleListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeClusterRoleListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeClusterRoleProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterRoleList is a collection of ClusterRoles.

        :param items: Items is a list of ClusterRoles.
        :param metadata: Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3c393f461ca1e59b9a19eff154fa0ced464b78285b389d42ea601e92b89f8079)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleProps"]:
        '''Items is a list of ClusterRoles.

        :schema: io.k8s.api.rbac.v1.ClusterRoleList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRoleList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeClusterRoleProps",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation_rule": "aggregationRule",
        "metadata": "metadata",
        "rules": "rules",
    },
)
class KubeClusterRoleProps:
    def __init__(
        self,
        *,
        aggregation_rule: typing.Optional[typing.Union[AggregationRule, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union["PolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

        :param aggregation_rule: AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: Standard object's metadata.
        :param rules: Rules holds all the PolicyRules for this ClusterRole.

        :schema: io.k8s.api.rbac.v1.ClusterRole
        '''
        if isinstance(aggregation_rule, dict):
            aggregation_rule = AggregationRule(**aggregation_rule)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2cf3e82972b963c98825d1168a29fc1c511a1011ba8fd82c1729227d0149135d)
            check_type(argname="argument aggregation_rule", value=aggregation_rule, expected_type=type_hints["aggregation_rule"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if aggregation_rule is not None:
            self._values["aggregation_rule"] = aggregation_rule
        if metadata is not None:
            self._values["metadata"] = metadata
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def aggregation_rule(self) -> typing.Optional[AggregationRule]:
        '''AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.

        If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.

        :schema: io.k8s.api.rbac.v1.ClusterRole#aggregationRule
        '''
        result = self._values.get("aggregation_rule")
        return typing.cast(typing.Optional[AggregationRule], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.rbac.v1.ClusterRole#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRule"]]:
        '''Rules holds all the PolicyRules for this ClusterRole.

        :schema: io.k8s.api.rbac.v1.ClusterRole#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRule"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterTrustBundleListV1Alpha1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeClusterTrustBundleListV1Alpha1",
):
    '''ClusterTrustBundleList is a collection of ClusterTrustBundle objects.

    :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeClusterTrustBundleV1Alpha1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is a collection of ClusterTrustBundle objects.
        :param metadata: metadata contains the list metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26d682a5bc93b864898eaad401a79586dea414f2c56710458449d67148591ea6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterTrustBundleListV1Alpha1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeClusterTrustBundleV1Alpha1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is a collection of ClusterTrustBundle objects.
        :param metadata: metadata contains the list metadata.
        '''
        props = KubeClusterTrustBundleListV1Alpha1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeClusterTrustBundleListV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterTrustBundleListV1Alpha1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeClusterTrustBundleV1Alpha1Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterTrustBundleList is a collection of ClusterTrustBundle objects.

        :param items: items is a collection of ClusterTrustBundle objects.
        :param metadata: metadata contains the list metadata.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__17436c810cda2a8c7231f69dfb9b1c25910bba186d21e7f4336d0279359387a3)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterTrustBundleV1Alpha1Props"]:
        '''items is a collection of ClusterTrustBundle objects.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterTrustBundleV1Alpha1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''metadata contains the list metadata.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterTrustBundleListV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterTrustBundleV1Alpha1(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeClusterTrustBundleV1Alpha1",
):
    '''ClusterTrustBundle is a cluster-scoped container for X.509 trust anchors (root certificates).

    ClusterTrustBundle objects are considered to be readable by any authenticated user in the cluster, because they can be mounted by pods using the ``clusterTrustBundle`` projection.  All service accounts have read access to ClusterTrustBundles by default.  Users who only have namespace-level access to a cluster can read ClusterTrustBundles by impersonating a serviceaccount that they have access to.

    It can be optionally associated with a particular assigner, in which case it contains one valid set of trust anchors for that signer. Signers may have multiple associated ClusterTrustBundles; each is an independent set of trust anchors for that signer. Admission control is used to enforce that only users with permissions on the signer can create or modify the corresponding bundle.

    :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundle
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[ClusterTrustBundleSpecV1Alpha1, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.certificates.v1alpha1.ClusterTrustBundle" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: spec contains the signer (if any) and trust anchors.
        :param metadata: metadata contains the object metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb41640c7a012aecf6db8ed2945ee227cbe9e9d38d6d2500dbdd399ca444960c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeClusterTrustBundleV1Alpha1Props(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[ClusterTrustBundleSpecV1Alpha1, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.certificates.v1alpha1.ClusterTrustBundle".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: spec contains the signer (if any) and trust anchors.
        :param metadata: metadata contains the object metadata.
        '''
        props = KubeClusterTrustBundleV1Alpha1Props(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.certificates.v1alpha1.ClusterTrustBundle".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeClusterTrustBundleV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeClusterTrustBundleV1Alpha1Props:
    def __init__(
        self,
        *,
        spec: typing.Union[ClusterTrustBundleSpecV1Alpha1, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ClusterTrustBundle is a cluster-scoped container for X.509 trust anchors (root certificates).

        ClusterTrustBundle objects are considered to be readable by any authenticated user in the cluster, because they can be mounted by pods using the ``clusterTrustBundle`` projection.  All service accounts have read access to ClusterTrustBundles by default.  Users who only have namespace-level access to a cluster can read ClusterTrustBundles by impersonating a serviceaccount that they have access to.

        It can be optionally associated with a particular assigner, in which case it contains one valid set of trust anchors for that signer. Signers may have multiple associated ClusterTrustBundles; each is an independent set of trust anchors for that signer. Admission control is used to enforce that only users with permissions on the signer can create or modify the corresponding bundle.

        :param spec: spec contains the signer (if any) and trust anchors.
        :param metadata: metadata contains the object metadata.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundle
        '''
        if isinstance(spec, dict):
            spec = ClusterTrustBundleSpecV1Alpha1(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4774a64ae79ae415a877f15193026205fba5ef58cfaa125af7b7770b43a03046)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> ClusterTrustBundleSpecV1Alpha1:
        '''spec contains the signer (if any) and trust anchors.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundle#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(ClusterTrustBundleSpecV1Alpha1, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''metadata contains the object metadata.

        :schema: io.k8s.api.certificates.v1alpha1.ClusterTrustBundle#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterTrustBundleV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeComponentStatus(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeComponentStatus",
):
    '''ComponentStatus (and ComponentStatusList) holds the cluster validation info.

    Deprecated: This API is deprecated in v1.19+

    :schema: io.k8s.api.core.v1.ComponentStatus
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        conditions: typing.Optional[typing.Sequence[typing.Union[ComponentCondition, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.ComponentStatus" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param conditions: List of component conditions observed.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46bcf7081299d0238b7a27013af0a728754da31d286a230f245278ead47afb1c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeComponentStatusProps(conditions=conditions, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        conditions: typing.Optional[typing.Sequence[typing.Union[ComponentCondition, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatus".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param conditions: List of component conditions observed.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeComponentStatusProps(conditions=conditions, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatus".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeComponentStatusList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeComponentStatusList",
):
    '''Status of all the conditions for the component as a list of ComponentStatus objects.

    Deprecated: This API is deprecated in v1.19+

    :schema: io.k8s.api.core.v1.ComponentStatusList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeComponentStatusProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.ComponentStatusList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: List of ComponentStatus objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b04f150d4fd4c2a4534128e75b6687376c0c3f165162d9340338e1876aea61fd)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeComponentStatusListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeComponentStatusProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatusList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: List of ComponentStatus objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        '''
        props = KubeComponentStatusListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatusList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeComponentStatusListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeComponentStatusListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeComponentStatusProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Status of all the conditions for the component as a list of ComponentStatus objects.

        Deprecated: This API is deprecated in v1.19+

        :param items: List of ComponentStatus objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.core.v1.ComponentStatusList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a9bccb232f6cdc2236951998d7cc418c5a64b4a934d35d1ff6a0230fc49bec6a)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeComponentStatusProps"]:
        '''List of ComponentStatus objects.

        :schema: io.k8s.api.core.v1.ComponentStatusList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeComponentStatusProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.core.v1.ComponentStatusList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeComponentStatusListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeComponentStatusProps",
    jsii_struct_bases=[],
    name_mapping={"conditions": "conditions", "metadata": "metadata"},
)
class KubeComponentStatusProps:
    def __init__(
        self,
        *,
        conditions: typing.Optional[typing.Sequence[typing.Union[ComponentCondition, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ComponentStatus (and ComponentStatusList) holds the cluster validation info.

        Deprecated: This API is deprecated in v1.19+

        :param conditions: List of component conditions observed.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.ComponentStatus
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f6d7701270eefe39991ef633ae8f016e9d3e535946d73d7b922bb42e2575b004)
            check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if conditions is not None:
            self._values["conditions"] = conditions
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def conditions(self) -> typing.Optional[typing.List[ComponentCondition]]:
        '''List of component conditions observed.

        :schema: io.k8s.api.core.v1.ComponentStatus#conditions
        '''
        result = self._values.get("conditions")
        return typing.cast(typing.Optional[typing.List[ComponentCondition]], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.ComponentStatus#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeComponentStatusProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeConfigMap(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeConfigMap",
):
    '''ConfigMap holds configuration data for pods to consume.

    :schema: io.k8s.api.core.v1.ConfigMap
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.ConfigMap" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param immutable: Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c57d342cffdebbd7b7cc949b4b489f4d13165b730167b99cc11242d3adda61c9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeConfigMapProps(
            binary_data=binary_data, data=data, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMap".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param immutable: Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeConfigMapProps(
            binary_data=binary_data, data=data, immutable=immutable, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMap".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeConfigMapList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeConfigMapList",
):
    '''ConfigMapList is a resource containing a list of ConfigMap objects.

    :schema: io.k8s.api.core.v1.ConfigMapList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeConfigMapProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.ConfigMapList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of ConfigMaps.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__050abeaa75963453322140fa2ff98a417267f625db35c7d11e9d35c0aa99e091)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeConfigMapListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeConfigMapProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMapList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of ConfigMaps.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeConfigMapListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMapList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeConfigMapListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeConfigMapListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeConfigMapProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ConfigMapList is a resource containing a list of ConfigMap objects.

        :param items: Items is the list of ConfigMaps.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.core.v1.ConfigMapList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb134bf7ee73f8016bf9586d44629477e89e606793c06bd0d89d674f7f3dfb02)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeConfigMapProps"]:
        '''Items is the list of ConfigMaps.

        :schema: io.k8s.api.core.v1.ConfigMapList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeConfigMapProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.core.v1.ConfigMapList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeConfigMapListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeConfigMapProps",
    jsii_struct_bases=[],
    name_mapping={
        "binary_data": "binaryData",
        "data": "data",
        "immutable": "immutable",
        "metadata": "metadata",
    },
)
class KubeConfigMapProps:
    def __init__(
        self,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ConfigMap holds configuration data for pods to consume.

        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param immutable: Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.ConfigMap
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9a043baa40d87d77b42d83b2350666c8e55d6666f4ccd5c47b1c2a85d1429e5e)
            check_type(argname="argument binary_data", value=binary_data, expected_type=type_hints["binary_data"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if binary_data is not None:
            self._values["binary_data"] = binary_data
        if data is not None:
            self._values["data"] = data
        if immutable is not None:
            self._values["immutable"] = immutable
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def binary_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''BinaryData contains the binary data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.

        :schema: io.k8s.api.core.v1.ConfigMap#binaryData
        '''
        result = self._values.get("binary_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def data(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Data contains the configuration data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.

        :schema: io.k8s.api.core.v1.ConfigMap#data
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time. Defaulted to nil.

        :schema: io.k8s.api.core.v1.ConfigMap#immutable
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.ConfigMap#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeConfigMapProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeControllerRevision(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeControllerRevision",
):
    '''ControllerRevision implements an immutable snapshot of state data.

    Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

    :schema: io.k8s.api.apps.v1.ControllerRevision
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        revision: jsii.Number,
        data: typing.Any = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.ControllerRevision" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param revision: Revision indicates the revision of the state represented by Data.
        :param data: Data is the serialized representation of the state.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a344b13a740b41598acfe241f336afac4660b8c8a53e7e49d048602593d1c748)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeControllerRevisionProps(
            revision=revision, data=data, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        revision: jsii.Number,
        data: typing.Any = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevision".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param revision: Revision indicates the revision of the state represented by Data.
        :param data: Data is the serialized representation of the state.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeControllerRevisionProps(
            revision=revision, data=data, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevision".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeControllerRevisionList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeControllerRevisionList",
):
    '''ControllerRevisionList is a resource containing a list of ControllerRevision objects.

    :schema: io.k8s.api.apps.v1.ControllerRevisionList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeControllerRevisionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.ControllerRevisionList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of ControllerRevisions.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1a65d79096c72e99d628b999845deca20cc85005f039cd4814d5335b36b8d49)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeControllerRevisionListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeControllerRevisionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevisionList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of ControllerRevisions.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeControllerRevisionListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevisionList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeControllerRevisionListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeControllerRevisionListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeControllerRevisionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ControllerRevisionList is a resource containing a list of ControllerRevision objects.

        :param items: Items is the list of ControllerRevisions.
        :param metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.apps.v1.ControllerRevisionList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd8478a1323e072184895b7d60fe66089220dd25978363381c64812f2d71de31)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeControllerRevisionProps"]:
        '''Items is the list of ControllerRevisions.

        :schema: io.k8s.api.apps.v1.ControllerRevisionList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeControllerRevisionProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.apps.v1.ControllerRevisionList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeControllerRevisionProps",
    jsii_struct_bases=[],
    name_mapping={"revision": "revision", "data": "data", "metadata": "metadata"},
)
class KubeControllerRevisionProps:
    def __init__(
        self,
        *,
        revision: jsii.Number,
        data: typing.Any = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''ControllerRevision implements an immutable snapshot of state data.

        Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

        :param revision: Revision indicates the revision of the state represented by Data.
        :param data: Data is the serialized representation of the state.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.ControllerRevision
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a98a9dd2fa6ae9c55c2b73f23e1cf45f590cd2b4f3b08ce41cba1eb16b9bef25)
            check_type(argname="argument revision", value=revision, expected_type=type_hints["revision"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "revision": revision,
        }
        if data is not None:
            self._values["data"] = data
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def revision(self) -> jsii.Number:
        '''Revision indicates the revision of the state represented by Data.

        :schema: io.k8s.api.apps.v1.ControllerRevision#revision
        '''
        result = self._values.get("revision")
        assert result is not None, "Required property 'revision' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def data(self) -> typing.Any:
        '''Data is the serialized representation of the state.

        :schema: io.k8s.api.apps.v1.ControllerRevision#data
        '''
        result = self._values.get("data")
        return typing.cast(typing.Any, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.ControllerRevision#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCronJob(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCronJob",
):
    '''CronJob represents the configuration of a single cron job.

    :schema: io.k8s.api.batch.v1.CronJob
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.batch.v1.CronJob" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__db1bdbf5f867cf6d66c6ccda4af416ac0d0f6438a13f7aaff8299f1b2467cfbb)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCronJobProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJob".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        props = KubeCronJobProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJob".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCronJobList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCronJobList",
):
    '''CronJobList is a collection of cron jobs.

    :schema: io.k8s.api.batch.v1.CronJobList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.batch.v1.CronJobList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd31eec6ad68fdcbd32fce46dd6905c571db1a5dd52d8acf7fd5edb5ed227b80)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCronJobListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJobList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeCronJobListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJobList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCronJobListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCronJobListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCronJobProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CronJobList is a collection of cron jobs.

        :param items: items is the list of CronJobs.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1.CronJobList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aee1f1c60eaa7903c2f580b3bf3c267b25ac8895dc5ba82a580a6291c4560842)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCronJobProps"]:
        '''items is the list of CronJobs.

        :schema: io.k8s.api.batch.v1.CronJobList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCronJobProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1.CronJobList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCronJobProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeCronJobProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[CronJobSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CronJob represents the configuration of a single cron job.

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1.CronJob
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = CronJobSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__960d3efc3f777119b46fb5507dbd8f882014fee52bdb6cc970dd2d00f6b10dbc)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.batch.v1.CronJob#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[CronJobSpec]:
        '''Specification of the desired behavior of a cron job, including the schedule.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.batch.v1.CronJob#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[CronJobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiDriver(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCsiDriver",
):
    '''CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

    Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.

    :schema: io.k8s.api.storage.v1.CSIDriver
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[CsiDriverSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSIDriver" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: spec represents the specification of the CSI Driver.
        :param metadata: Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a25cea2c051c39feb78b7a929a489656e69032522b84652e61611922be69384)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiDriverProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[CsiDriverSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriver".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: spec represents the specification of the CSI Driver.
        :param metadata: Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeCsiDriverProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriver".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCsiDriverList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCsiDriverList",
):
    '''CSIDriverList is a collection of CSIDriver objects.

    :schema: io.k8s.api.storage.v1.CSIDriverList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCsiDriverProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSIDriverList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of CSIDriver.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__39d8e7a45b75ed3c4212ab180fddf0604a667b7f9f0d4d01cb49c70563de2c56)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiDriverListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCsiDriverProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriverList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of CSIDriver.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCsiDriverListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriverList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCsiDriverListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiDriverListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCsiDriverProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIDriverList is a collection of CSIDriver objects.

        :param items: items is the list of CSIDriver.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSIDriverList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__04b49f2c27b70beee2e28f21291552dcceed53df0e886439539036a93898859b)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiDriverProps"]:
        '''items is the list of CSIDriver.

        :schema: io.k8s.api.storage.v1.CSIDriverList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiDriverProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSIDriverList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiDriverListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCsiDriverProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCsiDriverProps:
    def __init__(
        self,
        *,
        spec: typing.Union[CsiDriverSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

        Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.

        :param spec: spec represents the specification of the CSI Driver.
        :param metadata: Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.storage.v1.CSIDriver
        '''
        if isinstance(spec, dict):
            spec = CsiDriverSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d8b25ff0f4e92c3a81a83b8d6a6fe71174f476706d8f94d06b73a0b0b908bfda)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CsiDriverSpec:
        '''spec represents the specification of the CSI Driver.

        :schema: io.k8s.api.storage.v1.CSIDriver#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CsiDriverSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object metadata.

        metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.storage.v1.CSIDriver#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiDriverProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiNode(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCsiNode",
):
    '''CSINode holds information about all CSI drivers installed on a node.

    CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.

    :schema: io.k8s.api.storage.v1.CSINode
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[CsiNodeSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSINode" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: spec is the specification of CSINode.
        :param metadata: Standard object's metadata. metadata.name must be the Kubernetes node name.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6517f70a8b4ed503946926f4486ce650e69298688721299bdeb0f8c2eee21c41)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiNodeProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[CsiNodeSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINode".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: spec is the specification of CSINode.
        :param metadata: Standard object's metadata. metadata.name must be the Kubernetes node name.
        '''
        props = KubeCsiNodeProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINode".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCsiNodeList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCsiNodeList",
):
    '''CSINodeList is a collection of CSINode objects.

    :schema: io.k8s.api.storage.v1.CSINodeList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCsiNodeProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSINodeList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of CSINode.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b34c0ef2a829fadaafd7725bf54ed1da195bd8503c85ef2b5dbc4978162b21c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiNodeListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCsiNodeProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINodeList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of CSINode.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCsiNodeListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINodeList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCsiNodeListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiNodeListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCsiNodeProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSINodeList is a collection of CSINode objects.

        :param items: items is the list of CSINode.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSINodeList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__de48ff3897356358ac9c4e739be6fc960fd30fdcbf3467969d6cbf3b5043c57a)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiNodeProps"]:
        '''items is the list of CSINode.

        :schema: io.k8s.api.storage.v1.CSINodeList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiNodeProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSINodeList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiNodeListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCsiNodeProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCsiNodeProps:
    def __init__(
        self,
        *,
        spec: typing.Union[CsiNodeSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSINode holds information about all CSI drivers installed on a node.

        CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.

        :param spec: spec is the specification of CSINode.
        :param metadata: Standard object's metadata. metadata.name must be the Kubernetes node name.

        :schema: io.k8s.api.storage.v1.CSINode
        '''
        if isinstance(spec, dict):
            spec = CsiNodeSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee51cbc305021529fe19ce9bb338b449f72edd37fc84ef8ec2f92e1af60e5a08)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CsiNodeSpec:
        '''spec is the specification of CSINode.

        :schema: io.k8s.api.storage.v1.CSINode#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CsiNodeSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        metadata.name must be the Kubernetes node name.

        :schema: io.k8s.api.storage.v1.CSINode#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiNodeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiStorageCapacity(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCsiStorageCapacity",
):
    '''CSIStorageCapacity stores the result of one CSI GetCapacity call.

    For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

    For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

    The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

    The producer of these objects can decide which approach is more suitable.

    They are consumed by the kube-scheduler when a CSI driver opts into capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler compares the MaximumVolumeSize against the requested size of pending volumes to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back to a comparison against the less precise Capacity. If that is also unset, the scheduler assumes that capacity is insufficient and tries some other node.

    :schema: io.k8s.api.storage.v1.CSIStorageCapacity
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSIStorageCapacity" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param storage_class_name: storageClassName represents the name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: nodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__289032a84c8d0a3a4c92988cafc988654049fbd4582591988f5c836c88014147)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiStorageCapacityProps(
            storage_class_name=storage_class_name,
            capacity=capacity,
            maximum_volume_size=maximum_volume_size,
            metadata=metadata,
            node_topology=node_topology,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIStorageCapacity".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param storage_class_name: storageClassName represents the name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: nodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        '''
        props = KubeCsiStorageCapacityProps(
            storage_class_name=storage_class_name,
            capacity=capacity,
            maximum_volume_size=maximum_volume_size,
            metadata=metadata,
            node_topology=node_topology,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIStorageCapacity".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCsiStorageCapacityList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCsiStorageCapacityList",
):
    '''CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

    :schema: io.k8s.api.storage.v1.CSIStorageCapacityList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.storage.v1.CSIStorageCapacityList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18f8655fd9dd0fae05755b8ae5b5978876d65ad56d0fa7f46ff8e8eb2e29d7b3)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCsiStorageCapacityListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIStorageCapacityList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCsiStorageCapacityListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIStorageCapacityList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCsiStorageCapacityListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiStorageCapacityListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCsiStorageCapacityProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

        :param items: items is the list of CSIStorageCapacity objects.
        :param metadata: Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacityList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__765ffe96fa73bfe58afd93fb2600158617712b9c8667edfb78624c827548f3c5)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiStorageCapacityProps"]:
        '''items is the list of CSIStorageCapacity objects.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacityList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiStorageCapacityProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacityList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiStorageCapacityListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCsiStorageCapacityProps",
    jsii_struct_bases=[],
    name_mapping={
        "storage_class_name": "storageClassName",
        "capacity": "capacity",
        "maximum_volume_size": "maximumVolumeSize",
        "metadata": "metadata",
        "node_topology": "nodeTopology",
    },
)
class KubeCsiStorageCapacityProps:
    def __init__(
        self,
        *,
        storage_class_name: builtins.str,
        capacity: typing.Optional["Quantity"] = None,
        maximum_volume_size: typing.Optional["Quantity"] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        node_topology: typing.Optional[typing.Union["LabelSelector", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CSIStorageCapacity stores the result of one CSI GetCapacity call.

        For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

        For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

        The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

        The producer of these objects can decide which approach is more suitable.

        They are consumed by the kube-scheduler when a CSI driver opts into capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler compares the MaximumVolumeSize against the requested size of pending volumes to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back to a comparison against the less precise Capacity. If that is also unset, the scheduler assumes that capacity is insufficient and tries some other node.

        :param storage_class_name: storageClassName represents the name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param capacity: capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param maximum_volume_size: maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields. This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param metadata: Standard object's metadata. The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name. Objects are namespaced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param node_topology: nodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(node_topology, dict):
            node_topology = LabelSelector(**node_topology)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5dcbe5a37a49c8257459ea9204248ec5ba8ea912a8f7ec6cfb44faf74e2837e6)
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument capacity", value=capacity, expected_type=type_hints["capacity"])
            check_type(argname="argument maximum_volume_size", value=maximum_volume_size, expected_type=type_hints["maximum_volume_size"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument node_topology", value=node_topology, expected_type=type_hints["node_topology"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "storage_class_name": storage_class_name,
        }
        if capacity is not None:
            self._values["capacity"] = capacity
        if maximum_volume_size is not None:
            self._values["maximum_volume_size"] = maximum_volume_size
        if metadata is not None:
            self._values["metadata"] = metadata
        if node_topology is not None:
            self._values["node_topology"] = node_topology

    @builtins.property
    def storage_class_name(self) -> builtins.str:
        '''storageClassName represents the name of the StorageClass that the reported capacity applies to.

        It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#storageClassName
        '''
        result = self._values.get("storage_class_name")
        assert result is not None, "Required property 'storage_class_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def capacity(self) -> typing.Optional["Quantity"]:
        '''capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#capacity
        '''
        result = self._values.get("capacity")
        return typing.cast(typing.Optional["Quantity"], result)

    @builtins.property
    def maximum_volume_size(self) -> typing.Optional["Quantity"]:
        '''maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#maximumVolumeSize
        '''
        result = self._values.get("maximum_volume_size")
        return typing.cast(typing.Optional["Quantity"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-, a generated name, or a reverse-domain name which ends with the unique CSI driver name.

        Objects are namespaced.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def node_topology(self) -> typing.Optional["LabelSelector"]:
        '''nodeTopology defines which nodes have access to the storage for which capacity was reported.

        If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.

        :schema: io.k8s.api.storage.v1.CSIStorageCapacity#nodeTopology
        '''
        result = self._values.get("node_topology")
        return typing.cast(typing.Optional["LabelSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiStorageCapacityProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCustomResourceDefinition(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCustomResourceDefinition",
):
    '''CustomResourceDefinition represents a resource that should be exposed on the API server.

    Its name MUST be in the format <.spec.name>.<.spec.group>.

    :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        spec: typing.Union[CustomResourceDefinitionSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: spec describes how the user wants the resources to appear.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3491e4cfa9fd0feaeb8dcd47be306c8d7757c73f0a2d5ac88c236ab3a49d06bd)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCustomResourceDefinitionProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: typing.Union[CustomResourceDefinitionSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: spec describes how the user wants the resources to appear.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCustomResourceDefinitionProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeCustomResourceDefinitionList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeCustomResourceDefinitionList",
):
    '''CustomResourceDefinitionList is a list of CustomResourceDefinition objects.

    :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeCustomResourceDefinitionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items list individual CustomResourceDefinition objects.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3061defcc644046a424276370d8aef2b08013dc22d816be8fa35d28060c4ba3)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeCustomResourceDefinitionListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeCustomResourceDefinitionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items list individual CustomResourceDefinition objects.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
        '''
        props = KubeCustomResourceDefinitionListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCustomResourceDefinitionListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCustomResourceDefinitionListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeCustomResourceDefinitionProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceDefinitionList is a list of CustomResourceDefinition objects.

        :param items: items list individual CustomResourceDefinition objects.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6ed321cad9ff5e2410e871a3c49d83bd48bc6212bb2d149ac1cba7b6905930c6)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCustomResourceDefinitionProps"]:
        '''items list individual CustomResourceDefinition objects.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCustomResourceDefinitionProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCustomResourceDefinitionListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeCustomResourceDefinitionProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCustomResourceDefinitionProps:
    def __init__(
        self,
        *,
        spec: typing.Union[CustomResourceDefinitionSpec, typing.Dict[builtins.str, typing.Any]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CustomResourceDefinition represents a resource that should be exposed on the API server.

        Its name MUST be in the format <.spec.name>.<.spec.group>.

        :param spec: spec describes how the user wants the resources to appear.
        :param metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition
        '''
        if isinstance(spec, dict):
            spec = CustomResourceDefinitionSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d0c0b6a3d93d8367739345efe34c6efd227e32f5a96953bf002a3753d7b2f5b)
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CustomResourceDefinitionSpec:
        '''spec describes how the user wants the resources to appear.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CustomResourceDefinitionSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCustomResourceDefinitionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDaemonSet(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeDaemonSet",
):
    '''DaemonSet represents the configuration of a daemon set.

    :schema: io.k8s.api.apps.v1.DaemonSet
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DaemonSetSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.DaemonSet" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b17e8c2c8402c4f8488542faddda6597b2ac44144fe313c29e43057fea6ca483)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeDaemonSetProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DaemonSetSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSet".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        props = KubeDaemonSetProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSet".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeDaemonSetList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeDaemonSetList",
):
    '''DaemonSetList is a collection of daemon sets.

    :schema: io.k8s.api.apps.v1.DaemonSetList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeDaemonSetProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.DaemonSetList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: A list of daemon sets.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99ecc4ce705a5bb3b3ccea98cce3442eab3955c985bf0d268e41d02a9b17d277)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeDaemonSetListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeDaemonSetProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSetList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: A list of daemon sets.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeDaemonSetListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSetList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeDaemonSetListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDaemonSetListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeDaemonSetProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DaemonSetList is a collection of daemon sets.

        :param items: A list of daemon sets.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.DaemonSetList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8e2353fb1850efd12bd92fb563d98031cfc1260a58155c1ee11f506c2c72c20c)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDaemonSetProps"]:
        '''A list of daemon sets.

        :schema: io.k8s.api.apps.v1.DaemonSetList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDaemonSetProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.DaemonSetList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeDaemonSetProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDaemonSetProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DaemonSetSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DaemonSet represents the configuration of a daemon set.

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.apps.v1.DaemonSet
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DaemonSetSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e3e0fca1bed724b61c83a2273aef47b59afabea3da2651c5e62618a247dc0e7a)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.DaemonSet#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DaemonSetSpec]:
        '''The desired behavior of this daemon set.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.apps.v1.DaemonSet#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DaemonSetSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDeployment(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeDeployment",
):
    '''Deployment enables declarative updates for Pods and ReplicaSets.

    :schema: io.k8s.api.apps.v1.Deployment
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DeploymentSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.Deployment" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the Deployment.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7a2af744c35aecd4964b19c0d69e4e7fb3fe33dbecba5e9ba129c0b21d36464)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeDeploymentProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DeploymentSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.Deployment".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the Deployment.
        '''
        props = KubeDeploymentProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.Deployment".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeDeploymentList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeDeploymentList",
):
    '''DeploymentList is a list of Deployments.

    :schema: io.k8s.api.apps.v1.DeploymentList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeDeploymentProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.apps.v1.DeploymentList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: Items is the list of Deployments.
        :param metadata: Standard list metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20b48ec9c15224bcfdf05c50fe61ddcec8ec1565bddfaf4d18774aa1a17bab12)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeDeploymentListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeDeploymentProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DeploymentList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: Items is the list of Deployments.
        :param metadata: Standard list metadata.
        '''
        props = KubeDeploymentListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.apps.v1.DeploymentList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeDeploymentListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDeploymentListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeDeploymentProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''DeploymentList is a list of Deployments.

        :param items: Items is the list of Deployments.
        :param metadata: Standard list metadata.

        :schema: io.k8s.api.apps.v1.DeploymentList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fed483bc8addaaed823d788e18927c2b355b2a48072eef9afc3f20036abf5aae)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDeploymentProps"]:
        '''Items is the list of Deployments.

        :schema: io.k8s.api.apps.v1.DeploymentList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDeploymentProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        :schema: io.k8s.api.apps.v1.DeploymentList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeDeploymentProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDeploymentProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[DeploymentSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Deployment enables declarative updates for Pods and ReplicaSets.

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: Specification of the desired behavior of the Deployment.

        :schema: io.k8s.api.apps.v1.Deployment
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DeploymentSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__62b937ccbad1c96ac1736b407f64e6843525cb594b83c8404dfc0b848902519e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.apps.v1.Deployment#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DeploymentSpec]:
        '''Specification of the desired behavior of the Deployment.

        :schema: io.k8s.api.apps.v1.Deployment#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DeploymentSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEndpointSlice(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeEndpointSlice",
):
    '''EndpointSlice represents a subset of the endpoints that implement a service.

    For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

    :schema: io.k8s.api.discovery.v1.EndpointSlice
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[Endpoint, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPort, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.discovery.v1.EndpointSlice" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__06afcfb2e99589cccca90f5e442a3bcb05bfb78ed88a2b551127e75590fab7ec)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointSliceProps(
            address_type=address_type,
            endpoints=endpoints,
            metadata=metadata,
            ports=ports,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[Endpoint, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPort, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSlice".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.
        '''
        props = KubeEndpointSliceProps(
            address_type=address_type,
            endpoints=endpoints,
            metadata=metadata,
            ports=ports,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSlice".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeEndpointSliceList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeEndpointSliceList",
):
    '''EndpointSliceList represents a list of endpoint slices.

    :schema: io.k8s.api.discovery.v1.EndpointSliceList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.discovery.v1.EndpointSliceList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of endpoint slices.
        :param metadata: Standard list metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b2645c381b9fb979b7ae74fd25ec3b2144f35a6ecb2c2aed9cf04ba7d04de509)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointSliceListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSliceList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of endpoint slices.
        :param metadata: Standard list metadata.
        '''
        props = KubeEndpointSliceListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSliceList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeEndpointSliceListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEndpointSliceListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointSliceProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EndpointSliceList represents a list of endpoint slices.

        :param items: items is the list of endpoint slices.
        :param metadata: Standard list metadata.

        :schema: io.k8s.api.discovery.v1.EndpointSliceList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6044e550c901287cfb9c3751b192225504b6bb6898f85b037f3333b563c795b3)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEndpointSliceProps"]:
        '''items is the list of endpoint slices.

        :schema: io.k8s.api.discovery.v1.EndpointSliceList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEndpointSliceProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        :schema: io.k8s.api.discovery.v1.EndpointSliceList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointSliceListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeEndpointSliceProps",
    jsii_struct_bases=[],
    name_mapping={
        "address_type": "addressType",
        "endpoints": "endpoints",
        "metadata": "metadata",
        "ports": "ports",
    },
)
class KubeEndpointSliceProps:
    def __init__(
        self,
        *,
        address_type: builtins.str,
        endpoints: typing.Sequence[typing.Union[Endpoint, typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[EndpointPort, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''EndpointSlice represents a subset of the endpoints that implement a service.

        For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

        :param address_type: addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
        :param endpoints: endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.
        :param metadata: Standard object's metadata.
        :param ports: ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.

        :schema: io.k8s.api.discovery.v1.EndpointSlice
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce40ccf4563047cb9945420680837f170fbe82319818ae5c1f5b46b21a5ceaeb)
            check_type(argname="argument address_type", value=address_type, expected_type=type_hints["address_type"])
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "address_type": address_type,
            "endpoints": endpoints,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def address_type(self) -> builtins.str:
        '''addressType specifies the type of address carried by this EndpointSlice.

        All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.

        :schema: io.k8s.api.discovery.v1.EndpointSlice#addressType
        '''
        result = self._values.get("address_type")
        assert result is not None, "Required property 'address_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoints(self) -> typing.List[Endpoint]:
        '''endpoints is a list of unique endpoints in this slice.

        Each slice may include a maximum of 1000 endpoints.

        :schema: io.k8s.api.discovery.v1.EndpointSlice#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(typing.List[Endpoint], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        :schema: io.k8s.api.discovery.v1.EndpointSlice#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[EndpointPort]]:
        '''ports specifies the list of network ports exposed by each endpoint in this slice.

        Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.

        :schema: io.k8s.api.discovery.v1.EndpointSlice#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[EndpointPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointSliceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEndpoints(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeEndpoints",
):
    '''Endpoints is a collection of endpoints that implement the actual service. Example:.

    Name: "mysvc",
    Subsets: [
    {
    Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
    },
    {
    Addresses: [{"ip": "10.10.3.3"}],
    Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
    },
    ]

    :schema: io.k8s.api.core.v1.Endpoints
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subsets: typing.Optional[typing.Sequence[typing.Union[EndpointSubset, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.Endpoints" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param subsets: The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5ec2a4597be7ca66600b81552a4d30604b65d6271dae2d0b74ed0eedf1eb6fb)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointsProps(metadata=metadata, subsets=subsets)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subsets: typing.Optional[typing.Sequence[typing.Union[EndpointSubset, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.Endpoints".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param subsets: The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
        '''
        props = KubeEndpointsProps(metadata=metadata, subsets=subsets)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.Endpoints".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeEndpointsList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeEndpointsList",
):
    '''EndpointsList is a list of endpoints.

    :schema: io.k8s.api.core.v1.EndpointsList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointsProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.core.v1.EndpointsList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: List of endpoints.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e22ddd663847137ba678352931d6bb5b3f5b6ece0de046bb9c2cc0fa9f0bc885)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEndpointsListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointsProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.core.v1.EndpointsList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: List of endpoints.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        '''
        props = KubeEndpointsListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.core.v1.EndpointsList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeEndpointsListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEndpointsListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeEndpointsProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EndpointsList is a list of endpoints.

        :param items: List of endpoints.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.core.v1.EndpointsList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1994de77666497f63b03de0d4ea64b9b3c26606f0fafce59446c57c3b914c5ea)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEndpointsProps"]:
        '''List of endpoints.

        :schema: io.k8s.api.core.v1.EndpointsList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEndpointsProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

        :schema: io.k8s.api.core.v1.EndpointsList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointsListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeEndpointsProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "subsets": "subsets"},
)
class KubeEndpointsProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        subsets: typing.Optional[typing.Sequence[typing.Union[EndpointSubset, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Endpoints is a collection of endpoints that implement the actual service. Example:.

        Name: "mysvc",
        Subsets: [
        {
        Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        },
        {
        Addresses: [{"ip": "10.10.3.3"}],
        Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
        },
        ]

        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param subsets: The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.

        :schema: io.k8s.api.core.v1.Endpoints
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4079dc7c3dd1a2eb59dec619aa1a81998c86be1ff6104eb58bce08c2286d29a6)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument subsets", value=subsets, expected_type=type_hints["subsets"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if subsets is not None:
            self._values["subsets"] = subsets

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.core.v1.Endpoints#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def subsets(self) -> typing.Optional[typing.List[EndpointSubset]]:
        '''The set of all endpoints is the union of all subsets.

        Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.

        :schema: io.k8s.api.core.v1.Endpoints#subsets
        '''
        result = self._values.get("subsets")
        return typing.cast(typing.Optional[typing.List[EndpointSubset]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEvent(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeEvent",
):
    '''Event is a report of an event somewhere in the cluster.

    It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.

    :schema: io.k8s.api.events.v1.Event
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        event_time: datetime.datetime,
        action: typing.Optional[builtins.str] = None,
        deprecated_count: typing.Optional[jsii.Number] = None,
        deprecated_first_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_last_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_source: typing.Optional[typing.Union[EventSource, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        note: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        regarding: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        related: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        reporting_controller: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[typing.Union[EventSeries, typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Defines a "io.k8s.api.events.v1.Event" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param event_time: eventTime is the time when this Event was first observed. It is required.
        :param action: action is what action was taken/failed regarding to the regarding object. It is machine-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param deprecated_count: deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_first_timestamp: deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_last_timestamp: deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_source: deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param note: note is a human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param reason: reason is why the action was taken. It is human-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param regarding: regarding contains the object this Event is about. In most cases it's an Object reporting controller implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param related: related is the optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param reporting_controller: reportingController is the name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``. This field cannot be empty for new Events.
        :param reporting_instance: reportingInstance is the ID of the controller instance, e.g. ``kubelet-xyzf``. This field cannot be empty for new Events and it can have at most 128 characters.
        :param series: series is data about the Event series this event represents or nil if it's a singleton Event.
        :param type: type is the type of this event (Normal, Warning), new types could be added in the future. It is machine-readable. This field cannot be empty for new Events.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c3be8e41346388d9aff43a93333f4d14a874f929c9e042062675876d3eb4015)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEventProps(
            event_time=event_time,
            action=action,
            deprecated_count=deprecated_count,
            deprecated_first_timestamp=deprecated_first_timestamp,
            deprecated_last_timestamp=deprecated_last_timestamp,
            deprecated_source=deprecated_source,
            metadata=metadata,
            note=note,
            reason=reason,
            regarding=regarding,
            related=related,
            reporting_controller=reporting_controller,
            reporting_instance=reporting_instance,
            series=series,
            type=type,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        event_time: datetime.datetime,
        action: typing.Optional[builtins.str] = None,
        deprecated_count: typing.Optional[jsii.Number] = None,
        deprecated_first_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_last_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_source: typing.Optional[typing.Union[EventSource, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        note: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        regarding: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        related: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        reporting_controller: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[typing.Union[EventSeries, typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.events.v1.Event".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param event_time: eventTime is the time when this Event was first observed. It is required.
        :param action: action is what action was taken/failed regarding to the regarding object. It is machine-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param deprecated_count: deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_first_timestamp: deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_last_timestamp: deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_source: deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param note: note is a human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param reason: reason is why the action was taken. It is human-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param regarding: regarding contains the object this Event is about. In most cases it's an Object reporting controller implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param related: related is the optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param reporting_controller: reportingController is the name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``. This field cannot be empty for new Events.
        :param reporting_instance: reportingInstance is the ID of the controller instance, e.g. ``kubelet-xyzf``. This field cannot be empty for new Events and it can have at most 128 characters.
        :param series: series is data about the Event series this event represents or nil if it's a singleton Event.
        :param type: type is the type of this event (Normal, Warning), new types could be added in the future. It is machine-readable. This field cannot be empty for new Events.
        '''
        props = KubeEventProps(
            event_time=event_time,
            action=action,
            deprecated_count=deprecated_count,
            deprecated_first_timestamp=deprecated_first_timestamp,
            deprecated_last_timestamp=deprecated_last_timestamp,
            deprecated_source=deprecated_source,
            metadata=metadata,
            note=note,
            reason=reason,
            regarding=regarding,
            related=related,
            reporting_controller=reporting_controller,
            reporting_instance=reporting_instance,
            series=series,
            type=type,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.events.v1.Event".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeEventList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeEventList",
):
    '''EventList is a list of Event objects.

    :schema: io.k8s.api.events.v1.EventList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeEventProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.events.v1.EventList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is a list of schema objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ca1d7d1c9a0331cb291b2131b12b6c8321ae44eec4c40dc3f4fd00df39373d5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEventListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeEventProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.events.v1.EventList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is a list of schema objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeEventListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.events.v1.EventList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeEventListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEventListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeEventProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''EventList is a list of Event objects.

        :param items: items is a list of schema objects.
        :param metadata: Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.events.v1.EventList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7e859d5c805bc52561b61d4bba672b50931ca1c3a04f939c51092824da3ea1d)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEventProps"]:
        '''items is a list of schema objects.

        :schema: io.k8s.api.events.v1.EventList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEventProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.events.v1.EventList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEventListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeEventProps",
    jsii_struct_bases=[],
    name_mapping={
        "event_time": "eventTime",
        "action": "action",
        "deprecated_count": "deprecatedCount",
        "deprecated_first_timestamp": "deprecatedFirstTimestamp",
        "deprecated_last_timestamp": "deprecatedLastTimestamp",
        "deprecated_source": "deprecatedSource",
        "metadata": "metadata",
        "note": "note",
        "reason": "reason",
        "regarding": "regarding",
        "related": "related",
        "reporting_controller": "reportingController",
        "reporting_instance": "reportingInstance",
        "series": "series",
        "type": "type",
    },
)
class KubeEventProps:
    def __init__(
        self,
        *,
        event_time: datetime.datetime,
        action: typing.Optional[builtins.str] = None,
        deprecated_count: typing.Optional[jsii.Number] = None,
        deprecated_first_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_last_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_source: typing.Optional[typing.Union[EventSource, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        note: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        regarding: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        related: typing.Optional[typing.Union["ObjectReference", typing.Dict[builtins.str, typing.Any]]] = None,
        reporting_controller: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[typing.Union[EventSeries, typing.Dict[builtins.str, typing.Any]]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Event is a report of an event somewhere in the cluster.

        It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.

        :param event_time: eventTime is the time when this Event was first observed. It is required.
        :param action: action is what action was taken/failed regarding to the regarding object. It is machine-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param deprecated_count: deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_first_timestamp: deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_last_timestamp: deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_source: deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.
        :param metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param note: note is a human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param reason: reason is why the action was taken. It is human-readable. This field cannot be empty for new Events and it can have at most 128 characters.
        :param regarding: regarding contains the object this Event is about. In most cases it's an Object reporting controller implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param related: related is the optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param reporting_controller: reportingController is the name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``. This field cannot be empty for new Events.
        :param reporting_instance: reportingInstance is the ID of the controller instance, e.g. ``kubelet-xyzf``. This field cannot be empty for new Events and it can have at most 128 characters.
        :param series: series is data about the Event series this event represents or nil if it's a singleton Event.
        :param type: type is the type of this event (Normal, Warning), new types could be added in the future. It is machine-readable. This field cannot be empty for new Events.

        :schema: io.k8s.api.events.v1.Event
        '''
        if isinstance(deprecated_source, dict):
            deprecated_source = EventSource(**deprecated_source)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(regarding, dict):
            regarding = ObjectReference(**regarding)
        if isinstance(related, dict):
            related = ObjectReference(**related)
        if isinstance(series, dict):
            series = EventSeries(**series)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__008ea5213a31383a8af53fabdf38639c8e4208e4bc7f9e29639dd515edb1997b)
            check_type(argname="argument event_time", value=event_time, expected_type=type_hints["event_time"])
            check_type(argname="argument action", value=action, expected_type=type_hints["action"])
            check_type(argname="argument deprecated_count", value=deprecated_count, expected_type=type_hints["deprecated_count"])
            check_type(argname="argument deprecated_first_timestamp", value=deprecated_first_timestamp, expected_type=type_hints["deprecated_first_timestamp"])
            check_type(argname="argument deprecated_last_timestamp", value=deprecated_last_timestamp, expected_type=type_hints["deprecated_last_timestamp"])
            check_type(argname="argument deprecated_source", value=deprecated_source, expected_type=type_hints["deprecated_source"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument note", value=note, expected_type=type_hints["note"])
            check_type(argname="argument reason", value=reason, expected_type=type_hints["reason"])
            check_type(argname="argument regarding", value=regarding, expected_type=type_hints["regarding"])
            check_type(argname="argument related", value=related, expected_type=type_hints["related"])
            check_type(argname="argument reporting_controller", value=reporting_controller, expected_type=type_hints["reporting_controller"])
            check_type(argname="argument reporting_instance", value=reporting_instance, expected_type=type_hints["reporting_instance"])
            check_type(argname="argument series", value=series, expected_type=type_hints["series"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "event_time": event_time,
        }
        if action is not None:
            self._values["action"] = action
        if deprecated_count is not None:
            self._values["deprecated_count"] = deprecated_count
        if deprecated_first_timestamp is not None:
            self._values["deprecated_first_timestamp"] = deprecated_first_timestamp
        if deprecated_last_timestamp is not None:
            self._values["deprecated_last_timestamp"] = deprecated_last_timestamp
        if deprecated_source is not None:
            self._values["deprecated_source"] = deprecated_source
        if metadata is not None:
            self._values["metadata"] = metadata
        if note is not None:
            self._values["note"] = note
        if reason is not None:
            self._values["reason"] = reason
        if regarding is not None:
            self._values["regarding"] = regarding
        if related is not None:
            self._values["related"] = related
        if reporting_controller is not None:
            self._values["reporting_controller"] = reporting_controller
        if reporting_instance is not None:
            self._values["reporting_instance"] = reporting_instance
        if series is not None:
            self._values["series"] = series
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def event_time(self) -> datetime.datetime:
        '''eventTime is the time when this Event was first observed.

        It is required.

        :schema: io.k8s.api.events.v1.Event#eventTime
        '''
        result = self._values.get("event_time")
        assert result is not None, "Required property 'event_time' is missing"
        return typing.cast(datetime.datetime, result)

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        '''action is what action was taken/failed regarding to the regarding object.

        It is machine-readable. This field cannot be empty for new Events and it can have at most 128 characters.

        :schema: io.k8s.api.events.v1.Event#action
        '''
        result = self._values.get("action")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def deprecated_count(self) -> typing.Optional[jsii.Number]:
        '''deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.

        :schema: io.k8s.api.events.v1.Event#deprecatedCount
        '''
        result = self._values.get("deprecated_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def deprecated_first_timestamp(self) -> typing.Optional[datetime.datetime]:
        '''deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.

        :schema: io.k8s.api.events.v1.Event#deprecatedFirstTimestamp
        '''
        result = self._values.get("deprecated_first_timestamp")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def deprecated_last_timestamp(self) -> typing.Optional[datetime.datetime]:
        '''deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.

        :schema: io.k8s.api.events.v1.Event#deprecatedLastTimestamp
        '''
        result = self._values.get("deprecated_last_timestamp")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def deprecated_source(self) -> typing.Optional[EventSource]:
        '''deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.

        :schema: io.k8s.api.events.v1.Event#deprecatedSource
        '''
        result = self._values.get("deprecated_source")
        return typing.cast(typing.Optional[EventSource], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.events.v1.Event#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def note(self) -> typing.Optional[builtins.str]:
        '''note is a human-readable description of the status of this operation.

        Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.

        :schema: io.k8s.api.events.v1.Event#note
        '''
        result = self._values.get("note")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def reason(self) -> typing.Optional[builtins.str]:
        '''reason is why the action was taken.

        It is human-readable. This field cannot be empty for new Events and it can have at most 128 characters.

        :schema: io.k8s.api.events.v1.Event#reason
        '''
        result = self._values.get("reason")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def regarding(self) -> typing.Optional["ObjectReference"]:
        '''regarding contains the object this Event is about.

        In most cases it's an Object reporting controller implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.

        :schema: io.k8s.api.events.v1.Event#regarding
        '''
        result = self._values.get("regarding")
        return typing.cast(typing.Optional["ObjectReference"], result)

    @builtins.property
    def related(self) -> typing.Optional["ObjectReference"]:
        '''related is the optional secondary object for more complex actions.

        E.g. when regarding object triggers a creation or deletion of related object.

        :schema: io.k8s.api.events.v1.Event#related
        '''
        result = self._values.get("related")
        return typing.cast(typing.Optional["ObjectReference"], result)

    @builtins.property
    def reporting_controller(self) -> typing.Optional[builtins.str]:
        '''reportingController is the name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``. This field cannot be empty for new Events.

        :schema: io.k8s.api.events.v1.Event#reportingController
        '''
        result = self._values.get("reporting_controller")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def reporting_instance(self) -> typing.Optional[builtins.str]:
        '''reportingInstance is the ID of the controller instance, e.g. ``kubelet-xyzf``. This field cannot be empty for new Events and it can have at most 128 characters.

        :schema: io.k8s.api.events.v1.Event#reportingInstance
        '''
        result = self._values.get("reporting_instance")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def series(self) -> typing.Optional[EventSeries]:
        '''series is data about the Event series this event represents or nil if it's a singleton Event.

        :schema: io.k8s.api.events.v1.Event#series
        '''
        result = self._values.get("series")
        return typing.cast(typing.Optional[EventSeries], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''type is the type of this event (Normal, Warning), new types could be added in the future.

        It is machine-readable. This field cannot be empty for new Events.

        :schema: io.k8s.api.events.v1.Event#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEventProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEviction(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeEviction",
):
    '''Eviction evicts a pod from its node subject to certain policies and safety constraints.

    This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods//evictions.

    :schema: io.k8s.api.policy.v1.Eviction
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        delete_options: typing.Optional[typing.Union[DeleteOptions, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.policy.v1.Eviction" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param delete_options: DeleteOptions may be provided.
        :param metadata: ObjectMeta describes the pod that is being evicted.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__197cf7eed59392f463f7120a9cf3a8c485705f64a7faae50f4266267716c112e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeEvictionProps(delete_options=delete_options, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        delete_options: typing.Optional[typing.Union[DeleteOptions, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.policy.v1.Eviction".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param delete_options: DeleteOptions may be provided.
        :param metadata: ObjectMeta describes the pod that is being evicted.
        '''
        props = KubeEvictionProps(delete_options=delete_options, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.policy.v1.Eviction".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeEvictionProps",
    jsii_struct_bases=[],
    name_mapping={"delete_options": "deleteOptions", "metadata": "metadata"},
)
class KubeEvictionProps:
    def __init__(
        self,
        *,
        delete_options: typing.Optional[typing.Union[DeleteOptions, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Eviction evicts a pod from its node subject to certain policies and safety constraints.

        This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods//evictions.

        :param delete_options: DeleteOptions may be provided.
        :param metadata: ObjectMeta describes the pod that is being evicted.

        :schema: io.k8s.api.policy.v1.Eviction
        '''
        if isinstance(delete_options, dict):
            delete_options = DeleteOptions(**delete_options)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bab792da3de448c0e9153291d5f78c394079fd11067e4c87db4f3e90c7657059)
            check_type(argname="argument delete_options", value=delete_options, expected_type=type_hints["delete_options"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if delete_options is not None:
            self._values["delete_options"] = delete_options
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def delete_options(self) -> typing.Optional[DeleteOptions]:
        '''DeleteOptions may be provided.

        :schema: io.k8s.api.policy.v1.Eviction#deleteOptions
        '''
        result = self._values.get("delete_options")
        return typing.cast(typing.Optional[DeleteOptions], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''ObjectMeta describes the pod that is being evicted.

        :schema: io.k8s.api.policy.v1.Eviction#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEvictionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeFlowSchemaListV1Beta2(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeFlowSchemaListV1Beta2",
):
    '''FlowSchemaList is a list of FlowSchema objects.

    :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeFlowSchemaV1Beta2Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.flowcontrol.v1beta2.FlowSchemaList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: ``items`` is a list of FlowSchemas.
        :param metadata: ``metadata`` is the standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2189ac00995ce3834b2c1b42a4e5ad1150c7b8f6beca41d495801f7e6b62bbbf)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeFlowSchemaListV1Beta2Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeFlowSchemaV1Beta2Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta2.FlowSchemaList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: ``items`` is a list of FlowSchemas.
        :param metadata: ``metadata`` is the standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeFlowSchemaListV1Beta2Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta2.FlowSchemaList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeFlowSchemaListV1Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeFlowSchemaListV1Beta2Props:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeFlowSchemaV1Beta2Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''FlowSchemaList is a list of FlowSchema objects.

        :param items: ``items`` is a list of FlowSchemas.
        :param metadata: ``metadata`` is the standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea8e5c7702746f9841c5bdd3accbdb1b2549a03f68a8c7f487965f506cafa2c7)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeFlowSchemaV1Beta2Props"]:
        '''``items`` is a list of FlowSchemas.

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeFlowSchemaV1Beta2Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''``metadata`` is the standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchemaList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeFlowSchemaListV1Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeFlowSchemaListV1Beta3(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeFlowSchemaListV1Beta3",
):
    '''FlowSchemaList is a list of FlowSchema objects.

    :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeFlowSchemaV1Beta3Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.flowcontrol.v1beta3.FlowSchemaList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: ``items`` is a list of FlowSchemas.
        :param metadata: ``metadata`` is the standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ee98cf59a78041aa79249e67c3ed183bf804a14ca07fcd630f81f2c83f92324)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeFlowSchemaListV1Beta3Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeFlowSchemaV1Beta3Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta3.FlowSchemaList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: ``items`` is a list of FlowSchemas.
        :param metadata: ``metadata`` is the standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        '''
        props = KubeFlowSchemaListV1Beta3Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta3.FlowSchemaList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeFlowSchemaListV1Beta3Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeFlowSchemaListV1Beta3Props:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeFlowSchemaV1Beta3Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''FlowSchemaList is a list of FlowSchema objects.

        :param items: ``items`` is a list of FlowSchemas.
        :param metadata: ``metadata`` is the standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d38f35e7b1322d06179cfd1758519abc4c1c4063ffd7d2ea4742a30776bc369)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeFlowSchemaV1Beta3Props"]:
        '''``items`` is a list of FlowSchemas.

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeFlowSchemaV1Beta3Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''``metadata`` is the standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchemaList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeFlowSchemaListV1Beta3Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeFlowSchemaV1Beta2(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeFlowSchemaV1Beta2",
):
    '''FlowSchema defines the schema of a group of flows.

    Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".

    :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchema
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[FlowSchemaSpecV1Beta2, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.flowcontrol.v1beta2.FlowSchema" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: ``metadata`` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: ``spec`` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ac2549c9a0faddca607f07f6be74d5d97770dd571183669366c447593ce724d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeFlowSchemaV1Beta2Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[FlowSchemaSpecV1Beta2, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta2.FlowSchema".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: ``metadata`` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: ``spec`` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        props = KubeFlowSchemaV1Beta2Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta2.FlowSchema".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeFlowSchemaV1Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeFlowSchemaV1Beta2Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[FlowSchemaSpecV1Beta2, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''FlowSchema defines the schema of a group of flows.

        Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".

        :param metadata: ``metadata`` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: ``spec`` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchema
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = FlowSchemaSpecV1Beta2(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67025687657453a3f2c9946752a3c4c3d4c7b69e01977934b22b3e09c67d0757)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''``metadata`` is the standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchema#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[FlowSchemaSpecV1Beta2]:
        '''``spec`` is the specification of the desired behavior of a FlowSchema.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.flowcontrol.v1beta2.FlowSchema#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[FlowSchemaSpecV1Beta2], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeFlowSchemaV1Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeFlowSchemaV1Beta3(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeFlowSchemaV1Beta3",
):
    '''FlowSchema defines the schema of a group of flows.

    Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".

    :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchema
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[FlowSchemaSpecV1Beta3, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.flowcontrol.v1beta3.FlowSchema" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: ``metadata`` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: ``spec`` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af9c0baaf05d1ffadda89159b79f731994ea0ac6b1b6a50090092fc832322ec7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeFlowSchemaV1Beta3Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[FlowSchemaSpecV1Beta3, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta3.FlowSchema".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: ``metadata`` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: ``spec`` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        '''
        props = KubeFlowSchemaV1Beta3Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta3.FlowSchema".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeFlowSchemaV1Beta3Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeFlowSchemaV1Beta3Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[FlowSchemaSpecV1Beta3, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''FlowSchema defines the schema of a group of flows.

        Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".

        :param metadata: ``metadata`` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: ``spec`` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchema
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = FlowSchemaSpecV1Beta3(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ede91671226b3c6cffa8450a6a8bb35eb35aae02ca4079a2650c57bc65335973)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''``metadata`` is the standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchema#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[FlowSchemaSpecV1Beta3]:
        '''``spec`` is the specification of the desired behavior of a FlowSchema.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :schema: io.k8s.api.flowcontrol.v1beta3.FlowSchema#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[FlowSchemaSpecV1Beta3], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeFlowSchemaV1Beta3Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeHorizontalPodAutoscaler(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeHorizontalPodAutoscaler",
):
    '''configuration of a horizontal pod autoscaler.

    :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[HorizontalPodAutoscalerSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: spec defines the behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__adcf6c815cda4efef16f6e34a535398f2ed3ba8efcbf8727709e9aa2e87c6e37)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeHorizontalPodAutoscalerProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[HorizontalPodAutoscalerSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: spec defines the behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        '''
        props = KubeHorizontalPodAutoscalerProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeHorizontalPodAutoscalerList(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeHorizontalPodAutoscalerList",
):
    '''list of horizontal pod autoscaler objects.

    :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeHorizontalPodAutoscalerProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of horizontal pod autoscaler objects.
        :param metadata: Standard list metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2be8cf985a3184442c69a22af32815855426b77e05ef98722721e279b21092b4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeHorizontalPodAutoscalerListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeHorizontalPodAutoscalerProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of horizontal pod autoscaler objects.
        :param metadata: Standard list metadata.
        '''
        props = KubeHorizontalPodAutoscalerListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeHorizontalPodAutoscalerListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeHorizontalPodAutoscalerListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeHorizontalPodAutoscalerProps", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''list of horizontal pod autoscaler objects.

        :param items: items is the list of horizontal pod autoscaler objects.
        :param metadata: Standard list metadata.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb9d353af990a8f4e3ab4064261a380813fb5a9997b242f7ca8cfd4499930c5d)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeHorizontalPodAutoscalerProps"]:
        '''items is the list of horizontal pod autoscaler objects.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeHorizontalPodAutoscalerProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''Standard list metadata.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeHorizontalPodAutoscalerListV2(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeHorizontalPodAutoscalerListV2",
):
    '''HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.

    :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence[typing.Union["KubeHorizontalPodAutoscalerV2Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: items is the list of horizontal pod autoscaler objects.
        :param metadata: metadata is the standard list metadata.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd08f3c77f590bcfeea3e2191a4497861140719915307d5b2e4c52173d5d7e03)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeHorizontalPodAutoscalerListV2Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence[typing.Union["KubeHorizontalPodAutoscalerV2Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: items is the list of horizontal pod autoscaler objects.
        :param metadata: metadata is the standard list metadata.
        '''
        props = KubeHorizontalPodAutoscalerListV2Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeHorizontalPodAutoscalerListV2Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeHorizontalPodAutoscalerListV2Props:
    def __init__(
        self,
        *,
        items: typing.Sequence[typing.Union["KubeHorizontalPodAutoscalerV2Props", typing.Dict[builtins.str, typing.Any]]],
        metadata: typing.Optional[typing.Union["ListMeta", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.

        :param items: items is the list of horizontal pod autoscaler objects.
        :param metadata: metadata is the standard list metadata.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c794d649615d47e6f8f297bc9189562a70702b1ea4784ebaff2f88c8850fcb8)
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeHorizontalPodAutoscalerV2Props"]:
        '''items is the list of horizontal pod autoscaler objects.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeHorizontalPodAutoscalerV2Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''metadata is the standard list metadata.

        :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerListV2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeHorizontalPodAutoscalerProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeHorizontalPodAutoscalerProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[HorizontalPodAutoscalerSpec, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''configuration of a horizontal pod autoscaler.

        :param metadata: Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: spec defines the behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = HorizontalPodAutoscalerSpec(**spec)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d44a4d5158c0b158b99516c84c4f91c7a1d7b5c069be8e0a37f965564a12ff68)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument spec", value=spec, expected_type=type_hints["spec"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''Standard object metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[HorizontalPodAutoscalerSpec]:
        '''spec defines the behaviour of autoscaler.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.

        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[HorizontalPodAutoscalerSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeHorizontalPodAutoscalerV2(
    _cdk8s_d3d9af27.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.k8s.KubeHorizontalPodAutoscalerV2",
):
    '''HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

    :schema: io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[HorizontalPodAutoscalerSpecV2, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Defines a "io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9785129549f474dddd82261c0f5fe67d8535f33b2b370ca95da38e3a8e88079)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = KubeHorizontalPodAutoscalerV2Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest")
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional[typing.Union["ObjectMeta", typing.Dict[builtins.str, typing.Any]]] = None,
        spec: typing.Optional[typing.Union[HorizontalPodAutoscalerSpecV2, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> typing.Any:
        '''Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        '''
        props = KubeHorizontalPodAutoscalerV2Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.Any:
        '''Renders the object to Kubernetes JSON.'''
        return typing.cast(typing.Any, jsii.invoke(self, "toJson", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> _cdk8s_d3d9af27.GroupVersionKind:
        '''Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler".'''
        return typing.cast(_cdk8s_d3d9af27.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.k8s.KubeHorizontalPodAutoscalerV2Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeHorizontalPodAutoscalerV2Props:
    def __init__(
        self,
        *,
        metadata: typi