#HEADER
#                    arg/GUI/Logic/argSaveBeforeRunAction.py
#               Automatic Report Generator (ARG) v. 1.0
#
# Copyright 2020 National Technology & Engineering Solutions of Sandia, LLC
# (NTESS). Under the terms of Contract DE-NA0003525 with NTESS, the U.S.
# Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of the copyright holder nor the names of its
#   contributors may be used to endorse or promote products derived from this
#   software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# Questions? Visit gitlab.com/AutomaticReportGenerator/arg
#
#HEADER

from PySide2.QtCore import QSettings
from PySide2.QtWidgets import QAction, QApplication

app = "ARG-GUI"


class argSaveBeforeRunAction(QAction):
    """An action class
    """

    def __init__(self, parent=None):
        super(argSaveBeforeRunAction, self).__init__(parent)
        # scriptDirectory = os.path.dirname(os.path.realpath(__file__))
        # self.setIcon(QIcon("{}/{}".format(scriptDirectory, "../Graphics/clean.png")))
        self.setText("Save before run")
        self.setToolTip("Automatically save the parameter file before running ARG")
        self.setCheckable(True)

        self.triggered.connect(self.onTriggered)

    def onTriggered(self):
        print("[{}] 'Save before run' action detected. Enabled : {}".format(app, self.isChecked()))

        # Register the check state as setting
        settings = QApplication.instance().settingsController
        permanentSettings = QSettings(QSettings.IniFormat, QSettings.UserScope, settings.getCompanyName(),
                                      settings.getToolName())

        permanentSettings.setValue(settings.getSaveBeforeRunSettings(), self.isChecked())

        # Run the action request
        QApplication.instance().saveBeforeRunRequested(self.isChecked())
