/**
 * Enum for representing all the days of the week.
 *
 * @stability stable
 */
export declare enum Weekday {
    /**
     * Monday.
     *
     * @stability stable
     */
    MONDAY = "1",
    /**
     * Tuesday.
     *
     * @stability stable
     */
    TUESDAY = "2",
    /**
     * Wednesday.
     *
     * @stability stable
     */
    WEDNESDAY = "3",
    /**
     * Thursday.
     *
     * @stability stable
     */
    THURSDAY = "4",
    /**
     * Friday.
     *
     * @stability stable
     */
    FRIDAY = "5",
    /**
     * Saturday.
     *
     * @stability stable
     */
    SATURDAY = "6",
    /**
     * Sunday.
     *
     * @stability stable
     */
    SUNDAY = "7"
}
/**
 * Properties required for setting up a weekly maintenance time.
 *
 * @stability stable
 */
export interface LustreMaintenanceTimeProps {
    /**
     * The day of the week for maintenance to be performed.
     *
     * @stability stable
     */
    readonly day: Weekday;
    /**
     * The hour of the day (from 0-24) for maintenance to be performed.
     *
     * @stability stable
     */
    readonly hour: number;
    /**
     * The minute of the hour (from 0-59) for maintenance to be performed.
     *
     * @stability stable
     */
    readonly minute: number;
}
/**
 * Class for scheduling a weekly manitenance time.
 *
 * @stability stable
 */
export declare class LustreMaintenanceTime {
    /**
     * The day of the week for maintenance to be performed.
     */
    private readonly day;
    /**
     * The hour of the day (from 00-24) for maintenance to be performed.
     */
    private readonly hour;
    /**
     * The minute of the hour (from 00-59) for maintenance to be performed.
     */
    private readonly minute;
    /**
     * @stability stable
     */
    constructor(props: LustreMaintenanceTimeProps);
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     *
     * @stability stable
     */
    toTimestamp(): string;
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    private getTwoDigitString;
    /**
     * Validation needed for the values of the maintenance time.
     */
    private validate;
}
