"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .consumerrequestcountsindaterangeresponse import (
    ConsumerRequestCountsInDateRangeResponse,
    ConsumerRequestCountsInDateRangeResponseTypedDict,
)
from .httpmetadata import HTTPMetadata, HTTPMetadataTypedDict
from .unexpectederrorresponse import (
    UnexpectedErrorResponse,
    UnexpectedErrorResponseTypedDict,
)
from apideck_accounting_unify.types import BaseModel
from apideck_accounting_unify.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class VaultConsumerRequestCountsAllGlobalsTypedDict(TypedDict):
    app_id: NotRequired[str]
    r"""The ID of your Unify application"""


class VaultConsumerRequestCountsAllGlobals(BaseModel):
    app_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-app-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of your Unify application"""


class VaultConsumerRequestCountsAllRequestTypedDict(TypedDict):
    consumer_id: str
    r"""ID of the consumer to return"""
    start_datetime: str
    r"""Scopes results to requests that happened after datetime"""
    end_datetime: str
    r"""Scopes results to requests that happened before datetime"""
    app_id: NotRequired[str]
    r"""The ID of your Unify application"""


class VaultConsumerRequestCountsAllRequest(BaseModel):
    consumer_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the consumer to return"""

    start_datetime: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""Scopes results to requests that happened after datetime"""

    end_datetime: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""Scopes results to requests that happened before datetime"""

    app_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-apideck-app-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of your Unify application"""


class VaultConsumerRequestCountsAllResponseTypedDict(TypedDict):
    http_meta: HTTPMetadataTypedDict
    consumer_request_counts_in_date_range_response: NotRequired[
        ConsumerRequestCountsInDateRangeResponseTypedDict
    ]
    r"""Consumers Request Counts within Date Range"""
    unexpected_error_response: NotRequired[UnexpectedErrorResponseTypedDict]
    r"""Unexpected error"""


class VaultConsumerRequestCountsAllResponse(BaseModel):
    http_meta: Annotated[Optional[HTTPMetadata], pydantic.Field(exclude=True)] = None

    consumer_request_counts_in_date_range_response: Optional[
        ConsumerRequestCountsInDateRangeResponse
    ] = None
    r"""Consumers Request Counts within Date Range"""

    unexpected_error_response: Optional[UnexpectedErrorResponse] = None
    r"""Unexpected error"""
