"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .consumermetadata import ConsumerMetadata, ConsumerMetadataTypedDict
from .links import Links, LinksTypedDict
from .meta import Meta, MetaTypedDict
from .requestcountallocation import (
    RequestCountAllocation,
    RequestCountAllocationTypedDict,
)
from apideck_accounting_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DataTypedDict(TypedDict):
    consumer_id: NotRequired[str]
    application_id: NotRequired[str]
    metadata: NotRequired[ConsumerMetadataTypedDict]
    r"""The metadata of the consumer. This is used to display the consumer in the sidebar. This is optional, but recommended."""
    aggregated_request_count: NotRequired[float]
    request_counts: NotRequired[RequestCountAllocationTypedDict]
    created: NotRequired[str]
    modified: NotRequired[str]
    request_count_updated: NotRequired[str]
    services: NotRequired[List[str]]


class Data(BaseModel):
    consumer_id: Optional[str] = None

    application_id: Optional[str] = None

    metadata: Optional[ConsumerMetadata] = None
    r"""The metadata of the consumer. This is used to display the consumer in the sidebar. This is optional, but recommended."""

    aggregated_request_count: Optional[float] = None

    request_counts: Optional[RequestCountAllocation] = None

    created: Optional[str] = None

    modified: Optional[str] = None

    request_count_updated: Optional[str] = None

    services: Optional[List[str]] = None


class GetConsumersResponseTypedDict(TypedDict):
    r"""Consumers"""

    status_code: int
    r"""HTTP Response Status Code"""
    status: str
    r"""HTTP Response Status"""
    data: List[DataTypedDict]
    meta: NotRequired[MetaTypedDict]
    r"""Response metadata"""
    links: NotRequired[LinksTypedDict]
    r"""Links to navigate to previous or next pages through the API"""
    raw: NotRequired[Nullable[Dict[str, Any]]]
    r"""Raw response from the integration when raw=true query param is provided"""


class GetConsumersResponse(BaseModel):
    r"""Consumers"""

    status_code: int
    r"""HTTP Response Status Code"""

    status: str
    r"""HTTP Response Status"""

    data: List[Data]

    meta: Optional[Meta] = None
    r"""Response metadata"""

    links: Optional[Links] = None
    r"""Links to navigate to previous or next pages through the API"""

    raw: Annotated[OptionalNullable[Dict[str, Any]], pydantic.Field(alias="_raw")] = (
        UNSET
    )
    r"""Raw response from the integration when raw=true query param is provided"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "links", "_raw"]
        nullable_fields = ["_raw"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
