"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_accounting_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Any, Optional
from typing_extensions import NotRequired, TypedDict


class CustomFieldFinderTypedDict(TypedDict):
    id: NotRequired[str]
    r"""Custom Field ID"""
    name: NotRequired[Nullable[str]]
    r"""Custom Field name to use as a label if provided"""
    description: NotRequired[Nullable[str]]
    r"""More information about the custom field"""
    value: NotRequired[Any]
    r"""Custom Field value"""
    finder: NotRequired[str]
    r"""JSONPath finder for retrieving this value when mapping a response payload from downstream"""


class CustomFieldFinder(BaseModel):
    id: Optional[str] = None
    r"""Custom Field ID"""

    name: OptionalNullable[str] = UNSET
    r"""Custom Field name to use as a label if provided"""

    description: OptionalNullable[str] = UNSET
    r"""More information about the custom field"""

    value: Optional[Any] = None
    r"""Custom Field value"""

    finder: Optional[str] = None
    r"""JSONPath finder for retrieving this value when mapping a response payload from downstream"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "name", "description", "value", "finder"]
        nullable_fields = ["name", "description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
