"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_accounting_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing import Any, Dict, Optional
from typing_extensions import NotRequired, TypedDict


class CredentialsTypedDict(TypedDict):
    refresh_token: NotRequired[Nullable[str]]
    r"""The refresh token can be used to obtain a new access token."""
    access_token: NotRequired[str]
    r"""Access token"""
    issued_at: NotRequired[Nullable[datetime]]
    r"""The datetime at which the token was issued. If omitted the token will be queued for refresh."""
    expires_in: NotRequired[Nullable[int]]
    r"""The number of seconds until the token expires. If omitted the token will be queued for refresh."""


class Credentials(BaseModel):
    refresh_token: OptionalNullable[str] = UNSET
    r"""The refresh token can be used to obtain a new access token."""

    access_token: Optional[str] = None
    r"""Access token"""

    issued_at: OptionalNullable[datetime] = UNSET
    r"""The datetime at which the token was issued. If omitted the token will be queued for refresh."""

    expires_in: OptionalNullable[int] = UNSET
    r"""The number of seconds until the token expires. If omitted the token will be queued for refresh."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["refresh_token", "access_token", "issued_at", "expires_in"]
        nullable_fields = ["refresh_token", "issued_at", "expires_in"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SettingsTypedDict(TypedDict):
    r"""Connection settings. Values will persist to `form_fields` with corresponding id"""


class Settings(BaseModel):
    r"""Connection settings. Values will persist to `form_fields` with corresponding id"""


class ConnectionImportDataTypedDict(TypedDict):
    credentials: NotRequired[CredentialsTypedDict]
    settings: NotRequired[Nullable[SettingsTypedDict]]
    r"""Connection settings. Values will persist to `form_fields` with corresponding id"""
    metadata: NotRequired[Nullable[Dict[str, Any]]]
    r"""Attach your own consumer specific metadata"""


class ConnectionImportData(BaseModel):
    credentials: Optional[Credentials] = None

    settings: OptionalNullable[Settings] = UNSET
    r"""Connection settings. Values will persist to `form_fields` with corresponding id"""

    metadata: OptionalNullable[Dict[str, Any]] = UNSET
    r"""Attach your own consumer specific metadata"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["credentials", "settings", "metadata"]
        nullable_fields = ["settings", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
