"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .linkedinvoiceitem import LinkedInvoiceItem, LinkedInvoiceItemTypedDict
from .linkedledgeraccount import LinkedLedgerAccount, LinkedLedgerAccountTypedDict
from .linkedledgeraccount_input import (
    LinkedLedgerAccountInput,
    LinkedLedgerAccountInputTypedDict,
)
from .linkedtaxrate import LinkedTaxRate, LinkedTaxRateTypedDict
from .linkedtaxrate_input import LinkedTaxRateInput, LinkedTaxRateInputTypedDict
from .linkedtrackingcategory import (
    LinkedTrackingCategory,
    LinkedTrackingCategoryTypedDict,
)
from apideck_accounting_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class BillLineItemType(str, Enum):
    r"""Bill Line Item type"""

    EXPENSE_ITEM = "expense_item"
    EXPENSE_ACCOUNT = "expense_account"
    OTHER = "other"


class BillLineItemTypedDict(TypedDict):
    id: NotRequired[str]
    r"""A unique identifier for an object."""
    row_id: NotRequired[str]
    r"""Row ID"""
    code: NotRequired[Nullable[str]]
    r"""User defined item code"""
    line_number: NotRequired[Nullable[int]]
    r"""Line number in the invoice"""
    description: NotRequired[Nullable[str]]
    r"""User defined description"""
    type: NotRequired[Nullable[BillLineItemType]]
    r"""Bill Line Item type"""
    tax_amount: NotRequired[Nullable[float]]
    r"""Tax amount"""
    total_amount: NotRequired[Nullable[float]]
    r"""Total amount of the line item"""
    quantity: NotRequired[Nullable[float]]
    unit_price: NotRequired[Nullable[float]]
    unit_of_measure: NotRequired[Nullable[str]]
    r"""Description of the unit type the item is sold as, ie: kg, hour."""
    discount_percentage: NotRequired[Nullable[float]]
    r"""Discount percentage applied to the line item when supported downstream."""
    discount_amount: NotRequired[Nullable[float]]
    r"""Discount amount applied to the line item when supported downstream."""
    location_id: NotRequired[Nullable[str]]
    r"""Location id"""
    department_id: NotRequired[Nullable[str]]
    r"""Department id"""
    item: NotRequired[LinkedInvoiceItemTypedDict]
    tax_rate: NotRequired[LinkedTaxRateTypedDict]
    ledger_account: NotRequired[Nullable[LinkedLedgerAccountTypedDict]]
    tracking_categories: NotRequired[
        Nullable[List[Nullable[LinkedTrackingCategoryTypedDict]]]
    ]
    r"""A list of linked tracking categories."""
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""


class BillLineItem(BaseModel):
    id: Optional[str] = None
    r"""A unique identifier for an object."""

    row_id: Optional[str] = None
    r"""Row ID"""

    code: OptionalNullable[str] = UNSET
    r"""User defined item code"""

    line_number: OptionalNullable[int] = UNSET
    r"""Line number in the invoice"""

    description: OptionalNullable[str] = UNSET
    r"""User defined description"""

    type: OptionalNullable[BillLineItemType] = UNSET
    r"""Bill Line Item type"""

    tax_amount: OptionalNullable[float] = UNSET
    r"""Tax amount"""

    total_amount: OptionalNullable[float] = UNSET
    r"""Total amount of the line item"""

    quantity: OptionalNullable[float] = UNSET

    unit_price: OptionalNullable[float] = UNSET

    unit_of_measure: OptionalNullable[str] = UNSET
    r"""Description of the unit type the item is sold as, ie: kg, hour."""

    discount_percentage: OptionalNullable[float] = UNSET
    r"""Discount percentage applied to the line item when supported downstream."""

    discount_amount: OptionalNullable[float] = UNSET
    r"""Discount amount applied to the line item when supported downstream."""

    location_id: OptionalNullable[str] = UNSET
    r"""Location id"""

    department_id: OptionalNullable[str] = UNSET
    r"""Department id"""

    item: Optional[LinkedInvoiceItem] = None

    tax_rate: Optional[LinkedTaxRate] = None

    ledger_account: OptionalNullable[LinkedLedgerAccount] = UNSET

    tracking_categories: OptionalNullable[List[Nullable[LinkedTrackingCategory]]] = (
        UNSET
    )
    r"""A list of linked tracking categories."""

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "row_id",
            "code",
            "line_number",
            "description",
            "type",
            "tax_amount",
            "total_amount",
            "quantity",
            "unit_price",
            "unit_of_measure",
            "discount_percentage",
            "discount_amount",
            "location_id",
            "department_id",
            "item",
            "tax_rate",
            "ledger_account",
            "tracking_categories",
            "row_version",
            "updated_by",
            "created_by",
            "created_at",
            "updated_at",
        ]
        nullable_fields = [
            "code",
            "line_number",
            "description",
            "type",
            "tax_amount",
            "total_amount",
            "quantity",
            "unit_price",
            "unit_of_measure",
            "discount_percentage",
            "discount_amount",
            "location_id",
            "department_id",
            "ledger_account",
            "tracking_categories",
            "row_version",
            "updated_by",
            "created_by",
            "created_at",
            "updated_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BillLineItemInputTypedDict(TypedDict):
    row_id: NotRequired[str]
    r"""Row ID"""
    code: NotRequired[Nullable[str]]
    r"""User defined item code"""
    line_number: NotRequired[Nullable[int]]
    r"""Line number in the invoice"""
    description: NotRequired[Nullable[str]]
    r"""User defined description"""
    type: NotRequired[Nullable[BillLineItemType]]
    r"""Bill Line Item type"""
    tax_amount: NotRequired[Nullable[float]]
    r"""Tax amount"""
    total_amount: NotRequired[Nullable[float]]
    r"""Total amount of the line item"""
    quantity: NotRequired[Nullable[float]]
    unit_price: NotRequired[Nullable[float]]
    unit_of_measure: NotRequired[Nullable[str]]
    r"""Description of the unit type the item is sold as, ie: kg, hour."""
    discount_percentage: NotRequired[Nullable[float]]
    r"""Discount percentage applied to the line item when supported downstream."""
    discount_amount: NotRequired[Nullable[float]]
    r"""Discount amount applied to the line item when supported downstream."""
    location_id: NotRequired[Nullable[str]]
    r"""Location id"""
    department_id: NotRequired[Nullable[str]]
    r"""Department id"""
    item: NotRequired[LinkedInvoiceItemTypedDict]
    tax_rate: NotRequired[LinkedTaxRateInputTypedDict]
    ledger_account: NotRequired[Nullable[LinkedLedgerAccountInputTypedDict]]
    tracking_categories: NotRequired[
        Nullable[List[Nullable[LinkedTrackingCategoryTypedDict]]]
    ]
    r"""A list of linked tracking categories."""
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""


class BillLineItemInput(BaseModel):
    row_id: Optional[str] = None
    r"""Row ID"""

    code: OptionalNullable[str] = UNSET
    r"""User defined item code"""

    line_number: OptionalNullable[int] = UNSET
    r"""Line number in the invoice"""

    description: OptionalNullable[str] = UNSET
    r"""User defined description"""

    type: OptionalNullable[BillLineItemType] = UNSET
    r"""Bill Line Item type"""

    tax_amount: OptionalNullable[float] = UNSET
    r"""Tax amount"""

    total_amount: OptionalNullable[float] = UNSET
    r"""Total amount of the line item"""

    quantity: OptionalNullable[float] = UNSET

    unit_price: OptionalNullable[float] = UNSET

    unit_of_measure: OptionalNullable[str] = UNSET
    r"""Description of the unit type the item is sold as, ie: kg, hour."""

    discount_percentage: OptionalNullable[float] = UNSET
    r"""Discount percentage applied to the line item when supported downstream."""

    discount_amount: OptionalNullable[float] = UNSET
    r"""Discount amount applied to the line item when supported downstream."""

    location_id: OptionalNullable[str] = UNSET
    r"""Location id"""

    department_id: OptionalNullable[str] = UNSET
    r"""Department id"""

    item: Optional[LinkedInvoiceItem] = None

    tax_rate: Optional[LinkedTaxRateInput] = None

    ledger_account: OptionalNullable[LinkedLedgerAccountInput] = UNSET

    tracking_categories: OptionalNullable[List[Nullable[LinkedTrackingCategory]]] = (
        UNSET
    )
    r"""A list of linked tracking categories."""

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "row_id",
            "code",
            "line_number",
            "description",
            "type",
            "tax_amount",
            "total_amount",
            "quantity",
            "unit_price",
            "unit_of_measure",
            "discount_percentage",
            "discount_amount",
            "location_id",
            "department_id",
            "item",
            "tax_rate",
            "ledger_account",
            "tracking_categories",
            "row_version",
        ]
        nullable_fields = [
            "code",
            "line_number",
            "description",
            "type",
            "tax_amount",
            "total_amount",
            "quantity",
            "unit_price",
            "unit_of_measure",
            "discount_percentage",
            "discount_amount",
            "location_id",
            "department_id",
            "ledger_account",
            "tracking_categories",
            "row_version",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
