"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_accounting_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class AllocationType(str, Enum):
    r"""Type of entity this payment should be attributed to."""

    INVOICE = "invoice"
    ORDER = "order"
    EXPENSE = "expense"
    CREDIT_MEMO = "credit_memo"
    OVER_PAYMENT = "over_payment"
    PRE_PAYMENT = "pre_payment"
    JOURNAL_ENTRY = "journal_entry"
    OTHER = "other"
    BILL = "bill"


class AllocationTypedDict(TypedDict):
    id: NotRequired[str]
    r"""Unique identifier of entity this payment should be attributed to."""
    type: NotRequired[AllocationType]
    r"""Type of entity this payment should be attributed to."""
    code: NotRequired[str]
    amount: NotRequired[Nullable[float]]
    r"""Amount of payment that should be attributed to this allocation. If null, the total_amount will be used."""
    allocation_id: NotRequired[str]
    r"""Unique identifier of the allocation"""


class Allocation(BaseModel):
    id: Optional[str] = None
    r"""Unique identifier of entity this payment should be attributed to."""

    type: Optional[AllocationType] = None
    r"""Type of entity this payment should be attributed to."""

    code: Optional[str] = None

    amount: OptionalNullable[float] = UNSET
    r"""Amount of payment that should be attributed to this allocation. If null, the total_amount will be used."""

    allocation_id: Optional[str] = None
    r"""Unique identifier of the allocation"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type", "code", "amount", "allocation_id"]
        nullable_fields = ["amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AllocationInputTypedDict(TypedDict):
    id: NotRequired[str]
    r"""Unique identifier of entity this payment should be attributed to."""
    type: NotRequired[AllocationType]
    r"""Type of entity this payment should be attributed to."""
    amount: NotRequired[Nullable[float]]
    r"""Amount of payment that should be attributed to this allocation. If null, the total_amount will be used."""
    allocation_id: NotRequired[str]
    r"""Unique identifier of the allocation"""


class AllocationInput(BaseModel):
    id: Optional[str] = None
    r"""Unique identifier of entity this payment should be attributed to."""

    type: Optional[AllocationType] = None
    r"""Type of entity this payment should be attributed to."""

    amount: OptionalNullable[float] = UNSET
    r"""Amount of payment that should be attributed to this allocation. If null, the total_amount will be used."""

    allocation_id: Optional[str] = None
    r"""Unique identifier of the allocation"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type", "amount", "allocation_id"]
        nullable_fields = ["amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
