"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from apideck_accounting_unify.ageddebtors_sdk import AgedDebtorsSDK
from apideck_accounting_unify.attachments import Attachments
from apideck_accounting_unify.balancesheet_sdk import BalanceSheetSDK
from apideck_accounting_unify.billpayments import BillPayments
from apideck_accounting_unify.bills import Bills
from apideck_accounting_unify.companyinfo_sdk import CompanyInfoSDK
from apideck_accounting_unify.creditnotes import CreditNotes
from apideck_accounting_unify.customers import Customers
from apideck_accounting_unify.departments import Departments
from apideck_accounting_unify.expenses import Expenses
from apideck_accounting_unify.invoiceitems import InvoiceItems
from apideck_accounting_unify.invoices import Invoices
from apideck_accounting_unify.journalentries import JournalEntries
from apideck_accounting_unify.ledgeraccounts import LedgerAccounts
from apideck_accounting_unify.locations import Locations
from apideck_accounting_unify.payments import Payments
from apideck_accounting_unify.profitandloss_sdk import ProfitAndLossSDK
from apideck_accounting_unify.purchaseorders import PurchaseOrders
from apideck_accounting_unify.subsidiaries import Subsidiaries
from apideck_accounting_unify.suppliers import Suppliers
from apideck_accounting_unify.taxrates import TaxRates
from apideck_accounting_unify.trackingcategories import TrackingCategories


class Accounting(BaseSDK):
    tax_rates: TaxRates
    bills: Bills
    invoices: Invoices
    ledger_accounts: LedgerAccounts
    invoice_items: InvoiceItems
    credit_notes: CreditNotes
    customers: Customers
    suppliers: Suppliers
    payments: Payments
    company_info: CompanyInfoSDK
    balance_sheet: BalanceSheetSDK
    profit_and_loss: ProfitAndLossSDK
    journal_entries: JournalEntries
    purchase_orders: PurchaseOrders
    subsidiaries: Subsidiaries
    locations: Locations
    departments: Departments
    attachments: Attachments
    tracking_categories: TrackingCategories
    bill_payments: BillPayments
    expenses: Expenses
    aged_debtors: AgedDebtorsSDK

    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.tax_rates = TaxRates(self.sdk_configuration)
        self.bills = Bills(self.sdk_configuration)
        self.invoices = Invoices(self.sdk_configuration)
        self.ledger_accounts = LedgerAccounts(self.sdk_configuration)
        self.invoice_items = InvoiceItems(self.sdk_configuration)
        self.credit_notes = CreditNotes(self.sdk_configuration)
        self.customers = Customers(self.sdk_configuration)
        self.suppliers = Suppliers(self.sdk_configuration)
        self.payments = Payments(self.sdk_configuration)
        self.company_info = CompanyInfoSDK(self.sdk_configuration)
        self.balance_sheet = BalanceSheetSDK(self.sdk_configuration)
        self.profit_and_loss = ProfitAndLossSDK(self.sdk_configuration)
        self.journal_entries = JournalEntries(self.sdk_configuration)
        self.purchase_orders = PurchaseOrders(self.sdk_configuration)
        self.subsidiaries = Subsidiaries(self.sdk_configuration)
        self.locations = Locations(self.sdk_configuration)
        self.departments = Departments(self.sdk_configuration)
        self.attachments = Attachments(self.sdk_configuration)
        self.tracking_categories = TrackingCategories(self.sdk_configuration)
        self.bill_payments = BillPayments(self.sdk_configuration)
        self.expenses = Expenses(self.sdk_configuration)
        self.aged_debtors = AgedDebtorsSDK(self.sdk_configuration)
